<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::LsDif
Module liste de diffusion.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_LsDif
 * @class AlkHtmlPopupLsDifSelectUserForm
 * Classe permettant d'afficher un formulaire permettant de sélectionner un agent n'appartenant pas à l'annuaire
 */
class AlkHtmlPopupLsDifSelectUserForm extends AlkHtmlForm
{
  /** controle de saisie */
  protected $ctrlMail; 
  protected $ctrlNom;
  protected $ctrlUserList;
  protected $list;
  
  
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formAgent"); 
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");    
  } 
   
   /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit)
  {
    $this->list = AlkRequest::getToken("list", "-1");
    
    if($this->list==0){
       $this->ctrlMail = new AlkFormData($this, "ctrlMail", "", ALK_SQL_TEXT);
       $this->ctrlNom  = new AlkFormData($this,  "ctrlNom", "", ALK_SQL_TEXT);
    }else if($this->list==1){
      $this->ctrlUserList = new AlkFormData($this, "ctrlUserList", "", ALK_SQL_TEXT);
    }
 
  }
  
  /**
   * Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  {
    $list = AlkRequest::getToken("list", "-1");
    if($list==0)
      $strHtml = "Ajouter un destinataire à la liste";
    else if($list==1)
       $strHtml = "Ajouter une liste de destinataires";
    return $strHtml;
  }
  
  /**
   * Traitement du formulaire
   */
  public function doSql() 
  { 
    // vérification ajax de l'existance d'un abonné, création si n'existe pas
    // retourne l'identifiant de l'abonné
    $strMails = AlkRequest::_POST("m", "");
    $iClose   = AlkRequest::_POSTint("c", "0");
    
    $oQueryAnnuAction = AlkFactory::getQueryAction(ALK_ATYPE_ID_ANNU);
    $tabRes = $oQueryAnnuAction->addAbonneToListe(-1, $strMails);
    $tabRes = array("tab" => $tabRes, "close" => $iClose);
    
    echo json_encode($tabRes);
    return "";  
  }  
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);
    // element de type select qui doit recevoir le texte et la valeur de la selection
    $dest = AlkRequest::getToken("dest", "");

    $strobs = " obS = null;";
    if( $dest != "" ) { 
      $strobs = " var oOpener = GetWindowOpener();" .
        " obS = oOpener.".stripslashes($dest).";";   
    } 
    $this->addJs($strobs);
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_LIB."alkhtmlpopuplsdifselectuserform.js");   
   
    $iSizeTxt = 38;
    $iWidthMemo = 36;
    $iHeightMemo = 20;
 
    $block = $this->addBlock("block", "", "", 80, 300);
    
    if( $this->list==0 ) {
      // ajout unitaire
      $oIdentite = AlkHtmlFactory::getHtmlText($this->ctrlNom, "Nom Prénom", 1, $iSizeTxt, 100);
      $block->addCtrl($oIdentite);
      $oCourriel = AlkHtmlFactory::getHtmlText($this->ctrlMail, "Courriel", 1, $iSizeTxt, 255);
      $block->addCtrl($oCourriel);
    } elseif( $this->list==1 ) {
      $this->setLabelDesc("Instructions : Remplir une adresse par ligne. <br/>Celle-ci doit être de la forme NomPrenom&lt;adresseMail&gt; ou adresseMail<br/>".
                          "Exemple 1 : Administrateur Alkante&lt;alkante@alkante.com&gt;".
                          "<br/>Exemple 2 : alkante@alkante.com");
      $oUser = AlkHtmlFactory::getHtmlText($this->ctrlUserList, "Liste des destinataires",$iHeightMemo, $iWidthMemo+5);
      $block->addCtrl($oUser);
    }
    
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_USER, ALK_SHEET_NONE);
    
    $block->addButtonPage("Btajout", "javascript:ajoutSimple('".$strToken."');", "Ajouter", "Ajouter ce destinataire");
    $block->addButtonPage("BtFermer", "javascript:closeWindow('');", "Fermer", "Fermer la fenêtre");
  }
}
?>