<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Alkanet
Module fournissant les pages adressables Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/
require_once("../../../lib/lib_session.php");


/**
 * script de migration des données de newsletter vers lsdiff
 */
 
 echo "===========Début script=================<br/><br/>";
$dbConn = AlkFactory::getDbConn();

// 1. LETTRE-01-CLASSIFICATION =>SIT_LISTE
echo "1. LETTRE-01-CLASSIFICATION =>SIT_LISTE <br/>";

$strSql = " select * from LETTRE_01_CLASSIFICATION lc".
          " inner join SIT_APPLI_CONT sc on sc.APPLI_ID = lc.APPLI_ID";
$dsLet = $dbConn->initDataset($strSql);

$tabClass = array();
while($drLet = $dsLet->getRowIter()){
  $cont_id   = $drLet->getValueName("CONT_ID");
  $classif_lib = $drLet->getValueName("CLASSIFICATION_LIBELLE");
  $liste_id_new = $dbConn->getNextId("SIT_LISTE", "LISTE_ID", "SEQ_SIT_LISTE");
  $tabClass[$drLet->getValueName("CLASSIFICATION_ID")] = $liste_id_new;
  
  $strSql = " insert into SIT_LISTE (LISTE_ID,  LISTE_INTITULE_FR, LISTE_DESC_FR, LISTE_PRIVE,  LISTE_LOCK, LISTE_VALIDE, AGENT_ID, CONT_ID, LISTE_TYPE)".
            " values(".$liste_id_new.",'".$dbConn->analyseSql($classif_lib)."', '', 2, 0, 1, null, ".$cont_id.",2)";
  $dbConn->executeSql($strSql);
}

//2.LETTRE_01_ABOCLASS => SIT_ABONNE_LISTE
echo "2.LETTRE_01_ABOCLASS => SIT_ABONNE_LISTE <br/>";

foreach($tabClass as $classif_id =>$liste_id){
  $strSql = " insert into SIT_ABONNE_LISTE (LISTE_ID, ABONNE_ID)".
            " select ".$liste_id.", ABONNE_ID ".
            " from LETTRE_01_ABOCLASS where CLASSIFICATION_ID=".$classif_id;
  $dbConn->executeSql($strSql);
}

//3.LETTRE_01_LETTRE =>LSDIF_MSG
echo "3.LETTRE_01_LETTRE =>LSDIF_MSG <br/>";
$tabLettres = array();
$strSql = " select * from LETTRE_01_LETTRE";
$dsLettres = $dbConn->initDataset($strSql);

while ($drLettre = $dsLettres->getRowIter()){
  $msg_id = $dbConn->getNextId("LSDIF_MSG", "MSG_ID", "SEQ_LSDIF_MSG");
  $lettre_id = $drLettre->getValueName("LETTRE_ID");
  $lettre_contenu    = $drLettre->getValueName("LETTRE_CONTENU");
  $date_crea         = $drLettre->getValueName("LETTRE_DATE_CREATION");
  $date_envoi        = $drLettre->getValueName("LETTRE_DATE_ENVOI");
  $date_modif        = $drLettre->getValueName("LETTRE_DATEMODIF");
  $lettre_titre      = $drLettre->getValueName("LETTRE_TITRE");
  $lettre_visible    = $drLettre->getValueName("LETTRE_VISIBLE");
  $appli_id          = $drLettre->getValueName("APPLI_ID");
  $gedit_appli_id    = $drLettre->getValueName("GEDIT_APPLI_ID");
  $gedit_page_id     = $drLettre->getValueName("GEDIT_PAGE_ID");
  
  $strSql = "insert into LSDIF_MSG (MSG_ID, APPLI_ID, MSG_DATE, MSG_DATENV, MSG_PUBLIC, AGENT_ID, MSG_IDFROM, MSG_IDREPLY, MSG_SUJET, MSG_MESSAGE,".
            " MSG_PJ, MSG_ETAT, MSG_GROUP, MSG_TYPE) values(".$msg_id.",0,'".$date_crea."','".$date_envoi."',1, 1, 1, 1, '".$lettre_titre."',".
            "'','||', 0, 0, 2)";
  $dbConn->executeSql($strSql);
  $tabLettres[$lettre_id] = array("page_id"=>$gedit_page_id, "msg_id"=>$msg_id);
}


foreach($tabLettres as $lettre_id =>$tabValues){
  
  // copie des pages
  echo "4. Insertion dans LSDIF_MSG_PAGE <br/>";
  $strSql = " insert into LSDIF_MSG_PAGE(MSG_ID, PAGE_ID) values(".$tabValues["msg_id"].",".$tabValues["page_id"].")";
  $dbConn->executeSql($strSql);
  
  //LETTRE_01_LETTRECLASS => LSDIF_MSG_LISTE
  echo "5. LETTRE_01_LETTRECLASS => LSDIF_MSG_LISTE <br/>";
 foreach($tabClass as $classif_id =>$liste_id){
   $strSql = "insert into LSDIF_MSG_LISTE (MSG_ID, LISTE_ID)".
           " select ".$tabValues["msg_id"].", ".$liste_id.
           " from LETTRE_01_LETTRECLASS where CLASSIFICATION_ID=".$classif_id.
           " and LETTRE_ID=".$lettre_id;
   $dbConn->executeSql($strSql);
 }
 
 //LETTRE_01_LETTREABO
 echo "6. insertion dans LSDIF_DEST <br/>";
 $strSql = " insert into LSDIF_DEST(ABONNE_ID,  MSG_ID)".
           " select ABONNE_ID, ".$tabValues["msg_id"].
           " from LETTRE_01_LETTREABO ".
           " where LETTRE_ID=".$lettre_id;
  $dbConn->executeSql($strSql);
}

 echo "===========Fin script=================<br/><br/>";