{*licence 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::CEdit
Module consultation éditoriale..
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

licence*}
{strip}

{php}

/**
 * Fonction recursive retournant le plan sous forme arborescent avec les balises ul et li
 * Retourne le code html minimal. Affecter les styles sur ul, li a dans le contexte map 
 *
 * @param tabPageId  tableau contenant les identifiants de page du niveau courant
 * @return string
 */
function getHtmlArbo($tabPages, $tabPageId)
{
  $strHtml = "";
  foreach($tabPageId as $page_id) {
    $tabPage = $tabPages["_".$page_id];
    $strHtml .= "<li><a href=\"".$tabPage["page_url"]."\" target=\"".$tabPage["page_target"]."\">".$tabPage["page_titre"]."</a></li>";
    if( $tabPage["nbFils"] > 0 ) {
      $strHtml .= "<ul>".getHtmlArbo($tabPages, $tabPage["tabFilsId"])."</ul>";
    }
  }
  return $strHtml;
}

$tabPageId = array();
foreach($this->_tpl_vars["tabPages"] as $tabPage) {
  if( $tabPage["page_niveau"] == 2 ) {
    $tabPageId[] = $tabPage["page_id"];
  } 
}
$this->assign("strHtmlPlan", "<ul>".getHtmlArbo($this->_tpl_vars["tabPages"], $tabPageId)."</ul>");

{/php}

{include file='../../../scripts/gedit/templates/alkhtmlpageheader.tpl'}
<div id="contenu_page">
  <div class="map">
    {$strHtmlPlan}
  </div>
  {include file='../../../scripts/gedit/templates/alkhtmlgeditblocs.tpl' bColumn=0}
  {include file='../../../scripts/gedit/templates/alkhtmlgeditblocs.tpl' bColumn=1}
</div>
{/strip}
