<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::GEdit
Module gestion éditoriale.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_GEdit
 * @class AlkHtmlPopupUserList
 * @brief Classe affichant une popup de selection d'information éditoriale
 */
class AlkHtmlPopupDataSelect extends AlkHtmlForm 
{
  /** identifiant du bloc, =-1 pour association avec la page, sans affichage des données */
  protected $bloc_id;
  /** type de l'application contenant les informations à sélectionner */
  protected $atypeIdBloc;
  /** type de l'application conteneur de atypeIdBloc */
  protected $atypeIdAppli;
  /** =1 si possibilité d'affichage en colonne, =0 sinon */
  protected $iColumn;
  /** =1 si possibilité de filtrer par espace, =0 sinon */ 
  protected $iFilterSpace;
  /** =1 si possibilité de filtrer par application, =2 si possibilité d'associer une application à un bloc, =1 sinon */
  protected $iAssocAppli;
  /** =1 si possibilité de filtrer par catégorie, =2 si possibilité d'associer une catégorie à un bloc, =0 sinon */
  protected $iAssocCat;
  /** intitulé de la vue pour extraire les catégories de l'application */
  protected $catTableName;
  /** intitulé de la vue pour extraire les données publiables de l'application */
  protected $dataTableName;
  /** intitulé de la donnée pour l'environnement de l'application */
  protected $dataTitle;
  /** intitulé de la catégorie pour l'environnement de l'application */
  protected $catTitle;
  /** champ de bits donnant la liste des champs utilisés pour le tri dans un bloc */
  protected $iFields;
  /** champ de bits donnant la liste des champs utilisés pour le tri dans une page */
  protected $iFieldsPage;
  /** position du bloc spécifique : top ou bottom */
  protected $blocPosition;

  /** champs du formulaire */
  protected $cont_id_filter;
  protected $appli_id_filter;
  protected $cat_id_filter;
  protected $bloc_colonne;
  protected $bloc_filtrepub;
  protected $bloc_filtrecal; 
  protected $bloc_datedeb;   
  protected $bloc_datefin;   
  protected $bloc_ordre;
  protected $bloc_nom;
  protected $bloc_desc;
  protected $bloc_limit;
  protected $page_nb_elements;
  

  protected $bloc_typeassoc;
  protected $strParam;
  
  /** Objet appli lié au type de bloc **/
  protected $oAppliBloc;

  // masque de bloc_typeassoc pour obtenir les valeur de bloc_filtrepub et bloc_filtrecal
  protected $iMaskFiltrePubli;
  protected $iMaskFiltreCalendaire;


  /**
   * Constructeur par défaut
   * @param oAppli  Référence sur l'appli annuaire
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formDataSelect"); 
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
    $this->bloc_id        = AlkRequest::getToken("bloc_id", -1);
    
    // paramétrage du popup
    $this->atypeIdBloc    = AlkRequest::getToken("atypeIdBloc", "-1");
    $this->iColumn        = AlkRequest::getToken("iColumn", 0);
    $this->iFilterSpace   = AlkRequest::getToken("iFilterSpace", 0);
    $this->iAssocAppli    = AlkRequest::getToken("iAssocAppli", 1);
    $this->iAssocCat      = AlkRequest::getToken("iAssocCat", 0);
    $this->catTableName   = AlkRequest::getToken("catTableName", "");
    $this->dataTableName  = AlkRequest::getToken("dataTableName", "");
    $this->dataTitle      = AlkRequest::getToken("dataTitle", "");
    $this->catTitle       = AlkRequest::getToken("catTitle", "");   
    $this->blocPosition   = AlkRequest::getToken("blocPosition", "bottom");
    $this->iFields        = AlkRequest::getToken("iFields", 0);
    $this->iFieldsPage    = AlkRequest::getToken("iFieldsPage", 0);
    
    $this->strParam = "&bloc_id=".$this->bloc_id.
      "&atypeIdBloc=".$this->atypeIdBloc.
      "&iColumn=".$this->iColumn.
      "&iFilterSpace=".$this->iFilterSpace.
      "&iAssocAppli=".$this->iAssocAppli.
      "&iAssocCat=".$this->iAssocCat.
      "&catTableName=".$this->catTableName.
      "&dataTableName=".$this->dataTableName.
      "&dataTitle=".$this->dataTitle.
      "&catTitle=".$this->catTitle.
      "&iFields=".$this->iFields.
      "&iFieldsPage=".$this->iFieldsPage.
      "&blocPosition=".$this->blocPosition;
    
    if( $this->atypeIdBloc == ALK_ATYPE_ID_GEOLOC ) {
      $tabATypeIdBloc = array(ALK_ATYPE_ID_ACTU/*, ALK_ATYPE_ID_FDOC*/);
    } else {
      $tabATypeIdBloc = array($this->atypeIdBloc);
    }
    
    $strATypeIdAppli = "";
    foreach($tabATypeIdBloc as $atypeIdBloc) {
      $strATypeIdAppli .= ($strATypeIdAppli != "" ? "," : "").AlkFactory::getMasterATypeId($atypeIdBloc);
    }
    $this->atypeIdAppli = $strATypeIdAppli;
    
    $this->iMaskFiltreCalendaire = TASSOC_INTERVPUB + TASSOC_INTERVINFO + TASSOC_INTERVMODIF + TASSOC_30J_PUBLIE + TASSOC_30J_INFO + TASSOC_30J_MODIF; 
    $this->iMaskFiltrePubli      = TASSOC_ALAUNE + TASSOC_ARCHIVE + TASSOC_PUBLIE + TASSOC_AVALIDER + TASSOC_SYNDIC + TASSOC_ENVALIDATION;
  }

  /**
   * @brief Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) 
  {
    $this->cont_id_filter = AlkRequest::_POSTint("cont_id_filter", AlkRequest::getToken("cont_id", "-1"));
    $this->strDataIdList = AlkRequest::getDecodeParam("dil", "");
    $this->bloc_typeassoc = AlkRequest::getDecodeParam("typeassoc", TASSOC_EMPTY);
    $default_ordre = AlkRequest::getDecodeParam("default_ordre", "");
    $default_datedeb = AlkRequest::getDecodeParam("default_datedeb", "");
    $default_datefin = AlkRequest::getDecodeParam("default_datefin", "");
    $page_nb_elements = AlkRequest::getDecodeParam("page_nb_elements", "-1");
    $tabMultilingue  = array();

    $this->cont_id_filter   = new AlkFormData($this, "cont_id_filter",  $this->cont_id_filter,  ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->appli_id_filter  = new AlkFormData($this, "appli_id_filter", "-1",                   ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->cat_id_filter    = new AlkFormData($this, "cat_id_filter",   "-1",                   ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->bloc_colonne     = new AlkFormData($this, "bloc_colonne",    "0",                    ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->bloc_filtrepub   = new AlkFormData($this, "bloc_filtrepub",  "16",                   ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->bloc_filtrecal   = new AlkFormData($this, "bloc_filtrecal",  "0",                    ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->bloc_datedeb     = new AlkFormData($this, "bloc_datedeb",    $default_datedeb,       ALK_SQL_DATE,   ALK_VERIF_DEFAULT);
    $this->bloc_datefin     = new AlkFormData($this, "bloc_datefin",    $default_datefin,       ALK_SQL_DATE,   ALK_VERIF_DEFAULT);
    $this->bloc_ordre       = new AlkFormData($this, "bloc_ordre",      $default_ordre,         ALK_SQL_TEXT); // champ caché pour enregistrer le calcul js de bloc_ordre
    $this->bloc_nom         = new AlkFormData($this, "bloc_nom",        $tabMultilingue,        ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);
    $this->bloc_desc        = new AlkFormData($this, "bloc_desc",       "",                     ALK_SQL_TEXT); 
    $this->bloc_limit       = new AlkFormData($this, "bloc_limit",      "-1",                   ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->page_nb_elements = new AlkFormData($this, "page_nb_elements",$page_nb_elements,      ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    
    $oDrData   = null;
    if( $iTypeInit == ALK_INIT_MODE_DATAROW ) {
      $oDsData = $this->oAppli->oQuery->getDsBlocById($this->bloc_id, $this->iMaskFiltrePubli, $this->iMaskFiltreCalendaire);
      if( $oDrData = $oDsData->getRowIter() ) {
        $this->bloc_typeassoc = $oDrData->getValueName("BLOC_TYPEASSOC");
      } else {
        $oDrData = null;
      }  
    }
    $reqMethod = REQ_POST;
    $this->initData($iTypeInit, $oDrData, $reqMethod);
    
    if( $this->bloc_filtrepub->value == 0 ) {
      $this->bloc_filtrepub->value = TASSOC_PUBLIE;
    }
  }
  
  /**
   * @brief Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  { 
    $this->setData(ALK_INIT_MODE_REQUEST);

    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);    

    $bWindow = false;
    $bloc_typeassoc = TASSOC_EMPTY;
    $iColumn = "0";

    // enregistrement des données spécifiques au bloc
    $this->doSqlDataAtypeId();
    
    switch( $this->iMode ) {
    case "4": // sélection d'un espace : modif liste appli, liste cat vide
      $cont_id_filter = AlkRequest::_GETint("idc", "-1");

      $tabRes = array();

      // liste des appli de l'espace de type sélectionné
      $tabRes["tabAppli"] = Array();
      $dsAppli = $oQueryEspace->getDsListAppliBySpaceByATypeIdForCombo($user_id, $cont_id_filter, $this->atypeIdAppli);
      $nbElt = $dsAppli->getCountTotDr();
      if( $nbElt > 0 ) { 
        $tabRes["tabAppli"][] = array("-1", _t("Sélectionnez une application"));
      } else {
        $tabRes["tabAppli"][] = array("-1", _t("Aucune accessible dans cet espace"));
      }
      while( $drAppli = $dsAppli->getRowIter() ) {
        $idAppli  = $drAppli->getValueName("APPLI_ID");
        $strAppli = $drAppli->getValueName("APPLI_INTITULE");
        $tabRes["tabAppli"][] = array($idAppli, $strAppli);
      }

      // liste des catégories de l'appli
      $tabRes["tabCat"] = Array();
      if( $nbElt > 0 ) { 
        $tabRes["tabCat"][] = array("-1", _t("Sélectionnez une application"));
      } else {
        $tabRes["tabCat"][] = array("-1", _t("Aucun n'est accessible"));
      }

      $tabRes["strHtmlDataList"] = "";
      if( $this->bloc_id != -1 ) {
        $oCtrlList = $this->getHtmlDataList("-1", "-1", $user_id);
        $tabRes["strHtmlDataList"] = $oCtrlList->getHtml(); 
      }
      
      echo json_encode($tabRes);  
      break;
      
    case "5": // sélection d'une appli : modif liste dossier
      $cont_id_filter = AlkRequest::_GETint("idc", "-1");
      $appli_id_filter = AlkRequest::_GETint("ida", "-1");

      $tabRes = array();
      $tabRes["tabAppli"] = null;
 
      // liste des catégories de l'appli
      if( $this->iAssocCat > 0 ) {
        $tabRes["tabCat"] = Array();
        $dsAppli = $this->oAppli->oQuery->getDsListCat($appli_id_filter, $user_id, $this->catTableName);
        $nbElt = $dsAppli->getCountTotDr(); 
        if( $nbElt > 0 ) {
          $tabRes["tabCat"][] = array("-1", _t("Tous"));
        } else {
          $tabRes["tabCat"][] = array("-1", _t("Aucun n'est accessible"));
        }
        while( $drAppli = $dsAppli->getRowIter() ) {
          $idCat  = $drAppli->getValueName("CAT_ID");
          $strCat = $drAppli->getValueName(AlkFactory::getDBCurrentLanguageField("CAT_INTITULE"));
          $tabRes["tabCat"][] = array($idCat, $strCat);
        }
      } else {
        $tabRes["tabCat"] = null;
      }

      $tabRes["strHtmlDataList"] = "";
      if( $this->bloc_id != -1 ) {
        $oCtrlList = $this->getHtmlDataList($appli_id_filter, "-1", $user_id);
        $tabRes["strHtmlDataList"] = $oCtrlList->getHtml(); 
      }

      echo json_encode($tabRes);  
      break;
        
    case "6": // sélection d'une cat => réaffichage de la liste
      $cont_id_filter   = AlkRequest::_GETint("idc", "-1");
      $appli_id_filter  = AlkRequest::_GETint("ida", "-1");
      $cat_id_filter    = AlkRequest::_GETint("idt", "-1");
      $page_nb_elements = AlkRequest::_GETint("ide", "-1");

      $tabRes = array();
      $tabRes["tabAppli"] = null;
      $tabRes["tabCat"]   = null;

      $tabRes["strHtmlDataList"] = "";
      if( $this->bloc_id != -1 ) { 
        $oCtrlList = $this->getHtmlDataList($appli_id_filter, $cat_id_filter, $user_id);
        $tabRes["strHtmlDataList"] = $oCtrlList->getHtml(); 
      }
      
      echo json_encode($tabRes);  
      break;
        
    case "7": // association appli avec bloc
      $appli_id_filter   = AlkRequest::_POSTint("appli_id_filter", "-1");
      $bloc_colonne      = AlkRequest::_POSTint("bloc_colonne", "0");
      $bloc_ordre        = AlkRequest::_POST("bloc_ordre", "");
      $bloc_datedeb      = AlkRequest::_POST("bloc_datedeb", "");
      $bloc_datefin      = AlkRequest::_POST("bloc_datefin", "");
      $bloc_filtrepub    = AlkRequest::_POSTint("bloc_filtrepub", "0");
      $bloc_filtrecal    = AlkRequest::_POSTint("bloc_filtrecal", "0");
      $bloc_desc         = AlkRequest::_POST("bloc_desc", "");
      $bloc_limit        = AlkRequest::_POSTint("bloc_limit", "-1");
      $page_nb_elements  = AlkRequest::_POSTint("page_nb_elements", "-1");
      
      $tab_bloc_nom    = array();
      foreach($this->tabLangue as $key => $tabLg) {
        $tab_bloc_nom[$key] = AlkRequest::_POST("bloc_nom".$tabLg["bdd"], "");
      }
      $bloc_typeassoc  = $this->getTypeAssoc(TASSOC_BYAPPLI, $bloc_filtrepub, $bloc_filtrecal);
      if( $this->bloc_id != "-1" ) {
        $this->oAppli->oQueryAction->updateBlocColumn($this->bloc_id, $bloc_colonne, $bloc_typeassoc, $user_id, $bloc_ordre, $bloc_datedeb, 
                                                      $bloc_datefin,$tab_bloc_nom, $bloc_desc, $bloc_limit);
        $this->oAppli->assocAppliToBloc($this->bloc_id, $this->atypeIdBloc, $appli_id_filter);
        $bWindow = true;
      } else {
        // association avec la page
        $strAppliCatName = $this->oAppli->oQuery->getAppliCatName($this->atypeIdBloc, $appli_id_filter, -1);
        echo getBodyOnLoadExec("top.updateFieldAssocAppliCatPage(".$appli_id_filter.", -1, '".addslashes($strAppliCatName)."', '".$bloc_typeassoc."', '".$bloc_ordre."', '".$bloc_datedeb."', '".$bloc_datefin."', ".$page_nb_elements." );", "closeWindow();");    
        return "";  
      }
      break;

    case "8": // assocition cat avec bloc
      $appli_id_filter   = AlkRequest::_POSTint("appli_id_filter", "-1");
      $cat_id_filter     = AlkRequest::_POSTint("cat_id_filter", "-1");
      $bloc_colonne      = AlkRequest::_POSTint("bloc_colonne", "0");
      $bloc_ordre        = AlkRequest::_POST("bloc_ordre", "");
      $bloc_datedeb      = AlkRequest::_POST("bloc_datedeb", "");
      $bloc_datefin      = AlkRequest::_POST("bloc_datefin", "");
      $bloc_filtrepub    = AlkRequest::_POSTint("bloc_filtrepub", "0");
      $bloc_filtrecal    = AlkRequest::_POSTint("bloc_filtrecal", "0");
      $bloc_desc         = AlkRequest::_POST("bloc_desc", "");
      $bloc_limit        = AlkRequest::_POSTint("bloc_limit", "-1");
      $page_nb_elements  = AlkRequest::_POSTint("page_nb_elements", "-1");
      
      $tab_bloc_nom    = array();
      foreach($this->tabLangue as $key => $tabLg) {
        $tab_bloc_nom[$key] = AlkRequest::_POST("bloc_nom".$tabLg["bdd"], "");
      }
      $bloc_typeassoc  = $this->getTypeAssoc(TASSOC_BYCATEG, $bloc_filtrepub, $bloc_filtrecal);
      
      if( $this->bloc_id != "-1" ) {
        $this->oAppli->oQueryAction->updateBlocColumn($this->bloc_id, $bloc_colonne, $bloc_typeassoc, $user_id, 
                                                      $bloc_ordre, $bloc_datedeb, $bloc_datefin, $tab_bloc_nom, 
                                                      $bloc_desc, $bloc_limit);
        $this->oAppli->assocCatToBloc($this->bloc_id, $cat_id_filter, $this->atypeIdBloc, $appli_id_filter);
        $bWindow = true;
      } else {
        // association avec la page
        $strAppliCatName = $this->oAppli->oQuery->getAppliCatName($this->atypeIdBloc, $appli_id_filter, $cat_id_filter);
        echo getBodyOnLoadExec("top.updateFieldAssocAppliCatPage(".$appli_id_filter.", ".$cat_id_filter.", '".addslashes($strAppliCatName)."', '".$bloc_typeassoc."', '".$bloc_ordre."', '".$bloc_datedeb."', '".$bloc_datefin."', ".$page_nb_elements.");", "closeWindow();");
        return "";  
      }
      break;
        
    case "9": // association data avec bloc
      $appli_id_filter = AlkRequest::_POSTint("appli_id_filter", "-1");
      $tabDataId       = AlkRequest::_POST("listData", array());
      $bloc_colonne    = AlkRequest::_POSTint("bloc_colonne", "0");
      $bloc_ordre      = AlkRequest::_POST("bloc_ordre", "");
      $bloc_datedeb    = AlkRequest::_POST("bloc_datedeb", "");
      $bloc_datefin    = AlkRequest::_POST("bloc_datefin", "");
      $bloc_filtrecal  = AlkRequest::_POSTint("bloc_filtrecal", "0");
      $bloc_filtrepub  = AlkRequest::_POSTint("bloc_filtrepub", "0");
      $bloc_desc       = AlkRequest::_POST("bloc_desc", "");
      $bloc_limit      = AlkRequest::_POSTint("bloc_limit", "-1");
      $tab_bloc_nom    = array();
      foreach($this->tabLangue as $key => $tabLg) {
        $tab_bloc_nom[$key] = AlkRequest::_POST("bloc_nom".$tabLg["bdd"], "");
      }
      $bloc_typeassoc  = $this->getTypeAssoc(TASSOC_BYDATA, $bloc_filtrepub, $bloc_filtrecal);
            
      $this->oAppli->oQueryAction->updateBlocColumn($this->bloc_id, $bloc_colonne, $bloc_typeassoc, $user_id, 
                                                    $bloc_ordre, $bloc_datedeb, $bloc_datefin, $tab_bloc_nom, 
                                                    $bloc_desc, $bloc_limit);
      $this->oAppli->assocDataToBloc($this->bloc_id, $tabDataId, $this->atypeIdBloc, $appli_id_filter);
      $bWindow = true;
      break;  
    }

    if( $bWindow == true ) {
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                          "&iMode=10&bloc_id=".$this->bloc_id."&bloc_colonne=".$bloc_colonne.
                                          "&atypeIdBloc=".$this->atypeIdBloc."&bloc_typeassoc=".$bloc_typeassoc);
      $strHtmlJs = "top.updateDataBloc('".$strToken."');";
      echo getBodyOnLoadExec($strHtmlJs);
    }
    return "";
  }
  
  /**
   * Calcul le bloc_typeassoc correspondant aux 3 paramètres
   * @param iTypeAssoc        Type d'association au bloc : =1 appli, =2 cat, =3 data
   * @param iFiltrePubli      filtre de publication
   * @param ibloc_filtrecal filtre calendaire
   * @return entier
   */
  private function getTypeAssoc($iTypeAssoc, $iFiltrePubli, $ibloc_filtrecal)
  {
    return  $iTypeAssoc + $iFiltrePubli + $ibloc_filtrecal;
  }
  
  /**
   * @brief Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  {
    return "Sélectionner une information de type ".$this->dataTitle;
  }
  
  /**
   * @brief Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);
    
    $iWidthSelect = 260;
    $user_id = AlkFactory::getSProperty("user_id", "-1"); 
    
    $this->addBlockDataSelect($user_id, $iWidthSelect+70);
    if ( $this->bloc_id !=-1 ){
      $this->addBlocNom($iWidthSelect);
    }
    $this->addBlockDataAtypeId(130, $iWidthSelect+150);
    
    $this->setTemplate("gedit", "alkhtmlpopupdataselect.tpl");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."gedit/lib/alkhtmlpopupdataselect.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
  }
  
 /**
  * bloc contenant les informations sur les espaces, les appli, les catégories et data
  * @param unknown_type $user_id
  * @param unknown_type $iWidthSelect
  */
  private function addBlockDataSelect($user_id, $iWidthSelect)
  {
    $strGenreUn = ($this->bloc_id!=-1 ? _t("un") : _t("une"))." ";
    $strGenreDu = ($this->bloc_id!=-1 ? _t("du") : _t("de la"))." ";
    $strTypeEdit = ($this->bloc_id!=-1 ? _t("bloc") : _t("page éditoriale"));
    $iWidthLabel = "130";//"130";
    $strDesc = _f("Vous avez la possibilité de sélectionner une information de type %s présente sur ", $this->dataTitle).
    ( $this->iFilterSpace == "1" ? _t("tous les espaces accessibles") : _t("cet espace") ).".<br/>".
    _f("Vous pouvez associer à %s", $strGenreUn.$strTypeEdit)." :<br/>".
    " - "._t("soit une application ou une catégorie pouvant regrouper plusieurs informations")."<br/>".
    " - "._t("soit une sélection d'informations sélectionnées.")."<br/>" .
    _t("En gras souligné, le niveau d'association actuel.")."<br/>";

    
    $oBlock = $this->addBlock("blockProp", _f("Sélectionner, filtrer et ordonner les informations %s", $strGenreDu.$strTypeEdit), $strDesc, $iWidthLabel, $iWidthSelect+150, true);
    $oBlock->addCtrl(AlkHtmlFactory::getHtml(""));
    // champ caché pour enregistrer le bloc_ordre
    $oCtrlBlocOrder = AlkHtmlFactory::getHtmlHidden($this->bloc_ordre);
    $oCtrlBlocOrder->addDataHidden($this->bloc_desc);
    $oBlock->addCtrl($oCtrlBlocOrder);

    if( defined("ALK_B_GEDIT_TYPEPUBLI") && ALK_B_GEDIT_TYPEPUBLI ) {
      $iFields = ($this->bloc_id!=-1 ? $this->iFields : $this->iFieldsPage);
      
      $tabFiltrePubli = $this->getTabFiltrePubli($iFields);
      if( !empty($tabFiltrePubli) ) {
        $oCtrlTypePubli = AlkHtmlFactory::getHtmlSelect($this->bloc_filtrepub, _t("Filtre de publication"));
        $oCtrlTypePubli->setProperty("tabValTxt", $tabFiltrePubli);
        $oBlock->addCtrl($oCtrlTypePubli);
      }
            
      $tabFiltreCalend = $this->getTabFiltreCalend($iFields);
      if( !empty($tabFiltreCalend) ) {
        $oCtrlbloc_filtrecal = AlkHtmlFactory::getHtmlSelect($this->bloc_filtrecal, _t("Filtre calendaire"));
        $oCtrlbloc_filtrecal->setProperty("tabValTxt", $tabFiltreCalend);
        $oCtrlbloc_filtrecal->setProperty("tabValTxtDefault", array("0", _t("Aucun filtre")));
        $oCtrlbloc_filtrecal->addEvent("onclick","DisableFields()");
        $oCtrlbloc_filtrecal->addOnload("DisableFields()");
        $this->addOnload("initRank()");
        $oBlock->addCtrl($oCtrlbloc_filtrecal);
            
        $bloc_datedeb = AlkHtmlFactory::getHtmlDate($this->bloc_datedeb, _t("du"), "01/10/2008");
        $bloc_datefin  = AlkHtmlFactory::getHtmlDate($this->bloc_datefin, _t("au"), "01/10/2008");
        $bloc_datedeb->addCtrl($bloc_datefin);
        $oCtrlbloc_filtrecal->addCtrl($bloc_datedeb);
      }

      // Ajout ordre de publication
      $strHtml = $this->getFieldsOrder($iFields);
      if( $strHtml != "" ) { 
        $oBlock->addCtrl(AlkHtmlFactory::getHtml($strHtml, _t("Ordre de publication") ));
      }

      $this->addScriptCss("../".ALK_ROOT_MODULE."gedit/templates/alkhtmlpopupdataselect.css");
    }
    
    // Affichage en colonne
    if( $this->iColumn == "1") {
      $oCtrlCheckbox = AlkHtmlFactory::getHtmlCheckbox($this->bloc_colonne, _t("Affichage en colonne"));
      $oBlock->addCtrl($oCtrlCheckbox);
    }
    
    if ( $this->bloc_id !=-1 ){
      $bloc_limit = AlkHtmlFactory::getHtmlText($this->bloc_limit, _t("Nombre d'éléments à afficher"), 1, 5, 3);
      $bloc_limit->setLabelAfter("&nbsp;&nbsp;-1 = (tous)");
      $oBlock->addCtrl($bloc_limit);
    }else{
      $page_nb_elements = AlkHtmlFactory::getHtmlText($this->page_nb_elements, _t("Nombre d'éléments par page"), 1, 5, 3);
      $page_nb_elements->setLabelAfter("&nbsp;&nbsp;-1 = (tous)");
      $oBlock->addCtrl($page_nb_elements);
    }
    
    if ( $this->bloc_id !=-1 ){
      $strDesc = _t("Cette configuration prend effet immédiatement sur l'aperçu de la page éditoriale.");  
    } else {
      $strDesc = _t("Cette configuration prendra effet sur l'aperçu à la Validation ou à la Publication de la page éditoriale.");
    }   
    $oBlock = $this->addBlock("blockSelect", _t("Votre sélection"), $strDesc, $iWidthLabel, $iWidthSelect+150, true);
    // récupération des informations présaisies
    $cont_id = -1;
    $appli_id= -1;
    $cat_id  = -1;
    $this->oAppli->oQuery->getBlocContAppliCat($this->bloc_typeassoc, $this->strDataIdList, $this->dataTableName, $this->catTableName, 
                                               $cont_id, $appli_id, $cat_id); // retour par référence
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE); 
    
    // selectionne les espaces accessibles contenant des applis de type atypeIdAppli
    $this->cont_id_filter->value  = ( $cont_id  != -1 ? $cont_id  : $this->cont_id_filter->value );
    $this->appli_id_filter->value = ( $appli_id != -1 ? $appli_id : $this->appli_id_filter->value);
    $this->cat_id_filter->value   = ( $cat_id   != -1 ? $cat_id   : $this->cat_id_filter->value  );
    
    $oCtrlSelectSpace = AlkHtmlFactory::getHtmlSelect($this->cont_id_filter, _t("Espace"), 1, $iWidthSelect);
    $bShow = ( $this->iFilterSpace == "1" );
    if( $bShow ) {
      // recherche si le cont_id_filter appartient bien à la liste, 
      // sinon on le met à jour par rapport à la première valeur de la liste
      $dsCont = $oQueryEspace->getDsListSpaceByATypeIdForCombo($user_id, $this->atypeIdAppli);
      $iFirstContId = -1; 
      $tabCont = array();
      while( $drCont = $dsCont->getRowIter() ) {
        $idCont = $drCont->getValueName("CONT_ID");
        if( $iFirstContId == -1 ) {
          $iFirstContId = $idCont; 
        }
        $tabCont[$idCont] = $drCont->getValueName("CONT_INTITULE_COURT"); 
      }
      if( !isset($tabCont[$this->cont_id_filter->value]) ) {
        $this->cont_id_filter->value = $iFirstContId;
        $oCtrlSelectSpace->setProperty("value", $this->cont_id_filter->value);
      }
      $oCtrlSelectSpace->setProperty("tabValTxt", $tabCont);
    } else {
      $oCtrlSelectSpace->setProperty("tabValTxtDefault", array("-1", " Tous"));
    }
    $strTokenCombo = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                             $this->strParam."&iMode=4");
    $oCtrlSelectSpace->AddEvent("onchange", "onChangeCombo('".$strTokenCombo."')");
    $oCtrlSelectSpace->setHidden(!$bShow);
    $oBlock->addCtrl($oCtrlSelectSpace);

    // sélectionne les applis de type atypeIdAppli accessibles de l'espace sélectionné
    $cont_id_filter = $this->cont_id_filter->value;
    $oCtrlSelectAppli = AlkHtmlFactory::getHtmlSelect($this->appli_id_filter, $this->getAssocLabel($this->bloc_typeassoc, _t("Application"), TASSOC_BYAPPLI), 1, $iWidthSelect);
    $oCtrlSelectAppli->setProperty("tabValTxtDefault", array("-1", _t(" Sélectionnez une application")));
    $bShow = ( $cont_id_filter != "-1" );
    if( $bShow ) {
      $oCtrlSelectAppli->setProperty("oValTxt", $oQueryEspace->getDsListAppliBySpaceByATypeIdForCombo($user_id, $cont_id_filter, $this->atypeIdAppli));
      $oCtrlSelectAppli->setProperty("strFieldValue", "APPLI_ID");
      $oCtrlSelectAppli->setProperty("strFieldText", "APPLI_INTITULE");
    }
    $strTokenCombo = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                             $this->strParam."&iMode=5");
    $oCtrlSelectAppli->AddEvent("onchange", "onChangeCombo('".$strTokenCombo."')");      
    if( $this->iAssocAppli > 1 ) {
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE, "&iMode=7".$this->strParam);
      $oBtAddAppli = AlkHtmlFactory::getHtmlButtonForm("javascript:assoc2Bloc('".$strToken."', 1, false)", _t("Associer"), 
                                                       _t("Associer cette application au bloc"), true);
      $oCtrlSelectAppli->addCtrl($oBtAddAppli);
    }
    $oBlock->addCtrl($oCtrlSelectAppli);
        
    $appli_id_filter = $this->appli_id_filter->value;
    $cat_id_filter   = $this->cat_id_filter->value;

    // selectionne les thèmes accessibles
    if( $this->iAssocCat > 0 ) {
      $oCtrlSelectCat = AlkHtmlFactory::getHtmlSelect($this->cat_id_filter, $this->getAssocLabel($this->bloc_typeassoc, $this->catTitle, TASSOC_BYCATEG), 1, $iWidthSelect);
      $strTokenCombo = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                               $this->strParam."&iMode=6");
      $oCtrlSelectCat->AddEvent("onchange", "onChangeCombo('".$strTokenCombo."')");
      if( $appli_id_filter != "-1" ) {
        $oCtrlSelectCat->setProperty("tabValTxtDefault", array("-1", " Tous"));
        $oCtrlSelectCat->setProperty("oValTxt", $this->oAppli->oQuery->getDsListCat($appli_id_filter, $user_id, $this->catTableName));
        $oCtrlSelectCat->setProperty("strFieldValue", "CAT_ID");
        $oCtrlSelectCat->setProperty("strFieldText", AlkFactory::getDBCurrentLanguageField("CAT_INTITULE"));
      } else {
        $oCtrlSelectCat->setProperty("tabValTxtDefault", array("-1", _t(" Sélectionnez une application")));
      }

      if( $this->iAssocCat > 1 ) {
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE, "&iMode=8".$this->strParam);
        $oBtAddCat = AlkHtmlFactory::getHtmlButtonForm("javascript:assoc2Bloc('".$strToken."', 2, false)", _t("Associer"), _t("Associer cet ensemble au bloc"), true);
        $oCtrlSelectCat->addCtrl($oBtAddCat);
      }
      $oBlock->addCtrl($oCtrlSelectCat);
    }
    
    if( $this->bloc_id != -1 ) {
      $oTabPage = $this->getHtmlDataList($appli_id_filter, $cat_id_filter, $user_id);
      $this->addPanel($oTabPage);
    }    
  }
  
  /**
   * Marque le label du type d'association actuelle différemment par recherche du masque de label dans le type d'association du bloc
   * @param iTypeAssoc    Type d'association du bloc
   * @param label         Label à afficher
   * @param iMask         Masque du label 
   * @return string - le label marqué ou le label passé en entrée
   */
  public function getAssocLabel($iTypeAssoc, $label, $iLabelMask)
  {
    if ( $iLabelMask!=TASSOC_BYDATA ){
      if ( binmask_match($iTypeAssoc, $iLabelMask) && !binmask_match($iTypeAssoc, TASSOC_BYDATA) ){
        return "<u><b>".$label."</b></u>";
      }
    } else {
      if ( binmask_match($iTypeAssoc, TASSOC_BYDATA) ){
        return "<u><b>".$label."</b></u>";
      }
    }
    return $label;
  }
 /**
  * Ajoute le bloc contenant des contrôles spécifique lié au type de bloc
  * @param iWidthLabel largeur en px de la colonne label 
  * @param iWidthCtrl  lageur en px de la colonne ctrl de saisie
  */
  public function addBlockDataAtypeId($iWidthLabel, $iWidthCtrl)
  {
    // affichage des champs spécifiques liés bloc de type atypeIdBloc
    $this->oAppliBloc = AlkFactory::getAppli($this->atypeIdBloc);
    if( !is_null($this->oAppliBloc) && is_object($this->oAppliBloc) && method_exists($this->oAppliBloc, "getPanelGEditDataSelect") ) {
      // la méthode getPanelGEditDataSelect se doit d'attacher le bloc à $this passé en paramètre
      $this->oAppliBloc->getPanelGEditDataSelect($this, $this->oAppli, "blockATypeId_".$this->blocPosition, $iWidthLabel, $iWidthCtrl);
    }
  }
  
  /**
   * Execute l'enregistrement des ctrls spécifiques au bloc
   */
   private function doSqlDataAtypeId()
   {
     $this->oAppliBloc = AlkFactory::getAppli($this->atypeIdBloc);
     if( !is_null($this->oAppliBloc) && is_object($this->oAppliBloc) && method_exists($this->oAppliBloc, "doSqlGEditDataSelect") ) {
       $this->oAppliBloc->doSqlGEditDataSelect($this->iMode, $this->bloc_id);
     }   
   }
  
  /**
   * retourne la liste des données selon l'application, la classification choisies
   * @param $appli_id_filter
   * @param $cat_id_filter
   * @param $user_id
   */
  private function getHtmlDataList($appli_id_filter, $cat_id_filter, $user_id)
  {
    $bData=false;
    $tab_data = explode(",", $this->strDataIdList);
    if(($this->bloc_typeassoc & TASSOC_BYDATA) == TASSOC_BYDATA )
      $bData=true;
          
    // liste des résultats
    $dsRes = $this->oAppli->oQuery->getDsListData($appli_id_filter, $cat_id_filter, $user_id, $this->dataTableName, false);
    $nbElt = $dsRes->getCountTotDr();
    $iNbEltParPage = $nbElt;
    $strUrlPagine = "";
    $page = 1;
    $oTabPage = AlkHtmlFactory::getHtmlList($this, $nbElt, $page, $iNbEltParPage, false, 
                                            $strUrlPagine, _t("Aucune information disponible."));
    $oTabPage->setColumns(array("left",   "465"),
                          array("center", "80"));
    $oTabPage->setProperty("strTableAlign", "center");
    
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE, "&iMode=9".$this->strParam);
    $oBtAssocData = AlkHtmlFactory::getHtmlButtonForm("javascript:assoc2Bloc('".$strToken."', 3, false)", _t("Associer"), _t("Associer la sélection au bloc"));
    
   
    if ($this->atypeIdBloc == ALK_ATYPE_ID_DOC){
      $strTitle = "Liste des ".str_replace("Document", "Documents", $this->dataTitle);
    }else {
       $strTitle = _f("Liste des %ss", $this->dataTitle);
    }
    $oTabPage->addTitleRow($this->getAssocLabel($this->bloc_typeassoc, $strTitle, TASSOC_BYDATA)." (".$nbElt.")", $oBtAssocData);


    while( $drRes = $dsRes->getRowIter() ) {
      $data_id       = $drRes->getValueName("DATA_ID");
      $valueCheched = (!empty($tab_data) && in_array($data_id, $tab_data) && $bData ? $data_id:-1);
      $data_intitule = $drRes->getValueName(AlkFactory::getDBCurrentLanguageField("DATA_TITRE"));
      if( $data_intitule == "" ) {
        $data_intitule = $drRes->getValueName(AlkFactory::getDBCurrentLanguageField("DATA_DESC"));
      }

      $oBtAddData = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "listData[]", $valueCheched, "", $data_id, -1);
      $oTabPage->addRow($data_intitule, $oBtAddData);

    }
    
    return $oTabPage;
  }  
  
 /**
  * Rtourne le code html d'un élément déplaçable du controle de gestion des rangs
  * @param tabField  tableau de configuration du code à générer
  * @param BitOrder  liste d'identifiant donnant l'ordre des champs
  */
  private function getHtmlButtonOrder($tabField, $bitOrder)
  {
    $strHtmlLi = '<li id="'.$tabField["name"].'" title="'.$tabField["title"].'">'.$tabField["abrev"];
    if ( $tabField["type"]=="select" ) {
      $tabField["abrev"];
      $strOrder = "décroissant";
      $iNextValue = $tabField["option"][1];
      
      foreach($tabField["option"] as $value) {
        $strHtmlLi .= ' <a id="'.$tabField["name"].$value.'" ' .
          ( $value!=$bitOrder 
            ? 'style="display:none"'
            : '' ).
          ' href="javascript:changeOrder(\''.$tabField["name"].'\', '.$value.', '.$iNextValue.')">'.$strOrder.'</a>';
        $strOrder = "croissant";
        $iNextValue = $tabField["option"][0];
      }
    }
    $strHtmlLi .= '<input type="hidden" id="'.$tabField["name"].'_hidden" value="'.$bitOrder.'"/></li>';
     
    return $strHtmlLi;
  }
  
  /**
   * retourne les champs de tri dans l'ordre préenrégistré
   * @return string
   */
  protected function getFieldsOrder($iFields)
  {
    if( $iFields <=0 ) return "";
    
    $textCat = mb_strtolower($this->catTitle);
    
    $tabFields = array(IFIELD_DATARANG  => array("name"=>"iBitRang",    "type"=>"select", "option"=>array(TASSOC_DATARANG_DESC, TASSOC_DATARANG), "title"=>"Rang d'affichage", "abrev"=>"Rang d'affichage", "width"=>85, "bUsed"=>false),
                       IFIELD_DATEPUB   => array("name"=>"iBitdatepub", "type"=>"select", "option"=>array(TASSOC_DATEPUB_DESC, TASSOC_DATEPUB), "title"=>"Date publication", "abrev"=>"Date publication", "width"=>85, "bUsed"=>false),
                       IFIELD_DATEINFO  => array("name"=>"iBitdateinfo","type"=>"select", "option"=>array(TASSOC_DATEINFO_DESC, TASSOC_DATEINFO), "title"=>"Date information", "abrev"=>"Date information", "width"=>85, "bUsed"=>false),
                       IFIELD_DATEMODIF => array("name"=>"iBitdatemaj", "type"=>"select", "option"=>array(TASSOC_DATEMODIF_DESC, TASSOC_DATEMODIF), "title"=>"Date mise à jour", "abrev"=>"Date mise à jour", "width"=>85, "bUsed"=>false),
                       IFIELD_NOUVEAUTE => array("name"=>"iBitUne",     "type"=>"hidden", "title"=>"Information à la Une", "abrev"=>"Information à la Une", "width"=>30, "bUsed"=>false),
                       IFIELD_CATEGORIE => array("name"=>"iBitCatg",    "type"=>"hidden", "title"=>$this->catTitle, "abrev"=> "Intitulé ".$textCat, "width"=>40, "bUsed"=>false),
                       IFIELD_INTITULE  => array("name"=>"iBitData",    "type"=>"hidden", "title"=>"Intitulé information", "abrev"=>"Intitulé information", "width"=>40, "bUsed"=>false),
                     );
   $tabFieldsIndex = array("_".TASSOC_DATARANG      => IFIELD_DATARANG, 
                           "_".TASSOC_DATARANG_DESC => IFIELD_DATARANG, 
                           "_".TASSOC_DATEPUB_DESC  => IFIELD_DATEPUB,
                           "_".TASSOC_DATEPUB       => IFIELD_DATEPUB,
                           "_".TASSOC_DATEINFO_DESC => IFIELD_DATEINFO,
                           "_".TASSOC_DATEINFO      => IFIELD_DATEINFO,
                           "_".TASSOC_DATEMODIF_DESC=> IFIELD_DATEMODIF,
                           "_".TASSOC_DATEMODIF     => IFIELD_DATEMODIF,
                           "_".TASSOC_NOUVEAUTE     => IFIELD_NOUVEAUTE,
                           "_".TASSOC_CATEGORIE     => IFIELD_CATEGORIE,
                           "_".TASSOC_INTITULE      => IFIELD_INTITULE); 

   $tabFieldsOrdre = array();
   if( $this->bloc_ordre->value!="" ) {
     $tabFieldsOrdre = explode(",", $this->bloc_ordre->value);
   }
   
   // on affiche les champs selon le iField
   $strHtmlLi = "";
   $widthUl   = 0;
   $heightUl  = 0;
   $iNbDisplayField = 0;
   foreach($tabFieldsOrdre as $bitOrder){
     $iField = $tabFieldsIndex["_".$bitOrder];
     if( binmask_match($iFields, $iField) ) {
       $tabField = $tabFields[$iField];
       $strHtmlLi .= $this->getHtmlButtonOrder($tabField, $bitOrder);
       $tabFields[$iField]["bUsed"]=true;
       $widthUl += $tabField["width"];
       $iNbDisplayField++;
     }
   }
   foreach($tabFields as $iField => $tabField){
     if( !$tabField["bUsed"] && binmask_match($iFields, $iField) ) {
       $bitOrder = str_replace("_", "", array_search($iField, $tabFieldsIndex));
       $strHtmlLi .= $this->getHtmlButtonOrder($tabField, $bitOrder);
       $tabField["bUsed"]=true;
       $widthUl += $tabField["width"];
       $iNbDisplayField++;
     }
   }
        
    $widthUl  = $widthUl+($iNbDisplayField*14);  // fixe la largeur dans le cas horizontal
    $heightUl = $iNbDisplayField*19;         // fixe la hauteur dans le cas vertical
    return '<ul id="sortable" style="height:'.$heightUl.'px">'.$strHtmlLi.'</ul>'.
       '<p id="sortableTxt" class="txtHelp" >' .
       _t("A l'aide du glisser/déposer, paramétrez l'ordre des résultats en ordonnant les cellules ci-contre.").'<br/>' .
       ($this->bloc_id!=-1 
        ? '<b>'._f("Cet ordre ne sera appliqué que pour les associations de niveau Application et/ou %s.", $this->catTitle).
          _t("Au niveau Données, l'ordre sera celui des données dans le bloc.").'</b>' 
        : '') .
       '<br/>'.
       _t("Cliquez sur croissant/décroissant pour inverser l'ordre des cellules correspondantes. Dans les autres cas, l'ordre par défaut est croissant.").
       '</p>';
  }
  
  /**
   * Retourne la liste des filtres de publication disponibles
   * @return array
   */
  public function getTabFiltrePubli($iFields)
  {
    $tabRes = array();
    $tabField = array(IFIELD_ALAUNE   => array(TASSOC_ALAUNE,     "A la une"), 
                      IFIELD_ARCHIVE  => array(TASSOC_ARCHIVE,    "Archivé"), 
                      IFIELD_PUBLIEE  => array(TASSOC_PUBLIE,     "Publié"),
                    //IFIELD_AVALIDER  => array(TASSOC_AVALIDER,       "Non publié"),
                      IFIELD_SYNDIC   => array(TASSOC_SYNDIC,     "Syndiqué"),
                    //IFIELD_VALIDATION => array(TASSOC_VALIDATION, "En cours de validation")
                      );
    foreach($tabField as $iVal => $tabVal) {
      if( binmask_match($iFields, $iVal) ) {
        if ( binmask_match($this->bloc_typeassoc, $tabVal[0]) && !binmask_match($this->bloc_filtrepub->value, $tabVal[0]) ){
          $this->bloc_filtrepub->value = $tabVal[0];
        }
        $tabRes["".$tabVal[0].""] = $tabVal[1];
      } 
    }
    return $tabRes;
  }
  
  /**
   * Retourne la liste des filtres calendaires disponibles
   * @return array
   */
  public function getTabFiltreCalend($iFields)
  {
    $tabRes = array();
    $tabField = array(IFIELD_DATEPUB    => array(TASSOC_INTERVPUB,   _t("Date de publication")), 
                      IFIELD_DATEINFO   => array(TASSOC_INTERVINFO,  _t("Date de l'information")),
                      IFIELD_DATEMODIF  => array(TASSOC_INTERVMODIF, _t("Date de mise à jour")),
                      IFIELD_30J_PUBLIE => array(TASSOC_30J_PUBLIE,  _t("30 derniers jrs date pub.")),
                      IFIELD_30J_INFO   => array(TASSOC_30J_INFO,    _t("30 derniers jrs date info.")),
                      IFIELD_30J_MODIF  => array(TASSOC_30J_MODIF,   _t("30 derniers jrs date màj."))
                      );
    foreach($tabField as $iVal => $tabVal) {
      if( binmask_match($iFields, $iVal) ) {
        if ( binmask_match($this->bloc_typeassoc, $tabVal[0]) && !binmask_match($this->bloc_filtrecal->value, $tabVal[0]) ){
          $this->bloc_filtrecal->value = $tabVal[0];
        }
        $tabRes["".$tabVal[0].""] = $tabVal[1];
      } 
    }
    return $tabRes;
  }
  
  /**
   * fabrique le bloc des informations attributaires du bloc
   */
  public function addBlocNom($iWidthSelect){
    $iWidthLabel = "130";
    $strDesc     = "";
    $tabTitle = array();
    $oCtrlSelect = null;
        
    $cont_id = AlkRequest::getToken("cont_id", -1);
    $tabTitle = array();
    if (isset($GLOBALS["tabBlocTitle".$cont_id])){
      $tabTitle = $GLOBALS["tabBlocTitle".$cont_id];
    } elseif (isset($GLOBALS["tabBlocTitle"])){
      $tabTitle = $GLOBALS["tabBlocTitle"];
    }
    
    if (!empty($tabTitle)){
      $strDesc = "Vous avez la possibilité de choisir un nom dans la liste des noms prédéfinis";
          // ajout d'un champ combo qui contient la liste des blocs prédéfinis
      $oCtrlSelect = AlkHtmlFactory::getNewHtmlSelect($this, "0", "title", -1, "Noms prédéfinis", 1, $iWidthSelect+28);
      $tabResTitle = array();
      foreach ($tabTitle as $title){
        $tabResTitle[$title]=$title;
      }
      $oCtrlSelect->setProperty("tabValTxt", $tabResTitle);
      
      $oCtrlSelect->addEvent("onchange", "fillBlocNom('".$this->getName()."')");
    }
    $oBlock = $this->addBlock("blockNom", _t("Informations sur le bloc"), $strDesc, $iWidthLabel, $iWidthSelect+220, true);
    
    if ( !is_null($oCtrlSelect)){
      $oBlock->addCtrl($oCtrlSelect);
    }
    $this->addVarJs("tabTitle", json_encode($tabTitle));
    $this->addOnload("initCompletion()");
            
    $blocNom = AlkHtmlFactory::getHtmlText($this->bloc_nom, "Nom", 1, 44, 255);
    $blocNom->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
    $oBlock->addCtrl($blocNom);
  }
}

?>