<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::GEdit
Module gestion éditoriale.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/
//require_once('../../lib/lib_session.php');
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

class AlkPopupListDef extends AlkHtmlForm 
{
  
  /** identifiant de l'espace */
  protected $cont_id;
  /** identifiant de l'application */
  protected $appli_id_gedit;
  /** identifiant de l'utilisateur */
  protected $user_id;

  protected $dataTitle;
  /** identifiant de l'id du champ input ou on enregistre l'url */
  protected $ctrlUrl;
  /** identifiant de l'id du champ input ou on enregistre le link id */
  protected $ctrlLinkId;
  
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formListurlDef"); 
   

    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
    $this->appli_id_gedit = AlkRequest::getToken("appli_id_gedit", -1);
    $this->cont_id = AlkRequest::getToken("cont_id", -1);
    $this->user_id = AlkFactory::getsProperty("user_id", ALK_USER_ID_INTERNET);
    $this->ctrlUrl = AlkRequest::_REQUEST("ctrlUrl", AlkRequest::getToken("ctrlUrl", "-1")); // ctrl du bloc de saisie d'url'
    $this->ctrlLinkId = AlkRequest::_REQUEST("ctrlLinkId", AlkRequest::getToken("ctrlLinkId", "-1")); // ctrl du bloc de saisie d'url'

    //ALK_ATYPE_ID_GLOS
    // paramétrage du popup
    $this->atypeIdBloc    = AlkRequest::getToken("atypeIdBloc", "66");
    $this->iFilterSpace   = AlkRequest::getToken("iFilterSpace", $this->cont_id);
    $this->iAssocCat      = AlkRequest::getToken("iAssocCat", 0);
    $this->catTableName   = AlkRequest::getToken("catTableName", "");
    $this->dataTableName  = AlkRequest::getToken("dataTableName", "v_gedit_iedit_data");
    $this->dataTitle      = AlkRequest::getToken("dataTitle", "Article");
    $this->catTitle       = AlkRequest::getToken("catTitle", "");   

    $this->strParam = 
      "&atypeIdBloc=".$this->atypeIdBloc.
      "&iFilterSpace=".$this->iFilterSpace.
      "&iAssocCat=".$this->iAssocCat.
      "&catTableName=".$this->catTableName.
      "&dataTableName=".$this->dataTableName.
      "&dataTitle=".$this->dataTitle.
      "&catTitle=".$this->catTitle;

    if( $this->atypeIdBloc == ALK_ATYPE_ID_GEOLOC ) {
      $tabATypeIdBloc = array(ALK_ATYPE_ID_ACTU/*, ALK_ATYPE_ID_FDOC*/);
    } else {
      $tabATypeIdBloc = array($this->atypeIdBloc);
    }


    $strATypeIdAppli = "";
    foreach($tabATypeIdBloc as $atypeIdBloc) {
      $strATypeIdAppli .= ($strATypeIdAppli != "" ? "," : "").AlkFactory::getMasterATypeId($atypeIdBloc);
    }
    $this->atypeIdAppli = $strATypeIdAppli;

  }
  /**
   * @brief Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) 
  {

    $default_ordre = AlkRequest::getDecodeParam("default_ordre", "");
    $this->cont_id_filter = AlkRequest::_POSTint("cont_id_filter", AlkRequest::getToken("cont_id", "-1"));
    $this->strDataIdList = AlkRequest::getDecodeParam("dil", "");
    $this->bloc_typeassoc = AlkRequest::getDecodeParam("typeassoc", TASSOC_EMPTY);
    
    $this->cont_id_filter   = new AlkFormData($this, "cont_id_filter",  $this->cont_id_filter,  ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->appli_id_filter  = new AlkFormData($this, "appli_id_filter", "-1",                   ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->cat_id_filter    = new AlkFormData($this, "cat_id_filter",   "-1",                   ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);

    $this->bloc_ordre       = new AlkFormData($this, "bloc_ordre",      $default_ordre,         ALK_SQL_TEXT); // champ caché pour enregistrer le calcul js de bloc_ordre
    $this->iFieldsPage    = AlkRequest::getToken("iFieldsPage", 0);

  }
  /**
   * @brief Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  { 
    $this->setData(ALK_INIT_MODE_REQUEST); 
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);  
    $bWindow = false;
    $bloc_typeassoc = TASSOC_EMPTY;
    $iColumn = "0";

 switch( $this->iMode ) {
    case "4": // sélection d'un espace : modif liste appli, liste cat vide
      $cont_id_filter = AlkRequest::_GETint("idc", "-1");
      $tabRes = array();

      // liste des appli de l'espace de type sélectionné
      $tabRes["tabAppli"] = Array();
      $dsAppli = $oQueryEspace->getDsListAppliBySpaceByATypeIdForCombo($user_id, $cont_id_filter, 66);
      //$dsAppli = $this->oAppli->oQuery->getDsListGlossaireBySpaceByATypeIdForCombo($user_id, $cont_id_filter, 66);
      $nbElt = $dsAppli->getCountTotDr();

      if( $nbElt > 0 ) { 
        $tabRes["tabAppli"][] = array("-1", " Sélectionnez une application");
      } else {
        $tabRes["tabAppli"][] = array("-1", "Aucune accessible dans cet espace");
      }
      while( $drAppli = $dsAppli->getRowIter() ) {
        $idAppli  = $drAppli->getValueName("APPLI_ID");
        $strAppli = $drAppli->getValueName("APPLI_INTITULE");
        $tabRes["tabAppli"][] = array($idAppli, $strAppli);
      }

      // liste des catégories de l'appli
      $tabRes["tabCat"] = Array();
      if( $nbElt > 0 ) { 
        $tabRes["tabCat"][] = array("-1", " Sélectionnez une application");
      } else {
        $tabRes["tabCat"][] = array("-1", "Aucun n'est accessible");
      }

      $tabRes["strHtmlDataList"] = "";

      $oCtrlList = $this->getHtmlDataList("-1", "-1", $user_id, $this->ctrlUrl, $this->ctrlLinkId);
      $tabRes["strHtmlDataList"] = (is_string($oCtrlList) ? $oCtrlList : $oCtrlList->getHtml()); 

      echo json_encode($tabRes);  
      break;
    
     case "5": // sélection d'une appli : modif liste dossier
      $cont_id_filter = AlkRequest::_GETint("idc", "-1");
      $appli_id_filter = AlkRequest::_GETint("ida", "-1");

      $tabRes["tabAppli"] = null;
      // liste des catégories de l'appli
      if( $this->iAssocCat > 0 ) {
        $tabRes["tabCat"] = Array();
        $dsAppli = $this->oAppli->oQuery->getDsListCat($appli_id_filter, $user_id, $this->catTableName);

        $nbElt = $dsAppli->getCountTotDr(); 
        if( $nbElt > 0 ) {
          $tabRes["tabCat"][] = array("-1", " Tous");
        } else {
          $tabRes["tabCat"][] = array("-1", "Aucun n'est accessible");
        }
        while( $drAppli = $dsAppli->getRowIter() ) {
          $idCat  = $drAppli->getValueName("CAT_ID");
          $strCat = $drAppli->getValueName("CAT_INTITULE_FR");
          $tabRes["tabCat"][] = array($idCat, $strCat);
        }
      } else {
        $tabRes["tabCat"] = null;
      }

      $tabRes["strHtmlDataList"] = "";

      $oCtrlList = $this->getHtmlDataList($appli_id_filter, "-1", $user_id, $this->ctrlUrl, $this->ctrlLinkId);
      $tabRes["strHtmlDataList"] = (is_string($oCtrlList) ? $oCtrlList : $oCtrlList->getHtml());; 

      echo json_encode($tabRes);  
      break;
        
    }
  }
  
  /**
   * @brief Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  {
    return _f("Sélectionner un article pour l'affecter au lien");//"Sélectionner une définition du glossaire";
  }
  
    /**
   * @brief Définition du contenu affiché du formulaire
   */
  protected function setContents(){

    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_layer.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_arbre.js");
    $this->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."gedit/lib/alkhtmllistpage.js");
    $this->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."gedit/lib/alkhtmllistdef.js");
    $this->setData(ALK_INIT_MODE_DATAROW);  
    $iWidthSelect = 290;
    $user_id = AlkFactory::getSProperty("user_id", "-1");    
    $this->addBlockDataSelect($user_id, $iWidthSelect+70);
    $this->setTemplate("gedit", "alkhtmlpopupdataselect.tpl");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
  }

  /**
  * bloc contenant les informations sur les espaces, les appli, les catégories et data
  * @param unknown_type $user_id
  * @param unknown_type $iWidthSelect
  */
  private function addBlockDataSelect($user_id, $iWidthSelect)
  {

    $iWidthLabel = "70";
    $strDesc = "Cette configuration prend effet immédiatement sur l'aperçu de la page éditoriale.";  

    $oBlock = $this->addBlock("blockSelect", "Votre sélection", $strDesc, $iWidthLabel, $iWidthSelect, true);
    // récupération des informations présaisies
    $cont_id = -1;
    $appli_id= -1;
    $cat_id  = -1;
    $this->oAppli->oQuery->getBlocContAppliCat($this->bloc_typeassoc, $this->strDataIdList, $this->dataTableName, $this->catTableName, 
                                               $cont_id, $appli_id, $cat_id); // retour par référence
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE); 
    
    // selectionne les espaces accessibles contenant des applis de type atypeIdAppli
    $this->cont_id_filter->value  = ( $cont_id  != -1 ? $cont_id  : $this->cont_id_filter->value );
    $this->appli_id_filter->value = ( $appli_id != -1 ? $appli_id : $this->appli_id_filter->value);
    $this->cat_id_filter->value   = ( $cat_id   != -1 ? $cat_id   : $this->cat_id_filter->value  );
    
    $oCtrlSelectSpace = AlkHtmlFactory::getHtmlSelect($this->cont_id_filter, "Espace", 1, $iWidthSelect);
    $bShow = ( $this->iFilterSpace == "1" );
    if( $bShow ) {
      // recherche si le cont_id_filter appartient bien à la liste, 
      // sinon on le met à jour par rapport à la première valeur de la liste
      $dsCont = $oQueryEspace->getDsListSpaceByATypeIdForCombo($user_id, $this->atypeIdAppli);     
      $iFirstContId = -1; 
      $tabCont = array();
      while( $drCont = $dsCont->getRowIter() ) {
        $idCont = $drCont->getValueName("CONT_ID");
        if( $iFirstContId == -1 ) {
          $iFirstContId = $idCont; 
        }
        $tabCont[$idCont] = $drCont->getValueName("CONT_INTITULE_COURT"); 
      }
      if( !isset($tabCont[$this->cont_id_filter->value]) ) {
        $this->cont_id_filter->value = $iFirstContId;
        $oCtrlSelectSpace->setProperty("value", $this->cont_id_filter->value);
      }
      $oCtrlSelectSpace->setProperty("tabValTxt", $tabCont);
    } else {
      $oCtrlSelectSpace->setProperty("tabValTxtDefault", array("-1", " Tous"));
    }
    $strParam = "cont_id=".$this->oAppli->cont_id."&applitype_id=23&appli_id=-1&iMode=4&ctrlUrl=".$this->ctrlUrl."&ctrlLinkId=".$this->ctrlLinkId."&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_FICHE."&iSSheet=".ALK_SHEET_NONE;    
    $strTokenCombo = AlkRequest::getEncodeParam($strParam);
    $oCtrlSelectSpace->AddEvent("onchange", "onChangeCombo('".$strTokenCombo."')");
    $oCtrlSelectSpace->addonload("onChangeCombo('".$strTokenCombo."')");
    $oCtrlSelectSpace->setHidden(!$bShow);
    $oBlock->addCtrl($oCtrlSelectSpace); 
    
    // sélectionne les applis de type atypeIdAppli accessibles de l'espace sélectionné
    $cont_id_filter = $this->cont_id_filter->value;
    $oCtrlSelectAppli = AlkHtmlFactory::getHtmlSelect($this->appli_id_filter, $this->getAssocLabel($this->bloc_typeassoc, "Application", TASSOC_BYAPPLI), 1, $iWidthSelect);
    $oCtrlSelectAppli->setProperty("tabValTxtDefault", array("-1", " Sélectionnez une application"));
    $bShow = ( $cont_id_filter != "-1" );
    if( $bShow ) {
      $oCtrlSelectAppli->setProperty("oValTxt", $oQueryEspace->getDsListSpaceByATypeIdForCombo($user_id, $cont_id_filter, $this->atypeIdAppli));
      $oCtrlSelectAppli->setProperty("strFieldValue", "APPLI_ID");
      $oCtrlSelectAppli->setProperty("strFieldText", "APPLI_INTITULE");
    }
    $strParam = "cont_id=".$this->oAppli->cont_id."&applitype_id=23&appli_id=-1&iMode=5&ctrlUrl=".$this->ctrlUrl."&ctrlLinkId=".$this->ctrlLinkId."&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_FICHE."&iSSheet=".ALK_SHEET_NONE;    
    $strTokenCombo = AlkRequest::getEncodeParam($strParam);
    $oCtrlSelectAppli->AddEvent("onchange", "onChangeCombo('".$strTokenCombo."')");  
    $oBlock->addCtrl($oCtrlSelectAppli);  
    
        
    $appli_id_filter = $this->appli_id_filter->value;
    $cat_id_filter   = $this->cat_id_filter->value;

    // selectionne les thèmes accessibles
    /*if( $this->iAssocCat > 0 ) {
      $oCtrlSelectCat = AlkHtmlFactory::getHtmlSelect($this->cat_id_filter, $this->getAssocLabel($this->bloc_typeassoc, $this->catTitle, TASSOC_BYCATEG), 1, $iWidthSelect);
      $strParam = "cont_id=".$this->oAppli->cont_id."&applitype_id=20&appli_id=-1&iMode=6&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_FICHE."&iSSheet=".ALK_SHEET_NONE;    
      $strTokenCombo = AlkRequest::getEncodeParam($strParam);
      $oCtrlSelectCat->AddEvent("onchange", "onChangeCombo('".$strTokenCombo."')");
      if( $appli_id_filter != "-1" ) {
        $oCtrlSelectCat->setProperty("tabValTxtDefault", array("-1", " Tous"));
        $oCtrlSelectCat->setProperty("oValTxt", $this->oAppli->oQuery->getDsListCat($appli_id_filter, $user_id, $this->catTableName));
        $oCtrlSelectCat->setProperty("strFieldValue", "CAT_ID");
        $oCtrlSelectCat->setProperty("strFieldText", "CAT_INTITULE_FR");
      } else {
        $oCtrlSelectCat->setProperty("tabValTxtDefault", array("-1", " Sélectionnez une application"));
      }

      if( $this->iAssocCat > 1 ) {
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&iMode=8".$this->strParam);
        $oBtAddCat = AlkHtmlFactory::getHtmlButtonForm("javascript:assoc2Bloc('".$strToken."', 2, false)", "Associer", "Associer cet ensemble au bloc", true);
        $oCtrlSelectCat->addCtrl($oBtAddCat);
      }
      $oBlock->addCtrl($oCtrlSelectCat);
    }*/
    $oTabPage = $this->getHtmlDataList($appli_id_filter, $cat_id_filter, $user_id, $this->ctrlUrl, $this->ctrlLinkId);
    if (!is_string($oTabPage)){
      $this->addPanel($oTabPage);
    }
  }

  /**
   * Marque le label du type d'association actuelle différemment par recherche du masque de label dans le type d'association du bloc
   * @param iTypeAssoc    Type d'association du bloc
   * @param label         Label à afficher
   * @param iMask         Masque du label 
   * @return string - le label marqué ou le label passé en entrée
   */
  private function getAssocLabel($iTypeAssoc, $label, $iLabelMask)
  {
    if ( $iLabelMask!=TASSOC_BYDATA ){
      if ( binmask_match($iTypeAssoc, $iLabelMask) && !binmask_match($iTypeAssoc, TASSOC_BYDATA) ){
        return "<u><b>".$label."</b></u>";
      }
    } else {
      if ( binmask_match($iTypeAssoc, TASSOC_BYDATA) ){
        return "<u><b>".$label."</b></u>";
      }
    }
    return $label;
  }  
  
 /**
   * retourne la liste des données selon l'application, la classification choisies
   * @param $appli_id_filter
   * @param $cat_id_filter
   * @param $user_id
   */
  private function getHtmlDataList($appli_id_filter, $cat_id_filter, $user_id, $ctrlUrl, $ctrlLinkId)
  {
    //url de la page glossaire retrouvée avec le atype =24 dans gedit_page
//    $dsRes = $this->oAppli->oQuery->getDsUrlPageGlossaire();
//    if($drRes = $dsRes->getRowIter()){
//       $page_id = $drRes->getValueName("page_id");
//    }
    AlkFactory::getAppli(ALK_ATYPE_ID_IEDIT);
    $dsPage = $this->oAppli->oQuery->getDsPageByAppliID($this->oAppli->cont_id, $appli_id_filter, $this->oAppli->appli_id);
    $page_id = -1;
    while($drPage = $dsPage->getRowIter()){
      if($cat_id_filter == $drPage->getValueName("page_catid") ){
        $page_id = $drPage->getValueName("page_id");
        break;
      }elseif($page_id == -1){
        $page_id = $drPage->getValueName("page_id");
      }
    }
    
    
    if($page_id != -1){
      $bData=false;
      $tab_data = explode(",", $this->strDataIdList);
      if(($this->bloc_typeassoc & TASSOC_BYDATA) == TASSOC_BYDATA )
      $bData=true;
      $dsResList = $this->oAppli->oQuery->getDsListData($appli_id_filter, $cat_id_filter, $user_id, $this->dataTableName, true, true);
    
      $nbElt = $dsResList->getCountTotDr();
      $iNbEltParPage = $nbElt;
      $strUrlPagine = "";
      $page = 1;
      $oTabPage = AlkHtmlFactory::getHtmlList($this, $nbElt, $page, $iNbEltParPage, false, 
                $strUrlPagine, "Aucune information disponible.");
      $oTabPage->setColumns(array("left",   "465"));
      $oTabPage->setProperty("strTableAlign", "center");
      $oTabPage->addTitleRow($this->getAssocLabel($this->bloc_typeassoc, "Liste des ".$this->dataTitle."s", TASSOC_BYDATA)." (".$nbElt.")" );

      $strUrlPageGlossaire = $this->oAppli->oQuery->getPageUrl($page_id, "");
      $tabDataID= array();
      while( $drResList = $dsResList->getRowIter() ) {
        if(  in_array( $drResList->getValueName("DATA_ID"), $tabDataID ) ) continue;
        $tabDataID[] = $drResList->getValueName("DATA_ID");
        $data_id       = $drResList->getValueName("DATA_ID");
        $data_a_la_une      = $drResList->getValueName("DATA_NEW");
        $valueCheched = (!empty($tab_data) && in_array($data_id, $tab_data) && $bData ? $data_id:-1);
        $data_intitule = $drResList->getValueName(AlkFactory::getDBCurrentLanguageField("DATA_TITRE"));
        $strNom = str_replace("<br/>","",$data_intitule);
        $strNom = ereg_replace( "\"", "'", $strNom);
        //$strNom = ereg_replace( "'", "\'", $strNom);   
        $strUrlDef = "javascript:OpenFile('".$strUrlPageGlossaire."/".$drResList->getValueName("CAT_ID")."_".$drResList->getValueName("DATA_ID")."/".verifyPageName($data_intitule)."','".$ctrlUrl."', '".$drResList->getValueName("DATA_ID")."', '', '".$ctrlLinkId."', ".ALK_LTYPE_ID_IEDIT_PAGE.", ".ALK_ATYPE_ID_IEDIT." )";
        
        $imgAlaUne = '<img class="alkimgicon alkimgiconselected" src="http://qualif.loire-estuaire.org/media/images/transp.gif" alt="à la une" title="à la une" border="0">';
        $strHtml="<a href=\"".$strUrlDef."\" >".($data_a_la_une == 1 ? $imgAlaUne : "").$strNom."</a><br/>";    
        $strUrl = ""; 
        $oTabPage->addRow($strHtml);
      }
      
      return $oTabPage;
    }else{
      return "<div class='txtWarning'>Vous devez préalablement créer une page éditoriale associée à l'application sélectionnée.</div>";
    }
  }  
}
?>
