<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::GEdit
Module gestion éditoriale.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_GEdit
 * @class AlkHtmlFormGEditForm
 * Classe d'affichage de la page de gestion éditoriale 
 */
class AlkHtmlFormGEditForm extends AlkHtmlForm
{
  /** identifiant de la page parente */
  protected $page_parent_id;

  /** controle de saisie */ 
  protected $page_id;
  protected $page_parent;
  protected $page_arbre;
  protected $page_niveau;
  protected $page_racine_droit;
  protected $page_titre;
  protected $page_titre_court;
  protected $page_validepub;
  protected $page_brouillon;
  protected $page_datepub;
  protected $page_datepfin;
  protected $page_rang;
  protected $page_aptypeid;
  protected $page_appliid;
  protected $page_catid;
  protected $page_infotxt;
  protected $page_template;  
  protected $page_repertoire;
  protected $page_visible_menu;
  protected $page_validesynd;  
  protected $page_redirection;
  protected $page_redirection_target;
  protected $page_date_crea;
  protected $page_date_maj;
  protected $page_alias;
  protected $page_public;
  protected $page_titrenav;
  protected $page_motcle;
  protected $page_ordre;
  protected $page_typeassoc;
  protected $page_datedeb;//date de début et de fin des données à sélectionner
  protected $page_datefin;
  protected $right_id;
  protected $page_desc;
  protected $agent_nomcrea;
  protected $agent_nommaj;

  protected $pagepub_date_maj;
  protected $pagepub_validepub;

  protected $tabTypeBloc;
  
  protected $appliId;
  protected $contID;
  protected $tableNamePj;
  protected $strDirUpload;
  protected $page_visuel;
  protected $page_bandeau;
  protected $page_nb_elements;
 
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application associée
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formPage");

    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
    $this->tableNamePj = "GEDIT_PJ";
    $this->appliId = $oAppli->appli_id;
    $this->contID = $oAppli->cont_id;
    $this->page_id = AlkRequest::getToken("page_id", AlkRequest::_GETint("page_id", "-1"));
    $this->strDirUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_GEDIT,true).$this->contID."/";
    
    /** tableau des icones par type de bloc indice = tb[tb_id] */
    $this->tabTypeBloc = array("tb1" => array(true, ALK_ATYPE_ID_EDITEUR, 1, "éditorial", "icon_doc_5.gif"),
                               "tb0" => array(/*!(defined("ALK_B_GEDIT_BLOC_COLONNE") && ALK_B_GEDIT_BLOC_COLONNE==false)*/ false, 
                                              ALK_ATYPE_ID_EDITEUR, 1, "éditorial"/* en colonne*/, "icon_doc_5.gif", 1),
                               "tb2" => array(defined("ALK_B_GEDIT_CARTO") && ALK_B_GEDIT_CARTO == true,
                                              ALK_ATYPE_ID_SIGADMIN, 2, "carto", "icon_doc_83.gif"),
                               "tb3" => array(defined("ALK_B_GEDIT_FDOC") && ALK_B_GEDIT_FDOC == true,
                                              ALK_ATYPE_ID_FDOC, 3, "document", "icon_doc_0.gif"),
                               "tb4" => array(defined("ALK_B_GEDIT_LIEN") && ALK_B_GEDIT_LIEN == true,
                                              ALK_ATYPE_ID_IEDIT, 4, "lien", "icon_doc_6.gif"),
                               "tb5" => array(defined("ALK_B_GEDIT_SYND") && ALK_B_GEDIT_SYND == true,
                                              ALK_ATYPE_ID_SYND, 5, "syndication", "icon_doc_lien.gif"),
                               "tb6" => array(defined("ALK_B_GEDIT_LETTRE") && ALK_B_GEDIT_LETTRE == true,
                                              ALK_ATYPE_ID_LSDIF, 6, "abonnement lettre d'information", "icon_doc_lettre.gif"),
                               "tb7" => array(defined("ALK_B_GEDIT_FORM") && ALK_B_GEDIT_FORM == true,
                                              ALK_ATYPE_ID_FORM, 7, "formulaire/sondage", "icon_doc_formulaire.gif"),
                               /*"tb8" => array(defined("ALK_B_GEDIT_SONDAGE") && ALK_B_GEDIT_SONDAGE == true,
                                              ALK_ATYPE_ID_FORM, 8, "sondage", "icon_doc_sondage.gif"),*/
                               "tb9" => array(defined("ALK_B_GEDIT_ACTU") && ALK_B_GEDIT_ACTU == true,
                                              ALK_ATYPE_ID_IEDIT, 9, "article", "icon_doc_actu.gif"),
                               "tb10" => array(defined("ALK_B_GEDIT_EXPLORER") && ALK_B_GEDIT_EXPLORER == true,
                                               ALK_ATYPE_ID_EXPLORER, 10, "explorateur", "icon_doc_explorer.gif"),
                               "tb11" => array(defined("ALK_B_GEDIT_GLOS") && ALK_B_GEDIT_GLOS == true,
                                               ALK_ATYPE_ID_IEDIT, 11, "glossaire", "icon_doc_glossaire.gif"),
                               "tb13" => array(defined("ALK_B_GEDIT_ANNUECO") && ALK_B_GEDIT_ANNUECO == true,
                                               ALK_ATYPE_ID_ANNU, 13, "annuaire économique", "icon_doc_agenda.gif"),
                               "tb14" => array(defined("ALK_B_GEDIT_COMMPRESS") && ALK_B_GEDIT_COMMPRESS == true,
                                               ALK_ATYPE_ID_IEDIT, 14, "communiqué de presse", "icon_doc_commpress.gif"),
                               "tb15" => array(defined("ALK_B_GEDIT_FAQS") && ALK_B_GEDIT_FAQS == true,
                                               ALK_ATYPE_ID_IEDIT, 15, "faqs/suggestions", "icon_doc_faqs.gif"), 
                               "tb16" => array(true, ALK_ATYPE_ID_GEDIT, 16, "rss", "icon_doc_rss.gif"),
                               "tb17" => array(defined("ALK_B_GEDIT_GEOLOC") && ALK_B_GEDIT_GEOLOC == true,
                                               ALK_ATYPE_ID_GEOLOC, 17, "géolocalisation", "icon_doc_geoloc.gif"),
                               "tb18" => array(defined("ALK_B_GEDIT_FORUM") && ALK_B_GEDIT_FORUM == true,
                                               ALK_ATYPE_ID_FORUM, 18, "forum", "icon_doc_forum.gif"),
                               "tb19" => array(defined("ALK_B_GEDIT_GRAPHE") && ALK_B_GEDIT_GRAPHE == true,
                                               ALK_ATYPE_ID_GRAPHE, 19, "graphe", "icon_doc_graphe.gif"),
                               "tb20" => array(defined("ALK_B_GEDIT_TACHE") && ALK_B_GEDIT_TACHE == true,
                                               ALK_ATYPE_ID_IEDIT, 20, "tâche", "icon_doc_tache.gif"),
                               "tb21" => array(defined("ALK_B_GEDIT_DOC") && ALK_B_GEDIT_DOC == true,
                                               ALK_ATYPE_ID_IEDIT, 21, "document de type éditorial", "icon_doc_fiche_2.gif"),
                               "tb22" => array(defined("ALK_B_GEDIT_EVENT") && ALK_B_GEDIT_EVENT == true,
                                               ALK_ATYPE_ID_IEDIT, 22, "evenement", "icon_doc_fiche_2.gif")
                                               );
  }
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit)
  {
    $user_id = AlkFactory::GetSProperty("user_id", "-1");
    $appli_id = AlkRequest::getToken("appli_id", "-1");
    $idPage = AlkRequest::getToken("page_id", AlkRequest::_GETint("page_id", "-1"));
    if( $idPage=="0" ) {
      $idPage = "-1";
    }
    $this->page_parent_id = AlkRequest::getToken("page_parent_id", "0");

    if( $this->iMode==ALK_FORM_MODE_UPDATE && $idPage=="-1" ) {
      // recherche la première page de l'application, pas de verif de droit
      $idPage = $this->oAppli->oQuery->getFirstPageIdByAppli($appli_id, -1, true);
      $this->page_parent_id = "0";
    }
    if( $idPage == "-1" ) {
      $this->iMode = ALK_FORM_MODE_ADD;
      $this->page_parent_id = "0";
    }

    $this->page_id                 = new AlkFormData($this, "page_id",             $idPage, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->page_titre              = new AlkFormData($this, "page_titre",               "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);
    $this->page_titre_court        = new AlkFormData($this, "page_titre_court",         "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);
    $this->page_datepdeb           = new AlkFormData($this, "page_datepdeb",            "", ALK_SQL_TEXT );
    $this->page_datepfin           = new AlkFormData($this, "page_datepfin",            "", ALK_SQL_TEXT );
    $this->page_parent             = new AlkFormData($this, "page_parent",             "0", ALK_SQL_NUMBER );
    $this->page_racine_droit       = new AlkFormData($this, "page_racine_droit",       "0", ALK_SQL_NUMBER );
    $this->page_niveau             = new AlkFormData($this, "page_niveau",             "0", ALK_SQL_NUMBER );
    $this->page_arbre              = new AlkFormData($this, "page_arbre",            "-0-", ALK_SQL_TEXT );
    $this->page_date_crea          = new AlkFormData($this, "page_date_crea",           "", ALK_SQL_NONE );
    $this->page_date_maj           = new AlkFormData($this, "page_date_maj",            "", ALK_SQL_NONE );
    $this->agent_nomcrea           = new AlkFormData($this, "agent_nomcrea",            "", ALK_SQL_NONE );
    $this->agent_nommaj            = new AlkFormData($this, "agent_nommaj",             "", ALK_SQL_NONE );
    $this->page_aptypeid           = new AlkFormData($this, "page_aptypeid",        "23_0", ALK_SQL_TEXT);
    $this->page_appliid            = new AlkFormData($this, "page_appliid",           "-1", ALK_SQL_NUMBER);
    $this->page_catid              = new AlkFormData($this, "page_catid",             "-1", ALK_SQL_NUMBER);
    $this->page_infotxt            = new AlkFormData($this, "page_infotxt",             "Aucune information sélectionnée", ALK_SQL_NONE);
    $this->page_template           = new AlkFormData($this, "page_template",            "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT);
    $this->page_rang               = new AlkFormData($this, "page_rang",               "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC );
    $this->page_repertoire         = new AlkFormData($this, "page_repertoire",          "", ALK_SQL_TEXT );
    $this->page_validepub          = new AlkFormData($this, "page_validepub",          "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->page_validesynd         = new AlkFormData($this, "page_validesynd",         "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->page_visible_menu       = new AlkFormData($this, "page_visible_menu",       "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC); 
    $this->page_redirection        = new AlkFormData($this, "page_url_redirection",     "", ALK_SQL_TEXT );
    $this->page_redirection_target = new AlkFormData($this, "page_target_redirection", "0", ALK_SQL_NUMBER );
    $this->page_brouillon          = new AlkFormData($this, "page_brouillon",          "",  ALK_SQL_NONE );
    $this->page_public             = new AlkFormData($this, "page_public",             "1", ALK_SQL_NUMBER, ALK_VERIF_CHECK);
    $this->right_id                = new AlkFormData($this, "right_id",                "0", ALK_SQL_NONE );
    $this->page_ordre              = new AlkFormData($this, "page_ordre",              "", ALK_SQL_TEXT );
    $this->page_typeassoc          = new AlkFormData($this, "page_typeassoc",          TASSOC_EMPTY, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC );
    $this->page_datedeb            = new AlkFormData($this, "page_datedeb",            "", ALK_SQL_DATE );
    $this->page_datefin            = new AlkFormData($this, "page_datefin",            "", ALK_SQL_DATE );
    $this->page_nb_elements        = new AlkFormData($this, "page_nb_elements",        "", ALK_SQL_NUMBER );
    
    $this->page_alias    = new AlkFormData($this, "page_alias",    "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);
    $this->page_titrenav = new AlkFormData($this, "page_titrenav", "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);
    $this->page_motcle   = new AlkFormData($this, "page_motcle",   "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);
    $this->page_desc     = new AlkFormData($this, "page_desc",     "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);  
    
    $this->page_visuel        = new AlkFormData($this, "page_visuel",         "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT);
    $this->page_bandeau       = new AlkFormData($this, "page_bandeau",        "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT);
    
    $this->page_redirection_page_id = new AlkFormData($this, "page_redirection_page_id", "-1", ALK_SQL_NUMBER);
    
    $oDrData = null;
    $tabData = array(null);
    $reqMethod = -1;
    if( ($iTypeInit & ALK_INIT_MODE_DATAROW)==ALK_INIT_MODE_DATAROW ) {
      $iData = -1;
      $oDsData = $this->oAppli->oQuery->getPageById($this->page_id->value, $user_id, false);
      if( !($oDrData = $oDsData->GetRowIter()) ) {
        $oDrData = null;
      }
    }
    $this->page_parent_id = ( !is_null($oDrData) && $this->iMode==ALK_FORM_MODE_UPDATE 
                              ? $oDrData->getValueName("PAGE_PARENT") 
                              : $idPage );     

    if( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
    $this->initData($iTypeInit, $oDrData, $reqMethod);

    if( $this->iMode==ALK_FORM_MODE_ADD && ($iTypeInit & ALK_INIT_MODE_REQUEST) != ALK_INIT_MODE_REQUEST) {
      $this->page_parent->value   = $this->page_parent_id;
      $this->page_niveau->value   = $this->page_niveau->value+1;
      $tabTitleValue = array();
      foreach($this->tabLangue as $key => $tabLg) {
        $tabTitleValue[$key] = "";
      }
      $this->page_titre->value = $tabTitleValue;
      $this->page_titre_court->value = $tabTitleValue;
      $this->page_datepdeb->value = "";
      $this->page_datepfin->value = "";
      $this->page_rang->value     = $this->oAppli->oQuery->getNextRang($this->page_id->value);
      $this->page_validepub->value  = "0";
      $this->page_visible_menu->value = "0";
      $this->page_redirection->value  = "";
      $this->page_redirection_target->value = "0";
      $this->page_public->value ="1";
    }
    else if ( $this->iMode==ALK_FORM_MODE_UPDATE && ($iTypeInit & ALK_INIT_MODE_REQUEST) != ALK_INIT_MODE_REQUEST ) {
      $oAppliLink = AlkFactory::getAppli(ALK_ATYPE_ID_LINK);
      if ( $oAppliLink ) {
        $oDsLinks = $oAppliLink->getDsLinks(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $this->page_id->value, -1, -1);
        if ( $oDrLinks = $oDsLinks->getRowIter() ) {
          $this->page_redirection_page_id->value = $oDrLinks->getValueName("DATA_TO_ID");
          $this->page_redirection->value = $oAppliLink->getLink($oDrLinks->getValueName("LINK_ID"), $this->page_redirection->value, array("bWithRootUrl" => false));
        }
      }
    }
    
    foreach($this->tabLangue as $key => $tabLg) {
      if( $this->page_alias->value[$key] == "" ) {
        // si vide, on assure une valeur par défaut aux alias après une création
        $this->page_alias->value[$key] =  verifyPageName($this->page_titre->value[$key]);
        
        // on ne teste pas l'unicité ici, on laisse l'utilisateur géré d'éventuel conflit à la validation
      } else {
        // nettoyage systématique de l'alias
        $this->page_alias->value[$key] =  verifyPageName($this->page_alias->value[$key]);
      }
      if( $this->page_titrenav->value[$key] == "" ) {
        $this->page_titrenav->value[$key] = $this->page_titre->value[$key];
      }
    }
    
    /*if( $this->iMode==ALK_FORM_MODE_UPDATE && $this->page_brouillon->value=="" && 
        ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW) {
      // la page de brouillon n'existe pas, il faut toutes les créer.
      // cette action ne sera faite qu'une seule fois
      // la page brouillon devient la page courante 
      //echo "create draft page ".$this->page_id->value."<br>";
      $this->page_id->value = $this->oAppli->oQueryAction->createDraftPage($this->page_id->value);
    }*/
    
    if( $this->iMode==ALK_FORM_MODE_UPDATE && ($this->page_validepub->value == "2" || $this->right_id->value<ALK_APPLI_RIGHT_ADMIN) ) {
      $this->iMode = ALK_FORM_MODE_READ; 
    }
    
    $this->pagepub_date_maj   = "";
    $this->pagepub_validepub = 0;
    if( $this->page_brouillon->value != "" ) {
      // recherche les infos de publication de la page publiée
      $oDsPub = $this->oAppli->oQuery->getPageById($this->page_brouillon->value, -1);
      if( $oDrPub = $oDsPub->getRowIter() ) {
        $this->pagepub_date_maj   = $oDrPub->getValueName("PAGE_DATE_MAJ");
        $this->pagepub_validepub = $oDrPub->getValueName("PAGE_VALIDEPUB");
      } 
    }
  }

  /**
   * Traitement du formulaire
   */
  public function doSql()
  {
    $user_id  = AlkFactory::GetSProperty("user_id", "-1");
    $cont_id  = AlkRequest::getToken("cont_id", "-1");
    $appli_id = AlkRequest::getToken("appli_id", "-1");
    
    switch( $this->iMode ) {
    case ALK_FORM_MODE_ADD: // ajout d'une page
      $this->setData(ALK_INIT_MODE_REQUEST);
      $page_id = $this->oAppli->oQueryAction->addPage($this->page_titre->value, $this->page_titre_court->value,$this->page_alias->value, 
                                                      $this->page_titrenav->value, $this->page_motcle->value, $this->page_desc->value, 
                                                      $this->page_datepdeb->value, $this->page_datepfin->value, 
                                                      $this->page_rang->value, $this->page_validepub->value, $this->page_parent->value, 
                                                      $this->page_niveau->value, $this->page_arbre->value, $this->page_racine_droit->value, 
                                                      $user_id, $appli_id, $this->page_repertoire->value, $this->page_visible_menu->value, 
                                                      $this->page_redirection->value, $this->page_redirection_target->value,
                                                      $this->page_public->value, $this->page_template->value, $this->page_validesynd->value,
                                                      $this->page_aptypeid->value, $this->page_appliid->value, $this->page_catid->value);
      $page_id_publiee = $page_id;
      $oDsPage = $this->oAppli->oQuery->getPageById($page_id, -1);
      if ( $oDrPage = $oDsPage->getRowIter() ) {
        $page_id_publiee = $oDrPage->getValueName("PAGE_BROUILLON");
      }
      $this->oAppli->createListeAbonnes($page_id_publiee);
      // réaffichage de la page créée en mode modif, le page_id correspond à la page brouillon
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                          "&page_id=".$page_id."&iMode=".ALK_FORM_MODE_UPDATE);
      
      // sauvegarde le lien vers la page de redirection
      if ( $this->page_redirection_page_id->value != -1 ) {
        $oAppliLink = AlkFactory::getAppli(ALK_ATYPE_ID_LINK);
        if ( $oAppliLink ) {
          $oAppliLink->setLink(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $page_id, $this->page_redirection_page_id->value);
        }
      }
      
      break;
    
    case ALK_FORM_MODE_UPDATE: // modification d'une page
      $this->setData(ALK_INIT_MODE_REQUEST); 
      $this->startWorkflow();
      $this->oAppli->oQueryAction->updatePage($appli_id, $this->page_id->value, $this->page_titre->value,$this->page_titre_court->value, 
                                              $this->page_alias->value, $this->page_titrenav->value, $this->page_motcle->value, 
                                              $this->page_desc->value, $this->page_datepdeb->value, 
                                              $this->page_datepfin->value, /*$this->page_rang->value, */
                                              $this->page_validepub->value, $this->page_parent->value, $this->page_racine_droit->value, 
                                              $user_id, $this->page_repertoire->value, $this->page_visible_menu->value, 
                                              $this->page_redirection->value, $this->page_redirection_target->value,
                                              $this->page_public->value, $this->page_template->value, $this->page_validesynd->value,
                                              $this->page_aptypeid->value, $this->page_appliid->value, $this->page_catid->value,
                                              "", 
                                              $this->page_typeassoc->value, $this->page_ordre->value,
                                              $this->page_datedeb->value, $this->page_datefin->value, $this->page_nb_elements->value );

      // réaffichage de la même page en modif
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                          "&page_id=".$this->page_id->value."&iMode=".ALK_FORM_MODE_UPDATE);
      
      // sauvegarde le lien vers la page de redirection
      $oAppliLink = AlkFactory::getAppli(ALK_ATYPE_ID_LINK);
      if ( $oAppliLink ) {
        if ( $this->page_redirection_page_id->value != -1 ) {
          $oDsLinks = $oAppliLink->getDsLinks(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $this->page_id->value, $this->page_redirection_page_id->value, -1);
          if ( $oDsLinks->getCountTotDr() == 0 ) {
            $oAppliLink->delLinks(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $this->page_id->value, -1, -1);
            $oAppliLink->setLink(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $this->page_id->value, $this->page_redirection_page_id->value);
          }
        } else {
          $oAppliLink->delLinks(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $this->page_id->value, -1, -1);
        }
      }
      
      break;
       
    case ALK_FORM_MODE_DEL: // suppression d'une page
      $page_id = AlkRequest::getToken("page_id", "-1");
      $this->page_parent_id = AlkRequest::getToken("page_parent_id", "-1");
      $this->oAppli->delDataAssoc($cont_id, -1, $page_id);
      $this->oAppli->delPage($page_id);

      // retour vers la page parente
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                          "&page_id=".$this->page_parent_id."&iMode=".ALK_FORM_MODE_UPDATE);
      
      // supprime le lien vers la page de redirection
      $oAppliLink = AlkFactory::getAppli(ALK_ATYPE_ID_LINK);
      if ( $oAppliLink instanceof AlkAppliLink) {
        $oAppliLink->delLinks(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $page_id, -1, -1);
      }
      
      break;
        
    case "4": // Ajout d'un bloc
      $page_id = AlkRequest::getToken("page_id", "-1");
      $typeIdBloc  = AlkRequest::_GETint("typeIdBloc", "0");
      $atypeIdBloc = AlkRequest::_GETint("atypeIdBloc", "-1");
      $iColonne    = AlkRequest::_GETint("iColonne", "0");
        
      $bloc_id = $this->oAppli->addGEditBlocInGEdit($page_id, $typeIdBloc, $atypeIdBloc, $iColonne);
    
      // retour ajax du code html de la liste des blocs
      $strHtml = $this->getHtmlBlocContenu($page_id);
      echo $strHtml;
      return "";
      break;

    case "5": // suppression d'un bloc
      $page_id     = AlkRequest::getToken("page_id", "-1");
      $bloc_id     = AlkRequest::getToken("bloc_id", "-1");
      $typeIdBloc  = AlkRequest::getToken("typeIdBloc", "0");
      $atypeIdBloc = AlkRequest::getToken("atypeIdBloc", "-1");

      $this->oAppli->delGEditBloc($page_id, $bloc_id, $typeIdBloc, $atypeIdBloc);

      // retour ajax du code html de la liste des blocs
      $strHtml = $this->getHtmlBlocContenu($page_id);
      echo $strHtml;
      return "";
      break;
        
    case "6": // Changement de rang d'un bloc
      $page_id  = AlkRequest::getToken("page_id", "-1");
      $bloc_id = AlkRequest::getToken("bloc_id", "-1");
      $iDelta  = AlkRequest::getToken("delta", "0");
       
      if( $iDelta=="0" ) return "";

      $this->oAppli->oQueryAction->updateBlocRank($page_id, $bloc_id, $iDelta, $user_id);
       
      // retour ajax du code html de la liste des blocs
      $strHtml = $this->getHtmlBlocContenu($page_id);
      echo $strHtml;
      return "";
      break;
    
    case "7": // déplacer une page
      $page_id              = AlkRequest::_GETint("folderSrc_id",  "-1");
      $page_id_parent_start = AlkRequest::_GETint("folderPrev_id", "-1");
      $page_id_parent_dest   = AlkRequest::_GETint("folderDest_id", "-1");
      $page_id_prev         = AlkRequest::_GETint("pageIdPrev", "-1");
      
      $page_rang_start = $this->oAppli->oQuery->getRangById($page_id);
      $page_rang_end   = $this->oAppli->oQuery->getRangById($page_id_prev);
      
      // opération à effectuer
      $strOp = AlkRequest::_GET("op", "cut");

      if( $strOp == "cut" ) {
        if($page_id_parent_dest != $page_id_parent_start){
          $this->oAppli->oQueryAction->movePage($page_id, $page_id_parent_dest);
          //trace ajax pour décider du rafraichissement
          echo "cut";
        }
        $this->oAppli->oQueryAction->updatePageRang($page_id, $page_id_parent_start, $page_id_parent_dest, $page_rang_start, $page_rang_end);
      } elseif( $strOp == "copy" ) {
        // non implémenté
        //$this->oAppli->oQueryAction->dupPage($page_id, $page_id_dest);
        // trace ajax pour décider du rafraichissement
        //echo "copy";
      }
      AlkFactory::memCacheFlush(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_GEDIT)."_".$appli_id);
      return "";
      break;

    case "8": // modifier le rang d'une donnée dans un bloc
      $bloc_id        = AlkRequest::getToken("bloc_id", "-1");
      $data_id        = AlkRequest::getToken("data_id", "-1");
      $iDelta         = AlkRequest::getToken("delta", "0");
      $iRank          = AlkRequest::getToken("rank", "1");
      $atypeIdBloc    = AlkRequest::getToken("atypeIdBloc", "-1");
      $data_appliid   = AlkRequest::getToken("data_appliid", "-1");
      $bloc_typeassoc = AlkRequest::getToken("bloc_typeassoc", "0");
      $bloc_ordre     = AlkRequest::getToken("bloc_ordre", "");
      $bloc_datedeb   = AlkRequest::getToken("bloc_datedeb", "");
      $bloc_datefin   = AlkRequest::getToken("bloc_datefin", "");
      $bloc_colonne   = AlkRequest::getToken("bloc_colonne", "0");
      $bloc_limit     = AlkRequest::getToken("bloc_limit", "-1");
      $page_nb_elements     = AlkRequest::getToken("page_nb_elements", "-1");
      
      $this->oAppli->updateDataRankInBloc($bloc_id, $data_id, $iRank, $iDelta, $atypeIdBloc, $data_appliid);
      
      // retour ajax du code html de la liste des données d'un bloc
      $oAppliBloc  = AlkFactory::getAppli($atypeIdBloc);
      $tabContents = $oAppliBloc->getGEditBlocShortContents($bloc_id, $bloc_typeassoc, $atypeIdBloc, 
                                                            $bloc_ordre, $bloc_datedeb, $bloc_datefin, $bloc_limit);
      
      $tabRes = array("bloc_id" => $bloc_id,
                      "html"    => $this->getHtmlBlocShortContent($tabContents, $bloc_id, $atypeIdBloc, $bloc_typeassoc,
                                                                  $bloc_colonne, $bloc_ordre, $bloc_datedeb, $bloc_datefin, $bloc_limit));
      echo json_encode($tabRes);
      return "";
      break;

    case "9": // suppression d'une donnée dans un bloc
      $bloc_id        = AlkRequest::getToken("bloc_id", "-1");
      $data_id        = AlkRequest::getToken("data_id", "-1");
      $data_appliid   = AlkRequest::getToken("data_appliid", "-1");
      $atypeIdBloc    = AlkRequest::getToken("atypeIdBloc", "-1");
      $bloc_typeassoc = AlkRequest::getToken("bloc_typeassoc", "0");
      $bloc_ordre     = AlkRequest::getToken("bloc_ordre", "");
      $bloc_datedeb   = AlkRequest::getToken("bloc_datedeb", "");
      $bloc_datefin   = AlkRequest::getToken("bloc_datefin", "");
      $bloc_colonne   = AlkRequest::getToken("bloc_colonne", "0");
      $bloc_limit     = AlkRequest::getToken("bloc_limit", "-1");
      
      if( ( $bloc_typeassoc & 3) == 3 ) { 
        $this->oAppli->removeDataFromBloc($bloc_id, $data_id, $atypeIdBloc, $data_appliid); 
      } elseif( ( $bloc_typeassoc & 2) == 2 ) { 
        $this->oAppli->removeCatFromBloc($bloc_id, $data_id, $atypeIdBloc, $data_appliid); 
      } else { 
        $this->oAppli->removeAppliFromBloc($bloc_id, $data_id, $atypeIdBloc, $data_appliid); 
      }
      
      //retour ajax du code html de la liste des données d'un bloc
      $oAppliBloc  = AlkFactory::getAppli($atypeIdBloc);
      $tabContents = $oAppliBloc->getGEditBlocShortContents($bloc_id, $bloc_typeassoc, $atypeIdBloc,
                                                            $bloc_ordre, $bloc_datedeb, $bloc_datefin, $bloc_limit);
      
      $tabRes = array("bloc_id" => $bloc_id,
                      "html"    => $this->getHtmlBlocShortContent($tabContents, $bloc_id, $atypeIdBloc, $bloc_typeassoc,
                                                                  $bloc_colonne, $bloc_ordre, $bloc_datedeb, $bloc_datefin, $bloc_limit));
      echo json_encode($tabRes);
      return "";
      break;
      
    case "10": // réactualise le contenu d'un bloc uniquement
      $bloc_id        = AlkRequest::getToken("bloc_id", "-1");
      $atypeIdBloc    = AlkRequest::getToken("atypeIdBloc", "-1");
      $bloc_typeassoc = AlkRequest::getToken("bloc_typeassoc", "0");
      $bloc_ordre     = AlkRequest::getToken("bloc_ordre", "");
      $bloc_datedeb   = AlkRequest::getToken("bloc_datedeb", "");
      $bloc_datefin   = AlkRequest::getToken("bloc_datefin", "");
      $bloc_colonne   = AlkRequest::getToken("bloc_colonne", "0");
      $bloc_limit     = AlkRequest::getToken("bloc_limit", "-1");
      
      $dsBloc = $this->oAppli->oQuery->getDsBlocById($bloc_id);
      $strBlocTitre = "";
      if ($drBloc = $dsBloc->getRowIter()){
        $strBlocTitre   = $drBloc->getValueName(AlkFactory::getDBCurrentLanguageField("BLOC_NOM"));
      }

      $oAppliBloc  = AlkFactory::getAppli($atypeIdBloc);
      $tabContents = $oAppliBloc->getGEditBlocShortContents($bloc_id, $bloc_typeassoc, $atypeIdBloc,
                                                            $bloc_ordre, $bloc_datedeb, $bloc_datefin, $bloc_limit);
      if ($atypeIdBloc == ALK_ATYPE_ID_EDITEUR) {
        $strHtml = $tabContents[0]["data_desc"];
      } else {
        $strHtml = $this->getHtmlBlocShortContent($tabContents, $bloc_id, $atypeIdBloc, $bloc_typeassoc,
                                                  $bloc_colonne, $bloc_ordre, $bloc_datedeb, $bloc_datefin, $bloc_limit);
      }
      $tabRes = array("bloc_id" => $bloc_id,
                      "titre"   =>  ($strBlocTitre != "" ? "Titre du bloc : <b>".$strBlocTitre."</b>" : "").
                      ($bloc_colonne == 1 ? ($strBlocTitre != "" ? "<br/>" : "")."<i>Affichage en colonne</i>" : ""),
                      "html"    => $strHtml); 
      
      echo json_encode($tabRes);
      return "";
      break;
      
    case "11": // publier
      $cont_id   = AlkRequest::getToken("cont_id", "-1");
      $page_id = AlkRequest::getToken("page_id", "-1"); // page brouillon
      $this->setData(ALK_INIT_MODE_REQUEST);
      $this->oAppli->oQueryAction->updatePage($appli_id, $this->page_id->value, $this->page_titre->value, $this->page_titre_court->value,
                                              $this->page_alias->value, $this->page_titrenav->value, $this->page_motcle->value, 
                                              $this->page_desc->value, $this->page_datepdeb->value, 
                                              $this->page_datepfin->value, /*$this->page_rang->value, */
                                              $this->page_validepub->value, $this->page_parent->value, $this->page_racine_droit->value, 
                                              $user_id, $this->page_repertoire->value, $this->page_visible_menu->value, 
                                              $this->page_redirection->value, $this->page_redirection_target->value,
                                              $this->page_public->value, $this->page_template->value, $this->page_validesynd->value,
                                              $this->page_aptypeid->value, $this->page_appliid->value, $this->page_catid->value,
                                              $this->page_brouillon->value, 
                                              $this->page_typeassoc->value, $this->page_ordre->value,
                                              $this->page_datedeb->value, $this->page_datefin->value, $this->page_nb_elements->value );
      
      // sauvegarde le lien vers la page de redirection
      $oAppliLink = AlkFactory::getAppli(ALK_ATYPE_ID_LINK);
      if ( $oAppliLink ) {
        if ( $this->page_redirection_page_id->value != -1 ) {
          $oDsLinks = $oAppliLink->getDsLinks(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $this->page_id->value, $this->page_redirection_page_id->value, -1);
          if ( $oDsLinks->getCountTotDr() == 0 ) {
            $oAppliLink->delLinks(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $this->page_id->value, -1, -1);
            if ( $this->page_redirection_page_id->value != -1 ) {
              $oAppliLink->setLink(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $this->page_id->value, $this->page_redirection_page_id->value);
            }
          }
        } else {
          $oAppliLink->delLinks(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $this->page_id->value, -1, -1);
        }
      }
      
      $this->oAppli->publishRestoreDraftPage(AlkFactory::getUploadPath(ALK_ATYPE_ID_GEDIT).$this->contID."/", $page_id);
      
      $this->publishCommentaire();
      
      echo getBodyOnLoadExec("alkAlert(\"La page est publiée.\");");
      return "";
      break;

    case "12": // restaurer
      $page_id = AlkRequest::getToken("page_id", "-1");
      $this->oAppli->publishRestoreDraftPage(AlkFactory::getUploadPath(ALK_ATYPE_ID_GEDIT).$this->contID."/", $page_id, false);
      
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                          "&page_id=".$page_id."&iMode=".ALK_FORM_MODE_UPDATE);
      break;

    case "13": // dépublier
      $page_id_pub = AlkRequest::getToken("page_id", "-1");
      $this->oAppli->oQueryAction->unpublishPage($page_id_pub, $appli_id);

      echo getBodyOnLoadExec("alkAlert(\"La page a été retirée de la publication.\");");
      return "";
      break;
    
    case "14": // test l'unicite de l'intitule url (page_alias_[fr|uk])
      $page_id = AlkRequest::_GET("page_id", "-1");
      $page_alias = array();
      foreach($this->tabLangue as $key => $tabLg) {
        $page_alias[$key] = verifyPageName(AlkRequest::_GET("page_alias".strtolower($tabLg["bdd"]), ""));
      }
      $bUnique = $this->oAppli->oQuery->isPageAliasUnique($page_id, $page_alias);
      
      echo ( $bUnique ? "1" : "0" );
      return "";
      break;
    
    case "15": // met à jour la liste des templates en fonction du type de page
      $aptype_id = AlkRequest::_GET("aptid", "23_0");
      $tabFiles = $this->getPageTemplate($aptype_id);
      $strJsHtml = " tabOptions = new Array();";
      if( count($tabFiles) > 0 ) {
        $strJsHtml .= " tabOptions[0] = new Array('', 'Sélectionnez un modèle');";
        foreach($tabFiles as $strPathFile => $strFile) {
          $strJsHtml .= " tabOptions[tabOptions.length] = new Array('".$strPathFile."', '".$strFile."');";
        }
      } else {
        $strJsHtml .= " tabOptions[0] = new Array('', 'Aucun modèle disponible');";
      }
      
      // détermine le token pour ouvrir la sélection d'information
      $strJsHtml .= " var strTokenSelectValue = '".$this->getTokenSelectInfo($aptype_id)."';";
      
      $tabATypeId = explode("_", $aptype_id);
      $atypeIdBloc = $tabATypeId[0]; 
      $strJsHtml .= " var atype_id = '".$atypeIdBloc."';";
      
      // flux ajax
      echo $strJsHtml;
      return "";
    }
    return ALK_ALKANET."?token=".$strToken;
  }
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);	

    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $appli_id = AlkRequest::getToken("appli_id", "-1");
    
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $user_priv = AlkFactory::getSProperty("user_priv", "0");
    $user_right = AlkFactory::getSProperty("user_right", ALK_APPLI_RIGHT_NONE);
    $this->addScriptCss("../".ALK_ROOT_MODULE."gedit/templates/gedit.css");

    $page_id  = $this->page_id->value;
    
    //$this->activateComment("GEDIT_01_PAGE", "PAGE_ID", $this->page_id->value);
    
    $this->getBlockArbo($page_id);

    if( $this->iMode == ALK_FORM_MODE_UPDATE || $this->iMode == ALK_FORM_MODE_READ ) {
      /*if( defined("ALK_B_GEDIT_REFINTERNET") && ALK_B_GEDIT_REFINTERNET==true ) {
        $strTitle = "/".$this->oAppli->oQuery->getPageUrl($this->page_id->value, "", false);
      } else {*/
        $strTitle = $this->page_titre->value[ALK_LG];
      //}
      /** définition des onglets */
      $oPanelSheet = AlkHtmlFactory::getHtmlPanel("_formPage", "<div class='txtTitlePage left'>".$strTitle."</div>");
      $oPanelSheet->setIsStyleTitle(false);
      $this->addPanel($oPanelSheet);
      
      $oSheetPage = $oPanelSheet->addSheet("sheetPage", _t("Contenu de la page"));
      $oSheetProp = $oPanelSheet->addSheet("sheetProp", _t("Propriétés"));
      
      $this->getBlockForm($oSheetProp, $page_id);
      
      if( $this->iMode == ALK_FORM_MODE_UPDATE ) {
        $this->getBlockCommentaire($oSheetProp);
        $this->getBlockWorkflow($oSheetProp);
      }

      $this->getBlockMeta($oSheetProp);

      if( ALK_B_GEDIT_RIGHT_BY_ANIM_ONLY==true && ($user_priv & ALK_PRIV_SPACE_ADMIN)==ALK_PRIV_SPACE_ADMIN || 
          ALK_B_GEDIT_RIGHT_BY_ANIM_ONLY== false && $user_right > ALK_APPLI_RIGHT_ADMIN ) {
        $oSheetRight = $oPanelSheet->addSheet("sheetRight", "Droits");
        $oSheetRight->setTemplate("gedit", "alkhtmlsheetright.tpl");
        
        list($oBlockPublic, $oBlockRight) = $this->getRightPanel($page_id, false);
        $oSheetRight->addPanel($oBlockPublic);
        $oBlockRight->enableBlock("", "", "100", "270", false);
        $oSheetRight->addPanel($oBlockRight);
      }
      if( defined("ALK_B_GEDIT_REFINTERNET") && ALK_B_GEDIT_REFINTERNET==true ) {
        $oSheetRefInternet = $oPanelSheet->addSheet("sheetRefInternet", _t("Référencement"));
        $oBlockRefInternet = $this->getRefInternetPanel($page_id);
        $oSheetRefInternet->addPanel($oBlockRefInternet);
      }
      if( defined("ALK_B_GEDIT_RSS") && ALK_B_GEDIT_RSS==true ) {
        $oSheetRss = $oPanelSheet->addSheet("sheetRss", _t("Flux RSS"));
        $oBlockRss = $this->getRssPanel($page_id);
        $oSheetRss->addPanel($oBlockRss);
      }
    
      $this->getBlockPage($oSheetPage, $page_id);
      $this->setTemplate("gedit", "alkhtmlformgeditform_maj.tpl");
    } 
    else {
      $this->getBlockForm($this, $page_id);
      
      if( ALK_B_GEDIT_RIGHT_BY_ANIM_ONLY==true && ($user_priv & ALK_PRIV_SPACE_ADMIN)==ALK_PRIV_SPACE_ADMIN || 
          ALK_B_GEDIT_RIGHT_BY_ANIM_ONLY== false && $user_right > ALK_APPLI_RIGHT_ADMIN ) {         
        list($oBlockPublic, $oBlockRight) = $this->getRightPanel($page_id);
        $this->addPanel($oBlockPublic);
        $oBlockRight->enableBlock("", "", "100", "305", false);
        $this->addPanel($oBlockRight);
      }
    
      $this->setTemplate("gedit", "alkhtmlformgeditform_add.tpl");
    }
    $bIsPublicator = 0;
    $bIsAnimator = ( ($user_priv & ALK_PRIV_SPACE_ADMIN) == ALK_PRIV_SPACE_ADMIN ? 1 : 0 );
    
    if( defined("ALK_GEDIT_ALL_ADMIN_MOVE_PAGE") && ALK_GEDIT_ALL_ADMIN_MOVE_PAGE == true){
      $bIsPublicator = ( $user_right >= ALK_APPLI_RIGHT_ADMIN ? 1 : 0 );
    }else{
      $bIsPublicator = ( $user_right > ALK_APPLI_RIGHT_ADMIN ? 1 : 0 );
    }
    
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
    $this->addVarJs("bIsAnimator", $bIsAnimator);
    $this->addVarJs("bIsPublicator", $bIsPublicator);
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."gedit/lib/alkhtmlformgeditform.js");
  }

  /** 
   * Construit le block contenant l'ensemble des blocs éditoriaux
   */
  private function getBlockForm($oSheetProp, $page_id)
  {
    $user_right = AlkFactory::getSProperty("user_right", ALK_APPLI_RIGHT_NONE);

    $iSelectWidth = 280;
    $iTxtWidth    = 37;
    $iMemoHeight  = 8;
    $iMemoWidth   = 35;
    
    $strTitrePrincipal = ( $this->iMode == ALK_FORM_MODE_ADD
                           ? ( $this->page_parent_id != "0"
                               ? _t("Création d'une page fille")
                               : _t("Création d'une page racine") )
                           : ( $this->iMode == ALK_FORM_MODE_UPDATE
                               ? _t("Modification des propriétés de la page")
                               : _t("Propriétés de la page") ));
    
    $oBlockProp = $oSheetProp->addBlock("blockProp", $strTitrePrincipal, "", 120, $iSelectWidth+5, true, $this);

    $oCtrlH = AlkHtmlFactory::getHtmlHidden($this->page_id);
    $oCtrlH->addDataHidden($this->page_parent);
    $oCtrlH->addDataHidden($this->page_arbre);
    $oCtrlH->addDataHidden($this->page_niveau);
    $oCtrlH->addDataHidden($this->page_racine_droit);
    $oCtrlH->addDataHidden($this->page_brouillon);
    $oCtrlH->addDataHidden($this->page_ordre);
    $oCtrlH->addDataHidden($this->page_typeassoc);
    $oCtrlH->addDataHidden($this->page_datedeb);//date de début et de fin des données à sélectionner
    $oCtrlH->addDataHidden($this->page_datefin);

    $oCtrlTitreLng = AlkHtmlFactory::getHtmlText($this->page_titre, _t("Titre Long"), 1, $iTxtWidth, 80);
    $oCtrlTitreLng->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
    if( $this->iMode == ALK_FORM_MODE_ADD ) {
      $oCtrlTitreLng->addEvent("onChange", "onChange(this)");
    }
    $oBlockProp->addCtrl($oCtrlTitreLng);
    
    $oCtrlTitreCourt = AlkHtmlFactory::getHtmlText($this->page_titre_court, _t("Titre court"), 1, $iTxtWidth, 80);
    $oCtrlTitreCourt->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
    $oBlockProp->addCtrl($oCtrlTitreCourt);
    
    $oCtrlDatePDeb = AlkHtmlFactory::getHtmlDate($this->page_datepdeb, _t("Début de publication"), "00/00/0000");
    $oCtrlDatePDeb->addValidator(ALK_VERIF_DATE10);

    $oDatePubFin = AlkHtmlFactory::getHtmlDate($this->page_datepfin, "&nbsp;"._t("Fin pub."), "00/00/0000");
    $oDatePubFin->addValidator(ALK_VERIF_DATE10);
    $oCtrlDatePDeb->addCtrl($oDatePubFin);
    
    $oBlockProp->addCtrl($oCtrlDatePDeb);
    
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    if( defined("ALK_B_GEDIT_NOTIFICATION") && ALK_B_GEDIT_NOTIFICATION==true ) {
      $oAppliLsDif = $oQueryEspace->getAppliBySpace(ALK_ATYPE_ID_LSDIF, $cont_id);
    
      // construit le tableau des informations de la page pour la notification
      $tabInfoNotification = array();
      $tabInfoNotification["Intitulé"]        = array("type" => 1, "value" => $this->page_titre->name.ALK_LG_BDD);
      $tabInfoNotification["URL de la page"]  = array("type" => 0, "value" => $this->oAppli->oQuery->getPageUrl($this->page_id->value, "", true));
    }
    
    if( $user_right == ALK_APPLI_RIGHT_PUBLI && $this->iMode != ALK_FORM_MODE_READ ) {
      $oCtrlPVisible = AlkHtmlFactory::getHtmlCheckbox($this->page_validepub, _t("Page publiée"));
      $oCtrlPVisible->setLabelAfter( $this->pagepub_date_maj != $this->page_date_maj->value
                                     ? " <span class='txtWarning'>"._t("brouillon modifié.")."</span>"
                                     : " "._t("brouillon non modifié.") );
      //$bVisible = ( $user_right == ALK_APPLI_RIGHT_PUBLI && $this->iMode == ALK_FORM_MODE_UPDATE);
      $oCtrlPVisible->setHidden(!($this->iMode == ALK_FORM_MODE_UPDATE));
      if( $this->iMode == ALK_FORM_MODE_UPDATE ) {
        $strTokenPublish = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, "&page_id=".$page_id."&iMode=11");
        $strTokenUnpublish = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, "&page_id=".$this->page_brouillon->value."&iMode=13");
        $strFunctionJs = "onClickPagePublish('".$strTokenPublish."', '".$strTokenUnpublish."')";
        if ( defined("ALK_B_GEDIT_NOTIFICATION") && ALK_B_GEDIT_NOTIFICATION==true ) {
          if( !is_null($oAppliLsDif) ) {
            $strFunctionJs = $oAppliLsDif->getFunctionNotifier($this, "AlkVerifCtrl(document.".$this->name.")", "GEDIT_01_PAGE_LISTE", "PAGE_ID", $this->page_brouillon->value,
                                                               "", $strFunctionJs, $tabInfoNotification);
          }
        }
        $oCtrlPVisible->addEvent("onClick", $strFunctionJs);
      }
    } else {
      $oCtrlH->addDataHidden($this->page_validepub);
      $strHtmlPub = ( $this->pagepub_validepub == 0
                       ? _t("Page non publiée")
                       : _t("Page publiée") ).
        ( $this->page_validepub->value == 2
          ? ", <span class='txtWarning'>"._t("brouillon en cours de validation")."</span>"
          : ( $this->pagepub_date_maj != $this->page_date_maj->value
              ? ", <span class='txtWarning'>"._t("brouillon modifié.")."</span>"
              : ", "._t("brouillon non modifié.") ));
      $oCtrlPVisible = AlkHtmlFactory::getHtml($strHtmlPub, _t("Publication"));
    }
    $oBlockProp->addCtrl($oCtrlPVisible);

    $oCtrlPVSynd = AlkHtmlFactory::getHtmlCheckbox($this->page_validesynd, _t("Page syndiquée"));
    $bVisible = ( $user_right == ALK_APPLI_RIGHT_PUBLI && defined("ALK_B_GEDIT_RSS") && ALK_B_GEDIT_RSS==true );
    $oCtrlPVSynd->setHidden(!$bVisible);
    $oBlockProp->addCtrl($oCtrlPVSynd);
    
    $oCtrlH->addDataHidden($this->page_rang);
    /*
    $oCtrlRang = AlkHtmlFactory::getHtmlText($this->page_rang, _t("Rang"), 1, 5, 3);
    $oCtrlRang->addValidator(ALK_VERIF_INT, 0, 999);
    $oBlockProp->addCtrl($oCtrlRang);*/
    
    $oCtrlRepDroit = null;      
    $oCtrlRepDroit = AlkHtmlFactory::getHtmlText($this->page_repertoire, _t("Répertoire lié (droits)"), 1, 20, 80);
    $bVisible = ALK_B_GEDIT_REPERTOIRE_LIE;
    $oCtrlRepDroit->setHidden(!$bVisible);
    $oBlockProp->addCtrl($oCtrlRepDroit);
    
    $oCtrlVisibleMenu = AlkHtmlFactory::getHtmlCheckbox($this->page_visible_menu, _t("Visible dans le menu"));
    $bVisible = ALK_B_GEDIT_VISIBLE_MENU;
    $oCtrlVisibleMenu->setHidden(!$bVisible);
    $oBlockProp->addCtrl($oCtrlVisibleMenu);
 
    $strTxt = "<div align='center'><i>"._f("Si une adresse de redirection est renseignée ci-dessous,%nlle contenu de la page sera ignoré.", "<br/>")."</i></div>";
    $oCtrlTxt = AlkHtmlFactory::getHtml($strTxt); 
    $oBlockProp->addCtrl($oCtrlTxt, ALK_HTMLFORM_1L1C);
    
    $AppliGedit = AlkFactory::getAppli(ALK_ATYPE_ID_GEDIT);
    if($AppliGedit != null){
      $oCtrlUrl = AlkHtmlFactory::getHtmlText($this->page_redirection, _t("Url de redirection"), 1, 20, 255);
      $oCtrlUrl->addEvent("onChange", "jQuery('#".$this->page_redirection_page_id->name."').val(-1);");
      
      $oCtrlHiddenPageId = AlkHtmlFactory::getHtmlHidden($this->page_redirection_page_id);
      
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_LIST, ALK_SHEET_NONE, "&appli_id_gedit=".$AppliGedit->appli_id."&applitype_id=23&cont_id=".$AppliGedit->cont_id."&ctrlUrl=".$this->page_redirection->name."&ctrlId=".$this->page_redirection_page_id->name."&bWithRootUrl=false");
      $data_select_page = AlkHtmlFactory::getHtmlButtonForm("javascript:OpenWindow('".ALK_ALKANET."?token=".$strToken."', 500, 510, 'liste des pages')", "Parcourir les pages", "trouver l'url de la page ");
    }else{
      $oCtrlUrl = AlkHtmlFactory::getHtmlText($this->page_redirection, _t("Url de redirection"), 1, $iTxtWidth, 255);
    }
    $oCtrlUrl->addValidator(ALK_VERIF_TEXT);
    $oBlockProp->addCtrl($oCtrlUrl);
    if ( !is_null($oCtrlUrl) && isset($data_select_page) && !is_null($data_select_page) ){
      $oCtrlUrl->addCtrl($data_select_page);
      $oCtrlUrl->addCtrl($oCtrlHiddenPageId);
    }
    
    $oCtrlTarget =  AlkHtmlFactory::getHtmlRadio($this->page_redirection_target, _t("Cible de redirection"));
    $oCtrlTarget->AddRadio(0, _t("Même fenêtre"));
    $oCtrlTarget->AddRadio(1, _t("Nouvelle fenêtre")); 
    $oBlockProp->addCtrl($oCtrlTarget);

    $oBlockProp->addCtrl($oCtrlH);
    
    if(ALK_GEDIT_NB_VISUEL > 0 || ALK_GEDIT_NB_VISUEL == -1){
      $page_visuel = AlkHtmlFactory::getHtmlUpload($this->page_visuel, "", $this->tableNamePj, $this->page_id->value, 
                                              ( defined("ALK_B_MEDIA_SHARED") && ALK_B_MEDIA_SHARED ? 
                                                mb_strtolower(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE)) : 
                                                AlkFactory::getModuleName($this->oAppli->atype_id))."/".$this->contID."/visuel/",1,
                                              ( defined("ALK_B_MEDIA_SHARED") && ALK_B_MEDIA_SHARED ? 
                                                mb_strtolower(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE)) : 
                                                AlkFactory::getModuleName($this->oAppli->atype_id))."/".$this->contID."/");
      if ( !is_null($page_visuel) ){
          $page_visuel->setAppli($this->appliId);
          $page_visuel->setNbMaxPj(ALK_GEDIT_NB_VISUEL); 
          $strVisuels = "-";
          $dsPj = $page_visuel->getProperty("dsPJ", null);
          while ( !is_null($dsPj) && ($drPj = $dsPj->getRowIter()) ){
            $strVisuels .= $drPj->getValueName("ID")."-";
          }
          if ( !is_null($dsPj) ) $dsPj->moveFirst();
          //$page_visuel->addHidden("liste_image", $strVisuels);
        }
      $oBlockImage   = $oSheetProp->addBlock("blockImage", _t("Visuel"), "");
      $oBlockImage->addCtrl($page_visuel, ALK_HTMLFORM_1L1C);
    }
    if(ALK_GEDIT_NB_BANDEAU >0 || ALK_GEDIT_NB_BANDEAU == -1){
      $page_bandeau = AlkHtmlFactory::getHtmlUpload($this->page_bandeau, "", $this->tableNamePj, $this->page_id->value, 
                                              ( defined("ALK_B_MEDIA_SHARED") && ALK_B_MEDIA_SHARED ? 
                                                mb_strtolower(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE)) : 
                                                AlkFactory::getModuleName($this->oAppli->atype_id))."/".$this->contID."/visuel/",1,
                                              ( defined("ALK_B_MEDIA_SHARED") && ALK_B_MEDIA_SHARED ? 
                                                mb_strtolower(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE)) : 
                                                AlkFactory::getModuleName($this->oAppli->atype_id))."/".$this->contID."/");
      if ( !is_null($page_bandeau) ){
          $page_bandeau->setAppli($this->appliId);
          $page_bandeau->setNbMaxPj(ALK_GEDIT_NB_BANDEAU);
          $strVisuels = "-";
          $dsPj = $page_bandeau->getProperty("dsPJ", null);
          while ( !is_null($dsPj) && ($drPj = $dsPj->getRowIter()) ){
            $strVisuels .= $drPj->getValueName("ID")."-";
          }
          if ( !is_null($dsPj) ) $dsPj->moveFirst();
          //$page_bandeau->addHidden("liste_visuels_bandeau", $strVisuels);
        }
      $oBlockBandeau = $oSheetProp->addBlock("blockBandeau", _t("Bandeau"), "");
      $oBlockBandeau->addCtrl($page_bandeau, ALK_HTMLFORM_1L1C);
    }
    // en mode ajout, le bloc n'apparaît pas s'il n'est pas ajouté dans le template
    $this->getBlockAbonnement($oSheetProp);
    
    $strTokenUniq = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, "&iMode=14");
    if( $this->page_validepub->value!=2 && $user_right==ALK_APPLI_RIGHT_PUBLI ) {
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, "&page_id=".$page_id."&iMode=11");
      $strFunctionJs = "Publier('".$strToken."', '".$strTokenUniq."');";
      if ( defined("ALK_B_GEDIT_NOTIFICATION") && ALK_B_GEDIT_NOTIFICATION==true ) {
        if( !is_null($oAppliLsDif) ) {
          $strFunctionJs = "Publier('".$strToken."', '".$strTokenUniq."',1);";
          $strFunctionJs = $oAppliLsDif->getFunctionNotifier($this, "AlkVerifCtrl(document.".$this->name.")", "GEDIT_01_PAGE_LISTE", "PAGE_ID", $this->page_brouillon->value, 
                                                             "", $strFunctionJs, $tabInfoNotification);
        }
      }
      
      $oButton = $this->addButtonPage("btPublier", "javascript:".$strFunctionJs, _t("Publier"), _t("Publier le brouillon"));
      $this->addSubmitButton($oButton);
    }
    
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, "&page_id=".$page_id."&iMode=12");
    $oButton = $this->addButtonPage("btRestaurer", "javascript:Restaurer('".$strToken."');", _t("Restaurer"), _t("Restaurer le brouillon à partir de la page publiée"));
    $oButton = $this->addSubmitButton($oButton);
    
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, "&page_id=".$page_id."&iMode=".$this->iMode);
    $strFunctionJs = "Validation('".$strToken."', '".$strTokenUniq."');";
    /* pas de notification sur la validation de la page éditoriale
    if ( defined("ALK_B_GEDIT_NOTIFICATION") && ALK_B_GEDIT_NOTIFICATION && $this->iMode != ALK_FORM_MODE_ADD ) {
      if( !is_null($oAppliLsDif) ) {
        $strFunctionJs = $oAppliLsDif->getFunctionNotifier($this, true, "GEDIT_01_PAGE_LISTE", "PAGE_ID", $this->page_brouillon->value, 
                                                           $strFunctionJs, $tabInfo);
      }
    }
    */
    $oButton = $this->addButtonPage("btValid", "javascript:".$strFunctionJs, _t("Valider"), _t("Valider"));
    $this->addSubmitButton($oButton);
    
    if( $this->iMode == ALK_FORM_MODE_UPDATE ) {
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE,
                                          "&page_id=".$page_id."&iMode=".ALK_FORM_MODE_DEL."&page_parent_id=".$this->page_parent_id);
      $strFunctionJs = "Confirmation('".ALK_ALKANET_SQL."?token=".$strToken."', '"._t("Veuillez confirmer la suppression\\nde cette page et de sa sous-arborescence ?")."')";
      if ( defined("ALK_B_GEDIT_NOTIFICATION") && ALK_B_GEDIT_NOTIFICATION==true ) {
        if( !is_null($oAppliLsDif) ) {
          unset($tabInfoNotification["URL de la page"]);
          $strFunctionJs = $oAppliLsDif->getFunctionNotifier($this, "", "GEDIT_01_PAGE_LISTE", "PAGE_ID", $this->page_brouillon->value, 
                                                             "", $strFunctionJs, $tabInfoNotification, array(), true);
        }
      }
      //Si cette page est la page d'accueil ne pas permettre la suppression, si cette page possede une arborescence, la suppression n'est possible que pour un animateur de l'espace courant
      $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
      $user_id = AlkFactory::GetSProperty("user_id", "-1");
      $cont_id  = AlkRequest::getToken("cont_id", "-1");
      $bIsAnimateurOfSpace = $oQueryEspace->userIsAnimateurOfSpace($user_id, $cont_id );
      
      if($this->page_parent_id != 0 && ( $this->oAppli->oQuery->getNbPageFilleByPageId($this->page_id->value) < 1 || $bIsAnimateurOfSpace ) ){
        $this->addButtonPage("btDel", "javascript:".$strFunctionJs, _t("Supprimer"), _t("Supprimer"));  
      }
      $oButton = $this->addButtonPage("btCancel", "javascript:Annuler()", _t("Annuler"), _t("Annuler"));
      if (!is_null($oButton))
        $this->setResetButton($oButton);
    } else {
      // redirection vers la page parente
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                          "&page_id=".$this->page_parent_id."&iMode=".ALK_FORM_MODE_UPDATE);
      $this->addButtonPage("btCancel", ALK_ALKANET."?token=".$strToken, _t("Annuler"), _t("Annuler"));                        
    }
  }
 
  /**
   * Recherche la liste des fichiers templates :
   *  - modèles (dans /scripts/gedit/templates)
   *  - spécifiques (dans ALK_ROOT_TEMPLATE)
   * correspondant au type d'appli et de page sélectionnés
   * Retourne un tableauen un tableau pour le controle de saisie :
   *   value : chemin+fichier
   *   text  : nom du fichier sans le préfixe
   * @param page_aptypeid   chaine contenant atype_id."_".ptype_id
   * @return
   */
  private function getPageTemplate($page_aptypeid)
  {
    $cont_id   = AlkRequest::getToken("cont_id", "-1");

    $strPrefix1 = "alkgedit_".$page_aptypeid."_s_";
    $strPrefix2 = "alkgedit_".$cont_id."_".$page_aptypeid."_s_";
    $tabFiles = getTabFilesByDir(ALK_ALKANET_ROOT_PATH.ALK_ROOT_TEMPLATE, array("tpl"), false, array($strPrefix1, $strPrefix2), false);
    if( empty($tabFiles) ) {
      $strPrefix1 = "alkgedit_".$page_aptypeid."_";
      $strPrefix2 = "alkgedit_".$cont_id."_".$page_aptypeid."_";
      $tabFiles = getTabFilesByDir(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."gedit/templates/", array("tpl"), false, array($strPrefix1, $strPrefix2), false);
    }
    
    $tabRes = array();
    foreach($tabFiles as $strFile => $strPathFile) {
      if (strpos(mb_substr($strFile, 0, -4), $strPrefix2)!== false){
        $tabRes[$strPathFile] = mb_ereg_replace($strPrefix2, "", mb_substr($strFile, 0, -4));
        $tabRes[$strPathFile] = mb_strtoupper(mb_substr($tabRes[$strPathFile], 0, 1)).mb_substr(mb_ereg_replace("_", " ", $tabRes[$strPathFile]), 1);
      } else {
        $tabRes[$strPathFile] = mb_ereg_replace($strPrefix1, "", mb_substr($strFile, 0, -4));
        $tabRes[$strPathFile] = mb_strtoupper(mb_substr($tabRes[$strPathFile], 0, 1)).mb_substr(mb_ereg_replace("_", " ", $tabRes[$strPathFile]), 1);        
      } 
    }
    asort($tabRes);
    
    return $tabRes;
  }
 
  /**
   * Retourne le token nécessaire à l'ouverture de la popup pour sélectionner l'application
   * et éventuellement la catégorie pour le type d'appli et de page sélectionnés
   * @param page_patypeid  chaine contenant les identifiants type d'application et type de page séparés par un _
   * @return string
   */
  private function getTokenSelectInfo($page_aptypeid)
  {
    $tabATypeId = explode("_", $page_aptypeid);
    $atypeIdBloc = $tabATypeId[0]; 
    $oAppliBloc    = AlkFactory::getAppli($atypeIdBloc);
    $tabTypeUpdate = $oAppliBloc->getGEditBlocTypeUpdate(-1, $atypeIdBloc);
    return $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE,
                                   "&bloc_id=-1".
                                   "&iColumn=0". //$tabTypeUpdate["iColumn"].
                                   "&isForBloc=0".
                                   "&atypeIdBloc=".$atypeIdBloc.
                                   "&iFilterSpace=".$tabTypeUpdate["iFilterSpace"].
                                   "&iAssocAppli=".( isset($tabTypeUpdate["iAssocAppliPage"]) ? $tabTypeUpdate["iAssocAppliPage"] : $tabTypeUpdate["iAssocAppli"] ).
                                   "&iAssocCat=".$tabTypeUpdate["iAssocCat"].
                                   "&catTableName=".$tabTypeUpdate["catTableName"].
                                   "&dataTableName=".$tabTypeUpdate["dataTableName"].
                                   "&catTitle=".$tabTypeUpdate["catTitle"].
                                   "&dataTitle=".$tabTypeUpdate["dataTitle"].
                                   "&iFields=".$tabTypeUpdate["iFields"].
                                   "&iFieldsPage=".$tabTypeUpdate["iFieldsPage"]);
  }
 
  /**
   * Construit le block gestion de page
   */  
  private function getBlockPage($oSheetPage, $page_id)
  {
    $user_id    = AlkFactory::getSProperty("user_id", "-1");
    $user_right = AlkFactory::getSProperty("user_right", ALK_APPLI_RIGHT_NONE);
    $cont_id   = AlkRequest::getToken("cont_id", "-1");
    $appli_id   = AlkRequest::getToken("appli_id", "-1");
    $strUrl     = "";
    
  	$oBlockPage = $oSheetPage->addBlock("blockPage", "", "", 140, 280, false, $this);
   
    if( defined("ALK_B_GEDIT_REFINTERNET") && ALK_B_GEDIT_REFINTERNET==true ) {
      $strHtml = "";
      foreach($this->tabLangue as $key => $tabLg) {
        $strUrl = $this->oAppli->oQuery->getPageUrl($this->page_id->value, "", false, $tabLg["bdd"]);
        $strHtml .= ( count($this->tabLangue) > 1 ?"<img class=\"alkimgicon alkimgicondrapeau".strtolower($tabLg["rep"])."\" src=\"".ALK_MEDIA_URL."images/transp.gif\" hspace='1' border=\"0\"/>" : "" ).
          ( $strUrl != "" ? "/". wordwrap($strUrl, 45, "<br/>", true).(trim($this->page_redirection->value)=="" ? "" : "&nbsp;(redirection)") : _t("Non disponible.") )."<br/>";
      }
      $oCtrlUrl = AlkHtmlFactory::getHtml($strHtml, _t("Adresse Internet"));
      $oBlockPage->addCtrl($oCtrlUrl);
    }
       
    $strHtml = "";
    foreach($this->tabLangue as $key => $tabLg) {
      $strUrl = $this->oAppli->oQuery->getPageUrl($this->page_id->value, "", false, $tabLg["bdd"]);
      if( $strUrl!="" ) { 
        // cas du site internet
        // l'aperçu est un lien direct vers la page en mode brouillon
        
        $strRootUrlApercu = ( defined("ALK_ALKANET_ROOT_URL_FRONTOFFICE") 
                              ? ALK_ALKANET_ROOT_URL_FRONTOFFICE
                              : ALK_ALKANET_ROOT_URL ).$strUrl."?mode=brouillon";
        
        $strHtml .= ( trim($this->page_redirection->value)=="" 
                      ? "<a href=\"".$strRootUrlApercu."\" target=\"_blank\">" 
                      : "<a href=\"".$this->page_redirection->value."\" target=\"_blank\">" );
      } else {
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_APERCU, ALK_SHEET_NONE, 
                                            "&page_id=".$page_id."&mode=brouillon&lg=".$tabLg["bdd"]);  
        $strHtml .= ( trim($this->page_redirection->value)==""
                      ? "<a  title='"._t("Voir l'aperçu")." href=\"javascript:OpenApercu('".$strToken."');\">" 
                      : "<a title='"._t("Voir l'aperçu")." href=\"".$this->page_redirection->value."\" target=\"".($this->page_redirection_target->value ? "_blank" : "_self")."\">" );
      }
          
      $strHtml .= "<img class=\"alkimgicon ".( count($this->tabLangue) > 1 ? "alkimgicondrapeau".strtolower($tabLg["rep"]) : "alkimgiconpage")."\" src=\"".ALK_MEDIA_URL."images/transp.gif\" hspace='2' border=\"0\"/></a>";
    }

    $oCtrlApercu = AlkHtmlFactory::getHtml($strHtml, _t("Aperçu"));
    $oBlockPage->addCtrl($oCtrlApercu);

    $oCtrlTypePage = AlkHtmlFactory::getHtmlSelect($this->page_aptypeid, _t("Type de page associée"), 1, 260);
    $oCtrlTypePage->setProperty("tabValTxtDefault", array("23_0", _t("Sélectionnez un type de page")));
    $oCtrlTypePage->setProperty("tabValTxt", $this->oAppli->oQuery->getTabListGeditAppliType($cont_id));
    $strTokenChangeTypePage = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, "&iMode=15");
    $oCtrlTypePage->addEvent("onChange", "onChangePageType('".$strTokenChangeTypePage."')");
    $oBlockPage->addCtrl($oCtrlTypePage);

    $oCtrlH = AlkHtmlFactory::getHtmlHidden($this->page_appliid);
    $oCtrlH->addDataHidden($this->page_catid);
    $oCtrlH->addHidden("dataIdListPage",
      AlkRequest::getEncodeParam(
        ( binmask_match($this->page_typeassoc->value, TASSOC_BYAPPLI)
          ? $this->page_appliid->value
          : ( binmask_match($this->page_typeassoc->value, TASSOC_BYCATEG)
              ? $this->page_catid->value
              : -1 ) ) )
    );
    $oCtrlH->addHidden("page_infoToken", $this->getTokenSelectInfo($this->page_aptypeid->value)); 
    $oCtrlH->addDataHidden($this->page_nb_elements); 
    $oBlockPage->addCtrl($oCtrlH);
    $oBtMaj = AlkHtmlFactory::getHtmlButtonForm("javascript:OpenDataSelectPageType()", _t("Sélectionner"), _t("Sélectionner une information"), true);
    
    $tabATypeId = explode("_", $this->page_aptypeid->value);
    $page_atypeid = $tabATypeId[0];
    
    $bDisabled = ( $page_atypeid == ALK_ATYPE_ID_GEDIT );
    if( $bDisabled ) {
      $this->page_infotxt->value = _t("Aucune information sélectionnable");
    } elseif( $this->page_appliid->value != "-1" ) {
      $this->page_infotxt->value = $this->oAppli->oQuery->getAppliCatName($page_atypeid, $this->page_appliid->value, $this->page_catid->value);
    }
    $oCtrlInfo = AlkHtmlFactory::getHtmlText($this->page_infotxt, _t("Information associée"), 1, 23, 255);
    $oCtrlInfo->setReadOnly(true);
    $oCtrlInfo->setDisabled($bDisabled);
    if( $this->iMode != ALK_FORM_MODE_READ ) {
      $oCtrlInfo->addCtrl($oBtMaj);
    }
    $oBlockPage->addCtrl($oCtrlInfo);
    
    $oCtrlTmplPage = AlkHtmlFactory::getHtmlSelect($this->page_template, _t("Modèle de page"), 1, 260);
    $oCtrlTmplPage->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
    $tabFileTpl = $this->getPageTemplate($this->page_aptypeid->value);
    $oCtrlTmplPage->setProperty("tabValTxt", $tabFileTpl);
    $oCtrlTmplPage->setProperty("tabValTxtDefault", array("", _t("Sélectionnez un modèle")));
    $oBlockPage->addCtrl($oCtrlTmplPage);
    
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, "&page_id=".$page_id."&iMode=4");
    $strHtmlAddBloc = "";
    foreach( $this->tabTypeBloc as $key => $tabTypeBloc) {
      if( $tabTypeBloc[0] ) {
        // à voir getHtmlButtonIcon ou img à la place de getHtmlButtonForm et des addbutton?
        $strIcon = str_replace("icon_", "", strtolower(substr($tabTypeBloc[4], 0, -4)));
        
        $oBt = AlkHtmlFactory::getHtmlButtonIcon("javascript:AddBloc('".$strToken."', ".$tabTypeBloc[2].", ".$tabTypeBloc[1].
                                                ( count($tabTypeBloc)>5 ? ", ".$tabTypeBloc[5] : "" ).");", 
                                                $strIcon, $tabTypeBloc[3]);
        $strHtmlAddBloc .= $oBt->getHtml()."&nbsp;&nbsp;";
      }
    }

    if( $this->iMode == ALK_FORM_MODE_READ ) return;

    $oCtrlAddBloc = AlkHtmlFactory::getHtml($strHtmlAddBloc, _t("Ajouter un bloc de type :"));
    $oBlockPage->addCtrl($oCtrlAddBloc);
    
    $strHtml = $this->getHtmlBlocContenu($page_id);
    $oCtrlBlocContenu = AlkhtmlFactory::getHtml($strHtml);
    $oBlockPage->addCtrl($oCtrlBlocContenu, ALK_HTMLFORM_1L1C);
  }

  /**
   * Construit le block contenant 
   */
  private function getBlockMeta($oSheetProp)
  {
    $iSelectWidth = 280;

    $strHtml = ( $this->page_date_crea->value != ""
                 ? _f("Créé le %s par %s", $this->page_date_crea->value,$this->agent_nomcrea->value)."<br/>".
                 ( $this->page_date_maj->value != ""
                   ? _f("Modifié le %s par %s", $this->page_date_maj->value, $this->agent_nommaj->value)
                   : "" )
                 : "" );
    $oCtrlDate = AlkHtmlFactory::getHtml($strHtml);

    $oBlockMeta =& $oSheetProp->addBlock("blockMeta", _t("Méta-information"), "",  "120", $iSelectWidth+5, false, $this);
    $oBlockMeta->addCtrl($oCtrlDate, ALK_HTMLFORM_1L1C);
  }

  /** 
   * Construit le block contenant l'ensemble des blocs éditoriaux
   */
  private function getBlockArbo($page_id)
  {
    $user_id  = AlkFactory::getSProperty("user_id", "-1");
    $user_right = AlkFactory::getSProperty("user_right", ALK_APPLI_RIGHT_NONE);
    $appli_id = AlkRequest::getToken("appli_id", "-1");
    
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_layer.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_treeview.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery.treeview.js");
    $this->addScriptCss("../".ALK_ROOT_CLASSE."form/treeview.css");

    $dsNoeud = $this->oAppli->oQuery->getArboAutorise($user_id, $appli_id);
    $nbNoeud = $dsNoeud->getCountTotDr();
    $iHeightLimit = ( $user_right >= ALK_APPLI_RIGHT_ADMIN ? 250 : 400 );
    $iWidth = 305;
    
    //$strHtml = "<div id='layerArbre' style='width:".($iWidth-5)."px;".( $nbNoeud*17 > $iHeightLimit ? "overflow:auto; height:".$iHeightLimit."px" : "" )."'>&nbsp;</div>";
    $strHtml = "<div id='layerArbre' style='width:".($iWidth-5)."px;'>&nbsp;</div>";
    $oCtrlHtml = AlkHtmlFactory::getHtml($strHtml); 

    $strHtmlJs =  "var objTreeview = null; ".
      " function AffTreeview() { ".
      "   objTreeview = new Treeview(document, 'layerArbre', 0); ".
      "   var strUrl = \"javascript:updatePage(\";".
      "   var strUrlStart = \" <a title='Ajouter une page fille' href='javascript:addPage(\";".
      "   var strUrlEnd = \")'><img class='alkimgicon alkimgiconpageadd' src='".ALK_MEDIA_URL."images/transp.gif' alt='"._t("Ajouter une page fille")."' border='0'/></a>\";";
    //  "   objTreeview.AddFolder(\"_0\", \"_\", \"Gestion éditoriale\", -1, 0, 1, \"\", \"\");";  
    $strJsonEncode = '["_0", "_", "Gestion éditoriale", -1, 0, 1, "", ""]';   
      
    $strArbre = "";
    
    $idRoot = "0";
    while( $drNoeud = $dsNoeud->getRowIter() )  {
      $idFils = $drNoeud->getValueName("PAGE_ID");
      $idRoot = ( $idRoot == "0" ? $idFils : $idRoot );
      $idPere = $drNoeud->getValueName("ID_PERE");
      $iNiv   =  $drNoeud->getValueName("NIV")-1;
      $iDroit = $drNoeud->getValueName("RIGHT_ID");
      $iDroitAction = ( $iDroit >= 2 ? 2 : $iDroit );
      $iDroitLink = ( $iDroit >= 2 ? 2 : $iDroit );
      $atype_id   = $drNoeud->getValueName("ATYPE_ID");
            
      $strNom = str_replace("<br/>","",$drNoeud->getValueName(AlkFactory::getDBCurrentLanguageField("NOM")));
      $strNom = preg_replace( "/\"/", "'", $strNom);
      $strNom = preg_replace( "/'/", "\'", $strNom);
      
      /*$strNom .= ( $iDroitAction > 1
                   ? " <a title='Ajouter une page fille' href='javascript:addPage(".$idFils.")'>".
                     "<img class=\"alkimgicon alkimgiconpageadd\" src='".ALK_MEDIA_URL."images/transp.gif' alt='"._t("Ajouter une page fille")."' border='0'/></a>"
                   : "" );*/
                   
      $strNom = ( $iDroitAction > 1
                   ? '"'.$strNom.'"+strUrlStart+"'.$idFils.'"+strUrlEnd'
                   : '"'.$strNom.'"' );

      //$strUrl = "javascript:updatePage(".$idFils.")";
  
      if( $page_id == $idFils ) {
        $strArbre = $drNoeud->getValueName("ARBRE");
      }
      
      $strJsonEncode .= ',["_'.$idFils.'","_'.$idPere.'",'.$strNom.','.$iNiv.','.
        $iDroitLink.','.$iDroitAction.',strUrl+"'.$idFils.')","",-1,"","","","",'.
        ($drNoeud->getValueName("PAGE_PUBLIEE") == 1 ? $drNoeud->getValueName("PAGE_MODIFIEE") : "-1" ).','.$atype_id.',0]';
      /*
      $strHtmlJs .= " objTreeview.AddFolder(\"_".$idFils."\", \"_".$idPere."\", \"".$strNom."\", ".$iNiv.", ".
                     $iDroitLink.", ".$iDroitAction.", \"".$strUrl."\", \"\",-1,\"\", \"\", \"\", \"\", ".
                     $drNoeud->getValueName("PAGE_MODIFIEE").", ".$atype_id.",0);";*/
    }
  
    // parametrage
    $strHtmlJs .= " var tabNode = [".$strJsonEncode."];".
      " for(var i=0; i<tabNode.length; i++) {".
      "   objTreeview.AddFolder(tabNode[i][0], tabNode[i][1], tabNode[i][2], tabNode[i][3], ".
                               "tabNode[i][4], tabNode[i][5], tabNode[i][6], tabNode[i][7]," .
                               "tabNode[i][8], tabNode[i][9], tabNode[i][10], tabNode[i][11]," .
                               "tabNode[i][12], tabNode[i][13], tabNode[i][14], tabNode[i][15]);".
      " }".
      " objTreeview.classLinkFolder = '';".
      " objTreeview.classTextFolder = '';".
      " objTreeview.classLinkDoc = '';".
      " objTreeview.classTextDoc = '';".

      " objTreeview.imgNodeOpen  = '';".
      " objTreeview.imgNodeClose = '';".
      " objTreeview.imgNode      = '';".

      " objTreeview.imgNodeFolder    = '".ALK_MEDIA_URL."images/icon_page.gif';".
      " objTreeview.cssNodeFolder    = 'alkimgicon alkimgiconpage';".
      " objTreeview.imgNodeFolderCut = '".ALK_MEDIA_URL."images/icon_cut.gif';".
      " objTreeview.cssNodeFolderCut = 'alkimgicon alkimgiconcut';".
      //" objTreeview.imgNodeFolderCopy = '".ALK_MEDIA_URL."images/icon_copy.gif';".

      " objTreeview.urlConfirm = 'javascript:CutPastePage';".
      " objTreeview.tokenCutCopy = '".$this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, "&iMode=7")."';".
      " objTreeview.bShowNode = false;".
      " objTreeview.bCanShowHideNode = false;".
      " objTreeview.bViewHeader = true;".
      " objTreeview.bShowRoot = false;".
      " objTreeview.bShowHelp = true;".
      " objTreeview.iTabLg = ".($iWidth-25).";".
      " objTreeview.strToolTipDrawLine = \"Sélectionner une page\";";

    // affichage
    $bOpen = false;
    if( $idRoot != $page_id ) {
      $tabArbre = explode("-", trim($strArbre));
      if( is_array($tabArbre) ) {
        array_pop($tabArbre); // retire le dernier vide
        array_pop($tabArbre); // retire la page sélectionnée
        foreach ($tabArbre as $value) {
          if( is_numeric($value) ) {
            $strHtmlJs .= " objTreeview.OpenNode('_".$value."');";
            $bOpen = true;
          }
        }
      } 
    }
    if( !$bOpen ) {
      $strHtmlJs .= " objTreeview.OpenNode('_0');";
      $strHtmlJs .= " objTreeview.OpenNode('_".$idRoot."');";
    }

    $strHtmlJs .= " }";
    
    $this->addJs($strHtmlJs);
    $this->addOnLoad("AffTreeview();dragAndDropPages('layerArbre');");
    
    $strMsg = "<div id=\"geditArboHelp\" style=\"display:none\">"._t("Cliquez sur l'intitulé de la page pour atteindre ses propriétés.")."<br/>".
      _t("Pour déplacer une page , déplacez-là à l'aide de la souris et posez-la sur la page cible")."<br/>".
      //"Pour activer la page à copier, cliquer sur le picto <img src='".ALK_MEDIA_URL."images/icon_cut.gif'/>".
      //" pour afficher le picto <img src='".ALK_MEDIA_URL."images/icon_copy.gif'/>.<br/>".
      _t("Pour créer une page fille, cliquer sur le picto")." <img class=\"alkimgicon alkimgiconpageadd\" src='".ALK_MEDIA_URL."images/transp.gif'/>.<br/>".
      _t("La couleur orange signale une page en attente de publication")."<br/>".
      _t("La couleur grise signale une page non publiée").
      "</div>";

    $this->addVarJs("strTokenAddPage", "'".$this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, "&iMode=".ALK_FORM_MODE_ADD)."'");
    $this->addVarJs("strTokenUpdatePage", "'".$this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, "&iMode=".ALK_FORM_MODE_UPDATE)."'");
    
    $oBlockArbo = $this->addBlock("blockArbo", _t("Arborescence des pages éditoriales"), $strMsg, 1, $iWidth, false);
    $oBlockArbo->addCtrl($oCtrlHtml, ALK_HTMLFORM_1L1C);
  }
 
   /**
   * Retourne le code Html de tous les blocs associés à la page
   * @param $page_id  identifiant de la page sélectionnée
   * @return string
   */
  private function getHtmlBlocContenu($page_id)
  {
    $nbLg = count($this->tabLangue);

    $dsBloc = $this->oAppli->oQuery->getBlocByPageId($page_id);
    $nbBloc = $dsBloc->getCountTotDr(); 
    $oHtmlList = AlkHtmlFactory::getHtmlList(null, $nbBloc*2, 1, $nbBloc*2, false, "", _t("Aucun bloc sur cette page."));

    $oHtmlList->setColumns(array("center", 20), 
                           array("left",  268-18*$nbLg),
                           array("right",  60+18*$nbLg),
                           array("right",  54));
    $iCpt = 0;
    while( $drBloc = $dsBloc->getRowIter() ) {
      $bloc_id        = $drBloc->getValueName("BLOC_ID");
      $strBlocNom     = $drBloc->getValueName("BLOC_NOM");
      $strBlocTitre   = $drBloc->getValueName(AlkFactory::getDBCurrentLanguageField("BLOC_NOM"));
      $typeIdBloc     = $drBloc->getValueName("TB_ID");
      $atypeIdBloc    = $drBloc->getValueName("ATYPE_ID");
      $iRang          = $drBloc->getValueName("BLOC_RANG");
      $bloc_colonne   = ( $drBloc->getValueName("BLOC_COLONNE")==1 ? 1 : 0);
      $bloc_typeassoc = $drBloc->getValueName("BLOC_TYPEASSOC");
      $bloc_ordre     = $drBloc->getValueName("BLOC_ORDRE");
      $bloc_datedeb   = $drBloc->getValueName("BLOC_DATE_DEB");
      $bloc_datefin   = $drBloc->getValueName("BLOC_DATE_FIN");
      $bloc_limit     = $drBloc->getValueName("BLOC_LIMIT");

      $typeIdBlocIndex = "tb".( $typeIdBloc==1 && $bloc_colonne==1 ? 0 : $typeIdBloc );
      $strContenu  = "";
      $strCssIconBloc = str_replace("_", "", strtolower(substr($this->tabTypeBloc[$typeIdBlocIndex][4], 0, -4)));
      $strImgIcon = "<img class='alkimgicon alkimg".$strCssIconBloc."' src='".ALK_MEDIA_URL."images/transp.gif'/>";

      $oAppliBloc    = AlkFactory::getAppli($atypeIdBloc, ($typeIdBloc==16 ? $this->oAppli->appli_id : -1));
      $tabContents   = $oAppliBloc->getGEditBlocShortContents($bloc_id, $bloc_typeassoc, $atypeIdBloc, $bloc_ordre, $bloc_datedeb, $bloc_datefin, $bloc_limit);
      $tabTypeUpdate = $oAppliBloc->getGEditBlocTypeUpdate($typeIdBloc, $atypeIdBloc);

      // liste des boutons permettant de mettre à jour le contenu du bloc
      $strHtmlBt = "";
      $strHtmlBtRank = "";
      $strContenu = "";
      foreach($this->tabLangue as $key => $tabLg) {
        $strImgBt = ( $nbLg == 1 
                      ? "modifier" 
                      : "drapeau_".$tabLg["rep"] );
        
        $oStyle = true;
        switch( $tabTypeUpdate["type"] ) {
        case ALK_GEDIT_TYPEUPDATE_EDITEUR:
          $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_NONE, ALK_SHEET_NONE,
                                              /*"&applitype_id=".ALK_ATYPE_ID_EDITEUR.*/
                                              "&idEnt=".$tabContents[0]["data_id"].
                                              "&table=".$tabTypeUpdate["tableName"].
                                              "&champsHtml=".$tabTypeUpdate["field_content"].$tabLg["bdd"].
                                              "&champJScript".$tabTypeUpdate["field_scriptjs"].
                                              ( $tabTypeUpdate["field_scriptjs"] != "" ? $tabLg["bdd"] : "" ).
                                              "&champsId=".$tabTypeUpdate["field_pk"].
                                              "&bForm=".$tabTypeUpdate["useForm"].
                                              "&bReload=3&atypeIdBloc=".$atypeIdBloc.
                                              "&bloc_id=".$bloc_id."&bloc_colonne=".$bloc_colonne.
                                              "&repUpload=".$tabTypeUpdate["upload_dir"]);
        
          $oBtMaj = AlkHtmlFactory::getHtmlButtonIcon("javascript:OpenPopupEditeur('".$strToken."')", $strImgBt,
                                                      "modifier le contenu ".$tabLg["rep"]);
          $strContenu = $tabContents[0]["data_desc"];

          if( $strContenu == "" ) {
            if( $nbLg == 1 ) {
              $strContenu = "<div id='layerBloc".$bloc_id."' align='left'><i>"._t("Cliquez sur le bouton modifier pour associer un contenu à ce bloc.")."</i></div>";
            } else {
              $strContenu = "<div id='layerBloc".$bloc_id."' align='left'><i>"._t("Cliquez sur l'un des drapeaux pour associer un contenu à ce bloc.")."</i></div>";
            }
          } else {
            $strContenu = "<div id='layerBloc".$bloc_id."' align='left'>".wordwrap($strContenu, 53, "<br/>", true)."</div>";
          }
          break;

        case ALK_GEDIT_TYPEUPDATE_SELECTEDIT:
          if( $strHtmlBt == "" ) {
            // pas de sélection multilingue dans ce mode
            $oStyle = "style='margin:0px; padding:0px; border:none;'";
            $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE,
                                                "&bloc_id=".$bloc_id.
                                                "&iColumn=".$tabTypeUpdate["iColumn"].
                                                "&atypeIdBloc=".$atypeIdBloc.
                                                "&iFilterSpace=".$tabTypeUpdate["iFilterSpace"].
                                                "&iAssocAppli=".$tabTypeUpdate["iAssocAppli"].
                                                "&iAssocCat=".$tabTypeUpdate["iAssocCat"].
                                                "&catTableName=".$tabTypeUpdate["catTableName"].
                                                "&dataTableName=".$tabTypeUpdate["dataTableName"].
                                                "&catTitle=".$tabTypeUpdate["catTitle"].
                                                "&dataTitle=".$tabTypeUpdate["dataTitle"].
                                                "&iFields=".$tabTypeUpdate["iFields"].
                                                "&blocPosition=".( isset($tabTypeUpdate["blocPosition"]) ? $tabTypeUpdate["blocPosition"] : "bottom"));      
            
            $oBtMaj = AlkHtmlFactory::getHtmlButtonIcon("javascript:OpenDataSelect('".$strToken."', ".$bloc_id.")", "Modifier",
                                                       "Ajouter une information ".$tabLg["rep"]);
            $strContenu = $this->getHtmlBlocShortContent($tabContents, $bloc_id, $atypeIdBloc, $bloc_typeassoc, $bloc_colonne,
                                                         $bloc_ordre, $bloc_datedeb, $bloc_datefin, $bloc_limit);
            if( $strContenu == "" ) {
              $strContenu = "<div id='layerBloc".$bloc_id."' align='left'><i>"._t("Cliquez sur le bouton modifier pour associer de l'information à ce bloc.")."</i></div>";
            }
          } else {
            $oBtMaj = null;
          }
          break;
        }

        if($typeIdBloc!=16 && !is_null($oBtMaj) ) { // tous les blocs, sauf : RSS (16)
          $strHtmlBt .= $oBtMaj->getHtml()."&nbsp;";
        }
      }

      if( $iCpt < $nbBloc-1 ) {
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                            "&page_id=".$page_id."&iMode=6&bloc_id=".$bloc_id."&delta=1");
        $oCtrlBtDesc = AlkHtmlFactory::getHtmlButtonIcon("javascript:MajRangBloc('".$strToken."');", 
                                                         "Rang suivant", _t("Descendre ce bloc"));
        $strHtmlBtRank .= $oCtrlBtDesc->getHtml();
      }
      
      if( $iCpt > 0 ) {
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                            "&page_id=".$page_id."&iMode=6&bloc_id=".$bloc_id."&delta=-1");
        $oCtrlBtMnt = AlkHtmlFactory::getHtmlButtonIcon("javascript:MajRangBloc('".$strToken."');", 
                                                       "Rang precedent" , _t("Monter ce bloc"));
        $strHtmlBtRank .= "&nbsp;".$oCtrlBtMnt->getHtml();
      }

      
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                          "&page_id=".$page_id."&iMode=5&bloc_id=".$bloc_id.
                                          "&typeIdBloc=".$typeIdBloc."&atypeIdBloc=".$atypeIdBloc);
      $oCtrlBtSuppr = AlkHtmlFactory::getHtmlButtonIcon("javascript:DelBloc('".$strToken."');", 
                                                        "Supprimer", _t("Supprimer ce bloc"));
      $strHtmlBt .= $oCtrlBtSuppr->getHtml();
      
      $strTitleBloc = $strBlocNom." de type ".$this->tabTypeBloc[$typeIdBlocIndex][3]."".
        "<div id='layerBlocTitre".$bloc_id."' align='left'>".
           ( $strBlocTitre != "" ? "Titre du bloc : <b>".$strBlocTitre."</b>" : "" ).
           ( $bloc_colonne == 1 ? ( $strBlocTitre != "" ? "<br/>" : "")."<i>Affichage en colonne</i>" : "").
        "</div>";
      
      if( array_key_exists("tokenBlocPerso", $tabTypeUpdate) && $tabTypeUpdate["tokenBlocPerso"] != "" ){
        $oTitleBloc = AlkHtmlFactory::getHtmlButtonIcon("javascript:OpenFormBlocPerso('".$tabTypeUpdate["tokenBlocPerso"]."&bloc_id=".$bloc_id."');", 
                                                       "modifier", _t("Saisir les informations complémentaires"));
        $strHtmlBt = $oTitleBloc->getHtml()."&nbsp;".$strHtmlBt;
      }
      
      
      if( array_key_exists("iBlocPerso",$tabTypeUpdate) && $tabTypeUpdate["iBlocPerso"] == 1 &&  method_exists("", $oAppliBloc) ){
      
      }  

      $strContenu = "<div id='layerBloc".$bloc_id."' align='left'>".$strContenu."<div>";

      $oHtmlList->addRow(array($strImgIcon, 1, 2), $strTitleBloc, $strHtmlBt, $strHtmlBtRank);
      $oHtmlList->addRow(array($strContenu, 3, 1, $oStyle));
      $iCpt++;
    }    
    
    return "<div id='layerBlockPage' ".( $nbBloc>999 && (defined("ALK_B_GEDIT_BLOC_OVERFLOW") && ALK_B_GEDIT_BLOC_OVERFLOW == true) ? " style='overflow:auto; height:300px'" : "" ).">".$oHtmlList->getHtml()."</div>";
  }

  /**
   * Retourne le code html d'un bloc de type ALK_GEDIT_TYPEUPDATE_SELECTEDIT
   * Retourne un tableau avec la liste des éléments associés avec possibilité de les supprimer ou de les ordonner
   * @param tabContent     tableau contenant les informations sur les données associées au bloc
   * @param bloc_id        identifiant du bloc
   * @param atypeIdBloc    type de l'application gérant ces données associées au bloc
   * @param bloc_typeassoc type de données associées : 0=aucune, 1=appli, 2=cat, 3=data 
   *                       si bit 2 on : présente les news uniquement
   *                       si bit 3 on : présente les docs publiés passés
   *                       si bit 4 on : présente les docs publiés présents
   *                       si <=3, présente tous les docs publiés : passés, présent, à venir
   * @param bloc_colonne   =1 pour un affichage en colonne, =0 sinon
   * @param bloc_ordre     liste de nombres séparés par une virgule. 1 nombre correspond à une puissance de deux. 
   *                       cette liste correspond à l'ordre des champs d'après les champs de bit de bloc_typeassoc
   * @param bloc_datedeb   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc
   * @param bloc_datefin   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc 
   * @param bloc_limit     contient le nbre de résultats à afficher
   */
  private function getHtmlBlocShortContent($tabContents, $bloc_id, $atypeIdBloc, $bloc_typeassoc, 
                                           $bloc_colonne, $bloc_ordre, $bloc_datedeb, $bloc_datefin, $bloc_limit)
  {
    $strHtml = "";
    $nbData = count($tabContents);
    $strDataId = "";
    $strGlu = "";
    
    foreach($tabContents as $i => $tabContent) {
      $strHtmlBt = "";
      
      $strDataId .= ( isset($tabContent["data_id"]) && is_numeric($tabContent["data_id"])
                      ? $strGlu.$tabContent["data_id"]
                      : "" );
      $strGlu = ",";
      
      if( $i < $nbData-1 ) {
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                            "&data_id=".$tabContent["data_id"]."&iMode=8&bloc_id=".$bloc_id.
                                            "&rank=".$tabContent["data_rank"]."&delta=1&atypeIdBloc=".$atypeIdBloc.
                                            "&bloc_typeassoc=".$bloc_typeassoc."&bloc_ordre=".$bloc_ordre.
                                            "&bloc_datedeb=".$bloc_datedeb."&bloc_datefin=".$bloc_datefin.
                                            "&data_appliid=".( isset($tabContent["appli_id"]) ? $tabContent["appli_id"] : -1 )).
                                            "&bloc_colonne=".$bloc_colonne."&bloc_limit=".$bloc_limit;
        $oCtrlBtDesc = AlkHtmlFactory::getHtmlButtonIcon("javascript:MajRangDataBloc('".$strToken."');", 
                                                         "p_descendre", _t("Descendre cette donnée"));
        $strHtmlBt .= $oCtrlBtDesc->getHtml()."</td><td>";
      }
      else {
        $strHtmlBt .= "&nbsp;</td><td align='center' valign='top' width='15'>";
      }
      if( $i > 0 ) {
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                            "&data_id=".$tabContent["data_id"]."&iMode=8&bloc_id=".$bloc_id.
                                            "&rank=".$tabContent["data_rank"]."&delta=-1&atypeIdBloc=".$atypeIdBloc.
                                            "&bloc_typeassoc=".$bloc_typeassoc."&bloc_ordre=".$bloc_ordre.
                                            "&bloc_datedeb=".$bloc_datedeb."&bloc_datefin=".$bloc_datefin.
                                            "&data_appliid=".( isset($tabContent["appli_id"]) ? $tabContent["appli_id"] : -1 )).
                                            "&bloc_colonne=".$bloc_colonne."&bloc_limit=".$bloc_limit;
        $oCtrlBtMnt = AlkHtmlFactory::getHtmlButtonIcon("javascript:MajRangDataBloc('".$strToken."');", 
                                                       "p_monter" , _t("Monter cette donnée"));
        $strHtmlBt .= $oCtrlBtMnt->getHtml()."</td><td>";
      }
      else {
        $strHtmlBt .= "&nbsp;</td><td align='center' valign='top' width='15'>";
      }
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                          "&data_id=".$tabContent["data_id"]."&iMode=9&bloc_id=".$bloc_id.
                                          "&atypeIdBloc=".$atypeIdBloc."&bloc_typeassoc=".$bloc_typeassoc."&bloc_ordre=".$bloc_ordre.
                                          "&bloc_datedeb=".$bloc_datedeb."&bloc_datefin=".$bloc_datefin.
                                          "&data_appliid=".( isset($tabContent["appli_id"]) ? $tabContent["appli_id"] : -1 ) ).
                                          "&bloc_colonne=".$bloc_colonne."&bloc_limit=".$bloc_limit;
      $oCtrlBtSuppr = AlkHtmlFactory::getHtmlButtonIcon("javascript:DelDataBloc('".$strToken."');", 
                                                       "p_supprimer", _t("Supprimer cette donnée"));
      $strHtmlBt .= $oCtrlBtSuppr->getHtml();

      $strDesc = $tabContent["data_desc"];
      if( $strDesc != "" ) {
        if( mb_strlen($strDesc) > 100 ) {
          $iPos = mb_strpos($strDesc, " ", 95);
          $strDesc =  mb_substr($tabContent["data_desc"], 0, $iPos)."...";
        }
      }

      $strHtml .= "<tr>".
        "<td align='left' valign='top'>".
        wordwrap($tabContent["data_title"], 45, "<br/>", true).
        ( $tabContent["data_desc"]!="" 
          ? "<br/><i>".wordwrap($strDesc, 45, "<br/>", true)."</i>"
          : "" ).
        "</td>".
        "<td align='center' valign='top' width='15'>".$strHtmlBt."</td>".
        "</tr>";
    }

    if( $strHtml != "" ) {
      $strHtml = "<div id='layerBloc".$bloc_id."' align='left'>" .
          "<table class='tabGeditContent' border='0' cellpadding='0' cellspacing='0' width='100%'>".
        $strHtml.
       /* ( $bloc_colonne == 1 
          ? "<tr><td colspan='4'><i>"._t("Affichage en colonne")."</i></td></tr>"
          : "" ).*/
        "</table>".
        "<input type='hidden' id='dataIdList".$bloc_id."' name='dataIdList".$bloc_id."' value='".AlkRequest::getEncodeParam($strDataId)."'/>".
        "</div>";
    }

    return $strHtml;
  }

  /**
   * Retourne le block liste des profils avec la gestion de droits
   * @return AlkHtmlList
   */
  private function getRightPanel($page_id, $bAdd=true)
  {
    // liste des groupe de cet espace
    $cont_id   = AlkRequest::getToken("cont_id", "-1");
    $appli_id  = AlkRequest::getToken("appli_id", "-1"); 

    if( $this->iMode ==  ALK_FORM_MODE_ADD ) {
      $oQueryCont = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
      $dsProfil = $oQueryCont->getDsProfilListByAppli($appli_id, $cont_id);
    } else {
      $dsProfil = $this->oAppli->oQuery->getDsProfilListByPage($page_id);
    }

    $strEnable = ( $this->iMode==ALK_FORM_MODE_ADD || 
                   $this->iMode==ALK_FORM_MODE_UPDATE && $this->page_public->value==1
                   ? " disabled='disabled'"
                   : "" );

    // nombre de groupe
    $nbElt = $dsProfil->getCountTotDr()+1;
   
    $strDesc = _t("Si vous décochez, la validation propage automatiquement les droits à la sous-arborescence qui hérite.");
    $oBlocPublic = $this->addBlock("blockPublic", ( $bAdd ? _t("Gestion des droits") : "" ), $strDesc, "120", "250", false);
    $page_public = AlkHtmlFactory::getHtmlCheckbox($this->page_public, _t("Hériter des droits"));
    $page_public->AddEvent("onclick","onChangePagePublic(this, ".$this->iMode.")");
    if( $this->page_niveau->value > 1 ) {
      $page_public->setLabelAfter("<br/>"._t("En cochant cette case, la page récupère automatiquement les droits fixés sur la page parente."));
    } else {
      $page_public->setLabelAfter("<br/>"._t("En cochant cette case, la page récupère automatiquement les droits fixés sur l'application."));
    }
    $oBlocPublic->addCtrl($page_public);
    
    $oTabPage = AlkHtmlFactory::getHtmlListJQuery($this, $nbElt, false, "", "tabRight");
    $oTabPage->SetColumns(array("left",   "180"),
                          array("center", "50", "", false, false),
                          array("center", "50", "", false, false),
                          array("center", "50", "", false, false),
                          array("center", "50", "", false, false));

    $oTabPage->AddTitleRow(_t("Profil"), _t("Aucun"), _t("Consult."), _t("Admin."), _t("Publi."));

    $strToken = "";

    // selectionne la liste des profils
    $cpt = 0;
    while( $drProfil = $dsProfil->getRowIter() ) {
      $profil_id = $drProfil->getValueName("PROFIL_ID");
      $strProfil = mb_ereg_replace("_", " ", $drProfil->getValueName("PROFIL_INTITULE"));
      $droit_id  = $drProfil->GetValueName("DROIT_ID");
      $idCont    = $drProfil->GetValueName("CONT_ID");

      $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_CONSULT.
                                             "&iSheet=".ALK_SHEET_APPLICATION."&iSSheet=".ALK_SHEET_USERS_LIST."&profil_id=".$profil_id);
      $strProfil = "<a title='"._t("Afficher les utilisateurs concernés par les droits de ce Profil")."'".
        " onclick=\"javascript:showUsers('".$strToken."')\">".$strProfil.( $idCont==0 ? "*"  : "" )."</a>";

      $check0 = "-0'";
      $check1 = "-1'";
      $check2 = "-2'";
      $check4 = "-4'";
      switch( $droit_id )	{
      case ALK_APPLI_RIGHT_NONE:	$check0 .= " checked='checked'"; break;
      case ALK_APPLI_RIGHT_READ:	$check1 .= " checked='checked'"; break;
      case ALK_APPLI_RIGHT_ADMIN:	$check2 .= " checked='checked'"; break;
      case ALK_APPLI_RIGHT_PUBLI:	$check4 .= " checked='checked'"; break;
      }

      $strBR0 = "<input type='radio' name='listRight[".$cpt."]' ".$strEnable." value='".$profil_id.$check0."/>";
      $strBR1 = "<input type='radio' name='listRight[".$cpt."]' ".$strEnable." value='".$profil_id.$check1."/>";
      $strBR2 = "<input type='radio' name='listRight[".$cpt."]' ".$strEnable." value='".$profil_id.$check2."/>";
      $strBR4 = "<input type='radio' name='listRight[".$cpt."]' ".$strEnable." value='".$profil_id.$check4."/>";

      $oTabPage->AddRow($strProfil, $strBR0, $strBR1, $strBR2, $strBR4);
      $cpt++;
    }
    return array($oBlocPublic, $oTabPage);
  }

  /**
   * Retourne le block RSS
   * @return AlkHtmlBlock
   */
  private function getRssPanel($page_id)
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $user_right = AlkFactory::getSProperty("user_right", "0");
    $appli_id = AlkRequest::getToken("appli_id", "-1");  
    
    $oBlockRss  = $this->addBlock("blockRss",  "Syndication de cette page au format RSS 2.0", "", "10", "390", true);

    $strHtml = _f("Grâce aux fils RSS de %s vous pouvez désormais recevoir les dernières nouveautés directement sur votre ordinateur où sur d'autres sites.", ALK_APP_TITLE)."<br/>".
      _t("Le fil disponible correspond au contenu de la page sélectionnée").
       " :<ul style='margin:0px; padding:0 0 0 20px;'>".
      "<li>"._t("cliquez sur l'icône du service pour associer le flux à votre navigateur")."</li>".
      "<li>"._t("copier l'adresse associée pour paramètrer un lecteur de fils RSS placé sur un site internet ou sur un widget.")."<br/>".
      "<span class='txtAdvice'>"._t("Afin d'être certain de copier/coller toute l'adresse, il est conseillé de double cliquer sur le lien pour le sélectionner entièrement pour ensuite le copier.").
      "</ul><div>";
      
    $strTokenPub = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RSS, ALK_SHEET_NONE, "&page_id=".$page_id."&pub=1");
    $strTokenValid = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RSS, ALK_SHEET_NONE, "&page_id=-2&pub=0&user_id=".$user_id);
    
    $strUrlRssPub   = ALK_ALKANET_RSS."?token=".$strTokenPub;
    $strUrlRssValid = ALK_ALKANET_RSS."?token=".$strTokenValid;
    
    $strHtml .= "<div style='margin-top:8px;'>".
      ( $this->page_validesynd->value == "1" 
        ? "<a target='_blank' href='".$strUrlRssPub."'><img class='alkimgicon alkimgicondocrss' src='../../media/images/transp.gif' border='0' valign='absmiddle'/></a> ".
          _t("Cette page éditoriale")."</div>".
          "<div style='margin-left:20px;'>".
          "<input class='formCtrl' style='width:360px; border:none; background-color:grey; color:white;' type='text' value='".$strUrlRssPub."' readonly='readonly'>".
          "</div>"
        : _t("Cette page n'est pas autorisée pour la syndication.") ).
      ( $user_right == ALK_APPLI_RIGHT_PUBLI
        ? "<div style='margin-top:8px;'><a target='_blank' href='".$strUrlRssValid."'><img class='alkimgicon alkimgicondocrss' src='../../media/images/transp.gif' border='0' valign='absmiddle'/></a>".
         _t("Toutes les pages à valider de cette application")."</div>".
          "<div style='margin-left:20px;'>".
          "<input class='formCtrl' style='width:360px; border:none; background-color:grey; color:white;' type='text' value='".$strUrlRssValid."' readonly='readonly'>".
          "</div>"
        : "" ).
      "</div>";
    
    $oCtrlHtml = AlkHtmlFactory::getHtml($strHtml);
    $oBlockRss->addCtrl($oCtrlHtml);
    return $oBlockRss; 
  }

  /**
   * Retourne le block référencement
   * @return AlkHtmlBlock
   */
  private function getRefInternetPanel($page_id)
  {
    $iTxtWidth = "39";
    
    $strDesc = _t("Ces champs seront utilisés au moment de générer la page avec pour objectif, l'optimisation du référencement Internet auprès des moteurs de recherche."); 
    
    $oBlockRef  = $this->addBlock("blockRefInternet",  _t("Référencement Internet"), $strDesc, "100", "300", true);
   
    $oCtrlTitre = AlkHtmlFactory::getHtmlText($this->page_titrenav, _t("Titre navigateur"), 1, $iTxtWidth, 120);
    $oCtrlTitre->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
    $oBlockRef->addCtrl($oCtrlTitre);

    $oCtrlAlias = AlkHtmlFactory::getHtmlText($this->page_alias, _t("Intitulé url"), 1, $iTxtWidth, 250);
    $oCtrlAlias->setMultiLanguageMode(1);
    $oCtrlAlias->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
    $oBlockRef->addCtrl($oCtrlAlias);
        
    $oCtrlMotCle = AlkHtmlFactory::getHtmlText($this->page_motcle, _t("Mots clés"), 4, $iTxtWidth-2, 1000);
    $oCtrlMotCle->addValidator(ALK_VERIF_MEMO, "", 1000);
    $oBlockRef->addCtrl($oCtrlMotCle);

    $oCtrlDesc = AlkHtmlFactory::getHtmlText($this->page_desc, _t("Description"), 4, $iTxtWidth-2, 250);
    $oCtrlDesc->addValidator(ALK_VERIF_MEMO, "", 250);
    $oBlockRef->addCtrl($oCtrlDesc);
    
    return $oBlockRef;
  }

  /**
   * Ajoute un bloc commentaire sur le panel passé en paramètre 
   * @param oSheetProp  référence sur l'objet panel contenant le bloc
   */
  private function getBlockCommentaire($oSheetProp)
  {
    if( !(defined("ALK_B_ATYPE_COMMENT") && ALK_B_ATYPE_COMMENT==true) ) return;

    $cont_id  = AlkRequest::getToken("cont_id", "-1");
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    $oAppliComment = $oQueryEspace->getAppliBySpace(ALK_ATYPE_ID_COMMENT, $cont_id);
    if( !is_null($oAppliComment) ) {
      $oAppliComment->getHtmlBlockComment($this, $oSheetProp, "blockComment", 180, 225, 
                                          "GEDIT_01_PAGE", "PAGE_ID", $this->page_id->value, $this->oAppli->appli_id);
    }
  }

  /**
   * Ajoute un bloc abonnement sur le panel passé en paramètre 
   * @param oSheetProp  référence sur l'objet panel contenant le bloc
   */
  private function getBlockAbonnement($oSheetProp)
  {
    if( !(defined("ALK_B_GEDIT_ABONNEMENT") && ALK_B_GEDIT_ABONNEMENT==true) ) return;
    
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    $oAppliLsDif = $oQueryEspace->getAppliBySpace(ALK_ATYPE_ID_LSDIF, $cont_id);
    if( !is_null($oAppliLsDif) ) {
      $liste_id = "-1";
      $iAbonnement = "0";
      $page_id = ( $this->page_brouillon->value == "" ? "-1" : $this->page_brouillon->value );
      $oDsAbonnement = $oAppliLsDif->oQuery->getInfoAbonnement("GEDIT_01_PAGE_LISTE", "PAGE_ID", $page_id);
      if ( $oDrAbonnement = $oDsAbonnement->getRowIter() ) {
        $liste_id = $oDrAbonnement->getValueName("LISTE_ID");
        $iAbonnement = $oDrAbonnement->getValueName("ABONNEMENT");
      }
      $oAppliLsDif->getHtmlBlockAbonnement($this, $oSheetProp, "blockAbonnement", 180, 225, ALK_ATYPE_ID_GEDIT, $page_id, -1, $liste_id, $iAbonnement);
    }
  }

  /**
   * publication de l'autorisation des commentaires
   */
  private function publishCommentaire()
  {
    if( !(defined("ALK_B_ATYPE_COMMENT") && ALK_B_ATYPE_COMMENT==true) ) return;
    
    $cont_id  = AlkRequest::getToken("cont_id", "-1");
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    $oAppliComment = $oQueryEspace->getAppliBySpace(ALK_ATYPE_ID_COMMENT, $cont_id);
    if( !is_null($oAppliComment) ) {
      $oAppliComment->oQueryAction->duplicateAutorisation("GEDIT_01_PAGE", "PAGE_ID", $this->page_id->value, $this->page_brouillon->value, 
                                                          $this->oAppli->appli_id, $oAppliComment->appli_id);
    }
  }
  
  /**
   * Ajoute un bloc geoloc sur le panel passé en paramètre 
   * @param oSheetProp  référence sur l'objet panel contenant le bloc
   */
  private function getBlockWorkflow($oSheetProp)
  {
    if( !(defined("ALK_B_ATYPE_GALAXIA") && ALK_B_ATYPE_GALAXIA==true) ) return;

    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    $oAppliGalaxia = $oQueryEspace->getAppliBySpace(ALK_ATYPE_ID_GALAXIA, $cont_id);
    if( !is_null($oAppliGalaxia) ) {
      $user_right = AlkFactory::getSProperty("user_right", ALK_APPLI_RIGHT_NONE);
      $iWidthLabel = ( $user_right == ALK_APPLI_RIGHT_PUBLI ? 140 : 260 ); 
      $iWidthCtrl  = ( $user_right == ALK_APPLI_RIGHT_PUBLI ? 265 : 145 );
      $oAppliGalaxia->getHtmlBlocWorkflow($this, $oSheetProp, "blockWorkflow", _t("Validation"), $iWidthLabel, $iWidthCtrl, 
                                          $this->oAppli->appli_id, -1, $this->page_id->value, true);
    }
  } 
  
  /**
   * Lance le processus de validation si la case est cochée
   */
  private function startWorkflow()
  {
    if( !(defined("ALK_B_ATYPE_GALAXIA") && ALK_B_ATYPE_GALAXIA==true) ) return;

    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $processtype_id = AlkRequest::_POSTint("wkf_processtype_id", "-2");
    $wkf_start_process = AlkRequest::_POSTcheck("wkf_start_process", "0");

    $oAppliGalaxia = null;
    if( $processtype_id != "-2" || 
        $processtype_id != "-1" && $wkf_start_process=="1"  ) {
      $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
      $oAppliGalaxia = $oQueryEspace->getAppliBySpace(ALK_ATYPE_ID_GALAXIA, $cont_id);
    }
    
    if( $processtype_id != "-2" ) {
      if( !is_null($oAppliGalaxia) ) {
        $oAppliGalaxia->saveProcessTypeAppliCat($processtype_id, $this->oAppli->appli_id, -1);
      }
    } 
    
    if( $processtype_id != "-1" && $wkf_start_process=="1" ) {
      // lock la fiche
      $this->page_validepub->value = "2";
      if( !is_null($oAppliGalaxia) ) {
        $user_id = AlkFactory::getSProperty("user_id", "-1");
        $appli_intitule = _t("page éditoriale"); 
        $data_intitule = $this->page_titre->value[ALK_LG];
        $bRes = $oAppliGalaxia->startProcess($processtype_id, $this->oAppli->atype_id, $this->oAppli->appli_id, 
                                             -1, $this->page_id->value, $user_id, $appli_intitule, $data_intitule);
        if( !$bRes ) {
          $this->page_validepub->value = "0";
        }
      }
    } 
  }  

  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."gedit/help/gedit_01_page_form.htm"); 
  }  

}
?>