<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Form
Module formulaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."excel/Workbook.php");

/**
 * @package Alkanet_Module_Form
 * @class AlkHtmlFormList
 * Classe d'affichage de la liste des formulaires d'une application
 */
class AlkHtmlFormList extends AlkHtmlForm
{
 
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  
  
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "FormList");
    $this->iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $this->setProperties($this->iMode, ALK_FORM_METHOD_POST, "");
  }
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) {  }

  /**
   * Traitement 
   */
  public function doSql() 
  {
    $form_id = AlkRequest::getToken("form_id", "-1");
    $reponse_id = AlkRequest::getToken("reponse_id", "-1");
    $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM);
    $iSheet = AlkRequest::getToken("iSheet", ALK_SHEET_ENCOURS);
    $etat = AlkRequest::getToken("etat", ALK_FORM_ETAT_REPONSE_ATTENTE);
    
    switch( $this->iMode ) {
    case ALK_FORM_MODE_DEL: // suppression pour la liste      
      $this->delFormulaire($form_id, $strPathUpload);
      break;
      
    case 6 : // export au format excel
      $this->doExport($form_id, $strPathUpload);
      return "";
      break;
      
    case 7 : //purge
      $this->doPurge($form_id, $strPathUpload);
      echo getBodyOnLoadExec("alkAlert("._t("Les réponses ont été supprimées").");");
      return "";
      break;
    
    case 8 : // export au format pdf
      $this->doExportPdf($form_id, $strPathUpload);
      return "";
      break;
      
    case 10 : // modification du fichier xml pour rajouter le traitement Vu     
      $this->UpdateFichierXMLByReponseID($reponse_id, $form_id);
      echo ALK_ALKANET."?token=".$this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_LIST, "&form_id=".$form_id."&iMode=9&etat=".$etat);
      exit(); 
      break;
      
    case 11: // supprimer une réponse
      $this->UpdateFichierXMLByDeleteReponseID($reponse_id, $form_id);
      $strTokenRep = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_LIST, "&form_id=".$form_id."&iMode=9"."&etat=".$etat);
      echo ALK_ALKANET."?token=".$strTokenRep; 
      exit(); 
     break;
  }   
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_NONE); 
    return ALK_ALKANET."?token=".$strToken; 

}
  
  /**
   * Construction de la liste 
   */
  public function setContents()
  {
    $iSheet   = AlkRequest::getToken("iSheet", ALK_SHEET_ENCOURS);
    $cont_id  = AlkRequest::getToken("cont_id", "-1");
    $appli_id = AlkRequest::getToken("appli_id", "-1");
    $user_right = AlkFactory::getSProperty("user_right", ALK_APPLI_RIGHT_NONE);
     
    $this->strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM, true).$cont_id."/";
    if( !(@file_exists(ALK_ALKANET_ROOT_PATH.$this->strPathUpload) && @is_dir(ALK_ALKANET_ROOT_PATH.$this->strPathUpload)) ) {
      $bRes = @mkdir(ALK_ALKANET_ROOT_PATH.$this->strPathUpload, 0770);
      if( !$bRes ) {
        $this->strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM, true);
      } 
    }
    
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
    AlkFactory::setSQLParamsName();

    $iPub = 1;
    $strTitle = _t("Gestion des formulaires ");
    $strDesc = "";
    switch( $iSheet ) {
    case ALK_SHEET_AVENIR:
      $this->dsForm = $this->oAppli->oQuery->getDs_ListeFormulairesAVenir($appli_id, $iPub, 0, -1, AlkFactory::getDBCurrentLanguageField("FORM_TITRE"));
      $strTitle .= _t("dont la publication est à venir");
      $strDesc = "";
      break;

    case ALK_SHEET_PASSES:
      $this->dsForm = $this->oAppli->oQuery->getDs_ListeFormulairesArchive($appli_id, $iPub, 0, -1, AlkFactory::getDBCurrentLanguageField("FORM_TITRE"));
      $strTitle .= _t("dont la date de publication est dépassée");
      $strDesc = "";
      break;

    case ALK_SHEET_AVALIDER:
      $this->dsForm = $this->oAppli->oQuery->getDs_ListeFormulairesAValider($appli_id, 0, -1, AlkFactory::getDBCurrentLanguageField("FORM_TITRE"));
      $strTitle .= _t("non publiés et à valider pour publication");
      $strDesc = _f("Seul les %s ayant de droit de publication peuvent valider les formulaires.", ALK_S_AGENTS);
      break;

    case ALK_SHEET_ENCOURS:
    default:
      $this->dsForm = $this->oAppli->oQuery->getDs_ListeFormulairesAPublier($appli_id, $iPub, 0, -1, AlkFactory::getDBCurrentLanguageField("FORM_TITRE"));  
      $strTitle .= _t("actuellement publiés");
      $strDesc = "";
      break;
    }
    
    $etat = AlkRequest::getToken("etat", ALK_FORM_ETAT_REPONSE_ATTENTE );
    if ($this->iMode == 9){ // chargement de la liste des réponses
      $form_id = AlkRequest::getToken("form_id", "-1");
      if (isset($form_id) & isset($etat)){
        if ($form_id !=-1 && $etat!="" ){
         //Traitement affichage des réponses 
         $tabRes = $this->doExporTableauReponse($form_id , $etat, $iSheet);     
        } 
      }
      echo json_encode($tabRes);
      exit();
    }
    
    $output = array();
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
      $output = array(
            "sEcho" => AlkFactory::getSQLParamsName("sEcho", ""),
            "iTotalRecords" => $this->dsForm->getCountTotDr(),
            "iTotalDisplayRecords" => $this->dsForm->getCountTotDr(),
            "aaData" => array()
          );
    AlkFactory::emptySQLParamsName();

    $oBlock = $this->addBlock("block_fact", $strTitle, "", "200", "390", true);
    $this->setLabelDesc($strDesc);
    $strUrlPagine = ALK_ALKANET."?token=".$this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=12");
    
    $nbElt    = $this->dsForm->getCountTotDr(); 
    
    $oTabPage = AlkHtmlFactory::getHtmlListJQuery($this, $nbElt, true, $strUrlPagine, "listForm");
    
    $tabColumns = array(array("left",     "320", AlkFactory::getDBCurrentLanguageField("FORM_TITRE")),
                        array("center",   "100", "FORM_DATEMAJ"),
                        array("center",   90+30*count($this->tabLangue), "", false, false));
    
    $nbBtAdd = 5;                    

    $oTabPage->setColumnsByArray($tabColumns);
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_FORM);  
    $oBtAdd = AlkHtmlFactory::getHtmlButtonPage(ALK_ALKANET."?token=".$strToken, _t("Ajouter"), _t("Ajouter un nouveau formulaire"));
    $oTabPage->AddTitleRow(_f("Intitulé du formulaire (%s)", $nbElt), _t("Date modif."), $oBtAdd);
    $oTabPage->setFilter(true);
    $oTabPage->setModeAjax(true);
    $oBlock->addCtrl(AlkHtmlFactory::getHtml($oTabPage->getHtml(), ""), ALK_HTMLFORM_1L1C, "center");
    $oBlock->addCtrl(AlkHtmlFactory::getHtml("<div id='oForm_reponses'></div>"), ALK_HTMLFORM_1L1C);
    $this->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."form/lib/alkhtmlformlist.js");
    
    if ($this->iMode == 12){
      $this->readData(true, $oTabPage, $output);
    }
  }
  
 /**
  * Fonction de lecture des données
  */
 private function readData($bModeAjax=false, &$oList, &$output){
   
   $iSheet   = AlkRequest::getToken("iSheet", ALK_SHEET_ENCOURS);
   $etat     = AlkRequest::getToken("etat", ALK_FORM_ETAT_REPONSE_ATTENTE );
   
   while( $drForm = $this->dsForm->getRowIter() ) {
     $form_id          = $drForm->getValueName("FORM_ID");
     $form_titre       = $drForm->getValueName(AlkFactory::getDBCurrentLanguageField("FORM_TITRE"));
     $strDateMaj       = $drForm->getValueName("FORM_DATE_MAJ");
     $form_mail        = $drForm->getValueName("FORM_MAIL");
     $form_publication = $drForm->getValueName("VALIDEPUB");
     $form_sondate     = $drForm->getValueName("FORM_SONDAGE");
  
     $strTokenMaj = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_FORM, 
                                         "&iMode=".ALK_FORM_MODE_UPDATE."&form_id=".$form_id);
     $strForm = '<a title="'._t("Modifier le formulaire")." ".$form_titre.
      '" href="'.ALK_ALKANET.'?token='.$strTokenMaj.'">'.$form_titre.'</a>';

     $strTokenAp = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_APERCU, ALK_SHEET_NONE, 
                                            "&form_id=".$form_id);
     $oBtApercu = AlkHtmlFactory::getHtmlButtonIcon("javascript:OpenPopupApercu('".$strTokenAp."')", 
                                                       "Afficher", _t("Aperçu du formulaire")." ".$form_titre)->getHtml();

     $strTokenExp = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_NONE, 
                                             "&form_id=".$form_id."&iMode=6");
     $oBtExport = AlkHtmlFactory::getHtmlButtonIcon("javascript:void(OpenFooterExec('".ALK_ALKANET_SQL."?token=".$strTokenExp."'))", 
                                                     "doc_2", _t("Exporter les réponses du formulaire")." ".$form_titre)->getHtml();
                                                   
                                                 
     $oBtReponse   = "&nbsp;";                                             
     if(defined("ALK_B_FORM_REPONSE") && ALK_B_FORM_REPONSE) {
       // Bouton Traiter les réponses
       $strTokenRep = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_LIST, 
                                          "&form_id=".$form_id."&iMode=9"."&etat=".$etat);
       $oBtReponse = AlkHtmlFactory::getHtmlButtonIcon("javascript:displayReponses('".ALK_ALKANET."?token=".$strTokenRep."')", 
                                                    "lettre", _t("Traiter les réponses du formulaire")." ".$form_titre)->getHtml();
     }
  
     $oBtExportPdf = "&nbsp;";
     if( $form_sondate=="0" && defined("ALK_B_FORM_EXPORT_PDF") && ALK_B_FORM_EXPORT_PDF){
       $strTokenExpPdf = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_NONE, 
                                             "&form_id=".$form_id."&iMode=8");/*
       $oBtExportPdf = AlkHtmlFactory::getHtmlButtonIcon("javascript:void(OpenFooterExec('".ALK_ALKANET_SQL."?token=".$strTokenExpPdf."'))", 
                                                     "doc_3", "Exporter les réponses au format pdf");*/
       $oBtExportPdf = AlkHtmlFactory::getHtmlButtonIcon("javascript:void(OpenPopupWindow('".ALK_ALKANET_SQL."?token=".$strTokenExpPdf."', '500', '500', 'pdf'))", 
                                                     "doc_3", _t("Exporter les réponses au format pdf du formulaire")." ".$form_titre)->getHtml();
     }
  
     $strTokenPurge = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_NONE, 
                                             "&form_id=".$form_id."&iMode=7");
     $oBtPurge = AlkHtmlFactory::getHtmlButtonIcon("javascript:ExecPurge('".$strTokenPurge."')",
                                                  "Purge",  _t("Purger les réponses du formulaire")." ".$form_titre)->getHtml();

     $strTokenDel = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_NONE, 
                                           "&form_id=".$form_id."&iMode=".ALK_FORM_MODE_DEL);
     $oBtSuppr = AlkHtmlFactory::getHtmlButtonIcon("javascript:Confirmation('".ALK_ALKANET_SQL."?token=".$strTokenDel.
                                                "', '"._t("Veuillez confirmer la suppression de ce formulaire ?")."')", 
                                                "Supprimer",  _t("Supprimer le formulaire")." ".$form_titre)->getHtml();  
  
     $strBtCont = "";
     foreach($this->tabLangue as $key => $tabLg) {
        $strTokenEdit = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE,
                                            "&applitype_id=".ALK_ATYPE_ID_FORM.
                                            "&form_id=".$form_id."&table=FORM_01_FORM".
                                            "&lang=".$tabLg["bdd"]."&repUpload=".$this->strPathUpload);
      
       $oBtEdit = AlkHtmlFactory::getHtmlButtonImg("javascript:OpenPopupEditeur('".$strTokenEdit."')",
                                                   "icon_drapeau_".$tabLg["rep"].".gif", _f("Contenu %s de ce formulaire", $tabLg["rep"]));
       $strBtCont .= ( $strBtCont=="" ? "" : "&nbsp;").$oBtEdit->getHtml();
     }

     $strBtCont = ( $strBtCont=="" ? "&nbsp;" : $strBtCont );
  
     $ArrayBoutons = array($strForm, $strDateMaj, $strBtCont."&nbsp;".$oBtApercu."&nbsp;".$oBtPurge.
                                               "&nbsp;".$oBtSuppr."&nbsp;".$oBtExport."&nbsp;".$oBtExportPdf.$oBtReponse);
     if ($bModeAjax)
      $output["aaData"][] = $ArrayBoutons;
    else
      $oList->addRowByArray($ArrayBoutons);
   }
   
   if ( $bModeAjax) {
    echo json_encode( $output );
    exit();
  }
 }

  /**
   * Suppression d'un formulaire
   * @param form_id        identifiant du formulaire
   * @param strPathUpload  chemin physique du répertoire d'upload de l'application
   */
  private function delFormulaire($form_id, $strPathUpload)
  {
    $this->oAppli->oQueryAction->delFormulaire($form_id);
    $this->doPurge($form_id, $strPathUpload);
  }

  /**
   * Supprime les fichiers xml et excel d'un formulaire
   * @param form_id        identifiant du formulaire
   * @param strPathUpload  chemin physique du répertoire d'upload de l'application
   */
  private function doPurge($form_id, $strPathUpload)
  {
    delFile($strPathUpload."formulaire_".$form_id.".xls");
    delFile($strPathUpload."formulaire_".$form_id.".xml");
    delFile($strPathUpload."formulaire_".$form_id."_*.pdf");
    delFile($strPathUpload."formulaire_".$form_id.".pdf");
  }

  /**
   * Affiche les réponses au foramt excel
   * @param form_id        identifiant du formulaire
   * @param strPathUpload  chemin physique du répertoire d'upload de l'application
   */
  
  private function Construire_Tableau($strFileXml, $form_id){
    
             // build the array
    $nodeArray = array();
    $tabEntete = array();
    $tabEnteteTraitement = array();
    $nbRep = 0; 
    
    if(file_exists($strFileXml) && is_file($strFileXml) ) {
      $handleXml = fopen ($strFileXml, "r");
      $dsFormulaire = $this->oAppli->oQuery->GetDs_formulaire($form_id);
      if( $drFormulaire = $dsFormulaire->getRowIter() ) {
        $strXmlRep = file_get_contents($strFileXml);
        $strXmlRep .= "</formulaire>";
        
        $strXmlRep = str_replace(ALK_HTML_ENCODING, ALK_EXPORT_ENCODING, $strXmlRep);
        //$strXmlRep = mb_convert_encoding($strXmlRep, ALK_HTML_ENCODING, ALK_EXPORT_ENCODING);
        $oDom = DOMDocument::loadXML($strXmlRep);

        $oNodeRoot = $oDom->documentElement;
        if( $oNodeRoot->hasChildNodes() ) {
          $oNodesList =  $oNodeRoot->childNodes;
          $strHtml = "";
          for($i=0; $i<$oNodesList->length; $i++) {
            // niveau reponse
            $oNode = $oNodesList->item($i);
            if( $oNode->hasChildNodes() && $oNode->nodeName!="#text" ) {
              $oNodesSubList =  $oNode->childNodes;
              for($j=0; $j<$oNodesSubList->length; $j++) {
                $oSubNode = $oNodesSubList->item($j);
                if( $oSubNode->nodeName!="#text"){
                  if ($oSubNode->nodeName=="traitement"){
                    $traitement=array();
                    // on constitue la chaine
                    if ($oSubNode->hasChildNodes()){
                      $nodeTraitement = $oSubNode->childNodes;
                      for ($k=0;$k<$nodeTraitement->length;$k++){
                        if ($nodeTraitement->item($k)->nodeName !="#text"){
                          if( !array_key_exists($nodeTraitement->item($k)->nodeName, $traitement) ){
                            if( !in_array($nodeTraitement->item($k)->nodeName, $tabEnteteTraitement) ){ 
                              array_push($tabEnteteTraitement, $nodeTraitement->item($k)->nodeName);
                            }
                            $traitement[$nodeTraitement->item($k)->nodeName]= $nodeTraitement->item($k)->nodeValue;
                          }
                        }
                      }
                    }
                    $nodeArray[$nbRep][$oSubNode->nodeName][] = $traitement;
                  }else {
                    $strParamName = $oSubNode->nodeName;
                    //if (mb_substr(mb_strTolower($strParamName), 0, mb_strlen("form_".$form_id."_")) == "form_".$form_id."_")
                      $strParamName = mb_strTolower($strParamName); //mb_substr(mb_strTolower($strParamName), mb_strlen("form_".$form_id."_"));
              
                    if( !in_array($strParamName, $tabEntete) ) 
                      array_push($tabEntete, $strParamName);
                    if( !array_key_exists($strParamName, $nodeArray) ) 
                     //$nodeArray[$oSubNode->nodeName] = array();
                     $nodeArray[$nbRep][$strParamName] = $oSubNode->nodeValue;
                  }                 
                }
              }
              $nbRep++;
            }
          }
        }
      }// form_id existe dans base
  }// file_exists
  
    return array($nodeArray, $tabEntete, $tabEnteteTraitement, $nbRep);
  }
  private function doExport($form_id, $strPathUpload)
  {
    $strHtml = "";
    $strXml = "";
    
    $strFileXml = $strPathUpload."formulaire_".$form_id.".xml";
    $strFileExcel = $strPathUpload."formulaire_".$form_id.".xls";
    $strFileExcelToUpload = AlkFactory::getUploadUrl(ALK_ATYPE_ID_FORM)."formulaire_".$form_id.".xls";
    
    delFile($strFileExcel);

    $handleExcel = fopen ($strFileExcel, "w");

    // on récupère les différents tableaux
    $list = $this->Construire_Tableau($strFileXml, $form_id);
    
   $nodeArray = $list[0]; $tabEntete = $list[1]; $tabEnteteTraitement = $list[2];$nbRep = $list[3];
  
    
    if (!empty($nodeArray)||(!empty($tabEntete)) || (!empty($tabEnteteTraitement))){
      //Tableau entêtes
      AffHeaderFileDownload("", "formulaire_".$form_id.".xls", 0, "application/vnd.ms-excel");
      $workbook = new Workbook("-");
  
      // Creating the first worksheet
      $worksheet1 =& $workbook->add_worksheet('Export');
      
      $oFormatHeader =& $workbook->add_format();
      //$oFormatHeader->set_border(1);
      $oFormatHeader->set_align('center');
      $oFormatHeader->set_color('black');
      $oFormatHeader->set_pattern();
      $oFormatHeader->set_fg_color('white');
  
      $oFormatSeries =& $workbook->add_format();
      //$oFormatSeries->set_border(1);
      $oFormatSeries->set_align('left');
      $oFormatSeries->set_color('black');
      $oFormatSeries->set_pattern();
      $oFormatSeries->set_fg_color('white');
      $oFormatSeries->set_text_wrap(true);
      
      $iHeightRow = 30;
      $iWidthCol = 15;
    
      $nbEntete = 0;
            //$strHtmlEntete = "<tr>";
            foreach($tabEntete as $entete) {
              //$strHtmlEntete .= "<td><b>".$entete."</b></td>";
              
              $worksheet1->set_row(0, $iHeightRow);
              $worksheet1->set_column(0, $nbEntete, $iWidthCol);
              $worksheet1->write_string(0, $nbEntete, mb_convert_encoding($entete, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING), $oFormatHeader);
              $nbEntete++;
            }
            foreach($tabEnteteTraitement as $entete) {
              //$strHtmlEntete .= "<td><b>".$entete."</b></td>";
              
              $worksheet1->set_row(0, $iHeightRow);
              $worksheet1->set_column(0, $nbEntete, $iWidthCol);
              $worksheet1->write_string(0, $nbEntete, mb_convert_encoding($entete, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING), $oFormatHeader);
              $nbEntete++;
            }
              //$strHtmlEntete .= "</tr>"; */
              $iRow = 1;
              for($i=0; $i<$nbRep; $i++) {
                //$strHtml .= "<tr>";  
                $iCol = 0; 
                
                $iRowSpan = max(1, (array_key_exists("traitement", $nodeArray[$i]) ? count($nodeArray[$i]["traitement"]) : 1));
                  
                foreach($tabEntete as $entete) {
                  $worksheet1->set_row($iRow, $iHeightRow);
                  // cas des traitements
                  if( isset($nodeArray[$i][$entete]) ) {  
                    $worksheet1->merge_cells($iRow, $iCol, $iRow+$iRowSpan-1, $iCol);
                    $worksheet1->write_string($iRow, $iCol, mb_convert_encoding($nodeArray[$i][$entete], ALK_EXPORT_ENCODING, ALK_HTML_ENCODING), $oFormatSeries);
                    //$strHtml .= "<td>".$nodeArray[$entete][$i]."</td>";
                  } //else {
                    //$worksheet1->write_string($iRow, $iCol, ".", $oFormatSeries);
                    //$strHtml .= "<td>&nbsp;</td>";
                  //}
                  $iCol++;
                } 
                  // affichage des traitments de la réponse
                  $iColMin = $iCol;
                  if ( array_key_exists("traitement", $nodeArray[$i]) ){// traitement(s) de la réponse
                    
                    foreach ( $nodeArray[$i]["traitement"] as $traitement){
                      $iCol = $iColMin;
                      foreach($tabEnteteTraitement as $entete) {
                        //$strHtmlEntete .= "<td><b>".$entete."</b></td>";
                        if( isset($traitement[$entete]) ) {                             
                          $worksheet1->write_string($iRow, $iCol, mb_convert_encoding($traitement[$entete], ALK_EXPORT_ENCODING, ALK_HTML_ENCODING), $oFormatSeries);
                        }
                        $iCol++;
                      }
                      $iRow++;
                    }
                  }
                  else {// pas de traitment pour la réponse, mais on inscrit une cellule vide
                    foreach($tabEnteteTraitement as $entete) {
                      $worksheet1->write_string($iRow, $iCol, mb_convert_encoding("", ALK_EXPORT_ENCODING, ALK_HTML_ENCODING), $oFormatSeries);
                      $iCol++;
                    }
                  }
                    $iRow++;
                  //$strHtml .= "</tr>";
                }
                
                $workbook->close();
                //$strHtml = "<table border='1'>".$strHtmlEntete.$strHtml."</table>";
    } else {
      $strHtml = _t("Aucune réponse.");
    }
    //echo $strHtml;
    //fwrite($handleExcel, mb_convert_encoding($strHtml, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING));
    //fclose ($handleExcel);
    if( $strHtml != "" ) {
      AffHeaderFileDownload("", "formulaire_".$form_id.".txt", 0, "text/plain");
      echo $strHtml;
    }
  }
  
  
  /**
   * Affiche les réponses au foramt pdf
   * @param form_id        identifiant du formulaire
   * @param strPathUpload  chemin physique du répertoire d'upload de l'application
   */
  private function doExportPdf($form_id, $strPathUpload)
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."html2pdf/html2fpdf.php");
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."html2pdf/fpdi/fpdi.php");
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."html2pdf/alkhtml2pdf.class.php");
    
    $strFileXml = $strPathUpload."formulaire_".$form_id.".xml";
   // on récupère les différents tableaux
    $list = $this->Construire_Tableau($strFileXml, $form_id);
    
   $nodeArray = $list[0];  
   $this->setTemplate("form", "alkhtmlformulairereponse.tpl"); 
   $this->oTemplate->assign("nodeArray", $nodeArray);
   
   $strHtml = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">".
      "<html>".
      "<head xmlns=\"http://www.w3.org/1999/xhtml\">".
      "<meta http-equiv=\"content-type\" content=\"text/html; charset=".ALK_HTML_ENCODING."\" />".
      "</head>".
      "<body>";
      
   $strHtml .= $this->oTemplate->fetch($this->strTemplateFile);
  
   $strHtml .= "</body></html>";
   //echo $strHtml;
   
   /*exit();
   // on va appliquer un 2ème template
   $this->setTemplate("html", "alkhtmlformulairereponseSSCaractSpe.tpl"); 
   
   $this->oTemplate->assign("strHtml", $strHtml1);
   $strHtm = $this->oTemplate->fetch($this->strTemplateFile);
   
   echo $strHtm ;*/
   
   $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM);
   $strPathSource = $strPathUpload;
   $strPathDest = $strPathUpload;
   $strUrlSource = ALK_ALKANET_ROOT_URL.ALK_ROOT_UPLOAD."form/";
    
    // création du fichier html
  
   // on vérifie que le fichier n'existait pas déjà
    if (file_exists($strPathSource."formulaire_".$form_id.".html")) unlink($strPathSource."formulaire_".$form_id.".html");
    if (file_exists($strPathSource."formulaire_".$form_id.".html")){
      $fp=fopen($strPathSource,"w");
      fwrite($fp, $strHtml);
      fclose($fp);
    }
   
    $docPDF = new AlkHtml2Pdf ($strUrlSource,$strPathSource,"formulaire_".$form_id.".html",$strHtml,$strPathDest,"formulaire_".$form_id.".pdf",true);
    $docPDF->setModeOutput("BROWSER");
    $docPDF->getPdf();
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."form/help/form_01_formulaire_list.htm");   
  }
  
  private function doExporTableauReponse ($form_id, $etat, $iSheet)
  {
    // création de la liste
    $adr_mail="";// adresse mail
    $titreForm="";// titre du formulaire
    $reponse_id="";// id reponse
    $date="";// date de réponse
    $EtatInitial = $etat;
    $strHtml = "";
    
    $this->dsForm = $this->oAppli->oQuery->GetDs_formulaire($form_id);
    if( $drForm = $this->dsForm->getRowIter() ) {
      $nomChampMail= $drForm->getValueName("FORM_CHAMPMAIL_AR");
      $titreForm = $drForm->getValueName(AlkFactory::getDBCurrentLanguageField("FORM_TITRE"));
    }
    
    $oTabReponses = AlkHtmlFactory::getHtmlList($this, 0, 1, 0, false,"", _t("Aucun résultat."),false,"list_initiale");
    
    $this->page  = AlkRequest::getToken("page", AlkRequest::_GETint("page", 1));
    $NbElmentparPage = 10;

    $iFirst = ($this->page-1)*$NbElmentparPage;
    $iLast = $this->page*$NbElmentparPage -1;
    
    if ($iFirst!=-1 & $iLast !=-1){
      $pagine = "javascript:displayReponses('".ALK_ALKANET."?token=".$this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_LIST, 
             "&form_id=".$form_id."&iMode=9"."&etat=".$EtatInitial)."', page)";
      $tab = $this->ExportTableauPagine($form_id,$EtatInitial,$iFirst, $iLast); // tableau des réponses
      $oTabReponses = AlkHtmlFactory::getHtmlList($this, count($tab), $this->page, $NbElmentparPage, true, $pagine, "",  _t("Aucune Réponse."));
    } else {
      $pagine="";
      $tab = $this->ExportTableauPagine($form_id,$EtatInitial); // tableau des réponses
      $oTabReponses = AlkHtmlFactory::getHtmlList($this, count($tab), 1, 20, false, $pagine, "",  _t("Aucune Réponse."));
    }
    // bouton pour voir les réponses qui sont dans l'état inverse
    
    $oPanelEtat = AlkHtmlFactory::getHtmlPanelFilterLink(_t("Etat(s) des réponses "), "&etat=".$etat."'");
    $oPanelEtat->setProperty("strAlign", "left");
    $oPanelEtat->setProperty("strAll", _t(""));
    $oPanelEtat->setProperty("iValueAll", "-1");
    $oPanelEtat->setProperty("strNothing", _t(""));

    $etat = ALK_FORM_ETAT_REPONSE_ATTENTE;
    $msgBt = _t("En attente");
    $toolTip = _t("Voir les réponses en attente");
    $strTokenBtAlt = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_LIST, "&form_id=".$form_id."&iMode=9");
    $oPanelEtat->addItem("&etat=".$etat."'", $msgBt, "javascript:displayReponses('".ALK_ALKANET."?token=".$strTokenBtAlt.")");

    $etat = ALK_FORM_ETAT_REPONSE_TRAITE; 
    $msgBt = _t("Traitées"); 
    $toolTip = _t("Voir les réponses traitées");
    $strTokenBtAlt = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_LIST, "&form_id=".$form_id."&iMode=9&etat=".$etat);
    $oPanelEtat->addItem("&etat=".$etat."'", $msgBt, "javascript:displayReponses('".ALK_ALKANET."?token=".$strTokenBtAlt.")");
    
    $nbRep = count($tab);
    $PanelTitre =  ($nbRep == 0 
                 ? _t("0 réponse  pour le formulaire ")
                 : _nf("%s réponse  pour le formulaire ", "%s réponses pour le formulaire ",  $nbRep)).$titreForm;
    
    $strHtml.= "<legend class=\"main\" align=\"left\"><span class=\"main\">Traitement des réponses</span></legend>";
    $strHtml.= "<div style='font-weight:bold;font-size:11px;'><br><br>".$PanelTitre."</div>";
    $strHtml.= $oPanelEtat->getHtml();
    
    $oTabReponses->SetColumns(array("left", "420"), array("center", "90"), array("center", "80"));
    $oTabReponses->AddTitleRow(array(_t("N° Réponse (cliquer sur le numéro pour voir le détail de la réponse)"),1), array(_t("Date réponse"), 1), array("Actions"));        
   // parcours du tableau des réponses
   
   foreach ($tab as $cle=>$valeur){
     $divAutresChamps="<div id=div".$cle." style=\"display:none;\">";
     foreach ($valeur as $champ=>$value){
       if ($champ == /*"form_".$form_id."_".*/$nomChampMail){
         $adr_mail = $value;
       }    
       if ($champ == "reponse_id"){
         $reponse_id = $value;
       } else if ($champ == "daterep"){
         $date = $value;
       } else if (substr($champ,0,10) == "traitement"){
         $divAutresChamps .= "<br/><b>".$champ." :</b><br/>";
          foreach ($value as $cleTraitement=>$valeurTraitement){
            $divAutresChamps .= "&nbsp;&nbsp;&nbsp;"."<b>".$cleTraitement." :&nbsp;</b>".$valeurTraitement."<br/>";
          }
       } else {
         //if (mb_substr(mb_strTolower($champ), 0, mb_strlen("form_".$form_id."_")) == "form_".$form_id."_")
           $champ = mb_strTolower($champ); //mb_substr(mb_strTolower($champ), mb_strlen("form_".$form_id."_"));
         $divAutresChamps .= "<b>".$champ." :&nbsp;</b>".$value."<br/>";
       }               
    }
    $divAutresChamps .= "</div>";
   
    // traitement du $reponse
    $reponse = "<div onClick=\"toggleDiv('div".$cle."');\" style='cursor: pointer; margin-bottom: 2px'><a>"._t("Voir la réponse N° ").$reponse_id."</a></div>"; 
    $reponse.= $divAutresChamps;
    
    $strHtmlActions = "";
    $strTokenTraiter = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $this->iSheet, ALK_SHEET_NONE,"&iMode=10"."&reponse_id=".$reponse_id."&form_id=".$form_id."&etat=".$EtatInitial); 
    $oBtVu = AlkHtmlFactory::getHtmlButtonIcon("javascript:ConfirmationTraitement('".ALK_ALKANET_SQL."?token=".$strTokenTraiter."', '"._t("Voulez-vous vraiment considérer cette réponse comme vu ?")."')", "Valider", _t("Traiter la réponse sans envoi de mail"));  
                                                    
    $strTokenDelete = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $this->iSheet, ALK_SHEET_NONE,"&iMode=11"."&reponse_id=".$reponse_id."&form_id=".$form_id."&etat=".$EtatInitial); 
    $oBtDelete = AlkHtmlFactory::getHtmlButtonIcon("javascript:ConfirmationTraitement('".ALK_ALKANET_SQL."?token=".$strTokenDelete."', '"._t("Confirmez-vous la suppression de cette réponse ?")."')", "Supprimer", _t("Supprimer cette réponse"));  
    // on remplit le HTML list
   
    $ligne = array($reponse, $date);
    // bouton vu
    if ($EtatInitial == ALK_FORM_ETAT_REPONSE_ATTENTE) 
      $strHtmlActions.= $oBtVu->getHtml()."&nbsp;";
      
    // bouton répondre : affiché qand il ya mail pr répondre
    if ($adr_mail != "" ){
      $strTokenRepondre = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_MAIL, ALK_SHEET_NONE,"&form_id=".$form_id."&form_exp_mail=".$adr_mail."&iMode=".ALK_FORM_MODE_ADD."&reponse_id=".$reponse_id."&etat=".$EtatInitial);  
      $oBtRepondre = AlkHtmlFactory::getHtmlButtonIcon("javascript:OpenPopupApercu('".$strTokenRepondre."')", "ENVTEST", _t("Répondre au destinataire"));
      $strHtmlActions.= $oBtRepondre->getHtml()."&nbsp;";           
    }
    
    $strHtmlActions.= $oBtDelete->getHtml();
    $ligne [] = $strHtmlActions; 
    $oTabReponses->addRowByArray($ligne); 
    
  }
  //$oTabReponses->enableBlock($PanelTitre, "",550,0);
  $tabRes["titre"] = $strHtml;
  $tabRes["oList"] = $oTabReponses->getHtml();
  
  return  $tabRes;

}
  
  private function UpdateFichierXMLByReponseID($reponse_id, $form_id, $message="Vu", $agent_mail="", $agent_nom="", $agent_id=""){
    $strFileXml = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM)."formulaire_".$form_id.".xml";

    if ($agent_nom=="") $agent_nom= $_SESSION["alk_userName"];
    if ($agent_mail=="") $agent_mail = $_SESSION["alk_userMail"];
    if ($agent_id=="") $agent_id = $_SESSION["alk_idUser"];
    
    if (file_exists($strFileXml)){
    $handleXml = fopen ($strFileXml, "r+"); 
    // parcours     
    $strXmlRep = file_get_contents($strFileXml);
    $strXmlRep .= "</formulaire>";
           
    $strXmlRep = str_replace(ALK_HTML_ENCODING, ALK_EXPORT_ENCODING, $strXmlRep);
    //$strXmlRep = mb_convert_encoding($strXmlRep, ALK_HTML_ENCODING, ALK_EXPORT_ENCODING);
    $oDom = DOMDocument::loadXML($strXmlRep);
    
    // on cherche le noeud reponse correspondant
    $oXPath = new DomXPath($oDom);
    $oNodeList = $oXPath->query("/formulaire/reponse[normalize-space(reponse_id)='".$reponse_id."']");
    if ( $oNodeList->length==0 ){
      return;
    }
    $oReponse = $oNodeList->item(0);
    // on crée les noeuds
    // 1. noeud message
    $NoeudMsg = $oDom->createElement("message", utf8_encode($message));
    // 2. noeud date_traitement
    $NoeudDate = $oDom->createElement("date_traitement", date("d/m/Y"));
    // 3. noeud agent_id
    $noeudAgent = $oDom->createElement("agent_id", $agent_id);
    // 4. Nouveau etat de reponse
    $noeudEtatReponse = $oDom->createElement("etat", ALK_FORM_ETAT_REPONSE_TRAITE);
    // 5. Noeud mail de l'agent qui répond
    $noeudAgentMail = $oDom->createElement("agent_mail", $agent_mail);
    // 6. Noeud nom de l'agent qui répond
    $noeudAgentNom = $oDom->createElement("agent_nom", $agent_nom);
    // 5. Noeud Traitement
    $Newnode = $oDom->createElement("traitement", ""); // Noeud Traitement
    $AncienNoeudEtat = $oReponse->getElementsByTagName("etat")->item(0); 
     
     // suppression du noeud Etat
    $oReponse->removeChild($AncienNoeudEtat);
    $Newnode->appendchild($NoeudMsg);
    $Newnode->appendchild($NoeudDate);
    $Newnode->appendchild($noeudAgent); 
    $Newnode->appendchild($noeudAgentMail);  
    $Newnode->appendchild($noeudAgentNom);  
    $oReponse->appendchild($Newnode);
    $oReponse->appendchild($noeudEtatReponse);
    $cat = str_replace ("</formulaire>","", $oDom->saveXml());
    $cat = mb_convert_encoding($cat, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
    fwrite($handleXml,$cat);

   }
  }
  
  /**
   * supprime une réponse
   * @param reponse_id identifiant de la réponse à supprimer
   * @param form_id identifiant du formulaire contenant la réponse à supprimer
   */
  public function UpdateFichierXMLByDeleteReponseID($reponse_id, $form_id){
    $strFileXml = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM)."formulaire_".$form_id.".xml";
    
    if (file_exists($strFileXml)){
      $handleXml = fopen ($strFileXml, "r+"); 
      // parcours     
      $strXmlRep = file_get_contents($strFileXml);
      $strXmlRep .= "</formulaire>";
             
      $strXmlRep = str_replace(ALK_HTML_ENCODING, ALK_EXPORT_ENCODING, $strXmlRep);
      $oDom = DOMDocument::loadXML($strXmlRep);
      
      // on cherche le noeud reponse correspondant
      $oXPath = new DomXPath($oDom);
      $oNodeList = $oXPath->query("/formulaire/reponse[normalize-space(reponse_id)='".$reponse_id."']");
      
      if ( $oNodeList->length > 0 ){
        $oReponse = $oNodeList->item(0);
        $oNodeRoot = $oDom->documentElement;
        $oNodeRoot->removeChild($oReponse);
        $cat = str_replace ("</formulaire>","", $oDom->saveXml());
        $cat = mb_convert_encoding($cat, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
        
        // destruction du fichier
        @fclose($handleXml);
        delFile($strFileXml);
        
        // création d'un nouveau fichier
        $strXml = "<?xml version=\"1.0\" encoding=\"".ALK_HTML_ENCODING."\"?>\n".
          "<formulaire id=\"".$form_id."\">\n";
        if ($cat == "")
          $cat = $strXml;
       
        $hFile = @fopen($strFileXml, "a");
        @fwrite($hFile, $cat);
        @fclose($handleXml);
      }
    }
  }
  private function ExportTableauPagine ($form_id, $etat, $iFirst=-1, $iLast=-1){
    
    $resultatInt = array();
    $resultat= array();
    $strFileXml = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM)."formulaire_".$form_id.".xml";

    if (file_exists($strFileXml)){
    $handleXml = fopen ($strFileXml, "r"); 
    // parcours     
    $strXmlRep = file_get_contents($strFileXml);
    
    $strXmlRep .= "</formulaire>"; 
    
    //echo $form_id;
     
    $strXmlRep = str_replace(ALK_HTML_ENCODING, ALK_EXPORT_ENCODING, $strXmlRep); 
    //$strXmlRep = mb_convert_encoding($strXmlRep, ALK_HTML_ENCODING, ALK_EXPORT_ENCODING);
    $oDom = DOMDocument::loadXML($strXmlRep);

    $oNodeRoot = $oDom->documentElement;
    if( $oNodeRoot->hasChildNodes() ) {
      $oNodesList =  $oNodeRoot->childNodes;
      
      // on sélectionne les noeuds réponses qui correspondent à l'état $EtatInitial        
      $oXPath = new DomXPath($oDom);
      //echo $etat."||".trim($etat);
      //echo "/formulaire/reponse[normalize-space(etat)='".trim($etat)."' and (position()>=".$iFirst." or position()<=".$iLast;
      if ($iLast !=-1 & $iFirst !=-1){
        $oNodeListReponsesTrouvees = $oXPath->query("/formulaire/reponse[normalize-space(etat)='".trim($etat)."' and (position()>=".$iFirst." or position()<=".$iLast.")]");
      } else {
         $oNodeListReponsesTrouvees = $oXPath->query("/formulaire/reponse[normalize-space(etat)='".$etat."'");
      }
      $nbElem = $oNodeListReponsesTrouvees->length;
      
       $reponse_id="";
       $reponse="";// chaine div contenant la reponse id
       $date="";
       $mail="";
        for($i=0; $i<$nbElem; $i++) {
        // niveau reponse
        $cpt=0;
        $oNode = $oNodeListReponsesTrouvees->item($i);
        if ($oNode->hasChildNodes()){
            $oNodesSubList = $oNode->childNodes;                       
            for ($j=0; $j< $oNodesSubList->length;$j++){
              if ($oNodesSubList->item($j)->nodeName!="#text"){
                  // on mets ts les champs ds le tableau                  
                  // cas traitement
                  $traitement = array();
                if ($oNodesSubList->item($j)->nodeName=="traitement"){
                   if ($oNodesSubList->item($j)->hasChildNodes()){
                    $nodeTraitement = $oNodesSubList->item($j)->childNodes;
                    for ($k=0;$k<$nodeTraitement->length;$k++){
                      if ($nodeTraitement->item($k)->nodeName !="#text"){
                        if( !array_key_exists($nodeTraitement->item($k)->nodeName, $traitement) ){
                          $traitement[$nodeTraitement->item($k)->nodeName]= $nodeTraitement->item($k)->nodeValue;
                        }
                      }
                  }
                 }
                 $cpt++;
                  $resultatInt[$oNodesSubList->item($j)->nodeName." ".$cpt]= $traitement;
                }else if( !array_key_exists($oNodesSubList->item($j)->nodeName, $resultatInt) ){
                  $resultatInt[$oNodesSubList->item($j)->nodeName]= $oNodesSubList->item($j)->nodeValue;
                  }
               }                        

            }// fin for
         }// has Child Nodes    
        $resultat[$i] = $resultatInt;
        $resultatInt = array();
       }
    }
   }
   return $resultat;
  }
}
?>