<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Form
Module formulaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

define("ALK_B_ATYPE_FORM", true);

//   Table : FORM_01_FORM                                       
$tabTable["form_01_form"] = array(
  "form_id"            => array("type" => "int", "dn" => "NOT NULL"),
  "form_titre_fr"      => array("type" => "varchar(255)", "dn" => ""),
  "form_titre_en"      => array("type" => "varchar(255)", "dn" => ""),
  "form_contenu_fr"    => array("type" => "text", "dn" => ""),
  "form_contenu_en"    => array("type" => "text", "dn" => ""),
  "form_msg_ar_fr"     => array("type" => "text", "dn" => ""),
  "form_msg_ar_en"     => array("type" => "text", "dn" => ""),
  "form_msg_ar_es"     => array("type" => "text", "dn" => ""),
  "form_msg_ar_it"     => array("type" => "text", "dn" => ""),
  "form_msg_ar_pt"     => array("type" => "text", "dn" => ""),
  "form_mail"          => array("type" => "varchar(255)", "dn" => ""),
  "form_sondage"       => array("type" => "int", "dn" => "DEFAULT 0"),
  "form_datecrea"      => array("type" => "datetime", "dn" => "NOT NULL"),
  "agent_id_crea"      => array("type" => "int", "dn" => "NOT NULL"),
  "form_datemaj"       => array("type" => "datetime", "dn" => ""),
  "agent_id_maj"       => array("type" => "int", "dn" => "NOT NULL"),
  "form_javascript_fr" => array("type" => "text", "dn" => ""),
  "form_javascript_en" => array("type" => "text", "dn" => ""),
  "form_datepdeb"      => array("type" => "datetime", "dn" => ""),
  "form_datepfin"      => array("type" => "datetime", "dn" => ""),
  "form_nbrep_max"     => array("type" => "int", "dn" => ""),
  "form_btsave"        => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "form_validepub"     => array("type" => "int", "dn" => "DEFAULT 0"),
  "form_validesynd"    => array("type" => "int", "dn" => "DEFAULT 0"),
  "form_envoi_ar"      => array("type" => "int", "dn" => ""),
  "form_envoi_pdf"     => array("type" => "int", "dn" => "DEFAULT 0"),
  "form_donnees_ar"    => array("type" => "int", "dn" => ""),
  "form_contenu_ar"    => array("type" => "text", "dn" => ""),
  "form_champmail_ar"  => array("type" => "varchar(255)", "dn" => ""),
  "form_alaune"        => array("type" => "int", "dn" => ""),
  "form_secure"        => array("type" => "int", "dn" => ""),
  "form_rep_unique"    => array("type" => "int", "dn" => ""),
  "appli_id"           => array("type" => "int", "dn" => ""),
  );

$tabPk["form_01_form"]["pk_form_01_form"] = "form_id";

$tabIdx["form_01_form"] = array(
  "form_appliid_fk" => "appli_id",
  "formform_agentidc_fk" => "agent_id_crea",
  "formform_agentidm_fk" => "agent_id_maj",
  );

$tabFk["form_01_form"] = array(
  "fk_form_appliid"      => array("ffk" => "appli_id", "tpk" => "sit_appli", "fpk" => "appli_id"),
  "fk_formform_agentidc" => array("ffk" => "agent_id_crea", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_formform_agentidm" => array("ffk" => "agent_id_maj", "tpk" => "sit_agent", "fpk" => "agent_id"),
  );

$tabSeq["seq_form_01_form"] = "10";

//   Table : FORM_01_FORM_BLOC                                    
$tabTable["form_01_form_bloc"] = array(
  "form_id"   => array("type" => "int", "dn" => "NOT NULL"),
  "bloc_id"   => array("type" => "int", "dn" => "NOT NULL"),
  "form_rang" => array("type" => "int", "dn" => "NOT NULL"),
  );

$tabPk["form_01_form_bloc"]["pk_form_01_form_bloc"] = "bloc_id, form_id";

$tabIdx["form_01_form_bloc"] = array(
  "formformbloc_blocid_fk" => "bloc_id",
  "formformbloc_formid_fk" => "form_id",
  );
  
$tabFk["form_01_form_bloc"] = array(
  "fk_formformbloc_blocid" => array("ffk" => "bloc_id", "tpk" => "gedit_01_bloc", "fpk" => "bloc_id"),
  "fk_formformbloc_formid" => array("ffk" => "form_id", "tpk" => "form_01_form", "fpk" => "form_id"),
  );

// vues                                   
$tabView["v_gedit_form_data"] = "(CONT_ID, APPLI_ID, CAT_ID, DATA_ID, DATA_TYPE, DATA_NBREP_MAX, DATA_BTSAVE,
 CAT_INTITULE_FR, CAT_INTITULE_EN,
 DATA_TITRE_FR, DATA_DESCL_FR, DATA_DESC_FR, 
 DATA_TITRE_EN, DATA_DESCL_EN, DATA_DESC_EN, 
 DATA_DATEPDEB, DATA_DATEPFIN, DATA_DATEMAJ, DATA_VALIDEPUB, DATA_VALIDESYND,
 USER_ID, RIGHT_ID, DATA_SONDAGE, DATA_ALAUNE, DATA_SECURE, DATA_REP_UNIQUE) as
select ac.CONT_ID, f.APPLI_ID, 0 as CAT_ID, f.FORM_ID as DATA_ID, 0 as DATA_TYPE, f.FORM_NBREP_MAX, f.FORM_BTSAVE,
   ".$dbConn->getCast("''", "varchar(255)")." as CAT_INTITULE_FR,  ".$dbConn->getCast("''", "varchar(255)")." as CAT_INTITULE_EN,
  f.FORM_TITRE_FR as DATA_TITRE_FR, f.FORM_CONTENU_FR as DATA_DESCL_FR, ".$dbConn->getCast("''", "varchar(255)")." as DATA_DESC_FR,
  f.FORM_TITRE_EN as DATA_TITRE_EN, f.FORM_CONTENU_EN as DATA_DESCL_EN, ".$dbConn->getCast("''", "varchar(255)")." as DATA_DESC_EN,
  f.FORM_DATEPDEB as DATA_DATEPDEB, f.FORM_DATEPFIN as DATA_DATEPFIN,
  f.FORM_DATEMAJ as DATA_DATEMAJ, f.FORM_VALIDEPUB as DATA_VALIDEPUB, f.FORM_VALIDESYND as DATA_VALIDESYND,
  dr.USER_ID, dr.RIGHT_ID, f.FORM_SONDAGE as DATA_SONDAGE, f.FORM_ALAUNE as DATA_ALAUNE,
  f.FORM_SECURE as DATA_SECURE, f.FORM_REP_UNIQUE as DATA_REP_UNIQUE   
from FORM_01_FORM f 
  inner join V_USER_RIGHT dr on f.APPLI_ID=dr.APPLI_ID
  inner join SIT_APPLI_CONT ac on f.APPLI_ID=ac.APPLI_ID";

$tabView["v_synd_form_data"] = "(CONT_ID, APPLI_ID, CAT_ID, DATA_ID, DATA_TYPE, 
 CAT_INTITULE_FR, CAT_INTITULE_EN,
 DATA_TITRE_FR, DATA_DESCL_FR, 
 DATA_TITRE_EN, DATA_DESCL_EN, 
 DATA_DATEPDEB, DATA_DATEPFIN, DATA_SONDAGE, DATA_ALAUNE, DATA_SECURE, DATA_REP_UNIQUE) as
select ac.CONT_ID, f.APPLI_ID, 0 as CAT_ID, f.FORM_ID as DATA_ID, 0 as DATA_TYPE,
   ".$dbConn->getCast("''", "varchar(255)")." as CAT_INTITULE_FR,  ".$dbConn->getCast("''", "varchar(255)")." as CAT_INTITULE_EN,
  f.FORM_TITRE_FR as DATA_TITRE_FR, f.FORM_CONTENU_FR as DATA_DESCL_FR,
  f.FORM_TITRE_EN as DATA_TITRE_EN, f.FORM_CONTENU_EN as DATA_DESCL_EN, 
  f.FORM_DATEPDEB as DATA_DATEPDEB, f.FORM_DATEPFIN as DATA_DATEPFIN,
  f.FORM_SONDAGE as DATA_SONDAGE, f.FORM_ALAUNE as DATA_ALAUNE,
  f.FORM_SECURE as DATA_SECURE, f.FORM_REP_UNIQUE as DATA_REP_UNIQUE   
from FORM_01_FORM f 
  inner join SIT_APPLI_CONT ac on f.APPLI_ID=ac.APPLI_ID
where (f.FORM_VALIDEPUB=1 and f.APPLI_ID>0) or f.APPLI_ID=-3"; 

// type appli                                   
$tabIns[] = "INSERT INTO SIT_APPLI_TYPE (ATYPE_ID, ATYPE_ID_DIST, ATYPE_INTITULE, ATYPE_ABREV, ATYPE_URL, ATYPE_URL_ADMIN, ATYPE_URL_SITE,".
  " ATYPE_DROIT, ATYPE_DISPO, ATYPE_DESC, ATYPE_URL_TARGET, ATYPE_COMPATIBLE, ATYPE_LOGO, ATYPE_ADMIN_LOGO)".
  " VALUES(32, -1, 'Formulaire', 'form', '', '', '', 1, 1, '', '', 1, 'picto32_form.gif', '')";

// appli spécifique accessible pour la syndication
$tabIns[] = "INSERT INTO SIT_APPLI (APPLI_ID, ATYPE_ID, APPLI_INTITULE, APPLI_LOGO, APPLI_RANG, AGENT_IDCREA, AGENT_IDMAJ, APPLI_DATECREA, APPLI_DATEMAJ)".
  " VALUES (-3, 32, 'Formulaires pour diffusion circulaire', NULL, 0, 1, 1, ".$dbConn->getDateCur().", ".$dbConn->getDateCur().")";

if( defined("ALK_B_ATYPE_GEDIT") && ALK_B_ATYPE_GEDIT==true ) {
   $tabIns[] = "INSERT INTO GEDIT_01_APPLI_TYPE (ATYPE_ID) values (32)";
   $tabIns[] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) values (32, 1, 'Page formulaire', '', 'Data|pageForm')";
}

// constantes                                   
$tabIns[] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
  " VALUES (-1, -1, 'ALK_B_ATYPE_FORM', 'true', 'Module installé', 3, 1)";
$tabIns[] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
  " VALUES (32, -1, 'ALK_B_FORM_AR', 'false', '".$dbConn->analyseSql("Possibilité d'accusé réception à la validation")."', 3, 1)";
$tabIns[] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
  " VALUES (32, -1, 'ALK_B_FORM_EXPORT_PDF', 'false', '".$dbConn->analyseSql("Possibilité d'export PDF des réponses aux formulaires")."', 3, 1)";
$tabIns[] = " INSERT INTO SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN, CONST_LEVEL)" .
    " VALUES (32, -1, 'ALK_B_FORM_MODE_COOKIE', 'true', NULL, '3', '1', '0')";
$tabIns[] = " INSERT INTO SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN, CONST_LEVEL)" .
    " VALUES (32, -1, 'ALK_B_FORM_REPONSE', 'true', NULL, '3', '1', '0')";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
  " VALUES (32, -1, 'ALK_B_FORM_NBREPONSE_MAX', 'false', '".$dbConn->analyseSql("Permet de limiter le nombre de réponses à un formulaire")."', 3, 1);"; 
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
  " VALUES (32, -1, 'ALK_B_FORM_ENREGISTREMENT', 'false', '".$dbConn->analyseSql("Permet d'enregister les données saisies dans un formulaire sans valider celui-ci")."', 3, 1);";    
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
  " VALUES (32, -1, 'ALK_B_FORM_FIELDSET_COLONNE', 'false', '".$dbConn->analyseSql("Permet de définir un fieldset comme étant une colonne de formulaire")."', 3, 1);"; 
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
  " VALUES (32, -1, 'ALK_B_FORM_SECURE', 'false', '".$dbConn->analyseSql("Permet de pouvoir activer sur les formulaires la version sécurisée avec certificat SSL")."', 3, 1);";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
  " VALUES (32, -1, 'ALK_B_FORM_REP_UNIQUE', 'false', '".$dbConn->analyseSql("Permet de pouvoir activer le controle de l'adresse IP de chaque personne répondant au formulaire")."', 3, 1);"; 
$tabSeq["seq_form_01_reponse"] = "10";

//   Mailing
$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)".
  " VALUES('FORM_SAVE_DATA', '".$dbConn->analyseSql("Mailing envoyé après une saisie formulaire", false)."',".
  "'{\$apptitle} : {\$msgTitle}',".
  " '<html><p>Bonjour,<br/><br/>".
  "{\$msg}<br/>".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";
  
$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)".
  " VALUES('FORM_MAIL_REPONSE', '".$dbConn->analyseSql("Mail envoyé en réponse à un utilisateur", false)."',".
  " '{\$apptitle} - {\$msgTitle}',".
  " '<html><p>Bonjour,<br/><br/>".
  "{\$msg}<br/><br/>".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>"."', NULL)";

$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)".
  " VALUES('FORM_SAVE_DATA_AR', '".$dbConn->analyseSql("Mailing AR envoyé après une saisie formulaire", false)."',".
  " '{\$apptitle} : {\$msgTitle}.',".
  " '<html><p>Bonjour,<br/><br/>".
  "{\$msg}<br/>".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";

?>