/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * Affiche/maque les controles en fonction du type de tâche sélectionné
 * désactive les controles masqués
 * active les controles affichés
 */
function SwitchTypeTask()
{
  // tableau des controles visibles en fonction du type de tâche
  var tabTypeTask = new Array();
  tabTypeTask[0] = new Array("task_jourssemaine_0", "task_joursmois_0", "task_mois_0", "task_typetime");
  tabTypeTask[1] = new Array("task_date");
  
  var tabRadio = document.getElementsByName("task_typetask");
  if ( !tabRadio ) return;
  var i = 0;
  while ( i < tabRadio.length ) {
    var oRadio = tabRadio[i];
    if ( oRadio.checked == true ) {
      var j = 0;
      while ( j < tabTypeTask[i].length ) {
        var oLine = document.getElementById(tabTypeTask[i][j]+"_line");
        if ( oLine ) {
          var tabInput = oLine.getElementsByTagName("INPUT");
          var k = 0;
          while ( k < tabInput.length ) {
            var oInput = tabInput[k];
            oInput.disabled = false;
            k++;
          }
          oLineStyle= ( oLine.style ? oLine.style : oLine );
          oLineStyle.display = "";
        }
        j++;
      }
    } else {
      var j = 0;
      while ( j < tabTypeTask[i].length ) {
        var oLine = document.getElementById(tabTypeTask[i][j]+"_line");
        if ( oLine ) {
          oLineStyle = ( oLine.style ? oLine.style : oLine );
          oLineStyle.display = "none";
          var tabInput = oLine.getElementsByTagName("INPUT");
          var k = 0;
          while ( k < tabInput.length ) {
            var oInput = tabInput[k];
            oInput.disabled = true;
            k++;
          }
        }
        j++;
      }
    }
    i++;
  }
  switchLabelHour();
}

/**
 * Initialise le label des heures en fonction du type de tâche et du type d'heure sélectionné
 */
function switchLabelHour()
{
  var oCtrlLabel = document.getElementById("label_task_hour");
  if ( !oCtrlLabel ) return;
  var tabRadioTypeTask = document.getElementsByName("task_typetask");
  if ( !tabRadioTypeTask ) return;
  var i = 0;
  while ( i < tabRadioTypeTask.length ) {
    var oRadioTypeTask = tabRadioTypeTask[i];
    if ( oRadioTypeTask.checked == true ) {
      switch ( i ) {
        case 0 :  // périodique
          var tabRadioTypeHour = document.getElementsByName("task_typetime");
          var j = 0;
          while ( j < tabRadioTypeHour.length ) {
            var oRadioTypeHour = tabRadioTypeHour[j];
            if ( oRadioTypeHour.checked == true ) {
              switch ( j ) {
                case 0 :  // fréquence
                oCtrlLabel.innerHTML = _gt("Toutes les");
                break;
                case 1 :  // fixe
                  oCtrlLabel.innerHTML = _gt("A");
                break;
              }
            }
            j++;
          }
        break;
        case 1 :  // ponctuelle
          oCtrlLabel.innerHTML = "A";
          return;
        break;
      }
    }
    i++;
  }
}