<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlPopupChangePwd
 * Classe de gestion de la personnalisation du mot de passe  
 */
class alkhtmlPopupChangePwd extends AlkHtmlForm
{
  /** mot de passe */
  protected $str1Pwd;
  
  /** confirmation mot de passe */
  protected $str2Pwd;

  /**
   * constructeur par défaut
   * @param oAppli Référence sur l'application courante
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formPwd");  
    $strToken = AlkRequest::getEncodeParam("cont_id=1&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_CHANGEPWD); 
    $strAction = ALK_ALKANET_SITE_SQL."?token=".$strToken;
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, $strAction);
   }
   
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  public function setData($iTypeInit) { }

  /**
   * Traitement du formulaire
   */ 
  public function doSql() 
  {
    $user_id     = AlkFactory::getSProperty("user_id", "-1");
    $service_id  = AlkFactory::getSProperty("service_id", "-1");
    $service_id  = AlkFactory::getSProperty("service_id", "-1");
    $strSigle    = AlkFactory::getSProperty("service_sigle", "");
    
    
    $strPwd = AlkRequest::_POST("str1Pwd", "");
    $this->iModeRedirect = AlkRequest::_POST("iModeRedirect", "-1");
    
    if($this->iModeRedirect != "-1"){
      $strUrl = "";
    }else{
      $strUrl = ALK_ALKANET_IDENT;
    } 
    
    if( $user_id != "-1" ) {
      $QueryAnnuAction = AlkFactory::getQueryAction(ALK_ATYPE_ID_ANNU);        
      $QueryAnnuAction->updateUserPwd($user_id, $strPwd);
      if($this->iModeRedirect == "-1"){ 
        $strUrl = AlkFactory::getSProperty("user_home", "");
      }
    }

    echo getBodyOnLoadExec("", "closeWindow('".$strUrl."')");
    exit();
  }

  /**
   * retourne le titre / surcharge car pour les popup le gethtml est appelé après
   * @return string 
   */
  public function getTitle()
  {
    $strTitle = _t("Veuillez modifier votre mot de passe")." :"; 
    $this->setTitle($strTitle);
    return $strTitle;
  }  
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {
    $this->str1Pwd = new AlkFormData($this, "str1Pwd", "", ALK_SQL_TEXT);
    $this->str2Pwd = new AlkFormData($this, "str2Pwd", "", ALK_SQL_TEXT);

    $this->iModeRedirect    = AlkFactory::getSProperty("iModeRedirect", "-1");
    $iLarg = 500;
    
            
    
    $oCtrlPwd1 = AlkHtmlFactory::getHtmlText($this->str1Pwd, _t("Entrez un nouveau mot de passe"), 1, 15, 80);
    $oCtrlPwd1->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT, ALK_ANNU_LG_MIN_PWD, ALK_ANNU_LG_MAX_PWD);
    $oCtrlPwd1->setBPassword(true);    
    $oCtrlPwd2 = AlkHtmlFactory::getHtmlText($this->str2Pwd, _t("Entrez le mot de passe à nouveau pour le confirmer"), 1, 15, 80);
    $oCtrlPwd2->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT, ALK_ANNU_LG_MIN_PWD, ALK_ANNU_LG_MAX_PWD);
    $oCtrlPwd2->setBPassword(true);   
    
    $oBlock = $this->addBlock("blockPwd","", "", "320", "150");
    $oBlock->addCtrl($oCtrlPwd1);
    $oBlock->addCtrl($oCtrlPwd2);
    
    if($this->iModeRedirect != "-1"){
      $strUrl = ALK_ALKANET_IDENT;
      $strTxt = _t("Vous avez également la possibilité de modifier votre mot de passe sur votre fiche annuaire.");
    $this->setLabelDesc($strTxt);
    }else{
      $strUrl = "";
      $hidden = new AlkFormData($this, "iModeRedirect", "2", ALK_SQL_TEXT);
      $oHidden = AlkHtmlFactory::getHtmlHidden($hidden);
      $oBlock->addCtrl($oHidden);
    }
    
    
    $strSigle    = AlkFactory::getSProperty("service_sigle", ""); 
    $oBtVal = $this->addButtonPage("BtVal", "javascript:Valider('".$strSigle."', '".ALK_ANNU_PWD_ENCRYPTION."');", _t("Valider"), _t("Valider l'authentification"));
    $this->addSubmitButton($oBtVal);
    $oBtAnnuler = $this->addButtonPage("BtAnnuler", "javascript:closeWindow('".$strUrl."')", _t("Annuler"), _t("Annuler l'authentification"));
    
    $this->addOnload("onLoadWindAuth()");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlpopupchangepwd.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_crypt.js");
  }
  
}
?>