<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."excel/Workbook.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkpData.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkpChart.class.php");
/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormStatList
 * Classe d'affichage des statistiques par espace et par application
 * Pour activer les statistiques par application, il faut définir la constante ALK_B_SPACE_STAT_APPLI à true
 */
class AlkHtmlFormStatList extends AlkHtmlForm
{
  protected $iMois;
  protected $iAnnee;
  protected $iCont;
  protected $iDataType;
  protected $iService;
  protected $iUser;
  protected $iExport;
  protected $iData;
  private static $iNumSubPanel = 0;
  private $workbook;
  private $currentWorksheet;

  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formStat");	
    
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
    $this->iExport = 0;
    $this->workbook = null;
    
    $this->iMode = AlkRequest::getToken("iMode", AlkRequest::_REQUESTint("iMode",  1));
    
    $this->atype_id = AlkRequest::getToken("atype_id", -1);
    $this->idAppli = AlkRequest::getToken("idAppli", -1);
  } 
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { }
  
  /**
   * Traitement du formulaire
   */
  public function doSql()
  {
  	 
  	$export = AlkRequest::getToken("export",0);
  	echo $export;
  	switch( $export ) {
  		case 1 : 
  			$this->iExport = 1;
  			$this->setContents();
  			break;
  		case 2 :
  			$imagePath = AlkRequest::getToken("imagePath", "");
  			$this->downloadImage($imagePath);
  			break;
  	}
  	return "";
  }

  /**
   * Retourne le titre du panel
   * @return string
   */
  public function getLabel()
  {
    switch ( $this->iMode ) {
      case 1 :
        return _f("Statistiques de l'espace %s", $this->oAppli->getAppliProperty("CONT_INTITULE"));
      break;
      case 2 :
        $oAppli = AlkFactory::getAppli($this->atype_id, $this->idAppli);
        return _f("Statistiques de l'application %s - espace %s", 
                   $oAppli->getAppliProperty("APPLI_INTITULE"), $this->oAppli->getAppliProperty("CONT_INTITULE"));
      break;
    }
  }

  /**
   * Construction du formulaire
   */
  public function setContents()
  {
  	$queryCont = $this->oAppli->oQuery;
    $dbConn = AlkFactory::getDbConn();
    
    // récupère les datatypes SIT par rapport au atype_id
    $strSql = "select DATATYPE_INTITULE as txt, DATATYPE_ID as id, TABLE_REF, FIELD_PK, FIELDS_TEXT, SELECTING_WHERE from SIT_DATATYPE where APPLI_STAT=1 and ATYPE_ID=".$this->atype_id." order by DATATYPE_ID";
    $oDsDataType = $queryCont->getDs($strSql);
    $iDataTypeDefault = -1;
    if ( $oDrDataType  = $oDsDataType->getRowIter() ) {
      $iDataTypeDefault = $oDrDataType->getValueName("id");
    }
    $oDsDataType->moveFirst();
    
    $cont_id    = $this->oAppli->cont_id;
    $user_priv  = AlkFactory::getSProperty("user_priv", ALK_PRIV_SPACE_NONE);
    $iMois      = AlkRequest::_REQUESTint("iMois", AlkRequest::getToken("iMois", date("n", AlkFactory::getLocalDate())));
    $iAnnee     = AlkRequest::_REQUESTint("iAnnee", AlkRequest::getToken("iAnnee", date("Y", AlkFactory::getLocalDate())));
    $iCont      = AlkRequest::_POSTint("iCont",  $cont_id);
    $iDataType  = AlkRequest::_REQUESTint("iDataType", AlkRequest::getToken("iDataType", $iDataTypeDefault));
    $iService   = AlkRequest::_REQUESTint("iService", AlkRequest::getToken("iService", -1));
    $iUser      = AlkRequest::_REQUESTint("iUser", AlkRequest::getToken("iUser", -1));
    $iData      = AlkRequest::_REQUESTint("iData", AlkRequest::getToken("iData", -1));
    
    $tabMois = array( 0 => _t("Tous"), 1 => _t("Janvier"), 2 => _t("Février"),  3 => _t("Mars"),  4 => _t("Avril"),  
                      5 => _t("Mai"), 6 => _t("Juin"), 7 => _t("Juillet"), 8 => _t("Août"), 9 => _t("Septembre"), 
                      10 => _t("Octobre"), 11 => _t("Novembre"), 12 => _t("Décembre"));
    
    // construit le dataset des services
    $strSql = "select SERVICE_INTITULE as TXT, SERVICE_ID as ID from SIT_SERVICE where SERVICE_NIVEAU>0";
    $oDsService = $queryCont->getDs($strSql);
    
    // construit le dataset des utilisateurs
    $strSql = "select ".$dbConn->getConcat("AGENT_PRENOM", "' '", "AGENT_NOM")." as TXT, sa.AGENT_ID as ID from SIT_AGENT sa" .
      " inner join SIT_AGENT_SERVICE sas on sa.AGENT_ID=sas.AGENT_ID" .
      " where sa.AGENT_VALIDE=1" .
      ( $iService != -1 ? " and sas.SERVICE_ID=".$iService : "" ) .
      " order by TXT";
    $oDsUser = $queryCont->getDs($strSql);
    $bUserExists = false;
    while ( $oDrUser = $oDsUser->getRowIter() ) { // vérifie que l'utilisateur posté appartient au nouveau dataset
      $user_id = $oDrUser->getValueName("ID");
      if ( $user_id == $iUser ) {
        $bUserExists = true;
      }
    }
    if ( !$bUserExists ) {
      $iUser = -1;
    }
    
    // construit le dataset des données
    $dsPage = null;
    $oDsDataType->moveFirst();
    while ( $oDrDataType  = $oDsDataType->getRowIter() ) {
      $iDatatypeId = $oDrDataType->getValueName("id");
      if($iDatatypeId == $iDataType){
        $strTableRef = $oDrDataType->getValueName("TABLE_REF");
        $strFieldPk  = $oDrDataType->getValueName("FIELD_PK");
        $strFields   = $oDrDataType->getValueName("FIELDS_TEXT");
        $strWhere    = $oDrDataType->getValueName("SELECTING_WHERE");
        $tabFields   = explode("|", $strFields);
        
        if ($this->atype_id == ALK_ATYPE_ID_GEDIT){
          $strWhere = str_replace("_APPLI_ID_", $this->idAppli, $strWhere);
          $strWhere = str_replace("_USER_ID_", AlkFactory::getSProperty("user_id", -1), $strWhere);
        }
        $strSql = "select ".$tabFields[0]." as INTITULE, ".$strFieldPk." as ID ".
            " from ".$strTableRef.
            " where ".$strWhere;
        $dsPage = $queryCont->getDs($strSql);
      }     
    }
   
    if( $this->iExport == 0 ) {
      $this->iMois      = new AlkFormData($this, "iMois", $iMois, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
      $this->iAnnee     = new AlkFormData($this, "iAnnee", $iAnnee, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
      $this->iCont      = new AlkFormData($this, "iCont", $iCont, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
      $this->iDataType  = new AlkFormData($this, "iDataType", $iDataType, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
      $this->iService   = new AlkFormData($this, "iService", $iService, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
      $this->iUser      = new AlkFormData($this, "iUser", $iUser, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
      $this->iData      = new AlkFormData($this, "iData", $iData, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
      

      $strParam = "cont_id=".$this->oAppli->cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_ADMIN."&iSheet=".ALK_SHEET_STATS."&iMode=".$this->iMode."&atype_id=".$this->atype_id."&idAppli=".$this->idAppli;
      $strToken = AlkRequest::getEncodeParam($strParam);

      $oCtrlMois = AlkHtmlFactory::getHtmlSelect($this->iMois, _t("Mois"), 1, 152);
      $oCtrlMois->setProperty("tabValTxt", $tabMois);
      $oCtrlMois->addEvent("onchange", "Valider('".$strToken."')");
      
      $oCtrlAnnee = AlkHtmlFactory::getHtmlSelect($this->iAnnee, _t("Année"), 1, 152);
      $strSql = "select ANNEE_CONNEXION as txt, ANNEE_CONNEXION as id from SIT_STATISTIQUE group by ANNEE_CONNEXION";
      $oCtrlAnnee->setProperty("oValTxt", $queryCont->getDs($strSql));
      $oCtrlAnnee->addEvent("onChange", "Valider('".$strToken."')");
      
      $oCtrlEspace = null;
      if( $this->iMode == 1 && ($user_priv & ALK_PRIV_SPACE_ADMIN) == ALK_PRIV_SPACE_ADMIN ) {
        $oCtrlEspace = AlkHtmlFactory::getHtmlSelect($this->iCont, _t("Cible"), 1);
        $oCtrlEspace->setProperty("tabValTxt", array($cont_id => _t("Cet espace"), "-1" => _t("Tous les espaces")));
        $oCtrlEspace->addEvent("onchange", "Valider('".$strToken."')");
      } else {
        $oCtrlEspace = AlkHtmlFactory::getHtmlHidden($this->iCont);
      }
      
      // contrôles supplémentaires pour statistiques par application
      $oCtrlDataType = null;
      $oCtrlService = null;
      $oCtrlUser = null;
      if ( $this->iMode == 2 ) {
        // contrôle de sélection du type de donnée
        $oCtrlDataType = AlkHtmlFactory::getHtmlSelect($this->iDataType, _t("Type de donnée"), 1, 350);
        $oCtrlDataType->setProperty("oValTxt", $oDsDataType);
        $oCtrlDataType->setProperty("strFieldValue", "ID");
        $oCtrlDataType->setProperty("strFieldText", "txt");
        $oCtrlDataType->addEvent("onChange", "Valider('".$strToken."')");
        // contrôle de sélection du service
        $oCtrlService = AlkHtmlFactory::getHtmlSelect($this->iService, _t("Service"), 1, 350);
        $oCtrlService->setProperty("oValTxt", $oDsService);
        $oCtrlService->setProperty("tabValTxtDefault", array("-1", _t("Tous")));
        $oCtrlService->addEvent("onChange", "Valider('".$strToken."')");
        // contrôle de sélection de l'utilisateur
        $oCtrlUser = AlkHtmlFactory::getHtmlSelect($this->iUser, _t("Utilisateur"), 1, 350);
        $oCtrlUser->setProperty("oValTxt", $oDsUser);
        $oCtrlUser->setProperty("tabValTxtDefault", array("-1", _t("Tous")));
        $oCtrlUser->addEvent("onChange", "Valider('".$strToken."')");
        // contrôle de sélection sur les pages
        $oCtrlData = AlkHtmlFactory::getHtmlSelect($this->iData, _t("Données"), 1, 350);
        $oCtrlData->setProperty("oValTxt", $dsPage);
        $oCtrlData->setProperty("tabValTxtDefault", array("-1", _t("Toutes")));
        $oCtrlData->addEvent("onChange", "Valider('".$strToken."')");
      }      
      
      $oBlockCritere = $this->addBlock("Block_Critere", _t("Critères de sélection"), "", 120, 390, true);
      $oBlockCritere->addCtrl($oCtrlMois);
      $oCtrlMois->addCtrl($oCtrlAnnee);
      $oBlockCritere->addCtrl($oCtrlEspace);
      $oBlockCritere->addCtrl($oCtrlDataType);
      if ( $this->iMode == 2 ) {
        $oBlockCritere->addCtrl($oCtrlData);
      }
      
      $oBlockCritere->addCtrl($oCtrlService);
      $oBlockCritere->addCtrl($oCtrlUser);
      //$oBlockCritere->setTemplate("espace", "alkhtmlblockstatcritere.tpl");  
    } else {
      $this->initExcel(); 
    }
    $iBlock = 0;
    if( $this->iMode == 1 ){// affichage contenu statistique général 
      if( $iCont != -1 ) {
        $strCondDate = ( $iMois > 0 ? " and st.MOIS_CONNEXION=".$iMois : "" ).
          ( $iAnnee > 0 ? " and st.ANNEE_CONNEXION=".$iAnnee : "" );
      
        $strTitleDate = ( $iMois > 0 ? $tabMois[$iMois]." " : "" ).$iAnnee;
  
        // Nb de visites par application de l'espace
        $strTitle = _f("Nb de visites par application de l'espace en %s", $strTitleDate);
        
        if( $this->iExport == 1 ) {
          $this->addExcelSheet("NbVisitesParAppli", $strTitle);
        }
        $oBlock =& $this->addBlock("Block_".($iBlock++), $strTitle, "", 10, 590, false);
        if( $iMois > 0 ) {
          $strSql = "select a.ATYPE_ID, a.APPLI_ID, a.APPLI_INTITULE as INTITULE, sum(st.NB_CONNEXION) as NB".
            " from SIT_STATISTIQUE st".
            "   inner join SIT_APPLI a on (st.ID_TYPE_CONNEXION=a.APPLI_ID and st.TYPE_CONNEXION=2)".
            "   inner join SIT_APPLI_CONT ac on a.APPLI_ID=ac.APPLI_ID".
            "  where ac.CONT_ID=".$cont_id.$strCondDate.
            " group by a.ATYPE_ID, a.APPLI_ID, a.APPLI_INTITULE".
            " order by NB desc";
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableTxtNb($dsData, _t("Applications"), _t("Nb connexions"), $iMois, $iAnnee, true,true);
        } else {
          $strSql = "select a.ATYPE_ID, a.APPLI_ID, a.APPLI_INTITULE as INTITULE, sum(st.NB_CONNEXION) as NB, st.MOIS_CONNEXION as MOIS".
            " from SIT_STATISTIQUE st".
            "   inner join SIT_APPLI a on (st.ID_TYPE_CONNEXION=a.APPLI_ID and st.TYPE_CONNEXION=2)".
            "   inner join SIT_APPLI_CONT ac on a.APPLI_ID=ac.APPLI_ID".
            "  where ac.CONT_ID=".$cont_id.$strCondDate.
            " group by a.ATYPE_ID, a.APPLI_ID, a.APPLI_INTITULE, st.MOIS_CONNEXION".
            " order by MOIS, NB desc";
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableByMonth($dsData, true, true, $iMois, $iAnnee,true);
        }
        if( $this->iExport == 0 ) {
          $oCtrlHtml1 = AlkHtmlFactory::getHtml($strHtmlTmp);
          $oBlock->addCtrl($oCtrlHtml1);
        }
      
        // Nb de visites sur l'espace
        $strTitle = _f("Nb de visites sur l'espace en %s", $strTitleDate);
        if( $this->iExport == 1 ) {
          $this->addExcelSheet("NbVisitesSurEspace", $strTitle);
        }
        $oBlock =& $this->addBlock("Block_".($iBlock++), $strTitle, "", 10, 590, false);
        if( $iMois > 0 ) {
          $strSql = "select c.CONT_INTITULE as INTITULE, sum(st.NB_CONNEXION) as NB".
            " from SIT_STATISTIQUE st".
            "   inner join SIT_CONTENEUR c on (st.ID_TYPE_CONNEXION=c.CONT_ID and st.TYPE_CONNEXION=1)".
            "  where c.CONT_ID=".$cont_id.$strCondDate.
            " group by c.CONT_INTITULE".
            " order by NB desc";
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableTxtNb($dsData, _t("Espace"), _t("Nb connexions"), $iMois, $iAnnee,false,true);
        } else {
          $strSql = "select c.CONT_INTITULE as INTITULE, sum(st.NB_CONNEXION) as NB, st.MOIS_CONNEXION as MOIS".
            " from SIT_STATISTIQUE st".
            "   inner join SIT_CONTENEUR c on (st.ID_TYPE_CONNEXION=c.CONT_ID and st.TYPE_CONNEXION=1)".
            "  where c.CONT_ID=".$cont_id.$strCondDate.
            " group by c.CONT_INTITULE, st.MOIS_CONNEXION".
            " order by MOIS, NB desc";
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableByMonth($dsData, true, true, $iMois, $iAnnee,true);
        }
        if( $this->iExport == 0 ) {
          $oCtrlHtml2 = AlkHtmlFactory::getHtml($strHtmlTmp);
          $oBlock->addCtrl($oCtrlHtml2);
        }
      
        // Nb de visites par service sur l'espace
        $strTitle = _f("Nb de visites par service sur l'espace en %s", $strTitleDate);
        if( $this->iExport == 1 ) {
          $this->addExcelSheet("NbVisitesParService", $strTitle);
        }
        $oBlock =& $this->addBlock("Block_".($iBlock++), $strTitle, "", 10, 590, false);
        if( $iMois > 0 ) {
          $strSql = "select ag.SERVICE_INTITULE_COURT as INTITULE, sum(sst.NB_CONNEXION) as NB, ag.SERVICE_ID as ID".
            " from ".
            "    (select AGENT_ID, NB_CONNEXION".
            "     from SIT_STATISTIQUE st".
            "     where st.TYPE_CONNEXION=1 and st.ID_TYPE_CONNEXION=".$cont_id.$strCondDate.") sst".
            "  left join".
            "    (select a.AGENT_ID, s.SERVICE_ID, s.SERVICE_INTITULE_COURT".
            "     from SIT_AGENT a".
            "       inner join SIT_AGENT_SERVICE ase on a.AGENT_ID=ase.AGENT_ID".
            "       inner join SIT_SERVICE s on ase.SERVICE_ID=s.SERVICE_ID".
            "     where s.SERVICE_NIVEAU=1 and a.AGENT_VALIDE>-1) ag".
            "   on ag.AGENT_ID=sst.AGENT_ID".
            " group by ag.SERVICE_INTITULE_COURT, ag.SERVICE_ID".
            " order by NB desc";
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableTxtNb($dsData, "Services", "Nb connexions", $iMois, $iAnnee, true,false);
        } else {
          $strSql = "select ag.SERVICE_INTITULE_COURT as INTITULE, sum(sst.NB_CONNEXION) as NB, ag.SERVICE_ID as ID, sst.MOIS_CONNEXION as MOIS".
            " from ".
            "    (select AGENT_ID, NB_CONNEXION, MOIS_CONNEXION".
            "     from SIT_STATISTIQUE st".
            "     where st.TYPE_CONNEXION=1 and st.ID_TYPE_CONNEXION=".$cont_id.$strCondDate.") sst".
            "  left join".
            "    (select a.AGENT_ID, s.SERVICE_ID, s.SERVICE_INTITULE_COURT".
            "     from SIT_AGENT a".
            "       inner join SIT_AGENT_SERVICE ase on a.AGENT_ID=ase.AGENT_ID".
            "       inner join SIT_SERVICE s on ase.SERVICE_ID=s.SERVICE_ID".
            "     where s.SERVICE_NIVEAU=1 and a.AGENT_VALIDE>-1) ag".
            "   on ag.AGENT_ID=sst.AGENT_ID".
            " group by ag.SERVICE_INTITULE_COURT, ag.SERVICE_ID, sst.MOIS_CONNEXION".
            " order by Mois, NB desc";
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableByMonth($dsData, true, true, $iMois, $iAnnee,false);    
        }
        if( $this->iExport == 0 ) {
          $oCtrlHtml3 = AlkHtmlFactory::getHtml($strHtmlTmp);
          $oBlock->addCtrl($oCtrlHtml3);
        }
        
        // Nb de visites par agent sur l'espace
        $strTitle = _f("Nb de visites par %s sur l'espace en %s ", ALK_S_AGENT, $strTitleDate);
        if( $this->iExport == 1 ) {
          $this->addExcelSheet("NbVisitesParUtilisateur", $strTitle);
        }
        $oBlock =& $this->addBlock("Block_".($iBlock++), $strTitle, "", 10, 590, false);
        $strConcatName = $dbConn->getConcat("ag.AGENT_NOM", "' '", "ag.AGENT_PRENOM");
        if( $iMois > 0 ) {
          $strSql = "select ".$strConcatName." as INTITULE, sum(sst.NB_CONNEXION) as NB, ag.AGENT_ID as ID".
            " from ".
            "    (select AGENT_ID, NB_CONNEXION".
            "     from SIT_STATISTIQUE st".
            "     where st.TYPE_CONNEXION=1 and st.ID_TYPE_CONNEXION=".$cont_id.$strCondDate.") sst".
            "  left join SIT_AGENT ag on ag.AGENT_ID=sst.AGENT_ID".
            " group by INTITULE, ag.AGENT_ID".
            " order by NB desc";
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableTxtNb($dsData, ALK_S_AGENT2."s", "Nb connexions", $iMois, $iAnnee, true,false);
        } else {
          $strSql = "select ".$strConcatName." as INTITULE, sum(sst.NB_CONNEXION) as NB, ag.AGENT_ID as ID, sst.MOIS_CONNEXION as MOIS".
            " from ".
            "    (select AGENT_ID, NB_CONNEXION, MOIS_CONNEXION".
            "     from SIT_STATISTIQUE st".
            "     where st.TYPE_CONNEXION=1 and st.ID_TYPE_CONNEXION=".$cont_id.$strCondDate.") sst".
            "  left join SIT_AGENT ag on ag.AGENT_ID=sst.AGENT_ID".
            " group by INTITULE, ag.AGENT_ID, sst.MOIS_CONNEXION".
            " order by Mois, NB desc";
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableByMonth($dsData, true, true, $iMois, $iAnnee,false);    
        }
        if( $this->iExport == 0 ) {
          $oCtrlHtml4 = AlkHtmlFactory::getHtml($strHtmlTmp);
          $oBlock->addCtrl($oCtrlHtml4);
        }
      
        // Nb de visites par service par application sur l'espace
        $strTitle = _f("Nb de visites par service par application sur l'espace en %s", $strTitleDate);
        if( $this->iExport == 1 ) {
          $this->addExcelSheet("NbVisitesParServParAppli", $strTitle);
        }
        $oBlock =& $this->addBlock("Block_".($iBlock++), $strTitle, "", 10, 590, false);
        $strSql = "select ag.SERVICE_INTITULE_COURT as INTITULE, sum(sst.NB_CONNEXION) as NB, ag.SERVICE_ID as ID,".
          "   sst.APPLI_ID as ENTETE_ID, sst.APPLI_INTITULE as ENTETE_TXT".
          " from ".
          "    (select st.AGENT_ID, st.NB_CONNEXION, a.APPLI_ID, a.APPLI_INTITULE".
          "     from SIT_STATISTIQUE st".
          "       inner join SIT_APPLI a on (st.ID_TYPE_CONNEXION=a.APPLI_ID and st.TYPE_CONNEXION=2)".
          "       inner join SIT_APPLI_CONT ac on a.APPLI_ID=ac.APPLI_ID".
          "     where ac.CONT_ID=".$cont_id.$strCondDate.") sst".
          "  left join".
          "    (select a.AGENT_ID, s.SERVICE_ID, s.SERVICE_INTITULE_COURT".
          "     from SIT_AGENT a".
          "       inner join SIT_AGENT_SERVICE ase on a.AGENT_ID=ase.AGENT_ID".
          "       inner join SIT_SERVICE s on ase.SERVICE_ID=s.SERVICE_ID".
          "     where s.SERVICE_NIVEAU=1 and a.AGENT_VALIDE>-1) ag".
          "   on ag.AGENT_ID=sst.AGENT_ID".
          " group by ag.SERVICE_INTITULE_COURT, ag.SERVICE_ID, sst.APPLI_ID, sst.APPLI_INTITULE".
          " order by NB desc";
        $dsData = $queryCont->getDs($strSql);
        $strHtmlTmp = $this->getHtmlTableByAppli($dsData, true, true);
        if( $this->iExport == 0 ) {
          $oCtrlHtml5 = AlkHtmlFactory::getHtml($strHtmlTmp);
          $oBlock->addCtrl($oCtrlHtml5);
        }
      
        $strTitle = _f("Nb de visites par %s par application sur l'espace en %s", ALK_S_AGENT, $strTitleDate);
        if( $this->iExport == 1 ) {
          $this->addExcelSheet("NbVisitesParUtilParAppli", $strTitle);
        }
        $oBlock =& $this->addBlock("Block_".($iBlock++), $strTitle, "", 10, 590, false);
        $strConcatName = $dbConn->getConcat("ag.AGENT_NOM", "' '", "ag.AGENT_PRENOM");
        $strSql = "select ".$strConcatName." as INTITULE, sum(sst.NB_CONNEXION) as NB, ag.AGENT_ID as ID,".
          "   sst.APPLI_ID as ENTETE_ID, sst.APPLI_INTITULE as ENTETE_TXT".
          " from ".
          "    (select st.AGENT_ID, st.NB_CONNEXION, a.APPLI_ID, a.APPLI_INTITULE".
          "     from SIT_STATISTIQUE st".
          "       inner join SIT_APPLI a on (st.ID_TYPE_CONNEXION=a.APPLI_ID and st.TYPE_CONNEXION=2)".
          "       inner join SIT_APPLI_CONT ac on a.APPLI_ID=ac.APPLI_ID".
          "     where ac.CONT_ID=".$cont_id.$strCondDate.") sst".
          "  left join SIT_AGENT ag on ag.AGENT_ID=sst.AGENT_ID".
          " group by INTITULE, ag.AGENT_ID, sst.APPLI_ID, sst.APPLI_INTITULE".
          " order by NB desc";
        $dsData = $queryCont->getDs($strSql);
        $strHtmlTmp = $this->getHtmlTableByAppli($dsData, true, true);
        if( $this->iExport == 0 ) {
          $oCtrlHtml6 = AlkHtmlFactory::getHtml($strHtmlTmp);
          $oBlock->addCtrl($oCtrlHtml6);
        }
      }
      else {
        $strCondDate = ( $iMois > 0 ? " and st.MOIS_CONNEXION=".$iMois : "" ).
          ( $iAnnee > 0 ? " and st.ANNEE_CONNEXION=".$iAnnee : "" );
      
        $strTitleDate = ( $iMois > 0 ? $tabMois[$iMois]." " : "" ).$iAnnee;
      
        // Nb de visites sur le sit
        $strTitle = _f("Nb de visites sur %s en %s", ALK_APP_NAME, $strTitleDate);
        if( $this->iExport == 1 ) {
          $this->addExcelSheet(_t("NbVisites"), $strTitle);
        }
        $oBlock =& $this->addBlock("Block_".($iBlock++), $strTitle, "", 10, 590, false);
        $strName = "'".$dbConn->analyseSql(ALK_APP_NAME)."'";
        if( $iMois > 0 ) {
          $strSql = "select ".$strName." as INTITULE, sum(st.NB_CONNEXION) as NB".
            " from SIT_STATISTIQUE st".
            " where st.ID_TYPE_CONNEXION=0 and st.TYPE_CONNEXION=0".$strCondDate.
            " group by INTITULE".
            " order by NB desc";
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableTxtNb($dsData, "Espace", "Nb connexions", $iMois, $iAnnee,false,true);
        } else {
          $strSql = "select ".$strName." as INTITULE, sum(st.NB_CONNEXION) as NB, st.MOIS_CONNEXION as MOIS".
            " from SIT_STATISTIQUE st".
            " where st.ID_TYPE_CONNEXION=0 and st.TYPE_CONNEXION=0".$strCondDate.
            " group by INTITULE, st.MOIS_CONNEXION".
            " order by MOIS, NB desc";
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableByMonth($dsData, true, true, $iMois, $iAnnee,true);
        }
        if( $this->iExport == 0 ) {
          $oCtrlHtml2 = AlkHtmlFactory::getHtml($strHtmlTmp);
          $oBlock->addCtrl($oCtrlHtml2);
        }
        
        // Nb de visites par service sur l'espace
        $strTitle = _f("Nb de visites par service sur %s en %s", ALK_APP_NAME, $strTitleDate);
        if( $this->iExport == 1 ) {
          $this->addExcelSheet("NbVisitesParService", $strTitle);
        }
        $oBlock =& $this->addBlock("Block_".($iBlock++), $strTitle, "", 10, 590, false);
        if( $iMois > 0 ) {
          $strSql = "select ag.SERVICE_INTITULE_COURT as INTITULE, sum(sst.NB_CONNEXION) as NB, ag.SERVICE_ID as ID".
            " from ".
            "    (select AGENT_ID, NB_CONNEXION".
            "     from SIT_STATISTIQUE st".
            "     where st.TYPE_CONNEXION=0 and st.ID_TYPE_CONNEXION=0".$strCondDate.") sst".
            "  left join".
            "    (select a.AGENT_ID, s.SERVICE_ID, s.SERVICE_INTITULE_COURT".
            "     from SIT_AGENT a".
            "       inner join SIT_AGENT_SERVICE ase on a.AGENT_ID=ase.AGENT_ID".
            "       inner join SIT_SERVICE s on ase.SERVICE_ID=s.SERVICE_ID".
            "     where s.SERVICE_NIVEAU=1 and a.AGENT_VALIDE>-1) ag".
            "   on ag.AGENT_ID=sst.AGENT_ID".
            " group by ag.SERVICE_INTITULE_COURT, ag.SERVICE_ID".
            " order by NB desc";
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableTxtNb($dsData, "Services", "Nb connexions", $iMois, $iAnnee, true,false);
        } else {
          $strSql = "select ag.SERVICE_INTITULE_COURT as INTITULE, sum(sst.NB_CONNEXION) as NB, ag.SERVICE_ID as ID, sst.MOIS_CONNEXION as MOIS".
            " from ".
            "    (select AGENT_ID, NB_CONNEXION, MOIS_CONNEXION".
            "     from SIT_STATISTIQUE st".
            "     where st.TYPE_CONNEXION=0 and st.ID_TYPE_CONNEXION=0".$strCondDate.") sst".
            "  left join".
            "    (select a.AGENT_ID, s.SERVICE_ID, s.SERVICE_INTITULE_COURT".
            "     from SIT_AGENT a".
            "       inner join SIT_AGENT_SERVICE ase on a.AGENT_ID=ase.AGENT_ID".
            "       inner join SIT_SERVICE s on ase.SERVICE_ID=s.SERVICE_ID".
            "     where s.SERVICE_NIVEAU=1 and a.AGENT_VALIDE>-1) ag".
            "   on ag.AGENT_ID=sst.AGENT_ID".
            " group by ag.SERVICE_INTITULE_COURT, ag.SERVICE_ID, sst.MOIS_CONNEXION".
            " order by Mois, NB desc";
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableByMonth($dsData, true, true, $iMois, $iAnnee,false);    
        }
        if( $this->iExport == 0 ) {
          $oCtrlHtml3 = AlkHtmlFactory::getHtml($strHtmlTmp);
          $oBlock->addCtrl($oCtrlHtml3);
        }
        
        // Nb de visites par agent sur l'espace
        $strTitle = _f("Nb de visites par %s sur %s en %s", ALK_S_AGENT, ALK_APP_NAME, $strTitleDate );
        if( $this->iExport == 1 ) {
          $this->addExcelSheet("NbVisitesParUtil", $strTitle);
        }
        $oBlock =& $this->addBlock("Block_".($iBlock++), $strTitle, "", 10, 590, false);
        $strConcatName = $dbConn->getConcat("ag.AGENT_NOM", "' '", "ag.AGENT_PRENOM");
        if( $iMois > 0 ) {
          $strSql = "select ".$strConcatName." as INTITULE, sum(sst.NB_CONNEXION) as NB, ag.AGENT_ID as ID".
            " from ".
            "    (select AGENT_ID, NB_CONNEXION".
            "     from SIT_STATISTIQUE st".
            "     where st.TYPE_CONNEXION=0 and st.ID_TYPE_CONNEXION=0".$strCondDate.") sst".
            "  left join SIT_AGENT ag on ag.AGENT_ID=sst.AGENT_ID".
            " group by INTITULE, ag.AGENT_ID".
            " order by NB desc";
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableTxtNb($dsData, ALK_S_AGENT2."s", "Nb connexions", $iMois, $iAnnee, true,false);
        } else {
          $strSql = "select ".$strConcatName." as INTITULE, sum(sst.NB_CONNEXION) as NB, ag.AGENT_ID as ID, sst.MOIS_CONNEXION as MOIS".
            " from ".
            "    (select AGENT_ID, NB_CONNEXION, MOIS_CONNEXION".
            "     from SIT_STATISTIQUE st".
            "     where st.TYPE_CONNEXION=0 and st.ID_TYPE_CONNEXION=0".$strCondDate.") sst".
            "  left join SIT_AGENT ag on ag.AGENT_ID=sst.AGENT_ID".
            " group by INTITULE, ag.AGENT_ID, sst.MOIS_CONNEXION".
            " order by Mois, NB desc";
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableByMonth($dsData, true, true, $iMois, $iAnnee,false);    
        }
        if( $this->iExport == 0 ) {
          $oCtrlHtml4 = AlkHtmlFactory::getHtml($strHtmlTmp);
          $oBlock->addCtrl($oCtrlHtml4);
        }
      }
    }elseif( $this->iMode == 2 ){ // statistiques pour modules spécifiques avec iMode=2 et la constante ALK_B_SPACE_STAT_APPLI à true 
    	
      if( $iCont != -1 ) {
        
        $strCondDate = ( $iMois > 0 ? " and st.stat_mois=".$iMois : "" ).
          ( $iAnnee > 0 ? " and st.stat_annee=".$iAnnee : "" );
        
        $strTitleDate = ( $iMois > 0 ? $tabMois[$iMois]." " : "" ).$iAnnee;
        
        // Nb d'actions par donnée de l'application
        $strTitle = _f("Nb d'actions par donnée de l'application en %s", $strTitleDate);
        
        $strCondUser = "";
        if ( $iUser != -1 ) {
          $strCondUser = " and st.AGENT_ID=".$iUser;
          $oDsUser->moveFirst();
          while ( $oDrUser = $oDsUser->getRowIter() ) {
            $user_id = $oDrUser->getValueName("ID");
            if ( $user_id == $iUser ) {
              $strTitle.= " "._f("pour l'utilisateur %s", $oDrUser->getValueName("TXT"));
              continue;
            }
          }
        } else if ( $iService != -1 ) {
          $strCondUser = " and st.AGENT_ID in (select AGENT_ID from SIT_AGENT_SERVICE where SERVICE_ID=".$iService.")";
          $oDsService->moveFirst();
          while ( $oDrService = $oDsService->getRowIter() ) {
            $service_id = $oDrService->getValueName("ID");
            if ( $service_id == $iService ) {
              $strTitle.= " "._f("pour le service %s", $oDrService->getValueName("TXT"));
              continue;
            }
          }
        }
        
        if( $this->iExport == 1 ) {
          $this->addExcelSheet("NbActionsParDonnee", $strTitle);
        }
        
        $oBlock =& $this->addBlock("Block_".($iBlock++), $strTitle, "", 10, 590, false);
        
        $strSql = "select TABLE_REF, FIELD_PK, FIELDS_TEXT from SIT_DATATYPE where DATATYPE_ID=".$iDataType;
        $dsDataType = $queryCont->getDs($strSql);
        if ( $drDataType = $dsDataType->getRowIter() ) {
          $fields_text = $drDataType->getValueName("FIELDS_TEXT");
          $tabFields = explode("|", $fields_text);
          $fields_pk = $drDataType->getValueName("FIELD_PK");
          $table_ref = $drDataType->getValueName("TABLE_REF");
			if($iMois > 0){ 
				$strSql = "select st.DATA_ID, " .   // identifiant de la donnée dans la table SIT_STAT_APPLI
				"   (select ".$fields_pk." from ".$table_ref." where ".$fields_pk."=st.DATA_ID) as ID,".            // identifiant de la donnée dans sa table, permet de savoir si la donnée existe toujours
				"   (select ".$tabFields[0]." from ".$table_ref." where ".$fields_pk."=st.DATA_ID) as INTITULE," .  // suppose que l'intitulé de la donnée se trouve en première position dans le champs FIELDS_TEXT
				"   sum(st.stat_nombre) as NB," .
				"   sa.ACTION_INTITULE as ENTETE_TXT".
				" from SIT_STAT_APPLI st".
				"  inner join SIT_STAT_ACTION sa on sa.ACTION_ID=st.ACTION_ID".
				"  where 1=1".$strCondDate.$strCondUser.
				"  and DATATYPE_ID=".$iDataType.
				"  and ATYPE_ID=".$this->atype_id.
				"  and APPLI_ID=".$this->idAppli.
				($iData > 0 ? " and st.DATA_ID=".$iData : "").
				" group by INTITULE, st.DATA_ID, sa.ACTION_ID, sa.ACTION_INTITULE".
				" order by sa.ACTION_ID asc, NB desc";
				$dsData = $queryCont->getDs($strSql);
				$strHtmlTmp = $this->getHtmlTableDataByAppli($dsData, true,true);		  
			}else{
				$strSql = "select st.DATA_ID, st.stat_mois as MOIS," .   // identifiant de la donnée dans la table SIT_STAT_APPLI
				"   (select ".$fields_pk." from ".$table_ref." where ".$fields_pk."=st.DATA_ID) as ID,".            // identifiant de la donnée dans sa table, permet de savoir si la donnée existe toujours
				"   (select ".$tabFields[0]." from ".$table_ref." where ".$fields_pk."=st.DATA_ID) as INTITULE," .  // suppose que l'intitulé de la donnée se trouve en première position dans le champs FIELDS_TEXT
				"   sum(st.stat_nombre) as NB," .
				"   sa.ACTION_INTITULE as ENTETE_TXT".
				" from SIT_STAT_APPLI st".
				"  inner join SIT_STAT_ACTION sa on sa.ACTION_ID=st.ACTION_ID".
				"  where 1=1".$strCondDate.$strCondUser.
				"  and DATATYPE_ID=".$iDataType.
				"  and ATYPE_ID=".$this->atype_id.
				"  and APPLI_ID=".$this->idAppli.
				($iData > 0 ? " and st.DATA_ID=".$iData : "").
				" group by INTITULE, st.DATA_ID,st.stat_mois, sa.ACTION_ID, sa.ACTION_INTITULE".
				" order by st.stat_mois, sa.ACTION_ID asc, NB desc";
				$dsData = $queryCont->getDs($strSql);
				$strHtmlTmp = $this->getHtmlTableByMonth($dsData, true, true, $iMois, $iAnnee,true);
			}
          
          if( $this->iExport == 0 ) {
            $oCtrlHtml1 = AlkHtmlFactory::getHtml($strHtmlTmp);
            $oBlock->addCtrl($oCtrlHtml1);
          }
        }
        
        /*
        // Nb de type d'actions par action et organisme
        $strTitle = "Nb de types d'actions par organisme, sur l'application en ".$strTitleDate;
        if( $this->iExport == 1 ) {
          $this->addExcelSheet("NbActionParOrganismeSurEspace", $strTitle);
        }
        $oBlock =& $this->addBlock("Block_".($iBlock++), $strTitle, "", 10, 590, false);
        if( $iMois > 0 ) {

          
           $strSql = "select ss.SERVICE_INTITULE as INTITULE, sum(sst.STAT_NOMBRE) as NB, ss.SERVICE_ID as ID,".
          "   sst.ACTION_ID as ENTETE_ID, sst.ACTION_INTITULE as ENTETE_TXT".
          " from ".
          "    (select ss.SERVICE_ID, st.STAT_NOMBRE, sa.ACTION_ID, sa.ACTION_INTITULE".
          "     from SIT_STAT_APPLI st".
          //"     inner join SIT_ACTION sa on sa.ACTION_ID=st.ACTION_ID".
          "     inner join SIT_STAT_ACTION sa on sa.ACTION_ID=st.ACTION_ID".
          "     inner join SIT_AGENT_SERVICE sas on sas.AGENT_ID=st.AGENT_ID".
          "     inner join SIT_SERVICE ss on sas.SERVICE_ID=ss.SERVICE_ID".
          //"     where st.ACTION_ID >7 and st.ACTION_ID<23 ".$strCondDate.") sst".
          "     where 1=1".$strCondDate.") sst".
          " left join SIT_SERVICE ss on ss.SERVICE_ID=sst.SERVICE_ID".
          " group by INTITULE, ss.SERVICE_ID, sst.ACTION_ID, sst.ACTION_INTITULE".
          " order by sst.ACTION_ID asc, NB desc";

          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableByAppli($dsData, true, true);
         
          
        } else {// Nb de type d'actions par action et organisme sur l'année'
          

          $strSql = "select ss.SERVICE_INTITULE as INTITULE, sum(sst.STAT_NOMBRE) as NB, ss.SERVICE_ID as ID, sst.STAT_ANNEE as MOIS,".
          "   sst.ACTION_ID as ENTETE_ID, sst.ACTION_INTITULE as ENTETE_TXT".
          " from ".
          "    (select ss.SERVICE_ID, st.STAT_NOMBRE, st.STAT_ANNEE, sa.ACTION_ID, sa.ACTION_INTITULE".
          "     from SIT_STAT_APPLI st".
          //"     inner join SIT_ACTION sa on sa.ACTION_ID=st.ACTION_ID".
          "     inner join SIT_STAT_ACTION sa on sa.ACTION_ID=st.ACTION_ID".
          "     inner join SIT_AGENT_SERVICE sas on sas.AGENT_ID=st.AGENT_ID".
          "     inner join SIT_SERVICE ss on sas.SERVICE_ID=ss.SERVICE_ID".
          //"     where st.ACTION_ID >7 and st.ACTION_ID<23 ".$strCondDate." and st.STAT_ANNEE=".$iAnnee.") sst".
          "     where 1=1".$strCondDate." and st.STAT_ANNEE=".$iAnnee.") sst".
          " left join SIT_SERVICE ss on ss.SERVICE_ID=sst.SERVICE_ID".
          " group by INTITULE, ss.SERVICE_ID, sst.ACTION_ID, sst.ACTION_INTITULE, MOIS".
          " order by sst.ACTION_ID asc, NB desc";
        
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableByAppli($dsData, true, true);          
        }
        if( $this->iExport == 0 ) {
          $oCtrlHtml2 = AlkHtmlFactory::getHtml($strHtmlTmp);
          $oBlock->addCtrl($oCtrlHtml2);
        }

      
        // Nb d'action par utilisateur et type d'action sur l'espace
        //        
        $strTitle = "Nb de types d'actions par utilisateur, sur l'application en ".$strTitleDate;
        if( $this->iExport == 1 ) {
          $this->addExcelSheet("NbActionParUtilisateurSurEspace", $strTitle);
        }
        $oBlock =& $this->addBlock("Block_".($iBlock++), $strTitle, "", 10, 590, false);
        $strConcatName = $dbConn->getConcat("ag.AGENT_NOM", "' '", "ag.AGENT_PRENOM");
        if( $iMois > 0 ) {

  
          $strSql = "select ".$strConcatName." as INTITULE, sum(sst.STAT_NOMBRE) as NB, ag.AGENT_ID as ID,".
          "   sst.ACTION_ID as ENTETE_ID, sst.ACTION_INTITULE as ENTETE_TXT".
          " from ".
          "    (select st.AGENT_ID, st.STAT_NOMBRE, sa.ACTION_ID, sa.ACTION_INTITULE".
          "     from SIT_STAT_APPLI st".
          //"     inner join SIT_ACTION sa on sa.ACTION_ID=st.ACTION_ID".
          //"     where st.ACTION_ID >7 and st.ACTION_ID<23 ".$strCondDate.") sst".
          "     inner join SIT_STAT_ACTION sa on sa.ACTION_ID=st.ACTION_ID".
          "     where 1=1".$strCondDate.") sst".
          " left join SIT_AGENT ag on ag.AGENT_ID=sst.AGENT_ID".
          " group by INTITULE, ag.AGENT_ID, sst.ACTION_ID, sst.ACTION_INTITULE".
          " order by sst.ACTION_ID, NB desc";
                     
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableByAppli($dsData, true, true);

        } else {
         
        
          $strSql = "select ".$strConcatName." as INTITULE, sum(sst.STAT_NOMBRE) as NB, ag.AGENT_ID as ID, sst.STAT_ANNEE as MOIS, ".
          "   sst.ACTION_ID as ENTETE_ID, sst.ACTION_INTITULE as ENTETE_TXT".
          " from ".
          "    (select st.AGENT_ID, st.STAT_NOMBRE, st.STAT_ANNEE, sa.ACTION_ID, sa.ACTION_INTITULE".
          "     from SIT_STAT_APPLI st".
          //"     inner join SIT_ACTION sa on sa.ACTION_ID=st.ACTION_ID".
          //"     where st.ACTION_ID >7 and st.ACTION_ID<23 and st.STAT_ANNEE=".$iAnnee.") sst".
          "     inner join SIT_STAT_ACTION sa on sa.ACTION_ID=st.ACTION_ID".
          "     where st.STAT_ANNEE=".$iAnnee.") sst".
          " left join SIT_AGENT ag on ag.AGENT_ID=sst.AGENT_ID".
          " group by INTITULE, ag.AGENT_ID, sst.ACTION_ID, sst.ACTION_INTITULE, MOIS".
          " order by sst.ACTION_ID asc, NB desc";
           
          
          $dsData = $queryCont->getDs($strSql);
          $strHtmlTmp = $this->getHtmlTableByAppli($dsData, true, true);        

        }
        if( $this->iExport == 0 ) {
          $oCtrlHtml3 = AlkHtmlFactory::getHtml($strHtmlTmp);
          $oBlock->addCtrl($oCtrlHtml3);
        }
        */
      }
    }
    if( $this->iExport == 0 ) {
      $this->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlformstatlist.js");
      //$_SESSION["ALK_HTMLEXPORT_STAT"] = $this->getHtml();
      
      $strParam = "cont_id=".$cont_id."&appli_id=-1&export=1&iTypeSheet=".ALK_TYPESHEET_ADMIN."&iSheet=".ALK_SHEET_STATS."&iMode=".$this->iMode."&atype_id=".$this->atype_id."&idAppli=".$this->idAppli;
      $strToken = AlkRequest::getEncodeParam($strParam);
      $oButton = $this->addButtonPage("bt_Export", "javascript:OpenExport('".$strToken."');", _t("Exporter"), _t("Exporter cette page au format Excel"));
      $this->addSubmitButton($oButton);
      if( $this->iMode == 2 ){
        $strTokenRetour = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=1&iMois=".$iMois."&iAnnee=".$iAnnee);
        $this->addButtonPage("bt_Retour", ALK_ALKANET."?token=".$strTokenRetour, _t("Retour"), _t("Retour aux statistiques générales"));
      }
    } else {
      $this->closeExcel(); 
    }
  }

  /**
   * Retourne le code html d'un tableau contenant les statistiques
   *        d'une information composée d'un intitulé et d'un nombre
   *
   * @param dsData  DataSet contenant les informations
   * @param strTitleTxt  Titre de la colonne texte
   * @param strTitleNb   Titre de la colonne nb
   * @param iMois        numéro du mois filtré
   * @param iAnnee       année filtrée
   * @param bAffTotal    vrai pour afficher le total en dernière ligne
   * @return Retourne un string
   */
  private function getHtmlTableTxtNb(&$dsData, $strTitleTxt, $strTitleNb, $iMois, $iAnnee, $bAffTotal=false, $bGraphique=false)
  {
    $cont_id = AlkRequest::_POSTint("iCont", $this->oAppli->cont_id);

    if( $this->iExport == 0 ) {
      $iNbElt = $dsData->getCountTotDr();
      $oTabPage = AlkHtmlFactory::getHtmlList($this, $iNbElt, 1, 20, false, "", "Aucune connexion", false, "tabPagine".self::$iNumSubPanel, false);
      self::$iNumSubPanel++;
      $oTabPage->SetColumns(array("left",   "300"),
                            array("right", "100"));
  
      $oTabPage->AddTitleRow($strTitleTxt, $strTitleNb);
    } else {
      $iRow = 2;
      $this->currentWorksheet->write_string($iRow, 0, mb_convert_encoding($strTitleTxt, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING));
      $this->currentWorksheet->write_string($iRow, 1,mb_convert_encoding($strTitleNb, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING));
      $iRow = 4; 
    }
    
    $nbTot = 0;
    $dataTab = array();
    $nameTab = array();
    while( $drData = $dsData->getRowIter() ) {
      $strName = $drData->getValueName("INTITULE");
      $iNb     = $drData->getValueName("NB");
      
      $iNb = ( $iNb == "" ? 0 : $iNb*1 );
      $strName = ( $strName == "" ? "Supprimé" : $strName );

      $dataTab[] = $iNb;
      $nameTab[] = $strName;
      
      $atype_id = $drData->getValueName("ATYPE_ID");
      $appli_id = $drData->getValueName("APPLI_ID");
    
      if( $this->iExport == 0 && $atype_id !="" && $appli_id!="" && $strName!="Supprimé" ) {
        if( defined("ALK_B_SPACE_STAT_APPLI") && ALK_B_SPACE_STAT_APPLI ) {
          $strToken = AlkRequest::getEncodeParam("&cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_ADMIN."&iSheet=".ALK_SHEET_STATS.
                                                 "&atype_id=".$atype_id."&idAppli=".$appli_id."&iMois=".$iMois."&iAnnee=".$iAnnee."&iMode=2");
          $strName = '<a title="'._f("Statistiques de l'application %s", $strName).'" href="'.ALK_ALKANET.'?token='.$strToken.'">'.$strName.'</a>';
        }
      }
      $nbTot += $iNb;
      
      if( $this->iExport == 0 ) {
        $oTabPage->addRow($strName, array(number_format($iNb, 0, ',', ' '), 1, 1, "style='white-space:nowrap;'"));

      } else {
        $this->currentWorksheet->write_string($iRow, 0, mb_convert_encoding($strName, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING));
        $this->currentWorksheet->write_number($iRow, 1, $iNb);
        $iRow++;
      }
    }

    if( $bAffTotal && $nbTot > 0 ) {
      if( $this->iExport == 0 ) {
        $oTabPage->setNbTotItems($iNbElt+1);
        $oTabPage->addRow("<b>"._t("Total")."</b>", array("<b>".number_format($nbTot, 0, ',', ' ')."</b>", 1, 1, "style='white-space:nowrap;'"));
      } else {
        $this->currentWorksheet->write_string($iRow, 0, "Total");
        $this->currentWorksheet->write_number($iRow, 1, $nbTot);        
      }
    }

    $strHtml = ( $this->iExport == 0 ? $oTabPage->getHtml() : "" );
    $strHtml .= ( $this->iExport == 0 && $bGraphique ? $this->getHtmlGraphePie($nameTab,$dataTab) : "" );
    return $strHtml;
  
  }


  /**
   * Retourne le tableau html à partir des données récoltés 
   *
   * @param tabData  Tableau de données à afficher (les titres sont en indices 0)
   * @param nbLig    Nombre de ligne du tableau
   * @param nbCol    Nombre de colonne du tableau
   * @return Retourne un string
   */
  private function getHtmlTable2D(&$tabData, $nbLig, $nbCol, $iLarg, $nbColParLig=-1)
  {
    $jDeb = 1;
    $jFin = $nbCol;
    if( $nbColParLig != -1 ) {
      $jFin = min($nbColParLig, $nbCol);
      if( $jFin == $nbCol-1 ) {
        // evite une répétition avec une colonne
        $jFin = $nbCol;
      }
    }
    $strHtml = "";
    while( $jDeb <= $nbCol ) {
      if( $this->iExport == 0 ) {
        $oTabPage = AlkHtmlFactory::getHtmlList($this, $nbLig, 1, 20, false, "", _t("Aucune connexion."), false, "tabPagine".self::$iNumSubPanel);
        self::$iNumSubPanel++;

        $tabCol = array(array("left",   "120"));
        for($j=$jDeb; $j<=$jFin; $j++) {
          array_push($tabCol, array("right", $iLarg));
        }
        $oTabPage->SetColumnsByArray($tabCol);
      }
      
      $tabTitle = array();
      $tabTitle[] = $tabData[0][0];
      for($j=$jDeb; $j<=$jFin; $j++) {
        $tabTitle[] = $tabData[0][$j];
      }
      if( $this->iExport == 0 ) {
        $oTabPage->AddTitleRowByArray($tabTitle);
      } else {
        $iRow = 2;
        $this->addRowExcelSheet($tabTitle, $iRow);
        $iRow = 4;
      }
    
      for($i=1; $i<=$nbLig; $i++) {
        $strBoldStart = "";
        $strBoldEnd = "";
        if( $this->iExport == 0 && $tabData[$i][0] == "Totaux" ) {
          $strBoldStart = "<b>";
          $strBoldEnd = "</b>";
        }
        $tabRow = array($strBoldStart.$tabData[$i][0].$strBoldEnd);
      
        for($j=$jDeb; $j<=$jFin; $j++) {
          if( isset($tabData[$i][$j]) ) {
            if( $this->iExport == 0 ) {
              $tabRow[] = array($strBoldStart.number_format($tabData[$i][$j], 0, ',', ' ').$strBoldEnd, 1, 1, "style='white-space:nowrap;'");
            } else {
              $tabRow[] = $tabData[$i][$j];
            }
          } else {
            $tabRow[] = ( $this->iExport == 0 ? "&nbsp;" : "" );
          }
        }
        if( $this->iExport == 0 ) {
          $oTabPage->AddRowByArray($tabRow);
        } else {
          $this->addRowExcelSheet($tabRow, $iRow);
          $iRow++;
        }
      }

      if( $this->iExport == 0 ) {
        $strHtml .= $oTabPage->getHtml();
      }

      if( $nbColParLig==-1 ) 
        break;

      $jDeb = $jFin+1;
      $jFin = min($jFin+$nbColParLig, $nbCol);
      if( $jFin == $nbCol-1 ) {
        // evite une répétition avec une colonne
        $jFin = $nbCol;
      }
    }

    return $strHtml;
  }
  
  /**
   * Retourne un tableau HTML donnant le nombre d'actions par donnée pour une application
   * entête du tableau HTML retourné : ID, Donnée, actions
   * @param dsData        DataSet contenant les informations
   *                        DATA_ID : identifiant de la donnée dans la table SIT_STAT_APPLI
   *                        ID : identifiant de la donnée dans sa table, permet de savoir si la donnée existe toujours ou non
   *                        INTITULE : intitulé de la donnée
   *                        NB : nombre d'actions
   *                        ENTETE_TXT : nom de l'action
   * @param bShowId       booléen à true pour afficher la colonne identifiant de la donnée, false sinon
   * @param bGraphique    vrai pour afficher le graphique en dessus du tableau
   * @return Retourne un string
   */
  private function getHtmlTableDataByAppli(&$dsData, $bShowId=true, $bGraphique=false)
  {
    $tabData = array();
    $tabIndex = array("col" => array(), "lig" => array());
    $tabTotal = array("col" => array(), "lig" => array());
    $iCol = 1;
    $iLig = 0;
    $tabName = array();
    $tabDataForGraphe = array();
    while( $drData = $dsData->getRowIter() ) {
      $strEntete  = $drData->getValueName("ENTETE_TXT");
      $data_id    = $drData->getValueName("DATA_ID");
      $id         = $drData->getValueName("ID");
      $strName    = $drData->getValueName("INTITULE");
      $iNb        = $drData->getValueName("NB");
      $iNb = ( $iNb == "" ? 0 : $iNb*1 );
      
      if( $this->iExport == 0 ) {
        $strEntete = wordwrap($strEntete, 12, "<br/>");
      }
      
      if( !array_key_exists($data_id, $tabIndex["lig"]) ) {
        $i = ++$iLig;
        $tabIndex["lig"][$data_id] = $i;
        $tabData[$i][0] = $data_id;
        if ( $id ) {
          $tabData[$i][1] = $strName;
        } else {
          $tabData[$i][1] = "Supprimée";
        }
        $tabName[$i-1] = $tabData[$i][1];
        $tabTotal["lig"][$i] = 0;
      } else {
        $i = $tabIndex["lig"][$data_id];
      }
      if( !array_key_exists($strEntete, $tabIndex["col"]) ) {
        $j = ++$iCol;
        $tabIndex["col"][$strEntete] = $j;
        $tabData[0][$j] = $strEntete;   
        $tabTotal["col"][$j] = 0;
      } else {
        $j = $tabIndex["col"][$strEntete];
      }
      if( !array_key_exists($j, $tabData[$i]) ) {
        $tabData[$i][$j] = $iNb;
      } else {
        $tabData[$i][$j] += $iNb;
      }
    
      $tabTotal["lig"][$i] += $iNb; 
      $tabTotal["col"][$j] += $iNb;
    }
    
    if ( $bShowId ) {
      $tabData[0][0] = "ID";
    }
    $tabData[0][1] = "Donnée";
    
    $nbLig = $iLig;
    $nbCol = $iCol;
    $nbColParLig = ( $this->iExport==0 ? 6 : 250);
    
    // construit le code HTML du tableau
    $jDeb = 2;
    $jFin = $nbCol;
    if( $nbColParLig != -1 ) {
      $jFin = min($nbColParLig, $nbCol);
      if( $jFin == $nbCol-1 ) {
        // evite une répétition avec une colonne
        $jFin = $nbCol;
      }
    }
    $strHtml = "";
    while( $jDeb <= $nbCol ) {
      if( $this->iExport == 0 ) {
        $oTabPage = AlkHtmlFactory::getHtmlList($this, $nbLig, 1, 20, false, "", _t("Aucune donnée."), false, "tabPagine".self::$iNumSubPanel);
        self::$iNumSubPanel++;

        $tabCol = array();
        if ( $bShowId ) {
          $tabCol[] = array("center", "60");
        }
        $tabCol[] = array("left", "120");
                        
        for($j=$jDeb; $j<=$jFin; $j++) {
          array_push($tabCol, array("right", "90"));
        }
        $oTabPage->SetColumnsByArray($tabCol);
      }
      
      $tabTitle = array();
      if ( $bShowId ) {
        $tabTitle[] = $tabData[0][0];
      }
      $tabTitle[] = $tabData[0][1];
      for($j=$jDeb; $j<=$jFin; $j++) {
        $tabTitle[] = $tabData[0][$j];
      }
      if( $this->iExport == 0 ) {
        $oTabPage->AddTitleRowByArray($tabTitle);
      } else {
        $iRow = 2;
        $this->addRowExcelSheet($tabTitle, $iRow);
        $iRow = 4;
      }
    
      for($i=1; $i<=$nbLig; $i++) {
        $strBoldStart = "";
        $strBoldEnd = "";
        if( $this->iExport == 0 && $tabData[$i][0] == "Totaux" ) {
          $strBoldStart = "<b>";
          $strBoldEnd = "</b>";
        }
        $tabRow = array();
        if ( $bShowId ) {
          $tabRow[] = $tabData[$i][0];
        }
        $tabRow[] = $strBoldStart.$tabData[$i][1].$strBoldEnd;
      
        for($j=$jDeb; $j<=$jFin; $j++) {
          if( isset($tabData[$i][$j]) ) {
            if( $this->iExport == 0 ) {
              $tabRow[] = array($strBoldStart.number_format($tabData[$i][$j], 0, ',', ' ').$strBoldEnd, 1, 1, "style='white-space:nowrap;'");
            } else {
              $tabRow[] = $tabData[$i][$j];
            }
          } else {
            $tabRow[] = ( $this->iExport == 0 ? "&nbsp;" : "" );
          }
        }
        if( $this->iExport == 0 ) {
          $oTabPage->AddRowByArray($tabRow);
        } else {
          $this->addRowExcelSheet($tabRow, $iRow);
          $iRow++;
        }
      }

      if( $this->iExport == 0 ) {
        $strHtml .= $oTabPage->getHtml();      
      }

      if( $nbColParLig==-1 ) 
        break;

      $jDeb = $jFin+1;
      $jFin = min($jFin+$nbColParLig, $nbCol);
      if( $jFin == $nbCol-1 ) {
        // evite une répétition avec une colonne
        $jFin = $nbCol;
      }
    }
    if( $this->iExport == 0 && $bGraphique) {
      for($i = 1; $i < count($tabData); $i++){
        $tabDataForGraphe[$i-1] = $tabData[$i][2];
      }
      $strHtml .= $this->getHtmlGraphePie($tabName, $tabDataForGraphe);
    }
    return $strHtml;
  }
  
  /**
   * Retourne un tableau donnant le bilan par application en colonne
   *
   * @param dsData        DataSet contenant les informations
   * @param bAffTotalCol  vrai pour afficher le total en dernière colonne
   * @param bAffTotalLig  vrai pour afficher le total en dernière ligne
   * @param tabMois       tableau contenant les intitulés des mois
   * @param iMois         numéro du mois filtré
   * @param iAnnee        année filtrée
   * @param bGraphique    vrai pour afficher le graphique en dessous du tableau
   * @return Retourne un string
   */
  private function getHtmlTableByAppli(&$dsData, $bAffTotalCol=false, $bAffTotalLig=false, $tabMois=array(), $iMois=-1, $iAnnee=-1, $bGraphique=false)
  {
    $cont_id = AlkRequest::_POSTint("iCont", $this->oAppli->cont_id);
    
    $bMonth = ( count($tabMois)>0 ? true : false );
    $tabData = array();
    $tabIndex = array("col" => array(), "lig" => array());
    $tabTotal = array("col" => array(), "lig" => array());
    $iCol = 0;
    $iLig = 0;
    $lineNameTab = array();
    $tabAbcisse = array();
    while( $drData = $dsData->getRowIter() ) {
      if( $bMonth ) {
        $idMois    = $drData->getValueName("MOIS");
        $strEntete = $tabMois[$idMois];
        $strAbscisseNameForGraphe = $strEntete;
      } else {
        $idAppli   = $drData->getValueName("ENTETE_ID");
        $strEntete = $drData->getValueName("ENTETE_TXT");
      }
      $strName  = $drData->getValueName("INTITULE");
      $iNb      = $drData->getValueName("NB");
      $iNb = ( $iNb == "" ? 0 : $iNb*1 );
      $strName = ( $strName == "" ? "Supprimé" : $strName );

      if( $this->iExport == 0 ) {
        $strEntete = wordwrap($strEntete, 12, "<br/>");
      }      
      $atype_id = $drData->getValueName("ATYPE_ID");
      $appli_id = $drData->getValueName("APPLI_ID");
      $strNameForGraphe = $strName;
      if( $this->iExport == 0 && $atype_id!="" && $appli_id!="" && $strName!="Supprimé" ) {
        if( defined("ALK_B_SPACE_STAT_APPLI") && ALK_B_SPACE_STAT_APPLI ) {
          $strToken = AlkRequest::getEncodeParam("&cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_ADMIN."&iSheet=".ALK_SHEET_STATS.
                                                 "&atype_id=".$atype_id."&idAppli=".$appli_id."&iMois=".$iMois."&iAnnee=".$iAnnee."&iMode=2");          
          $strName = '<a title="'._f("Statistiques de l'application %s", $strName).' " href="'.ALK_ALKANET.'?token='.$strToken.'">'.$strName.'</a>';          
        }
      }      
      if( !array_key_exists($strName, $tabIndex["lig"]) ) {
        $i = ++$iLig;
        $tabIndex["lig"][$strName] = $i;
        $tabData[$i][0] = $strName;  
        $tabTotal["lig"][$i] = 0;
        $lineNameTab[$i] = $strNameForGraphe;
      } else {
        $i = $tabIndex["lig"][$strName];
      }
      if( !array_key_exists($strEntete, $tabIndex["col"]) ) {
        $j = ++$iCol;
        $tabIndex["col"][$strEntete] = $j;
        $tabData[0][$j] = $strEntete;   
        $tabTotal["col"][$j] = 0;
        if($bMonth){
          $tabAbcisse[$j-1] = $strAbscisseNameForGraphe;
        }        
      } else {
        $j = $tabIndex["col"][$strEntete];
      }
      if( !array_key_exists($j, $tabData[$i]) ) {
        $tabData[$i][$j] = $iNb;
      } else {
        $tabData[$i][$j] += $iNb;
      }    
      $tabTotal["lig"][$i] += $iNb; 
      $tabTotal["col"][$j] += $iNb;
    }

    // ajoute la colonne total au tabData
    $iTotCol = 0;
    if( $bAffTotalCol ) {
      $j = ++$iCol;
      $tabData[0][$j] = "Totaux";
      for($k=1; $k<=$iLig; $k++) {
        $tabData[$k][$j] = (isset($tabTotal["lig"][$k]) ? $tabTotal["lig"][$k] : 0 );
        $iTotCol += $tabData[$k][$j];
      }
    }

    // ajoute la ligne total au tabData
    if( $bAffTotalLig ) {
      $i = ++$iLig;
      $tabData[$i][0] = "Totaux";
      $iColMax = ( $bAffTotalCol ? $iCol-1 : $iCol );
      for($k=1; $k<=$iColMax; $k++) {
        $tabData[$i][$k] = ( isset($tabTotal["col"][$k]) ? $tabTotal["col"][$k] : 0 );
      }
      if( $bAffTotalCol ) {
        $tabData[$i][$iCol] = $iTotCol;
      }
    }

    if( $iLig>1 && !$bAffTotalLig || $iLig>2 && $bAffTotalLig ) {
      $tabData[0][0] = "Nbre : ".($bAffTotalLig ? $iLig-1 : $iLig);
    } else {
      $tabData[0][0] = ( $this->iExport==0 ? "&nbsp;" : "" );
    }
    
    $iLarg = ( $bMonth ? "40" : "70" );
    $strHtml = $this->getHtmlTable2D($tabData, $iLig, $iCol, $iLarg, ( $this->iExport==0 ? 6 : 250));
    if(count($tabMois)>0 && $bGraphique){
      $strHtml .= $this->getHtmlGrapheMultipleLine($tabAbcisse, $tabData, $lineNameTab);          
    }
    return $strHtml;
  }

 

  /**
   * Retourne un tableau donnant le bilan par mois en colonne
   *
   * @param dsData        DataSet contenant les informations
   * @param bAffTotalCol  vrai pour afficher le total en dernière colonne
   * @param bAffTotalLig  vrai pour afficher le total en dernière ligne
   * @param iMois         numéro du mois filtré
   * @param iAnnee        année filtrée
   * @param bGraphique    vrai pour afficher le graphique en dessous du tableau
   * @return Retourne un string
   */
  private function getHtmlTableByMonth(&$dsData, $bAffTotalCol=false, $bAffTotalLig=false, $iMois=-1, $iAnnee=-1, $bGraphique = false)
  {
    $tabMois = array(0 => "", 1 => _t("Jan"), 2 => _t("Fev"),  3 => _t("Mar"),  4 => _t("Avr"),  5 => _t("Mai"), 6 => _t("Jun"),
                     7 => _t("Jul"), 8 => _t("Aou"), 9 => _t("Sep"), 10 => _t("Oct"), 11 => _t("Nov"), 12 => _t("Dec"));
    
    return $this->getHtmlTableByAppli($dsData, $bAffTotalCol, $bAffTotalLig, $tabMois, $iMois, $iAnnee,$bGraphique);
  }

  
  /**
   * Initialise un document excel
   */
  private function initExcel()
  {
    AffHeaderFileDownload("", "statistiques.xls", 0, "application/vnd.ms-excel");
    
    // Creating a workbook
    $this->workbook = new Workbook("-");
  }

  /**
   * Ajoute un onglet nommé avec un titre qui devient l'onglet courant
   * @param strSheetName  intitule de la feuille de calcul
   * @param strTitle      titre de la feuille
   */
  private function addExcelSheet($strSheetName, $strTitle)
  {
    $this->currentWorksheet =& $this->workbook->add_worksheet($strSheetName);
     
    $iCol = 0;
    $iRow = 0;
    $this->currentWorksheet->write_string($iRow, $iCol, mb_convert_encoding($strTitle, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING));
  }

  /**
   * 
   */
  private function addRowExcelSheet($tabData, $iRow)
  {
    $iCol = 0;
    foreach($tabData as $strText) {
      if( is_numeric($strText) ) {
        $this->currentWorksheet->write_number($iRow, $iCol, $strText);
      } else {
        $this->currentWorksheet->write_string($iRow, $iCol, mb_convert_encoding($strText, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING));
      }
      $iCol++;
    }
  }

  /**
   * Finalise un document excel
   */
  private function closeExcel()
  {
    $this->workbook->close();
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/help/espace_09_stats_list.htm"); 
  }
  
  /**
   * créer un graphique de type multilignes
   * @param unknown_type $nameTab la liste des abscisse (mois)
   * @param unknown_type $dataTab les données
   * @param unknown_type $lineName les noms des différentes courbes
   * @return chaine html
   */
  public function getHtmlGrapheMultipleLine($nameTab,$dataTab,$lineName){
    if(count($nameTab)<=0 || count($dataTab)<=0 || count($lineName)<=0 || count($lineName) > 10){
      return "";
    }
    // Dataset definition  
   $DataSet = new pData;  
   for($i = 1; $i < (count($dataTab)-1); $i++){
     $arrayMerged = $dataTab[$i]+array_fill(0, count($nameTab)+2, 0);
     ksort($arrayMerged);
     $nomSerie = "Serie".($i);
     $DataSet->AddPoint(array_slice($arrayMerged, 1, count($nameTab)),$nomSerie);
     $DataSet->AddSerie($nomSerie);
     $DataSet->SetSerieName($lineName[$i],$nomSerie);     
   }
   $DataSet->AddPoint($nameTab,"Serie0");   
   $DataSet->SetAbsciseLabelSerie("Serie0");     
     
   // Initialise the graphe
   $Test = new pChart(830,230);     
   $Test->setFontProperties(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."alkanet/font/tahoma.ttf",8);
   $Test->setGraphArea(70,30,680,200);
   $Test->drawFilledRoundedRectangle(7,7,693,223,5,240,240,240);
   $Test->drawRoundedRectangle(5,5,695,225,5,230,230,230);
   $Test->drawGraphArea(255,255,255,TRUE);
   $Test->drawScale($DataSet->GetData(),$DataSet->GetDataDescription(),SCALE_NORMAL,150,150,150,TRUE,0,2);     
   $Test->drawGrid(4,TRUE,230,230,230,50);  
     
   // Draw the 0 line     
   $Test->setFontProperties(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."alkanet/font/tahoma.ttf",6);     
   $Test->drawTreshold(0,143,55,72,TRUE,TRUE);     
     
   // Draw the line graph  
   $Test->drawLineGraph($DataSet->GetData(),$DataSet->GetDataDescription());     
   $Test->drawPlotGraph($DataSet->GetData(),$DataSet->GetDataDescription(),3,2,255,255,255);     
     
   // Finish the graph     
   $Test->setFontProperties(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."alkanet/font/tahoma.ttf",8);     
   $Test->drawLegend(700,50,$DataSet->GetDataDescription(),255,255,255);     
   
   $nomGraphe = 'graphe_'.rand().'.png';
    $Test->Render(ALK_ALKANET_ROOT_PATH.'upload/cache/'.$nomGraphe);
    $imagePath = ALK_ALKANET_ROOT_PATH.'upload/cache/'.$nomGraphe;
    $imageUrl = ALK_ALKANET_ROOT_URL.'upload/cache/'.$nomGraphe;
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&export=2&imagePath=".$imagePath);
    return '<span style="float:center"><a href="'.ALK_ALKANET_SQL.'?token='.$strToken.'" title="Cliquer sur le graphique pour le télécharger">'.
        '<img src="'.$imageUrl.'"></a></span>';
  }
  
  /**
   * crée un graphique de type camembert 
   * @param unknown_type $nameTab le nom des part du camembert
   * @param unknown_type $dataTab les données
   * @return chaine html
   */
  public function getHtmlGraphePie($nameTab,$dataTab){
    if(count($nameTab)<=0 || count($dataTab)<=0){
      return "";
    }
    if( defined("ALK_ITEM_PER_STATS") && count($nameTab)>ALK_ITEM_PER_STATS){
    	return "";
    }
    // Dataset definition
    $DataSet = new pData();
    $DataSet->AddPoint($dataTab,"Serie1");
    $DataSet->AddPoint($nameTab,"Serie2");
    $DataSet->AddAllSeries();
    $DataSet->SetAbsciseLabelSerie("Serie2");
    
    // Initialise the graph
    $Test = new pChart(550,200);
    $Test->drawFilledRoundedRectangle(7,7,373,193,5,240,240,240);
    $Test->drawRoundedRectangle(5,5,375,195,5,230,230,230);
    
    
    // Draw the pie chart
    $Test->setFontProperties(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."alkanet/font/tahoma.ttf",8);
    $Test->drawPieGraph($DataSet->GetData(),$DataSet->GetDataDescription(),150,90,110,PIE_PERCENTAGE,TRUE,50,20,5);
    $Test->drawPieLegend(310,15,$DataSet->GetData(),$DataSet->GetDataDescription(),250,250,250);
    
    $nomGraphe = 'graphe_'.rand().'.png';
    $imagePath = ALK_ALKANET_ROOT_PATH.'upload/cache/'.$nomGraphe;
    $Test->Render($imagePath);

    $imageUrl = ALK_ALKANET_ROOT_URL.'upload/cache/'.$nomGraphe;
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&export=2&imagePath=".$imagePath);
    
    return '<div style="text-align:center;"><a href="'.ALK_ALKANET_SQL.'?token='.$strToken.'" title="Cliquer sur le graphique pour le télécharger">'.
            '<img src="'.$imageUrl.'"></a></div>';
  }
  
  /**
   * Telecharge l'image correspondant au graphique
   * @param unknown_type $imagePath
   */
  private function downloadImage($imagePath){
    AffHeaderFileDownload($imagePath, "export_graphe.png", 0, "image/png");
    readfile($imagePath) ;
  }
}
?>