<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormSommaireForm
 * Classe d'affichage de la page plan alkanet
 */
class AlkHtmlFormSommaireForm extends AlkHtmlForm
{

  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formPlan");
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
  }

  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { }

  /**
   * Traitement du formulaire
   */
  public function doSql() 
  { 
    /** rend visible ou invisible un espace du menu */    
    if( !ALK_B_SPACE_MENU_VISIBLE ) return "";
    
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $cont_id = Request("folder_id", REQ_GET, "-1", "is_numeric");
    $iVisible = Request("val", REQ_GET, "1", "is_numeric");

    // enregistre le parametre de visibilite de l'espace dans le menu
    // pour l'utilisateur connecté
    $this->oAppli->oQueryAction->updateSpaceVisible($cont_id, $user_id, $iVisible);

    return "";
  }
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {    
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $user_id = AlkFactory::getSProperty("user_id", "-1");
   
    $this->setLabel(_t("Plan de")." - ".$this->oAppli->getAppliProperty("CONT_INTITULE")." -");
    $this->setLabelDesc(_t("Cette arborescence pr&eacute;sente tous les espaces de travail qui vous sont accessibles depuis cet espace.")."<br/>".
                         ( ALK_B_SPACE_MENU_VISIBLE == true
                           ? _t("Les cases à cocher vous permettent de rendre").
                             " "._t("les espaces de travail sur le menu visibles ou invisibles.")
                           : "" ));
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_layer.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_arbre.js");
    
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_treeview.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery.treeview.js");
    $this->addScriptCss("../../".ALK_ROOT_CLASSE."form/treeview.css");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlformsommaireform.js");
    
    $strHtml = "<div id='layerArbre' style='width:520;'>&nbsp;</div>";
    $oCtrlTxt = AlkHtmlFactory::getHtml($strHtml); 
    $oBlock = $this->addBlock("blockplan", "", "", "10", "510", true);
    $oBlock->addCtrl($oCtrlTxt);

    $strHtmlJs = "";

    if( ALK_B_SPACE_MENU_VISIBLE == true ) {
      $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_CONSULT."&iSheet=".ALK_SHEET_MODIFIER);
      $strHtmlJs .= "function onTreeviewCheckbox(idNoeud, UrlEspace) {".
        "   var ctrlCheckbox = eval('document.formPlan.c' + idNoeud);".
        "   var iChecked = 0;".
        "   if( ctrlCheckbox.checked == true ) iChecked = 1;".
        "   idN = idNoeud.substr(1);".
        "   showHideSpace('".$strToken."', '&folder_id='+idN+'&val='+iChecked);".
        " }";
    }
    
    $strHtmlJs .= " var objTreeview = null; ".
      "function AffTreeview() { ".
      "  objTreeview = new Treeview(document, 'layerArbre', 1);";
        
    // liste des conteneurs accessibles a l'utilisateur
    $dsNoeud = $this->oAppli->oQuery->GetDs_listeEspaceByAgentForArbo($user_id, false, $cont_id, true);
    while( $drNoeud = $dsNoeud->getRowIter() ) {
      $idFils = $drNoeud->getValueName("ID");
      $iVisible = $drNoeud->getValueName("CONT_VISIBLE");
      if( $iVisible == "" ) {
        $iVisible = "2"; 
      }
      $idPere = $drNoeud->getValueName("ID_PERE");
      $iNiv = $drNoeud->getValueName("NIV");
      $iDroitLink = $drNoeud->getValueName("DROIT");
      if( $iDroitLink == "" ) {
        $iDroitLink = "-1";
      }
      $strNom = $drNoeud->getValueName("NOM");
      $iForce = $drNoeud->getValueName("FORCEVISIBLE");
    
      $strNom = preg_replace( "/\"/", "'", $strNom);
      $strNom = preg_replace( "/'/", "\'", $strNom);
    
      $strToken = AlkRequest::getEncodeParam("cont_id=".$idFils."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_CONSULT."&iSheet=".ALK_SHEET_ARBORESCENCE);
      $strUrl = ""; 
      if( $iDroitLink == "-1" && $iForce == "0" ) continue;
      if( !($iForce == 1 && $iDroitLink == "-1") ) {
        $strUrl = "javascript:AffAdmin('".$strToken."')";
      }

      $iDroitLink = 2;
      $iDroitAction = 0;
      $iChecked = ( ALK_B_SPACE_MENU_VISIBLE == true ? $iVisible : -1 );
    
      $strHtmlJs .= " objTreeview.AddFolder(\"_".$idFils."\", \"_".$idPere."\", \"".$strNom."\", ".
        ($iNiv+1).", ".$iDroitLink.", ".$iDroitAction.", \"".$strUrl."\", \"\", ".$iChecked.");";
    }
    
    /* liste des applications accessibles a l'utilisateur
    $dsFeuille = $queryCont->GetDs_listeAppliByAgentForArbo($_SESSION["sit_idUser"]);
    while( $drFeuille = $dsFeuille->getRowIter() ) {
      $id = $drFeuille->getValueName("ID");
      $idNoeud = $drFeuille->getValueName("ID_NOEUD");
      $strUrl = $drFeuille->getValueName("URLJS");
      $strUrl1 = $drFeuille->getValueName("URL");
      $strIcone = $drFeuille->getValueName("ICONE");
      $strNom = $drFeuille->getValueName("NOM");
    
      $strNom = ereg_replace( "\"", "'", $strNom);
      $strNom = ereg_replace( "'", "\'", $strNom);
      $iDroitLink = 2;
      $iDroitAction = 0;
    
      if( strtolower(substr($strUrl, 0, 10)) != "javascript" )
        $strUrl = ALK_SIALKE_URL.ALK_ROOT_MODULE.$strUrl1;
    
      $strIcone = ALK_URL_SI_MEDIA."pictos/plan/".$strIcone;
      echo "  objTreeview.AddDoc(\"_".$id."\", \"_".$idNoeud."\", \"".$strNom."\", ".
        $iDroitLink.", ".$iDroitAction.", \"".$strIcone."\", \"".$strUrl."\", \"\");";
    }
    */

    $strHtmlJs .= " /* paramétrage */".
      " objTreeview.classLinkFolder = '';".
      " objTreeview.classTextFolder = 'txtNormal';".
      " objTreeview.classLinkDoc = '';".
      " objTreeview.classTextDoc = 'txtNormal';".
    
      " objTreeview.imgNodeOpen = '';".
      " objTreeview.imgNodeClose = '';".
      " objTreeview.imgNode = '';".
    
      " objTreeview.bShowNode = false;".
      " objTreeview.bCanShowHideNode = false;".
      " objTreeview.strNodeName = ' applications';".
      " objTreeview.iSizeIcon = '16';".
    
      " /* affichage */".
      
      " objTreeview.OpenNodeToRoot('_".$cont_id."');".
      "}";

    $this->addJs($strHtmlJs);
    //$this->addOnLoad("AffTreeview()");
    $this->addOnLoad("AffTreeview();dragAndDropPages('layerArbre');");
  }

  /**
  * Retourne l'aide associée au formulaire
  * @return string
  */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/help/espace_sommaire.htm"); 
  }

}
    
?>