<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormEspace
 * Classe d'affichage de la page propriété d'un espace
 */
class AlkHtmlFormEspace extends AlkHtmlForm
{
  protected $cont_id;
  protected $cont_intitule_court;
  protected $cont_intitule;
  protected $cont_alias;
  protected $cont_public;
  protected $cont_desc;
  protected $cont_date_crea;
  protected $cont_date_maj;
  protected $agent_nomcrea;
  protected $agent_nommaj;
  protected $cont_logo;
  protected $cont_logo2;
  protected $cont_bandeau;
  protected $type_crea;
  protected $cont_css;
  protected $cont_type;
  protected $cont_visible;
  protected $cont_archive;
  protected $cont_type_id;

  protected $tabFields;
  protected $cont_id_return;
  
  protected $cont_front_url;
  protected $cont_admin_url;
  
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formSpace");

    $iModeForm = AlkRequest::getToken("iMode", AlkRequest::_GETint("iMode",ALK_FORM_MODE_UPDATE));
    $cont_id = AlkRequest::getToken("cont_id", -1);

    $strParam ="cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".$this->iTypeSheet."&iSheet=".ALK_SHEET_FICHE."&iMode=".$iModeForm;
    $strAction = ALK_ALKANET_SQL."?token=".AlkRequest::getEncodeParam($strParam);

    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);
    
    $this->tabFields = array();
  }

  /**
   * Déclaration et récupération des données du formulaire
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit)
  {
    $tabMultilingue = "";
    // changement quand on vient de collab
    $cont_id = $this->oAppli->cont_id;
    $this->user_id = AlkFactory::getSProperty("user_id", "-1");
    
    $this->cont_id             = new AlkFormData($this, "cont_id", $cont_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->cont_intitule_court = new AlkFormData($this, "cont_intitule_court", "", ALK_SQL_TEXT);
    $this->cont_intitule       = new AlkFormData($this, "cont_intitule", "", ALK_SQL_TEXT);
    $this->cont_alias          = new AlkFormData($this, "cont_alias", "", ALK_SQL_TEXT);
    $this->cont_public         = new AlkFormData($this, "cont_public", 0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->cont_desc           = new AlkFormData($this, "cont_desc", "", ALK_SQL_TEXT);
    $this->cont_date_crea      = new AlkFormData($this, "cont_date_crea", "");
    $this->cont_date_maj       = new AlkFormData($this, "cont_date_maj", "");
    $this->agent_nomcrea       = new AlkFormData($this, "agent_nomcrea", "");
    $this->agent_nommaj        = new AlkFormData($this, "agent_nommaj", "");
    $this->cont_logo           = new AlkFormData($this, "cont_logo", "", ALK_SQL_TEXT);
    $this->cont_logo2          = new AlkFormData($this, "cont_logo2", "", ALK_SQL_TEXT);
    $this->cont_bandeau        = new AlkFormData($this, "cont_bandeau", "", ALK_SQL_TEXT);
    $this->type_crea           = new AlkFormData($this, "type_crea", 0, ALK_SQL_NONE, ALK_VERIF_NUMERIC);
    $this->cont_css            = new AlkFormData($this, "cont_css", ALK_DEFAULT_CSS, ALK_SQL_TEXT);
    $this->cont_type           = new AlkFormData($this, "cont_type", ALK_DEFAULT_TEMPLATE, ALK_SQL_TEXT);
    $this->cont_visible        = new AlkFormData($this, "cont_visible", 0, ALK_SQL_NUMBER, ALK_VERIF_CHECK);
    $this->cont_archive        = new AlkFormData($this, "cont_archive", 0, ALK_SQL_NUMBER, ALK_VERIF_CHECK);
    $this->cont_type_id        = new AlkFormData($this, "cont_type_id", 0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->cont_objet          = new AlkFormData($this, "cont_objet", "", ALK_SQL_TEXT);
    
    $this->cont_root_front_url      = new AlkFormData($this, "cont_root_front_url", $tabMultilingue, ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);
    $this->cont_root_admin_url      = new AlkFormData($this, "cont_root_admin_url", $tabMultilingue, ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);
    
    $oDrData = null;
        
    $reqMethod = -1;
    if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW && $this->iMode==ALK_FORM_MODE_UPDATE ) {
      $oDsData = $this->oAppli->oQuery->GetDs_ficheEspaceById($cont_id, "", true);
      if( !($oDrData = $oDsData->GetRowIter()) )
        $oDrData = null;
    }
    
    
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
    $this->initData($iTypeInit, $oDrData, $reqMethod);
  }

  /**
   * Traitement du formulaire
   */
  public function doSql()
  {
    $this->setData(ALK_INIT_MODE_REQUEST);
    $strParam ="appli_id=-1&iTypeSheet=".$this->iTypeSheet."&iSheet=".ALK_SHEET_FICHE."&iSSheet=".ALK_SHEET_NONE."&cont_id=";
   
    $iMode = AlkRequest::getToken("iMode");
    switch( $iMode ) {
    case ALK_FORM_MODE_ADD:

      $this->tabFields = $this->getTabQuery(array(),
                                      array("CONT_DATE_CREA", "CONT_DATE_MAJ", "AGENT_NOMCREA", "AGENT_NOMMAJ"));
      if( isset($_POST["ctrl_espace"])) 
        $this->tabFields["field"]["CTRL_ESPACE"] = array(ALK_SQL_NUMBER, $_POST["ctrl_espace"]);
      
      $this->cont_id_return = $this->oAppli->addSpace($this->tabFields);
      break;

    case ALK_FORM_MODE_UPDATE:
      $this->cont_id_return = $this->oAppli->cont_id;
      $this->tabFields = $this->getTabQuery(array("CONT_ID"), 
                                      array("CONT_DATE_CREA", "CONT_DATE_MAJ", "AGENT_NOMCREA", "AGENT_NOMMAJ"));
      $this->oAppli->updateSpace($this->cont_id_return, $this->tabFields);
      break;

    case ALK_FORM_MODE_DEL:
      $this->cont_id_return = $this->oAppli->delSpace();
      if( $this->cont_id_return == 0 ) {
        $this->cont_id_return = 1;
      }
      break;
    }

    $strUrl = ALK_ALKANET."?token=".AlkRequest::getEncodeParam($strParam.$this->cont_id_return);
    return $strUrl;
  }
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);

    $this->setLabel( $this->iMode == ALK_FORM_MODE_ADD
                     ? _t("Création d'un nouvel espace de travail")
                     : _t("Modification des propriétés de l'espace de travail") );

    // création des controles
    $iWidthTxt      = 40;
    $iWidthTxtRight = 35;
    $iWidthSelectRight = 270;
    $iWidthMemo     = 38;
    $iHeightMemo    = 4;

    $iWidthLabelLeft  = 90;
    $iWidthCtrlLeft   = 200;

    $iWidthLabelRight = 100;
    $iWidthCtrlRight  = 200;

    $cont_id   = $this->oAppli->cont_id;
    $cont_pere = ( $this->iMode == ALK_FORM_MODE_ADD
                    ? $cont_id
                    : $this->oAppli->getAppliProperty("CONT_PERE") );
    $cont_niveau = $this->oAppli->getAppliProperty("CONT_NIVEAU") + ( $this->iMode == ALK_FORM_MODE_ADD ? 1 : 0 );
    
    // ajout de l'onglet Propriétés 
    $this->addBlockProprietes($cont_id, $cont_niveau);
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    
    $oCtrlDate = null;
    if( $this->iMode == ALK_FORM_MODE_UPDATE ) {
      $strHtml = ( $this->cont_date_crea->value != ""
                   ? _f("Créé le %s par %s", $this->cont_date_crea->value, $this->agent_nomcrea->value)."<br/>".
                     ( $this->cont_date_maj->value != ""
                       ? _f("Modifié le %s par %s", $this->cont_date_maj->value, $this->agent_nommaj->value)
                       : "" )
                   : "" );
      $oCtrlDate = AlkHtmlFactory::getHtml($strHtml);
    }

    $oCtrlLogo1 = null;
    if( defined("ALK_SPACE_TAILLE_LOGO1") && ALK_SPACE_TAILLE_LOGO1!="" ) {
      $oCtrlLogo1 = AlkHtmlFactory::getHtmlFile($this->cont_logo, _f("Image").ALK_SPACE_TAILLE_LOGO1, $iWidthTxtRight);
      $oCtrlLogo1->setDualMode(true);
      $oCtrlLogo1->setFileUrl($this->oAppli->getUrlUpload(), $this->cont_logo->value);
    }

    $oCtrlLogo2 = null;
    if( defined("ALK_SPACE_TAILLE_LOGO2") && ALK_SPACE_TAILLE_LOGO2!="" ) {
      $oCtrlLogo2 = AlkHtmlFactory::getHtmlFile($this->cont_logo2, _f("Image").ALK_SPACE_TAILLE_LOGO2, $iWidthTxtRight);
      $oCtrlLogo2->setDualMode(true);
      $oCtrlLogo2->setFileUrl($this->oAppli->getUrlUpload(), $this->cont_logo2->value);
    }

    $oCtrlBandeau = null;
    $oCtrlCss = null;
    $oCtrlType = null;
    if( defined("ALK_SPACE_TAILLE_BANDEAU") && ALK_SPACE_TAILLE_BANDEAU!="" ) {
      $oCtrlBandeau = AlkHtmlFactory::getHtmlFile($this->cont_bandeau, _f("Bandeau").ALK_SPACE_TAILLE_BANDEAU, $iWidthTxtRight);
      $oCtrlBandeau->setDualMode(true);
      $oCtrlBandeau->setFileUrl($this->oAppli->getUrlUpload(), $this->cont_bandeau->value);

      $oCtrlCss = AlkHtmlFactory::getHtmlSelect($this->cont_css, _f("Feuille de style"), 1);
      $tabCss = getTabFilesByDir(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE, array("css"));
      // on va chercher les modèles de css
      $tabCss = array_merge($tabCss, getTabFilesByDir(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."alkanet/styles/", array("css")) );
      $tabCss = array_filter($tabCss, array($this, "filterCss"));
      $oCtrlCss->setProperty("tabValTxt", $tabCss);

      $oCtrlType = AlkHtmlFactory::getHtmlSelect($this->cont_type, _t("Type interface"), 1);
      $tabTemplate = getTabFilesByDir(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF, array("tpl"));
      $tabTemplate = array_filter($tabTemplate, array($this, "filterTemplate"));
      $tabTmp = array_map(array($this, "renameTemplate"), $tabTemplate);
      sort($tabTmp);
      $tabTemplate = array();
      foreach($tabTmp as $strType) {
        $tabTemplate[$strType] = $strType;
      }
      
      // on va chercher les modèles
      $tabTemplate2 = getTabFilesByDir(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."alkanet/templates/", array("tpl"));
      $tabTemplate2 = array_filter($tabTemplate2, array($this, "filterTemplate"));
      $tabTmp2 = array_map(array($this, "renameTemplate"), $tabTemplate2);
      foreach($tabTmp2 as $strType) {
        $tabTemplate[$strType] = $strType;
      }
   
      $oCtrlType->setProperty("tabValTxt", $tabTemplate);
    }

    $oCtrlCrea = null;
    if( $this->iMode==ALK_FORM_MODE_ADD /*&& $cont_niveau>2*/ ) {
      $oCtrlCrea = AlkHtmlFactory::getHtmlRadio($this->type_crea, ""/*Type de création*/);
      $oCtrlCrea->setSeparator("<br/>");
      $oCtrlCrea->addRadio(0, _t("Créer un espace vierge"));
      $oCtrlCrea->addRadio(1, _t("Avec les applications de l'espace parent"));
      $oCtrlCrea->addRadio(2 ,_t("Avec les utilisateurs (et animateurs) de l'espace parent"));
      $oCtrlCrea->addRadio(3, _t("Avec les applications et les utilisateurs (et animateurs)"));
      $oCtrlCrea->addRadio(4, _t("Dupliquer l'espace"));
      $oCtrlCrea->addEventToRadio(0,"onclick","DisableEspace(0)");
      $oCtrlCrea->addEventToRadio(1,"onclick","DisableEspace(1)");
      $oCtrlCrea->addEventToRadio(2,"onclick","DisableEspace(2)");
      $oCtrlCrea->addEventToRadio(3,"onclick","DisableEspace(3)");
      $oCtrlCrea->addEventToRadio(4,"onclick","DisableEspace(4)");

      // sélection des espaces dupliquables
      $dsEspace = $this->oAppli->oQuery->getDsEspaceDupliquablesForCombo($user_id);
      $oCtrlEspace = AlkHtmlFactory::getNewHtmlSelect($this, "0", "ctrl_espace",-1,"",1,$iWidthSelectRight-50);
      $oCtrlEspace->setProperty("oValTxt", $dsEspace);
      $tabDefault[-1]= _t("Selectionnez");
      $oCtrlEspace->setProperty("tabValTxt", $tabDefault);
      $oCtrlEspace->setLabelBefore(_t("Espace")."&nbsp;");
      
      $oCtrlTypeDup = AlkHtmlFactory::getNewHtmlRadio($this, 0, "typedup_espace", 1,"");
      $oCtrlTypeDup->addRadio(1, _t("Avec structure et paramétrage"));
      $oCtrlTypeDup->addRadio(2, _t("Avec structure, paramétrage et données"));
      $oCtrlTypeDup->setSeparator("<br/>");
      $oCtrlEspace->setDisabled(true);
      $oCtrlTypeDup->setDisabled(true);    
    }
    
    $oCtrlArbo = null;
    $bDroitAdd = true;
    $bContVide = false;
    $strHtml = $this->getHtmlBlockArbo($bDroitAdd, $bContVide);
    if( $strHtml != "" ) {
      $oCtrlArbo = AlkHtmlFactory::getHtml($strHtml);
    }
    

    if( $oCtrlLogo1 != null || $oCtrlLogo2 != null || $oCtrlBandeau != null ) {
      $oBlockPers =& $this->addBlock("block_2", _t("Personnalisation"), "", $iWidthLabelRight, $iWidthCtrlRight, false);
      $oBlockPers->addCtrl($oCtrlLogo1);
      $oBlockPers->addCtrl($oCtrlLogo2);
      $oBlockPers->addCtrl($oCtrlBandeau);
      $oBlockPers->addCtrl($oCtrlCss);
      $oBlockPers->addCtrl($oCtrlType);
      $foo = AlkHtmlFactory::getHtml("&nbsp;");
      $oBlockPers->addCtrl($foo);
    }

    if( $this->iMode==ALK_FORM_MODE_UPDATE && $oCtrlDate != null ) {
      $oBlockDate =& $this->addBlock("block_3", _t("Méta-information"), "", $iWidthLabelLeft, $iWidthCtrlLeft, false);
      $oBlockDate->addCtrl($oCtrlDate, ALK_HTMLFORM_1L1C);
    }
    if( $this->iMode==ALK_FORM_MODE_UPDATE && $oCtrlArbo != null ) {
      $oBlockArbo =& $this->addBlock("block_4", _t("Gestion de l'arborescence"), "", $iWidthLabelRight, $iWidthCtrlRight, false);
      $oBlockArbo->addCtrl($oCtrlArbo, ALK_HTMLFORM_1L1C);
    }
    if( $this->iMode==ALK_FORM_MODE_ADD && $oCtrlCrea != null ) {
      $oBlockCrea =& $this->addBlock("block_5", _t("Type de création"), "",1, $iWidthCtrlRight+$iWidthLabelRight, false);
      $oBlockCrea->addCtrl($oCtrlCrea, ALK_HTMLFORM_1L1C);
      $oBlockCrea->addCtrl($oCtrlEspace);
      $oBlockCrea->addCtrl($oCtrlTypeDup);
    }
   

    /** ajout de boutons */
      
    $strParamSheet = "iTypeSheet=".$this->iTypeSheet."&iSheet=".ALK_SHEET_FICHE."&iSSheet=".ALK_SHEET_NONE."&appli_id=-1&cont_id=".$cont_id."&iMode=";

    $strToken = AlkRequest::getEncodeParam($strParamSheet.$this->iMode);
    $oButton = $this->addButtonPage("bt_1", "javascript:Valider('".$strToken."');", _t("Valider"), _t("Valider"));
    $this->addSubmitButton($oButton);

    if( $this->iMode == ALK_FORM_MODE_UPDATE ) {
      $oButton = $this->addButtonPage("bt_2", "javascript:Annuler()", _t("Annuler"), _t("Annuler les modifications"));
      $this->setResetButton($oButton);
    } else {
      $strToken = AlkRequest::getEncodeParam($strParamSheet.ALK_FORM_MODE_UPDATE);
      $this->addButtonPage("bt_2", ALK_ALKANET."?token=".$strToken, _t("Annuler"), _t("Annuler les modifications"));
    }

    $user_id = AlkFactory::getSProperty("user_id", "-1");
    if( $bDroitAdd == true && ($bContVide == true || $user_id==ALK_USER_ID_ADMINALK) && $cont_id != 1 ) {
      $strToken = AlkRequest::getEncodeParam($strParamSheet.ALK_FORM_MODE_DEL);
      $this->addButtonPage("bt_3", "javascript:SupprCont('".$strToken."')", _t("Supprimer"), _t("Supprimer cet espace vide"));
    }

    /** ajout des javascripts */
    $this->addJavascript();
  }

  /**
   * Retourne le code html du block en lecteur Gestion arborescence
   * @return string
   */
  private function getHtmlBlockArbo(&$bDroitAdd, &$bContVide)
  {
    // pas de logo pour le conteneur principal
    $cont_id = $this->oAppli->cont_id;
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    
    $iFileFlag = ( $cont_id == 1 ? 0 : 1 );

    $strHtmlNav = "";
    $dsContPere = null;

    $strParamSheet = "iTypeSheet=".ALK_TYPESHEET_ADMIN."&iSheet=".ALK_SHEET_FICHE."&iSSheet=".ALK_SHEET_NONE."&appli_id=-1&cont_id=";

    if( $bDroitAdd == true ) {
      $strTokenArbo = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_ARBORESCENCE, ALK_SHEET_NONE);
      $strHtmlNav .= '<div>'.
        '<span class="txtNormal">- </span><a href="javascript:OpenArbo(\''.$strTokenArbo.'\')" title="'.
        _t("Arborescence des espaces de travail administrables").'">'.
        _t("Arborescence des espaces de travail administrables").'</a></div>'.
        '<div>'.
        '<span class="txtNormal">- </span>'.
        '<a href="'.ALK_ALKANET.'?token='.AlkRequest::getEncodeParam($strParamSheet.$cont_id.'&iMode='.ALK_FORM_MODE_ADD).
        '" title="'._t("Cr&eacute;er un espace fils").'">'.
        _t("Cr&eacute;er un espace fils").'</a></div>';
    }

    if( $cont_id != 1 ) {
      // conteneur pere dont l'agent connecte est animateur
      $cont_pere = $this->oAppli->getAppliProperty("CONT_PERE");
      $dsContPere = $this->oAppli->oQuery->GetDs_listeEspaceByAnimateur($cont_pere, $user_id, false);
	
      // verifie si le conteneur est vide
      $bContVide = $this->oAppli->oQuery->GetBool_espaceVide($cont_id);

      if( $drContPere = $dsContPere->getRowIter() ) {
        $strContPere = $drContPere->getValueName("CONT_INTITULE");

        $strHtmlNav .= '<div>'.
                    '<span class="txtNormal bold" style="white-space:nowrap">- '._t("Atteindre l'espace père :").' </span><a '.
                    'href="'.ALK_ALKANET."?token=".AlkRequest::getEncodeParam($strParamSheet.$cont_pere.'&iMode='.ALK_FORM_MODE_UPDATE).
                    '" title="'._t("Atteindre l'espace père :").'">'.$strContPere.
                    '</a></div>';
      }
    }

    // liste des sous-conteneurs dont l'agent connecte est animateur
    $dsSsCont = $this->oAppli->oQuery->GetDs_listeEspaceByAnimateur($cont_id, $user_id);
    if( $drSsCont = $dsSsCont->getRowIter() ) {
      $strHtmlNav .= '<div>'.
                     '<span class="txtNormal bold" style="white-space:nowrap">- '._t("Atteindre les espaces fils :").' </span>'.
                   '<ul>';

      while( $drSsCont ) {
        $cont_id_fils = $drSsCont->getValueName("CONT_ID");
        $strContFils = $drSsCont->getValueName("CONT_INTITULE");
        $strHtmlNav .= '<li><a href="'.ALK_ALKANET.'?token='.
                        AlkRequest::getEncodeParam($strParamSheet.$cont_id_fils.'&iMode='.ALK_FORM_MODE_UPDATE).
                        '" title="'.$strContFils.'">'.$strContFils.'</a></li>';
        $drSsCont = $dsSsCont->getRowIter();
      }
      $strHtmlNav .= '</ul></div>';
    } 
    
    return $strHtmlNav;
  }

  /**
   * appels javascript
   */
  protected function addJavascript(){
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlformespace.js");
    $this->addOnload("onChangeContPublic(".$this->cont_public->value.");");

    $this->setTemplate("espace", "alkhtmlformespace.tpl");
    $this->assign("iMode", $this->iMode);
    $this->assign("ALK_B_SPACE_SEND_MAIL", ALK_B_SPACE_SEND_MAIL);
  }

  /**
   * bloc propriété de l'espace de travail
   *
   */
  protected function addBlockProprietes($cont_id, $cont_niveau, $bCbVisible=true)
  {
    $iWidthTxt      = 40;
    $iWidthTxtRight = 35;
    $iWidthSelectRight = 270;
    $iWidthMemo     = 38;
    $iHeightMemo    = 4;

    $iWidthLabelLeft  = 90;
    $iWidthCtrlLeft   = 300;

    $iWidthLabelRight = 110;
    $iWidthCtrlRight  = 280;
    
    // si animateur ou admin mode modif sinon readonly pour qlqs chmps
    $dsAnimateur = $this->oAppli->oQuery->getDs_listeAnimateurByEspaceForCombo($this->cont_id->value);
    $bIsAnim = false;

    while($drAnimateur = $dsAnimateur->getRowiter()){     
      if($this->user_id == $drAnimateur->getValueName("id")){
        $bIsAnim = true;
      }
    }
    
    
    $strLabelIntitule = _t("Intitulé court");
    if( defined("ALK_B_SPACE_TEST_NAME") && ALK_B_SPACE_TEST_NAME == true ) {
      $strLabelIntitule = "<a class='formLabel' style='text-decoration:underline' title='Tester' ".
        "href='javascript:OpenTest()'>".$strLabelIntitule."</a>";
    }

    $oCtrlTxt = AlkHtmlFactory::getHtmlText($this->cont_intitule, _t("Intitulé"), 1, $iWidthTxt, 80);
    $oCtrlTxt->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
    $oCtrlTxt->addEvent("onKeyUp", "onKeyUpIntitule()");
    
    $oCtrlTxtC = AlkHtmlFactory::getHtmlText($this->cont_intitule_court, $strLabelIntitule, 1, $iWidthTxt, 32);
    $oCtrlTxtC->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);

    $oCtrlTxtA = AlkHtmlFactory::getHtmlText($this->cont_alias, _t("Accès rapide"), 1, 18, 32);
    $oCtrlTxtA->AddValidator(ALK_VERIF_TEXT);
    $oCtrlTxtA->setLabelBefore(ALK_ROOT_URL."/");
    $oCtrlTxtA->setLabelAfter(".htm");
    $bShow = ( defined("ALK_B_SPACE_LINK") && ALK_B_SPACE_LINK == true && $cont_niveau>1 );
    $oCtrlTxtA->setHidden(!$bShow);

    $oCtrlTxtDom = AlkHtmlFactory::getHtmlText($this->cont_root_front_url, _t("Domaine de l'espace"), 1, 18, 200);
    $oCtrlTxtDom->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
    $oCtrlTxtDom->setLabelAfter(_t("ex: http://www.mon-domaine.fr"));
    
    $oCtrlTxtDomAdmin = AlkHtmlFactory::getHtmlText($this->cont_root_admin_url, _t("Domaine d'administration de l'espace"), 1, 18, 200);
    $oCtrlTxtDomAdmin->AddValidator(ALK_VERIF_TEXT);
    $oCtrlTxtDomAdmin->setLabelAfter(_t("ex: http://admin.mon-domaine.fr"));
    
    $oCtrlMemo = AlkHtmlFactory::getHtmlText($this->cont_desc, _t("Description"), $iHeightMemo, $iWidthMemo, 4000);
    $oCtrlMemo->AddValidator(ALK_VERIF_TEXT, 0, 4000);

    $oCtrlRadio = AlkHtmlFactory::getHtmlRadio($this->cont_public, _t("Accessibilité"));
    $oCtrlRadio->setSeparator("<br/>");
    if( defined("ALK_SPACE_PRIVE_VISIBLE") && ALK_SPACE_PRIVE_VISIBLE==true ) {
      $oCtrlRadio->AddRadio(0, _t("Espace privé"));
      $oCtrlRadio->AddRadio(2, _t("Espace privé visible (avec demande d'invitation)"));
      $oCtrlRadio->AddRadio(1, _t("Espace public"));
      $oCtrlRadio->addEventToRadio(2, "onclick", "onChangeContPublic(2)");
    } else {
      $oCtrlRadio->AddRadio(0, _t("Espace privé"));
      $oCtrlRadio->AddRadio(1, _t("Espace public"));
    }
    $oCtrlRadio->addEventToRadio(0, "onclick", "onChangeContPublic(0)");
    $oCtrlRadio->addEventToRadio(1, "onclick", "onChangeContPublic(1)");
    
    $oCtrlDept = $this->getCtrlDept();
    
    if ( $bCbVisible ) {
      $oCtrlVisible = AlkHtmlFactory::getHtmlCheckbox($this->cont_visible, _t("Visible"));
      $oCtrlVisible->setLabelAfter("("._t("force l'affichage de l'espace sur le plan").")");
    } else {
      $oCtrlVisible = null;
    }
    
    $oCtrlArchive = AlkHtmlFactory::getHtmlCheckbox($this->cont_archive, _t("Espace archive"));
    $oCtrlArchive->setLabelAfter("("._t("Espace destiné à contenir les documents archivés").")");

    $oCtrlType = AlkHtmlFactory::getHtmlSelect($this->cont_type_id, "Catégorie",1,$iWidthSelectRight);
    $dsThemGrpTrav = $this->oAppli->oQuery->getDsListTypeByGrpTravailForCombo($this->cont_id->value);
    $oCtrlType->setProperty("oValTxt", $dsThemGrpTrav);
    $tabDefault[-1]= _t("Selectionnez");
    $oCtrlType->setProperty("tabValTxt", $tabDefault);

    $oCtrlObjet = AlkHtmlFactory::getHtmlText($this->cont_objet, _t("Objet"), $iHeightMemo, $iWidthMemo, 4000);
    $oCtrlObjet->AddValidator(ALK_VERIF_TEXT, 0, 255);
    
    /* VERIF droits des réferents sur qlqs champs */
    if(!$bIsAnim){
      $oCtrlType->setMode(1);
      $oCtrlArchive->setMode(1); 
      $oCtrlMemo->setMode(1);
    }
    
    /** création des blocs et association des controles */
    $strLib = ( $this->iMode==ALK_FORM_MODE_ADD 
                ? _t("Propriétés de l'espace à créer") 
                : _t("Propriétés de l'espace")." (id=".$cont_id.")" );
        
    $oBlockProp =& $this->addBlock("block_1", $strLib, "", $iWidthLabelLeft, $iWidthCtrlLeft, true);
    $oBlockProp->addCtrl($oCtrlTxt);
    $oBlockProp->addCtrl($oCtrlTxtC);
    $oBlockProp->addCtrl($oCtrlTxtDom);
    $oBlockProp->addCtrl($oCtrlTxtDomAdmin);
    $oBlockProp->addCtrl($oCtrlTxtA);
    $oBlockProp->addCtrl($oCtrlMemo);
    $oBlockProp->addCtrl($oCtrlRadio);
    $oBlockProp->addCtrl($oCtrlDept);
    $oBlockProp->addCtrl($oCtrlVisible);
    $oBlockProp->addCtrl($oCtrlArchive);
    $oBlockProp->addCtrl($oCtrlType);
    if( defined("ALK_B_GRP_TRAV_OBJET") && ALK_B_GRP_TRAV_OBJET==true ) {
      $oBlockProp->addCtrl($oCtrlObjet);  
    }
  }
  
  /**
   * Retourne le ctrl associé à la liste des entités territoriales disponibles
   * @return string
   */
  private function getCtrlDept()
  {
    $oDataDept = new AlkFormData($this, "dept[]",0);

    $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
    $dsDept = $this->oAppli->oQuery->getDsListeDptCont($this->cont_id->value);
    if( $dsDept->getCountTotDr() == 0 ) {
      $oCtrlHtml = AlkHtmlFactory::getHtml(_f("pour les services de type %s", ALK_S_SERV_DTYPEETAT), _t("Espace public"), "dept[]"); 
      $oCtrlHtml->setTemplate("espace", "alkhtmlctrldept.tpl");
      $oCtrlHtml->assign("nbDept", 0);
      return $oCtrlHtml;   
    } 
    
    $dsDept->setTree("DEPT_ID", "DEPT_PERE");
    
    $oCtrlCB = AlkHtmlFactory::getHtmlCheckbox($oDataDept, _t("Espace public vis-à-vis de"));
    $oCtrlCB->setItemsPerLine(1);
    while( $drDept = $dsDept->getRowIter() ) {
      $dept_id       = $drDept->getValueName("DEPT_ID");
      $dept_intitule = $drDept->getValueName("DEPT_LABEL");
      $cont_id       = $drDept->getValueName("CONT_ID");
      if( $dept_id == "0" ) {
        $dept_intitule .= "<i> ("._t("par défaut si aucun").")</i>";
      }
      $oCtrlCB->addCheckBox(( $cont_id != "" || $this->iMode==ALK_FORM_MODE_ADD ? $dept_id : -1 ), $dept_intitule, $dept_id, -1);
    }
    $oCtrlCB->setTemplate("espace", "alkhtmlctrldept.tpl");
    $oCtrlCB->assign("nbDept", $dsDept->getCountTotDr());
    return $oCtrlCB;
  }

  /**
   * Retourne vrai si le fichier passé en paramètre correspond au filtre défini par cette fonction
   *        le filtre consiste à ne garder que les fichiers de type alkhtmlpagesit.tpl
   * @param strFileName Nom du fichier template
   * @return booléen
   */
  private function filterTemplate($strFileName)
  {
    return ( mb_substr($strFileName, -4) == ".tpl" && 
             mb_substr($strFileName, -10) != "_popup.tpl" &&
             mb_substr($strFileName, 0, 11) == "alkhtmlpage" &&
             mb_substr($strFileName, 0, 19) != "alkhtmlpageinternet"
            );
  }

  /**
   * Retourne vrai si le fichier passé en paramètre correspond au filtre défini par cette fonction
   *        le filtre consiste à ne garder que les fichiers de type alkanet*.css
   * @param strFileName Nom du fichier css
   * @return booléen
   */
  private function filterCss($strFileName)
  {
    return ( mb_substr($strFileName, -4) == ".css" && 
             strpos($strFileName, "_IE")=== false &&
             strpos($strFileName, "_print")=== false &&
             mb_substr($strFileName, 0, 7) == "alkanet" );
  }

  /**
   * Retourne vrai si le fichier passé en paramètre correspond au filtre défini par cette fonction
   *        le filtre consiste à ne garder que les fichiers de type alkhtmlpagesit.tpl
   * @param strFileName Nom du fichier template
   * @return booléen
   */
  private function renameTemplate($strFileName)
  {
    $strFileName = mb_substr($strFileName, 11, -4);
    return mb_strtoupper(mb_substr($strFileName, 0, 1)).mb_strtolower(mb_substr($strFileName, 1));
  }
   
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/help/espace_04_conteneur_form.htm"); 
  }
   
}

?>