<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Editeur
Module éditeur basé sur fckeditor.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

include_once ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkappli.class.php";

$iCpt = 0;
define("ALK_LTYPE_ID_FILE", $iCpt++);

/**
 * @package Alkanet_Module_Editeur
 * Module éditeur basé sur fckeditor
 * @Class AlkAppliEditeur
 * Classe de l'application  gestion et réservation des ressources
 */
class AlkAppliEditeur extends AlkAppli implements AlkIntGEdit
{
  /**
   * Constructeur par défaut
   * @param appli_id   Identifiant de l'application
   */
  function  __construct($appli_id)
  {
    parent::__construct(ALK_ATYPE_ID_EDITEUR, $appli_id);
  }
  
   /**
   * Destructeur par défaut
   */
  public function __destruct() { }

  /**
   * Vérifie les droits spécifiques à l'application
   *        Retourne vrai si l'utilisateur connecté possède les droits, faux sinon
   * @return booleen
   */
  public function verifSecuAppli()
  { 
    return true;
  }

  /**
   * Retourne l'objet Panel correspondant au iSheet et iSSheet sélectionné
   * 
   * @param oAppliFrom    AlkAppli   Application appelant cette fonction (principe call services par dérivation)
   * 
   * @return AlkHtmlPanel
   */
  public function getPanel(AlkAppli $oAppliFrom=null)
  {
    switch( $this->iTypeSheet ) {
      case ALK_TYPESHEET_CONSULT:
        switch ( $this->iSheet ) {
          case ALK_SHEET_AJAX :
            switch ( $this->iSSheet ) {
              case ALK_SHEET_FILEMANAGER :  // vérifie si le fichier correspondant à l'URL existe et retourne l'identifiant du lien
                $url = AlkRequest::getToken("url", "");
                $domain = substr(ALK_ALKANET_ROOT_URL, strpos(ALK_ALKANET_ROOT_URL, "://")+3);
                $iPosDomain = strpos($url, $domain);
                if ( $iPosDomain !== false ) {
                  $fichier_path = substr($url, $iPosDomain+strlen($domain));
                } else {
                  $fichier_path = $url;
                }
                $oDsFichier = $this->oQuery->getDsDbFichier(-1, $fichier_path);
                if ( $oDrFichier = $oDsFichier->getRowIter() ) {
                  $fichier_id = $oDrFichier->getValueName("FICHIER_ID");
                  $oAppliLink = AlkFactory::getAppli(ALK_ATYPE_ID_LINK);
                  if ( $oAppliLink ) {
                    echo $oAppliLink->setLink(ALK_ATYPE_ID_EDITEUR, ALK_LTYPE_ID_FILE, null, $fichier_id);
                  }
                }
                exit();
              break;
            }
          break;
        }
      break;
    }
    
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."editeur/classes/alkhtmlformediteurform.class.php");
    $oPanel = new AlkHtmlFormEditeurForm($this);
    
    return $oPanel; 
  }
  
  /**
   * Fonction virtuelle appelée par le constructeur permettant d'initialiser 
   *        le tableau this->tabSheets
   */
  public function setTabSheets() { /** pas d'onglet pour cette appli */ }
  
  /** interface gedit */
  
  /**
   * Méthode appelée à l'ajout d'un bloc gedit
   *        Implémenter les actions effectuant l'ajout de ce bloc sur ce type d'application
   * @param bloc_id     identifiant du bloc
   * @param typeIdBloc  type de bloc 
   * @param atypeIdBloc type de l'application associé au type de bloc
   */
  public function addGEditBloc($bloc_id, $typeIdBloc, $atypeIdBloc) { /** rien à faire */ }
  
  /**
   * Méthode appelée avant suppression définitive d'une application de type gedit
   *        ou avant suppression d'une page gedit
   *        ou avant suppression d'un bloc gedit
   *        Implémenter les actions effectuant le ménage interne à l'application
   * @param page_id     identifiant de la page
   * @param bloc_id     identifiant du bloc
   * @param typeIdBloc  type de bloc 
   * @param atypeIdBloc type de l'application associé au type de bloc
   */
  public function delGEditBloc($page_id, $bloc_id, $typeIdBloc, $atypeIdBloc) { /** rien à faire */ }

  /**
   * Recopie les associations d'un bloc à un autre bloc
   * 
   * @param bloc_id_src  identifiant du bloc source
   * @param bloc_id_dest identifiant du bloc destination
   */
  public function dupGEditBloc($bloc_id_src, $bloc_id_dest) { /** rien à faire */ }

  /**
   * Retourne un tableau contenant l'information sélectionnée par cette méthode (appel régulier de getDataContents())
   * @param typeAff         type d'affichage, permet d'établir une conditionnelle dans cette méthode pour gérer plusieurs type d'affichage
   * @param cont_id         Identifiant de l'espace, pris en compte si appli_id vaut -1
   * @param appli_id        Identifiant de l'application, peut valoir =-1 pour toutes les applis de cont_id
   * @param cat_id          Identifiant de la catégorie, peut valoir =-1 pour toutes les infos de appli_id
   * @param data_id         Identifiant de la données, différent de -1 pour afficher la fiche, =-1 sinon par défaut
   * @param lg              langue utilisé, _FR par défaut
   * @param page_typeassoc  Type d'association des données à la page
   * @param page_ordre      Ordre des données dans la page
   * @param page_datedeb    Contient la date de début pour un filtre éventuel en fonction de la valeur de page_typeassoc
   * @param page_datefin    Contient la date de début pour un filtre éventuel en fonction de la valeur de page_typeassoc 
   * @return array
   */
  public function getGEditDataContents($typeAff, $cont_id, $atype_id, $appli_id, $cat_id, $data_id="-1", $lg="fr", $page_typeassoc=0, $page_ordre="", $page_datedeb="", $page_datefin="")
  {
    return array(); 
  }

  /**
   * Retourne le contenu raccourci d'un bloc éditorial
   * pour un affichage de gestion ou d'aperçu
   * @apram bloc_id        Identifiant du bloc
   * @param bloc_typeassoc type d'association : 0=aucune, 1=appli, 2=cat, 3=data
   *                       si bit 2 on =4 : filtre publication : news uniquement
   *                       si bit 3 on =8 : filtre publication : infos publiés passés (archivés)
   *                       si bit 4 on =16: filtre publication : infos publiés présents
   *                       si bit 5 on =32: filtre publication : infos non publiés
   *                       bit 6 au bit 12 : anciennes versions de tris prédéfinis 
   *                       si bit 13 on : ordre : champ nouveauté
   *                       si bit 14 on : ordre : champ catégorie
   *                       si bit 15 on : ordre : champ data
   *                       si bit 16 on : ordre : champ date pub décroissant
   *                       si bit 17 on : ordre : champ date pub croissant
   *                       si bit 18 on : ordre : champ date info décroissant
   *                       si bit 19 on : ordre : champ date info croissant
   *                       si bit 20 on : ordre : champ date maj décroissant
   *                       si bit 21 on : ordre : champ date maj croissant
   *                       si bit 22 on : filtre calendaire : date début-fin pub 
   *                       si bit 23 on : filtre calendaire : date début-fin info 
   *                       si bit 24 on : filtre calendaire : date début-fin màj
   *                       si bit 25 on : filtre publication : infos synf 
   *                       si bit 26 on : filtre publication : en cours de validation
   *                       si bit 27 on : filtre publication : 30 derniers jours date pub
   *                       si bit 28 on : filtre publication : 30 derniers jours date info
   *                       si bit 29 on : filtre publication : 30 derniers jours date màj
   *                       si bit 30 on : ordre : champ rang des données décroissant
   *                       si bit 31 on : ordre : champ rang des données croissant
   * @param atypeIdBloc    type de l'application liée, =-1 si non utilisé
   * @param bloc_ordre     liste de nombres séparés par une virgule. 1 nombre correspond à une puissance de deux. 
   *                       cette liste correspond à l'ordre des champs d'après les champs de bit de bloc_typeassoc
   * @param bloc_datedeb   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc
   * @param bloc_datefin   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc 
   * @param bloc_limit     contient le nbre de résultats à afficher
   * @return array
   */
  public function getGEditBlocShortContents($bloc_id, $bloc_typeassoc, $atypeIdBloc=-1, $bloc_ordre="", $bloc_datedeb="", $bloc_datefin="", $bloc_limit="-1")
  {
    $contenu_id = "-1";
    $strContenu = "";
    
    $dsContent = $this->oQuery->getContenuByBlocId($bloc_id);
    if( $drContent = $dsContent->getRowIter() ) {
      $contenu_id = $drContent->getValueName("CONTENU_ID");
      $strContenu = $drContent->getValueName("CONTENU_FR");

      $strContenu = mb_ereg_replace("<[bB][rR]>", "sautdeligne", $strContenu);
      $strContenu = mb_ereg_replace("<[^>]*>", "", $strContenu);
      $strContenu = mb_substr($strContenu, 0, 300);
      $strContenu = mb_ereg_replace("sautdeligne", "<br/>", $strContenu);
      if( $strContenu != "" ) {
        $strContenu .= "...";
      }
      
      $strContenu = $this->buildLinks($strContenu);
    }
    
    $tabContent[0]["data_id"]     = $contenu_id;
    $tabContent[0]["data_rank"]   = 0;
    $tabContent[0]["data_title"]  = '';
    $tabContent[0]["data_desc"]   = $strContenu;
    $tabContent[0]["data_type"]   = 0;
    $tabContent[0]["data_visuel"] = '';
    $tabContent[0]["data_url"]    = '';
    $tabContent[0]["data_nbpj"]   = 0;
    
    return $tabContent; 
  }
  
  /**
   * Retourne le contenu complet d'un bloc éditorial dans la langue sélectionnée
   * pour un affichage de consultation
   * @param bloc_id   Identifiant du bloc
   * @param lg        suffixe de la langue sélectionnée =_FR, _UK, etc...
   * @param bloc_typeassoc type d'association : 0=aucune, 1=appli, 2=cat, 3=data
   *                       si bit 2 on =4 : filtre publication : news uniquement
   *                       si bit 3 on =8 : filtre publication : infos publiés passés (archivés)
   *                       si bit 4 on =16: filtre publication : infos publiés présents
   *                       si bit 5 on =32: filtre publication : infos non publiés
   *                       bit 6 au bit 12 : anciennes versions de tris prédéfinis 
   *                       si bit 13 on : ordre : champ nouveauté
   *                       si bit 14 on : ordre : champ catégorie
   *                       si bit 15 on : ordre : champ data
   *                       si bit 16 on : ordre : champ date pub décroissant
   *                       si bit 17 on : ordre : champ date pub croissant
   *                       si bit 18 on : ordre : champ date info décroissant
   *                       si bit 19 on : ordre : champ date info croissant
   *                       si bit 20 on : ordre : champ date maj décroissant
   *                       si bit 21 on : ordre : champ date maj croissant
   *                       si bit 22 on : filtre calendaire : date début-fin pub 
   *                       si bit 23 on : filtre calendaire : date début-fin info 
   *                       si bit 24 on : filtre calendaire : date début-fin màj
   *                       si bit 25 on : filtre publication : infos synf 
   *                       si bit 26 on : filtre publication : en cours de validation
   *                       si bit 27 on : filtre publication : 30 derniers jours date pub
   *                       si bit 28 on : filtre publication : 30 derniers jours date info
   *                       si bit 29 on : filtre publication : 30 derniers jours date màj
   *                       si bit 30 on : ordre : champ rang des données décroissant
   *                       si bit 31 on : ordre : champ rang des données croissant
   * @param atypeIdBloc    type de l'application liée, =-1 si non utilisé
   * @param bloc_ordre     liste de nombres séparés par une virgule. 1 nombre correspond à une puissance de deux. 
   *                       cette liste correspond à l'ordre des champs d'après les champs de bit de bloc_typeassoc
   * @param bloc_datedeb   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc
   * @param bloc_datefin   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc 
   * @param bloc_limit     contient le nbre de résultats à afficher
   * @return array
   */
  public function getGEditBlocContents($bloc_id, $lg, $bloc_typeassoc, $atypeIdBloc=-1, $bloc_ordre="", $bloc_datedeb="", $bloc_datefin="", $bloc_limit="-1")
  {
    $contenu_id = "-1";
    $strContenu = "";
    $tabRes = array();

    $i = 0;
    $dsContent = $this->oQuery->getContenuByBlocId($bloc_id);
    if( $drContent = $dsContent->getRowIter() ) {
      $contenu_id = $drContent->getValueName("CONTENU_ID");
      $strContenu = $drContent->getValueName("CONTENU".$lg);

      $strContenu = mb_ereg_replace("<[bB][rR]>", "sautdeligne", $strContenu);
      $strContenu = mb_ereg_replace("sautdeligne", "<br/>", $strContenu);
      
      $strContenu = $this->buildLinks($strContenu, array("lg" => $lg));
    }
    
    $tabContent[0]["cat_name"]    = "";
    $tabContent[0]["data_id"]     = $contenu_id;
    $tabContent[0]["data_rank"]   = 0;
    $tabContent[0]["data_title"]  = "";
    $tabContent[0]["data_desc"]   = $strContenu;
    $tabContent[0]["data_type"]   = 0;
    $tabContent[0]["data_visuel"] = "";
    $tabContent[0]["data_url"]    = "";
    $tabContent[0]["data_nbpj"]   = 0;    
    
    return $tabContent;
  }
  
  /**
   * Retourne le type de méthode pour mettre à jour les blocs
   *        Retourne un tableau en fonction du type sélectionné.
   * @param typeIdBloc   type de bloc
   * @param atypeIdBloc  type de l'application associée au type de bloc
   * @return array
   */
  public function getGEditBlocTypeUpdate($typeIdBloc, $atypeIdBloc)
  {
    $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_GEDIT, true).$this->cont_id."/"; 
    if( !(@file_exists(ALK_ALKANET_ROOT_PATH.$strPathUpload) && @is_dir(ALK_ALKANET_ROOT_PATH.$strPathUpload)) ) {
      $bRes = @mkdir(ALK_ALKANET_ROOT_PATH.$strPathUpload, 0770);
      if( !$bRes ) {
        $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_GEDIT, true);
      } 
    }
    
    return array("type"          => ALK_GEDIT_TYPEUPDATE_EDITEUR, 
                 "iAssocAType"   => ALK_ATYPE_ID_GEDIT,
                 "tableName"     => "GEDIT_01_CONTENU", 
                 "field_content" => "CONTENU", 
                 "field_pk"      => "CONTENU_ID", 
                 "field_scriptjs"=> "",
                 "xmltag"        => "texte",
                 "useForm"       => "0",   
                 "upload_dir"    => $strPathUpload );
  }
  
  /**
   * Associe une catégorie appartenant à l'application de type atypeIdBloc et d'identifiant appliIdBloc au bloc
   * @param bloc_id     Identifiant du bloc
   * @param cat_id      Identifiant de la catégorie
   * @param atypeIdBloc type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function assocCatToBloc($bloc_id, $cat_id, $atypeIdBloc=-1, $appliIdBloc=-1) { /** rien à faire */ }
  
  /**
   * Associe un ensemble de données appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc au bloc
   * @param bloc_id     Identifiant du bloc
   * @param tabDataId   Tableau contenant les identifiants des données à associer
   * @param atypeIdBloc type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function assocDataToBloc($bloc_id, $tabDataId, $atypeIdBloc=-1, $appliIdBloc=-1) { /** rien à faire */ }
  
  /**
   * Supprime une association entre une catégorie appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc et le bloc
   * @param bloc_id     Identifiant du bloc
   * @param cat_id      Identifiant de la catégorie, =-1 pour supprimer toutes les catégories du bloc
   * @param atypeIdBloc type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function removeCatFromBloc($bloc_id, $cat_id, $atypeIdBloc=-1, $appliIdBloc=-1) { /** rien à faire */ }
  
  /**
   * Supprime une association entre une donnée appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc et le bloc
   * @param bloc_id     Identifiant du bloc
   * @param data_id     Identifiant de la données à associer, =-1 pour supprimer toutes les données du bloc
   * @param atypeIdBloc type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function removeDataFromBloc($bloc_id, $data_id, $atypeIdBloc=-1, $appliIdBloc=-1) { /** rien à faire */ }
  
  /**
   * Met à jour le rang d'une donnée dans un bloc
   * @param bloc_id     Identifiant du bloc
   * @param data_id     Identifiant de la donnée
   * @param iRank       Rang de la donnée courante
   * @param iDelta      Entier : 1 pour descendre d'un rang, -1 pour monter d'un rang
   * @param atypeIdBloc Type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function updateDataRankInBloc($bloc_id, $data_id, $iRank, $iDelta, $atypeIdBloc=-1, $appliIdBloc=-1) { /** rien à faire */ }
  
  /**
   * synchronise la base de données des fichiers
   * @param $dir            chemin du répertoire
   * @param $tabDirExclude  tableau des noms de répertoires à exclure
   * @param $delFichier     supprime les fichiers inexistants
   */
  public function syncDbFichier($dir=null, $tabDirExclude=array("template_c", "cache"), $delFichier=true)
  {
    if ( !$dir ) {
      $dir = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD;
    }
    if ( substr($dir, strlen($dir)-1, 1) == "/" ) {
      $dir = substr($dir, 0, -1);
    }
    if ( is_dir($dir) ) {
      $handle = opendir($dir);
      while ( false !== ($entry = readdir($handle)) ) {
        if ($entry != "." && $entry != "..") {
          if ( is_dir($dir."/".$entry) && !in_array($entry, $tabDirExclude) ) {
            $this->syncDbFichier($dir."/".$entry, $tabDirExclude, false);
          } else if ( is_file($dir."/".$entry) ) {
            $this->oQueryAction->addDbFichier(str_replace(ALK_ALKANET_ROOT_PATH, "", $dir)."/".$entry);
          }
        }
      }
    }
    if ( $delFichier ) {
      $this->oQueryAction->cleanDbFichier();
    }
  }
  
  /**
   * initialise la gestion des liens et construit les associations des liens existants
   */
  public function initLinks($bSimul=false)
  {
    echo "Synchronisation de la base de données avec les fichiers\n";
    if ( !$bSimul ) {
      $this->syncDbFichier();
    }
  }
  
  /**
   * initialise les liens d'un contenu HTML en créant les attributs link_id
   * @param $strContenu contenu HTML
   * @param $tabReplacement   tableau des remplacements à effectuer sur les liens
   * @param $tabPagePubliee   tableau des identifiants des pages publiées indexées par alias
   * @param $bSimul           booléen à true pour simuler, false sinon par défaut
   */
  public function makeLinks($strContenu, $tabReplacement=array(), $tabPagePubliee=array(), $bSimul=false)
  {
    $oAppliLink = AlkFactory::getAppli(ALK_ATYPE_ID_LINK);
    if ( $oAppliLink ) {
      $tabAttr = array('href', 'src');
      foreach ( $tabAttr as $attr ) {
        $matches = array();
        preg_match_all('(<[^<]*?'.$attr.'="([^"]*)"[^>]*?>)', $strContenu, $matches);
        foreach ( $matches[0] as $i => $tag ) {
          if ( strpos($tag, "link_id=") === false ) {
            foreach ( $tabReplacement as $search => $replace ) {
              $link = str_replace($search, $replace, $matches[1][$i]);
            }
            
            $link_id = null;
            
            // cas fichier
            if ( file_exists(ALK_ALKANET_ROOT_PATH.( substr($link, 0, 1) == "/" ? substr($link, 1) : $link )) ) {
              $oDsDbFichier = $this->oQuery->getDsDbFichier(-1, $link);
              if ( $oDrDbFichier = $oDsDbFichier->getRowIter() ) {
                $fichier_id = $oDrDbFichier->getValueName("FICHIER_ID");
                $fichier_path = $oDrDbFichier->getValueName("FICHIER_PATH");
                echo "Création d'un lien vers le fichier fichier_id:".$fichier_id."|fichier_path:".$fichier_path."\n";
                if ( !$bSimul ) {
                  $link_id = $oAppliLink->setLink(ALK_ATYPE_ID_EDITEUR, ALK_LTYPE_ID_FILE, null, $fichier_id);
                }
              }
            }
            
            // cas page
            $link = ( substr($link, 0, 1) == "/" ? "" : "/" ).$link;
            if ( array_key_exists($link, $tabPagePubliee) ) {
              echo "Création d'un lien vers la page page_id:".$tabPagePubliee[$link]."|page_alias:".$link."\n";
              if ( !$bSimul ) {
                $link_id = $oAppliLink->setLink(ALK_ATYPE_ID_EDITEUR, ALK_LTYPE_ID_PAGE, null, $tabPagePubliee[$link]);
              }
            }
            
            if ( $link_id ) {
              $newTag = preg_replace('/(.*'.$attr.'=".*?"[^>]*)(>)/', '$1 link_id="'.$link_id.'"$2', $tag);
              if ( strcmp($tag, $newTag) != 0 ) {
                echo "Remplacement du tag ".$tag." par ".$newTag."\n";
                if ( !$bSimul ) {
                  $strContenu = str_replace($tag, $newTag, $strContenu);
                }
              }
            }
          }
        }
      }
    }
    return $strContenu;
  }
  
  /**
   * retourne un lien vers une ressource
   * @param $ltype_id     identifiant du type de lien
   * @param $data_from_id identifiant d'un objet
   * @param $data_to_id   identifiant de l'objet associé
   * @param $value        valeur de lien optionnelle
   * @param $tabParams    tableau de paramètres supplémentaires
   * @return string lien regénéré
   */
  public function getLink($ltype_id=null, $data_from_id=null, $data_to_id=null, $value=null, $tabParams=array())
  {
    switch ( $ltype_id ) {
      case ALK_LTYPE_ID_FILE :
        $oDsDbFichier = $this->oQuery->getDsDbFichier($data_to_id);
        if ( $oDrDbFichier = $oDsDbFichier->getRowIter() ) {
          return ( !array_key_exists("bWithRootUrl", $tabParams) || $tabParams["bWithRootUrl"] === true ? ALK_ALKANET_ROOT_URL : "/" ).$oDrDbFichier->getValueName("FICHIER_PATH");
        }
      break;
    }
  }
  
  /**
   * construit les liens d'un contenu HTML en se basant sur l'attribut link_id
   * @param $strContenu contenu HTML
   * @param $tabParams  tableau de paramètres supplémentaires
   * @return contenu HTML avec les liens mis à jour
   */
  public function buildLinks($strContenu, $tabParams=array())
  {
    $oAppliLink = AlkFactory::getAppli(ALK_ATYPE_ID_LINK);
    if ( $oAppliLink ) {
      $matches = array();
      preg_match_all('(<[^<]*?link_id="(\d*)"[^>]*?>)', $strContenu, $matches);
      
      foreach ( $matches[0] as $i => $tag ) {
        $strLink = $oAppliLink->getLink($matches[1][$i], null, $tabParams);
        if ( $strLink ) {
          $tabAttr = array('href', 'src');
          foreach ( $tabAttr as $attr ) {
            $newTag = preg_replace('/(.*'.$attr.'=").*?(".*)/', '$1'.$strLink.'$2', $tag);
            if ( strcmp($tag, $newTag) != 0 ) {
              $strContenu = str_replace($tag, $newTag, $strContenu);
            }
          }
        }
      }

    }
    return $strContenu;
  }
}
?>