<?php

/*licence/

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Crbn_cat
Module Crbn_cat.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkzip.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/lib/app_conf_crbn_cat.php");
/**
 * @class AlkHtmlFormConsultCrbn_catList
 * @brief Description de la classe
 */
class AlkHtmlFormConsultCrbn_catList extends AlkHtmlForm
{

	protected $strParam;
	/**
	 * Constructeur
	 * @param oAppli    Application appelante
	 */
	public function __construct(AlkAppli &$oAppli)
	{
		parent::__construct($oAppli, "formCrbn_catList");
		$this->setProperties(3, ALK_FORM_METHOD_POST );
		//echo "mode".
		$this->iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_READ);
		$this->cssForm = ""; // pour annuler le css

		//echo "user".$
		$this->user_id = AlkFactory::getSProperty("user_id", ALK_USER_ID_INTERNET);
		
		
		$this->tabCorrespStatut = array(); // cf. en relation avec la req sql getDsEtude et le champ name_statut
		$this->tabCorrespStatut[0] = "Etude en cours";
		$this->tabCorrespStatut[1] = "Etude publiée";
		$this->tabCorrespStatut[2] = "Etude archivée";

	}

	/**
	 *  Abstract : Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
	 */
	protected function setData($iTypeInit) { /** rien à faire **/ }

	/**
	 * Appel des actions SQL sur les données du formulaire
	 */
	public function doSql() {
		 
		$this->setData(ALK_INIT_MODE_REQUEST);
		switch( $this->iMode ) {
			case 4 :  // changement de theme

				$theme_id  = AlkRequest::getToken("theme_id", AlkRequest::_REQUESTint("theme_id", -1));
				$tabSSth = array(array("-1", "Sélectionnez un sous-thème"));
				$oDsSSTheme = $this->oAppli->oQuery->getDsByTableName("sous_thematiques ".($theme_id != -1 ?  "WHERE thematique_id = ".$theme_id : "")." ORDER BY sous_thematique_intitule ASC" , false);
				while ( $oDrSSTheme = $oDsSSTheme->getRowIter() ) {
					$tabSSth[] = array($oDrSSTheme->getValueName("sous_thematique_id"), $oDrSSTheme->getValueName("sous_thematique_intitule"));
				}
				 
				$array["data_com"] = $tabSSth;
				echo json_encode($array);
				exit;
				break;
				 
			case 5 :  // lancement ajax de la recherche
			  
				$_SESSION["search_commune_id"] = $search_commune_id = AlkRequest::_REQUEST("search_commune_id", "");
				$_SESSION["theme_id"] = $theme_id = AlkRequest::_REQUEST("tabTheme", "-1");
				$_SESSION["sous_theme_id"] = $sous_theme_id = AlkRequest::_REQUEST("tabSSTheme", "-1");
				$_SESSION["mot_cles"] = $mot_cles = AlkRequest::_REQUEST("mot_cles", "");
				$_SESSION["mode_id"] = $mode_id = AlkRequest::_REQUEST("tabMode", "-1");
				$_SESSION["mes_etudes"] = $mes_etudes = AlkRequest::_REQUEST("mes_etudes", "");
				$_SESSION["numero_fiche"] = $numero_fiche = AlkRequest::_REQUEST("numero_fiche", "");
				$_SESSION["masquer_etudes"] = AlkRequest::_REQUEST("masquer_etudes", "");
				$_SESSION["motsrecherche"]  = AlkRequest::_REQUEST("motsrecherche", "");
				exit;
				break;

			case 6 :  // Export csv

				$this->getDsFromSession();
				$this->ExportCsv();
				exit;

				break;

			case 7 :  // Export Zip

				$this->getDsFromSession();
				$this->ExportZip();
				exit;

				break;
				
			case 8 : // export XML
				$etude_id = AlkRequest::getToken("id", "-1");
				$strExtension = "xml";
        $etude_file = $this->oAppli->ExportXml($etude_id);
        AffHeaderFileDownload($etude_file, "fiche_".$etude_id.".".$strExtension, 0, "application/xml");
        readfile($etude_file) ;
        
        exit;

        break;
        
      case 9 : // export ZIP des documents
        $etude_id = AlkRequest::getToken("id", "-1");
        $this->CompteurConsult($etude_id, "etude_nb_telechargement");

        $dsData = $this->oAppli->oQuery->getDsDataById($etude_id);
        $tabData = array();
        while($drData = $dsData->getRowIter()){
        	$tabData[$drData->getValueName("pj_name")] = AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT).$this->oAppli->cont_id. "/".$drData->getValueName("pj_file");
        }
        if(!empty($tabData)){
	        if (count($tabData)==1){
	        	foreach($tabData as $real_name => $file){
				      $strExtension = GetTypeMime($file);
				      if(file_exists($file)){
				        AffHeaderFileDownload($file, $real_name);
				        readfile($file);
				      }else{
				      	echo "<script language='javascript'>alert(\"le document associé à l'étude n'est pas présent sur le serveur.\")</script>";
				      }
	        	}
		      }else{
		      	$this->ExportEtude($tabData);
		      }
        }else{
        	echo "<script language='javascript'>alert(\"Aucun document n'est associé à l'étude.\")</script>";
        }
        exit;
        break;  
		}
	}

	/**
	 * Définition du contenu affiché du formulaire
	 */
	protected function setContents()
	{

		$this->addSheetRecherche();
	}

	private function addSheetRecherche() {

		$oSheetRecherche = $this;
		$iSelectWidth = "";
		$iWidthSelect = "";
		$widthTxt = "";
		$nbRows = 1;

		if(file_exists( ALK_ALKANET_ROOT_PATH.ALK_ROOT_TEMPLATE."alkhtmlformrechercheform.tpl")){
			$oSheetRecherche->setTemplate(ALK_ROOT_TEMPLATE, "alkhtmlformrechercheform.tpl");
		}else{
			$oSheetRecherche->setTemplate("crbn_cat", "alkhtmlformrechercheform.tpl");
		}
		$this->addScriptJs(ALK_ALKANET_ROOT_URL."scripts/crbn_cat/lib/alkhtmlformadmincrbn_catform.js");
		$this->addScriptJs(ALK_ALKANET_ROOT_URL."scripts/crbn_cat/lib/alkhtmlformconsultcrbn_catform.js");
		// construction de la liste deroulante pour l'autocomplétion
		$oSearchCom = AlkHtmlFactory::getNewHtmlText(null, 0,"search_commune_id", (isset($_SESSION["search_commune_id"])? $_SESSION["search_commune_id"] : ""), "Nom de la Commune", 1, $widthTxt);
		$oDsCommune = $this->oAppli->oQuery->getDsByTableName('"'.config_table_com.'"' , true, " where ".config_id_reg."='25' "." ORDER BY ".config_nom_coml." ASC");
		$strCom="";
		while ($oDrCommune = $oDsCommune->getRowIter()){
			$strCom.= "\"".trim($oDrCommune->getValueName(config_nom_coml))." (".trim($oDrCommune->getValueName(config_id_com)).")"."\",";
		}
		$strCom = substr($strCom, 0, -1);
		$this->addJs("var tabCommune = [".$strCom."]");

		//$this->addJs("var tokenSearchCommune = '".$this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=4")."';");

    $oSheetRecherche->assign("bError", AlkRequest::getToken("bError", AlkRequest::_REQUESTint("bError", 0)));
    
		$oSheetRecherche->assign("oSearchCom", $oSearchCom->getHtml());
		$oDsTheme = $this->oAppli->oQuery->getDsByTableName("thematique ORDER BY thematique_intitule ASC" , false);

		$theme = AlkHtmlFactory::getNewHtmlSelect(null, 0,"theme_id", (isset($_SESSION["theme_id"]) ? $_SESSION["theme_id"] : -1), "Thèmes", 1, $iSelectWidth);
		$theme->setProperty("oValTxt", $oDsTheme);
		$theme->setProperty("strFieldValue", "thematique_id");
		$theme->setProperty("strFieldText", "thematique_intitule");
		$theme->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un thème"));
		$strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=4");
		$theme->AddEvent("onChange", "ChangeThemeSearch('".$strToken."')");
		$oSheetRecherche->assign("otheme", $theme->getHtml());
		 
		$oDsSSTheme = $this->oAppli->oQuery->getDsByTableName("sous_thematiques ORDER BY sous_thematique_intitule ASC" , false);
		$oSStheme = AlkHtmlFactory::getNewHtmlSelect(null, 0,"sous_thematique_id", (isset($_SESSION["sous_theme_id"])? $_SESSION["sous_theme_id"] : "-1"), "Sous-thématiques", 1, $iSelectWidth);
		$oSStheme->setProperty("oValTxt", $oDsSSTheme);
		//$oSStheme->setProperty("bMultiple", true);
		$oSStheme->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un sous-thème"));
		$oSStheme->setProperty("strFieldValue", "sous_thematique_id");
		$oSStheme->setProperty("strFieldText", "sous_thematique_intitule");

		$oSheetRecherche->assign("oSstheme", $oSStheme->getHtml());

		// construction du bloc mots cles
		$oKeyWords = AlkHtmlFactory::getNewHtmlText(null, 0, "mots_cles", (isset($_SESSION["mot_cles"])? $_SESSION["mot_cles"] : ""), "Mot(s) clé(s)", 1, $widthTxt);
		$oSheetRecherche->assign("oKeyWords", $oKeyWords->getHtml());
    
		//masquer les etude region
		$oCBMasque = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "masquer_etudes", (isset($_SESSION["masquer_etudes"])? $_SESSION["masquer_etudes"] : ""), "Masquer les études à caractère régional", 1, $widthTxt);
		$oSheetRecherche->assign("oMasquer_etudes", $oCBMasque->getHtml());

		if($this->user_id!=ALK_USER_ID_INTERNET){
		  $oCB = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "mes_etudes",  (isset($_SESSION["mes_etudes"])? $_SESSION["mes_etudes"] : ""), "Mes études", 1, $widthTxt);
      $oSheetRecherche->assign("oMesEtudes", $oCB->getHtml());
		}

		//Bouton de validation du formulaire
		$strTokenAjaxSearch = (ALK_ALKANET_SQL."?token=".$this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RECHERCHE, ALK_SHEET_NONE, "&iMode=5"));
		$this->addVarJs("strTokenAjaxSearch", "'".$strTokenAjaxSearch."'");
		$oButtonRecherche		= AlkHtmlFactory::getHtmlButtonForm("javascript:sqlSearch('".$strTokenAjaxSearch."')", "LANCER LA RECHERCHE", "");
		//$oButtonRecherche->addEvent("onClick", "sqlSearch('".$strTokenAjaxSearch."')");
		//$oButtonRecherche->setButtonType("submit");
		$oButtonRecherche->setCssLink("submit");
//		$oSheetRecherche->assign("oActionSubmit", "javascript:sqlSearch('".$strTokenAjaxSearch."')");
    $oSheetRecherche->assign("oButtonRecherche", $oButtonRecherche->getHtml());
		$strTokenCsvExport = ALK_ALKANET_SQL."?token=".$this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RECHERCHE, ALK_SHEET_NONE, "&iMode=6");
		$oSheetRecherche->assign("oActionExportCsv", "javascript:Export('".$strTokenCsvExport."')");
		$strTokenZipExport = ALK_ALKANET_SQL."?token=".$this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RECHERCHE, ALK_SHEET_NONE, "&iMode=7");
		$oSheetRecherche->assign("oActionExportZip", "javascript:Export('".$strTokenZipExport."')");
		
		if($this->user_id!=ALK_USER_ID_INTERNET){
			$strTokenNewSheet = ALK_ALKANET_ROOT_URL."accueil?id=-1&iMode=".ALK_FORM_MODE_UPDATE;
	    $oSheetRecherche->assign("oActionCreerFiche", $strTokenNewSheet);
	    $strTokenImportPopup = ALK_ALKANET."?token=".$this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_IMPORTEXPORT, ALK_SHEET_NONE);
      $oSheetRecherche->assign("oActionImport","javascript:OpenWindow('".$strTokenImportPopup."', '360', '550', 'windImport');"); 
		}
		// mode de recherche

		//$oDsEPCI = $this->oAppli->oQuery->getDataFromTable(couche_epci." ORDER BY ".couche_epci_champ_nom_epci." ASC" , true);
		$oModeRecherche = AlkHtmlFactory::getNewHtmlSelect(null, 0,"moderecherche", -1, "Mode de recherche", $nbRows, $iSelectWidth);
		$oModeRecherche->setProperty("tabValTxtDefault", array("-1", "Tous les mots"));
		$tabValTxt = array("0"  => "N'importe quel mot",
                       "1"    => "Phrase exacte");
		$oModeRecherche->setProperty("tabValTxt", $tabValTxt);
		$oSheetRecherche->assign("moderecherche", $oModeRecherche->getHtml());
    
		$oMotsrecherche = AlkHtmlFactory::getNewHtmlSelect(null, 0,"motsrecherche", -1, "Mode de recherche des mots", $nbRows, $iSelectWidth);
		$oMotsrecherche->setProperty("tabValTxtDefault", array("-1", "Mot complet"));
		$tabValTxt = array("0"  => "Début de mot",
				"1"    => "Fin de mot");
		$oMotsrecherche->setProperty("tabValTxt", $tabValTxt);
		$oSheetRecherche->assign("motsrecherche", $oMotsrecherche->getHtml());
		
		
		if($this->user_id!=ALK_USER_ID_INTERNET){
			$oNumeroFiche = AlkHtmlFactory::getNewHtmlText(null, 0, "numero_fiche", "", "Numéro de fiche", 1, $widthTxt);
	    $oSheetRecherche->assign("oNumeroFiche", $oNumeroFiche->getHtml());
		}
		
		
		// construction du ds pour la liste d'études
		$dsNbEtude = $this->oAppli->oQuery->getDsByTableName("etude " , false, ($this->user_id!=ALK_USER_ID_INTERNET ? "" : " where etude_statut = 1"));
		$nbElt = $dsNbEtude->getCountTotDr();
		 
		$oSheetRecherche->assign("oButtonExportCsv", "");
		
		$oSheetRecherche->assign("oListAjax", $this->getListAjax());
	
		/*$_SESSION["search_commune_id"] = null;
		$_SESSION["theme_id"] = null;
		$_SESSION["sous_theme_id"] = null;
		$_SESSION["mot_cles"] = null;
		$_SESSION["mode_id"] = null;
		$_SESSION["mes_etudes"] = null;
		$_SESSION["numero_fiche"] = null;
		$_SESSION["masquer_etudes"]=null;*/

		$oSheetRecherche->assign("oNbEtudes", $nbElt);

		// si pas authenti filtre sur le statut
		$strWhereStatut = "";
		if($this->user_id == ALK_USER_ID_INTERNET){// mode authentifie filtre sur les archives ou pas
		  $strWhereStatut.= " WHERE etude_statut = 1 " ;
		}
		
		// 4  dernière fiches mise en ligne

		$dsNbEtude = $this->oAppli->oQuery->getDsLastEtude($strWhereStatut);
		$i=0;

		while ($drNbEtude = $dsNbEtude->getRowIter()){
			$etude_intitule           = $drNbEtude->getValueName("etude_intitule");
			$etude_date_maj           = $drNbEtude->getValueName("etude_date_maj");
			$strTokenLink = ALK_ALKANET_ROOT_URL."accueil?id=".$drNbEtude->getValueName("etude_id"); 
			//$this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&etude_id=".$drNbEtude->getValueName("etude_id"));
			$oLinkIntitule            = AlkHtmlFactory::getHtmlButton($strTokenLink,
			$etude_intitule."<span class='lien'> &gt; voir la fiche</span>", _f("Accéder à l'étude %s", $etude_intitule));


			$oSheetRecherche->assign("oFiche".$i, $oLinkIntitule->getHtml());
			$i++;
		}

		// 4  fiches les plus visites

		$dsNbEtude = $this->oAppli->oQuery->getDsEtudeMostVisited($strWhereStatut);
		$j=0;
		while ($drNbEtude = $dsNbEtude->getRowIter()){
			$etude_intitule           = $drNbEtude->getValueName("etude_intitule");
			$etude_nb_consult           = $drNbEtude->getValueName("etude_nb_consult");
			$strTokenLink = ALK_ALKANET_ROOT_URL."accueil?id=".$drNbEtude->getValueName("etude_id");
			$strTokenLink =  //$this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&etude_id=".$drNbEtude->getValueName("etude_id"));
			$oLinkIntitule            = AlkHtmlFactory::getHtmlButton($strTokenLink,
			$etude_intitule."<span class='lien'> &gt; voir la fiche</span>", _f("Accéder à l'étude %s", $etude_intitule));

			$oSheetRecherche->assign("oFicheVisited".$j, $oLinkIntitule->getHtml());
			$j++;
		}
	}
	
	private function getListAjax(){
	  // dans le cas d'une recherche avec les communes 
	  $search_commune_id = isset($_SESSION["search_commune_id"]) ? $_SESSION["search_commune_id"] : null;
	  if($search_commune_id !=null){
	    $tabSearch_commune_id = explode("(", $search_commune_id);
	    $search_commune_id = substr($tabSearch_commune_id[1], 0, -1);
	    $dsGeomCommune = $this->oAppli->oQuery->getDsGeomByCode($search_commune_id);
	    if ($drGeomCommune = $dsGeomCommune->getRowIter()){
	      $_SESSION["strGeomCommune"]= $strGeomCommune = $drGeomCommune->getValueName("geom");
	    }
	  }
	  /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
	  AlkFactory::setSQLParamsName();
	  
	  $_SESSION["sEcho"]= AlkFactory::getSQLParamsName("sEcho", (isset($_SESSION["sEcho"]) ? $_SESSION["sEcho"] : ""));
	  $iNbEltParPage = AlkFactory::getSQLParamsName("iDisplayLength", 10);
	  
    $page = (isset($_SESSION["sEcho"]) ? $_SESSION["sEcho"] : 1) ; //ALKRequest::_GETint("page", 1);
    


		$this->getDsFromSession($page, $iNbEltParPage);
		$nbElt = $this->dsEtude->getCountTotDr();
		//$iNbEltParPage = $nbElt; //ALKRequest::_GETint("nbItemsPerPage", ALK_ITEMS_PER_PAGE);
		
		$output = array();
		
		
		/** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
		$output = array(
        "sEcho" => $page,
        "iTotalRecords" => $nbElt,
        "iTotalDisplayRecords" => $nbElt,
        "aaData" => array()
		);
		
		
		AlkFactory::emptySQLParamsName();
		$strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=5");

		$strUrlPagine = $_SERVER["PHP_SELF"]."?token=".$strToken;

		$oTabPage = AlkHtmlFactory::getHtmlListJQuery($this, $nbElt, true, $strUrlPagine);
		if($this->user_id != ALK_USER_ID_INTERNET){
  		$oTabPage->SetColumns(array("left",   "45%", "etude_intitule"),
	  	array("center", "8%",  "service_intitule_court", false),
		  array("center", "8%",  "etude_date_maj"),
		  array("center", "8%",  "etude_annee_achevement", false),
		  array("center", "8%",  "etude_nb_telechargement"),
		  array("center", "8%",  "etude_nb_consult"), 
  		array("center", "8%",  "name_statut", false),  		    
		  array("center", "10%", "action", false, false),
		  array("center", "1%", "geom", false, false));
  		$oTabPage->addTitleRow(_t("Titre"), _t("Commanditaire"), _t("Date de mise en ligne"), _t("Année de publication"), _t("Nb téléchargement"), _t("Nb consultation"), _t("Statut"),"","");
  		$oTabPage->addRightRow(1,1,1,1,1,1,1,1,0);
		}else{
		  $oTabPage->SetColumns(array("left",   "45%", "etude_intitule"),
		      array("center", "8%",  "service_intitule_court", false),
		      array("center", "8%",  "etude_date_maj"),
		      array("center", "8%",  "etude_annee_achevement", false),
		      array("center", "8%",  "etude_nb_telechargement"),
		      array("center", "8%",  "etude_nb_consult"),
		      array("center", "10%", "action", false, false),
		      array("center", "1%", "geom", false, false));
		  $oTabPage->addTitleRow(_t("Titre"), _t("Commanditaire"), _t("Date de mise en ligne"), _t("Année de publication"), _t("Nb téléchargement"), _t("Nb consultation"),"","");
		  $oTabPage->addRightRow(1,1,1,1,1,1,1,0);
		}

// 		//$oTabPage->addRightRow(1,1,1,1,1,1,1,0);
		$oTabPage->setProperty("cssList", "display dataTable");
		
		
		$oTabPage->setFilter(true);
		$oTabPage->setModeAjax(true);
		
		$this->addVarJs("config_wms", "'".config_wms."'");
		$this->addVarJs("config_layer_wms", "'".config_layer_wms."'");
		// Lecture des données
		/** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
		$iMode = AlkRequest::getToken("iMode");
		if ($iMode==5){
			$this->readData(true, $page, $iNbEltParPage, $oTabPage, $output);
		}
		// construction des liste de filtres
		// commandiataires
		$strListCommanditaires="";
		$dsEtudeCom = $this->oAppli->oQuery->getDsListCommanditaire();
		while($drEtudeCom = $dsEtudeCom->getRowIter()){
		  $strListCommanditaires.= "'".$drEtudeCom->getValueName("service_intitule_court")."',";
		}
		if($strListCommanditaires!=""){
		  $strListCommanditaires = substr($strListCommanditaires, 0, -1);
		}
		
		// annee publi 
		$strListAnnee="";
		$dsEtudeAnnee = $this->oAppli->oQuery->getDsListAnneePubli();
		while($drEtudeAnnee = $dsEtudeAnnee->getRowIter()){
		  $strListAnnee.= "'".$drEtudeAnnee->getValueName("etude_annee_achevement")."',";
		}
		if($strListAnnee!=""){
		  $strListAnnee = substr($strListAnnee, 0, -1);
		}
		
		$bStatut = false;
		if($this->user_id != ALK_USER_ID_INTERNET){
		// statut
		  $bStatut = true;
  		$strListStatut="";
  		foreach($this->tabCorrespStatut as $k => $val){
  
  		  $strListStatut.= "'".$val."',";
  		}
  		if($strListStatut!=""){
  		  $strListStatut = substr($strListStatut, 0, -1);
  		}
		}
		
		
		
		$oTabPage->setFunctionJs("oTable.columnFilter(
		    {sPlaceHolder: 'head:before', 
		     aoColumns: [ 
             null,
			      ".($strListCommanditaires!="" ? "{ type: 'select', values: [ ".$strListCommanditaires." ]}," : "null,")." 
				     null,
				     ".($strListAnnee!="" ? "{ type: 'select', values: [ ".$strListAnnee." ]}," : "null,")." 
             null,
		         null 
		          ".($bStatut ? ($strListStatut!="" ? ", { type: 'select', values: [ ".$strListStatut." ]}," : ", null") : ", null")."
		    
		          ]
		        }	    
		    );");
		
		$this->addJs("jQuery(document).ready( function () {
		    var datatable = $('#tabPagine').dataTable();
		    $(datatable).bind( 'draw', setHoverAction );
	    });
		");
				
		return $oTabPage->getHtml();
	}

	private function getDsFromSession($page=0, $iNbEltParPage=-1){
		 
		$search_commune_id = isset($_SESSION["search_commune_id"]) ? $_SESSION["search_commune_id"] : null;
		$theme_id = isset($_SESSION["theme_id"]) ? $_SESSION["theme_id"] : null;
		$sous_theme_id = isset($_SESSION["sous_theme_id"]) ? $_SESSION["sous_theme_id"] : null;
		$mot_cles = isset($_SESSION["mot_cles"]) ? $_SESSION["mot_cles"] : null;
		$mode_id = isset($_SESSION["mode_id"]) ? $_SESSION["mode_id"] : null;
		$motsrecherche = isset($_SESSION["motsrecherche"]) ? $_SESSION["motsrecherche"] : null;
		$mes_etudes = isset($_SESSION["mes_etudes"]) ? $_SESSION["mes_etudes"] : null;
		$numero_fiche = isset($_SESSION["numero_fiche"]) ? $_SESSION["numero_fiche"] : null;
		$masque_etude_regional = isset($_SESSION["masquer_etudes"]) ? $_SESSION["masquer_etudes"] : null; 
		$strGeomCommune = isset($_SESSION["strGeomCommune"]) ? $_SESSION["strGeomCommune"] : null; 		
		$dbConn = AlkFactory::getDbConn();

		// construction du ds pour la liste d'études repete car maj dynamique
		if ( !$search_commune_id && !$theme_id && !$sous_theme_id && !$mot_cles && !$mode_id && !$mes_etudes && !$numero_fiche && !$masque_etude_regional && !$motsrecherche) {// si aucun champ rempli dans le formulaire
			//$this->dsEtude = $dsEtude = $this->oAppli->oQuery->getDsEtude("", "", "");		  
		  $strWhere = "";
		  if($this->user_id == ALK_USER_ID_INTERNET){// mode authentifie filtre sur les archives ou pas
		    $strWhere.= " WHERE etude_statut = 1 " ;
		  }
		  $this->dsEtude = $dsEtude = $this->oAppli->oQuery->getDsEtude( "", $strWhere, $dbConn->getGroupConcat("service_intitule_court", "','", "", false, "from sit_service ssc where ssc.service_id in (select service_id from etude_commanditaires where etude_id=e.etude_id)")." as service_intitule_court, etude_url ");
		} else {
			$strWhere = "";
			$strTableJoin ="";
			if($search_commune_id != "" && !is_null($strGeomCommune)){
				$strWhere.=" etude_perimetre_principal_geom && st_geomfromtext('".$strGeomCommune."', 2154) 
				           and (ST_within(st_geomfromtext('".$strGeomCommune."', 2154), etude_perimetre_principal_geom) or st_geomfromtext('".$strGeomCommune."', 2154) = etude_perimetre_principal_geom)";		
			}
			if($theme_id != -1 || $sous_theme_id != -1){
				$strTableJoin.= " LEFT JOIN etude_thematique et on e.etude_id = et.etude_id";
				$strWhereTh = "";
				// recherche sur le theme
				if($theme_id != -1){
					$strWhereTh.= ($strWhereTh!="" ? " AND " : "")." et.thematique_id=".$theme_id." AND et.etude_thematique_type=1 ";
				}
				// recherche sur le ss theme
				if($sous_theme_id != -1){
					$strWhereTh.= ($strWhereTh!="" ? " AND " : "")." et.sous_thematique_id=".$sous_theme_id." AND et.etude_thematique_type=1 ";
				}
				$strWhere.= ($strWhere!=""? " AND ".$strWhereTh : $strWhereTh);
			}
			// recherche sur le mot cle
			/*if($mot_cles != ""){
				$strWhereMode="";
				// recherche sur le mode
				if($mode_id == -1){// tous les mots
					$str_mots_cles = "";
					$tabmot = explode(" ", $mot_cles);
					foreach($tabmot as $key => $mot){
						$str_mots_cles.=" unaccent_string(etude_xml)  ILIKE '%".$this->unaccent_string($mot)."%' AND";
					}
					$str_mots_cles = substr($str_mots_cles, 0, -3);
				}elseif($mode_id==0){// n'importe quel mot
					$str_mots_cles = "";
					$tabmot = explode(" ", $mot_cles);
					foreach($tabmot as $key => $mot){
						$str_mots_cles.=" unaccent_string(etude_xml)  ILIKE '%".$this->unaccent_string($mot)."%' OR";
					}
					$str_mots_cles = substr($str_mots_cles, 0, -2);
				}elseif($mode_id==1){// phrase exacte
					$str_mots_cles = "";
					$str_mots_cles.=" unaccent_string(etude_xml)  ILIKE '%".$this->unaccent_string($mot_cles)."%'";
				}
				$strWhere.=($strWhere!="" ? " AND  (".$str_mots_cles.")" :  " ".$str_mots_cles);
			}*/
			
			if($mot_cles!=""){
				$oMnogo = AlkFactory::getMnogoSearch();
				
				if($mode_id == -1){// tous les mots
					$oMnogo->set(UDM_PARAM_SEARCH_MODE,UDM_MODE_ALL);
				}elseif($mode_id==0){// n'importe quel mot
					$oMnogo->set(UDM_PARAM_SEARCH_MODE,UDM_MODE_ANY);
				}elseif($mode_id==1){// phrase exacte
					$oMnogo->set(UDM_PARAM_SEARCH_MODE,UDM_MODE_PHRASE);
				} 
				if($motsrecherche==-1){
					$oMnogo->set(UDM_PARAM_WORD_MATCH,  UDM_MATCH_WORD);
				}elseif($mode_id==0){// début de mot
					$oMnogo->set(UDM_PARAM_WORD_MATCH, UDM_MATCH_BEGIN);
				}elseif($mode_id==1){// fin de mot
					$oMnogo->set(UDM_PARAM_WORD_MATCH, UDM_MATCH_END);
				} 
					
				$oMnogo->set_agent_param_ex("StripAccents", 1);
				
				$bMnogoSearch = $oMnogo->find($mot_cles, 0, 1000);
				
				if($bMnogoSearch && $oMnogo->matches){
					$strLimitId = " e.etude_id in (";
					foreach($oMnogo->matches as $key => $value){
						$tabInfo = explode("/", $value["url"]);
						$etude_id = substr($tabInfo[count($tabInfo)-1], 6, $tabInfo[count($tabInfo)-1]-3);
						$strLimitId .=	(is_numeric($etude_id) ? $etude_id.", " : "");
					}
					$strWhere.= ($strWhere!="" ? " and".substr($strLimitId,0,-2).")" : substr($strLimitId,0,-2).")");
				}else{
					$strWhere.= ($strWhere!="" ? " AND 1=0 " : " 1=0 " );
				}
				
			}
			
			if($mes_etudes == 1){
				$strWhere.= ($strWhere!="" ? " AND etude_agent_id=".$this->user_id : "etude_agent_id=".$this->user_id );  
			}
			
			if($masque_etude_regional ==1){
			  $strWhere.= ($strWhere!="" ? " AND etude_b_region=0 " : " etude_b_region=0 " );
			}
			
			if($this->user_id == ALK_USER_ID_INTERNET){// mode authentifie filtre sur les archives ou pas
			  $strWhere.= ($strWhere!="" ? " AND etude_statut = 1 " : "etude_statut =1 ");
			}
			
		  if(intval($numero_fiche) !=""){
        $strWhere.= ($strWhere!="" ? " AND e.etude_id=".$numero_fiche: "e.etude_id=".$numero_fiche );  
      }

			if($strWhere!=""){
				$strWhere =" WHERE ".$strWhere;
			}
			//$this->dsEtude = $dsEtude = $this->oAppli->oQuery->getDsEtude($strTableJoin, $strWhere, "");
      $iFirst = ($page-1)*$iNbEltParPage;
      $iLast =   $page*$iNbEltParPage -1;
			$this->dsEtude = $dsEtude = $this->oAppli->oQuery->getDsEtude($strTableJoin, $strWhere, $dbConn->getGroupConcat("service_intitule_court", "','", "", false, "from sit_service ssc where ssc.service_id in (select service_id from etude_commanditaires where etude_id=e.etude_id)")." as service_intitule_court, etude_url", $iFirst, $iLast);
		}
	}


	private function readData($bModeAjax=false, $page, $iNbEltParPage, &$oList, &$output){

	  $user_priv = AlkFactory::getSProperty("user_priv", "0");
		$nbElt = $this->dsEtude->getCountTotDr();
		//$appli_id_defaut = $this->oAppli->getAppliProperty("CONT_APPLI_DEFAUT", "0");
		$cont_id = $this->oAppli->cont_id;
		$_SESSION["list_etude"]= array();
		while( $drEtude = $this->dsEtude->getRowIter() ) {

			$etude_intitule           = $drEtude->getValueName("etude_intitule");		
			$service_intitule_court         = $drEtude->getValueName("service_intitule_court");
			if(strlen($service_intitule_court)>42 ){
			  $service_intitule_court = substr($service_intitule_court, 0, 42)." etc..";
			}
			$etude_date_maj           = date("d/m/Y",strtotime($drEtude->getValueName("etude_date_maj")));// transfo timestamp
			//$etude_date_publication   = date("YYYY",strtotime( $drEtude->getValueName("etude_date_publication")));
			$etude_date_publication   = $drEtude->getValueName("etude_annee_achevement");
			$etude_nb_telechargement  = $drEtude->getValueName("etude_nb_telechargement");
			$etude_nb_consult         = $drEtude->getValueName("etude_nb_consult");
			$etude_id                 = $drEtude->getValueName("etude_id");
      $etude_agent_id           = $drEtude->getValueName("etude_agent_id");
      $etude_statut             = $drEtude->getValueName("name_statut");      
      $etude_url                = $drEtude->getValueName("etude_url");
      $_SESSION["list_etude"][]=$etude_id;
			$etude_perimetre_principal_geom = $drEtude->getValueName("etude_perimetre_principal_geom");
      $strTokenLink = ALK_ALKANET_ROOT_URL."accueil?id=".$etude_id;
			//$strTokenLink = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&etude_id=".$etude_id);
			$oLinkIntitule  = AlkHtmlFactory::getHtmlButton($strTokenLink,
			$etude_intitule, _f("Accéder à l'étude %s", $etude_intitule));

			$oTelecharger1 = "&nbsp;";

			$strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=5");

		  $strTokenEtudeExport = ALK_ALKANET_SQL."?token=".$this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RECHERCHE, ALK_SHEET_NONE, "&iMode=9&id=".$etude_id);
			$oTelecharger1 = AlkHtmlFactory::getHtmlButtonImg("javascript:Export('".$strTokenEtudeExport."')",
          "icon_telecharger.gif", "Télécharger l'étude", 22 , 22);

			$strTokenXmlExport = ALK_ALKANET_SQL."?token=".$this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RECHERCHE, ALK_SHEET_NONE, "&iMode=8&id=".$etude_id);
			$oTelecharger2 = AlkHtmlFactory::getHtmlButtonImg("javascript:Export('".$strTokenXmlExport."')",
          "icon_telecharger_meta.gif", "Télécharger la métadonnée de la fiche étude au format XML", 22 , 22);
      
			$o3bt = $oTelecharger1->getHtml()." ".$oTelecharger2->getHtml()." ";
		  
			$dsData = $this->oAppli->oQuery->getDsDataById($etude_id);
      $tabData = array();
      while($drData = $dsData->getRowIter()){
        if($drData->getValueName("pj_champ") == "data_pj_pdf"){
          //$tabData[] = AlkFactory::getUploadUrl(ALK_ATYPE_ID_CRBN_CAT).$drData->getValueName("pj_agentcrea"). "/".$drData->getValueName("pj_file");
          $tabData[] = AlkFactory::getUploadUrl(ALK_ATYPE_ID_CRBN_CAT).$this->oAppli->cont_id. "/".$drData->getValueName("pj_file");
        }
      }
      if($etude_url!="" && $etude_url!="NULL"){
        $etude_url = explode("#", $etude_url);
        $tabData = array_merge($tabData, $etude_url);
      } 
      if (empty($tabData)){
      	$oConsult = AlkHtmlFactory::getHtmlButtonImg("javascript:alert('Aucun document n'est attaché à l\'étude')",
          "icon_consulter.gif", "Consulter l'étude en ligne", 22 , 22);
        $o3bt.=$oConsult->getHtml();
      }elseif(count($tabData)==1){
        $oConsult = AlkHtmlFactory::getHtmlButtonImg("javascript:void window.open('".$tabData[0]."')",
          "icon_consulter.gif", "Consulter l'étude en ligne", 22 , 22);
        $o3bt.=$oConsult->getHtml();
      }else{// sinon verifier si une url etude est donnée
        //url etude
        $oConsult = AlkHtmlFactory::getHtmlButtonImg("javascript:alert('Plus d\'un document est attaché à l\'étude, merci de consulter la fiche pour voir la liste.')",
          "icon_consulter.gif", "Consulter l'étude en ligne", 22 , 22);
        $o3bt.=$oConsult->getHtml();
      }
      
		  if($this->user_id == $etude_agent_id || (AlkFactory::isSpaceAnimAll() && AlkFactory::isAnnuAdminAll())){
        $oModifier = AlkHtmlFactory::getHtmlButtonImg(ALK_ALKANET_ROOT_URL."accueil?id=".$etude_id."&iMode=".ALK_FORM_MODE_UPDATE,"icon_modifier.gif", "Modifier l'étude en ligne", 22 , 22);
        //$oSupprimer = AlkHtmlFactory::getHtmlButtonImg(ALK_ALKANET_SQL."?token=".$this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&iMode=".ALK_FORM_MODE_DEL."&id=".$etude_id),"icon_supprimer.gif", "Supprimer l'étude", 22 , 22);
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&iMode=".ALK_FORM_MODE_DEL."&id=".$etude_id);
        $oSupprimer = AlkHtmlFactory::getHtmlButtonImg("javascript:DeleteData('".$strToken."', 'Veuillez confirmer la suppression de cette étude ?')", "icon_supprimer.gif", "Supprimer l\'étude", 22 , 22);
        $o3bt.=" ".$oModifier->getHtml(). " ".$oSupprimer->getHtml();
      }

      
			if ($bModeAjax){
			  if($this->user_id != ALK_USER_ID_INTERNET){
			    //$strStatut = $this->tabCorrespStatut[$etude_statut];
			    $strStatut = $etude_statut;			    
			    $output["aaData"][] = array($oLinkIntitule->getHtml(), $service_intitule_court, $etude_date_maj, $etude_date_publication, $etude_nb_telechargement, $etude_nb_consult, 	$strStatut, $o3bt, $etude_perimetre_principal_geom);
			  }else{
			    $output["aaData"][] = array($oLinkIntitule->getHtml(), $service_intitule_court, $etude_date_maj, $etude_date_publication, $etude_nb_telechargement, $etude_nb_consult,$o3bt,$etude_perimetre_principal_geom);
			  }
			}else{
			  if($this->user_id != ALK_USER_ID_INTERNET){			  
			    //$strStatut = $this->tabCorrespStatut[$etude_statut];
			    $strStatut = $etude_statut;
			    $oList->addRowByArray(array($oLinkIntitule->getHtml(), $service_intitule_court, $etude_date_maj, $etude_date_publication, $etude_nb_telechargement, $etude_nb_consult, $strStatut, $o3bt, $etude_perimetre_principal_geom));
			  }else{
			    $oList->addRowByArray(array($oLinkIntitule->getHtml(), $service_intitule_court, $etude_date_maj, $etude_date_publication, $etude_nb_telechargement, $etude_nb_consult, $o3bt,$etude_perimetre_principal_geom));
			  }
			}
		}
		if ( $bModeAjax) {
			echo json_encode( $output );
			exit();
		}
	}

	/**
	 *  function d'exportation de la liste des résultats
	 */
	private function ExportCsv()
	{
		$ag_id = $this->user_id;
		$strExtension = "csv";
		$urlFileExport = $this->oAppli->getProperty("strUrlUpload").$ag_id."_exp.".$strExtension;
		$strFileExport = $this->oAppli->getProperty("strPathUpload").$ag_id."_exp.".$strExtension;

		// HTTP headers
		AffHeaderFileDownload("", $ag_id."_exp.".$strExtension, 0, "text/plain");

		// Destruction de l'export precedent
		if( file_exists($strFileExport) && is_file($strFileExport) ) {
			@unlink($strFileExport);
		}
		$strSep = ";";
		$strRetLigne = "\r\n";

		$tabReference = array("Titre", "Commanditaire", "Date de mise en ligne", "Date de publication", mb_convert_encoding("Nb téléchargement", ALK_EXPORT_ENCODING, ALK_HTML_ENCODING), "Nb consultation");

		for ($k=0; $k<count($tabReference); $k++) {
			echo $tabReference[$k].$strSep;
		}

		echo $strRetLigne;


		$cpt = 0;
		while( $drEtude = $this->dsEtude->getRowIter() ) {
			 
			$etude_intitule = mb_convert_encoding($drEtude->getValueName("etude_intitule"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
			$service_intitule_court = mb_convert_encoding($drEtude->getValueName("service_intitule_court"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
			$etude_date_maj = mb_convert_encoding($drEtude->getValueName("etude_date_maj"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
			$etude_date_publication = mb_convert_encoding($drEtude->getValueName("etude_date_publication"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
			$etude_nb_telechargement = mb_convert_encoding($drEtude->getValueName("etude_nb_telechargement"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
			$etude_nb_consult = mb_convert_encoding($drEtude->getValueName("etude_nb_consult"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);

			echo $etude_intitule.$strSep.$service_intitule_court.$strSep.$etude_date_maj.$strSep.$etude_date_publication.$strSep.
			$etude_nb_telechargement.$strSep.$etude_nb_consult;

			echo $strRetLigne;
		}
		//Redirection du fichier vers l'utilisateur
		if( file_exists($strFileExport) ) {
			readfile($strFileExport) ;
		}
	}

	/**
	 *  function d'exportation des résulats en archive de fiches XML
	 */
	private function ExportZip()
	{
		$ag_id = $this->user_id;
    $strExtension = "zip";
    $strFileExport = $this->oAppli->getProperty("strPathUpload").$ag_id."_Export_Fiches.".$strExtension;
		
    $oZip = new AlkZipFile($strFileExport);
		while( $drEtude = $this->dsEtude->getRowIter() ) {
			$etude_id = $drEtude->getValueName("etude_id");
			//Traitement du fichier XML d'étude
			$etude_file = $this->oAppli->ExportXml($etude_id);
			if ($etude_file){
				$oZip->addFile($etude_file, "fiche_".$etude_id.".xml");
      }
		}
		$oZip->close();
		AffHeaderFileDownload($strFileExport, $ag_id."_Export_Fiches.".$strExtension);
    readfile($strFileExport);
	}
	
  /**
   *  function d'exportation des études
   */
  private function ExportEtude($tabData)
  {
  	$ag_id = $this->user_id;
    $strExtension = "zip";
    $strFileExport = $this->oAppli->getProperty("strPathUpload").$ag_id."_Export_Etudes.".$strExtension;
    
    $oZip = new AlkZipFile($strFileExport);
    foreach($tabData as $real_name => $file){
      if(file_exists($file))
    	 $oZip->addFile($file,$real_name);
    }
    $oZip->close();
    AffHeaderFileDownload($strFileExport, $ag_id."_Export_Etudes.".$strExtension);
    readfile($strFileExport);
  }



  /**
   * incrémanete le nb de consult en fonction de l'etude_id
   * @etude_id
   * @$strFieldEtude : le champ appartenant à etude qui est à incrémaneter
   * @return string
   */
	public function CompteurConsult($etude_id, $strFieldEtude){
	  // compteur nb consult pour une etude id
	  

	  
	  $oDsDataEtude = $this->oAppli->oQuery->getDsByTableName(" etude".
	      " where etude_id =".$etude_id );
	  if($oDrDataEtude = $oDsDataEtude->getRowIter()){
	    $nbConsult = $oDrDataEtude->getValueName($strFieldEtude);
	  }
	  $this->oAppli->oQueryAction->updateNbConsult($etude_id, $nbConsult+1, $strFieldEtude);
	}
  /**
   * suppression des accents
   * @param $str
   * @return unknown_type
   */
  public function unaccent_string($str){
	  $tabChar = array("éèêëäàâüùûîïôöç", "eeeeaaauuuiiooc");
	  for($i=0; $i<mb_strlen($tabChar[0]); $i++) {
	    $str = mb_ereg_replace(mb_substr($tabChar[0], $i, 1), mb_substr($tabChar[1], $i, 1), $str);
	  }
	  return $str;
  }


	/**
	 * Retourne l'aide associée au formulaire
	 * @return string
	 */
	public function getHelp()
	{
		return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/help/crbn_cat_01_consult_list.htm");
	}
}
?>