<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANTE_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkimport.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkImportAnnuCourriel
 * 
 * Classe d'import des services pour l'annuaire
 */
class AlkImportAnnuCourriel extends AlkImport
{
	
	
	/**
   *  Constructeur de la classe Import : initialisation des attributs de Import.
   *
   * @param strFichier_Import Emplacement  du fichier d'import
   * @param tabImport  Tableau contenant les proprietés des  colonnes
   * @param tabSup  Tableau contenant les colonnes obligatoires pour la suppression
   * @param tabAjoutt  Tableau contenant les colonnes obligatoires pour l'ajouts
   * @param objErreur  Nom de l'objet  ImportErreur
   */
	function AlkImportAnnuCourriel($strFichier_Import,  $tabAlkImportCol, $tabSup, $tabAjout, 
                         $tabModif, &$obj_Erreur,&$objWarning, &$oQuery, &$oQueryAction, &$oSpace )
	{
		parent::__construct($strFichier_Import,  $tabAlkImportCol, $tabSup, $tabAjout, 
                      $tabModif, $obj_Erreur,$objWarning, $oQuery, $oQueryAction, $oSpace );
	}
	
  /**
   *  Fonction qui rend un tableaux de champs valeurs.
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return tabChampsData  un tableau de champs valeurs
   */
	function getChampsData($tabLigne, $tabCopy, $tabLigneRef, $bUpdate=false)
	{
		$tabChampsData = array();
    
    $tabChampsData = array("AGENT_NOM"     => "", "AGENT_PRENOM" => "", "LOGIN" => "", "COURRIEL_1"  => "",
                             "COURRIEL_2" => "", "COURRIEL_3" => "", "PUBLICATION_1"  => "-1", "PUBLICATION_2" => "-1",
                             "PUBLICATION_3" => "-1");
		
    //Compléter la ligne par des champs vides si elle n'a pas le nbre de colonnes que la ligne de reference
    if (count($tabLigne) < count($tabLigneRef)){
      for ($j=count($tabLigne); $j<count($tabLigneRef); $j++)
        $tabLigne[$j] = "";
    }
    
    if (in_array("NOM", $tabLigneRef) && ($tabLigne[$tabCopy["NOM"]] != "")) 
    $tabChampsData["AGENT_NOM"] = $tabLigne[$tabCopy["NOM"]];
           
    if (in_array("PRENOM",$tabLigneRef) && ($tabLigne[$tabCopy["PRENOM"]] != "")) 
    $tabChampsData["AGENT_PRENOM"] = $tabLigne[$tabCopy["PRENOM"]];
    
    if (in_array("LOGIN",$tabLigneRef) && ($tabLigne[$tabCopy["LOGIN"]] != "")) 
    $tabChampsData["LOGIN"] = $tabLigne[$tabCopy["LOGIN"]];
    
    if (in_array("COURRIEL_1",$tabLigneRef) && ($tabLigne[$tabCopy["COURRIEL_1"]] != "")) 
    $tabChampsData["COURRIEL_1"] = $tabLigne[$tabCopy["COURRIEL_1"]];
    
    if (in_array("COURRIEL_2",$tabLigneRef) && ($tabLigne[$tabCopy["COURRIEL_2"]] != "")) 
    $tabChampsData["COURRIEL_2"] = $tabLigne[$tabCopy["COURRIEL_2"]];
    
    if (in_array("COURRIEL_3",$tabLigneRef) && ($tabLigne[$tabCopy["COURRIEL_3"]] != "")) 
    $tabChampsData["COURRIEL_3"] = $tabLigne[$tabCopy["COURRIEL_3"]];

    if (in_array("PUBLICATION_1",$tabLigneRef) && ($tabLigne[$tabCopy["PUBLICATION_1"]] != "")) 
    $tabChampsData["PUBLICATION_1"] = $tabLigne[$tabCopy["PUBLICATION_1"]];
    
    if (in_array("PUBLICATION_2",$tabLigneRef) && ($tabLigne[$tabCopy["PUBLICATION_2"]] != "")) 
    $tabChampsData["PUBLICATION_2"] = $tabLigne[$tabCopy["PUBLICATION_2"]];
    
    if (in_array("PUBLICATION_3",$tabLigneRef) && ($tabLigne[$tabCopy["PUBLICATION_3"]] != "")) 
    $tabChampsData["PUBLICATION_3"] = $tabLigne[$tabCopy["PUBLICATION_3"]];
    
		return 	$tabChampsData;
	}
	
  /**
   *  Fonction insertion de la ligne courante .
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return vrai si ibsertion faux sinon
   */
	function insert($tabLigne, $tabCopy, $tabLigneRef, $t)
	{
		
	}
  
  /**
   *  Integre le fichier d'import
   *
   * @param intSeparateur  caractere séparateur du fichier
   * @return Retourne un entier : 0 si aucune erreur, >0 sinon
   */
  function integrate($intSeparateur) 
  {
    $iTotRes = 0;
    $tabCopy = array();
    $fImport = fopen($this->strFichier_Import, "r");
    $i = 2;
  
    if( $fImport ) {
      // lecture de la premiere ligne
      $intTailleFichier = filesize($this->strFichier_Import);
      $tabLigneRef = fgetcsv($fImport, $intTailleFichier, chr($intSeparateur));
      for ($j=0; $j<count($tabLigneRef); $j++) {
        $tabCopy[$tabLigneRef[$j]] = $j;
      }

      while( !feof($fImport) ) {
        $oRes = 0;
        $tabLigne = fgetcsv($fImport, $intTailleFichier, chr($intSeparateur));
        if( $tabLigne == NULL ) {
          // on ignore les lignes vides
        } else {
            $oRes = $this->update($tabLigne, $tabCopy, $tabLigneRef,$i);  
        }
        $iTotRes += $oRes;
        $i++;
      }
    }
    return $iTotRes;
  }
	/**
   *  Fonction de modification de la ligne courante dans la base .
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return vrai si ibsertion faux sinon
   */
	function update($tabLigne, $tabCopy, $tabLigneRef,$t)
	{
		$tabChamps = $this->getchampsData($tabLigne, $tabCopy, $tabLigneRef);
    if (! isset($tabChamps["LOGIN"]) || $tabChamps["LOGIN"]== ""){
    	$strMes = "Erreur : Ligne ".$t.", impossible de modifier le(s) courriel(s). Login inexistant. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2; 
    }

    $dsAgent = $this->oQuery->getAgentIdByLogin($tabChamps["LOGIN"]);
    if( $dsAgent->iCountTotDr != 1 ) {
      $strMes = "Erreur : Ligne ".$t.", impossible de modifier le(s) courriel(s). Login inconnu. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;      
    }        
    if ($drAgent = $dsAgent->getRowIter()){
    	$agent_id = $drAgent->getValueName("AGENT_ID");
    }
		
    if (! isset($tabChamps["COURRIEL_1"]) || $tabChamps["COURRIEL_1"]== "" ||
        strpos($tabChamps["COURRIEL_1"], "@")== false || strpos($tabChamps["COURRIEL_1"], ".")== false){
      $strMes = "Erreur : Ligne ".$t.", impossible de modifier le(s) courriel(s). Courriel 1 inexistant ou erroné. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2; 
    }
    
    $coor_publication = 4;
    
    if (!isset($tabChamps["PUBLICATION_1"]) || !array_keys(array(1,2,4,7) ,$tabChamps["PUBLICATION_1"]) ){
    	$strMes = "Warning : Ligne ".$t.", La publication n'est pas précisée ou est non valide. Le courriel 1 sera diffusé à l'ensemble ". S_DSIT.".";
      $this->obj_Warning->erreur(7, $strMes);
    }else{
    	$coor_publication = $tabChamps["PUBLICATION_1"];
    }
    
    $this->oQueryAction->del_coordonneeTelecom("-1", $agent_id, 4);
  
    $this->oQueryAction->add_coordonneeTelecom($agent_id, 4, $tabChamps["COURRIEL_1"],
                                                "", $coor_publication);
                                 
  	if (isset($tabChamps["COURRIEL_2"]) && $tabChamps["COURRIEL_2"]!= ""){
      
      if (strpos($tabChamps["COURRIEL_2"], "@")== false || strpos($tabChamps["COURRIEL_2"], ".")== false){
      	$strMes = "Erreur : Ligne ".$t.", impossible de modifier le(s) courriel(s). Courriel 2 erroné. Ligne rejetée.";
        $this->obj_Erreur->erreur(7, $strMes);
      return 2;
      }
      
      $coor_publication = 4;
      if (!isset($tabChamps["PUBLICATION_2"]) || !array_keys(array(1,2,4,7) ,$tabChamps["PUBLICATION_2"]) ){
        $strMes = "Warning : Ligne ".$t.", La publication n'est pas précisée ou est non valide. Le courriel 2 sera diffusé à l'ensemble ". S_DSIT.".";
        $this->obj_Warning->erreur(7, $strMes);
      }else{
        $coor_publication = $tabChamps["PUBLICATION_1"];
      }
      $this->oQueryAction->add_coordonneeTelecom($agent_id, 4, $tabChamps["COURRIEL_2"],
                                 "", $coor_publication);
                                 
    }
      
    if (isset($tabChamps["COURRIEL_3"]) && $tabChamps["COURRIEL_3"]!= ""){
      
      if (strpos($tabChamps["COURRIEL_3"], "@")== false || strpos($tabChamps["COURRIEL_3"], ".")== false){
       $strMes = "Erreur : Ligne ".$t.", impossible de modifier le(s) courriel(s). Courriel 3 erroné. Ligne rejetée.";
       $this->obj_Erreur->erreur(7, $strMes);
       return 2;
      }
      $coor_publication = 4;
      if (!isset($tabChamps["PUBLICATION_3"]) || !array_keys(array(1,2,4,7) ,$tabChamps["PUBLICATION_3"]) ){
        $strMes = "Warning : Ligne ".$t.", La publication n'est pas précisée ou est non valide. Le courriel 3 sera diffusé à l'ensemble ". S_DSIT.".";
        $this->obj_Warning->erreur(7, $strMes);
      }else{
        $coor_publication = $tabChamps["PUBLICATION_1"];
      }
      $this->oQueryAction->add_coordonneeTelecom($agent_id, 4, $tabChamps["COURRIEL_3"],
                                 "", $coor_publication);  
    }
		return 0;
	}
	
	/**
   *  Fonction de suppresion de la ligne courante dans la base .
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return vrai si insertion faux sinon
   */
	function delete($tabLigne, $tabCopy, $tabLigneRef,$t)
	{
		
	}
	
	/**
   *  retourne la reference d'un champ..
   *
   * @param  champ  l'intitule du champs
   * @param  tabType tableau contenant le champs 
   * @return tabRes[0] la reference recherche dans la tabType et celle de la premiere case.
   */
	function getIdChamp($champ,$tabType)
	{
		$tabRes = array_keys($tabType, $champ);
    if( count($tabRes) > 0 ) 
      return $tabRes[0];
    return -1;
	}
	
}

?>
