<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlPopUpServiceFiche
 * 
 * Classe de gestion des services de l'Annuaire
 */
class AlkHtmlPopUpServiceFiche extends AlkHtmlForm
{
  /**
   *  Constructeur par défaut
   * @param oAppli Référence sur l'appli associée
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "popupServiceFiche", "Fiche service"); 
    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_READ);
    $strAction = "";
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);    
  } 
   
   /**
   *  Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { }
  
  /**
   *  Traitement du formulaire
   */
  public function doSql() { }  
  
  /**
   *  Retourne le titre de la poup
   * @return string
   */
  public function getTitle()
  {
    return _t("Fiche service");
  }

  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $user_id     = AlkFactory::getSProperty("user_id", "-1");
    $user_priv   = AlkFactory::getSProperty("user_priv", "0");
    $userServ_id = AlkFactory::getSProperty("service_id", "-1");
    $this->addScriptCss("../".ALK_ROOT_MODULE."annu/templates/annu.css");
    $iUpdate  = AlkRequest::_GETint("u", "1");

    $service_id = AlkRequest::getToken("sid", AlkRequest::_GETint("sid", "-1"));
    $bUpdate = false;
    
    // infos sur le service
    $dsServ = $this->oAppli->oQuery->getDs_ficheService($service_id);
    if( !($drServ = $dsServ->getRowIter()) ) {
      $this->addOnload("windowClose()");
      return;
    } else {
      $service_intitule       = $drServ->getValueName("SERVICE_INTITULE");
      $service_intitule_court = $drServ->getValueName("SERVICE_INTITULE_COURT");
      $service_adresse        = $drServ->getValueName("SERVICE_ADRESSE");
      $service_tel            = $drServ->getValueName("SERVICE_TEL");
      $service_fax            = $drServ->getValueName("SERVICE_FAX");
      $service_email          = $drServ->getValueName("SERVICE_EMAIL");
      $service_web            = $drServ->getValueName("SERVICE_WEB");
      $service_etat           = $drServ->getValueName("SERVICE_ETAT");
      $service_logo			  = $drServ->getValueName("SERVICE_LOGO");
      $agent_nomprenom_resp   = $drServ->getValueName("RESPONSABLE");
      $agent_id_resp          = $drServ->getValueName("AGENT_ID");
      
      $servicePere_id = $drServ->getValueName("SERVICE_PERE");
      $service_niveau = $drServ->getValueName("SERVICE_NIVEAU");
      $service_racine = $drServ->getValueName("SERVICE_RACINE");
    
      $servicePere_intitule = "";
      $dsServ = $this->oAppli->oQuery->getDs_ficheService($servicePere_id);
      if( $drServ = $dsServ->getRowIter() )
        $servicePere_intitule = $drServ->getValueName("SERVICE_INTITULE");

      $bUpdate = ( $iUpdate==1  && ( AlkFactory::isAnnuAdminAll() ||
                   AlkFactory::isAnnuAdminServ() && $service_racine==$userServ_id) );
    }
    
    /** identité */
    $strHtml = '<ul class="userIdent">'.
      '<li class="ident">'.$service_intitule.
      ( $service_intitule_court != "" 
        ? ' ('.$service_intitule_court.')' 
        : "" ).
      '</li>'.
      ( $service_adresse != "" 
        ? '<li class="adr">'.$service_adresse.'</li>' 
        : "" ).
      '<li class="tel">'.( $service_tel!="" 
                         ? $service_tel 
                         : 'n.c.' ).  
      ( $service_fax    != "" 
        ? '<span class="fax"> '._t("Fax").' : </span>'.$service_fax 
        : "" ).
      '</li>'.
      ( $service_email != "" 
        ? '<li class="mail"><a title="'._f("envoyer un mail au service %s", $service_intitule).'" href="mailto:'.$service_email.'">'.$service_email.'</a></li>' 
        : "" ).
      ( $service_web != "" 
        ? '<li class="site"><a title="'._f("accéder site web du service %s", $service_intitule_court).
          '" href="'.$service_web.'">'.$service_web.'</a></li>'
        : "" ).
      ( $agent_id_resp != "" 
        ? '<li><span class="fax">'._t("Responsable").' : </span>'.
          '<a title="'._f("voir la fiche du responsable de service %s", $agent_nomprenom_resp).
          '" href="javascript:OpenPopupFiche(\'agent\', '.$agent_id_resp.')">'.
          $agent_nomprenom_resp.'</a></li>'
        : "" );
    $strHtml .= '</ul>'; 

    $strHtml .= $this->getHtmlListeAdminService($service_racine);
    $strHtmlServ = $this->getHtmlArboService($service_id, $service_intitule, $service_niveau, 
                                             $servicePere_id, $servicePere_intitule);

    $urlUpload = AlkFactory::getUploadUrl(ALK_ATYPE_ID_ANNU);
    $strHtmlLogo = "";
    if( $service_logo != "" ){
      $strHtmlLogo = "<img src='".$urlUpload.$service_logo."' height='100' width='150' alt='Logo du service'/>";
    }
    $oCtrlIdent = AlkHtmlFactory::getHtml($strHtml, "", "ctrlIdent");
    $oCtrlServ  = AlkHtmlFactory::getHtml($strHtmlServ);
    $oCtrlLogo	= AlkHtmlFactory::getHtml($strHtmlLogo);
   
    $oBlockIdent = $this->addBlock("blockIdent", "", "", "5", "435");
    $oBlockIdent->addCtrl($oCtrlIdent, ALK_HTMLFORM_1L1C);
    $oBlockIdent->addCtrl($oCtrlLogo);
    
    $oBlockServ = $this->addBlock("blockServ", "Arborescence", "", "5", "435", true);
    $oBlockServ->addCtrl($oCtrlServ, ALK_HTMLFORM_1L1C);
    
    /** Elements spécifiques aux applications de l'espace */
    $oSpace = $this->oAppli->getProperty("oSpace", null);
    
    if ( !is_null($oSpace) && (defined("ALK_B_ATYPE_ACL") && ALK_B_ATYPE_ACL==true))
      $oSpace->callService($this->oAppli->atype_id, "getHtmlAnnuServiceForm", $this, $this, $service_id);
    

    if( $bUpdate ) {
      $strToken = ALK_ALKANET."?token=".$this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_SERVICE, ALK_SHEET_FORM, 
                                          "&iMode=".ALK_FORM_MODE_UPDATE."&service_id=".$service_id);
      $oBtUpdt = $this->addButtonPage("btUpdate", "javascript:closeAllWindow('".$strToken."')", _t("Modifier"), _t("Modifier la fiche"));
    }
  }
  
  /**
   *  Retourne le code html de la liste des adminstrateurs
   * @param service_id  identifiant du service de niveau 1 correspondant au service courant
   * @return string
   */
  private function getHtmlListeAdminService($service_racine)
  {
    $strHtml = "";
    $dsAgent = $this->oAppli->oQuery->getDs_listeAdminService($service_racine);
    while( $drAgent = $dsAgent->getRowIter() ){
      $agent_id       = $drAgent->getValueName("AGENT_ID");
      $agent_civilite = $drAgent->getValueName("AGENT_CIVILITE");
      $agent_nom      = $drAgent->getValueName("AGENT_NOM");
      $agent_prenom   = $drAgent->getValueName("AGENT_PRENOM");
      
      $strHtml .= '<a title="voir la fiche de '.trim($agent_civilite." ".strtoupper($agent_nom)." ".$agent_prenom).
                  '" href="javascript:OpenPopupFiche(\'agent\', '.$agent_id.')">'.
                  trim($agent_civilite." ".strtoupper($agent_nom)." ".$agent_prenom).'</a><br/>';
    }
    if( $strHtml != "" ) {
      $strHtml = mb_substr($strHtml, 0, -5);
      $strHtml = "<ul class='adminserv'><li class='adminserv'>".$strHtml."</li></ul>";
    }
    return $strHtml;
  }
    
  /**
   *  Définition du contenu du service (arborescence)
   */    
  private function getHtmlArboService($service_id, $service_intitule, $service_niv, $idServPere, $strServPere)
  {
    $user_id     = AlkFactory::getSProperty("user_id", "-1");
    $user_priv   = AlkFactory::getSProperty("user_priv", "0");
    $userServ_id = AlkFactory::getSProperty("service_id", "-1");
    
    $strHtml = '<ul class="userIdent serv">';

    if( $strServPere != "" ) {
      // service parent
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_SERVICE, ALK_SHEET_NONE, "&sid=".$idServPere);    
      $strHtml .= '<li><a title="Afficher la fiche du service parent" href="'.ALK_ALKANET.'?token='.$strToken.'">'.
                  $strServPere.'</a></li><ul class="level">';
    }

    // service courant
    $strHtml .= '<li class="level bold">'.$service_intitule.'</li>';

    $dsServ = $this->oAppli->oQuery->GetDs_listeService($user_priv, $userServ_id, $service_niv, $service_id);
    if( $dsServ->getCountTotDr() > 0 ) {
      // sous services
      $strHtml .= "<ul class='level'>";
      while( $drServ = $dsServ->getRowIter() ) {
        $nbFils = $drServ->getValueName("NB_FILS");
        $idServ = $drServ->getValueName("SERVICE_ID");
        $strServ = $drServ->getValueName("SERVICE_INTITULE");
  
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_SERVICE, ALK_SHEET_NONE, "&sid=".$idServ);    
        $strHtml .= '<li><a href="'.ALK_ALKANET.'?token='.$strToken.'"'.
                    ' title="Afficher la fiche du sous service">'.$strServ.'</a></li>';
      }
      $strHtml .= '</ul>';
    }
    $strHtml .= '</ul>'.( $strServPere != "" ? '</ul>' : "" );
      
    return $strHtml;
  }

}   
?>
