<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlPopUpUserFiche
 * 
 * Classe de gestion des user de l' Annuaire'
 */
class AlkHtmlPopUpAbonneFiche extends AlkHtmlForm
{
  protected $oTargetAppli;
  protected $iTypeSheetOpener;
  
  /**
   * Constructeur par défaut
   * @param oAppli        Référence sur l'appli associée
   * @param oTargetAppli  Référence sur l'appli demandant cette fenêtre
   */
  public function __construct(AlkAppli $oAppli, $oTargetAppli, $iTypeSheetOpener=ALK_TYPESHEET_CONSULT)
  {
    parent::__construct($oAppli, "popupAbonneFiche", "Fiche d'un abonné"); 
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
    
    $this->oTargetAppli = $oTargetAppli;
    $this->iTypeSheetOpener = $iTypeSheetOpener;   
  } 
   
  /**
   *  Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit){ }
  
  /**
   *  Traitement du formulaire
   */
  public function doSql() { }  
  
  /**
   *  Retourne le titre de la poup
   * @return string
   */
  public function getTitle()
  {
    return _t("Fiche d'un abonné");
  }

  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $abonne_id = AlkRequest::_GETint("aid", "-1");
    $iUpdate  = AlkRequest::_GETint("u", "1");
    $this->addScriptCss("../".ALK_ROOT_MODULE."annu/templates/annu.css");

    $dsAbonne = $this->oAppli->oQuery->getDsAbonne($abonne_id);
    if( !($drAbonne = $dsAbonne->getRowIter()) ) {
      $this->addOnload("windowClose()");
      return;
    }

    //info sur l'abonné
    $abonne_nom      = $drAbonne->getValueName("ABONNE_NOM");
    $abonne_prenom   = $drAbonne->getValueName("ABONNE_PRENOM");
    $abonne_pseudo   = $drAbonne->getValueName("ABONNE_PSEUDO");
    $abonne_adr      = $drAbonne->getValueName("ABONNE_ADRESSE");
    $abonne_post     = $drAbonne->getValueName("ABONNE_CP");
    $abonne_ville    = $drAbonne->getValueName("ABONNE_VILLE");
    $abonne_pays     = $drAbonne->getValueName("ABONNE_PAYS");
    $abonne_mail     = $drAbonne->getValueName("ABONNE_MAIL");
    $abonne_tel      = $drAbonne->getValueName("ABONNE_TEL");
    $abonne_valide       = $drAbonne->getValueName("ABONNE_VALIDE");
    $abonne_date_insc    = $drAbonne->getValueName("ABONNE_DATE_INSCR");
    $abonne_date_desinsc = $drAbonne->getValueName("ABONNE_DATE_DESINSCR");
    $abonne_desc         = $drAbonne->getValueName("ABONNE_DESC");
    
    $bUpdate = ( $iUpdate==1  && (AlkFactory::isAnnuAdminAll() || AlkFactory::isSpaceAnim() || AlkFactory::isSpaceAnimAll() ));
    
    $bAdr = ( trim($abonne_adr.$abonne_post.$abonne_ville.$abonne_pays) != "" );
    
    /** identité */
    $strHtml = '<ul class="userIdent">'.
      '<li class="ident">'.trim($abonne_prenom.' '.$abonne_nom.( $bUpdate ? ' ( id : '.$abonne_id.')' : '' ) ).'</li>'.
      ( $abonne_valide == "0" 
        ? ( $abonne_date_desinsc == ""
            ? '<li class="info">'._t("Abonné en attente de validation").'</li>' 
            : '<li class="info">'._t("Abonné désactivé le")." ".$abonne_date_desinsc.'</li>' )
        : '<li class="info">'._t("Abonné depuis le")." ".$abonne_date_insc.'</li>' ).
      ( $abonne_pseudo != "" ? '<li class="pseudo">'.$abonne_pseudo.'</li>' : '' ).
      ( $bAdr
        ? '<li class="adr">'.
          ( $abonne_adr != "" ? $abonne_adr.'<br/>' : '' ).
          trim($abonne_post.' '.$abonne_ville.( $abonne_pays!="" ? ' ('.$abonne_pays.')' : '' )).
          '</li>'
        : '' ).
       ($abonne_desc != "" 
         ? '<li class="desc" title="'._t("description").'">'.$abonne_desc.'</li>'
         : "").
      '<li class="mail"><a title="'._t("envoyer un mail à l'abonné").'" href="mailto:'.$abonne_mail.'">'.$abonne_mail.'</a></li>'.
      ( $abonne_tel!=""
        ? '<li class="tel">'.$abonne_tel.'</li>'
        : '' );

    $strHtml .= '</ul>'; 

    $oCtrlIdent   = AlkHtmlFactory::getHtml($strHtml, "", "ctrlIdent");
    
    $oBlockIdent = $this->addBlock("blockIdent", "", "", "5", "435");
    $oBlockIdent->addCtrl($oCtrlIdent);
    
    if( $bUpdate ) {
      $strToken = $this->oTargetAppli->getToken($this->iTypeSheetOpener, ALK_SHEET_ABONNEFORM, ALK_SHEET_NONE, 
                                                "&iMode=".ALK_FORM_MODE_UPDATE."&abonne_id=".$abonne_id);
      $oBtUpdt = $this->addButtonPage("btUpdate", "javascript:closeAllWindow('".$strToken."')", _t("Modifier"), _t("Modifier la fiche"));
    }
    $oBtUpdt = $this->addButtonPage("btClose", "javascript:closeWindow()", _t("Fermer"), _t("Fermer la fenêtre"));
  }
    
}

?>