<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlFormOForm
 * 
 * Classe de l'organigramme de l'Annuaire
 */
class AlkHtmlFormOrganigForm extends AlkHtmlForm 
{

  /**
   *  construct
   */  
  public function __construct(AlkAppli $oAppli)
  {   
    parent::__construct($oAppli, "formOrganigForm"); 
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
  }

  /**
   *  Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   * @param iTypeInit   type de récupération
   */
  protected function setData($iTypeInit) { }
  
  /**
   *  Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  {
    $idServSrc  = AlkRequest::_GETint("folderSrc_id",  "-1");
    $idServDest = AlkRequest::_GETint("folderDest_id", "-1");
    $idAgent    = AlkRequest::_GETint("doc_id",        "-1");

    // Supprime l'ancienne pour ajouter les services successifs jusqu'à atteindre idServDest
    $this->oAppli->oQueryAction->updateFiliation($idAgent, $idServSrc, $idServDest);

    return "";
  }  
  
  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $service_id  = AlkRequest::_GETint("service_id", "-1");
    $user_id     = AlkFactory::getSProperty("user_id", "-1");
    $user_priv   = AlkFactory::getSProperty("user_priv", ALK_PRIV_SPACE_NONE);
    if(defined("ALK_B_ANNU_CLOISONNEMENT_SERVICE") && ALK_B_ANNU_CLOISONNEMENT_SERVICE==true && !AlkFactory::isAnnuAdminAll())
      $userServ_id = AlkFactory::getSProperty("service_id", "-1");
    else
      $userServ_id = -1;

    $this->setLabel(ALK_STR_ORGA_SERV1);
    $this->setLabelDesc(_f("Cliquez sur le service ou %s pour consulter sa fiche", ALK_S_LAGENT).".<br/>".
                        ( AlkFactory::isAnnuAdminAll() || AlkFactory::isAnnuAdminServ()
                          ? _f("Pour activer %s à déplacer, cliquer sur le picto de type", ALK_S_LAGENT)." <img class=\"alkimgicon alkimgiconpriv0\" src='".ALK_MEDIA_URL."images/transp.gif'/>".
                            " "._t("pour afficher le picto")." <img class=\"alkimgicon alkimgiconcut\" src='".ALK_MEDIA_URL."images/transp.gif'/>.<br/>".
                            _f("Pour sélectionner le service cible, cliquer sur le picto %s associé", "<img src='".ALK_MEDIA_URL."images/icon_paste.gif'/>")."."
                          : "" ));
    
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_layer.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_arbre.js");
    //$this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_treeview.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery.treeview.js");
    //$this->addScriptCss("../../classes/form/treeview.css");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlformorganigform.js");

    $strHtml = "<div id='layerArbre' style='width:520;'>&nbsp;</div>".
      "<div style='margin:12px 0px;'><b>Légende :</b>".
      "<ul class='txtAdvice' style='margin-top:6px; padding-top:0px; text-align:left;'>".
      "<li style='list-style: url(".ALK_MEDIA_URL."images/icon_priv_0.gif) outside;'>"._t("Utilisateur")."</li>".
      "<li style='list-style: url(".ALK_MEDIA_URL."images/icon_priv_2.gif) outside;'>"._t("Administrateur annuaire de service")."</li>".
      "<li style='list-style: url(".ALK_MEDIA_URL."images/icon_priv_4.gif) outside;'>"._t("Administrateur de tout l'annuaire")."</li>".
      "<li style='list-style: url(".ALK_MEDIA_URL."images/icon_priv_32.gif) outside;'>"._t("Animateur de tous les espaces")."</li>".
      "<li style='list-style: url(".ALK_MEDIA_URL."images/icon_priv_34.gif) outside;'>"._t("Animateur de tous les espaces et administrateur annuaire de service")."</li>".
      "<li style='list-style: url(".ALK_MEDIA_URL."images/icon_priv_36.gif) outside;'>"._t("Administrateur de tous les espaces et tout l'annuaire")."</li>".
      "</ul></div>";

    $oCtrlTxt = AlkHtmlFactory::getHtml($strHtml); 
    $oBlock = $this->addBlock("blockOrga", "", "", "10", "550", true);
    $oBlock->addCtrl($oCtrlTxt);

    $strHtmlJs =  "var objTreeview = null; ".
      " function AffTreeview() { ".
      "   objTreeview = new Treeview(document, 'layerArbre', 0); ";
    
    $dsNoeud = $this->oAppli->oQuery->getDs_arboServiceNoeud($user_id, $user_priv, $userServ_id);
    $dsFeuille = $this->oAppli->oQuery->getDs_arboServiceFeuille();
    $idFirstNode = "-1";
    while( $drNoeud = $dsNoeud->getRowIter() ) {
      $idFils  = $drNoeud->getValueName("ID");
      if( $idFirstNode=="-1" ) {
        $idFirstNode = $idFils;
      }
      $idPere  = $drNoeud->getValueName("ID_PERE");
      $strNom  = $drNoeud->getValueName("NOM");
      $strNom  = preg_replace( "/\"/", "'", $strNom);
      $strNom  = preg_replace( "/'/", "\'", $strNom);
      $iNiv    = $drNoeud->getValueName("NIV");
      $strUrl  = $drNoeud->getValueName("URL");
      $iDroitLink = 0;
      $iDroitAction = 0;
      if( $iNiv > 0 ) {
        $iDroitLink = 2;
        $iDroitAction = $drNoeud->getValueName("DROIT");
      }
      if( $strNom != "" && $idPere != "-1" ) {
        $strHtmlJs .= " objTreeview.AddFolder(\"_".$idFils."\", \"_".$idPere."\", \"".$strNom."\", ".
          $iNiv.", ".$iDroitLink.", ".$iDroitAction.", \"".$strUrl."\", \"\");\n";
      }
    }
    
    while( $drFeuille = $dsFeuille->getRowIter() ) {
      $id = $drFeuille->getValueName("ID");
      $idNoeud   = $drFeuille->getValueName("ID_NOEUD");
      $strNom    = $drFeuille->getValueName("NOM");
      $strNom    = preg_replace( "/\"/", "'", $strNom);
      $strNom    = preg_replace( "/'/", "\'", $strNom);
      $strUrl    = $drFeuille->getValueName("URL");
      $user_priv = $drFeuille->getValueName("ICONE");
      $iDroitLink = 2;
      $iDroitAction = ( AlkFactory::isAnnuAdminAll() || AlkFactory::isAnnuAdminServ() ? 2 : 1 );

      $strIcone = ALK_MEDIA_URL."images/icon_priv_".$user_priv.".gif";
      if( $strNom != "" && $idNoeud != "-1" ) {
        $strHtmlJs .= " objTreeview.AddDoc(\"_".$id."\", \"_".$idNoeud."\", \"".$strNom."\", ".
          $iDroitLink.", ".$iDroitAction.", \"".$strIcone."\", \"".$strUrl."\", \"\", 1);\n";
      }
    }

    // paramétrage
    $strHtmlJs .=  " objTreeview.classLinkFolder = 'bold';".
      " objTreeview.classTextFolder = 'txtNormal bold';".
      " objTreeview.classLinkDoc = '';".
      " objTreeview.classTextDoc = 'txtNormal';".
      
      " objTreeview.imgNodeOpen  = '".ALK_MEDIA_URL."images/icon_arbo_close.gif';".
      " objTreeview.imgNodeClose = '".ALK_MEDIA_URL."images/icon_arbo_open.gif';".
      " objTreeview.imgNode      = '".ALK_MEDIA_URL."images/icon_arbo_cant_open.gif';".
      
   /*   " objTreeview.imgNodeOpen  = '';".
      " objTreeview.imgNodeClose = '';".
      " objTreeview.imgNode      = '';".*/
      
      " objTreeview.imgNodeFolder    = '".ALK_MEDIA_URL."images/icon_paste.gif';".
      " objTreeview.imgNodeDocSelect = '".ALK_MEDIA_URL."images/icon_cut.gif';".
      " objTreeview.iTabLg = 540;".
      
      " objTreeview.urlConfirm = 'javascript:CutPasteUser';".
      " objTreeview.tokenCutCopy = '".$this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_ARBORESCENCE, ALK_SHEET_NONE)."';".
      
      " objTreeview.bShowNode = true;".
      " objTreeview.bCanShowHideNode = false;".
      " objTreeview.strNodeName = ' agents';".
      
      " /* affichage */".
      " objTreeview.OpenNode('_".$idFirstNode."'); ".
      "	/*objTreeview.OpenAll();*/ ".
      "} ";
    
    $this->addJs($strHtmlJs);
    $this->addOnLoad("AffTreeview();dragAndDropPages('layerArbre');");
    //$this->addOnLoad("AffTreeview();");
    
  }  
    /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_07_service_arbo.htm");
  }
}
?>