<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."excel/Workbook.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlFormImportExport
 * 
 * Classe de gestion d'import annuaire
 */
class AlkHtmlFormImportExportForm extends AlkHtmlForm 
{
  
  /**
   *  construct par défaut
   * @param oAppli  Référence sur l'application en cours
   */  
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formImportExportForm");
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE); 
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");    
  }

  /**
   *  Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { }
  
  /**
   *  Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  {
    switch( $this->iMode ) {
    case  5:
      $this->doExportProfil(); 
      break;
    case 6:
      $this->doExportService(); 
      break;
    case 7:     
      $this->doExportMission(); 
      break;
    case 8:     
      $this->doExportMail(); 
      break;
    case 9:     
      $this->doExportLdap(); 
      break;
    }
    return "";
  }  
  
  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $actionForm   = new AlkFormData($this, "actionForm", -1, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $contenuFile  = new AlkFormData($this, "contenuFile", "", ALK_SQL_TEXT);
    $imp_fic      = new AlkFormData($this, "imp_fic", "", ALK_SQL_TEXT); 
   
    //paramètres communs à toutes les URL de ce fichier
    
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $appli_id = 0;
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $user_priv = AlkFactory::getSProperty("user_priv", "0");
    $service_id = AlkFactory::getSProperty("service_id", "-1");

    $iWidthLabel = 220;
    $iWidthCtrl  = 280;
    $iWidthLabelRight = 10;
    $iWidthCtrlRight  = 160;
    $iTxtWidth = 48;
    
    $oCtrlH = AlkHtmlFactory::getHtmlHidden($actionForm);
    $oCtrlRadioGroup = AlkHtmlFactory::getHtmlRadio($contenuFile, "Précisez le type de fichier à importer");
    $oCtrlRadioGroup->AddRadio(0, ALK_S_AGENT2."s");
    $oCtrlRadioGroup->AddRadio(1, "Services");
    if( ALK_LDAP == true ) {
      $oCtrlRadioGroup->AddRadio(3, ALK_S_AGENT2."s ".ALK_LDAP_NAME);
    }
    if( ALK_B_ANNU_IMPORT_EMAIL ==true ) {
      $oCtrlRadioGroup->AddRadio(2, "Courriels");
    } 
    $oCtrlRadioGroup->setSeparator("<br/>");
    $oCtrlCBMail = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "sendMailUser", 0, "Envoyer un courriel aux ".ALK_S_AGENTS." créés");

    $oCtrlFile = AlkHtmlFactory::getHtmlFile($imp_fic, "Cliquez sur le bouton [Parcourir] et sélectionnez un fichier", "", $iTxtWidth, 255); 
   
    $strTokenImportUser = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_IMPORTEXPORT, ALK_SHEET_IMPORT_USER);
    $strTokenImportServ = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_IMPORTEXPORT, ALK_SHEET_IMPORT_SERV);
    $strTokenImportMail = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_IMPORTEXPORT, ALK_SHEET_IMPORT_MAIL);
    $strTokenImportLdap = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_IMPORT_USER, ALK_SHEET_NONE, "&imp=1");
    $oButton = $this->addButtonPage("bt_1", "javascript:Valider('".$strTokenImportUser."', '".$strTokenImportServ."', '".$strTokenImportMail."', '".$strTokenImportLdap."');", 
                         "Valider", "Démarrer l'import");  
    $this->addSubmitButton($oButton);
       
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_IMPORTEXPORT, ALK_SHEET_FORM);
    $oButton = $this->addButtonPage("bt_2", "javascript:Annuler()", "Annuler", "Annuler la modification"); 
    $this->setResetButton($oButton);        
    
    $strTokenExportService = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_IMPORTEXPORT, ALK_SHEET_FORM, "&iMode=6");
    $strTokenExportMission = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_IMPORTEXPORT, ALK_SHEET_FORM, "&iMode=7");
    $strTokenExportProfil = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_IMPORTEXPORT, ALK_SHEET_FORM, "&iMode=5");
    $strTokenExportMail = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_IMPORTEXPORT, ALK_SHEET_FORM, "&iMode=8");
    $strTokenExportServLdap = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_IMPORTEXPORT, ALK_SHEET_FORM, "&iMode=9");
    $strServiceInt = "Des services ".( defined("ALK_LDAP") && ALK_LDAP==true ? " Alkanet" : "" );
    
    $strHtmlExport = '<div class="txtNormal">'.
     '- <a title="Effectuer un export '.$strServiceInt.'" href="javascript:OpenFooterExec(\''.ALK_ALKANET_SQL.'?token='.$strTokenExportService.'\')">'.$strServiceInt.'</a><br/>'.
      ( defined("ALK_LDAP") && ALK_LDAP==true
        ? '- <a  title="Effectuer un export des services '.ALK_LDAP_NAME.'" href="'.ALK_ALKANET_SQL.'?token='.$strTokenExportServLdap.'">Des services '.ALK_LDAP_NAME.'</a><br/>'
        : "" ).
      '- <a title="Effectuer un export des missions" href="javascript:OpenFooterExec(\''.ALK_ALKANET_SQL.'?token='.$strTokenExportMission.'\')">Des missions</a><br/>'.
      '- <a title="Effectuer un export des profils" href="javascript:OpenFooterExec(\''.ALK_ALKANET_SQL.'?token='.$strTokenExportProfil.'\')">Des profils</a><br/>'.
      ( ALK_B_ANNU_IMPORT_EMAIL ==true 
        ? '- <a title="Effectuer un export des courriels" href="'.ALK_ALKANET_SQL.'?token='.$strTokenExportMail.'">Des courriels</a><br/>'
        : "" ).
      '</div>';
    $textLiens = AlkHtmlFactory::getHtml($strHtmlExport);
   
    $oCtrlService = null;
    $oLien_export_courriel = null;
    if( ALK_B_ANNU_IMPORT_EMAIL ==true ) {
      $oCtrlService = AlkHtmlFactory::getHtmlSelect($this->service_id, "service_id");
      //liste des services de niveau 1
      $tabValTxt = array();
      
      $dsService = $this->oAppli->oQuery->GetDs_listeService($user_priv, $service_id, 1, 1);
      while($drService = $dsService->getRowIter()){
        $service_intitule= $drService->getValueName("SERVICE_INTITULE");
        $service_id = $drService->getValueName("SERVICE_ID"); 
        $tabValTxt[$service_id]=$service_intitule;
      }

      $oCtrlService->setProperty("tabValTxt", $tabValTxt);
      $oCtrlService->setProperty("tabValTxtDefault", array("-1" , "Veuillez sélectionner un service"));
      
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_IMPORT, ALK_SHEET_EXPORT_PROFIL); 
      $oLien_export_courriel = AlkHtmlFactory::getHtmlButton("javascript:ExportCourriel('".$strToken."')", "Exporter les profils", "");
    }
                       
    $strRegles = " des agents</a> ,".
      "<a href='".AlkFactory::getModuleUrl($this->oAppli->atype_id)."import_regles_service.pdf' target='blank'>des services</a>".
      ( ALK_B_ANNU_IMPORT_EMAIL == true 
        ?  " et <a href='".AlkFactory::getModuleUrl($this->oAppli->atype_id)."import_regles_courriel.pdf' target='blank'>des courriels</a>"
        :  "" );

    $this->setLabel("Importation et exportation sur l'annuaire");
    $this->setLabelDesc("Pour r&eacute;aliser un import de donn&eacute;es dans l'annuaire, vous devez au pr&eacute;alable prendre".
                        " connaissance du <a href='".AlkFactory::getModuleUrl($this->oAppli->atype_id)."import_format.pdf'".
                        " target='blank'>format</a> et des <a href='".AlkFactory::getModuleUrl($this->oAppli->atype_id).
                        "import_regles_utilisateur.pdf' target='blank'>r&egrave;gles d'importation".$strRegles.".<br/>".
                        " Lorsque l'import est termin&eacute;, le syst&egrave;me renvoie une adresse vous permettant de".
                        " consulter le compte-rendu de l'importation.<br/>".
                        " Plusieurs exemples de fichiers d'import sont disponibles&nbsp;:".
                        " <a href='".AlkFactory::getModuleUrl($this->oAppli->atype_id)."import_ex1.txt' target='blank'>exemple 1</a>,".
                        " <a href='".AlkFactory::getModuleUrl($this->oAppli->atype_id)."import_ex2.txt' target='blank'> exemple 2</a>.</div>");
      
    $strValide = "Cliquez sur le bouton [Valider] pour commencer l'import.";
    $oValid = AlkHtmlFactory::getHtml($strValide);
    
    /** ajout de blocs et association des controles */
    $oBlockProp = $this->addBlock("block_1", "Effectuer un import", "", $iWidthLabel, $iWidthCtrl, true);
    $oBlockProp->addCtrl($oCtrlRadioGroup);
    $oBlockProp->addCtrl($oCtrlCBMail);
    $oBlockProp->addCtrl($oCtrlFile);  
    $oBlockProp->addCtrl($oValid);
    $oBlockProp->addCtrl($oCtrlService);
    $oBlockProp->addCtrl($oLien_export_courriel);
   
    $oBlockProp2 = $this->addBlock("block_2", "Effectuer un export :", "", $iWidthLabelRight, $iWidthCtrlRight, true);
    $oBlockProp2->addCtrl($textLiens, ALK_HTMLFORM_1L1C);
    
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlformimportexportform.js");
    $this->setTemplate("annu", "alkhtmlformimportexportform.tpl");  
  }  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_11_import_form.htm"); 
  }    

  /**
   * Exécute l'export des profils au format excel sur la sortie standard
   */
  private function doExportProfil()
  {
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $appli_id = 0;
    $strParam = "cont_id=".$cont_id."&appli_id=".$appli_id;
    
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    
    $strUrlFileExport = $this->oAppli->getProperty("strUrlUpload").$user_id."_exp_profil.xls";
    $strPathFileExport = $this->oAppli->getProperty("strPathUpload").$user_id."_exp_profil.xls";

    // Destruction de l'export precedent
    if( file_exists($strPathFileExport) && is_file($strPathFileExport) ) {
      delFile($strPathFileExport);
    }
    
    // Creating a workbook
    $workbook = new Workbook($strPathFileExport);
    
    // Creating the first worksheet
    $worksheet1 =& $workbook->add_worksheet('Profils_generaux');
    
    // Creating the formats
    $oFormatHeader =& $workbook->add_format();
    $oFormatHeader->set_border(2);
    $oFormatHeader->set_align('center');
    $oFormatHeader->set_color('black');
    
    $oFormatValue =& $workbook->add_format();
    $oFormatValue->set_border(1);
    $oFormatValue->set_color('black');
    
    $iCol = 0;
    $iRow = 0;
    $iHeightRow = 20;
    $iWidthCol = 15;
    $tabReference = array("PROFIL_ID","INTITULE");
    for ($k=0; $k<count($tabReference); $k++) {
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $tabReference[$k] , $oFormatHeader);
      $iCol++;
    }
    $iCol = 0;
    $iRow++;
    
    $dsProfil =$this->oAppli->oQuery->getDsListProfilForCombo(255);
    $cpt = 0;
    while( $drProfil = $dsProfil->getRowIter() ) {
      $profil_id = $drProfil->getValueName("PROFIL_ID");
      $profil_intitule = $drProfil->getValueName("PROFIL_INTITULE");

      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_number($iRow, $iCol, $profil_id , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, mb_convert_encoding($profil_intitule,ALK_EXPORT_ENCODING,ALK_HTML_ENCODING) , $oFormatValue);
      $iRow++;
      $iCol = 0;
    }
    
    $workbook->close();
    
    // affiche le conteu du fichier sur la sortie standard
    if( file_exists($strPathFileExport) ) {
      AffHeaderFileDownload($strPathFileExport, $user_id."_exp_profil.xls", 0, "application/vnd.ms-excel");
      readfile($strPathFileExport) ;
    }
  }

  /**
   * Exécute l'export des missions au format excel sur la sortie standard
   */
  private function doExportMission()
  {
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $appli_id = 0;
    $strParam = "cont_id=".$cont_id."&appli_id=".$appli_id;
    
    $user_id = AlkFactory::getSProperty("user_id", "-1");

    $strUrlFileExport = $this->oAppli->getProperty("strUrlUpload").$user_id."_exp_mission.xls";
    $strPathFileExport = $this->oAppli->getProperty("strPathUpload").$user_id."_exp_mission.xls";
    
    // Destruction de l'export precedent
    if( file_exists($strPathFileExport) && is_file($strPathFileExport) ) {
      delFile($strPathFileExport);
    }

    // Creating a workbook
    $workbook = new Workbook($strPathFileExport);
    
    // Creating the first worksheet
    $worksheet1 =& $workbook->add_worksheet('Missions');
    
    // Creating the formats
    $oFormatHeader =& $workbook->add_format();
    $oFormatHeader->set_border(2);
    $oFormatHeader->set_align('center');
    $oFormatHeader->set_color('black');
    
    $oFormatValue =& $workbook->add_format();
    $oFormatValue->set_border(1);
    $oFormatValue->set_color('black');
    
    $iCol = 0;
    $iRow = 0;
    $iHeightRow = 20;
    $iWidthCol = 15;
    $tabReference = array("MISSION_ID", "INTITULE");
    
    for ($k=0; $k<count($tabReference); $k++) {
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $tabReference[$k] , $oFormatHeader);
      $iCol++;
    }
    
    $iCol = 0;
    $iRow++;
    $dsMission = $this->oAppli->oQuery->GetDs_Mission();
    
    while( $drMission = $dsMission->getRowIter() ) {
      $mission_id = $drMission->getValueName("MISSION_ID");
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_number($iRow, $iCol, $mission_id , $oFormatValue);
      $iCol++;
      $mission_intitule = $drMission->getValueName("MISSION_INTITULE");
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, mb_convert_encoding($mission_intitule,ALK_EXPORT_ENCODING,ALK_HTML_ENCODING) , $oFormatValue);
      
      $iRow++;
      $iCol = 0;
    }
    $workbook->close();

    // affiche le conteu du fichier sur la sortie standard
    if( file_exists($strPathFileExport) ) {
      AffHeaderFileDownload($strPathFileExport, $user_id."_exp_mission.xls", 0, "application/vnd.ms-excel");
      readfile($strPathFileExport) ;
    }
  }

  /**
   * Exécute l'export des services au format excel sur la sortie standard
   */
  private function doExportService()
  {
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $appli_id = 0;

    $strParam = "cont_id=".$cont_id."&appli_id=".$appli_id;
    
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    if(defined("ALK_B_ANNU_CLOISONNEMENT_SERVICE") && ALK_B_ANNU_CLOISONNEMENT_SERVICE==true && !AlkFactory::isAnnuAdminAll())
      $service_id = AlkFactory::getSProperty("service_id", "-1");
    else
      $service_id = -1;
    
    $strUrlFileExport = $this->oAppli->getProperty("strUrlUpload").$user_id."_exp_service.xls";
    $strPathFileExport = $this->oAppli->getProperty("strPathUpload").$user_id."_exp_service.xls";
    
    // Destruction de l'export precedent
    if( file_exists($strPathFileExport) && is_file($strPathFileExport) ) {
      delFile($strPathFileExport);
    }

    // Creating a workbook
    $workbook = new Workbook($strPathFileExport);
    
    // Creating the first worksheet
    $worksheet1 =& $workbook->add_worksheet('Service');
    
    // Creating the formats
    $oFormatHeader =& $workbook->add_format();
    $oFormatHeader->set_border(2);
    $oFormatHeader->set_align('center');
    $oFormatHeader->set_color('black');
    
    $oFormatValue =& $workbook->add_format();
    $oFormatValue->set_border(1);
    $oFormatValue->set_color('black');
    
    $iCol = 0;
    $iRow = 0;
    $iHeightRow = 20;
    $iWidthCol = 15;
    
    $tabReference = array("MODE", "CLE", "DEPT_ID", "ETAT", 
                          "INTITULE", "INTITULE_COURT", "SERVICE_NIVEAU",
                          "SERVICE_NIVEAU1", "SERVICE_NIVEAU2", "SERVICE_NIVEAU3", "SERVICE_NIVEAU4",
                          "ADRESSE", "TEL", "FAX", "EMAIL", "WEB", 
                          "SERVICE_LDAP", "SERVICE_LDAPDN", "SERVICE_LDAPUID");
    
    for ($k=0; $k<count($tabReference); $k++) {
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $tabReference[$k] , $oFormatHeader);
      $iCol++;
    }
    $iCol = 0;
    $iRow++;
    $dsService =$this->oAppli->oQuery->GetDs_Service($service_id);
    while( $drService = $dsService->getRowIter() ) {
      $service_id         = $drService->getValueName("SERVICE_ID");
      $service_intituleUTF8 = $drService->getValueName("SERVICE_INTITULE");
      $service_intitule   = mb_convert_encoding($service_intituleUTF8, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $service_int_court  = mb_convert_encoding($drService->getValueName("SERVICE_INTITULE_COURT"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $service_adresse    = mb_convert_encoding($drService->getValueName("SERVICE_ADRESSE"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $service_tel        = mb_convert_encoding($drService->getValueName("SERVICE_TEL"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $service_fax        = mb_convert_encoding($drService->getValueName("SERVICE_FAX"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $service_email      = mb_convert_encoding($drService->getValueName("SERVICE_EMAIL"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $service_web        = mb_convert_encoding($drService->getValueName("SERVICE_WEB"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $service_etat       = $drService->getValueName("SERVICE_ETAT");
      $service_niv        = $drService->getValueName("SERVICE_NIVEAU");
      $service_arbre      = $drService->getValueName("SERVICE_ARBRE");
      $dept_id            = $drService->getValueName("DEPT_ID");
      $service_ldap       = $drService->getValueName("SERVICE_LDAP");
      $service_ldapuid    = mb_convert_encoding($drService->getValueName("SERVICE_LDAPUID"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $service_ldapdn     = mb_convert_encoding($drService->getValueName("SERVICE_LDAPDN"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      
      $tabArbre = explode("-", substr($service_arbre, 1, -1));
            
      $service_niv1 = "";
      $service_niv2 = "";
      $service_niv3 = "";
      $service_niv4 = "";
      
      switch( $service_niv ) {
      case 4:
        $service_niv4 = $service_intituleUTF8;
        $service_niv3 = $this->oAppli->oQuery->getStr_ServiceSigle($tabArbre[3], false);
        $service_niv2 = $this->oAppli->oQuery->getStr_ServiceSigle($tabArbre[2], false);
        $service_niv1 = $this->oAppli->oQuery->getStr_ServiceSigle($tabArbre[1], false);
        break;
      case 3:
        $service_niv3 = $service_intituleUTF8;
        $service_niv2 = $this->oAppli->oQuery->getStr_ServiceSigle($tabArbre[2], false);
        $service_niv1 = $this->oAppli->oQuery->getStr_ServiceSigle($tabArbre[1], false);
        break;
      case 2:
        $service_niv2 = $service_intituleUTF8;
        $service_niv1 = $this->oAppli->oQuery->getStr_ServiceSigle($tabArbre[1], false);
        break;
      case 1:
        $service_niv1 = $service_intituleUTF8;
        break;
      }
      
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, "" , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_number($iRow, $iCol, $service_id , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_number($iRow, $iCol, $dept_id, $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_number($iRow, $iCol, $service_etat , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_intitule , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_int_court , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_number($iRow, $iCol, $service_niv , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, mb_convert_encoding($service_niv1, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING) , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, mb_convert_encoding($service_niv2, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING) , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, mb_convert_encoding($service_niv3, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING) , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, mb_convert_encoding($service_niv4, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING) , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_adresse , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_tel , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_fax , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_email , $oFormatValue);
      $iCol++;  
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_web , $oFormatValue);
      $iCol++;  
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_number($iRow, $iCol, $service_ldap , $oFormatValue);
      $iCol++;  
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_ldapdn , $oFormatValue);
      $iCol++;  
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_ldapuid , $oFormatValue);
      
              
      $iRow++;
      $iCol = 0;
    }
    $workbook->close();

    // affiche le conteu du fichier sur la sortie standard
    if( file_exists($strPathFileExport) ) {
      AffHeaderFileDownload($strPathFileExport, $user_id."_exp_service.xls", 0, "application/vnd.ms-excel");
      readfile($strPathFileExport) ;
    }
  }

  /**
   * Effectue l'export excel des services ldap distant
   */
  private function doExportLdap()
  {
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $appli_id = 0;

    $strParam = "cont_id=".$cont_id."&appli_id=".$appli_id;
    
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    if(defined("ALK_B_ANNU_CLOISONNEMENT_SERVICE") && ALK_B_ANNU_CLOISONNEMENT_SERVICE==true && !AlkFactory::isAnnuAdminAll())
      $service_id = AlkFactory::getSProperty("service_id", "-1");
    else
      $service_id = -1;
    
    $strUrlFileExport = $this->oAppli->getProperty("strUrlUpload").$user_id."_exp_service_ldap.xls";
    $strPathFileExport = $this->oAppli->getProperty("strPathUpload").$user_id."_exp_service_ldap.xls";
    
    // Destruction de l'export precedent
    if( file_exists($strPathFileExport) && is_file($strPathFileExport) ) {
      delFile($strPathFileExport);
    }

    // Creating a workbook
    $workbook = new Workbook($strPathFileExport);
    
    // Creating the first worksheet
    $worksheet1 =& $workbook->add_worksheet('Service');
    
    // Creating the formats
    $oFormatHeader =& $workbook->add_format();
    $oFormatHeader->set_border(2);
    $oFormatHeader->set_align('center');
    $oFormatHeader->set_color('black');
    
    $oFormatValue =& $workbook->add_format();
    $oFormatValue->set_border(1);
    $oFormatValue->set_color('black');
    
    $iCol = 0;
    $iRow = 0;
    $iHeightRow = 20;
    $iWidthCol = 15;
    
    $tabReference = array("MODE", "CLE", "DEPT_ID", "ETAT", 
                          "INTITULE", "INTITULE_COURT", "SERVICE_NIVEAU",
                          "SERVICE_NIVEAU1", "SERVICE_NIVEAU2", "SERVICE_NIVEAU3", "SERVICE_NIVEAU4",
                          "ADRESSE", "TEL", "FAX", "EMAIL", "WEB", 
                          "SERVICE_LDAP", "SERVICE_LDAPDN", "SERVICE_LDAPUID");
    
    for ($k=0; $k<count($tabReference); $k++) {
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $tabReference[$k] , $oFormatHeader);
      $iCol++;
    }
    $iCol = 0;
    $iRow++;
    $dsService =$this->oAppli->oQuery->getDsLdapListService();
    while( $drService = $dsService->getRowIter() ) {
      $service_id       = "";
      $dept_id          = "0";
      $service_etat     = "1";
      $service_intituleUTF8 = $drService->getValueName("SERVICE_INTITULE");
      $service_intitule = mb_convert_encoding($service_intituleUTF8, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $service_adresse  = "";
      $service_tel      = "";
      $service_fax      = "";
      $service_email    = "";
      $service_web      = "";
      $service_ldapuid  = ( defined("ALK_B_LDAP_AD") && ALK_B_LDAP_AD==true 
                            ? "CN=".$service_intitule.",".mb_convert_encoding($drService->getValueName("DN"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING)
                            : mb_convert_encoding($drService->getValueName("DN"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING) );
      $service_ldapdn   = mb_convert_encoding(ALK_LDAP_BASE_DN_NODE_SERV, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $service_ldap     = "1";
      
      $service_niv      = "1";
      $strDnServiceSplit = str_replace(",", "", $service_ldapuid);
      $tabDn = spliti("ou=",$strDnServiceSplit);
      if( is_array($tabDn) && count($tabDn)>2 ) {  
        unset($tabDn[0]); 
        unset($tabDn[count($tabDn)]);
        $service_niv = count($tabDn);
      } else {
        $tabDn = array("", $service_intitule);  
      }
      
      $service_int_court = ( $service_niv > 1 ? "" : substr($service_intitule, 0, 40));
      
      $service_niv1 = "";
      $service_niv2 = "";
      $service_niv3 = "";
      $service_niv4 = "";
      
      switch( $service_niv ) {
      case 4:
        $service_niv4 = $service_intitule;
        $service_niv3 = $tabDn[2];
        $service_niv2 = $tabDn[3];
        $service_niv1 = $tabDn[4];
        break;
      case 3:
        $service_niv3 = $service_intitule;
        $service_niv2 = $tabDn[2];
        $service_niv1 = $tabDn[3];
        break;
      case 2:
        $service_niv2 = $service_intitule;
        $service_niv1 = $tabDn[2];
        break;
      case 1:
        $service_niv1 = $service_intitule;
        break;
      }
      
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, "" , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_id , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_number($iRow, $iCol, $dept_id, $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_number($iRow, $iCol, $service_etat , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_intitule , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_int_court , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_number($iRow, $iCol, $service_niv , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_niv1, $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_niv2, $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_niv3, $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_niv4, $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_adresse , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_tel , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_fax , $oFormatValue);
      $iCol++;
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_email , $oFormatValue);
      $iCol++;  
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_web , $oFormatValue);
      $iCol++;  
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_number($iRow, $iCol, $service_ldap , $oFormatValue);
      $iCol++;  
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_ldapdn , $oFormatValue);
      $iCol++;  
      $worksheet1->set_row($iRow, $iHeightRow);
      $worksheet1->set_column($iRow, $iCol, $iWidthCol);
      $worksheet1->write_string($iRow, $iCol, $service_ldapuid , $oFormatValue);
      
      $iRow++;
      $iCol = 0;
    }
    $workbook->close();

    // affiche le conteu du fichier sur la sortie standard
    if( file_exists($strPathFileExport) ) {
      AffHeaderFileDownload($strPathFileExport, $user_id."_exp_service_ldap.xls", 0, "application/vnd.ms-excel");
      readfile($strPathFileExport) ;
    }
  }

}

?>