<?php

/** Chargement des fichiers de config */
$strPathBase = str_replace("scripts/alkanet/task/updateIndexPj.php", "", $_SERVER["PHP_SELF"]);
require_once($strPathBase."libconf/app_conf.php");

// initialisation des langues, nécessaire si $tabLg n'est pas défini dans le fichier app_conf.php
require_once(ALK_ALKANET_ROOT_PATH."lib/lib_locales.php");
$bFrontOffice = false;
initAlkLocale();

require_once(ALK_ALKANET_ROOT_PATH."lib/app_conf_alkanet.php");
require_once(ALK_ALKANET_ROOT_PATH."lib/lib_file.php");
require_once(ALK_ALKANET_ROOT_PATH."classes/pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH."classes/pattern/alkrequest.class.php");
require_once(ALK_ALKANET_ROOT_PATH."classes/pattern/alkfactory.class.php");

/** 
 * Pour s'assurer qu'on est en PHP_CLI, on vérifie l'existance des paramètres argc/argv normalement toujours et uniquement disponible dans ce mode
 */
ini_set('register_argc_argv', 0);
if( PHP_SAPI != "cli" ) {
  require_once(ALK_ALKANET_ROOT_PATH."lib/lib_file.php");
  writeHTTP404();
  exit();
}

define("ALK_B_ATYPE_ESPACE", true);
AlkFactory::loadConstants(array(-1), array(-1), array(-1));

$data_id = ( isset($argv[1]) ? $argv[1] : "-1" );
$pj_id   = ( isset($argv[2]) ? $argv[2] : "-1" );

if ( file_exists(ALK_ALKANET_ROOT_PATH."libconf/classes/alksearcher_solr.class.php") ){
  require_once(ALK_ALKANET_ROOT_PATH."libconf/classes/alksearcher_solr.class.php");
} else {
  require_once(ALK_ALKANET_ROOT_PATH."classes/pattern/alksearcher_solr.class.php");
}

if( $data_id!="-1" && $pj_id!="-1" ) {
  AlkSearcherSolr::mergeDataToPj($data_id, $pj_id);
}

?>