<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Alkanet
Module fournissant les images de types graphe Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * @file alkanet_graphe.php
 * @package Alkanet_Appli
 */
require_once("../../lib/lib_session.php"); 
require_once(AlkFactory::getModulePath(ALK_ATYPE_ID_GRAPHE)."lib/app_conf_graphe.php");

$strPath = ALK_ALKANET_ROOT_PATH.AlkFactory::getUploadPath(ALK_ATYPE_ID_GRAPHE,true);
$graphe_id = (isset($_REQUEST["g"]) ? $_REQUEST["g"] : -1);
$is_static = (isset($_REQUEST["i"]) ? $_REQUEST["i"] : 1);  
$bApercu   = (isset($_REQUEST["a"]) ? $_REQUEST["a"] : 0);   
$hauteur   = (isset($_REQUEST["h"]) ? $_REQUEST["h"] : 0);
$largeur   =  (isset($_REQUEST["l"]) ? $_REQUEST["l"] : 0);  
$strFileName = $strPath.$graphe_id.".png";  

if( !defined("ALK_B_ATYPE_GRAPHE") ) define("ALK_B_ATYPE_GRAPHE", true);
$oQueryGraphe = AlkFactory::getQuery(ALK_ATYPE_ID_GRAPHE); 

if ($is_static==1){
  if (!file_exists($strFileName)){
    buildgraphe($graphe_id, 1);
  }
  $iSize = @filesize($strFileName);
  header("Content-Type: image/png; name=\"".$strFileName."\"");
  header("Content-Length: ".$iSize);
  $im = @imagecreatefrompng($strFileName);
  imagepng($im);
  imagedestroy($im);

} else {
  buildgraphe($graphe_id, -1, 1);
}

function buildgraphe($graphe_id, $bStatic=-1, $bStroke=-1)
{
  global $oQueryGraphe, $bApercu, $largeur, $hauteur;
  $dsGraphe = $oQueryGraphe->getDsGraphById($graphe_id);
  if ($dr = $dsGraphe->getRowIter()){
    $source_id = $dr->getValueName("SOURCE_ID");
    $graphe_title = $dr->getValueName("GRAPHE_TITLE");
    $graphe_titlefontstyle = $dr->getValueName("GRAPHE_TITLEFONTSTYLE");
    $graphe_titlefontsize = $dr->getValueName("GRAPHE_TITLEFONTSIZE");
    $graphe_titlefontcolor = $dr->getValueName("GRAPHE_TITLEFONTCOLOR");
    $graphe_bgcolor = $dr->getValueName("GRAPHE_BGCOLOR");
    $graphe_bgimage = $dr->getValueName("GRAPHE_BGIMAGE");
    $graphe_bggradient = $dr->getValueName("GRAPHE_BGGRADIENT");
    $graphe_bgtransparency = $dr->getValueName("GRAPHE_BGTRANSPARENCY");
    $graphe_legendfontsize = $dr->getValueName("GRAPHE_LEGENDFONTSIZE");
    $graphe_legendfontstyle = $dr->getValueName("GRAPHE_LEGENDFONTSTYLE");
    $graphe_legendbackground = $dr->getValueName("GRAPHE_LEGENDBACKGROUND");
    $graphe_showlegend = $dr->getValueName("GRAPHE_SHOWLEGEND");
    $graphe_showzeroline = $dr->getValueName("GRAPHE_SHOWZEROLINE");
    $graphe_borderwidth = $dr->getValueName("GRAPHE_BORDERWIDTH");
    $graphe_bordercolor = $dr->getValueName("GRAPHE_BORDERCOLOR");
    $graphe_addborder = $dr->getValueName("GRAPHE_ADDBORDER");
    $graphe_xaxistitle = $dr->getValueName("GRAPHE_XAXISTITLE");
    $graphe_yaxistitle = $dr->getValueName("GRAPHE_YAXISTITLE");
    $graphe_yaxisformat = $dr->getValueName("GRAPHE_YAXISFORMAT");
    $graphe_xaxisformat = $dr->getValueName("GRAPHE_XAXISFORMAT");
    $graphe_pielegendlabel = $dr->getValueName("GRAPHE_PIELEGENDLABEL");
    $graphe_pielegenddecimal = $dr->getValueName("GRAPHE_PIELEGENDDECIMAL");
    $graphe_linemark = $dr->getValueName("GRAPHE_LINEMARK");
    $typegraphe_id = $dr->getValueName("TYPEGRAPHE_ID");
    $graphe_dimx = $dr->getValueName("GRAPHE_DIMX");
    $graphe_dimy= $dr->getValueName("GRAPHE_DIMY");
    $graphe_bdrawgrid = $dr->getValueName("GRAPHE_BDRAWGRID");
    $graphe_gridcolor = $dr->getValueName("GRAPHE_GRIDCOLOR");
    $graphe_gridwidth = $dr->getValueName("GRAPHE_GRIDWIDTH");
    $graphe_gridtransparence = $dr->getValueName("GRAPHE_GRIDTRANSPARENCE");
    $graphe_columns = $dr->getValueName("GRAPHE_COLUMNS");
    $graphe_columnx = $dr->getValueName("GRAPHE_COLUMNX");
    $graphe_columncourbe = $dr->getValueName("GRAPHE_COLUMNCOURBE");
    $graphe_columnsalias = $dr->getValueName("GRAPHE_COLUMNSALIAS");
    $graphe_columnscolor = $dr->getValueName("GRAPHE_COLUMNSCOLOR");
    $graphe_showvalues = $dr->getValueName("GRAPHE_SHOWVALUES");
    $graphe_copyright = $dr->getValueName("GRAPHE_COPYRIGHT");
    $graphe_filecolor = $dr->getValueName("GRAPHE_FILECOLOR");

    // construction du graphe
    $path_font = ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."".AlkFactory::getModuleName(ALK_ATYPE_ID_GRAPHE)."/Fonts/";
    $path_file = ALK_ALKANET_ROOT_PATH.AlkFactory::getUploadPath(ALK_ATYPE_ID_GRAPHE,true)."Pictures/";

    // définition des données 
    $array_columns = array();
    $DataSet = Alkfactory::getpData(); 

    $source_file = getSourceFileCvs($source_id);
    
    if(file_get_contents($source_file)=="") return;
    if($graphe_columns=="") return;
    
        
    // création du graphe
    $graphe_dimx = ($largeur!=0 ? $largeur : $graphe_dimx);
    $graphe_dimy = ($hauteur !=0 ? $hauteur : $graphe_dimy);
    $graph = Alkfactory::getpChart($graphe_dimx, $graphe_dimy);

    ################ Traitement des séries ###############
    $array_columns = explode("-", $graphe_columns);
    if($graphe_columnx !=-1)
      $DataSet->ImportFromCSV($source_file,",",$array_columns,TRUE,intval($graphe_columnx)); 
    else
      $DataSet->ImportFromCSV($source_file,",",$array_columns,TRUE);
    $DataSet->AddAllSeries(); 
    $DataSet->SetAbsciseLabelSerie(); 
    
    // renommage des séries
    $tab_alias = explode(",", $graphe_columnsalias);
    foreach($array_columns as $value){
      $DataSet->SetSerieName($tab_alias[$value],"Serie".$value); 
    }
    
    // modification de la palette de couleurs si fichier renseigné
    if($graphe_filecolor !="" && file_exists($path_file.$graphe_filecolor))
      $graph->loadColorPalette($path_file.$graphe_filecolor);

    // utilisation des couleurs sélectionnées par l'utilisateur(pas d'utilisation de couleurs pour les camemberts)

    if($typegraphe_id != ALK_CAMMENB_BASIQUE && $typegraphe_id !=ALK_CAMMENB_ECARTELE && $typegraphe_id != ALK_CAMMMENB_3D){
      $tab_color = explode("-",$graphe_columnscolor);
      $iColor = 0;
      foreach($array_columns as $value){
        $couleur = $tab_color[$value];
        if($couleur!=""){
          $array_color = getRGB($couleur);
          $graph->setColorPalette($iColor++,$array_color[0],$array_color[1],$array_color[2]);  
        }
      }
    }

    // apercu de graphe depuis la liste : ne pas déplacer
    if ($bApercu==1){
     //Cache definition   
      $Cache = Alkfactory::getpCache();   
      $Cache->GetFromCache($graphe_id,$DataSet->GetData()); 
    }
                    
    ################ Propriétés du graphe ###############

    $graph->setFontProperties($path_font.$graphe_titlefontstyle,8); 

    // arrière plan couleur 
    $array_color = getRGB($graphe_bgcolor);
    $x = ($graphe_xaxistitle!="" ? 60: 20);
    $y = ($graphe_xaxistitle!="" ? 70: 40);
    
    if($graphe_bggradient==1){
      $graph->drawGraphAreaGradient($array_color[0],$array_color[1],$array_color[2],50,TARGET_BACKGROUND);  
      $graph->setGraphArea($x,$y,$graphe_dimx-$x,$graphe_dimy-$y);  
      $graph->drawGraphArea($array_color[0]+81,$array_color[1]+64,$array_color[2]+41,FALSE);   
      $graph->drawGraphAreaGradient($array_color[0]+30,$array_color[1]+50,$array_color[2]+30,50); 
    }else{
      $graph->setGraphArea($x,$y,$graphe_dimx-$x,$graphe_dimy-$y);
      $graph->drawFilledRoundedRectangle(7,7,$graphe_dimx-7,$graphe_dimy-7,5,$array_color[0],$array_color[1],$array_color[2]);
      $graph->drawRoundedRectangle(5,5,$graphe_dimx-5,$graphe_dimy-5,5,$array_color[0]-5,$array_color[1]-5,$array_color[2]-5);
      $graph->drawGraphArea(255,255,255,TRUE);
    }

    switch($typegraphe_id){
     case ALK_HISTO_NORMAL:
     case ALK_HISTO_EMPILE:
     case ALK_COURBE_SIMPLE:
     case ALK_COURBE_PLEINECUB:
     case ALK_COURBE_PLEINE:
     case ALK_MIXTE_HISTONLIGNE:
     case ALK_MIXTE_HISTOELIGNE:

       // format des axes des abcises
       $DataSet->SetXAxisName($graphe_xaxistitle); 
       $DataSet->SetYAxisName($graphe_yaxistitle); 
      
       if ($graphe_xaxisformat!="no_format")
         $DataSet->SetXAxisFormat($graphe_xaxisformat); 
       if ($graphe_yaxisformat!="no_format")
         $DataSet->SetYAxisFormat($graphe_yaxisformat); 
         
       if($typegraphe_id==ALK_COURBE_SIMPLE || $typegraphe_id==ALK_MIXTE_HISTOELIGNE || $typegraphe_id==ALK_MIXTE_HISTONLIGNE){
         $tab_mark = explode(",",$graphe_linemark);
         
         foreach ($tab_mark as $index=>$value){
           if($value !=""){
             $picture = ALK_ALKANET_ROOT_PATH.AlkFactory::getUploadPath(ALK_ATYPE_ID_GRAPHE,true)."Pictures/".$value;
             if (in_array($index, $array_columns))
               $DataSet->SetSerieSymbol("Serie".$index,$picture);
           }
         }
       }
      
       if ($typegraphe_id==ALK_HISTO_EMPILE || $typegraphe_id==ALK_MIXTE_HISTOELIGNE){
         $graph->drawScale($DataSet->GetData(),$DataSet->GetDataDescription(),SCALE_ADDALLSTART0,
          ($array_color[0]-100 <0 ? $array_color[0] :$array_color[0]-100),($array_color[1]-100 <0 ? $array_color[1] :$array_color[1]-100),($array_color[2]-100 <0 ? $array_color[2] :$array_color[2]-100),
          TRUE,0,2,TRUE,1,FALSE);
       }
       else {
         $graph->drawScale($DataSet->GetData(),$DataSet->GetDataDescription(),SCALE_NORMAL,
          ($array_color[0]-100 <0 ? $array_color[0] :$array_color[0]-100),($array_color[1]-100 <0 ? $array_color[1] :$array_color[1]-100),($array_color[2]-100 <0 ? $array_color[2] :$array_color[2]-100),
          TRUE,0,2,TRUE,1,FALSE);
       }
      
      
       // grid ou pas
       if ($graphe_bdrawgrid==0){
         $array_color = getRGB($graphe_gridcolor);
         $graph->drawGrid($graphe_gridwidth,TRUE,$array_color[0],$array_color[1],$array_color[2],$graphe_gridtransparence); 
       }
  
       // Draw the 0 line  
       if ($graphe_showzeroline==1){
         $graph->setFontProperties($path_font.$graphe_titlefontstyle,8);  
         $graph->drawTreshold(0,255,0,0);  
       }
       
       // dessin du graphe
      if($typegraphe_id==ALK_HISTO_NORMAL){
        $graph->drawBarGraph($DataSet->GetData(),$DataSet->GetDataDescription(),TRUE);  
      }else if($typegraphe_id==ALK_HISTO_EMPILE){
        $graph->drawStackedBarGraph($DataSet->GetData(),$DataSet->GetDataDescription(),TRUE);  
      }else if($typegraphe_id==ALK_COURBE_SIMPLE){
        $graph->drawLineGraph($DataSet->GetData(),$DataSet->GetDataDescription());     
        $graph->drawPlotGraph($DataSet->GetData(),$DataSet->GetDataDescription(),3,2,255,255,255);   
      }else if ($typegraphe_id==ALK_COURBE_PLEINECUB){
        $graph->drawFilledCubicCurve($DataSet->GetData(),$DataSet->GetDataDescription(),.1,50);  
      }else if($typegraphe_id==ALK_COURBE_PLEINE){
        $graph->drawFilledLineGraph($DataSet->GetData(),$DataSet->GetDataDescription(),50,TRUE);  
      }else {
        // on remove les séries qui vont être des courbes
        $tab_courbe = explode("-", $graphe_columncourbe);
        foreach($tab_courbe as $value){
          if($value!="")
            $DataSet->RemoveSerie("Serie".$value);
        }
  
        if($typegraphe_id==ALK_MIXTE_HISTONLIGNE){
           // on construit le histo normal
           $graph->drawBarGraph($DataSet->GetData(),$DataSet->GetDataDescription(),TRUE);  
        }else {
          $graph->drawStackedBarGraph($DataSet->GetData(),$DataSet->GetDataDescription(),TRUE);  
        }
  
        // on remove all series
        $DataSet->RemoveAllSeries();
        
        // on add le reste des séries
       $tab_courbe = explode("-", $graphe_columncourbe);
       foreach($tab_courbe as $value){
         if($value!="")
            $DataSet->AddSerie("Serie".$value);
       }
  
        $graph->drawLineGraph($DataSet->GetData(),$DataSet->GetDataDescription());   
        $graph->drawPlotGraph($DataSet->GetData(),$DataSet->GetDataDescription(),3,2,255,255,255);   
  
      }
      
      // Finish the graph  
      $graph->setFontProperties($path_font.$graphe_legendfontstyle,intval($graphe_legendfontsize)); 
      $array_color = getRGB($graphe_legendbackground);
      if ($graphe_showlegend==1)
        $graph->drawLegend(50,35,$DataSet->GetDataDescription(),$array_color[0],$array_color[1],$array_color[2]);  
    break;
    case ALK_CAMMENB_BASIQUE:
    case ALK_CAMMENB_ECARTELE:
    case ALK_CAMMMENB_3D:
      $radius = min($graphe_dimx, $graphe_dimy)*0.3;
      if($typegraphe_id==ALK_CAMMENB_BASIQUE){
         $graph->drawBasicPieGraph($DataSet->GetData(),$DataSet->GetDataDescription(),$graphe_dimx/2,$graphe_dimy/2,$radius,constant($graphe_pielegendlabel),255,255,255, $graphe_pielegenddecimal);  
      }else if($typegraphe_id==ALK_CAMMENB_ECARTELE){  
        $graph->drawFlatPieGraph($DataSet->GetData(),$DataSet->GetDataDescription(),$graphe_dimx/2,$graphe_dimy/2,$radius,constant($graphe_pielegendlabel),10,$graphe_pielegenddecimal);  
      }else {
        $graph->drawPieGraph($DataSet->GetData(),$DataSet->GetDataDescription(),$graphe_dimx/2,$graphe_dimy/2,$radius,constant($graphe_pielegendlabel),TRUE,50,20,5,$graphe_pielegenddecimal);  
      }
      
      $array_color = getRGB($graphe_legendbackground);
      if ($graphe_showlegend==1)
        $graph->drawPieLegend(40,35,$DataSet->GetData(),$DataSet->GetDataDescription(),$array_color[0],$array_color[1],$array_color[2]);  
    break;
    
    case ALK_RADAR_NORMAL:
    case ALK_RADAR_SURFACIQUE:       
      $graph->drawRadarAxis($DataSet->GetData(),$DataSet->GetDataDescription(), FALSE,20,0,0,0,200,200,200,10);

      if($typegraphe_id==ALK_RADAR_NORMAL)
        $graph->drawRadar($DataSet->GetData(),$DataSet->GetDataDescription());
      else
        $graph->drawFilledRadar($DataSet->GetData(),$DataSet->GetDataDescription());
          // Finish the graph  
      $graph->setFontProperties($path_font.$graphe_legendfontstyle,intval($graphe_legendfontsize)); 
      $array_color = getRGB($graphe_legendbackground);
      if ($graphe_showlegend==1)
        $graph->drawLegend(50,35,$DataSet->GetDataDescription(),$array_color[0],$array_color[1],$array_color[2]);  
    break;

   }      
    // a choisi l'image
    if($graphe_bgimage !=""){
      $picture = $path_file.$graphe_bgimage;
      $ext = substr($graphe_bgimage,strlen($graphe_bgimage)-3, strlen($graphe_bgimage));
      switch(strtolower($ext)){
        case "jpg":
          $graph->drawFromJPG($picture,$graphe_dimx-70,$graphe_dimy-70,50);
          break;
        case "gif":
          $graph->drawFromGIF($picture,$graphe_dimx-70,$graphe_dimy-70,50);
          break;
        case "png":
          $graph->drawFromPNG($picture,$graphe_dimx-110,$graphe_dimy-55,50);
          break;
      }
    }
  
    // on a choisi ou pas la bordure
    if($graphe_addborder==0){
      $array_color = getRGB($graphe_bordercolor);
       $graph->AddBorder($graphe_borderwidth, $array_color[0],$array_color[1],$array_color[2]);  
    }
    // écrire les valeurs sur le graphe
    
    // pour les graphe de type cammembert et radar, cette valeur est 0
    if($typegraphe_id==ALK_RADAR_NORMAL || $typegraphe_id==ALK_RADAR_SURFACIQUE || 
       $typegraphe_id==ALK_CAMMENB_BASIQUE || $typegraphe_id==ALK_CAMMENB_ECARTELE || $typegraphe_id==ALK_CAMMMENB_3D)
       $graphe_showvalues = 0;
       
    if($graphe_showvalues==1){
       $graph->setFontProperties($path_font.$graphe_titlefontstyle,8);   
       foreach($array_columns as $num){
         $graph->writeValues($DataSet->GetData(),$DataSet->GetDataDescription(),"Serie".$num);  
       }
    }
    // le titre
    $graph->setFontProperties($path_font.$graphe_titlefontstyle,intval($graphe_titlefontsize)); 
    $array_color = getRGB($graphe_titlefontcolor); 
    $graph->drawTextBox(30,5,$graphe_dimx-30,20,$graphe_title,0,$array_color[0],$array_color[1],$array_color[2],ALIGN_BOTTOM_CENTER,FALSE,255,255,255,30); 
  
    // un copyright
    if ($graphe_copyright!=""){
      // découpage 
      if(strlen($graphe_copyright)>($graphe_dimx*0.16)){
        $graphe_copyright = substr($graphe_copyright, 0, round($graphe_dimx*0.16))."\r\n".substr($graphe_copyright, round($graphe_dimx*0.16)+1, strlen($graphe_copyright));
      }
      $graph->setFontProperties($path_font.$graphe_titlefontstyle,7); 
      $graph->drawTextBox(30,$graphe_dimy-30,$graphe_dimx-30,$graphe_dimy-5,$graphe_copyright,0,0,0,0,ALIGN_TOP_LEFT,FALSE,255,255,255,30); 
    }
    // apercu de graphe depuis la liste
    if ($bApercu==1){
      $Cache->WriteToCache($graphe_id,$DataSet->GetData(),$graph); 
    }
    
    if($bStatic==1)
      $graph->Render(ALK_ALKANET_ROOT_PATH.Alkfactory::getUploadPath(ALK_ATYPE_ID_GRAPHE, true).$graphe_id.".png"); 
    
    if ($bStroke==1)
      $graph->Stroke();
  }
}

/**
 * retourne un taleau des 3 codes couleur
 * @param unknown_type $couleur
 */
function getRGB($couleur)
{
 $couleur = str_replace("#","",$couleur);
 $tabConfig = array("A"=>10, "B"=>11, "C"=>12, "D"=>13, "E"=>14, "F"=>15);
 
 if ($couleur !=""){
   $r=0;$g=0;$b=0;
   for($i=0;$i<strlen($couleur);$i++){
     $char = $couleur[$i];
     $val=-1;

     switch($i){
       case 0:
       case 2:
       case 4:
        if(in_array($char, array_keys($tabConfig))){
         $val = $tabConfig[$char]*16;
        }else{
         $val = intval($char)*16;
        }
         
        if($i==0)
         $r+=$val;
        else if($i==2)
         $g+=$val;
        else 
          $b+=$val;
        break;
       case 1:
       case 3:
       case 5:
        if(in_array($char, array_keys($tabConfig))){
         $val = $tabConfig[$char];
        }else{
         $val = intval($char);
        }
         
        if($i==1)
         $r+=$val;
        else if($i==3)
         $g+=$val;
        else 
          $b+=$val;
        break;
     }
   }
   
   return array($r,$g,$b);
 }else
   return"";
 }
 
/**
* retourne le fichier csv contenant la source
* @param $source_id
*/
function getSourceFileCvs($source_id)
{
  global $oQueryGraphe;
  $dsSource = $oQueryGraphe->getDsSourceById($source_id);
  $path_file = ALK_ALKANET_ROOT_PATH.AlkFactory::getUploadPath(ALK_ATYPE_ID_GRAPHE,true)."Data/";
  $strFileToUpload = ALK_ALKANET_ROOT_PATH.AlkFactory::getUploadPath(ALK_ATYPE_ID_GRAPHE,true)."Data/source_madefileXXX.csv"; // chemin du fichier à remplir par le contenu des url
  $data="";
  if (file_exists($strFileToUpload)) delFile($strFileToUpload);
  if($dr = $dsSource->getRowIter()){
    $typesource = $dr->getValueName("TYPESOURCE_ID");
    $url_service=$dr->getValueName("SOURCE_URLSERVICE");
    $url_widget=$dr->getValueName("SOURCE_URLWIDGET");
    $fichier_csv = $dr->getValueName("SOURCE_FILE");
    switch($typesource){
      case ALK_TYPESOURCE_FICHIERCSV:
        $data = $path_file.$fichier_csv; 
       break;
      case ALK_TYPESOURCE_URLSERVICE:
      case ALK_TYPESOURCE_URLWIGDET:
        $handleCsv = fopen ($strFileToUpload, "w");
        //fputcsv($handleCsv, split("\n",file_get_contents($url_service))); 
        file_put_contents($strFileToUpload, file_get_contents($url_service));
        $data = $strFileToUpload;
        fclose($handleCsv);
      break;
    }
  }
  return $data;
}
?>