<?php
include_once("../../lib/lib_session.php");
include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_file.php");

/** 
 * l'ajout de commantaire fonctionne
 * @todo Vérifier la modification
 */

// lecture de la licence
$strContentLic = "";
$strPathFileLic = ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE.ALK_ROOT_MODULE."licence.txt";
$hFile = @fopen($strPathFileLic, "r");
if( $hFile ) {
  $strContentLic = @fread($hFile, filesize($strPathFileLic));
  fclose($hFile);
} else {
  die("Impossible de lire le fichier de licence."); 
}

$tabSubDirModule = array("_admin/", "classes/", "lib/", "templates/");

// liste des modules où placer la licence
$tabModules = array(
  array("../index.php",    "Alkanet",                   "Page d'accueil extranet Alkanet."),
  array(ALK_ROOT_CLASSE."form/",    "Alkanet::Class::Form",     "Module fournissant les classes d'affichage Alkanet."),
  array(ALK_ROOT_CLASSE."pattern/", "Alkanet::Class::Pattern",  "Module fournissant les classes de base Alkanet."),
  array(ALK_ROOT_CLASSE."indexer/", "Alkanet::Class::Indexer",  "Module fournissant les classes pour le moteur d'indexation d'Alkanet."),
  array(ALK_ROOT_LIB,             "Alkanet::Library",         "Librairie js et php globale à Alkanet."),
  array(ALK_ROOT_CONF,         "Alkanet",                  "Projet Alkanet."),
  array(ALK_ROOT_MODULE."ident/",   "Alkanet",                  "Module fournissant l'interface d'authentification Alkanet."),
  array(ALK_ROOT_MODULE."annu/",    "Alkanet::Module::Annu",    "Module annuaire Alkanet."),
  array(ALK_ROOT_MODULE."espace/",  "Alkanet::Module::Espace",  "Module gestionnaire d'espaces."),
  array(ALK_ROOT_MODULE."alkanet/", "Alkanet::Module::Alkanet", "Module fournissant les pages adressables Alkanet."),
  array(ALK_ROOT_MODULE."cedit/",   "Alkanet::Module::CEdit",   "Module consultation éditoriale.."),
  array(ALK_ROOT_MODULE."iedit/",   "Alkanet::Module::IEdit",   "Module information éditoriale."),
  array(ALK_ROOT_MODULE."gedit/",   "Alkanet::Module::GEdit",   "Module gestion éditoriale."),
  array(ALK_ROOT_MODULE."editeur/", "Alkanet::Module::Editeur", "Module éditeur basé sur fckeditor."),
  array(ALK_ROOT_MODULE."fdoc/",    "Alkanet::Module::FDoc",    "Module fonds documentaire."),
  array(ALK_ROOT_MODULE."crv/",     "Alkanet::Module::Crv",     "Module circuit de validation."),
  array(ALK_ROOT_MODULE."forum/",   "Alkanet::Module::Forum",   "Module forum."),
  array(ALK_ROOT_MODULE."form/",    "Alkanet::Module::Form",    "Module formulaire."),
  array(ALK_ROOT_MODULE."sigadmin/","Alkanet::Module::SigAdmin","Module de base SIG."),
  array(ALK_ROOT_MODULE."sigsite/", "Alkanet::Module::SigSite", "Module de consultation SIG."),
  array(ALK_ROOT_MODULE."atlas/",   "Alkanet::Module::Atlas",   "Module cartothèque SIG."),
  array(ALK_ROOT_MODULE."grr/",     "Alkanet::Module::GRR",     "Module gestion réservation de ressources."),
  array(ALK_ROOT_MODULE."lsdif/",   "Alkanet::Module::LsDif",   "Module liste de diffusion."),
  array(ALK_ROOT_MODULE."search/",  "Alkanet::Module::Search",  "Module fournissant les interfaces de recherche."),
  array(ALK_ROOT_MODULE."synd/",  "Alkanet::Module::Synd",    "Module diffusion de circulaires."),
  );
  
$nbTotFile = 0;
$sizeTotFile = 0;

/**
 * Traitement d'un fichier
 */
function addLicenceToFile($strPathFileName, $strContentLic)
{
  global $nbTotFile, $sizeTotFile;
  
  $hFile = fopen($strPathFileName, "r");
  if( $hFile ) {
    $iSize = filesize($strPathFileName);
  	$strContent = @fread($hFile, $iSize);
  	fclose($hFile);
  	if( trim($strContent) == "" ) return; 
    $sizeTotFile += $iSize;
    
    $strHeader = "";
    switch( mb_substr($strPathFileName, -3) ) {
    case "php":
  	  // suppression de la license précédente
      $strHeader = "<?php\n";
      $strContent = mb_ereg_replace("<\?php\\n\/\*licence\/.*\/licence\*\/\\n", "", $strContent);
      $strContent = mb_substr($strContent, mb_strlen($strHeader));
      break;
    case ".js":
	  // suppression de la license précédente
      $strContent = mb_ereg_replace("\/\*licence\/.*\/licence\*\/\\n", "", $strContent);
      break;

    case "htm":
    case "tml":
	  $strContentLic = "<!--".$strContentLic."-->";
	  // suppression de la license précédente
      $strContent = mb_ereg_replace("<!--\*\/\*licence\/.*\/licence\*\/-->\\n", "", $strContent);
      break;
  	  
  	case "tpl":
  	  $strContentLic = "{*".$strContentLic."*}";
  	  // suppression de la license précédente
        $strContent = mb_ereg_replace("{\*\/\*licence\/.*\/licence\*\/\*}\\n", "", $strContent);
  	  break;
  	}
  	$strContent = $strHeader.$strContentLic."\n".$strContent;
  	
    /** @todo : laisser commenter dans cvs pour éviter les accidents */
  	/*$hFile = fopen($strPathFileName, "w");
  	fwrite($hFile, $strContent);
  	fclose($hFile);*/
  	echo $sizeTotFile." ".(++$nbTotFile)." ".$strPathFileName."<br>";
  }
}

/**
 * Lecture des fichiers d'un répertoire
 */
function addLicenceToDir($strPath, $strContentLic)
{
  $tabFiles = getTabFilesByDir($strPath, array("php", "html", "htm", "js", "tpl"), false, array(), true);
  foreach($tabFiles as $strPathFileName) {
    addLicenceToFile($strPathFileName, $strContentLic);
  }
}

/**
 * Parcours des modules
 */
foreach($tabModules as $tabModule) {
  $strPath       = ALK_ALKANET_ROOT_PATH.$tabModule[0];
  $strModuleName = $tabModule[1];
  $strModuleDesc = $tabModule[2];
  
  $strContentLicModule = mb_ereg_replace("\[moduleName\]", $strModuleName, $strContentLic);
  $strContentLicModule = mb_ereg_replace("\[moduleDesc\]", $strModuleDesc, $strContentLicModule);
  
  if( file_exists($strPath) && is_file($strPath) ) {
    addLicenceToFile($strPath, $strContentLicModule);
  } elseif( file_exists($strPath) && is_dir($strPath) ) {
    addLicenceToDir($strPath, $strContentLicModule);
    foreach($tabSubDirModule as $strSubDir ) {
      addLicenceToDir($strPath.$strSubDir, $strContentLicModule);
    }
  }
}

echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> 
<html>
<head>
  <meta http-equiv=\"content-type\" content=\"text/html; charset=".ALK_HTML_ENCODING."\" />
  <link rel='stylesheet' href='styles/sit.css' type='text/css'/>
  <title>Administration Alkanet</title>
</head>
<body style='margin:10px'><div class='divContenuTexte'>Opération terminée.</div></body></html>";
?>
