<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


/** 
 * @file lib_session.php
 * @package Alkanet_Library
 * @brief Charge les fichiers de définition de constantes et vérifie l'état de session
 */

session_start();

ini_set("display_errors", "on");
error_reporting(E_ALL);

/** Chargement des fichiers de config */
require_once("../../"."libconf/app_conf.php");
require_once(ALK_ALKANET_ROOT_PATH."lib/app_conf_alkanet.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."app_conf_sig.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkrequest.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_locales.php");

/** Gestion des langues */
initAlkLocale();

/**
 * @brief Controle de sécurité
 */

/** $tabFileSession est déclaré dans app_conf_alkanet.php */

$PHP_SELF = $_SERVER["PHP_SELF"];
$strPageCur = substr($PHP_SELF, 1); // enleve le premier caractère = /

/** evite d'afficher la popup d'identification pour les pages suivantes */
$bTestPage = true;
if( isset($tabFileSession) && is_array($tabFileSession) ) {
  foreach($tabFileSession as $strFileName) {
    $bTestPage = $bTestPage && ( strpos($strPageCur, $strFileName)===false );
  }
}

$_SESSION["alk_idUser"] = ALK_USER_ID_ADMINALK;
$_SESSION["alk_idAbonne"] = 1;
$_SESSION["alk_pseudoAbonne"] = "alkante";
$_SESSION["alk_idProfil"] = 1;
$_SESSION["alk_idService"] = 2;
$_SESSION["alk_idDept"] = 0;
$_SESSION["alk_userPriv"] = ALK_PRIV_ANNU_ALL+ALK_PRIV_SPACE_ADMIN;
$_SESSION["alk_userLogin"] = "alkante";
$_SESSION["alk_userPwd"] = "";
$_SESSION["alk_userName"] = "Administrateur Alkante";
$_SESSION["alk_userFirstName"] = "Administrateur";
$_SESSION["alk_userLastName"] = "Alkante";
$_SESSION["alk_userMail"] = "p.cliquet@alkante.com";
$_SESSION["alk_userHome"] = "#";
$_SESSION["alk_idPerf"] = "-1";
$_SESSION["alk_serviceName"] = "Partenaires"; 
$_SESSION["alk_serviceSigle"]= "PART";

$bUserInternetExists = !( !defined("ALK_B_USER_INTERNET_EXISTS") || 
                          defined("ALK_B_USER_INTERNET_EXISTS") && !ALK_B_USER_INTERNET_EXISTS );

if( $bTestPage ) {
  if( !(isset($_SESSION["alk_idUser"]) && is_numeric($_SESSION["alk_idUser"]) &&
        ( !$bUserInternetExists && $_SESSION["alk_idUser"]!=ALK_USER_ID_INTERNET || $bUserInternetExists )) ) {
    echo "<html><head>".
      "<script type='text/javascript' src='../../lib/lib_js.js'></script>".
      "<script type='text/javascript'>".
      " /*ALK_RECONNECT | top.window.location = '/index.php?err=2&url=".AlkRequest::getEncodeParam($_SERVER["REQUEST_URI"])."'; */".
      " function OpenWindowLogin() {".
      "   if( !closeAllWindow('/index.php?err=2&url=".AlkRequest::getEncodeParam($_SERVER["REQUEST_URI"])."') )".
      "     top.window.location = '/index.php?err=2&url=".AlkRequest::getEncodeParam($_SERVER["REQUEST_URI"])."';".
      " }".
      "</script></head>".
      "<body onload=\"OpenWindowLogin()\"></body>".
      "</html>";
    exit();
  }
} else {
  /** @todo : vérifier la sécurité */
  if( !$bUserInternetExists && !isset($_SESSION["alk_idUser"]) ) {
    /* connexion internet */
    $_SESSION["alk_idUser"] = ALK_USER_ID_INTERNET;
    $_SESSION["alk_idAbonne"] = -1;
    $_SESSION["alk_pseudoAbonne"] = "";
    $_SESSION["alk_idProfil"] = 1;
    $_SESSION["alk_idService"] = 2;
    $_SESSION["alk_idDept"] = 0;
    $_SESSION["alk_userPriv"] = ALK_PRIV_SPACE_USER;
    $_SESSION["alk_userLogin"] = "";
    $_SESSION["alk_userPwd"] = "";
    $_SESSION["alk_userName"] = "Visiteur Internet";
    $_SESSION["alk_userMail"] = "";
    $_SESSION["alk_userHome"] = "#";
    $_SESSION["alk_serviceName"] = ""; 
    $_SESSION["alk_serviceSigle"]= "";
    $_SESSION["alk_idPerf"] = "-1";
  }
}

/** Chargement des classes de bases */
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkfactory.class.php");
require_once ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkmailing.class.php";
if( strpos($strPageCur, "/alkanet_sql.php")===false ) {
  require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlfactory.class.php");
} 
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_file.php");

/** Chargement ensuite du lib_global et du app_conf_sgbd : 
 *   - chargement des constantes générales + espace + annu + celles de l'appli utilisée 
 */
AlkFactory::setSProperty("user_id",    $_SESSION["alk_idUser"]);
AlkFactory::setSProperty("abonne_id",     $_SESSION["alk_idAbonne"]);
AlkFactory::setSProperty("abonne_pseudo", $_SESSION["alk_pseudoAbonne"]);
AlkFactory::setSProperty("profil_id",  $_SESSION["alk_idProfil"]);
AlkFactory::setSProperty("service_id", $_SESSION["alk_idService"]);
AlkFactory::setSProperty("dept_id",    $_SESSION["alk_idDept"]);
AlkFactory::setSProperty("service_name",  $_SESSION["alk_serviceName"]);
AlkFactory::setSProperty("service_sigle", $_SESSION["alk_serviceSigle"]);
AlkFactory::setSProperty("user_priv",  $_SESSION["alk_userPriv"]);
AlkFactory::setSProperty("user_right", ALK_APPLI_RIGHT_NONE);
AlkFactory::setSProperty("user_login", $_SESSION["alk_userLogin"]);
AlkFactory::setSProperty("user_pwd",   $_SESSION["alk_userPwd"]);
AlkFactory::setSProperty("user_name",  $_SESSION["alk_userName"]);
AlkFactory::setSProperty("user_mail",  $_SESSION["alk_userMail"]);
AlkFactory::setSProperty("user_home",  $_SESSION["alk_userHome"]);
AlkFactory::setSProperty("perf_id",    $_SESSION["alk_idPerf"]);

AlkFactory::setSProperty("bInternet",  (!$bUserInternetExists && $_SESSION["alk_idUser"] == ALK_USER_ID_INTERNET) );
                                        
?>