﻿<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet
Projet Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * @file app_conf.php
 * @package Alkanet_Appli
 * 
 * @brief  liste de constantes spécifiques à l'implentation de l'application
 */

/** nom de la page d'identification dans scripts/ident/ */
//define("ALK_INDEX_AUTH", "index.php");
define("ALK_INDEX_AUTH", "scripts/alkanet/index.php");
/** nom de la css par défaut */
define("ALK_DEFAULT_CSS", "alkanetadmininternet_v2.css");
/** nom du template par défaut */
define("ALK_DEFAULT_TEMPLATE", "Admininternet_v2");

define("ALK_B_CSSJS_MINIMIZE", false);
define("ALK_VIRTUAL_DIR", "/");

/** utilisation d'un cookie pour mémoriser l'authentification avec délai d'expiration en minute */
define("ALK_B_COOKIE", true);
define("ALK_COOKIE_EXPIRE", 60*24*30*6);

/** Type d'authentification */
define("ALK_AUTH_ALKANET",     1);
define("ALK_AUTH_LDAP",        2);
define("ALK_AUTH_SSO",         3);
define("ALK_AUTH_NTLM_NAV",    4);
define("ALK_AUTH_NTLM_APACHE", 5);

/** Type d'authentification utilisé */
define ("ALK_AUTH", ALK_AUTH_ALKANET);

/** chargement des constantes SGBD */
define("ALK_B_SGBD_CONSTANT", true);

/** Type de SGBD possible */
define("ALK_SGBD_ORACLE",   "oracle");
define("ALK_SGBD_MYSQL",    "mysql");
define("ALK_SGBD_POSTGRES", "postgres");

// type SGBD spatial
define("ALK_SIGBD_ORACLESDE", ALK_SGBD_ORACLE);
define("ALK_SIGBD_MYGIS",     ALK_SGBD_MYSQL);
define("ALK_SIGBD_POSTGIS",   ALK_SGBD_POSTGRES);

/** Type de SGBD utilisé */
define("ALK_BDD_TYPE", ALK_SGBD_POSTGRES);

/** Encodage client SGBD */
define("ALK_SGBD_ENCODING", "UTF-8");
define("ALK_MAIL_ENCODING", "UTF-8");

/** Utilisation d'une base spatiale : oui ou non */
define("ALK_SIGBD", true);

/** Type de SIG BD utilisé */
define("ALK_SIGBD_TYPE", ALK_SIGBD_POSTGIS);

/** paramètres de connexion Oracle */
define("ALK_ORA_LOGIN", "");
define("ALK_ORA_PWD",   "");
define("ALK_ORA_SID",   "");

/** paramètres de connexion Mysql */
define("ALK_MYSQL_LOGIN", "");
define("ALK_MYSQL_HOST",  "localhost");
define("ALK_MYSQL_PWD",   "");
define("ALK_MYSQL_BD",    "");
define("ALK_MYSQL_PORT",  "3306");
 
/** paramètres de connexion Postgres */
define("ALK_POSTGRES_LOGIN", "user_crbn");
define("ALK_POSTGRES_HOST",  "localhost");
define("ALK_POSTGRES_PWD",   "pass_crbn");
define("ALK_POSTGRES_BD",    "alk_crbn");
define("ALK_POSTGRES_PORT",  "5432");


/** paramètres de connexion Prodige */
define("ALK_PRODIGE_LOGIN", "prodige");
define("ALK_PRODIGE_HOST",  "localhost");
define("ALK_PRODIGE_PWD",   "prodige");
define("ALK_PRODIGE_BD",    "PRODIGE");
define("ALK_PRODIGE_PORT",  "5432");
define("ALK_PRODIGE_SCHEMA",  "public");


/** paramètres de connexion MNOGOSEARCH */
define("ALK_MNOGOSEARCH_LOGIN", "user_crbn");
define("ALK_MNOGOSEARCH_HOST",  "localhost");
define("ALK_MNOGOSEARCH_PWD",   "pass_crbn");
define("ALK_MNOGOSEARCH_BD",    "alk_crbn");
define("ALK_MNOGOSEARCH_PORT",  "5432");

/** nom des schémas utilisés : préfixe de table */
define("ALK_SGBD_SCHEMA",   "alkanet");
define("ALK_SIGBD_SCHEMA",  "alkarto");

/** Utilisation de LDAP : oui ou non, liaison fiche annuaire */
define("ALK_LDAP", false);

/** utilisation d'ACTIVEDIRECTORY comme annuaire ldap */
define("ALK_B_LDAP_AD", false);

/** Paramètres de connexion LDAP */
define("ALK_LDAP_HOST",               "");
define("ALK_LDAP_PORT",               "");
define("ALK_LDAP_ACCOUNT_SUFFIX",     "");
define("ALK_LDAP_BASE_DN",            "");
define("ALK_LDAP_USER",               "");
define("ALK_LDAP_PWD",                "");
define("ALK_LDAP_NAME",               "");
define("ALK_LDAP_ENCODING",           "UTF-8");
define("ALK_LDAP_VERIF_LOGIN",        false);

define("ALK_LDAP_AD_DOMAIN_NAME",   "");
define("ALK_LDAP_AD_DOMAIN",        "");
define("ALK_LDAP_AD_DOMAIN_INVITE", "");
define("ALK_LDAP_AD_SERVER_AUTH",   "Digest");

define("ALK_LDAP_BASE_DN_NODE",        "");
define("ALK_LDAP_BASE_DN_NODE_SERV",   "");
define("ALK_LDAP_BASE_DN_NODE_AGENTS", "");

  
/** association champ ldap avec l'annuaire Alkanet, 
 * - le premier champ caractérise la clé primaire ldap, ici : mail 
 * - le second caractérise la clé identifiant le service, ici departmentnumber
 * - le troisième caractérise le DN de l'info 
 */
define("ALK_LDAP_ASSOC_ANNU", 
       serialize(array("mail"                     => array("table" => "SIT_AGENT",   "field" => "AGENT_MAIL"),
                       "memberof"                 => array("table" => "SIT_SERVICE", "field" => "SERVICE_LDAPUID"),
                       "dn"                       => array("table" => "",            "field" => "DN"),
                       "initials"                 => array("table" => "SIT_AGENT",   "field" => "AGENT_CIVILITE"),
                       "sn"                       => array("table" => "SIT_AGENT",   "field" => "AGENT_NOM"),
                       "samaccountname"           => array("table" => "SIT_AGENT",   "field" => "AGENT_LOGIN"),
                       "givenname"                => array("table" => "SIT_AGENT",   "field" => "AGENT_PRENOM"), 
                       "homephone"                => array("table" => "SIT_AGENT",   "field" => "AGENT_TEL"),
                       "facsimiletelephonenumber" => array("table" => "SIT_AGENT",   "field" => "AGENT_FAX"),
                       "mobile"                   => array("table" => "SIT_AGENT",   "field" => "AGENT_MOBILE"),
                       "ipphone"                  => array("table" => "SIT_AGENT",   "field" => "AGENT_PHOTO"),
                       "description"              => array("table" => "SIT_AGENT",   "field" => "AGENT_FONCTION"),
                       "info"                     => array("table" => "SIT_AGENT",   "field" => "AGENT_DESC"),
                       "streetaddress"            => array("table" => "SIT_ADRESSE", "field" => "ADR_ADR1"),
                       "postalcode"               => array("table" => "SIT_ADRESSE", "field" => "ADR_POST"),
                       "l"                        => array("table" => "SIT_ADRESSE", "field" => "ADR_VILLE"),                       
                       "name"                     => array("table" => "SIT_SERVICE", "field" => "SERVICE_INTITULE"),
                       )));

/** Sous-répertoire contenant le si */
define("ALK_ROOT_DIR", "/");

/** paramètre SSO */
if( ALK_AUTH == ALK_AUTH_SSO ) {
  define ("ALK_SSO_URL",     "");
  define("ALK_SSO_URL",      "");
  define("ALK_SSO_PORT",   7071);
  define("ALK_SSO_URI",      "");
  define("ALK_SSO_REDIRECT", "");  
}

/** constantes de recherche */
define("ALK_SEARCH_ALKANET", 0);
define("ALK_SEARCH_SOLR",    1);

define("ALK_SEARCH", ALK_SEARCH_ALKANET); 

if( ALK_SEARCH == ALK_SEARCH_SOLR ) {
  define("ALK_SOLR_SERVER",   "");
  define("ALK_SOLR_PORT",   8983);
  define("ALK_SOLR_USER",     "");
  define("ALK_SOLR_PASSWORD", ""); 
  define("ALK_SOLR_PATH", "");
}

/** Adresse mail administrateur */
define("ALK_MAIL_ADMIN_MAIL",  "contact@etudes.fr");
define("ALK_MAIL_ADMIN_NAME",  "ETUDES");
define("ALK_MAIL_ADMIN_SIGNATURE", "");
define("ALK_MAIL_MAX_SEND", 50);
define("ALK_MAIL_SENDER", "ETUDES");  // permet d'identifier le site qui envoi le mail dans les logs système;
define("ALK_MAIL_NOREPLY_MAIL", "no-reply@domaine.com");
define("ALK_MAIL_NOREPLY_NAME", "Ne pas répondre svp");
define("ALK_MAIL_NOREPLY", "no-reply@domaine.com");
define("ALK_MAIL_REPLY_ERR", "");    // adresse de retour en cas d'erreur, adresse de reply-eur sinon, pas de retour sinon
define("ALK_MAIL_ADMIN_LG", "fr_FR");
/**
 * Détermine si le frontoffice et le backoffice sont sur le même domaine
 * true  : si le back-office est présent sur le même domaine que le front-office
 * false : si les domaines sont différents. Dans ce cas, la partie authentification est bloquée avec l'url front-office
 */
define("ALK_B_SAMEDOMAIN", true);
/** URL de base du si */
// host du front office
// nécessaire de fournir une url par défaut pour éviter les warning en mode php cli
$strHostFrontOffice =  "http://www.mondomaine.fr";
$strHostBackOffice = ( ALK_B_SAMEDOMAIN == true
                       ? $strHostFrontOffice
                       : "" );

$strCurrentHost = ( isset($_SERVER["HTTP_HOST"]) 
                    ? ( isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"]=="on" ? "https" : "http")."://".$_SERVER["HTTP_HOST"] 
                    : $strHostFrontOffice );
                    
/** stockage de l'url du front office **/
define("ALK_VIRTUAL_DIR_FRONTOFFICE", "/");
define("ALK_ALKANET_ROOT_URL_FRONTOFFICE", $strHostFrontOffice.ALK_VIRTUAL_DIR_FRONTOFFICE);

// clé memcache pour unifier les 2 domaines lorsque ALK_B_SAMEDOMAIN=false
define("ALK_ROOT_URL_MEMCACHE", $strHostFrontOffice);

// host du site back-office
define("ALK_ROOT_URL_BACKOFFICE", $strHostBackOffice);
define("ALK_ROOT_URL_FRONTOFFICE", $strHostFrontOffice);
define("ALK_ROOT_URL", $strCurrentHost);
define("ALK_ROOT_PDF_URL", $strCurrentHost);

/** Chemin de base du SI */
define("ALK_ROOT_PATH", mb_ereg_replace(ALK_ROOT_DIR."libconf/app_conf.php", "", str_replace("\\", "/", __FILE__)));

define ("ALK_ANNU_LG_MIN_PWD", 6);
/** Sous-répertoire contenant le repertoire upload */
define("ALK_ROOT_UPLOAD", "upload/");

/** Url et chemin de base Alkanet */
define("ALK_ALKANET_ROOT_PATH", ALK_ROOT_PATH.ALK_ROOT_DIR);
define("ALK_ALKANET_ROOT_URL",  ALK_ROOT_URL.ALK_ROOT_DIR);

/** chemin relatif de base pour les images */
define("ALK_MEDIA_PATH", ALK_ROOT_DIR."media/");

/** adresse de base pour les images */
define("ALK_MEDIA_URL", ALK_ALKANET_ROOT_URL."media/");

/** url du lecteur de flux RSS */
define("ALK_RSS_READER_URL", "http://rss.alkante.com/");

/** identifiant utilisateur spécifique */
define("ALK_USER_ID_ADMINALK", 1);
define("ALK_USER_ID_INTERNET", 2);
define("ALK_B_USER_INTERNET_EXISTS", true);
define("ALK_B_USER_INTERNET_CANCONNECT_ALKANET", true);

// ce paramètre permet à alkanet_verif.php d'authoriser l'authentification à un utilisateur
// ayant un compte valide, non autorisé au backoffice. Utile pour les extranet type internet authentifié.
// nécessite de fournir à alkanet_verif.php, le paramètre url
define("ALK_B_USER_CANCONNECT_EXTRANET", false);

/** Gestion des erreurs */
define("ALK_ERROR_B_LOG",      false);
define("ALK_ERROR_LOG_SCREEN", 1);
define("ALK_ERROR_LOG_FILE",   2);
define("ALK_ERROR_LOG_MAIL",   4);

/** Mode de gestion des erreurs */
define('ALK_ERROR_GEST', ALK_ERROR_LOG_SCREEN+ALK_ERROR_LOG_MAIL);

/** Integration de la trace d'exécution dans les rapports d'erreur
 *  0 : pas de trace d'execution de la pile
 *  1 : trace d'execution de la pile des variables 
 */
define("ALK_ERROR_DEBUG", 1);

/** Destinataire des logs : mail ou fichier */
define("ALK_ERROR_DEST_MAIL",     "support@etudes.com");
define("ALK_ERROR_DEST_PATHFILE", ALK_ROOT_PATH.ALK_ROOT_DIR."upload/log/");
define("ALK_ERROR_DEST_FILENAME", "errlog.txt");

/** Activation=true/Désactivation=false du mode débug */
define("ALK_DEBUG", false);

/** Activation=false/Désactivation=true de l'envoi de mail */
define("ALK_DEBUG_MAIL", false);

/** Activation=false/désactivation=true de tous les modes caches: memcache / smarty / css / js */
define("ALK_DEBUG_CACHE_MEMCACHE", false);
define("ALK_DEBUG_CACHE_TEMPLATE", false);
define("ALK_DEBUG_CACHE_JS", false);
define("ALK_DEBUG_CACHE_CSS", false);

/** activation des popus jQuery**/
define("ALK_B_POPUP_JQUERY", true);

/** Activation stats appli */
define("ALK_B_SPACE_STAT_APPLI", true);

/** déclaration générale des langues*/
$GLOBALS["tabLg"] = array("backoffice"  => array(0 => "fr"),
                          "frontoffice" => array(0 => "fr" ));
$GLOBALS["tabLocales"] = array("backoffice"  => array(0 => "fr_FR"), 
                               "frontoffice" => array(0 => "en_GB", 1=>"fr_FR", 2=>"es_ES", 3=>"pt_PT"),
                               "mail"        => array(0 => "en_GB", 1=>"fr_FR"));

/*$GLOBALS["tabStrLocales"] = array("en_GB" => "anglais - Grande Bretagne",
                                  "fr_FR" => "français - France",
                                  "es_ES" => "espagnol - Espagne",
                                  "pt_PT" => "portugais - Portugal");*/
$GLOBALS["tabStrLocales"] = array("fr_FR" => "français - France");


/** tableau exhaustif des listes de titre de blocs **/
$tabBlocTitle = null; //array(ALK_KEYWORD_BLOC_FLASH_INFO            => "Flash info");

/** tableau de déclinaison des images */
/** seul les fichiers *.jpg, *.gif et *.png peuvent être redimendionnés */
/** A chaque fois qu'une image va être uploadée elle va être déclinée en autant de version */
/** ex: l'image uplopadée se nomme image.jpg */
/** elle va être déclinée en image_xsmall.jpg, image_small.jpg, image_medium.jpg ... */
/** les proportions de l'image sont conservées et l'application essaye de générer l'image la plus grande possible en fonction des dimensions renseignées */ 
$tabImageSizeOverride = array("small" => array ("width"=>"119", "height"=>""),
                              "medium" => array ("width"=>"250", "height"=>""),
                              "large" => array ("width"=>"548", "height"=>""));

define("ALK_SECURITY_LETTERS", "123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");

define("ALK_GEOLOC_GOOGLE_KEY", "ABQIAAAAiEnZtqUQVm_uT69LswuHHxSR88ybvm2a3lN0GtWPeELZn6hqlBSaAryRqHSWccelRgIHweaIiro-qw");

/**
 * tableau des champs détaillés utilisés pour les pièces jointes
 * Remarque : s'assurer que les champs existent en base de données pour les modules IEDIT, COMMENT et FORUM
 * label : string label du champ
 * field : string nom du champ en base de données (obligatoire)
 * type : string type du champ pour validation javascript, doit correspondre à ceux utilisé dans la méthode AlkVerifCtrl ("text", "date10", ... obligatoire)
 * code_iptc : string code du tag IPTC correspondant au champ (optionnel, chaine vide si aucune correspondance IPTC)
 * row : integer nombre de ligne du contrôle (=1 : <input type=text>, >1 : <textarea>) (obligatoire)
 * column : integer nombre de colonnes du contrôle, peut être redéfini par l'application en fonction de l'espace disponible (obligatoire)
 * value : mixed valeur par défaut si non trouvé dans métadonnées IPTC (optionnel)
 * tabValTxt : array tableau des valeurs possibles (optionnel, obligatoire pour le type "select")
 * min : mixed valeur min (optionnel)
 * max : mixed valeur max (optionnel)
 */

// pas demander la traduction ici, la locale n'étant pas encore sélectionnée
$tabPJDetails = array(
  array("label" => "Date", 
        "field" => "pj_datecreafile", 
        "type" => "date10", "required" => false, "readOnly" => false, "code_iptc" => "2#055", "row" => 1, "column" => 40, "min" => "00/00/0000", "value"=> ""),
  array("label" => "Titre", 
        "field" => "pj_title", 
        "type" => "text", "required" => false, "readOnly" => false, "code_iptc" => "2#005", "row" => 1, "column" => 40, "max" => 64, "value"=> ""),
  array("label" => "Copyright", 
        "field" => "pj_copyright", 
        "type" => "text", "required" => false, "readOnly" => false, "code_iptc" => "2#116", "row" => 1, "column" => 40, "max" => 128, "value"=> ""),
  array("label" => "Auteur", 
        "field" => "pj_auteur", 
        "type" => "text", "required" => false, "readOnly" => false, "code_iptc" => "2#122", "row" => 1, "column" => 40, "max" => 32, "value"=> ""),
  array("label" => "Description", 
        "field" => "pj_desc", 
        "type" => "text", "required" => false, "readOnly" => false, "code_iptc" => "2#120", "row" => 4, "column" => 38, "max" => 2000, "value"=> ""),
  array("label" => "Mots-clés", 
        "field" => "pj_keywords", 
        "type" => "text", "required" => false, "readOnly" => false, "code_iptc" => "2#025", "row" => 1, "column" => 40, "max" => 64, "value"=> ""),
  array("label" => "Langue", 
        "field" => "pj_lang", 
        "type" => "select", "required" => false, "readOnly" => false, "code_iptc" => "", "row" => 1, "column" => 38, "tabValTxt" => $GLOBALS["tabLg"], "value"=> ""),
);

/**
 * tableau des extensions de fichier pris en charge par le reader de l'aaplication collab
 */
$tabCollabFileExtensionReadable = array("jpg", "jpeg", "gif", "png", "tif", "bmp",
                                        "flv", "mp4", "mov", "wmv",
                                        "mp3",
                                        "swf");
// valeur de l'id de la région dans la table des commune pour identifier le carctere regional
define("VAL_ID_REGION", "25");
?>
