<?php
require_once(ALK_ALKANET_ROOT_PATH."classes/form/alkhtmlpagesite.class.php"); 
//require_once(ALK_ALKANET_ROOT_PATH."classes/indexer/alkhtdig.class.php");
require_once(ALK_ALKANET_ROOT_PATH."libconf/lib/lib_date.php"); 

/**
 * @file alkhtmlpagesitealk.class.php
 * @class AlkHtmlPageSiteAlk
 * @package Alkanet_Appli
 * @brief Classe représentant la page html pour la partie site internet
 */
class AlkHtmlPageSiteAlk extends AlkHtmlPageSite
{

  /**
   * @brief constructeur par défaut
   *
   */
  public function __construct(&$oSpace, &$oAppli)
  {
    parent::__construct($oSpace, $oAppli);

    $user_id = AlkFactory::getSProperty("user_id", ALK_USER_ID_INTERNET); 
    
    $this->setTitle(ALK_APP_TITLE);
    $this->setEncoding(ALK_HTML_ENCODING);
    $this->addMeta("language", "FR");
    $this->addMeta("Publisher", ALK_APP_TITLE);
    $this->addMeta("Creator", "Alkante");
    
    $this->addLink("icon", ALK_MEDIA_PATH."site/favicon.png");
    
    $this->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_formcheck.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_formdate.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_formnumber.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_formselect.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_form.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_formtxt.js");
    
    $this->addVarJs("ALK_APPLI_TOKEN", "'".AlkRequest::getEncodeParam("cont_id=".$this->oAppli->cont_id."&appli_id=".$this->oAppli->appli_id)."'");
    $this->addVarJs("ALK_CONT_ID", "'".$this->oAppli->cont_id."'");
    $this->addVarJs("ALK_APPLI_ID", "'".$this->oAppli->appli_id."'");
    
    $iTypeSheet = AlkRequest::getToken("iTypeSheet", ALK_TYPESHEET_CONSULT);
    $strPopup = ( $iTypeSheet == ALK_TYPESHEET_POPUP ? "_popup" : "" );
    if( $iTypeSheet == ALK_TYPESHEET_POPUP ) {
      $strPopup = "_popup";
      $this->addClassCss("body", "background-color:#ffffff;");
    } else {
      $strPopup = "";
    }
  }
  
  /**
   * @brief Retourne le code html du contenu de la page
   * @return string
   */
  protected function initBody()
  {
    parent::initBody();
    $this->addScriptJs(ALK_ALKANET_ROOT_URL."libconf/lib/jquery-1.9.1.js");
  }
}
?>