<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


/**
 * @file lib_llocale.php
 * @package Alkanet_Library
 * @brief Ensemble des fonctions sur la gestion de traduction
 *        Attention : ces fonctions ne doivent être appelées qu'après appel de AlkFactory::initLocale();
 */

$GLOBALS["ALK_GT_START"] = '';
$GLOBALS["ALK_GT_END"] = '';

/**
 * Initialise la prise en change de la langue et de la locale courante
 */
function initAlkLocale()
{
  global $bFrontOffice;
  
  /** initialisation par défaut si non spécifié dans app_conf.php */
  $GLOBALS["_LG_tab_langue"] = array();
  if( !isset($GLOBALS["tabLg"]) ) {
    $GLOBALS["tabLg"] = array("backoffice"  => array(0 => "fr"), 
                              "frontoffice" => array(0 => "fr"));
  }
  if( !isset($GLOBALS["tabLocales"]) ) {
    $GLOBALS["tabLocales"] = array("backoffice"  => array(0 => "fr_FR"), 
                                   "frontoffice" => array(0 => "fr_FR"),
                                   "mail"        => array(0 => "fr_FR"));
  }
  if( !isset($GLOBALS["tabStrLocales"]) ) {
    $GLOBALS["tabStrLocales"] = array("fr_FR" => "français - France");
  }
  
  /** détermination type interface */
  $bFrontOffice = ( defined("ALK_ROOT_URL_FRONTOFFICE") 
                   ? ( ALK_ROOT_URL_FRONTOFFICE==ALK_ROOT_URL ? true : false )
                   : false ); 
  
  $strKey = ( $bFrontOffice ? "frontoffice" : "backoffice" );
  foreach($GLOBALS["tabLg"][$strKey] as $iKey => $strLg) {
    define("ALK_LG_".strtoupper($strLg), $iKey);
    $GLOBALS["_LG_tab_langue"][$iKey] = array("bdd" => "_".strtoupper($strLg), "rep" => $strLg);
  }
   
  /** Langue sélectionnée */
  if( isset($_GET["lg"]) && $_GET["lg"]!="" && 
      is_numeric($_GET["lg"]) && $_GET["lg"]>=0 && $_GET["lg"]<count($GLOBALS["tabLg"]) ) {
    if( $bFrontOffice  ) { 
      $_SESSION["ALK_LG_INTERNET"] = $_GET["lg"];
    } else {
      $_SESSION["ALK_LG"] = $_GET["lg"];
    }
  } 
  
  /** langue sélectionnée côté Front Office */
  if( !isset($_SESSION["ALK_LG_INTERNET"]) ) {
    $_SESSION["ALK_LG_INTERNET"] = 0;
  }
  
  /** langue sélectionnée côté Back Office */
  if( !isset($_SESSION["ALK_LG"]) ) {
    $_SESSION["ALK_LG"] = 0;
  }
  
  /** variable de gestion I18N */
  if( !defined("ALK_LG_CATEGORY") ) {
    if (isset($_SERVER['SERVER_SOFTWARE'])){
      if( preg_match("/Win32/", $_SERVER['SERVER_SOFTWARE']) > 0 ) {
        define("ALK_LG_CATEGORY", "LC_ALL");
      } else {
        define("ALK_LG_CATEGORY", "LC_MESSAGES");
      }
    }else {
      define("ALK_LG_CATEGORY", "LC_MESSAGES");
    }
  }  
  
  $strLocaleBackOffice = ( isset($GLOBALS["tabLocales"]["backoffice"][$_SESSION["ALK_LG"]]) 
                           ? $GLOBALS["tabLocales"]["backoffice"][$_SESSION["ALK_LG"]]
                           : $GLOBALS["tabLocales"]["backoffice"][0] );
  $bRes = setlocale(constant(ALK_LG_CATEGORY), $strLocaleBackOffice);
  if( $bRes === false ) {
    // arrive si la locale n'est pas installée (retour de setlocale())
    setlocale(constant(ALK_LG_CATEGORY), $GLOBALS["tabLocales"]["backoffice"][0]);
    $_SESSION["ALK_LG_LOCALE"] = $GLOBALS["tabLocales"]["backoffice"][0];
  } else {
    $_SESSION["ALK_LG_LOCALE"] = $strLocaleBackOffice;
  }
  
  $strLocaleFrontOffice = ( isset($GLOBALS["tabLocales"]["frontoffice"][$_SESSION["ALK_LG_INTERNET"]]) 
                            ? $GLOBALS["tabLocales"]["frontoffice"][$_SESSION["ALK_LG_INTERNET"]]
                            : $GLOBALS["tabLocales"]["frontoffice"][0] );
  $bRes = setlocale(constant(ALK_LG_CATEGORY), $strLocaleFrontOffice);
  if( $bRes === false ) {
    // arrive si la locale n'est pas installée (retour de setlocale())
     setlocale(constant(ALK_LG_CATEGORY), $GLOBALS["tabLocales"]["frontoffice"][0]);
     $_SESSION["ALK_LG_LOCALE_INTERNET"] = $GLOBALS["tabLocales"]["frontoffice"][0];
  } else {
    $_SESSION["ALK_LG_LOCALE_INTERNET"] = $strLocaleFrontOffice;
  }
}

/**
 * Traduit les variables déclarées dans les fichiers de configuration avant l'appel de AlkFactory::initLocale()
 */
function translateConf()
{
  if( isset($GLOBALS["tabPJDetails"]) && is_array($GLOBALS["tabPJDetails"]) && !empty($GLOBALS["tabPJDetails"]) ) {
    if( false ) {
      // force l'indexation
      _t("Date");
      _t("Titre");
      _t("Copyright");
      _t("Description");
      _t("Mots-clés");
      _t("Langue");
    }
    $nbDetail = count($GLOBALS["tabPJDetails"]);
    for($i=0; $i<$nbDetail; $i++) {
      if( isset($GLOBALS["tabPJDetails"][$i]["label"]) ) {
        $GLOBALS["tabPJDetails"][$i]["label"] = _t($GLOBALS["tabPJDetails"][$i]["label"]);
      }
    }
  }
  
  if( isset($GLOBALS["tabStrLocales"]) ) {
    if( false ) {
      _t("anglais - Grande Bretagne");
      _t("français - France");
      _t("espagnol - Espagne");
      _t("portugais - Portugal");
      _t("allemand - Allemagne");
      _t("italien - Italie");
      _t("anglais - Etats-Unis");
    }
    foreach($GLOBALS["tabStrLocales"] as $strLocale => $strLabel) {
      $GLOBALS["tabStrLocales"][$strLocale] = _t($strLabel);
    }
  }
}

/**
 * Fixe une locale, retourne true si ok, false sinon
 * @param strNewLocale  nouvelle locale souhaitée
 * @return boolean
 */
function setAlkLocale($strNewLocale)
{
  putenv(constant(ALK_LG_CATEGORY)."=".$strNewLocale); // nécessaire pour windows
  $bRes = @setLocale(constant(ALK_LG_CATEGORY), $strNewLocale);
  if( $bRes === false ) {
    return false;
  } 
      
  @bindtextdomain(ALK_LG_DOMAIN, ALK_ALKANET_ROOT_PATH."locales");
  @textdomain(ALK_LG_DOMAIN);
  @bind_textdomain_codeset(ALK_LG_DOMAIN, ALK_HTML_ENCODING);
  return true;
}

/**
 * Fixe la locale par défaut pour envoyer les mails
 * - Si le mail est destiné à un seul destinataire, ou à un ensemble de destinataires de même langue,
 *   fournir la locale souhaitée
 * - sinon la locale utilisée est celle sélectionnée par défaut dans AlkFactory::initLocale();
 * 
 * Retourne true si ok, false sinon
 * @param strUserDestLg ="" par défaut, =locale de l'utilisateur destinataire si unique
 * @return boolean
 */
function setMailAlkLocale($strUserDestLg="")
{
  $strMailLocale = ( $strUserDestLg!="" && in_array($strUserDestLg, $GLOBALS["tabLocales"]["mail"]) 
                     ? $strUserDestLg
                     : ALK_MAIL_LOCALE );
  
  return setAlkLocale($strMailLocale);
}

/**
 * Restaure la locale courante
 * Retourne true si ok, false sinon
 * @return boolean
 */
function setCurrentAlkLocale()
{
  return setAlkLocale(ALK_LG_LOCALE);
}

/**
 * Alias de la fonction ngettext($strTextSingular, $strTextPlural, $iCpt)
 * @return string 
 */
function getAlkText($strFunction, $tabParam)
{
  $strFront = ( defined("ALK_ROOT_URL_FRONTOFFICE") 
               ? ( ALK_ROOT_URL_FRONTOFFICE==ALK_ROOT_URL ? "frontoffice" : "backoffice" )
               : "backoffice" );
             
  $strKey = $tabParam[0]; 
  
  $currentLocale = ALK_LG_LOCALE;
  $usedLocale = $currentLocale."0"; 
  $strRes = call_user_func_array($strFunction, $tabParam);
  if( $strRes == $strKey && substr($currentLocale, 0, 5)!="fr_FR" ) {
    // le texte n'est pas traduit dans la langue sélectionnée, sélection de la locale par défaut
    $defaultLocale = $GLOBALS["tabLocales"][$strFront][0];
    $usedLocale = $defaultLocale."1";
    $bRes = setAlkLocale($GLOBALS["tabLocales"][$strFront][0]);
    if( $bRes ) {
      // traduit le texte avec la locale par défaut
      $strRes = call_user_func_array($strFunction, $tabParam);
      if( $strRes == $strKey && substr($defaultLocale, 0, 5)!="fr_FR" ) {
        // le texte n'est pas traduit dans la langue par défaut, sélection de la locale française
        $usedLocale = "fr_FR2";
        $bRes = setAlkLocale("fr_FR");
        if( $bRes ) {
          // traduit le texte avec la locale française
          $strRes = call_user_func_array($strFunction, $tabParam);
        } else {
          // pas de locale française
          $strRes = $strKey;
        }
      }
    } else {
      // pas de locale par défaut
      $strRes = $strKey;
    }
    
    // réinstalle la locale courante
    setAlkLocale($currentLocale);
  } 
  
  return ( $GLOBALS["ALK_GT_START"] == '' ? $strRes : $usedLocale." ".$strRes );
}

/**
 * Alias de la fonction gettext($strText)
 * @return string 
 */
function _t($strText)
{
  $strRes = getAlkText("gettext", array($strText));
  
  return $GLOBALS["ALK_GT_START"].$strRes.$GLOBALS["ALK_GT_END"];
}

/**
 * Alias de la fonction ngettext($strTextSingular, $strTextPlural, $iCpt)
 * @return string 
 */
function _n($strTextSingular, $strTextPlural, $iCpt)
{
  $strRes = getAlkText("ngettext", array($strTextSingular, $strTextPlural, $iCpt));
  
  return $GLOBALS["ALK_GT_START"].$strRes.$GLOBALS["ALK_GT_END"];
}

/**
 * Alias de la fonction sprintf(_(strText), param1, param2, ..., paramN)
 * @return string 
 */
function _f($strText)
{
  // récupère les params de cette fonction
  $tabParam = func_get_args();
  // retire le premier paramètre pour ne garder que les param de sprintf
  array_shift($tabParam);
  // ajoute en premier, le résultat de la traduction de strText
  $strText = str_replace("%nl", "%s", $strText);
  array_unshift($tabParam, getAlkText("gettext", array($strText)));
  
  return $GLOBALS["ALK_GT_START"].call_user_func_array("sprintf", $tabParam).$GLOBALS["ALK_GT_END"];
}

/**
 * Alias de la fonction sprintf(ngettext(strTextSingular, strTextPlural, iCpt), param1, param2, ..., paramN)
 * Si aucun paramètre optionnel, param1 prend automatiquement la valeur de iCpt
 * @return string
 */
function _nf($strTextSingular, $strTextPlural, $iCpt)
{
  // récupère les params de cette fonction
  $tabParam = func_get_args();
  // retire les 3 premiers paramètres pour ne garder que les param de sprintf
  $tabParam = array_splice($tabParam, 3);
  if( empty($tabParam) ) {
    // ajoute le compteur comme paramètre de sprintf
    $tabParam = array($iCpt);
  }
  // ajoute en premier, le résultat de la traduction
  $strTextSingular = str_replace("%nl", "%s", $strTextSingular);
  $strTextPlural = str_replace("%nl", "%s", $strTextPlural);
  array_unshift($tabParam, getAlkText("ngettext", array($strTextSingular, $strTextPlural, $iCpt)));

  return $GLOBALS["ALK_GT_START"].call_user_func_array("sprintf", $tabParam).$GLOBALS["ALK_GT_END"];
}
?>
