<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Pattern
Module fournissant les classes de base Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * @package Alkanet_Class_Pattern
 * 
 * @interface AlkIntOptionsProvider
 * @brief Cette interface est à implémenter par toute classe souhaitant déclarer des options.
 *        La méthode <b>getDeclaredOptions()</b> doit se charger de déclarer les options sous la forme d'un 
 *        objet AlkoptionsBuilder, la fonction getAppliId indiquant à quelle application devront 
 *        appartenir les options (ou -1 si il doit s'agir options globales (<i>non supporté pour le moment</i>)).
 *        Cette interface est implémentée de base par la classe <b>AlkAppli</b>.
 */
interface AlkIntOptionsProvider
{

  /**
   * Cette fonction doit renvoyer sous form d'un objet AlkOptionsBuilder
   * la définition des options instanciables d'une application
   * 
   * @return AlkOptionsBuilder
   */
  public function getDeclaredOptions();
  
  /**
   * Cette fonction doit renvoyer l'identifiant d'application à associé aux options, ou -1 pour des options globales
   * 
   * @return int identifiant d'application, ou -1
   */
  public function getAppliId();

}

?>