<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlctrl.class.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlTree
 * 
 * 
 * Classe d'affichage d'un composant arbre.
 * 
 * @usage 
 *  -- fichier de mise en former de l'interface
 *  $oTree = new AlkHtmlTree('fdocTree', 'Racine', 'ajax_fdoc.php?node=0');
 *  
 *  -- fichier ajax_fdoc.php
 *  <?php
 *  header("Content-Type: text/xml"); // forcer l'entete xml
 *  header("Cache-Control: no-cache, must-revalidate");
 *  header("Expires: Mon, 26 Jul 1970 05:00:00 GMT");
 * 
 *  $node = $_GET['node']; // utiliser la methode GET
 *  // récuperer les données de ce noeud
 *  $children = $aQuery->getChildrenFornode($node);
 *
 *  // construire et retourner le contenu xml
 *  $strXml = "<tree>"; // racine du noeud $node
 *  foreach($children as $child) {
 *    $strXml .= "<tree text='".$child['text']."' ";
 *    $strXml .= "src='".$child['src']."' ";
 *    $strXml .= "action='ajax_tree.php?node=".$child['id']."' ";
 *    $strXml .= "icon='images/fdoc.png' ";
 *    $strXml .= "openIcon='images/fdoc_open.png' ";
 *    $strXml .= "/>";
 *  }
 *  $strXml .= "</tree>";
 *  echo $strXml; // envoyer le contenu xml
 */
class AlkHtmlTree extends AlkHtmlCtrl {
  
  const ALK_TREE_CLASSIC = "classic";
  const ALK_TREE_EXPLORER = "explorer";
  
  /**
   * @brief Constructeur par défaut
   * @param string strName nom du champ arbre (doit être unique)
   * @param string rText texte de la racine de l'arbre
   * @param string rXmlSrc source xml contenant les fils de la racine
   * @param string rAction action associée à la racine ('javascript:alert(...)', 'href://...') [optionnel]
   * @param string rBehavior mode d'affiche de l'arbre (AlkHtmlTree::ALK_TREE_CLASSIC ou AlkHtmlTree::ALK_TREE_EXPLORER) [optionnel]
   * @param string rIcon icone (fermée) de la racine [optionnel] 
   * @param string rOpenIcon icone (ouverte de la racine) [optionnel]
   * @param string loadingText texte affiché lors du chargement des noeuds [optionnel]
   * @param string errorLoadingText texte affiché en cas d'erreur du lors du chargement [optionnel]
   * @param string reloadText texte affiché sur le bouton de rafraichissement [optionnel]
   */
  public function __construct($strName, $rText, $rXmlSrc, $rAction="", $rBehavior="classic", $rIcon="", $rOpenIcon="", 
                  $loadingText="Chargement...", $errorLoadingText="Erreur lors du chargement", 
                  $reloadText="Cliquer pour recharger")
  {
    parent::__construct($strName, $rText);
    
    // controle des paramètres
    if(empty($strName)) $this->triggerError("class ".get_class($this)."::".__FUNCTION__.
                              "Le paramètre strName ne doit pas être vide", E_USER_ERROR);
    if(empty($rText)) $this->triggerError("class ".get_class($this)."::".__FUNCTION__.
                              "Le paramètre rName ne doit pas être vide", E_USER_ERROR);
    if(empty($rXmlSrc)) $this->triggerError("class ".get_class($this)."::".__FUNCTION__.
                              "Le paramètre rXmlSrc ne doit pas être vide", E_USER_ERROR);
    
    if($rBehavior!=self::ALK_TREE_CLASSIC || $rBehavior!=self::ALK_TREE_EXPLORER)
      $rBehavior = self::ALK_TREE_CLASSIC;
    
    // import des librairies pour xhttpRequest et xtree 
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/xmlextras.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/xtree2.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/xloadtree2.js");
    $this->addScriptCss(ALK_ALKANET_ROOT_URL."style/xtree.css");
    
    // configuration de base
    $strOnLoad = "";
    if(!empty($rIcon)) $strOnLoad .= "webFXTreeConfig.rootIcon        = '".$rIcon."'; ";
    else $strOnLoad .= "webFXTreeConfig.rootIcon        = '".ALK_MEDIA_URL."pictos/xtree_folder.png'; ";
    if(!empty($rOpenIcon)) $strOnLoad .= "webFXTreeConfig.openRootIcon        = '".$rOpenIcon."'; ";
    else $strOnLoad .= "webFXTreeConfig.openRootIcon    = '".ALK_MEDIA_URL."pictos/xtree_openfolder.png'; ";
    
    $strOnLoad .= "webFXTreeConfig.folderIcon      = '".ALK_MEDIA_URL."pictos/xtree_folder.png'; ";
    $strOnLoad .= "webFXTreeConfig.openFolderIcon  = '".ALK_MEDIA_URL."pictos/xtree_openfolder.png'; ";
    $strOnLoad .= "webFXTreeConfig.fileIcon        = '".ALK_MEDIA_URL."pictos/xtree_file.png'; ";
    $strOnLoad .= "webFXTreeConfig.iIcon           = '".ALK_MEDIA_URL."pictos/xtree_I.png'; ";
    $strOnLoad .= "webFXTreeConfig.lIcon           = '".ALK_MEDIA_URL."pictos/xtree_L.png'; ";
    $strOnLoad .= "webFXTreeConfig.lMinusIcon      = '".ALK_MEDIA_URL."pictos/xtree_Lminus.png'; ";
    $strOnLoad .= "webFXTreeConfig.lPlusIcon       = '".ALK_MEDIA_URL."pictos/xtree_Lplus.png'; ";
    $strOnLoad .= "webFXTreeConfig.tIcon           = '".ALK_MEDIA_URL."pictos/xtree_T.png'; ";
    $strOnLoad .= "webFXTreeConfig.tMinusIcon      = '".ALK_MEDIA_URL."pictos/xtree_Tminus.png'; ";
    $strOnLoad .= "webFXTreeConfig.tPlusIcon       = '".ALK_MEDIA_URL."pictos/xtree_Tplus.png'; ";
    $strOnLoad .= "webFXTreeConfig.blankIcon       = '".ALK_MEDIA_URL."pictos/xtree_blank.png'; ";
    $strOnLoad .= "webFXTreeConfig.loadingIcon     = '".ALK_MEDIA_URL."pictos/xtree_loading.gif'; ";
    $strOnLoad .= "webFXTreeConfig.loadingText     = '".$loadingText."'; ";
    $strOnLoad .= "webFXTreeConfig.errorIcon       = '".ALK_MEDIA_URL."pictos/xtree_error.png'; ";
    $strOnLoad .= "webFXTreeConfig.errorLoadingText = '".$errorLoadingText."'; ";
    $strOnLoad .= "webFXTreeConfig.reloadText      = '".$reloadText."'; ";
    
    // désactiver le double click
    $strOnLoad .= "WebFXTreeAbstractNode.prototype._ondblclick = function(){}; ";
    
    // création de l'arbre avec la racine passée en paramètre
    $strOnLoad .= "var ".$this->name." = new WebFXLoadTree('".$rText."', '".$rXmlSrc."', '".$rAction."', ";
    $strOnLoad .= "'".$rBehavior."', '".$rIcon."', '".$rOpenIcon."'); ";
    
    $strOnLoad .= "var div".$this->name." = document.getElementById('div".$this->name."'); ";
    $strOnLoad .= "div".$this->name.".innerHTML = ".$this->name.".toHtml(); ";
    
    // ouvrir l'arbre et forcer le rafraichissement de la racine
    $strOnLoad .= "tree.setExpanded(true); ";
    
    $this->addScriptJs($strOnLoad);
  }

  /**
   * @brief Génère puis retourne le code html associé au controle
   */
  protected function getCtrlHtml($key=0, $tabLg=array())
  {
    // creer un div qui va contenir l'arbre
    $strHtml = "<div id='div".$this->name."'></div>";
    return $strHtml;
  }
  
}

?>