/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::GEdit
Module gestion éditoriale.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

function OpenPopupEditeur(strToken)
{
  OpenWindow(ALK_ALKANET+"?token="+strToken, "580", "850", "windEditeur");
}

function OpenDataSelect(strToken, bloc_id, strMoreParam)
{
  var oDataIdList = document.getElementById("dataIdList"+bloc_id);
  var strParam = "";
  if( oDataIdList ) {
    // ajoute les data_id sélectionnés, la valeur est cryptée
    strParam += "&dil="+oDataIdList.value;
  }
  if ( typeof strMoreParam!="undefined" ){
    strParam += strMoreParam;
  }
  OpenWindow(ALK_ALKANET+"?token="+strToken+strParam, "590", "630", "windSelectData");
}

function OpenDataSelectPageType()
{
  var TASSOC_BYAPPLI = 1;
  var TASSOC_BYCATEG = 2;
  var bloc_id = "Page";
  var strMoreParam = "";
  
  var f = document.formPage;
  var oDataIdList = document.getElementById("dataIdList"+bloc_id);
  var strParam = "";
  if( oDataIdList ) {
    if ( f.page_typeassoc ){
      var typeassoc = parseInt(f.page_typeassoc.value);
      oDataIdList.value = 
        TextEncode( 
          ( (typeassoc & TASSOC_BYCATEG) == TASSOC_BYCATEG
            ? f.page_catid.value
            : f.page_appliid.value )
        );
      strMoreParam += "&typeassoc="+TextEncode( typeassoc+"" );
    }
    if ( f.page_ordre ){
      strMoreParam += "&default_ordre="+TextEncode( f.page_ordre.value );
    }
    if ( f.page_datedeb ){
      strMoreParam += "&default_datedeb="+TextEncode( f.page_datedeb.value );
    }
    if ( f.page_datefin ){
      strMoreParam += "&default_datefin="+TextEncode( f.page_datefin.value );
    }
    if ( f.page_nb_elements ){
      strMoreParam += "&page_nb_elements="+TextEncode( f.page_nb_elements.value );
    }
  }
  if( !f.page_infotxt.disabled )
    OpenDataSelect(f.page_infoToken.value, bloc_id, strMoreParam);
}

function OpenApercu(strToken) 
{
  OpenWindow(ALK_ALKANET+"?token="+strToken, "580", "800", "windViewer");
}

function OpenFormBlocPerso(strToken)
{
  OpenWindow(ALK_ALKANET+"?token="+strToken, "580", "630", "windFormPerso");
}

function setHidePageListeLabelAfter()
{
  var oDiv = document.getElementById("page_liste_labelAfter");
  if( oDiv ) {
    var oStyle = ( oDiv.style ? oDiv.style : oDiv ); 
    oStyle.display = "none";
  }
}

function onClickPageListe(oThis, strToken)
{
  var f = document.formPage;
  var iValide = ( oThis.checked ? "1" : "0" );
  var strParam = strToken+"&lid="+f.liste_id.value+"&lv="+iValide;
  var oAjax = new AlkAjax('', '', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_AJAX+'?token='+strParam, null, false);
  var strRes = oAjax.getReturnValue();
  var tabRes = eval("("+strRes+")");
  
  f.liste_id.value = tabRes.liste_id;
  
  var oDiv = document.getElementById("page_liste_labelAfter");
  if( oDiv ) {
    var oStyle = ( oDiv.style ? oDiv.style : oDiv ); 
    oStyle.display = ( iValide == "1" ? "" : "none" );
    if( tabRes.html ) {
      oDiv.innerHTML = tabRes.html; 
    }
  }
}

function openPopupAbonnes(strToken)
{
  var f = document.formPage;
  if( f.page_liste.value == "1" && f.liste_id.value != "-1" ) { 
    OpenWindow(ALK_ALKANET+"?token="+strToken, "580", "630", "windFormAbonne");
  }
}

function objTreeviewShowHideHelp()
{
  var oDivHelp = document.getElementById("geditArboHelp");
  var oStyle = ( oDivHelp.style ? oDivHelp.style : oDivHelp );  
  oStyle.display = ( oStyle.display == "none" ? "block" : "none" );
}

//var bIsPageAliasUnique = false;
var AlkNbClickValid = 0;
function Validation(strToken, strTokenUnicite)
{
  var bIsPageAliasUnique = checkUniciteIntituleUrl(strTokenUnicite);
  if(bIsPageAliasUnique==false) {
    alertInituleUrlIsNotUnique();
    return false;
  }
  
  var f = document.formPage;
  if( AlkNbClickValid == 0 ) {
    var bRes = AlkVerifCtrl(f);
    if( bRes == true ) {
      AlkNbClickValid++;
      f.target = "";
      f.action = ALK_ALKANET_SQL+"?token="+strToken;
      return true;
    }
  }
  return false; 
}

function Publier(strToken, strTokenUnicite)
{
  var bIsPageAliasUnique = checkUniciteIntituleUrl(strTokenUnicite);
  if( bIsPageAliasUnique==false ) {
    alertInituleUrlIsNotUnique();
    return false;
  }
  bIsPageAliasUnique = false;
  
  var f = document.formPage;
  var bRes = AlkVerifCtrl(f);
  if(bRes){
    var bResPubli = window.confirm("Veuillez confirmer la mise en ligne de cette page ?");
    if( bResPubli) {
      f.target = "footerExec";
      f.action = ALK_ALKANET_SQL+"?token="+strToken;
      f.page_validepub.checked = true;
      var bNotif = (arguments.length > 2 ? arguments[2] : 0);
      if (bNotif==1){
          f.submit();
      }else {
          return true;
      }
    }
  }
  return false;
}

function checkUniciteIntituleUrl(strToken)
{
  var f = document.formPage;
  var page_id = f.page_id.value;
  var strParam = "&page_id="+page_id;
  var tabValue = new Array();
  var bOk = true;
  var bNull = true;
  for(i=0; i<tabLang.length; i++) {
    oPageAlias = f.elements["page_alias"+tabLang[i]];
    if( !oPageAlias ) continue;
    strField = "page_alias"+tabLang[i];
    tabValue[i] = oPageAlias.value;
    bNull = bNull && ( tabValue[i]=="" );
    for(j=0; j<i; j++) {
      bOk = bOk && (tabValue[i] != tabValue[j]);
    } 
    strParam += "&"+strField.toLowerCase()+"="+encodeURIComponent(oPageAlias.value)
  }
  
  // les alias sont tous vides => non disponibles, etat ok par défaut
  if( bNull ) return true;
  
  // les alias ne sont pas distincts
  if( !bOk ) return false;
  
  // requete synchrone  
  var oAjax = new AlkAjax('checkUniciteIntituleUrl', '', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_AJAX+'?token='+strToken+strParam, null, false);
  var iRes = oAjax.getReturnValue();
  return ( iRes != "1" ? false : true );
}

function alertInituleUrlIsNotUnique()
{
  var f = document.formPage;
  var oCtrl = f.elements["page_alias"+tabLang[0]];
  if( oCtrl ) {
    oCtrl.alkFormSheetIndex = "sheetRefInternet";
    oCtrl.alkSheetManager = "_formPage";
    AlkAlertMsg(oCtrl, "Attention, il existe déjà une page ayant un 'Intitulé url' identique.\nVeuillez utiliser un autre intitulé pour cette page.");
  }
}

function Restaurer(strToken)
{
  var f = document.formPage;
  var bRes = alkConfirm("Veuillez confirmer la restauration de cette page\nà partir des données publiées ?\n"+
                        "Attention, si la page n'est pas publiée, vous risquez une perte de données.");
  if( bRes ) {
    f.target = "";
    f.action = ALK_ALKANET_SQL+"?token="+strToken;
    return true;
  }
}

function onClickPagePublish(strTokenPublish, strTokenUnpublish)
{
  var f = document.formPage;
  var bRes = false;
  var strToken = strTokenPublish;
  if( !f.page_validepub.checked ) {
    bRes = alkConfirm("Veuillez confirmer le retrait de cette page de la publication ?");
    strToken = strTokenUnpublish;
  } else {
    bRes = alkConfirm("Veuillez confirmer la mise en ligne de cette page ?");
  }
  if( bRes ) {
    f.target = "footerExec";
    f.action = ALK_ALKANET_SQL+"?token="+strToken;
    f.submit();
  } else {
    f.page_validepub.checked = !f.page_validepub.checked;
  }
}

function Annuler()
{
  var f = document.formPage;
  f.reset();
}

function updatePage(page_id)
{
  AlkGoUrl(ALK_ALKANET+"?token="+strTokenUpdatePage+"&page_id="+page_id);
}
function addPage(page_id)
{
  AlkGoUrl(ALK_ALKANET+"?token="+strTokenAddPage+"&page_id="+page_id);
}

function AddBloc(strToken, typeIdBloc, atypeIdBloc, iColonne)
{
  iColonne = ( typeof(iColonne)=="undefined" ? 0 : iColonne );
  var strParam = strToken+"&typeIdBloc="+typeIdBloc+"&iColonne="+iColonne+"&atypeIdBloc="+atypeIdBloc;
  var oAjax = new AlkAjax('nameLoadAddBloc', 'fnLoadAddBloc', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_AJAX+'?token='+strParam, null);
}

function fnLoadAddBloc(strHtmlContent)
{
  // retourne le code html de la liste des blocs de la page
    var oDiv = document.getElementById("layerBlockPage");
  if ( !oDiv ) return;
  var oStyle = ( oDiv.style ? oDiv.style : oDiv );
  oStyle.display = 'block';
  oDiv.innerHTML = strHtmlContent;
}

function DelBloc(strToken)
{
  var bRes = alkConfirm("Veuillez confirmer la suppression de ce bloc ?");
  if( bRes ) {
    var oAjax = new AlkAjax('nameLoadDelBloc', 'fnLoadAddBloc', ALK_FORM_METHOD_GET, 
                            ALK_ALKANET_AJAX+'?token='+strToken, null);
  }
}

function MajRangBloc(strToken)
{
  var f = document.formPage;
  var oAjax = new AlkAjax('nameLoadUpdateRankBloc', 'fnLoadAddBloc', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_AJAX+'?token='+strToken, null);
}

function MajRangDataBloc(strToken)
{
  var oAjax = new AlkAjax('nameLoadUpdateRankDataBloc', 'fnLoadDelDataBloc', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_AJAX+'?token='+strToken, null);
}

function DelDataBloc(strToken)
{
  var bRes = alkConfirm("Veuillez confirmer la suppression de cette information ?");
  if( bRes ) {
    var oAjax = new AlkAjax('nameLoadDelDataBloc', 'fnLoadDelDataBloc', ALK_FORM_METHOD_GET, 
                            ALK_ALKANET_AJAX+'?token='+strToken, null);
  }
}

function updateDataBloc(strToken)
{
  var oAjax = new AlkAjax('nameLoadUpdateDataBloc', 'fnLoadUpdateDataBloc', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_AJAX+'?token='+strToken, null);
}
function fnLoadUpdateDataBloc(strHtmlContent)
{
  fnLoadDelDataBloc(strHtmlContent);
  closeWindow();
}
function fnLoadDelDataBloc(strRes)
{
  var oRes = eval("("+strRes+")");
  
  var bloc_id = oRes.bloc_id;
  var strHtml = oRes.html;
  var strTitre = oRes.titre;

  if( strHtml == "" ) {
    strHtml = "<i>Cliquez sur le bouton modifier pour associer de l'information à ce bloc</i>";
  } 

  var oDiv = top.window.document.getElementById("layerBloc"+bloc_id);
  var oDivTitre = top.window.document.getElementById("layerBlocTitre"+bloc_id);
  if ( oDivTitre ) oDivTitre.innerHTML = (strTitre != "" ? strTitre  : ""); 
  
  if ( !oDiv ) return;
  var oStyle = ( oDiv.style ? oDiv.style : oDiv );
  oStyle.display = 'block';
  oDiv.innerHTML = strHtml;
}

function showUsers(strToken)
{
  var oAjax = new AlkAjax('nameLoadUsersList', 'fnLoadUsersList', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_AJAX+'?token='+strToken, null);
}

function fnLoadUsersList(strHtmlContent)
{
  var oDiv = document.getElementById("layerUsersList");
  if ( !oDiv ) return;
  var oStyle = ( oDiv.style ? oDiv.style : oDiv );
  oStyle.display = 'block';
  oDiv.innerHTML = strHtmlContent;
}

function CutPastePage(strParam)
{
  var oAjax = new AlkAjax('nameLoadCutPastePage', 'fnLoadCutPastePage', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_SQL+'?'+strParam, null);
}

function fnLoadCutPastePage(strHtmlContent)
{
  if( strHtmlContent == "copy" ) {
    document.location.reload();
  }
}

function onChangePageType(strToken)
{
  var f = document.formPage;
  var aptype_id = "23_0";
  if( f.page_aptypeid.selectedIndex > -1 ) {
    aptype_id = f.page_aptypeid.options[f.page_aptypeid.selectedIndex].value; 
  }
  var oAjax = new AlkAjax('nameLoadChangePageType', 'fnLoadChangePageType', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_SQL+'?token='+strToken+"&aptid="+aptype_id, null);
}

function fnLoadChangePageType(strHtmlContent)
{
  var TASSOC_BYAPPLI = 1;
  var TASSOC_BYCATEG = 2;
  var f = document.formPage;

  f.page_infotxt.value = "Aucune information sélectionnée";
  f.page_appliid.value = "-1";
  f.page_catid.value   = "-1";
  if ( f.page_typeassoc ){
    var typeassoc = parseInt(f.page_typeassoc.value);
    if ( (typeassoc & TASSOC_BYAPPLI) == TASSOC_BYAPPLI )
      f.page_typeassoc.value = typeassoc - TASSOC_BYAPPLI;
    if ( (typeassoc & TASSOC_BYCATEG) == TASSOC_BYCATEG )
      f.page_typeassoc.value = typeassoc - TASSOC_BYCATEG;
  }
  
  // évalue le tableau tabOptions et strTokenSelectValue
  eval(strHtmlContent);

  f.page_infoToken.value = strTokenSelectValue;
  f.page_infotxt.disabled = ( atype_id == "23" || atype_id == "1" );
  if( f.page_infotxt.disabled ) {
    f.page_infotxt.value = "Aucune information sélectionnable";
  }
  
  updateComboFromTabAlkAjax(f.page_template, tabOptions, true, false);
}

function updateFieldAssocAppliCatPage(appli_id, cat_id, strAppliCatName, page_typeassoc, page_ordre, page_datedeb, page_datefin, page_nb_elements)
{
  var f = document.formPage;
  f.page_appliid.value = appli_id;
  f.page_catid.value   = cat_id;
  f.page_infotxt.value = strAppliCatName;
  f.page_typeassoc.value = page_typeassoc;
  f.page_ordre.value = page_ordre;
  f.page_datedeb.value = page_datedeb;
  f.page_datefin.value = page_datefin;
  f.page_nb_elements.value = page_nb_elements;
}

function onChangePagePublic(oCtrl, iMode)
{
  var f = document.formPage;
  var bRightDisable = ( oCtrl.checked );
  for(i=0; i<f.elements.length; i++) {
    var oCtrlRD = f.elements[i];
    
    if( oCtrlRD.name && oCtrlRD.name.substr(0,9)=="listRight" ) {
      oCtrlRD.disabled = bRightDisable;
    }
  }
}

function OpenFileManager(strToken)
{
	OpenWindow(strToken, "580", "1000", "windViewer");
}

var cursorLeft = 20;
var cursorTop = 10;
var optionsDrag = { cursor : "move", opacity : 0.8, cursorAt: { left: cursorLeft, top: cursorTop },
    helper: function () {
      var oMove;
      oMove = $(this).clone().appendTo('body').css('zIndex',5);
      oMove.html("<img class='alkimgicon alkimgiconpage' src='"+ALK_ALKANET_ROOT_URL+"media/images/transp.gif'/>");
      oMove.show();
      return oMove;
    }
};
  
function dragAndDropPages(idLayer)
{
  if ( !document.getElementById(idLayer) ) 
     return;
  // jquery treeview
  $('#'+ idLayer).treeview(); 
  // jquery drag an drop
  var idPageToMove=-1;
  var posDebut = 1; var posFin = 1;
  var idParentDebut = -1; var idParentFin = -1; var idPrevFin = -1;

  //var strpan = $('span[id$="_2"]'); // recherche uniquement sur les pages sur lesquelles l'utilisateur a droit
  if(bIsAnimator || bIsPublicator){
    
    /*$('ul li.last > span').css('background-color', '#fff');*/
    $('ul li.last > span').after('<ul class="noParent" style="margin: 0px !important; padding: 1px 0 0 0 !important; height:0px;">&nbsp;</ul>');
    
    $("div#layerArbre > ul > li.lastCollapsable").sortable({
      cancel: null, // Cancel the default events on the controls
      handle: 'li span a:first',
      placeholder: "ui-state-highlight",
      items: "ul:not(.ui-state-disabled)",
      forcePlaceholderSize: true,
      cursorAt: { left: cursorLeft, top: cursorTop },
      cursor: 'move',
      start: function(e, ui){
        ui.placeholder.height('1px'/*ui.item.height()*2*/);

        posDebut = 1;
        ui.item.prevAll('ul').each(function(){
          posDebut++;
        });

        idPageToMove = ui.item.children('li').children('span').attr('id').replace("atn_", "");
        idPageToMove = idPageToMove.substr(0, idPageToMove.length-2);

        idParentDebut = ui.item.parent().children('span').attr('id').replace("atn_", "");
        idParentDebut = idParentDebut.substr(0, idParentDebut.length-2)
      },
      update: function(e, ui){
        var strNameCurrent = ui.item.children('li').children('span').text();
        var strNameParentFin = ui.item.parent().children('span').text();

        posFin = 1;
        ui.item.prevAll('ul').each(function(){
          posFin++;
        });

        idParentFin = ui.item.parent().children('span').attr('id').replace("atn_", "");
        idParentFin = idParentFin.substr(0, idParentFin.length-2);

        if(ui.item.prev('ul').children('li').children('span').attr('id') != undefined){
          idPrevFin = ui.item.prev('ul').children('li').children('span').attr('id').replace("atn_", "");
          idPrevFin = idPrevFin.substr(0, idPrevFin.length-2);
        }
        if(idPageToMove == -1 || idParentFin == -1){
          $(this).sortable('cancel');
          return;
        }

        if(idParentDebut != idParentFin){
          if(! confirm('Confirmez-vous le déplacement de la page \n"'+strNameCurrent+'"\nVers la page \n"'+strNameParentFin+'" ?') ){
            $(this).sortable('cancel');
            return;
          }
          new AlkAjax('MovePage', 'fnMovePage', ALK_FORM_METHOD_GET, 
                            ALK_ALKANET_SQL+'?token='+objTreeview.tokenCutCopy+"&op=cut&folderSrc_id="+idPageToMove+"&folderPrev_id="+idParentDebut+"&folderDest_id="+idParentFin+"&pageIdPrev="+idPrevFin, null);

        }else{
          if(posDebut != posFin){
            if(! confirm('Confirmez-vous le changement de rang de la page \n"'+strNameCurrent+'" ?') ){
              $(this).sortable('cancel');
              return;
            }
            new AlkAjax('MovePage', 'fnMovePage', ALK_FORM_METHOD_GET, 
                            ALK_ALKANET_SQL+'?token='+objTreeview.tokenCutCopy+"&op=cut&folderSrc_id="+idPageToMove+"&folderPrev_id="+idParentDebut+"&folderDest_id="+idParentFin+"&pageIdPrev="+idPrevFin, null);

          }else return;
        }
      }
    });

    //$('div#layerArbre li.lastCollapsable .ui-sortable').addClass('ui-sortable');
    $('div#layerArbre li.lastCollapsable').removeClass('ui-sortable');
    $('div#layerArbre li.lastCollapsable').each(function(){
      $(this).find('ul li span').each(function(){
        $(this).children('a:first').css('cursor', 'move');
      });
    });
  }
}

function onChange(obj)
{ 
  var lang = obj.name.substring(obj.name.lastIndexOf("_"));
  var page_titre_court_lang = eval('page_titre_court' + lang);
  var page_titre_lang = eval('page_titre' + lang);
    page_titre_court_lang.value = page_titre_lang.value;
}

function fnMovePage(strHtmlContent) { 
  document.location.reload();
}