<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::GEdit
Module gestion éditoriale.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/*
 * permet la gestion des mots clés et de leur pondération
 */

class AlkHtmlTagCloudForm extends AlkHtmlForm
{
  
  protected $motCle;
  protected $poids;
  protected $motsPlusUtilises;
  protected $motsRecherchésPlusDemandes;
  protected $MotCle_id;
  
  /**
   * Construction du formulaire
   * @param $oAppli
   * @return 
   */
  
  public function __construct(AlkAppli &$oAppli) 
  {
    parent::__construct($oAppli, "formTagCloud");

    // récupération du mode formulaire
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=".$iMode);
    $strAction = ALK_ALKANET_SQL."?token=".$strToken;    
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, $strAction);
  }
  
  /**
   * (non-PHPdoc)
   * @see classes/form/AlkHtmlForm#setData()
   */
  protected function setData($iTypeInit) { 
    
    $this->motCle  = new AlkFormData($this, "motCle",  AlkRequest::getToken("motCle", AlkRequest::_POST("motCle", "")), ALK_SQL_TEXT);
    $this->poids  = new AlkFormData($this, "poids",  AlkRequest::getToken("poids", AlkRequest::_POST("poids", "")), ALK_SQL_NUMBER);
    $this->motsPlusUtilises  = new AlkFormData($this, "motsPlusUtilises",  AlkRequest::getToken("motsPlusUtilises", AlkRequest::_POST("motsPlusUtilises", "")), ALK_SQL_TEXT);
    $this->motsRecherchésPlusDemandes  = new AlkFormData($this, "motsRecherchesPlusDemandes",  AlkRequest::getToken("motsRecherchesPlusDemandes", AlkRequest::_POST("motsRecherchesPlusDemandes", "")), ALK_SQL_TEXT);
    $this->MotCle_id = new AlkFormData($this, "MotCle_id", AlkRequest::getToken("MotCle_id",-1),ALK_SQL_NUMBER);
  }
  
    /**
   * Traitement 
   */
  public function doSql() 
  {
    $appli_id = AlkRequest::getToken("appli_id", "-1");
     switch( $this->iMode ) {
       case 1 : // supprimer un mot clé
         $idMotCle = AlkRequest::getToken("MotCle_id", -1);
         $this->oAppli->oQueryAction->DelMotCle($idMotCle);
         break;
       Case 2 : // on veut afficher dans le formulaire d'ajout le mot les plus utilisé qui a été sélectionné
         $Motselect = AlkRequest::_GET("Motselect", "");
         // on récupère le mot clé sélectionné et son secno
         $dsMotUtil = $this->oAppli->oQuery->GetDsMotCleUtilByIdMocleUtil($Motselect);
         if ($drMotUtil = $dsMotUtil->getRowIter()){
         	$MotSelect = $drMotUtil->getValueName("word");
         	$secno = $drMotUtil->getValueName("somme");
         }
         $strJsHtml = "var res = '".utf8_decode($Motselect)."';";
         $strJsHtml .= "var nb = '".$secno."';";
         echo $strJsHtml; exit();
         break;
       Case 3 : // on veut afficher dans le formulaire d'ajout le mot recherché le plus demandé
         $idMotRech = AlkRequest::_GET("idMotRech", -1);
         // on récupère le mot clé recherché
         $dsMotCleSearch = $this->oAppli->oQuery->GetDsMotCleSearchByIdMocleSearc($idMotRech);        
         if ($drMotCleSearch = $dsMotCleSearch->getRowIter()) {
           $motcleSearch = $drMotCleSearch->getValueName("SSTAT_MOT");
           $nbSearch = $drMotCleSearch->getValueName("SSTAT_NB");
         }
         $strJsHtml = "var res = '".$motcleSearch."';";
         $strJsHtml .= "var nb = ".$nbSearch.";";
         echo $strJsHtml; exit();
         break;
     }
     
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $this->iSheet, ALK_SHEET_NONE); 
    return ALK_ALKANET."?token=".$strToken; 
  }
  
  /**
   * (non-PHPdoc)
   * @see classes/form/AlkHtmlForm#setContents()
   */
  public function setContents()
  {
  $appli_id = AlkRequest::getToken("appli_id", "-1");  
  if ($this->iMode == 4){
      // action du bouton valider
     // on récupère les valeurs à mettre en base
     $idMotCleMaj = AlkRequest::_GET("MotId", -1);
     $motCleMaj = AlkRequest::_GET("mot", -1);
     $poidsMaj = AlkRequest::_GET("poids", -1);
     if ($idMotCleMaj == -1){
       // cas ajout
       $tagCloudId = AlkFactory::getDbConn()->getNextId("FORM_01_FORM", "TAGCLOUD_ID", "seq_gedit_01_tagcloud");
       // on peut avoir un cas où le mot existe déjà ???
       $this->oAppli->oQueryAction->AddMotCle($tagCloudId,$appli_id,$motCleMaj,$poidsMaj);
     }else {
       // Modification
       $this->oAppli->oQueryAction->UpdateMotCle($idMotCleMaj,$motCleMaj,$poidsMaj);
     }
     // constitution de la réponse ajax
     $strJsHtml=$this->HtmlListeMotsCle();
     echo $strJsHtml; return;
  } else {
  
     $cont_id  = AlkRequest::getToken("cont_id", "-1");
     $appli_id = AlkRequest::getToken("appli_id", "-1");
     $user_right = AlkFactory::getSProperty("user_right", ALK_APPLI_RIGHT_NONE);
    
     $this->setData(ALK_INIT_MODE_REQUEST);
    
    
     $strTitleMotsCles = _t("Liste des mots clés");
     $strTitleGestionMotsCles = _t("Gestion des mots clés");
     $strTitleConsultMotsCles = _t("Mots clés les plus utilisés/demandés");
    
     $oBlockListMotCle = $this->addBlock("block_0", $strTitleMotsCles, "", "100", "300", true);
     $oBlockGestionMotCle = $this->addBlock("block_1", $strTitleGestionMotsCles, "", "70", "300", true);
     $oBlockConsultMotCle = $this->addBlock("block_2", $strTitleConsultMotsCles, "", "110", "260", false);
   
     $oBlockListMotCle->addCtrl(AlkHtmlFactory::getHtml($this->HtmlListeMotsCle(), ""), ALK_HTMLFORM_1L1C, "center");
   
     // autres contrôles
    // la liste des mots les plus utilisés
    $oCtrlMotUtSelect = AlkHtmlFactory::getHtmlSelect($this->motsPlusUtilises, _t("Mots les plus utilisés"), 1, 220);
    $oCtrlMotUtSelect->setProperty("tabValTxtDefault", array(-1, "--- "._t("Aucun mot sélectionné")." ---")); 
    $tableauUtil = $this->oAppli->oQuery->GetTableauMotCleMotsPlusUtilises();
    $oCtrlMotUtSelect->setProperty("tabValTxt",$tableauUtil);
    // bouton Ajouter
    $strTokenAddMotUtSelect = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $this->iSheet, ALK_SHEET_NONE,"&iMode=2");
    $oBtAddMotUtSelect = AlkHtmlFactory::getHtmlButtonIcon("javascript:AjaxDisplayMotCle('".$strTokenAddMotUtSelect."')", "Ajouter", _t("Ajouter ce mot clé à ma liste"),false,"","BtAddMotUtSelect");
     
    // la liste des mots recherchés les plus demandés
    $oCtrlMotRechSelect = AlkHtmlFactory::getHtmlSelect($this->motsRecherchésPlusDemandes, _t("Mots Recherchés les plus Demandés"), 1, 220);
    $oCtrlMotRechSelect->addValidator(ALK_VERIF_SELECT); 
    $oCtrlMotRechSelect->setProperty("tabValTxtDefault", array("-1", "--- "._t("Aucun mot sélectionné")." ---")); 
    $tableauSearch = $this->oAppli->oQuery->getTableauMotsCleSearch($appli_id);
    $oCtrlMotRechSelect->setProperty("tabValTxt", $tableauSearch);
   
    // bouton Ajouter
    $strTokenAddMotRechSelect = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $this->iSheet, ALK_SHEET_NONE, 
                                       "&iMode=3");

    $oBtAddMotRechSelect = AlkHtmlFactory::getHtmlButtonIcon("javascript:AjaxDisplayMotCle1('".$strTokenAddMotRechSelect."')", "Ajouter", "Ajouter ce mot clé à ma liste",false,"","BtAddMotRechSelect");
   
    $oBlockConsultMotCle->addCtrl($oCtrlMotUtSelect);
    $oCtrlMotUtSelect->addCtrl($oBtAddMotUtSelect);
    $oBlockConsultMotCle->addCtrl($oCtrlMotRechSelect);
    $oCtrlMotRechSelect->addCtrl($oBtAddMotRechSelect);
   
    // assignation du template
    //$oBlockConsultMotCle->setTemplate("alkanet","block_bicolumn.tpl"); 
   
    // le formulaire d'ajout
    // champ caché du MotCle_id
    $oHide = AlkHtmlFactory::getHtmlHidden($this->MotCle_id);
    // champ mot clé
    $oCtrlMotCle = AlkHtmlFactory::getHtmlText($this->motCle, _t("Mot Clé"), 1,25,50,50);
    $oCtrlMotCle->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
   
    // champ Poids
    $oCtrlPoids = AlkHtmlFactory::getHtmlText($this->poids, _t("Poids"), 1,5,5,5);
    $oCtrlPoids->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
    
    $oBlockGestionMotCle->addCtrl($oHide);
    $oBlockGestionMotCle->addCtrl($oCtrlMotCle);
    $oBlockGestionMotCle->addCtrl($oCtrlPoids);
    
    //bouton valider
    $strAction = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $this->iSheet, ALK_SHEET_NONE,"&iMode=4");
    $oBlockGestionMotCle->addButtonPage("","javascript:AjaxModifieListeMotCleEtReaffiche('".$strAction."')","Valider");
    // assignation du template
    $this->setTemplate("alkanet","form_bicolumn.tpl"); 
    
    $this->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."gedit/lib/alkhtmltagcloudform.js");
  }

  }
  
  /**
   * retourne en HTML la liste des mots clés après modification
   * @return unknown_type
   */
  public function HtmlListeMotsCle(){
    
    // gestion de la pagination
    /*$this->page = AlkRequest::getToken("page", AlkRequest::_GETint("page", 1));
    $NbElmentparPage = 5;
    $iFirst = ($this->page-1)*$NbElmentparPage;
    $iLast =   $this->page*$NbElmentparPage -1;
    $Urlpagine = ALK_ALKANET."?token=".$this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $this->iSheet, ALK_SHEET_LIST);*/
    
    $appli_id = AlkRequest::getToken("appli_id", "-1");
    // recupération de la liste des mots clés
    $dsListMotCles = $this->oAppli->oQuery->getDsListMotsCles($appli_id);
    $nbElt = $dsListMotCles->getCountTotDr();
    
    //construction  de la liste des mots clés    
    $oListMotCle = AlkHtmlFactory::getHtmlList($this, $nbElt,1, $nbElt, false,"", _t("Aucun résultat."),false,"list_mots_cles");
   
     $oListMotCle->SetColumns(array("left", "200"),
                       array("center", "80"),
                       array("center", "60"));

    
     $oListMotCle->addTitleRowByArray(array(_t("Mot clé"), _t("Pondération"), _t("Action")));
    
     // remplissage de la liste
    $dsListMotCles = $this->oAppli->oQuery->getDsListMotsCles($appli_id);     
    while( $drListMotCles = $dsListMotCles->getRowIter() ) {
      $tagCloud_id      = $drListMotCles->getValueName("TAGCLOUD_ID");
      $tagCloud_mot     = $drListMotCles->getValueName("TAGCLOUD_MOT");
      $tagCloudPoids    = $drListMotCles->getValueName("TAGCLOUD_POIDS");
      $strChaineMotCle = $tagCloud_id."_".$tagCloud_mot."_".$tagCloudPoids;

      // construction des url pour les boutons
  
     // lien modifier
     $oLinkUpdate = AlkHtmlFactory::getHtmlButton("javascript:DisplayMotCle('".$strChaineMotCle."')", $tagCloud_mot, "");
      
      // bouton supprimer
      $strTokenDel = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $this->iSheet, ALK_SHEET_NONE, 
                                             "&MotCle_id=".$tagCloud_id."&iMode=1");
      $oBtSuppr = AlkHtmlFactory::getHtmlButtonIcon("javascript:Confirmation('".ALK_ALKANET_SQL."?token=".$strTokenDel.
                                                    "', '"._t("Veuillez confirmer la suppression de ce mot clé ?")."')", 
                                                    "Supprimer",  _t("Supprimer ce mot clé")); 
      $oListMotCle->addRowByArray(array($oLinkUpdate,$tagCloudPoids,$oBtSuppr));
    }
    return $oListMotCle->getHtml();  
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."gedit/help/gedit_01_page_form.htm"); 
  }  

}
?>