<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::GEdit
Module gestion éditoriale.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/
//require_once('../../lib/lib_session.php');
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

class AlkPopupListPage extends AlkHtmlForm 
{
  
  /** identifiant de l'espace */
  protected $cont_id;

  /** identifiant de l'utilisateur */
  protected $user_id;

  protected $dataTitle;
  /** identifiant de l'id du champ input ou on enregistre l'url */
  protected $ctrlUrl;
  /** booleen indiquant si l'on souhaite récupérer l'adresse Url complete ou juste le chemin relatif*/
  protected $bWithRootUrl;
  
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formListurl"); 

    $this->cont_id = AlkRequest::getToken("cont_id", -1);
    $this->user_id = AlkFactory::getsProperty("user_id", ALK_USER_ID_INTERNET);
    $this->ctrlUrl = AlkRequest::getToken("ctrlUrl", "");
    $this->ctrlId = AlkRequest::getToken("ctrlId", "");
    $this->ctrlLinkId = AlkRequest::getToken("ctrlLinkId", "");
    $this->bWithRootUrl = AlkRequest::getToken("bWithRootUrl", true);
    if($this->bWithRootUrl === "false" ) $this->bWithRootUrl = false;
    $this->bCtrlMultilingue = AlkRequest::getToken("bCtrlMultilingue", false);
    if($this->bCtrlMultilingue === "false" ) $this->bCtrlMultilingue = false;
    
  }
  /**
   * @brief Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) 
  {

    if( !defined("ALK_B_ATYPE_GEDIT") ) {
      define("ALK_B_ATYPE_GEDIT", true);
    }
    if( !defined("ALK_B_ATYPE_ESPACE") ) define("ALK_B_ATYPE_ESPACE", true);
    if( !defined("ALK_B_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE) ) define("ALK_B_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE, "Espace");
  }
  /**
   * @brief Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  { 

  }
  
  /**
   * @brief Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  {
    return "Sélectionner la page";
    //return "Sélectionner une information de type ".$this->dataTitle;
  }
  
    /**
   * @brief Définition du contenu affiché du formulaire
   */
  protected function setContents(){
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_layer.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_treeview.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery.treeview.js");
    $this->addScriptCss("../../".ALK_ROOT_CLASSE."form/treeview.css");
    $this->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."gedit/lib/alkhtmllistpage.js");
    
    $this->setData(ALK_INIT_MODE_REQUEST);
    $iWidthSelect = 290;
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    $dsAppli = $oQueryEspace->getDs_listeAppliByEspaceType($this->cont_id, ALK_ATYPE_ID_GEDIT);
    $listIDApplis = "";
    while($drAppli = $dsAppli->getRowIter()){
      $listIDApplis .= $drAppli->getValueName("APPLI_ID").",";
    }
    $listIDApplis = substr($listIDApplis, 0, -1);
    $dsNoeud = $this->oAppli->oQuery->getArboAutorise($this->user_id, $listIDApplis, true, "-1", true, "-1", "-1", "-1", true);

    $nbNoeud = $dsNoeud->getCountTotDr();
    $iHeightLimit = 400;
    $iWidth = 305;
    
    $strHtml = "<div id='layerArbre' style='width:".($iWidth-5)."px;'>&nbsp;</div>";
    $oCtrlHtml = AlkHtmlFactory::getHtml($strHtml); 

    $strHtmlJsDeb =  "var objTreeview = null; ".
      " function AffTreeview() { ".
      "   objTreeview = new Treeview(document, 'layerArbre', 0); ".
      "   objTreeview.AddFolder(\"_0\", \"_\", \"Gestion éditoriale\", -1, 0, 1, \"\", \"\");";
      
    $strArbre = "";

    $idRoot = "0";
    $tabAppliPages= array();
    $tabAppliIntitule= array();
    while( $drNoeud = $dsNoeud->getRowIter() )  {
      $strHtmlJs = "";
      
      $idFils = $drNoeud->getValueName("PAGE_ID");
      $idRoot = ( $idRoot == "0" ? $idFils : $idRoot );
      //$idPere = ($drNoeud->getValueName("ID_PERE") == "0" ? $drNoeud->getValueName("APPLI_ID") : $drNoeud->getValueName("ID_PERE"));
      $idPere = $drNoeud->getValueName("ID_PERE");
      $iNiv   =  $drNoeud->getValueName("NIV")-1;
      //$iDroit = $drNoeud->getValueName("RIGHT_ID");
      //$iDroitAction = ( $iDroit >= 2 ? 2 : $iDroit );
      $iDroitAction = 1;
      $iDroitLink = 2;//( $iDroit >= 2 ? 2 : $iDroit );

      $strNom = str_replace("<br/>","",$drNoeud->getValueName("NOM".ALK_LG_BDD));
      $strNom = preg_replace( "/\"/", "'", $strNom);
      $strNom = preg_replace( "/'/", "\'", $strNom);
      
      $strUrlsHtml = "";
      $tabPageUrl     = array();
      $tabCtrlUrl     = array();
      $tabCtrlId      = array();
      $tabCtrlLinkId  = array();
      $tabLTypeId     = array();
      foreach($this->tabLangue as $key => $tabLg) {
        
        $pageUrl = addslashes(($this->bWithRootUrl ? "" : "/").$this->oAppli->oQuery->getPageUrl($idFils, "", $this->bWithRootUrl, $tabLg["bdd"]));
        if(count($this->tabLangue) > 1) {
          $strUrlsHtml .= "<a test=\\\"\\\" href=\\\"javascript:OpenFile('".$pageUrl."', '".$this->ctrlUrl.( $this->bCtrlMultilingue ? $tabLg["bdd"] : "" )."', ".$idFils.", '".$this->ctrlId.( $this->bCtrlMultilingue ? $tabLg["bdd"] : "" )."', '".$this->ctrlLinkId.( $this->bCtrlMultilingue ? $tabLg["bdd"] : "" )."', ".ALK_LTYPE_ID_PAGE.")\\\"><img class='alkimgicon alkimgicondrapeau".strtolower($tabLg["rep"])."' src='".ALK_MEDIA_URL."images/transp.gif' hspace='1' border='0'/></a>";
        }
        $tabPageUrl[]     = $pageUrl;
        $tabCtrlUrl[]     = addslashes($this->ctrlUrl.( $this->bCtrlMultilingue ? $tabLg["bdd"] : "" ));
        $tabCtrlId[]      = addslashes($this->ctrlId.( $this->bCtrlMultilingue ? $tabLg["bdd"] : "" ));
        $tabCtrlLinkId[]  = addslashes($this->ctrlLinkId.( $this->bCtrlMultilingue ? $tabLg["bdd"] : "" ));
        $tabLTypeId[]     = addslashes(constant("ALK_LTYPE_ID_PAGE".( $this->bCtrlMultilingue ? $tabLg["bdd"] : "" )));
      }
      if ( $strUrlsHtml != "" ) {
       $strUrlsHtml = "  ".$strUrlsHtml; 
      }
      if ( count($tabPageUrl) == 1 && count($tabCtrlUrl) == 1 && count($tabCtrlId) == 1 && count($tabCtrlLinkId) == 1 && count($tabLTypeId) == 1 ) {
        $strUrl = 'javascript:OpenFile(\''.$tabPageUrl[0].'\', \''.$tabCtrlUrl[0].'\', '.$idFils.', \''.$this->ctrlId.( $this->bCtrlMultilingue ? $tabLg["bdd"] : "" ).'\', \''.$this->ctrlLinkId.( $this->bCtrlMultilingue ? $tabLg["bdd"] : "" ).'\', '.ALK_LTYPE_ID_PAGE.')';
      } else if ( $this->bCtrlMultilingue ) {
        $strUrl = 'javascript:OpenFile([\''.implode('\',\'', $tabPageUrl).'\'], [\''.implode('\',\'', $tabCtrlUrl).'\'], '.$idFils.', [\''.implode('\',\'', $tabCtrlId).'\'], [\''.implode('\',\'', $tabCtrlLinkId).'\'], ['.implode(',', $tabLTypeId).'])';
      } else {
        $strUrl = 'javascript:OpenFile(\''.$tabPageUrl[0].'\', \''.$tabCtrlUrl[0].'\', '.$idFils.', \''.$this->ctrlId.( $this->bCtrlMultilingue ? $tabLg["bdd"] : "" ).'\', \''.$this->ctrlLinkId.( $this->bCtrlMultilingue ? $tabLg["bdd"] : "" ).'\', '.ALK_LTYPE_ID_PAGE.')';
      }
      
      $strHtmlJs .= " objTreeview.AddFolder(\"_".$idFils."\", \"_".$idPere."\", \"".$strNom."\", ".$iNiv.", ".
        $iDroitLink.", ".$iDroitAction.", \"".$strUrl."\", \"\", -1, 0, \"\", \"\", \"".$strUrlsHtml."\");";
      
      $tabAppliPages[$drNoeud->getValueName("APPLI_ID")][] = $strHtmlJs;
      $tabAppliIntitule[$drNoeud->getValueName("APPLI_ID")] = $drNoeud->getValueName("APPLI_INTITULE");
    }
    
    $strHtmlJs = "".$strHtmlJsDeb;
    $bFirst=0;
    
    foreach($tabAppliPages as $idAppli => $tabPages){
      if(count($tabAppliPages) > 1)
        $strHtmlJs .= "   objTreeview.AddFolder(\"_".$idAppli."\", \"_0\", \"<br/><h2 class=\'closed-hitarea expandable-hitarea lastExpandable-hitarea' >".$tabAppliIntitule[$idAppli]."</h2>\", -1, 0, 1, \"\", \"\", -1, 0, \"\", \"\", \"\");";
      if(! $bFirst){
        $strHtmlJs .= " objTreeview.OpenNode('_".$idAppli."');";
        $bFirst = 1;
      }
      foreach($tabPages as $page){
        $strHtmlJs .= $page;
      }
    }
    
    // parametrage
    $strHtmlJs .= " objTreeview.classLinkFolder = '';".
      " objTreeview.classTextFolder = '';".
      " objTreeview.classLinkDoc = '';".
      " objTreeview.classTextDoc = '';".

      " objTreeview.imgNodeOpen  = '';".
      " objTreeview.imgNodeClose = '';".
      " objTreeview.imgNode      = '';".
      " objTreeview.imgNodeFolder    = '';".
      " objTreeview.bShowNode = false;".
      " objTreeview.bCanShowHideNode = false;".
      " objTreeview.bViewHeader = true;".
      " objTreeview.bShowRoot = false;".
      " objTreeview.bShowHelp = true;".
      " objTreeview.iTabLg = ".($iWidth-25).";".
      " objTreeview.strToolTipDrawLine = \"Sélectionner une page\";";

    // affichage
    $strHtmlJs .= " objTreeview.OpenNode('_0');";
    $strHtmlJs .= " objTreeview.OpenNode('_".$idRoot."');";

    $strHtmlJs .= " }";

    $this->addJs($strHtmlJs);
    $this->addJs("function initJQuery(){ \$(document).ready(function(){\$('#layerArbre').treeview(); }); }");
    $this->addOnLoad("AffTreeview();initJQuery();");
    $strMsg = "<div id=\"geditArboHelp\" style=\"display:none\">Cliquez sur l'intitulé de la page pour la sélectionner.<br/>".(count($this->tabLangue)>1 ?"Ou cliquez sur le drapeau de la langue souhaitée." : "").
      "</div>";
    $oBlockList = $this->addBlock("block_0", "", $strMsg, "5", "495", true);
    $oBlockList->addCtrl(AlkHtmlFactory::getHtml($strHtml), ALK_HTMLFORM_1L1C);
    

  }
}
?>
