<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Form
Module formulaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkquery.class.php");

/**
 * @package Alkanet_Module_Form
 * @class AlkQueryForm
 * Classe contenant l'ensemble des requetes sélections de l'application formulaire
 */
class AlkQueryForm extends AlkQuery
{
  /**
   * Constructeur par défaut
   * @param oDb  Référence sur l'objet de connexion de type AlkDb
   */
  public function __construct(&$oDb)
  {
    parent::__construct($oDb);   
  }
   
  /**
   * Destructeur par défaut
   */
  public function __destruct() { }

  /**
   * Retourne la liste des formulaires pour une application
   * 
   * @param $appli_id : identifiant de l'application
   * @param $validepub : le formulaire est il publié ou pas ?
   * @return AlkDs
   */
  public function GetDs_ListeFormulairesByAppli($appli_id=-1, $validepub=-1)
  {
    $strWhere = " where 1=1";
    $strWhere.= ( $validepub !=-1 ? " and f.FORM_VALIDEPUB=".$validepub: "");
    $strWhere.= ($appli_id !=-1 ? " and APPLI_ID=".$appli_id :"");
    
    $strSql = "select f.* ".($appli_id==-1 ? ", sc.*" : "").
      $this->getMultilingueList("FORM_TITRE", "", true).",".
      $this->dbConn->GetDateFormat('DD/MM/YYYY', 'FORM_DATECREA', false)." as FORM_DATE_CREA,".
      $this->dbConn->GetDateFormat('DD/MM/YYYY', 'FORM_DATEMAJ', false)." as FORM_DATE_MAJ,".
      " FORM_SONDAGE, FORM_MAIL".
      " from FORM_01_FORM f".
      ($appli_id ==-1 ? " inner join SIT_APPLI_CONT sc on sc.APPLI_ID = f.APPLI_ID":"").
      $strWhere.
      " order by FORM_DATEMAJ desc";
    return $this->dbConn->InitDataSet($strSql);
  }
  
  /**
   * Retourne la liste des formulaires à publier pour une application
   * 
   * @param $appli_id : identifiant de l'application
   */
  public function getDs_ListeFormulairesAPublier($appli_id, $bPublication, $idFirst=0, $idLast=-1, $strOrder="", $bAlaune=0)
  {

    $strSql = "select FORM_ID ".
      $this->getMultilingueList("FORM_TITRE", "", true).", ".
      "FORM_VALIDEPUB, ".
      $this->dbConn->GetDateFormat('DD/MM/YYYY', 'FORM_DATEPDEB', false)." as DEBPUB, ".
      $this->dbConn->GetDateFormat('DD/MM/YYYY', 'FORM_DATEPFIN', false)." as FINPUB, ".
      $this->dbConn->GetDateFormat('DD/MM/YYYY', 'FORM_DATECREA', false)." as FORM_DATE_CREA,".
      $this->dbConn->GetDateFormat('DD/MM/YYYY', 'FORM_DATEMAJ', false)." as FORM_DATE_MAJ,".
      " FORM_SONDAGE, FORM_MAIL, FORM_DATEMAJ".
      " from FORM_01_FORM".
      " where APPLI_ID=".$appli_id.
      " and (FORM_DATEPDEB <= ".$this->dbConn->getDateCur()." or FORM_DATEPDEB is null)".
      " and (FORM_DATEPFIN >= ".$this->dbConn->getDateCur()." or FORM_DATEPFIN is null)".
      " and FORM_VALIDEPUB = ".$bPublication.
      ( defined("ALK_B_FORM_ALAUNE") && ALK_B_FORM_ALAUNE && $bAlaune ? " and FORM_ALAUNE = 1": "").
      ( $strOrder == ""
        ? " order by FORM_DATEMAJ desc"
        : " order by ".$strOrder );
     
    return $this->dbConn->InitDataSet($strSql);
  }
  
  /**
   * Retourne la liste des formulaires à venir pour une application
   * 
   * @param $appli_id : identifiant de l'application
   */
  public function getDs_ListeFormulairesAVenir($appli_id, $bPublication, $idFirst=0, $idLast=-1, $strOrder="")
  {
    $strSql = "select FORM_ID ".
      $this->getMultilingueList("FORM_TITRE", "", true).
      " , FORM_VALIDEPUB as VALIDEPUB,".
      " ".$this->dbConn->GetDateFormat('DD/MM/YYYY', 'FORM_DATECREA', false)." as FORM_DATE_CREA,".
      " ".$this->dbConn->GetDateFormat('DD/MM/YYYY', 'FORM_DATEMAJ', false)." as FORM_DATE_MAJ,".
      " FORM_SONDAGE, FORM_MAIL, FORM_DATEMAJ".
      " from FORM_01_FORM".
      " where APPLI_ID=".$appli_id.
      " and FORM_DATEPDEB > ".$this->dbConn->getDateCur().
      " and FORM_VALIDEPUB = ".$bPublication.
      ( $strOrder == ""
        ? " order by FORM_DATEMAJ desc"
        : " order by ".$strOrder );
    return $this->dbConn->InitDataSet($strSql);
  }
  
  /**
   * Retourne la liste des formulaires archivés pour une application
   * 
   * @param $appli_id : identifiant de l'application
   */
  public function getDs_ListeFormulairesArchive($appli_id, $bPublication, $idFirst=0, $idLast=-1, $strOrder="")
  {
    $strSql = "select FORM_ID ".
      $this->getMultilingueList("FORM_TITRE", "", true).
      " , FORM_VALIDEPUB as VALIDEPUB,".
      $this->dbConn->GetDateFormat('DD/MM/YYYY', 'FORM_DATECREA', false)." as FORM_DATE_CREA,".
      $this->dbConn->GetDateFormat('DD/MM/YYYY', 'FORM_DATEMAJ', false)." as FORM_DATE_MAJ,".
      " FORM_SONDAGE, FORM_MAIL, FORM_DATEMAJ".
      " from FORM_01_FORM".
      " where APPLI_ID=".$appli_id.
      " and FORM_DATEPFIN < ".$this->dbConn->getDateCur().
      " and FORM_VALIDEPUB = ".$bPublication.   
      ( $strOrder == ""
        ? " order by FORM_DATEMAJ desc"
        : " order by ".$strOrder );
    return $this->dbConn->InitDataSet($strSql);
  }
  
  /**
   * Retourne la liste des formulaires à valider une application
   * 
   * @param $appli_id : identifiant de l'application
   */
  public function getDs_ListeFormulairesAValider($appli_id, $idFirst=0, $idLast=-1, $strOrder="")
  {
    $strSql = "select FORM_ID ".
      $this->getMultilingueList("FORM_TITRE", "", true).
      " , FORM_VALIDEPUB as VALIDEPUB,".
      $this->dbConn->GetDateFormat('DD/MM/YYYY', 'FORM_DATECREA', false)." as FORM_DATE_CREA,".
      $this->dbConn->GetDateFormat('DD/MM/YYYY', 'FORM_DATEMAJ', false)." as FORM_DATE_MAJ,".
      " FORM_SONDAGE, FORM_MAIL, FORM_DATEMAJ".
      " from FORM_01_FORM".
      " where APPLI_ID=".$appli_id.
      " and FORM_VALIDEPUB = 0".
      ( $strOrder == ""
        ? " order by FORM_DATEMAJ desc"
        : " order by ".$strOrder );
    return $this->dbConn->InitDataSet($strSql);
  }
    
  /**
   * Retourne les informations du formulaire avec les dates mises en forme
   * @param form_id  identifiant de la formulaire
   * @return AlkDs
   */
  public function GetDs_formulaire($form_id)
  {
    $strTitreChamp = "";
    $strContenuChamp = "";
    
    $bAr = (defined("ALK_B_FORM_AR") && ALK_B_FORM_AR);
    $bReponse = (defined("ALK_B_FORM_REPONSE") && ALK_B_FORM_REPONSE);
        
    $strSql = "select f.FORM_ID".
      $this->getMultilingueList("f.FORM_TITRE", "", true).
      $this->getMultilingueList("f.FORM_CONTENU", "", true).
      $this->getMultilingueList("f.FORM_MSG_AR", "", true).",".
      $this->dbConn->getDateFormat("DD/MM/YYYY, HH:MI",  "f.FORM_DATECREA", false)." as FORM_DATE_CREA,".
      $this->dbConn->getDateFormat("DD/MM/YYYY, HH:MI",  "f.FORM_DATEMAJ", false)." as FORM_DATE_MAJ,".
      $this->dbConn->getConcat("ac.AGENT_PRENOM", "' '", "ac.AGENT_NOM")." as agent_nomcrea,".
      $this->dbConn->getConcat("am.AGENT_PRENOM", "' '", "am.AGENT_NOM")." as agent_nommaj,".
      "f.FORM_MAIL,".
      "f.FORM_SONDAGE,".
      "f.FORM_ENVOI_PDF,".
      "f.FORM_VALIDEPUB,".
      "f.FORM_NBREP_MAX,".
      "f.FORM_BTSAVE,".
      $this->dbConn->getDateFormat("DD/MM/YYYY",  "f.FORM_DATEPDEB", false)." as FORM_DATEPDEB,".
      $this->dbConn->getDateFormat("DD/MM/YYYY",  "f.FORM_DATEPFIN", false)." as FORM_DATEPFIN".
      ( $bAr || $bReponse
        ? ", f.FORM_CHAMPMAIL_AR" 
        : "" ).
      ( $bAr 
        ? ", f.FORM_ENVOI_AR, f.FORM_DONNEES_AR, f.FORM_CONTENU_AR" 
        : "" ).
      (defined("ALK_B_FORM_ALAUNE") && ALK_B_FORM_ALAUNE ? ", f.FORM_ALAUNE": "").
      ", f.FORM_SECURE ".
      ", f.FORM_REP_UNIQUE ".
      " from FORM_01_FORM f".
      "   inner join SIT_AGENT ac on f.AGENT_ID_CREA=ac.AGENT_ID".
      "   inner join SIT_AGENT am on f.AGENT_ID_MAJ=am.AGENT_ID".
      " where f.FORM_ID=". $form_id;
    
    return $this->dbConn->InitDataSet($strSql);
  }
  
  /**
   * Retourne la liste des applis formulaire de l'espace sélectionné accessibles à l'utilisateur
   * alkappliformulaire.class.php
   *
   * @param cont_id Identifiant du conteneur
   * @param agent_id Identifiant de l'agent
   * @return Retourne un dataSet
   */
  public function GetDs_listeAppliFormulaireForCombo($cont_id, $agent_id)
  {
    $strSql = "select ".$this->dbConn->GetSubstring("a.APPLI_INTITULE", 0, 40)." as NOM, a.APPLI_ID".
      " from SIT_APPLI_CONT ac".
      "   inner join SIT_APPLI a on ac.APPLI_ID=a.APPLI_ID".
      "   inner join V_USER_RIGHT aa on a.APPLI_ID=aa.APPLI_ID".
      " where ac.CONT_ID=".$cont_id." and a.ATYPE_ID=".ALK_ATYPE_ID_FORM.
      " and aa.USER_ID=".$agent_id." and aa.RIGHT_ID>0".
      " order by NOM";
    
    return $this->dbConn->InitDataSet($strSql);
  }
  
  /**
   *  Obtention de la liste des formulaires à publier par appli
   * @param appli_id Identifiant de l'application
   * @param idFirst  paramètre de pagination, indice de début, =0 par défaut pour aucune pagination
   * @param idLast   paramètre de pagination, indice de fin, =-1 par défaut pour aucune pagination
   * @return AlkDs
   */
  public function getFormsAPublier($appli_id, $idFirst=0, $idLast=-1)
  {
    $strContenuChamp = "";
    $strJavascriptChamp = "";
    
    $strSql = "select FORM_ID".
      $this->getMultilingueList("FORM_TITRE", "", true).
      $this->getMultilingueList("FORM_CONTENU", "", true).
      $this->getMultilingueList("FORM_JAVASCRIPT", "", true).
      ", FORM_SONDAGE, FORM_MAIL".
      " from FORM_01_FORM".
      " where (FORM_DATEPDEB <= ".$this->dbConn->getDateCur()." or FORM_DATEPDEB is null)".
      " and (FORM_DATEPFIN >= ".$this->dbConn->getDateCur()." or FORM_DATEPFIN is null)".
      " and FORM_VALIDEPUB = 1";
                     
    if( $appli_id > 0 )
      $strSql .= " and APPLI_ID =".$appli_id;
    
    return $this->dbConn->initDataset($strSql, $idFirst, $idLast) ;
  }

  /**
   * Obtention de la liste des formulaires par bloc
   * @param idBloc  identifiant du bloc  
   * @return AlkDs
   */
  public function getFormByBlocId($idBloc)
  {
    $strContenuChamp = "";
    $strJScriptChamp = "";
    
    $strSql = "select f.FORM_ID,".
      $this->getMultilingueList("f.FORM_TITRE", "", true).
      $this->getMultilingueList("f.FORM_CONTENU", "", true).
      $this->getMultilingueList("f.FORM_JAVASCRIPT", "", true).
      ", f.FORM_MAIL".
      " from FORM_01_FORM f".
      "   LEFT JOIN FORM_01_FORM_BLOC fb on f.FORM_ID = fb.FORM_ID".
      " where fb.BLOC_ID = ".$idBloc.
      " and (FORM_DATEPDEB <= ".$this->dbConn->getDateCur()." or FORM_DATEPDEB is null)".
      " and (FORM_DATEPFIN >= ".$this->dbConn->getDateCur()." or FORM_DATEPFIN is null)".
      " and FORM_VALIDEPUB = 1";
    
    return $this->dbConn->initDataset($strSql);
  }  
  
  /**
   * Retourne les informations liées à un bloc
   * filtre en fonction des bits allumés sur bloc_typeassoc
   * 
   * @param bloc_id        Identifiant du bloc
   * @param bloc_typeassoc type d'association : 0=aucune, 1=appli, 2=cat, 3=data
   *                       si bit 2 on =4 : filtre publication : news uniquement
   *                       si bit 3 on =8 : filtre publication : infos publiés passés (archivés)
   *                       si bit 4 on =16: filtre publication : infos publiés présents
   *                       si bit 5 on =32: filtre publication : infos non publiés
   *                       bit 6 au bit 12 : anciennes versions de tris prédéfinis 
   *                       si bit 13 on : ordre : champ nouveauté
   *                       si bit 14 on : ordre : champ catégorie
   *                       si bit 15 on : ordre : champ data
   *                       si bit 16 on : ordre : champ date pub décroissant
   *                       si bit 17 on : ordre : champ date pub croissant
   *                       si bit 18 on : ordre : champ date info décroissant
   *                       si bit 19 on : ordre : champ date info croissant
   *                       si bit 20 on : ordre : champ date maj décroissant
   *                       si bit 21 on : ordre : champ date maj croissant
   *                       si bit 22 on : filtre calendaire : date début-fin pub 
   *                       si bit 23 on : filtre calendaire : date début-fin info 
   *                       si bit 24 on : filtre calendaire : date début-fin màj
   *                       si bit 25 on : filtre publication : infos synf 
   *                       si bit 26 on : filtre publication : en cours de validation
   *                       si bit 27 on : filtre publication : 30 derniers jours date pub
   *                       si bit 28 on : filtre publication : 30 derniers jours date info
   *                       si bit 29 on : filtre publication : 30 derniers jours date màj
   *                       si bit 30 on : ordre : champ rang des données décroissant
   *                       si bit 31 on : ordre : champ rang des données croissant
   * @param user_id           identifiant de l'utilisateur connecté, si -1, non vérification des droits
   * @param bAdmin         =true pour l'affichage côté backoffice, = false pour l'affichage consultation
   * @param strLg             langue utilisée, =_FR par défaut
   * @param bloc_ordre     liste de nombres séparés par une virgule. 1 nombre correspond à une puissance de deux. 
   *                       cette liste correspond à l'ordre des champs d'après les champs de bit de bloc_typeassoc
   * @param bloc_datedeb   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc
   * @param bloc_datefin   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc 
   * @param bloc_limit     contient le nombre d'éléments à afficher
   * @return AlkDs
   */
  public function getDsListFormByBlocId($bloc_id, $bloc_typeassoc, $user_id, $bAdmin=false, 
                                        $strLg=ALK_LG_BDD, $bloc_ordre="", $bloc_datedeb="", $bloc_datefin="", $bloc_limit="-1")
  {
    $strSql = "";
    
    if( $bAdmin ) {
      // retourne le formulaire sélectionné
      $strSql = "select d.DATA_ID, d.DATA_TITRE".$strLg.", d.DATA_DESCL".$strLg.",".
        " db.FORM_RANG as DATA_RANG".
        " from V_GEDIT_FORM_DATA d".
        "   inner join FORM_01_FORM_BLOC db on d.DATA_ID=db.FORM_ID".
        " where db.BLOC_ID=".$bloc_id." and d.USER_ID=".$user_id." and d.RIGHT_ID>0 and d.DATA_VALIDEPUB=1".
        "   and (d.DATA_DATEPFIN is null or d.DATA_DATEPFIN>".$this->dbConn->getDateCur().")";
        //" order by DATA_RANG, DATA_TITRE_FR"; // pas nécessaire de trier puisque un seul résultat au pire
    } 
    else {
      // retourne le formulaire du bloc - pas nécessaire de calculer l'ordre de tri
      //$strSqlOrder = $this->getSqlOrderByGEditBlocTypeAssoc($bloc_typeassoc, $strLg, $bloc_ordre, "");
      $strSqlWhere = $this->getSqlWhereByGEditBlocTypeAssoc($bloc_typeassoc, $bloc_datedeb, $bloc_datefin);
     
      $strSql = "select d.*, db.FORM_RANG as DATA_RANG".
        " from V_GEDIT_FORM_DATA d".
        "   inner join FORM_01_FORM_BLOC db on d.DATA_ID=db.FORM_ID".
        " where ".
        "   db.BLOC_ID=".$bloc_id." and d.USER_ID=".$user_id." and d.RIGHT_ID>0".
        ( $strSqlWhere != "" ? " and " : "" ).$strSqlWhere;
        //($bloc_limit > -1 ? " limit ".$bloc_limit : -1);
    }
    return $this->dbConn->initDataset($strSql);
  }

/**
   * Retourne les informations :
   *  - de l'info data_id=object_id si typeassoc&3=3
   *  - des infos de la classification =object_id si typeassoc&2=2
   *  - des infos de appli_id=object_id si typeassoc&1=1
   *  - des infos de cont_id=object_id si typeassoc&3=0, de tous les espaces si object_id=-1
   * filtre en fonction des bits allumés sur typeassoc
   * 
   * @param object_id        identifiant de l'information, de la classification, de l'application ou de l'espace en fonction du 2nd paramètre
   * @param typeAssoc        type d'association : 0=cont, 1=appli, 2=classif, 3=data
   *                            si bit 2 on : présente les infos publiées à la une
   *                            si bit 3 on : présente les infos publiées passées
   *                            si bit 4 on : présente les infos publiées présentes
   *                            si bit 5 on : présente les infos à valider
   *                            si bit 6 on : ordre les éléments d'abord par intitulé de catégorie
   *                            si bit 7 on : présente les docs syndiqués 
   *                            si bit 8 on : ordre les éléments d'abord par nouveauté (à la une) puis par intitulé de catégorie puis par titre
   *                            si bit 9 on : présente les  infos en cours de validation 
   *                            si bit 10 on: ordre par date de publication d'abord 
   *                            si bit 11 on: présente toutes les infos (en cours, publiée ou à valider)
   *                            si bit 12 on : ordre par date de publication croissante d'abord
   *                            si <=3, présente toutes les pages publiées : passés, présent, à venir
   * @param user_id           identifiant de l'utilisateur connecté, si -1, non vérification des droits
   * @param strLg             langue utilisée, =_FR par défaut
   * @param strAppliTypeAbrev abreviation de la sous appli iedit
   * @param strMotsCles       mots clés à rechercher dans le titre ou le descriptif de l'info (une expression ou un tableau de mots)
   * @param strFilterComplt   filtre complémentaire (condition ajoutée à la partie where). Doit commencer par and
   * @param iFirst            indice de début de pagination, =0 par défaut
   * @param iLast             indice de fin de pagination, =-1 par défaut pour aucune pagination
   * @param data_id_list      vide par défaut, = liste d'identifiants trouvés au préalable lors d'une analyse des pj par exemple
   * @return AlkDs
   */
  public function getDsListFormById($object_id, $typeAssoc, $user_id, $strLg=ALK_LG_BDD)
  {
    $strWhere = "";
    $strSql = "";
    
    
    if( binmask_match($typeAssoc, TASSOC_BYDATA) ) {
      $strWhere = "d.DATA_ID=".$object_id; 
    } elseif( binmask_match($typeAssoc, TASSOC_BYAPPLI) ) {
      $strWhere = "d.APPLI_ID=".$object_id; 
    } elseif( binmask_match($typeAssoc, TASSOC_BYDATA, 0) ) {
      $strWhere = ( $object_id != "-1" ? "d.CONT_ID=".$object_id : "d.CONT_ID>0" );
    }
    
    $strFilter="";
    
    if( binmask_match($typeAssoc, TASSOC_ALAUNE) ) {
      // filtre sur news
      $strFilter .= " and d.DATA_NEW=1";
    }
    if( binmask_match($typeAssoc, TASSOC_ARCHIVE) ) {
      // filtre sur docs passés
      if( !binmask_match($typeAssoc, TASSOC_PUBLIE) )
        $strFilter .= " and d.DATA_DATEPFIN < ".$this->dbConn->getDateCur();
    }
    if( binmask_match($typeAssoc, TASSOC_PUBLIE) ) {
      // filtre sur docs présents
      $strFilter .= " and (d.DATA_DATEPDEB <= ".$this->dbConn->getDateCur()." or d.DATA_DATEPDEB is null)".
        ( !binmask_match($typeAssoc, TASSOC_ARCHIVE) 
          ? " and (d.DATA_DATEPFIN >= ".$this->dbConn->getDateCur()." or d.DATA_DATEPFIN is null)"
          : "" );
    }
    
    if( binmask_match($typeAssoc, TASSOC_AVALIDER) ) {
      $strFilter .= " and d.DATA_VALIDEPUB=0";
    } elseif( binmask_match($typeAssoc, TASSOC_ENVALIDATION) ) { 
      $strFilter .= " and d.DATA_VALIDEPUB=2";
    } elseif( !binmask_match($typeAssoc, TASSOC_TOUTETATPUB) ) {
      $strFilter .= " and d.DATA_VALIDEPUB=1";
    }
    if( binmask_match($typeAssoc, TASSOCORDER_CATEGORIE) && !binmask_match($typeAssoc, TASSOCORDER_DATEINFOPUB) ) {
      $orderBy = "CAT_INTITULE".$strLg.", DATA_DATEPDEB desc, DATA_DATEPFIN desc, DATA_TITRE".$strLg;
                          
    } elseif( binmask_match($typeAssoc, TASSOCORDER_NOUVEAUTE) ) {
      $orderBy = "DATA_NEW desc, CAT_INTITULE".$strLg.", DATA_TITRE".$strLg.", DATA_DATEPDEB desc, DATA_DATEPFIN desc, DATA_TITRE".$strLg;

    } elseif( binmask_match($typeAssoc, TASSOCORDER_DATEINFOPUBDESC) && !binmask_match($typeAssoc, TASSOCORDER_CATEGORIE) ) {
      $orderBy = "DATA_DATEPDEB desc, DATA_DATEPFIN desc, DATA_TITRE".$strLg.", CAT_INTITULE".$strLg;
                          
    } elseif( binmask_match($typeAssoc, TASSOCORDER_DATEINFOPUBDESC) && binmask_match($typeAssoc, TASSOCORDER_CATEGORIE) ) {
      $orderBy = "CAT_INTITULE".$strLg.", DATA_DATEPDEB, DATA_DATEPFIN,DATA_TITRE".$strLg;

    } elseif( binmask_match($typeAssoc, TASSOCORDER_DATEINFOPUB) && !binmask_match($typeAssoc, TASSOCORDER_CATEGORIE) ) {
      $orderBy = "DATA_DATEPDEB, DATA_DATEPFIN,DATA_TITRE".$strLg.", CAT_INTITULE".$strLg;
    
    } elseif( binmask_match($typeAssoc, TASSOCORDER_DATEINFOPUB) && binmask_match($typeAssoc, TASSOCORDER_CATEGORIE) ) {
      $orderBy = "CAT_INTITULE".$strLg.",DATA_DATEPDEB, DATA_DATEPFIN, DATA_TITRE".$strLg;

    } else {
      $orderBy = "DATA_DATEPDEB desc, DATA_DATEPFIN desc, DATA_TITRE".$strLg.", CAT_INTITULE".$strLg;

    }
    
    if( binmask_match($typeAssoc, TASSOC_ESTSYNDIQUE) ) {
      $strFilter .= " and d.DATA_VALIDESYND=1";
    } 

    $strSql = "select d.*, 0 as DATA_RANG,".
      $this->dbConn->getDateFormat("DD/MM/YYYY",  "d.DATA_DATEPFIN", false)." as DATA_DATE_PFIN".
      ( $user_id != "-1" 
        ? ",".$this->dbConn->getDateFormat("DD/MM/YYYY",  "d.DATA_DATEMAJ", false)." as DATA_DATE_MAJ"
        : "" ).
      " from ".( $user_id != "-1" ? "V_GEDIT_FORM_DATA d" : "V_SYND_FORM_DATA d" ).
      " where ".$strWhere.
      ( $user_id != "-1" 
        ? " and d.USER_ID=".$user_id." and d.RIGHT_ID>0".$strFilter
        : "" ).
      " order by ".$orderBy;
    
    return $this->dbConn->initDataset($strSql);
  }
  
  /**
   * Retourne par référence, le cont_id et appli_id associé à form_id
   * @param cont_id   par référence, contient id de l'espace contenant appli_id
   * @param appli_id  par référence, contient id de l'appli contenant form_id
   * @param form_id   identifiant du formulaire
   */
  public function getContAppliIdByFormId(&$cont_id, &$appli_id, $form_id)
  {
    $cont_id = "-1";
    $appli_id = "-1";
    $strSql = "select f.APPLI_ID, ac.CONT_ID".
      " from FORM_01_FORM f".
      "   inner join SIT_APPLI_CONT ac on f.APPLI_Id=ac.APPLI_ID".
      " where f.FORM_ID=".$form_id;
    $dsForm = $this->dbConn->initDataset($strSql);
    if( $drForm = $dsForm->getRowIter() ) {
      $cont_id = $drForm->getValueName("CONT_ID");
      $appli_id = $drForm->getValueName("APPLI_ID");
    } 
  }
  
  public function GetLastReponseId(){
    $strSql = "select * from SEQUENCE";
    $dsRep = $this->dbConn->initDataset($strSql);
    if( $drForm = $dsRep->getRowIter() ) {
      return $drForm->getValueName("SEQ_FORM_01_REPONSE");
    }
  }
  
}

?>