<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlPopupContact
 * Classe de gestion de droit par utilisateur sur les applis d'un espace
 */
class AlkHtmlPopupContact extends AlkHtmlForm 
{
  protected $ctrlFromName;
  protected $ctrlFromMail;
  protected $ctrlTitle;
  protected $ctrlMsg;
  protected $securecode;

  /**
   * Constructeur par défaut
   * @param oAppli  Référence sur l'appli annuaire
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formContact");

    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
  }

  /**
   * Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) 
  { 
    $userId    = AlkFactory::getSProperty("user_id", "");
    $userName  = ( $userId != ALK_USER_ID_INTERNET ? AlkFactory::getSProperty("user_name", "") : "" );
    $userMail  = ( $userId != ALK_USER_ID_INTERNET ? AlkFactory::getSProperty("user_mail", "") : "" );
    $userPhone = "";

    $this->ctrlFromName        = new AlkFormData($this, "ctrlFromName",  $userName,  ALK_SQL_TEXT);
    $this->ctrlFromMail        = new AlkFormData($this, "ctrlFromMail",  $userMail,  ALK_SQL_TEXT);
    $this->ctrlFromPhone       = new AlkFormData($this, "ctrlFromPhone", $userPhone, ALK_SQL_TEXT);
    $this->ctrlTitle           = new AlkFormData($this, "ctrlTitle",     "",         ALK_SQL_TEXT);
    $this->ctrlMsg             = new AlkFormData($this, "ctrlMsg",       "",         ALK_SQL_TEXT);
    $this->securecode           = new AlkFormData($this, "securecode",         "", ALK_SQL_NONE);

    $oDrData = null;
    $reqMethod = -1;
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
    $this->initData($iTypeInit, $oDrData, $reqMethod);
  }
  
  /**
   * Appel des actions SQL sur les données du formulaire
   */
  public function doSql() { }
  
  /**
   * retourne le titre / surcharge car pour les popup le gethtml est appelé après
   * @return string 
   */
  public function getTitle()
  {
    return _t("Contacter un administrateur");
  }  
    
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $iSend = AlkRequest::getToken("iSend", 0);
    if( $iSend == "1" ) {
      $this->setData(ALK_INIT_MODE_REQUEST);
      $this->setContentsAfter();
      return;
    }
    $this->setData(-1);

    $iWidthTxt   = 48;
    $iWidthMemo  = 46;
    $iHeightMemo = 10;
    $iWidthLabel = 130;
    $iWidthCtrl  = 390;

    $this->setLabelDesc(_f("Veuillez préciser vos coordonnées ainsi que le problème rencontré.%nl Un administrateur vous répondra ou vous contactera afin de le régler rapidement.", "<br/>"));

    $oCtrlTxtN = AlkHtmlFactory::getHtmlText($this->ctrlFromName, _t("Votre prénom et nom"), 1, $iWidthTxt, 80);
    $oCtrlTxtN->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
    if( $this->ctrlFromName->value != "" )
      $oCtrlTxtN->setMode(1);

    $oCtrlTxtM = AlkHtmlFactory::getHtmlText($this->ctrlFromMail, _t("Votre courriel"), 1, $iWidthTxt, 255);
    $oCtrlTxtM->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_MAIL);
    if( $this->ctrlFromMail->value != "" )
      $oCtrlTxtM->setMode(1);

    $oCtrlTxtP = AlkHtmlFactory::getHtmlText($this->ctrlFromPhone, _t("Votre téléphone"), 1, $iWidthTxt, 30);
    $oCtrlTxtP->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXTNUM);
    if( $this->ctrlFromPhone->value != "" )
      $oCtrlTxtP->setMode(1);

    $oCtrlTxtS = AlkHtmlFactory::getHtmlText($this->ctrlTitle, _t("Type de problème"), 1, $iWidthTxt, 80);
    $oCtrlTxtS->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);

    $oCtrlMemo = AlkHtmlFactory::getHtmlText($this->ctrlMsg, _t("Détaillez votre problème"), $iHeightMemo, $iWidthMemo, 1000);
    $oCtrlMemo->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT, 0, 4000);

    $oCtrlSecure = null;
    if ( !(defined("ALK_B_SECURE_MODE") && ALK_B_SECURE_MODE==false) ){
      $oCtrlSecure = AlkHtmlFactory::getHtmlText($this->securecode, _t("Code de sécurité"), 1, 6, 6);
      $oCtrlSecure->addValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
      $oCtrlSecureImg = AlkHtmlFactory::getHtml("<a title=\""._t("Un autre code")."\" href=\"javascript:loadSecureImg('sImg".$oCtrlSecure->getGUID()."')\"><image id='sImg".$oCtrlSecure->getGUID()."' src='".ALK_ALKANET_CAPTCHA."' height='25' border='0'></a>");
      $oCtrlSecure->addCtrl($oCtrlSecureImg);
    }

    $oBlockProp =& $this->addBlock("blockProp", "", "", $iWidthLabel, $iWidthCtrl);
    $oBlockProp->addCtrl($oCtrlTxtN);
    $oBlockProp->addCtrl($oCtrlTxtM);
    $oBlockProp->addCtrl($oCtrlTxtP);
    $oBlockProp->addCtrl($oCtrlTxtS);
    $oBlockProp->addCtrl($oCtrlMemo);
    $oBlockProp->addCtrl($oCtrlSecure);

    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_CONTACT, ALK_SHEET_NONE, "&iSend=1");
    $oButton = $this->addButtonPage("bt_Valider", "javascript:Valider('".$strToken."')", _t("Valider"), _t("Valider les droits"));
    $this->addSubmitButton($oButton);

    $this->addButtonPage("bt_Annuler", "javascript:closeWindow()", _t("Annuler"), _t("Annuler les modifications"));
        
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlpopupcontact.js");
  }

  /**
   * Envoi du message puis affichage d'un texte
   */
  protected function setContentsAfter()
  {
    setMailAlkLocale(ALK_MAIL_ADMIN_LG);
    $oAlkMail = AlkFactory::getMail();
    
    $oAlkMail->SetFrom($this->ctrlFromName->value, $this->ctrlFromMail->value);
    $oAlkMail->AddTo(ALK_MAIL_ADMIN_NAME, ALK_MAIL_ADMIN_MAIL);
    $strType = "ESPACE_CONTACT";

    $tabAssoc["msgTitle"] = $this->ctrlTitle->value;
    $tabAssoc["msg"] = _f("J'étais connecté au %s le %s à %s.", ALK_S_SIT, date("d/m/Y"), date("H:i")).'<br/>'.
      _t("j'ai rencontré le problème suivant :").
      '<ul>'.nl2br($this->ctrlMsg->value).'</ul><br/>'.
      _f("Mon numéro de téléphone : %s", $this->ctrlFromPhone->value).'<br/><br/>';

    // informations complémentaires
    $tabAssoc["agent_pb"] = nl2br($this->ctrlMsg->value);
    $tabAssoc["agent_tel"] = $this->ctrlFromPhone->value;
      
    $iRes = AlkMailing::SendMailType($oAlkMail, $strType, $tabAssoc);    
    setCurrentAlkLocale();
    
    $this->setLabelDesc("<br><br>".
                        ( $iRes > 0 
                          ? _t("Votre demande a été transmise.")
                          : _t("Votre message n'a pas été envoyé.") ).
                        "<br><br>");
    $this->addButtonPage("bt_Close", "javascript:closeWindow()", _t("Fermer"), _t("Fermer la fenêtre"));
  }

}

?>