<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Dico
Module fournissant les pages d'administration de dictionnaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH."classes/pattern/alkquery.class.php");

/**
 * @package Alkanet_Module_Dico
 * 
 * @class AlkQueryDico
 * @brief Ensemble des requetes selection de l'application Dico
 */
class AlkQueryDico extends AlkQuery 
{

  /**
   *  Constructeur
   */ 
  public function __construct(&$oDb)
  {
    parent::__construct($oDb);   
  }
   
  /**
   *  Destructeur par défaut
   */
  public function __destruct() { }
  
  /**
   * Retourne la liste des éléments d'un dictionnaire
   *  
   * @param dico      nom de la table dictionnaire
   * @param tabDico   tableau associatif contenant les infos sur la table
   * @param iFirst    indice début de pagination (=0 par défaut)
   * @param iLast     indice fin de pagination (-1 par défaut, pour ne pas paginer) 
   * @return AlkDataSet
   */
  public function getDs_listeDico($dico, $tabDico, $iFirst=0, $iLast=-1)
  {
    $strSelect = "";
    foreach($tabDico as $strAlias => $oElt) {
      if( $strAlias != "title" && $strAlias != "search" ) {
        $strElt = ( is_array($oElt) ? $oElt[0] : $oElt );
        if (!is_string($strElt)) continue;
        $strSelect .= ( $strSelect !="" ? ", " : "" ).
          $strElt." as \"".mb_strtolower(mb_convert_encoding($strAlias, ALK_SGBD_ENCODING))."\"";
      }
    }

    $strSql = "select ".$strSelect.
      " from ".$dico.
      ( isset($tabDico["search"]["orderBy"])  
        ? " order by ".$tabDico["search"]["orderBy"]
        : "" );
    return $this->dbConn->initDataset($strSql, $iFirst, $iLast);
  }
  
  /**
   * Retourne la fiche d'un élément dictionnaire
   *  
   * @param dico     nom de la table dictionnaire
   * @param tabDico  tableau associatif contenant les infos sur la table
   * @param id       identifiant de l'élément sélectionné
   * @return AlkDataSet
   */
  public function getDs_ficheDico($dico, $tabDico, $id)
  {
    $strSelect = "";
    foreach($tabDico as $strAlias => $oElt) {
      if( $strAlias != "title" && $strAlias != "search"  && $strAlias != "redirect" ) {
        $strElt = ( is_array($oElt) ? $oElt[0] : $oElt );
        if (!is_string($strElt)) continue;
        $strSelect .= ( $strSelect !="" ? ", " : "" ).
          $strElt." as \"".mb_strtolower(mb_convert_encoding($strAlias, ALK_SGBD_ENCODING))."\"";
      }
    }

    $strSql = "select ".$strSelect.
      " from ".$dico.
      " where ".$tabDico["id"]."=".$id;
    
    $strSql;
    return $this->dbConn->initDataset($strSql);
  }
  
  /**
   * Retourne la liste des éléments obtenu à partir d'une jointure in
   * 
   * @param tabDesc Tableau de paramétrage de la jointure
   * @param id      Identifiant de l'information
   * @return AlkDataSet
   */
  public function getDs_JoinIn($tabDesc, $id)
  {
  	$jointable = $tabDesc["jointable"];
  	$fromtable = $tabDesc["fromtable"];
  	$chpjoin   = $tabDesc["chpjoin"];
  	$chpvar    = $tabDesc["chpvar"];
  	$chpvalue  = $tabDesc["chpvalue"];
  	
  	$strSql = "select ".$chpvalue.", t1.".$chpjoin.
      " from ".$fromtable." t1".
      "   inner join ".$jointable." t2 on t1.".$chpjoin."=t2.".$chpjoin.
      " where t2.".$chpvar."=".$id;
    
  	if( isset($tabDesc["orderBy"]) ) 
      $strSql .= " order by ".$tabDesc["orderBy"];
  	
    return $this->dbConn->initDataset($strSql);
  }

  /**
   * Retourne la liste des éléments obtenu à partir d'une jointure not in
   * 
   * @todo Requete à refaire pour postgres
   * 
   * @param tabDesc Tableau de paramétrage de la jointure
   * @param id      Identifiant de l'information
   * @return AlkDataSet
   */
  public function getDs_JoinNotIn($tabDesc, $id)
  {
  	$jointable = $tabDesc["jointable"];
  	$fromtable = $tabDesc["fromtable"];
  	$chpjoin   = $tabDesc["chpjoin"];
  	$chpvar    = $tabDesc["chpvar"];
  	$chpvalue  = $tabDesc["chpvalue"];
  	$strSql = "select ".$chpvalue.", t1.".$chpjoin.
      " from ".$fromtable." t1 " .
      " where " .
      "		if(t1.".$chpjoin." in " .
      "			(select ".$chpjoin." from ".$jointable." where ".$chpvar."=".$id.")," .
      "			0, 1" .
      "		)" ;
    
  	if( isset($tabDesc["orderBy"]) ) 
      $strSql .= " order by ".$tabDesc["orderBy"];
  	
    return $this->dbConn->initDataset($strSql);
  }

}
?>