<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Dico
Module fournissant les pages d'administration de dictionnaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."dico/classes/alkapplidico.class.php");

/**
 * @package  Alkanet_Module_Dico
 * 
 * @class AlkDicoFactory
 * @brief Classe abstraite nécessaire pour initialiser une appli dictionnaire
 */
abstract class AlkDicoFactory extends AlkObject 
{
  /** référence vers l'appli utilisant le dic */
  protected $oAppli;

	/** Référence vers l'objet de clase AlkAppliDico */
	protected $oAppliDico;

  /** tableau contenant la déclaration du dictionnaire */
  protected $tabDico;

  /**
   * Constructeur
   *
   * @param oAppli Référence de l'applicaton contenant le dictionnaire
   */
  public function __construct(&$oAppli) 
  {
    $this->oAppli = $oAppli;
    $this->oAppliDico = null;
    $this->tabDico = array();
	$this->_initTabDico();
	}
	
  /**
   *  Destructeur par défaut
   */
  public function __destruct() { }
  
	/**
	 * Méthode abstraite instanciant la table dictionnaire
	 * 
	 * Format de la table dictionnaire :
	 * "Nom_table_SQL" => 	{ "titre" 	=> "titre écrit dans le combo de recherche" ; obligatoire,
	 * 												"search"	=> 	{ "titres" => {liste des en-têtes de la table résultats de la recherche} ; obligatoire,
	 * 																				"pattern"=> "pattern pour l'affichage des résultats : 
	 * 																										'<i>' correspond à l'index du champ dans la table dico (i>2)
	 * 																										'|' 	marque le passage à une nouvelle colonne, il débute le pattern" ; obligatoire
	 * 																			},
	 * 											  "id"			=> "champ clé primaire de la table" ; obligatoire,
	 * 												["label du champ" => <description_affichage>]+
	 * 											}
	 * 
	 * Format de la description de l'affichage (type array) : 
	 *  - pour les controles de type "text"
	 * 		{	"champ dans table BD", taille du champ, bool pour chp obligatoire, type controle ("text", "textnum", "textalpha", "int")}
	 *  - pour les controles de type "file"
	 * 		{	<idem avec type controle="file">, "chemin d'upload'"}
	 * 
	 *  - pour les controles de type "hidden"
	 * 		{	<idem avec type controle="hidden">, "not_null" ou autre pour indiquer si le chp doit avoir une valeur par défaut, valeur par défaut}
	 * 
	 *  - pour les controles de type "combo_num" (combobox)
	 * 		{	"champ dans table BD", valeur initiale sélectionnée, bool pour chp obligatoire, "combo_num", 
	 * 					"requête sql à effectuer pour le remplissage", valeur par défaut(clé, valeur)}
	 * 
	 *  - pour les controles de type "list_join" 
	 * 	(pour les jointures multiples : ctrl combo contenant les valeurs non-jointes + ctrl liste contenant les valeurs jointes)
	 * 		{	{ "NOT_<chp_BD>[]", valeur initiale sélectionnée, valeur par défaut(clé, valeur) },
	 * 			{ "<chp_BD>[]", valeur initiale sélectionnée, valeur par défaut(clé, valeur) },
	 * 			taille des contrôles, bool pour chp obligatoire, "list_join", 
	 * 			{ "jointable" => table de jointure sans alias,
	 * 				"fromtable" => table de provenance de <chp_BD> sans alias,
	 * 				"chpjoin" 	=> champ de jointure (=<chp_BD>),
	 * 				"chpvar"		=> clé primaire du dictionnaire (champ variable)
	 * 				"chpvalue"	=> champ(s) issu(s) de fromtable formatés pour l'affichage dans les select
	 * 			} (toutes les clés de cette table sont requises)
	 * 		}
	 */
	abstract protected function _initTabDico();
  
		/**
		 * Exemple :
     * $this->tabDico = 
		 * 		array(
		 * 					"CDR" 				=> array(
		 *																		 "titre"       		=> "des CDR",
		 *		                                 "search"					=> array(
		 *		                                 												"titres" => array("Centre", "Code postal / Ville"),
		 *		                                 												"pattern"=>	"|<3>|<8> <9>"
		 *		                                 											),
		 *		                                 "id"          		=> "CDR_ID", 
		 *		                                 "Nom" 						=> array("CDR_NOM1", 255, true, "text"),
		 *		                                 "Adresse"     		=> array("CDR_ADR1", 255, true, "text"),
		 *		                                 "Code_postal" 		=> array("CDR_PCODE", 5, true, "textnum"),
		 *		                                 "Ville"       		=> array("CDR_VILLE", 150, true),
		 *		             "Liste des personnes liées"
		 *		             																			=> array(
		 *		             																						array(
		 *			             																						array("NOT_AGENT_ID[]", -1, array("null", ""),				
		 *																															),
		 *			             																						array("AGENT_ID[]", -1, array("null", ""),
		 *																															)
		 *																														),
		 *																														200, true, "list_join",
		 *			             																					array("jointable"=>"CDR_AGENT", 
		 *																																	"fromtable"=>"AGENT", 
		 *																																	"chpjoin"=>"AGENT_ID",  
		 *																																	"chpvar"=>"CDR_ID",  
		 *																																	"chpvalue"=>"concat(AGENT_NOM, ' ', AGENT_PRENOM)"),
		 *		             																					),
		 *                                     "Niveau"  				=> array("NIVEAU_ID", -1, true, "combo_num",
		 *                                                        			"select NIVEAU_NOM, NIVEAU_ID".
		 *                                                        			" from NIVEAU".
 		 *                                                       				" order by ORDRE", 
 		 * 																															array("null", ""))),
		 *		                             ),
		 *	);
		 */	
	
  
  /**
   * Retourne le premier dictionnaire du tableau tabDico, après avoir effectué ou pas un tri alphabétique sur les titres affichés
   * @param bSortDico (boolean=true) si vrai, trie les titres par ordre alphabétique
   * @return Le premier dictionnaire du tableau tabDico (trié ou pas)
   */
  public function getFirstDico($bSortDico=true){
    $tabTitle = array();

    foreach ($this->tabDico as $key=>$tabValue){
      $tabTitle[$key] = $tabValue["title"];
    }
    if ( $bSortDico ){
      asort($tabTitle);
    }
    return key($tabTitle);
  }
	/**
	 * Retourne une référence sur l'application dictionnaire construite à partir de la déclaration tabDico
	 * 
	 * @return AlkAppliDico
	 */
	public function getAppliDico()
  {
		if( $this->oAppliDico == null ) {
      $this->oAppliDico = AlkFactory::getAppli(ALK_ATYPE_ID_DICO, $this->oAppli->appli_id);
			$this->oAppliDico->setDataDico($this->tabDico);
    }
		return $this->oAppliDico;
	}
}
?>