<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlPopupUsersList
 * 
 * Classe de selection multiple d'utilisateur de l'Annuaire
 */
class AlkHtmlPopupUsersList extends AlkHtmlForm 
{
  /**
   *  Constructeur par défaut
   * @param oAppli  Référence sur l'appli annuaire
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formUsersList"); 
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
  }

   /**
   *  Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) { }
  
  /**
   *  Appel des actions SQL sur les données du formulaire
   */
  public function doSql() { return ""; }

  /**
   *  Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  {
    $abonne_id_filtre = AlkRequest::getToken("abonne_id_filtre", "0");
    return ( $abonne_id_filtre != "1" 
             ? _t("Sélectionner des agents de l'annuaire")
             : _t("Sélectionner des abonnés de l'annuaire") );
  }
  
  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    if(defined("ALK_B_ANNU_CLOISONNEMENT_SERVICE") && ALK_B_ANNU_CLOISONNEMENT_SERVICE==true && !AlkFactory::isAnnuAdminAll())
    	$serv_id = AlkFactory::getSProperty("service_id", -1);
    else
    	$serv_id = -1;
    $cont_id = AlkRequest::getToken("cont_id", "-1"); 

    // filtre les abonnés si <> "", l'identifiant sera alors l'id de l'abonné
    // =0 sélection d'agents avec retour agent_id
    // =1 sélection d'abonnés avec retour abonne_id
    // =2 sélection d'agents avec retour abonne_id
    // =3 sélection d'abonnés avec retour abonne_id et agent_id
    $abonne_id_filtre = AlkRequest::getToken("abonne_id_filtre", "0");

    // filtre les utilisateurs sur cet espace si <>""
    $cont_id_filtre = AlkRequest::getToken("cont_id_filtre", "");
    $cont_id_profil = ( $cont_id_filtre != "" ? -$cont_id_filtre : -$cont_id );

    // exclu les utilisateurs appartenant à cet espace si <>""
    $cont_id_exclude = AlkRequest::getToken("cont_id_exclude", "");

    // exclu les utilisateurs appartenant à cet espace si <>""
    $profil_id_exclude = AlkRequest::getToken("profil_id_exclude", "-1");

    // filtre les utilisateurs ayant accès à cette application si <>""
    $appli_id_filtre = AlkRequest::getToken("appli_id_filtre", "");

    // token pour le traitement de l'ajout simple
    $tokenSave = AlkRequest::getToken("tokenSave", "");

    // token pour reafficher la page opener sur fermeture de popup
    $tokenClose = AlkRequest::getToken("tokenClose", "");

    // niveau d'erreur
    $erreur = AlkRequest::getToken("erreur", "");

    // =1 : reduire la recherche au champ nom et restriction à l'espace
    $iSearchNameOnly = AlkRequest::getToken("searchNameOnly", "0");

    // element de type select qui doit recevoir le texte et la valeur de la selection
    $dest = AlkRequest::getToken("dest", "");
    $dest = stripslashes($dest);

    // facultatif : =1 pour afficher les administrateurs principaux dans la liste des profils
    $iAffAdmin = AlkRequest::getToken("iAffAdmin", "0");

    $strParam = "&cont_id_filtre=".$cont_id_filtre."&appli_id_filtre=".$appli_id_filtre.
      "&cont_id_exclude=".$cont_id_exclude."&profil_id_exclude=".$profil_id_exclude.
      "&erreur=".$erreur."&dest=".$dest."&iAffAdmin=".$iAffAdmin.
      "&abonne_id_filtre=".$abonne_id_filtre.
      "&tokenSave=".$tokenSave."&tokenClose=".$tokenClose."&searchNameOnly=".$iSearchNameOnly;

    $FILTRE_NOM        = AlkRequest::_REQUEST("FILTRE_NOM", "");
    $FILTRE_PROFIL_ID  = AlkRequest::_REQUEST("FILTRE_PROFIL_ID", "");
    $FILTRE_SERVICE_ID = AlkRequest::_REQUEST("FILTRE_SERVICE_ID", "");
    $FILTRE_ESPACE     = AlkRequest::_REQUESTint("FILTRE_ESPACE", ($iSearchNameOnly==0 ? "0" : "1"));
    $FILTRE_MISSION_ID = AlkRequest::_REQUEST("FILTRE_MISSION_ID", "0");
    $FILTRE_LISTE_ID   = AlkRequest::_REQUEST("FILTRE_LISTE_ID", "-1");
    $FILTRE_PRIV_ID    = AlkRequest::_REQUEST("FILTRE_PRIV_ID", "-1");
    if( $FILTRE_PROFIL_ID == "" ) $FILTRE_PROFIL_ID = "0";
    if( $FILTRE_SERVICE_ID == "" ) $FILTRE_SERVICE_ID = "-1";

    $bFiltreService = ($iSearchNameOnly==0);
    $bFiltreProfil  = ($iSearchNameOnly==0);
    $bFiltreEspace = ( $appli_id_filtre!="" || $cont_id_filtre!="" || $cont_id_exclude!="" ? false : true );
    $bFiltreLsDif  = !(defined("ALK_B_ANNU_FILTER_LSDIF") && ALK_B_ANNU_FILTER_LSDIF==false) && $iSearchNameOnly==0;
    $bFiltreMission = ( ALK_B_ANNU_FILTER_MISSION && $iSearchNameOnly==0 && $abonne_id_filtre != "1" && $abonne_id_filtre != "3" );
    $bAffAdmin = ( $iAffAdmin == "1" && $iSearchNameOnly==0 );
  
    $bFiltreAucun = ( $FILTRE_NOM=="" && 
                      $FILTRE_PROFIL_ID=="0" && 
                      $FILTRE_SERVICE_ID=="-1" &&
                      $FILTRE_ESPACE=="0" &&
                      $FILTRE_MISSION_ID=="0" &&
                      $FILTRE_LISTE_ID=="-1" &&
                      $FILTRE_PRIV_ID=="-1" );

    $this->setLabelDesc(_t("Afin de limiter l'affichage, il est recommandé d'utiliser les fonctions de filtre.")."<br/>".
                        _t("Pour filtrer tous les noms, saisir le caractère %.")."<br/>".
                        ( $abonne_id_filtre != "1" && $abonne_id_filtre != "3"
                          ? "Les agents sélectionnés sont ceux dont la case est cochée."
                          : "Les abonnés sélectionnés sont ceux dont la case est cochée." )."<br/>".
                        _t("Cliquez sur Ajouter pour valider la sélection."));

    $oCtrlTxtNom = AlkHtmlFactory::getNewHtmlText(null, 0, "FILTRE_NOM", $FILTRE_NOM, "&nbsp;"._t("Nom"), 1, 16, 16);
    $oQueryAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);  
    
    $strFiltreProfil = "";
    if( $bFiltreProfil ) {
      $oCtrlSelectProfil = AlkHtmlFactory::getNewHtmlSelect(null, 0, "FILTRE_PROFIL_ID", $FILTRE_PROFIL_ID, _t("Profil"), 1, 180);
      $dsProfil = $oQueryAnnu->oQuery->getDsListProfilForCombo(28, $cont_id_profil, $profil_id_exclude);
      if ( $dsProfil->getCountTotDr()!=1 ){
        $oCtrlSelectProfil->setProperty("tabValTxtDefault", array("0", " "._t("Tous les profils")));
      }
      $oCtrlSelectProfil->setProperty("oValTxt", $dsProfil);
      $strFiltreProfil = $oCtrlSelectProfil->getLabel()." : ".$oCtrlSelectProfil->getHtml();
    }
        
    $strFiltreService = "";
    if( $bFiltreService ) {
      $oCtrlSelectService = AlkHtmlFactory::getNewHtmlSelect(null, 0, "FILTRE_SERVICE_ID", $FILTRE_SERVICE_ID, _t("Service"), 1, 160);
      $dsService = $oQueryAnnu->oQuery->getDsListeServiceForCombo("1", "-1", false, 18, "", "-2", $serv_id);
      if ( $dsService->getCountTotDr()!=1 ){
        $oCtrlSelectService->setProperty("tabValTxtDefault", array("-1", " "._t("Tous les services")));
      }
      $oCtrlSelectService->setProperty("oValTxt", $dsService);
      $strFiltreService = $oCtrlSelectService->getLabel()." : ".$oCtrlSelectService->getHtml();
    }
    
    $strFiltreEspace = "";
    if( $bFiltreEspace && $iSearchNameOnly==0) {
      $oCtrlCBEspace = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "FILTRE_ESPACE", $FILTRE_ESPACE, _t("Restreindre à cet espace"));
      $strFiltreEspace = $oCtrlCBEspace->getLabel()." : ".$oCtrlCBEspace->getHtml();
    }

    $oCtrlCBAll = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "iCheckAll", 0, "");
    $oCtrlCBAll->addEvent("onclick", "SelectAllCB()");

    $oBtAdd    = AlkHtmlFactory::getHtmlButtonPage("javascript:ajoutSimple('".$tokenSave."', ".$abonne_id_filtre.");", _t("Ajouter"), _t("Ajouter la sélection"));
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_USERS_LIST, ALK_SHEET_NONE, $strParam);
    $oBtFiltre = AlkHtmlFactory::getHtmlButtonPage("javascript:ValiderFiltre('".$strToken."')", _t("Filtrer"), _t("Exécuter le filtre"));

    /** tableau contenant les éléments de filtre */
    /** tableau des utilisateurs à sélectionner */
    $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    $dsAgent = $oQuery->getDsListUsers($FILTRE_NOM, $FILTRE_PROFIL_ID, ( $bFiltreAucun ? "-2" : $FILTRE_SERVICE_ID ), $FILTRE_MISSION_ID, 
                                       $cont_id_filtre, $cont_id , $FILTRE_ESPACE, ($bFiltreEspace || $iSearchNameOnly==1), 
                                       $cont_id_exclude, $appli_id_filtre, $iAffAdmin, $FILTRE_LISTE_ID, 
                                       $FILTRE_PRIV_ID, $profil_id_exclude, $abonne_id_filtre);
                                         
    $nbElt = $dsAgent->getCountTotDr();
    $page = 1;

    $nbEltFilter = 1;
    $oTabFilter = AlkHtmlFactory::getHtmlList($this, $nbElt, 1, 1, false, "", "", false, "tabFilter");
    $oTabFilter->setProperty("bSelectNbElts", false);
   
    $oTabFilter->setColumns(array("left", 540), array("center",120));
    $oTabFilter->setProperty("strTableAlign", "center");

    $strTile = ( $abonne_id_filtre != "1" && $abonne_id_filtre != "3"
                 ? _f("Nombre d'agent filtré : %s", $nbElt)
                 : _f("Nombre d'abonné filtré : %s", $nbElt) );
    $oTabFilter->addTitleRow($strTile, $oBtFiltre->getHtml());
    $oTabFilter->addRow(array($oCtrlTxtNom->getLabel()." : ".$oCtrlTxtNom->getHtml()."&nbsp;&nbsp;&nbsp;".
                              ( $iSearchNameOnly!=0 ? $strFiltreEspace : "" ). 
                              $strFiltreService."&nbsp;&nbsp;&nbsp;".
                              $strFiltreProfil, 2, 1));

    if( $bFiltreLsDif ) {
      $oCtrlSelectLsDif = AlkHtmlFactory::getNewHtmlSelect(null, 0, "FILTRE_LISTE_ID", $FILTRE_LISTE_ID, _t("Liste de diffusion"), 1, 330);
      $oCtrlSelectLsDif->setProperty("tabValTxtDefault", array("-1", " "._t("Aucune")));
      $oCtrlSelectLsDif->setProperty("oValTxt", $this->oAppli->oQuery->getDsListes($user_id, $cont_id, true));
      $oTabFilter->addRow(array($oCtrlSelectLsDif->getlabel()." : ".$oCtrlSelectLsDif->getHtml().
                                "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$strFiltreEspace, 2, 1));
      $nbEltFilter++;
    }

    $strMissionPriv = "";
    if( $bAffAdmin ) {
      $oCtrlSelectPriv = AlkHtmlFactory::getNewHtmlSelect(null, 0, "FILTRE_PRIV_ID", $FILTRE_PRIV_ID, _t("Privilèges"), 1);
      $tabPriv = array("-1"                 => _t("Aucun filtre"),
                       ALK_PRIV_SPACE_USER  => _t("Utilisateur"), // ceux qui n'ont pas de privilège (agent_priv=0)
                       ALK_PRIV_ANNU_SERV   => _t("Admin. annuaire de service"),
                       ALK_PRIV_ANNU_ALL    => _t("Admin. de tout l'annuaire"),
                       ALK_PRIV_SPACE_ADMIN => _t("Anim. de tous les espaces"),
                       ALK_PRIV_SPACE_ADMIN+
                       ALK_PRIV_ANNU_ALL    => _t("Administrateur général"));
      $oCtrlSelectPriv->setProperty("tabValTxt", $tabPriv);
      $strMissionPriv = $oCtrlSelectPriv->getLabel()." : ".$oCtrlSelectPriv->getHtml();
    }
    
    if( $bFiltreMission ) {
      $iWidth = ( $iAffAdmin == "1" ? 330 : 370 );
      $oCtrlSelectMission = AlkHtmlFactory::getNewHtmlSelect(null, 0, "FILTRE_MISSION_ID", $FILTRE_MISSION_ID, _t("Mission"), 1, $iWidth);
      $oCtrlSelectMission->setProperty("tabValTxtDefault", array("0", " "._t("Toutes les missions")));
      $oCtrlSelectMission->setProperty("oValTxt", $this->oAppli->oQuery->getDsListMissionForCombo(55));
      $strMissionPriv = $oCtrlSelectMission->getlabel()." : ".$oCtrlSelectMission->getHtml().
        ( $strMissionPriv != "" ? "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" : "" ).$strMissionPriv;
    }
    if( $strMissionPriv != "" ) {
      $oTabFilter->addRow(array($strMissionPriv, 2, 1));
      $nbEltFilter++;
    }

    $oTabFilter->setNbTotItems($nbEltFilter);

    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_USERS_LIST, ALK_SHEET_NONE, $strParam);

    $oTabPage = AlkHtmlFactory::getHtmlList($this, $nbElt, $page, ($nbElt==0 ? 1 : $nbElt), false, ALK_ALKANET."?token=".$strToken, 
                                            ( $bFiltreAucun 
                                              ? _t("Vous devez renseigner au moins un critère puis cliquez sur Filtrer.") 
                                              : _t("Pas de résultat.") ), 
                                            false, "tabUsers", false);
   
    $oTabPage->setColumns(array("left", 240), array("left", 180), array("left", 180), array("center", 50, "", false, false));

    $oTabPage->addTitleRow(array("<div align='right'>".$oBtAdd->getHtml()."</div>", 4, 1));
    $oTabPage->addTitleRow(_t("Nom Prénom"), _t("Service"), _t("Profil principal"), $oCtrlCBAll->getHtml());
    $oTabPage->setProperty("strTableAlign", "center");
       
    $cpt = 0;
    while( $drAgent = $dsAgent->getRowIter() ) {
      $id         =  $drAgent->getValueName("ID");
      $strNom     = $drAgent->getValueName("NOM");
      $strProfil  = $drAgent->getValueName("PROFIL");
      $idService  = $drAgent->getValueName("IDSERVICE");
      $strService = $drAgent->getValueName("SERVICE");
      $agent_id   = $drAgent->getValueName("AGENT_ID");
      $typePopup  = $drAgent->getValueName("TYPE_POPUP");
      $typePopup  = ( $agent_id == ALK_USER_ID_INTERNET ? "abonne" : "agent" ); 
      $idPopup    = ( $typePopup == "abonne" ? $id : $agent_id );

      $strUser = "";
      if( $dest != "" ) {
        $oCtrlHName = AlkHtmlFactory::getNewHtmlHidden(null, "listUserName[]", $strNom);
        $strUser = $oCtrlHName->getHtml();
      } 
      
      $oCtrlCB = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "listUsersId[]", -1, "", $id);
      
      $strUser = '<a title="voir la fiche de l\'agent '.$strNom.'" href="javascript:OpenPopupFiche(\''.$typePopup.'\', '.$idPopup.');" >'.$strNom.'</a>'.$strUser;
      $strServ = '<a title=" voir la fiche service de l\'agent '.$strNom.'" href="javascript:OpenPopupFiche(\'service\', '.$idService.');">'.$strService.'</a>';

      $oTabPage->addRow($strUser, $strServ, $strProfil, $oCtrlCB->getHtml());
    }

    $this->addPanel($oTabFilter);
    $this->addPanel($oTabPage);

    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlpopupuserslist.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
    $this->setTemplate("annu", "alkhtmlpopupuserslist.tpl");  
    $this->addOnload("onLoadFormUsersList()");

    $strHtmlJs = 
      " var oOpener = null;".
      " var obS = null;".
      " function onLoadFormUsersList() {".
      "   var f = document.formUsersList;".
      "   oOpener = GetWindowOpener();".
      "   if( oOpener==null ) { return; }".
      ( $dest != ""      ? " obS = oOpener.".$dest.";"      : "" ).
      ( $erreur == 1     ? " alkAlert(\""._t("Personne déjà présente !")."\");" : "" ).
      ( $erreur == 2     ? " alkAlert(\""._t("Votre sélection est vide !")."\");" : "" ).
      " f.FILTRE_NOM.focus();".
      " f.FILTRE_NOM.select();".
      " }";
    $this->addJs($strHtmlJs);
  }
}
?>