<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlFormServiceList
 * 
 * Classe de gestion liste des service de l'Annuaire
 */
class AlkHtmlFormServiceList extends AlkHtmlForm
{

  /**
   *  constructeur par défaut
   * @param oAppli Référence sur l'application associée 
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formServiceList"); 
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");    
  }	
   
  /**
   *  Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { }
  
  /**
   *  Traitement du formulaire
   */
  public function doSql() { }  
  
  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    /** information de l'utilisateur connecté */
    $idUser = AlkFactory::getSProperty("user_id", "-1");
    $user_service_id = AlkFactory::getSProperty("service_id", "-1");
    $user_priv = AlkFactory::getSProperty("user_priv", "0");

    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $err = AlkRequest::_REQUESTint("err", "0");   
    $strParam = "cont_id=".$cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_ADMIN."&iSheet=".ALK_SHEET_SERVICE;
    $nbEltParPage = AlkRequest::_POSTint("tabPagine_itemsPerPage", ALK_ITEMS_PER_PAGE);
    $service_id = AlkRequest::getToken("service_id", "-1");
    
    
    if( $service_id == "-1" && ($user_priv & ALK_PRIV_ANNU_ALL) == ALK_PRIV_ANNU_ALL ) {
      /** recherche le service id de la racine niveau 0 */	
      $service_id = $this->oAppli->oQuery->GetStr_idServiceBase();
    } elseif( $service_id == "-1" ) {
      /** service niveau 1 pour admin serv sur son service de niveau 1 */
      $service_id = $user_service_id;
    }

    if( $service_id == "-1" ) {
      header("location: ".ALK_ALKANET_IDENT."?err=1");
      exit();
    }

    // info sur le service pere
    $pservice_niveau = "-1";
    $pservice_intitule = "";
    $pservice_pere = "0";
    $pservice_dept_id = "-1";
    $dsServP = $this->oAppli->oQuery->GetDs_ficheService($service_id);
    if( $drServP = $dsServP->getRowIter() ) {
      $pservice_niveau   = $drServP->getValueName("SERVICE_NIVEAU");
      $pservice_intitule = $drServP->getValueName("SERVICE_INTITULE");
      $pservice_pere     = $drServP->getValueName("SERVICE_PERE");
      $pservice_dept_id  = $drServP->getValueName("DEPT_ID");
    }
    
    $dept_id = -1;
    $dsDept = $this->oAppli->oQuery->getDsListeDptForCombo(true, true);
    if( ($user_priv & ALK_PRIV_ANNU_ALL) == ALK_PRIV_ANNU_ALL && $pservice_niveau == 0  && $dsDept->getCountTotDr()>1 ) {
      $dept_id_default = $this->oAppli->oQuery->getDefaultUserDeptId($idUser, $service_id);
      $dept_id = AlkRequest::_REQUESTint("dept_id", AlkRequest::getToken("dept_id", $dept_id_default));
    } else {
      $dept_id = $pservice_dept_id; 
    }
                    
    $service_niveau = $pservice_niveau+1;
    
    // infos a afficher en fonction du niveau
    $strTitreContenu = ($service_niveau == 0 ? "" : _t("Sous-service de "));
    $this->setLabel(_f("Gestion des services de niveau %s %nl %s", $service_niveau, "<br/>", $strTitreContenu.$pservice_intitule));

    $this->setLabelDesc(_t("Cliquez sur l'intitul&eacute; du service pour modifier ses propriétés.")."<br/>" .
                        _t("Cliquez sur les flèches pour monter ou descendre dans l'arborescence."));

    if( $err == "1" ) {
      $this->setLabelWarning(_t("Il est impossible de supprimer ce service."));
    }
    
    $oCtrlAdd = null;
 
    if( ( $pservice_niveau >=0 && ($user_priv & ALK_PRIV_ANNU_ALL) == ALK_PRIV_ANNU_ALL ) || 
        ( $pservice_niveau > 0 && ($user_priv & ALK_PRIV_ANNU_SERV) == ALK_PRIV_ANNU_SERV ) ) { 
      
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_SERVICE, ALK_SHEET_LIST, "&dept_id=".$dept_id."&service_id=".$pservice_pere); 
      $oMonter = AlkHtmlFactory::getHtmlButtonIcon(ALK_ALKANET."?token=".$strToken, "Monter", _t("Remonter dans l'arbre des services"));
      $opservice_intitule = AlkHtmlFactory::getHtmlButton(ALK_ALKANET."?token=".$strToken, 
                                                          ( $pservice_niveau<0 
                                                            ? "" 
                                                            : _f("%s (niv %s)", $pservice_intitule, $pservice_niveau)), 
                                                          _t("Remonter dans l'arbre des services"));

      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_SERVICE, ALK_SHEET_FORM, "&service_pere=".$service_id);
      $oCtrlAdd = AlkHtmlFactory::getHtmlButtonPage(ALK_ALKANET."?token=".$strToken, 
                                                    _t("Ajouter"), _f("Ajouter un service de niveau %s", $service_niveau)); 
    } else {
    	$oMonter = "&nbsp;";
      $opservice_intitule = "&nbsp;";
    	$oCtrlAdd = "&nbsp;";
    }
    
    $page = 1;
    $iNbEltParPage = 20;
    
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
    AlkFactory::setSQLParamsName();
    
    // L'administrateur de service n'a acces qu'a l'arborescence de son service
    $this->dsServ = $this->oAppli->oQuery->GetDs_listeService($user_priv, $user_service_id, $service_niveau, $service_id, $dept_id);
    
    $output = array();
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
      $output = array(
            "sEcho" => AlkFactory::getSQLParamsName("sEcho", ""),
            "iTotalRecords" => $this->dsServ->getCountTotDr(),
            "iTotalDisplayRecords" => $this->dsServ->getCountTotDr(),
            "aaData" => array()
          );
    AlkFactory::emptySQLParamsName();
    
    $nbElt = $this->dsServ->getCountTotDr();
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_SERVICE, ALK_SHEET_LIST, "&dept_id=".$dept_id.
                                        "&service_id=".$service_id."&iMode=4"); 
    $strUrlPagine = ALK_ALKANET."?token=".$strToken; 
   
    $oTabPage = AlkHtmlFactory::getHtmlListJQuery($this, $nbElt, true, $strUrlPagine);
    $oTabPage->SetColumns(array("left",   "25", "", false, false),
                          array("left",   "380", "SERVICE_INTITULE"),
                          array("center", "100", "", false, false));
    $oTabPage->setFilter(true);
    $oTabPage->setModeAjax(true);

    if( ($user_priv & ALK_PRIV_ANNU_ALL) == ALK_PRIV_ANNU_ALL && $pservice_niveau == 0 && $dsDept->getCountTotDr()>1 ) {
      $oCtrlDept = AlkHtmlFactory::getNewHtmlSelect($this, 0, "dept_id", $dept_id, _t("Filtre")." : ", 1);
      $oCtrlDept->setProperty("tabValTxtDefault", array(-1, _t("Tous")));
      $oCtrlDept->setProperty("oValTxt", $dsDept);
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_SERVICE, ALK_SHEET_LIST, "&service_id=".$service_id); 
      $oCtrlDept->addEvent("onChange", "onChangeDept('".$strToken."')");

      $oTabPage->AddTitleRow(array($oCtrlDept, 3, 1));
    }
    $oTabPage->AddTitleRow($oMonter, $opservice_intitule, $oCtrlAdd);
    $this->addPanel($oTabPage);

    // Lecture des données
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
    $iMode = AlkRequest::getToken("iMode",-1);
    if ($iMode==4)
      $this->readData(true, $service_id, $service_niveau, $pservice_niveau, $dept_id, $oTabPage, $output);
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlformservicelist.js");
  }
  
  private function readData($bModeAjax = false, $service_id, $service_niveau, $pservice_niveau, $dept_id, &$oList, &$output) {
    // infos a afficher en fonction du niveau
    $user_priv = AlkFactory::getSProperty("user_priv", "0");
    
    $strTypeTitre = _f("(niv %s)", $pservice_niveau);
    $strTitreContenu = _t("Sous-service de ");
    switch( $service_niveau ) {
     case "0":
       $strTypeTitre = "&nbsp;";
       $strMessBox = "";
       $strMesAjout = "";
       if( ($user_priv & ALK_PRIV_ANNU_ALL) == ALK_PRIV_ANNU_ALL )
         $strMesAjout = _t("Ajouter un service de niveau 1");
       $strMesModif = _t("Modifier ce service de base");
       $strMesDel = "";
       $strTitreContenu = "";
       break;
       
    default:
       $strMessBox = _t("ce service");
       $strMesModif = _t("Modifier le service");
       $strMesDel = _t("Supprimer le service");
       break;
    }
    while( $drServ = $this->dsServ->getRowIter() ) {
      $nbFils         = $drServ->getValueName("NB_FILS");
      $nbAg           = $drServ->getValueName("NB_AG");
      $iEff           = $drServ->getValueName("SERVICE_EFFACABLE");
      $service_niveau = $drServ->getValueName("SERVICE_NIVEAU");
    
      $idServ    = $drServ->getValueName("SERVICE_ID");
      $strServ   = $drServ->getValueName("SERVICE_INTITULE");
      $iServEtat = $drServ->getValueName("SERVICE_ETAT");
      $service_valide = $drServ->getValueName("SERVICE_VALIDE");
    
      $strLienTitre = "";
      
      $strIntituleService = $strServ;
      if ( $iServEtat == 1 )
        $strIntituleService = $strServ." (".ALK_S_SERV_ETAT.")";
      
      if($service_valide==-2)
        $strIntituleService.=" <i>("._t("en attente d'activation").")<i>";
      elseif($service_valide==0)  
        $strIntituleService.=" <i>("._t("inactif").")</i>";
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_SERVICE, ALK_SHEET_FORM,
                                          "&service_id=".$idServ."&iMode=".ALK_FORM_MODE_UPDATE);  
      $oLien = AlkHtmlFactory::getHtmlButton(ALK_ALKANET."?token=".$strToken, $strIntituleService, 
                                             _f("Gestion des informations du service %s",$strServ))->getHtml();      

      if( $service_niveau < ALK_ANNU_SERV_NIV_MAX ) {
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_SERVICE, ALK_SHEET_LIST,"&service_id=".$idServ);
        $oDescendre = AlkHtmlFactory::getHtmlButtonIcon(ALK_ALKANET."?token=".$strToken, "Descendre", 
                                                        _t("Descendre dans l'arbre des services"), $strMesModif)->getHtml();
      } else {
        $oDescendre = "&nbsp;";
      }
      
      $oSup = "&nbsp;";
      if( $iEff==1 && $nbFils==0 && $nbAg==0 ) {  
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_SERVICE, ALK_SHEET_FORM,
                                            "&service_id=".$idServ."&service_pere=".$service_id."&dept_id=".$dept_id."&iMode=".ALK_FORM_MODE_DEL);
        $oSup = AlkHtmlFactory::getHtmlButtonForm("javascript:DeleteData('".$strToken."', 'Veuillez confirmer la suppression de ce service ?');", 
                                                  _t("Supprimer"), $strMesDel." ".$strServ)->getHtml();
      }
      
      if ($bModeAjax)
        $output["aaData"][] = array( $oDescendre, $oLien, $oSup);
      else
        $oList->addRowByArray(array( $oDescendre, $oLien, $oSup));
    }
    
    if ( $bModeAjax) {
      echo json_encode( $output );
      exit();
    }
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
      return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_07_service_list.htm"); 
  } 
}   

?>