<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlFormListDiffusionList
 * 
 * Classe de recherche de l'Annuaire
 */
class AlkHtmlFormLsDifList extends AlkHtmlForm 
{

  /**
   *  construct par défaut
   * @param oAppli référence sur l'application associée
   */  
  public function __construct(AlkAppli $oAppli)
  {   
    parent::__construct($oAppli, "formLsDif"); 
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");    
  }

  /**
   *  Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   * @param iTypeInit  type de récupération
   */
  protected function setData($iTypeInit) { }
  
  /**
   *  Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  {
  	
    $oQueryAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
    $user_id      = AlkFactory::getSProperty("user_id", "-1");
    $cont_id      = AlkRequest::getToken("cont_id", "-1");
    $liste_id     = AlkRequest::getToken("liste_id", "-1");
    $iMode        = AlkRequest::getToken("iMode", "-1");
    $iModeAff     = AlkRequest::getToken("iModeAff", "0");
    $nbEltParPage = AlkRequest::getToken("nbItemsPerPage", ALK_ITEMS_PER_PAGE);
    $page         = AlkRequest::getToken("page", 1);
    $appli_id     = AlkRequest::getToken("appli_id", -1);
    
    // Paramètres de l'action du formulaire et URL de retour
   
    $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".$this->iTypeSheet.
                                             "&iSheet=".ALK_SHEET_MESLISTES."&iSSheet=".ALK_SHEET_NONE."&iModeAff=".$iModeAff);
    
    
    $urlBack = ALK_ALKANET."?token=".$strToken."&page=".$page."&nbItemsPerPage=".$nbEltParPage;
    
    switch( $iMode ) {
    case ALK_FORM_MODE_DEL : // suppression de la fiche
      $oQueryAnnu->delListe($liste_id);
      break;
    
    case 4: // dupliquer la liste
      $oQueryAnnu->oQueryAction->copyListeDif($liste_id, $user_id, $cont_id);
      break;
    }

    return $urlBack;
  }  
  
  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $oQueryAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
    $nbEltParPage = AlkRequest::_GETint("nbItemsPerPage", ALK_ITEMS_PER_PAGE);
    $page         = AlkRequest::_GETint("page", 1);
    $iModeAff     = AlkRequest::getToken("iModeAff", 0);
    
    $cont_id      = AlkRequest::getToken("cont_id", "-1");
    $appli_id     = AlkRequest::getToken("appli_id", "-1");
    
    $user_id      = AlkFactory::getSProperty("user_id", "-1");
    
    $tabModeAff = array(0 => _t("Afficher vos listes uniquement"), 
                        1 => ( !AlkFactory::isSpaceAnimAll() 
                               ? _t("Afficher toutes les listes accessibles")
                               : _t("Afficher toutes les listes") ));

    $tabTitre = array(0 => _t("Ensemble de vos listes de diffusion"), 
                      1 => ( !AlkFactory::isSpaceAnimAll() 
                             ? _t("Ensemble des listes de diffusion accessibles")
                             : _t("Ensemble des listes de diffusion") )); 


    $tabPrive = array("0" => _t("Publique"),
                      "2" => _t("Publique pour tous espaces"),
                      "1" => _t("Privée"),
                      "3" => _t("Privée pour tous espaces"));
    
    $strToken0 = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".$this->iTypeSheet.
                                             "&iSheet=".ALK_SHEET_MESLISTES."&iSSheet=".ALK_SHEET_NONE."&iModeAff=0");
    
    $strToken1 = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".$this->iTypeSheet.
                                             "&iSheet=".ALK_SHEET_MESLISTES."&iSSheet=".ALK_SHEET_NONE."&iModeAff=1");

    $this->setLabel(_t("Gestion des listes de diffusion"));
    $this->setLabelDesc(_t("Vous avez la possibilité d'ajouter, modifier ou supprimer des listes de diffusion.")."<br/>".
                        _t("En italique, les listes non visibles.")."<br/>".
                        ( $iModeAff == 0 
                          ? '<a href="'.ALK_ALKANET.'?token='.$strToken1.'" title="'.$tabModeAff[1].'">'.$tabModeAff[1].'</a>'
                          : '<a href="'.ALK_ALKANET.'?token='.$strToken0.'" title="'.$tabModeAff[0].'">'.$tabModeAff[0].'</a>' ));

    $liste_type = AlkRequest::_GETint("liste_type", "-1");
    $strListeType = ( $liste_type == "-1"
                      ? "0, 3"
                      : $liste_type );

    if( $iModeAff == "0" ) {
      // ensemble des listes de l'utilisateur connecté
      $dsListe = $oQueryAnnu->oQuery->getDsListesGerees($user_id, $strListeType, ($page-1)*$nbEltParPage, $page*$nbEltParPage-1);
    } else {
      // ensemble des listes acessibles ou toutes les listes si utilisateur adminall connecté
      $dsListe = $oQueryAnnu->oQuery->getDsListes($user_id, $cont_id, false, 
                                                  ($page-1)*$nbEltParPage, 
                                                  $page*$nbEltParPage-1, AlkFactory::isSpaceAnimAll(), AlkFactory::isSpaceAnim(), false, $strListeType);
    }
    $nbElt = $dsListe->getCountTotDr();
   
    $strTokenPagine = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".$this->iTypeSheet.
                                             "&iSheet=".ALK_SHEET_MESLISTES."&iSSheet=".ALK_SHEET_NONE."&iModeAff=".$iModeAff);
    $strTokenAdd = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                              "&iSheet=".ALK_SHEET_MESLISTES."&iModeAff=".$iModeAff."&iMode=".ALK_FORM_MODE_ADD);
    
    $oCtrlSL = AlkHtmlFactory::getNewHtmlSelect(null, 0, "liste_type", $liste_type, "", 1, 240);
    $oCtrlSL->setProperty("tabValTxt", array("-1" => _t("Toutes les listes"),
                                             "0"  => _t("Listes de diffusion"),
                                             "3"  => _t("Listes d'abonnement aux lettres d'informations")));
    $oCtrlSL->addEvent("onchange", "onChangeListeType('".$strTokenPagine."')");
   
    $oBtAdd = AlkHtmlFactory::getHtmlButtonPage("javascript:viewFormListeDif('".$strTokenAdd."')", 
                                                _t("Ajouter"), _t("Ajouter une nouvelle liste"));
    
    $oTabPage=AlkHtmlFactory::getHtmlList($this, $nbElt, $page, $nbEltParPage, true, ALK_ALKANET."?token=".$strTokenPagine, 
                                          _t("Aucune liste."), false, "tabPagine", true);
    $oTabPage->SetColumns(array("left",   "250"),
                          array("center", "200"),
                          array("center", "85"),
                          array("center", "85"),
                          array("center", "85"));
   
    $oTabPage->AddTitleRow(array($tabTitre[$iModeAff]." (".$nbElt.")", 5));
    $oTabPage->AddTitleRow($oCtrlSL->getHtml(), _t("Accessibilité"), array($oBtAdd, 3));
    
    while( $drListe = $dsListe->getRowIter() ) {
      $liste_id = $drListe->getValueName("LISTE_ID");
      $nbAbonne =  $drListe->getValueName("NBABONNES");
      $nbAbonne = ( $nbAbonne == "" ? "0" : $nbAbonne );
      $liste_prive    = $drListe->getValueName("LISTE_PRIVE");
      $liste_agent_id = $drListe->getValueName("AGENT_ID");
      $liste_cont_id  = $drListe->getValueName("CONT_ID");
      $liste_intitule = $drListe->getValueName(AlkFactory::getDBCurrentLanguageField("LISTE_INTITULE"));
      $liste_type     = $drListe->getValueName("LISTE_TYPE");
      $liste_valide   = $drListe->getValueName("LISTE_VALIDE");
      $acont_id       = $drListe->getValueName("ACONT_ID");
      $cont_intitule  = $drListe->getValueName("CONT_INTITULE");

      $bAcces = true;
      if( $acont_id == "" ) {
        // l'utilisateur n'a pas accès à l'espace
        $bAcces = false;
      }
      $strTokenUpdate = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                   "&iSheet=".ALK_SHEET_MESLISTES."&iSSheet=".ALK_SHEET_FORM.
                                                   "&iModeAff=".$iModeAff."&iMode=".ALK_FORM_MODE_UPDATE.
                                                   "&liste_id=".$liste_id."&tokenClose=reload");
      $strLienTitre = "javascript:viewFormListeDif('".$strTokenUpdate."')";
      $strTagIS = ( $liste_valide == "0" ? "<i>" : "" );
      $strTagIE = ( $liste_valide == "0" ? "</i>" : "" );
      $strTheme = AlkHtmlFactory::getHtmlButton($strLienTitre, $strTagIS.$liste_intitule.( $nbAbonne>0 
                                                                                           ? " ("._nf("%s abonné", "%s abonnés", $nbAbonne).")" 
                                                                                           : "").$strTagIE, _t("Gestion de la liste de diffusion")." ".$liste_intitule);
 
      $strType = $tabPrive[$liste_prive];
      if( $liste_prive == 0 || $liste_prive == 1 ) {
        if( $liste_cont_id==$cont_id ) {
          $strType = _f("%s pour cet espace", $strType);
        } else {
          $strParamSpace = "cont_id=".$liste_cont_id."&appli_id=0".
            "&iTypeSheet=".$this->iTypeSheet.
            "&iSheet=".ALK_SHEET_MESLISTES.
            "&iModeAff=".$iModeAff;
          $strTokenSpace = AlkRequest::getEncodeParam($strParamSpace);         

          $strType =  AlkHtmlFactory::getHtmlButton(ALK_ALKANET."?token=".$strTokenSpace, 
                                                    _f("%s sur l'espace %s", $strType, "<br/><b>".$cont_intitule."</b>"), 
                                                    _t("Atteindre cet espace"));
          $strType = $strType->getHtml();
        }
      }

      $strTokenAbonnes = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                    "&iSheet=".ALK_SHEET_MESLISTES."&iSSheet=".ALK_SHEET_LIST. 
                                                    "&iModeAff=".$iModeAff."&iMode=".ALK_FORM_MODE_UPDATE.
                                                    "&liste_id=".$liste_id."&tokenClose=reload");
      $strBtAbonnes = AlkHtmlFactory::getHtmlButtonForm("javascript:viewAbonnesListeDif('".$strTokenAbonnes."')", 
                                                        _t("Abonnés"), _t("Gestion des abonnés de la liste")." ".$liste_intitule);     

      $strBtDel = "&nbsp;";
      if( $liste_agent_id == $user_id || AlkFactory::isSpaceAnimAll() ) {
        $iPage = ( $nbElt-1 <= ($page-1)*$nbEltParPage ? ($page-1>0 ? $page-1 : 1) : $page);  
        
        $strTokenDel = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".$this->iTypeSheet.
                                                   "&iSheet=".ALK_SHEET_MESLISTES."&iSSheet=".ALK_SHEET_NONE.
                                                   "&iModeAff=".$iModeAff."&iMode=".ALK_FORM_MODE_DEL."&liste_id=".$liste_id.
                                                   "&page=".$iPage."&nbItemsPerPage=".$nbEltParPage);
                                                   
        $strBtDel = AlkHtmlFactory::getHtmlButtonForm("javascript:delLsDif('".$strTokenDel."')", _t("Supprimer"), _t("Supprimer la liste")." ".$liste_intitule);
      }
        
      $strTokenCopy = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".$this->iTypeSheet.
                                                   "&iSheet=".ALK_SHEET_MESLISTES."&iSSheet=".ALK_SHEET_NONE.
                                                   "&iModeAff=".$iModeAff."&iMode=4&liste_id=".$liste_id."&page=".$page."&nbItemsPerPage=".$nbEltParPage);
                                                                                      
                                              
      $strBtCopy = AlkHtmlFactory::getHtmlButtonForm("javascript:copyLsDif('".$strTokenCopy."')", _t("Dupliquer"), _t("Dupliquer la liste")." ".$liste_intitule);



      $oTabPage->addRowByArray(array($strTheme, $strTagIS.$strType.$strTagIE, 
                                     $strBtAbonnes, $strBtCopy, $strBtDel));
    }

    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlformlsdiflist.js");
    $this->addPanel($oTabPage);
  }
    
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_03_listedif_list.htm"); 
  } 
}
?>