<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."excel/Workbook.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlFormAbonne
 * Classe de gestion des abonnés.
 */
class AlkHtmlFormAbonne extends AlkHtmlForm
{
  /** controle de saisie */
  protected $abonne_id;
  protected $abonne_nom;
  protected $abonne_prenom;
  protected $abonne_pseudo;
  protected $abonne_mail;
  protected $abonne_tel;
  protected $abonne_adresse;
  protected $abonne_cp;
  protected $abonne_ville;
  protected $abonne_pays;
  protected $abonn_date_inscr;
  protected $abonn_date_desinscr;
  protected $abonne_valide;
  protected $abonne_valide_orig;
  protected $abonne_desc;
  
  protected $oTargetAppli;
  protected $bOwnAbonne;
  
  /**
   * constructeur par défaut
   * @param oAppli        Référence sur l'application
   * @param oTargetAppli  Référence sur l'appli demandant cette fenêtre
   */
  public function __construct(AlkAppli $oAppli, $oTargetAppli)
  {
    parent::__construct($oAppli, "formAbonne");

    $this->oTargetAppli = $oTargetAppli;
    
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
  }
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit)
  {    
    $abonne_id = AlkRequest::getToken("abonne_id" , AlkRequest::_REQUESTint("abonne_id", "-1"));
    $abonne_id_connected = AlkFactory::getSProperty("abonne_id", "");
    $this->bOwnAbonne = ($abonne_id_connected == $abonne_id);
    
    $this->abonne_id           = new AlkFormData($this, "abonne_id",                   $abonne_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);  
    $this->appli_id            = new AlkFormData($this, "appli_id", $this->oTargetAppli->appli_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC );  
    $this->abonne_nom          = new AlkFormData($this, "abonne_nom",                          "", ALK_SQL_TEXT );  
    $this->abonne_prenom       = new AlkFormData($this, "abonne_prenom",                       "", ALK_SQL_TEXT );
    $this->abonne_pseudo       = new AlkFormData($this, "abonne_pseudo",                       "", ALK_SQL_TEXT );
    $this->abonn_date_inscr    = new AlkFormData($this, "abonne_date_inscr",        date("d/m/Y"), ALK_SQL_DATE );  
    $this->abonn_date_desinscr = new AlkFormData($this, "abonne_date_desinscr",                "", ALK_SQL_DATE );  
    $this->abonne_mail         = new AlkFormData($this, "abonne_mail",                         "", ALK_SQL_TEXT );
    $this->abonne_valide       = new AlkFormData($this, "abonne_valide",                        1, ALK_SQL_NUMBER, ALK_VERIF_CHECK);
    $this->abonne_valide_orig  = new AlkFormData($this, "abonne_valide_orig",                   1, ALK_SQL_NUMBER, ALK_VERIF_CHECK);
    $this->abonne_cp           = new AlkFormData($this, "abonne_cp",                           "", ALK_SQL_TEXT );  
    $this->abonne_ville        = new AlkFormData($this, "abonne_ville",                        "", ALK_SQL_TEXT );  
    $this->abonne_pays         = new AlkFormData($this, "abonne_pays",                         "", ALK_SQL_TEXT );
    $this->abonne_tel          = new AlkFormData($this, "abonne_tel",                          "", ALK_SQL_TEXT );  
    $this->abonne_adresse      = new AlkFormData($this, "abonne_adresse",                      "", ALK_SQL_TEXT );
    $this->abonne_desc         = new AlkFormData($this, "abonne_desc",                         "", ALK_SQL_TEXT );
    
    // Si liste_id fourni, les actions de validation et d'annulation renvoient vers la liste (même en mode Popup)
    $this->liste_id = AlkRequest::getToken("liste_id", AlkRequest::_REQUESTint("liste_id", "-1"));
    
    $oDrData = null;
    $reqMethod = -1;
    if($this->iMode== ALK_FORM_MODE_UPDATE){
      if(($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
        $oDsData = $this->oAppli->oQuery->getDsAbonne($abonne_id);
        $oDrData = ( !($oDrData = $oDsData->GetRowIter()) ? null : $oDrData);
      }
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST ) {
      $reqMethod = REQ_POST;
    }
    $this->initData($iTypeInit, $oDrData, $reqMethod);
    
    if( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
      $this->abonne_valide_orig->value = $this->abonne_valide->value;
    
      if( $abonne_id == "-1" ) {
        $this->iMode = ALK_FORM_MODE_ADD;
      }
    }
  }

  /**
   * Traitement du formulaire
   */
  public function doSql()
  {
    $this->setData(ALK_INIT_MODE_REQUEST);
    $abonne_id = AlkRequest::getToken("abonne_id", -1);
    $strValeur = AlkRequest::_GET("m", "");
    switch( $this->iMode ) {
      case ALK_FORM_MODE_ADD :
        $abonne_id = $this->oAppli->oQueryAction->addAbonne(ALK_USER_ID_INTERNET, $this->abonne_nom->value, $this->abonne_prenom->value, $this->abonne_mail->value, 
                                                    $this->abonne_valide->value, $this->abonne_adresse->value, $this->abonne_cp->value, 
                                                    $this->abonne_ville->value, $this->abonne_pays->value, $this->abonne_tel->value,
                                                    "", $this->abonne_pseudo->value, $this->abonne_desc->value);
        break; 
  
      case ALK_FORM_MODE_UPDATE :
        $tabQuery = $this->getTabQuery(array("ABONNE_ID"), array("APPLI_ID"));
        $this->oAppli->oQueryAction->updateAbonne($tabQuery["field"], $this->abonne_id->value, ALK_USER_ID_INTERNET);       
        break;
        
      case "4": // vérification de l'unicité du pseudo
        $strNewPseudo = $this->oAppli->oQueryAction->getStrVerifyPseudo($abonne_id, $strValeur, ALK_ANNU_LG_MAX_PSEUDO)  ;    
        $bNewLogin = ($strNewPseudo == $strValeur ? "0" : "1");
        
        $tabRes = array("intitule"    =>"pseudo", 
                        "iLogin"    =>$bNewLogin, 
                        "new_valeur"=>$strNewPseudo,
                        "champ"     =>"abonne_pseudo");
        echo json_encode($tabRes);
        exit();
       break;
       
     case "5": // vérification de l'unicité du mail
        $bExists = $this->oAppli->oQuery->getBoolVerifyMail($abonne_id, $strValeur);    
        $bNewLogin = ($bExists ? "1" : "0");
        
        $tabRes = array("intitule"     =>"mail", 
                        "iLogin"    =>$bNewLogin,
                        "new_valeur"=> "",
                        "champ"     =>"abonne_mail");
        echo json_encode($tabRes);
        exit();
       break;
    }       
    
    if ($this->iTypeSheet == ALK_TYPESHEET_POPUP && $this->liste_id == -1){
      $strToken = $this->oTargetAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, 
                   "&iMode=".ALK_FORM_MODE_UPDATE."&abonne_id=".$abonne_id);
    }else {
      $strToken = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE, "&liste_id=".$this->liste_id);
    }
    
    return ALK_ALKANET."?token=".$strToken;
  }
  
  public function getTitle()
  {
    return _t("Fiche abonné");
  }
  
  /**
   * Construction de la liste (soit boite de reception soit liste des envois)
   */
  public function setContents()
  {    
    $this->setData(ALK_INIT_MODE_DATAROW);
    $this->setHtmlFormAbonne();
    $this->addScriptJs(AlkFactory::getModuleUrl(ALK_ATYPE_ID_ANNU)."lib/alkhtmlformabonne.js");
  }
 
  /**
   * Retourne le code Html du formulaire TArea
   *
   * @param iMode   Mode du formulaire
   * @param room_id Identifiant du type de réservation
   * @return Retourne un string
   */
  function setHtmlFormAbonne()
  {
    $iWidthTxt = 42;
    $iWidthMemo = 40;
    $iWidthCp = 10;
    $iHeightMemo = 5;
    $iWidthSelect= 290;
    
    $strTitre = ( $this->iMode == ALK_FORM_MODE_ADD 
                  ? _t("Ajout d'un abonné") 
                  : _t("Modification d'un abonné") );
    
    $bloc2 = $this->addBlock("block_0", $strTitre, "", "120", "330", true);
    $bloc2->setProperty("strTableAlign", "center");

    $oCtrlH = AlkHtmlFactory::getHtmlHidden($this->abonne_id);  
    $oCtrlH->addDataHidden($this->abonne_valide_orig);
    $oCtrlH->addDataHidden($this->appli_id);
    
    if ($this->bOwnAbonne)
    $oCtrlH->addDataHidden($this->abonne_valide);
      
    $oAbonneNom = AlkHtmlFactory::getHtmlText($this->abonne_nom, _t("Nom"), 1, $iWidthTxt, 100);  
    $oAbonneNom->addValidator(ALK_VERIF_TEXT);
    
    $oAbonnePrenom = AlkHtmlFactory::getHtmlText($this->abonne_prenom, _t("Prénom"), 1, $iWidthTxt, 40);  
    $oAbonnePrenom->addValidator(ALK_VERIF_TEXT);

    $oAbonnePseudo = AlkHtmlFactory::getHtmlText($this->abonne_pseudo, _t("Pseudonyme"), 1, $iWidthTxt, 255);  
    $oAbonnePseudo->addValidator(ALK_VERIF_TEXT);
    
    $strToken = $this->oTargetAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=4&abonne_id=".$this->abonne_id->value);
    $oBtCheckLogin = AlkHtmlFactory::getHtmlButton("javascript:void(checkLogin('".$this->getName()."', ['pseudo']))", _t("Soumettre"), "");
    
    $varRef = AlkhtmlFactory::getHtml($oBtCheckLogin->getHtml());
    $oAbonnePseudo->addCtrl($varRef);
    $oCtrlH->addHidden("tokenPseudo", $strToken);
    
    $oAbonneMail = AlkHtmlFactory::getHtmlText($this->abonne_mail, _t("Mail"), 1, $iWidthTxt, 255);  
    $oAbonneMail->addValidator(ALK_VERIF_MAIL + ALK_IS_REQUIRED);
     
    $strToken = $this->oTargetAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=5&abonne_id=".$this->abonne_id->value);
    $oBtCheckLogin = AlkHtmlFactory::getHtmlButton("javascript:void(checkLogin('".$this->getName()."', ['mail']))", _t("Soumettre"), "");
    $varRef2 = AlkhtmlFactory::getHtml($oBtCheckLogin->getHtml());
    $oAbonneMail->addCtrl($varRef2);
    $oCtrlH->addHidden("tokenMail", $strToken);
    
    $oAbonneTel = AlkHtmlFactory::getHtmlText($this->abonne_tel, _t("Téléphone"), 1, $iWidthTxt, 32);  
    $oAbonneTel->addValidator(ALK_VERIF_TEXTNUM);

    $oAbonneAdresse = AlkHtmlFactory::getHtmlText($this->abonne_adresse, _t("Adresse"), 1, $iWidthTxt, 255);  
    $oAbonneAdresse->addValidator(ALK_VERIF_TEXT);
    
    $oAbonneDesc = AlkHtmlFactory::getHtmlText($this->abonne_desc, _t("Description"), 3, $iWidthTxt-2, 255);  
    $oAbonneDesc->addValidator(ALK_VERIF_TEXT);

    $oAbonneCp = AlkHtmlFactory::getHtmlText($this->abonne_cp, _t("Code Postal"), 1, $iWidthCp, 10);  
    $oAbonneCp->addValidator(ALK_VERIF_TEXT);
    
    $oAbonneVille = AlkHtmlFactory::getHtmlText($this->abonne_ville, _t("Ville"), 1, $iWidthTxt, 40);  
    $oAbonneVille->addValidator(ALK_VERIF_TEXT);
    
    $oAbonnePays = AlkHtmlFactory::getHtmlText($this->abonne_pays, _t("Pays"), 1, $iWidthTxt, 40);  
    $oAbonnePays->addValidator(ALK_VERIF_TEXT);
    
    $odDateInscription = AlkHtmlFactory::getHtmlText($this->abonn_date_inscr, _t("Date inscription"),1, $iWidthTxt);  
    $odDateInscription->setMode(1);
    
     if (! $this->bOwnAbonne)
      $oValide = AlkHtmlFactory::getHtmlCheckbox($this->abonne_valide, _t("Valide"));  
    
    $odDateDesinscription = AlkHtmlFactory::getHtmlText($this->abonn_date_desinscr, _t("Date désinscription"),1, $iWidthTxt);  
    $odDateDesinscription->setMode(1);

    $bloc2->addCtrl($oCtrlH);
    $bloc2->addCtrl($oAbonneNom);
    $bloc2->addCtrl($oAbonnePrenom);
    $bloc2->addCtrl($oAbonnePseudo);
    $bloc2->addCtrl($oAbonneMail);
    $bloc2->addCtrl($oAbonneTel);
    $bloc2->addCtrl($oAbonneAdresse);
    $bloc2->addCtrl($oAbonneCp);
    $bloc2->addCtrl($oAbonneVille);
    $bloc2->addCtrl($oAbonnePays);
    $bloc2->addCtrl($odDateInscription);
    $bloc2->addCtrl($oAbonneDesc);
    if (! $this->bOwnAbonne)
      $bloc2->addCtrl($oValide);
    $bloc2->addCtrl($odDateDesinscription);
    
    $strToken = $this->oTargetAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, 
                                              "&iMode=".$this->iMode."&abonne_id=".$this->abonne_id->value."&liste_id=".$this->liste_id);
    
    $oButton = $this->addButtonPage("oBtV","javascript:checkAllLogin('".$strToken."','".$this->getName()."')", _t("Valider"), _t("Valider les modifications"));
    $this->addSubmitButton($oButton);
    
    if ($this->iTypeSheet == ALK_TYPESHEET_POPUP && $this->liste_id == -1){
      $this->addButton("btCancel", "javascript:closeWindow()", _t("Fermer"), _t("Fermer la fenêtre"));  
    } else {
      $strToken = $this->oTargetAppli->getToken($this->iTypeSheet, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE, "&liste_id=".$this->liste_id);
      $this->addButton("btCancel", ALK_ALKANET."?token=".$strToken, _t("Annuler"), _t("Annuler la saisie"));
    }
  }

  /**
  * Retourne l'aide associée au formulaire
  * @return string
  */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_abonne.htm"); 
  }
   
}
?>