<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


if ( ALK_BDD_TYPE==ALK_SGBD_MYSQL ) {
  //   Table : SEQUENCE                   
  $tabTable["sequence"] = array(
    "id" => array("type" => "int", "dn" => "DEFAULT 1 NOT NULL")
    );
  
  $tabPk["sequence"]["pk_sequence"] = "id";
    
  $tabIns[] = "insert into SEQUENCE (ID) values (1)";
}

// table : SIT_DEPT
$tabTable["sit_dept"] = array(
  "dept_id" => array("type" => "int", "dn" => "NOT NULL"),
  "dept_intitule" => array("type" => "varchar(80)", "dn" => ""),
  "dept_num" => array("type" => "varchar(5)", "dn" => ""),
  "dept_pere" => array("type" => "int", "dn" => "NOT NULL"),
  "dept_visible" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  );
$tabPk["sit_dept"]["pk_sit_dept"] = "dept_id";

// table SIT_PROFIL
$tabTable["sit_profil"] = array(
  "profil_id" => array("type" => "int", "dn" => "NOT NULL"),
  "profil_intitule" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  "profil_rang" => array("type" => "int", "dn" => "DEFAULT 0"),
  "profil_desc" => array("type" => "varchar(255)", "dn" => ""),
  "profil_effacable" => array("type" => "int", "dn" => "DEFAULT 1 NOT NULL"),
  "cont_id" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  );

$tabPk["sit_profil"]["pk_sit_profil"] = "profil_id";

$tabIdx["sit_profil"] = array(
  "sitprofil_contid_fk" => "cont_id",
  );

// cle etrangere dans 03_annu.sql 

$tabSeq["seq_sit_profil"] = "10";

// table SIT_AGENT_TYPE
$tabTable["sit_agent_type"] = array(
  "agtype_id" => array("type" => "int", "dn" => "NOT NULL"),
  "agtype_intitule" => array("type" => "varchar(20)", "dn" => "NOT NULL"),
  "agtype_rang" => array("type" => "int", "dn" => ""),
  );

$tabPk["sit_agent_type"]["pk_sit_agent_type"] = "agtype_id";

//   Table : SIT_MISSION                                       
$tabTable["sit_mission"] = array(
  "mission_id" => array("type" => "int", "dn" => "NOT NULL"),
  "mission_intitule" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  "mission_rang" => array("type" => "int", "dn" => "DEFAULT 0"),
  );

$tabPk["sit_mission"]["pk_sit_mission"] = "mission_id";

$tabSeq["seq_sit_mission"] = "10";

//   Table : SIT_TELECOM                                       
$tabTable["sit_telecom"] = array(
  "telecom_id" => array("type" => "int", "dn" => "NOT NULL"),
  "telecom_intitule" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  "telecom_rang" => array("type" => "int", "dn" => ""),
  );

$tabPk["sit_telecom"]["pk_sit_telecom"] = "telecom_id";

//   Table : SIT_AGENT                                         
$tabTable["sit_agent"] = array(
  "agent_id" => array("type" => "int", "dn" => "NOT NULL"),
  "profil_id" => array("type" => "int", "dn" => "NOT NULL"),
  "agent_priv" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "agtype_id" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "agent_civilite" => array("type" => "varchar(10)", "dn" => ""),
  "agent_nom" => array("type" => "varchar(100)", "dn" => "NOT NULL"),
  "agent_prenom" => array("type" => "varchar(40)", "dn" => "NOT NULL"),
  "agent_trigramme" => array("type" => "varchar(5)", "dn" => ""),
  "agent_mail" => array("type" => "varchar(255)", "dn" => "NOT NULL"),
  "agent_tel" => array("type" => "varchar(30)", "dn" => ""),
  "agent_telposte" => array("type" => "varchar(30)", "dn" => ""),
  "agent_fax" => array("type" => "varchar(30)", "dn" => ""),
  "agent_mobile" => array("type" => "varchar(30)", "dn" => ""),
  "agent_photo" => array("type" => "varchar(255)", "dn" => ""),
  "agent_fonction" => array("type" => "varchar(255)", "dn" => ""),
  "agent_login" => array("type" => "varchar(255)", "dn" => "NOT NULL"),
  "agent_pwd" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  "agent_desc" => array("type" => "varchar(4000)", "dn" => ""),
  "agent_valide" => array("type" => "int", "dn" => ""),
  "agent_date_conn" => array("type" => "datetime", "dn" => ""),
  "agent_date_maj" => array("type" => "datetime", "dn" => ""),
  "agent_date_crea" => array("type" => "datetime", "dn" => ""),
  "agent_datevalid" => array("type" => "datetime", "dn" => ""),
  "agent_datelimit" => array("type" => "datetime", "dn" => ""),
  "cont_id_start" => array("type" => "int", "dn" => "DEFAULT 0"),
  "agent_browser" => array("type" => "varchar(1024)", "dn" => ""),
  "agent_publipostage" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "extent_id" => array("type" => "int", "dn" => "DEFAULT 0"),
  "agent_id_crea" => array("type" => "int", "dn" => ""),
  "agent_id_maj" => array("type" => "int", "dn" => ""),
  "agent_ldap" => array("type" => "int", "dn" => "DEFAULT 0"),
  "agent_adminauth" => array("type" => "int", "dn" => "DEFAULT 1 NOT NULL"),
  "agent_lg" => array("type" => "varchar(10)", "dn" => ""),
  );

$tabPk["sit_agent"]["pk_sit_agent"] = "agent_id";

$tabIdx["sit_agent"] = array(
  "sit_agent_profilid_fk" => "profil_id",
  "sit_agent_type_fk" => "agtype_id",
  );

$tabFk["sit_agent"] = array(
  "fk_agtypeid_sittype_agent" => array("ffk" => "agtype_id", "tpk" => "sit_agent_type", "fpk" => "agtype_id"),
  "fk_sit_agent_profilid" => array("ffk" => "profil_id", "tpk" => "sit_profil", "fpk" => "profil_id"),
  );

$tabUq["sit_agent"]["ag_login_uq"] = "agent_login";

$tabSeq["seq_sit_agent"] = "10";

// table : SIT_AGENT_PROFIL
$tabTable["sit_agent_profil"] = array(
  "agent_id" => array("type" => "int", "dn" => "NOT NULL"),
  "profil_id" => array("type" => "int", "dn" => "NOT NULL"),
  );
$tabPk["sit_agent_profil"]["pk_sit_agent_profil"] = "agent_id, profil_id";

$tabIdx["sit_agent_profil"] = array(
  "sit_agentp_profilid_fk" => "profil_id",
  "sit_agentp_agentid_fk" => "agent_id",
  );

$tabFk["sit_agent_profil"] = array(
  "fk_agentp_agentid" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_agentp_profilid" => array("ffk" => "profil_id", "tpk" => "sit_profil", "fpk" => "profil_id"),
  );

// Table : SIT_FONCTION, Gestion des fonctions
$tabTable["sit_fonction"] = array(
  "fonc_id" => array("type" => "int", "dn" => "NOT NULL"),
  "fonc_intitule" => array("type" => "varchar(255)", "dn" => ""),
  "fonc_desc" => array("type" => "varchar(4000)", "dn" => ""),
  "fonc_pj" => array("type" => "varchar(255)", "dn" => ""),
  );

$tabPk["sit_fonction"]["pk_sit_fonction"] = "fonc_id";

$tabSeq["seq_sit_fonction"] = "10";

//   Table : SIT_SERVICE                                       
$tabTable["sit_service"] = array(
  "service_id" => array("type" => "int", "dn" => "NOT NULL"),
  "dept_id" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "service_etat" => array("type" => "int", "dn" => "DEFAULT 0"),
  "service_intitule" => array("type" => "varchar(255)", "dn" => ""),
  "service_intitule_court" => array("type" => "varchar(40)", "dn" => ""),
  "service_racine" => array("type" => "int", "dn" => ""),
  "service_pere" => array("type" => "int", "dn" => ""),
  "service_arbre" => array("type" => "varchar(4000)", "dn" => ""),
  "service_niveau" => array("type" => "int", "dn" => ""),
  "service_rang" => array("type" => "int", "dn" => "DEFAULT 0"),
  "service_effacable" => array("type" => "int", "dn" => "DEFAULT 1"),
  "service_adresse" => array("type" => "varchar(255)", "dn" => ""),
  "service_tel" => array("type" => "varchar(40)", "dn" => ""),
  "service_fax" => array("type" => "varchar(40)", "dn" => ""),
  "service_email" => array("type" => "varchar(255)", "dn" => ""),
  "service_web" => array("type" => "varchar(255)", "dn" => ""),
  "cont_id_start" => array("type" => "int", "dn" => "DEFAULT 0"),
  "service_date_maj" => array("type" => "datetime", "dn" => ""),
  "agent_id" => array("type" => "int", "dn" => ""),
  "fonc_id" => array("type" => "int", "dn" => ""),
  "service_ldap" => array("type" => "int", "dn" => "default 0"),
  "service_ldapdn"  => array("type" => "varchar(255)", "dn" => ""),
  "service_ldapuid" => array("type" => "varchar(255)", "dn" => ""),
  "service_valide" => array("type" => "int", "dn" => "DEFAULT 1"),
  "service_date_creation" =>array("type" => "datetime", "dn" => ""),
  "service_logo" => array("type" => "varchar(255)", "dn" => ""),
  );
  
$tabPk["sit_service"]["pk_sit_service"] = "service_id";

$tabIdx["sit_service"] = array(
  "sit_service_agent_id_fk" => "agent_id",
  "sit_service_fonc_id_fk" => "fonc_id",
  "sitservice_deptid_fk" => "dept_id",
  );  

$tabFk["sit_service"] = array(
  "fk_service_agentid" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_service_foncid" => array("ffk" => "fonc_id", "tpk" => "sit_fonction", "fpk" => "fonc_id"),
  "fk_sitservice_deptid" => array("ffk" => "dept_id", "tpk" => "sit_dept", "fpk" => "dept_id"),
  );

$tabSeq["seq_sit_service"] = "10";
/*
   Table : SIT_COORDONNEE
   COOR_PUBLICATION:
     0 : utilisateur uniquement
     1 : service uniquement
     2 : service Ã©tat uniquement
     4 : tous les services
     8 : site internet
*/
$tabTable["sit_coordonnee"] = array(
  "coor_id" => array("type" => "int", "dn" => "NOT NULL"),
  "telecom_id" => array("type" => "int", "dn" => "NOT NULL"),
  "agent_id" => array("type" => "int", "dn" => "NOT NULL"),
  "coor_valeur" => array("type" => "varchar(80)", "dn" => ""),
  "coor_complement" => array("type" => "varchar(80)", "dn" => ""),
  "coor_publication" => array("type" => "int", "dn" => "DEFAULT 7 NOT NULL"),
  );

$tabPk["sit_coordonnee"]["pk_sit_coordonnee"] = "coor_id";

$tabIdx["sit_coordonnee"] = array(
  "sit_agent_coordonnee_fk" => "agent_id",
  "sit_coordonnee_telecom_fk" => "telecom_id",
  );
  
$tabFk["sit_coordonnee"] = array(
  "fk_sit_coor_sit_agent_sit_agen" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_sit_coor_sit_coord_sit_tele" => array("ffk" => "telecom_id", "tpk" => "sit_telecom", "fpk" => "telecom_id"),
  );

$tabSeq["seq_sit_coordonnee"] = "100";

//   Table : SIT_ADRESSE                                        
$tabTable["sit_adresse"] = array(
  "adr_id" => array("type" => "int", "dn" => "NOT NULL"),
  "agent_id" => array("type" => "int", "dn" => "NOT NULL"),
  "adr_adr1" => array("type" => "varchar(50)", "dn" => ""),
  "adr_adr2" => array("type" => "varchar(50)", "dn" => ""),
  "adr_adr3" => array("type" => "varchar(50)", "dn" => ""),
  "adr_post" => array("type" => "varchar(10)", "dn" => ""),
  "adr_ville" => array("type" => "varchar(50)", "dn" => ""),
  "adr_pays" => array("type" => "varchar(50)", "dn" => ""),
  "adr_desc" => array("type" => "varchar(4000)", "dn" => ""),
  );

$tabPk["sit_adresse"]["pk_sit_adresse"] = "adr_id";

$tabIdx["sit_adresse"] = array(
  "lien_666_fk" => "agent_id",
  );

$tabFk["sit_adresse"] = array(
  "fk_agentid_sit_adresseagent" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  );

$tabSeq["seq_sit_adresse"] = "10";

//   Table : SIT_AGENT_MISSION                                 
$tabTable["sit_agent_mission"] = array(
  "mission_id" => array("type" => "int", "dn" => "NOT NULL"),
  "agent_id" => array("type" => "int", "dn" => "NOT NULL"),
  );
  
$tabPk["sit_agent_mission"]["pk_sit_agent_mission"] = "mission_id, agent_id";

$tabIdx["sit_agent_mission"] = array(
  "lien_664_fk" => "mission_id",
  "lien_665_fk" => "agent_id",
  );

$tabFk["sit_agent_mission"] = array(
  "fk_sit_agen_lien_664_sit_miss" => array("ffk" => "mission_id", "tpk" => "sit_mission", "fpk" => "mission_id"),
  "fk_sit_agen_lien_665_sit_agen" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  );

//   Table : SIT_AGENT_SERVICE                                 
$tabTable["sit_agent_service"] = array(
  "service_id" => array("type" => "int", "dn" => "NOT NULL"),
  "agent_id" => array("type" => "int", "dn" => "NOT NULL"),
  );

$tabPk["sit_agent_service"]["pk_sit_agent_service"] = "service_id, agent_id";

$tabIdx["sit_agent_service"] = array(
  "lien_708_fk" => "service_id",
  "lien_709_fk" => "agent_id",
  );

$tabFk["sit_agent_service"] = array(
  "fk_sit_agen_lien_708_sit_serv" => array("ffk" => "service_id", "tpk" => "sit_service", "fpk" => "service_id"),
  "fk_sit_agen_lien_709_sit_agen" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  );

// Table : SIT_AGENT_FONCTION
$tabTable["sit_agent_fonction"] = array(
  "agent_id" => array("type" => "int", "dn" => "NOT NULL"),
  "fonc_id" => array("type" => "int", "dn" => "NOT NULL"),
  );

$tabPk["sit_agent_fonction"]["pk_sit_agent_fonction"] = "agent_id, fonc_id";
  
$tabIdx["sit_agent_fonction"] = array(
  "sit_agentfonc_agentid_fk" => "agent_id",
  "sit_agentfonc_foncid_fk" => "fonc_id",
  );
  
$tabFk["sit_agent_fonction"] = array(
  "fk_agentfonction_agentid" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_agentfonction_foncid" => array("ffk" => "fonc_id", "tpk" => "sit_fonction", "fpk" => "fonc_id"),
  );

// Table : SIT_SERVICE_FONCTION
$tabTable["sit_service_fonction"] = array(
  "service_id" => array("type" => "int", "dn" => "NOT NULL"),
  "fonc_id" => array("type" => "int", "dn" => "NOT NULL"),
  );

$tabPk["sit_service_fonction"]["pk_sit_service_fonction"] = "service_id, fonc_id";

$tabIdx["sit_service_fonction"] = array(
  "sit_servfonc_foncid_fk" => "fonc_id",
  "sit_servfonc_servid_fk" => "service_id",
  );

$tabFk["sit_service_fonction"] = array(
  "fk_servicefonction_foncid" => array("ffk" => "fonc_id", "tpk" => "sit_fonction", "fpk" => "fonc_id"),
  "fk_servicefonction_servid" => array("ffk" => "service_id", "tpk" => "sit_service", "fpk" => "service_id"),
  );

// insert initial : SIT_APPLI_DROIT , SIT_APPLI_TYPE
$tabIns[] = "insert into SIT_PROFIL (PROFIL_ID , PROFIL_INTITULE , PROFIL_DESC, PROFIL_EFFACABLE)".
  " values (1 , 'Utilisateur' , 'Profil utilisateur de base.', 0)";

$tabIns[] = "insert into SIT_TELECOM (TELECOM_ID , TELECOM_INTITULE , TELECOM_RANG) values (1 , 'Tel.Bureau (ligne directe)' , 2)";
$tabIns[] = "insert into SIT_TELECOM (TELECOM_ID , TELECOM_INTITULE , TELECOM_RANG) values (2 , 'Fax' , 3)";
$tabIns[] = "insert into SIT_TELECOM (TELECOM_ID , TELECOM_INTITULE , TELECOM_RANG) values (3 , 'Minitel' , 9)";
$tabIns[] = "insert into SIT_TELECOM (TELECOM_ID , TELECOM_INTITULE , TELECOM_RANG) values (4 , 'Courriel' , 1)";
$tabIns[] = "insert into SIT_TELECOM (TELECOM_ID , TELECOM_INTITULE , TELECOM_RANG) values (5 , 'Site' , 8)";
$tabIns[] = "insert into SIT_TELECOM (TELECOM_ID , TELECOM_INTITULE , TELECOM_RANG) values (6 , 'Tel.Mobile' , 4)";
$tabIns[] = "insert into SIT_TELECOM (TELECOM_ID , TELECOM_INTITULE , TELECOM_RANG) values (7 , 'Tel.Assistant' , 6)";
$tabIns[] = "insert into SIT_TELECOM (TELECOM_ID , TELECOM_INTITULE , TELECOM_RANG) values (8 , 'Tel.Secrétariat' , 5)";
$tabIns[] = "insert into SIT_TELECOM (TELECOM_ID , TELECOM_INTITULE , TELECOM_RANG) values (9 , 'Tel.Domicile' , 7)";
$tabIns[] = "insert into SIT_TELECOM (TELECOM_ID , TELECOM_INTITULE , TELECOM_RANG) values (10 , 'Tel.Poste' , 2)";

$tabIns[] = "insert into SIT_AGENT_TYPE (AGTYPE_ID , AGTYPE_INTITULE , AGTYPE_RANG) values (0 , 'Individuelle' , 1)";
$tabIns[] = "insert into SIT_AGENT_TYPE (AGTYPE_ID , AGTYPE_INTITULE , AGTYPE_RANG) values (1 , 'Groupe' , 2)";

$tabIns[] = "insert into SIT_AGENT (AGENT_ID, PROFIL_ID, AGENT_PRIV, AGENT_NOM, AGENT_PRENOM, AGENT_FONCTION, AGENT_LOGIN,". 
  "AGENT_PWD, AGENT_DESC, AGENT_VALIDE, AGENT_DATE_CONN, AGENT_MAIL, AGENT_DATEVALID, AGENT_DATE_CREA, AGENT_DATE_MAJ)".
  " values (1 , 1, 36 , 'ALKANTE' , 'Administrateur' , '' , 'alkante' , md5('PyS2ziP') , 'Administrateur Alkante' , 1 ,".
  $dbConn->getDateCur().", 'p.cliquet@alkante.com', ".$dbConn->getDateCur().", ".$dbConn->getDateCur().", ".$dbConn->getDateCur().")";
$tabIns[] = "update SIT_AGENT set AGENT_ID_CREA=1, AGENT_ID_MAJ=1 where AGENT_ID=1";

$tabIns[] = "insert into SIT_ADRESSE (ADR_ID, AGENT_ID, ADR_ADR1, ADR_ADR2, ADR_ADR3, ADR_POST, ADR_VILLE, ADR_DESC, ADR_PAYS)". 
  " values (1, 1, '1, rue du chêne Morand', '', '', '35510', 'Cesson-Sévigné', '', 'France')";

$tabIns[] = "insert into SIT_COORDONNEE (COOR_ID , TELECOM_ID , AGENT_ID , COOR_VALEUR) values (1 , 4 , 1 , 'p.cliquet@alkante.com')";

$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE) values (0, 'Autres que Régions et Départements', '', 0)";

$tabIns[] = "insert into SIT_SERVICE (SERVICE_ID, SERVICE_INTITULE, SERVICE_RACINE, SERVICE_PERE, SERVICE_ARBRE," .
  " SERVICE_NIVEAU, SERVICE_RANG, SERVICE_INTITULE_COURT, SERVICE_EFFACABLE)" .
  " values (1 , 'SI' , 1 , 0 , '-1-' , 0 , 1 , 'SI' , 0)";
    
$tabIns[] = "insert into SIT_SERVICE (SERVICE_ID, SERVICE_INTITULE, SERVICE_RACINE, SERVICE_PERE, SERVICE_ARBRE," .
  " SERVICE_NIVEAU, SERVICE_RANG, SERVICE_INTITULE_COURT, SERVICE_EFFACABLE)" .
  " values (2 , 'Partenaires' , 2 , 1 , '-1-2-' , 1 , 1 , 'PART' , 0)";

$tabIns[] = "insert into SIT_AGENT_SERVICE (SERVICE_ID , AGENT_ID) values (2 , 1)";
$tabIns[] = "insert into SIT_AGENT_PROFIL (PROFIL_ID , AGENT_ID) values (1 , 1)";

if( defined("ALK_USER_ID_INTERNET") && ALK_USER_ID_INTERNET==2 ) {
  $tabIns[] = "insert into SIT_PROFIL (PROFIL_ID , PROFIL_INTITULE , PROFIL_DESC, PROFIL_EFFACABLE)".
    " values (2 , 'Internet' , 'Profil visiteur internet.', 0)";
  
  $tabIns[] = "insert into SIT_AGENT (AGENT_ID, PROFIL_ID, AGENT_PRIV, AGENT_NOM, AGENT_PRENOM, AGENT_FONCTION, AGENT_LOGIN,". 
    "AGENT_PWD, AGENT_DESC, AGENT_VALIDE, AGENT_DATE_CONN, AGENT_MAIL, AGENT_DATEVALID, AGENT_DATE_CREA, AGENT_DATE_MAJ, AGENT_ADMINAUTH)".
    " values (2 , 2, 0 , 'INTERNET' , 'Visiteur' , '' , 'vinternet' , md5('vinternet') , 'no-reply@alkante.com' , 1 ,".
    $dbConn->getDateCur().", '', ".$dbConn->getDateCur().", ".$dbConn->getDateCur().", ".$dbConn->getDateCur().", 0)";  

  $tabIns[] = "update SIT_AGENT set AGENT_ID_CREA=1, AGENT_ID_MAJ=1 where AGENT_ID=2";

  $tabIns[] = "insert into SIT_ADRESSE (ADR_ID, AGENT_ID, ADR_ADR1, ADR_ADR2, ADR_ADR3, ADR_POST, ADR_VILLE, ADR_DESC, ADR_PAYS)". 
    " values (2, 2, null, null, null, null, null, null, null)";
  
  $tabIns[] = "insert into SIT_AGENT_SERVICE (SERVICE_ID , AGENT_ID) values (2 , 2)";
  $tabIns[] = "insert into SIT_AGENT_PROFIL (PROFIL_ID , AGENT_ID) values (2 , 2)";
}

// Région et département : il faut fixer le champ DEPT_VISIBLE à 1 au paramètrage

$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(1, 'ALSACE', '42', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(2, 'AQUITAINE', '72', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(3, 'AUVERGNE', '83', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(4, 'BOURGOGNE', '26', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(5, 'BRETAGNE', '53', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(6, 'CENTRE', '24', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(7, 'CHAMPAGNE-ARDENNE', '21', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(8, 'CORSE', '94', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(9, 'FRANCHE-COMTE', '43', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(10, 'ILE-DE-FRANCE', '11', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(11, 'LANGUEDOC-ROUSSILLON', '91', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(12, 'LIMOUSIN', '74', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(13, 'LORRAINE', '41', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(14, 'MIDI-PYRENEES', '73', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(15, 'NORD-PAS-DE-CALAIS', '31', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(16, 'BASSE-NORMANDIE', '25', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(17, 'HAUTE-NORMANDIE', '23', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(18, 'PAYS-DE-LA-LOIRE', '52', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(19, 'PICARDIE', '22', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(20, 'POITOU-CHARENTES', '54', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(21, '".$dbConn->analyseSql("PROVENCE-ALPES-COTE-D'AZUR")."', '93', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(22, 'RHONE-ALPES', '82', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(24, 'AIN', '01', 22, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(25, 'AISNE', '02', 19, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(26, 'ALLIER', '03', 3, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(27, 'ALPES-DE-HAUTE-PROVENCE', '04', 21, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(28, 'HAUTES-ALPES', '05', 21, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(29, 'ALPES-MARITIMES', '06', 21, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(30, 'ARDECHE', '07', 22, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(31, 'ARDENNES', '08', 7, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(32, 'ARIEGE', '09', 14, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(33, 'AUBE', '10', 7, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(34, 'AUDE', '11', 11, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(35, 'AVEYRON', '12', 14, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(36, 'BOUCHES-DU-RHONE', '13', 21, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(37, 'CALVADOS', '14', 16, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(38, 'CANTAL', '15', 3, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(39, 'CHARENTE', '16', 20, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(40, 'CHARENTE-MARITIME', '17', 20, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(41, 'CHER', '18', 6, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(42, 'CORREZE', '19', 12, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(43, '".$dbConn->analyseSql("COTE-D'OR")."', '21', 4, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(44, '".$dbConn->analyseSql("COTES-D'ARMOR")."', '22', 5, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(45, 'CREUSE', '23', 12, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(46, 'DORDOGNE', '24', 2, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(47, 'DOUBS', '25', 9, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(48, 'DROME', '26', 22, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(49, 'EURE', '27', 17, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(50, 'EURE-ET-LOIR', '28', 6, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(51, 'FINISTERE', '29', 5, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(52, 'CORSE-DU-SUD', '2A', 8, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(53, 'HAUTE-CORSE', '2B', 8, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(54, 'GARD', '30', 11, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(55, 'HAUTE-GARONNE', '31', 14, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(56, 'GERS', '32', 14, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(57, 'GIRONDE', '33', 2, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(58, 'HERAULT', '34', 11, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(59, 'ILLE-ET-VILAINE', '35', 5, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(60, 'INDRE', '36', 6, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(61, 'INDRE-ET-LOIRE', '37', 6, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(62, 'ISERE', '38', 22, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(63, 'JURA', '39', 9, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(64, 'LANDES', '40', 2, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(65, 'LOIR-ET-CHER', '41', 6, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(66, 'LOIRE', '42', 22, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(67, 'HAUTE-LOIRE', '43', 3, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(68, 'LOIRE-ATLANTIQUE', '44', 18, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(69, 'LOIRET', '45', 6, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(70, 'LOT', '46', 14, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(71, 'LOT-ET-GARONNE', '47', 2, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(72, 'LOZERE', '48', 11, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(73, 'MAINE-ET-LOIRE', '49', 18, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(74, 'MANCHE', '50', 16, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(75, 'MARNE', '51', 7, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(76, 'HAUTE-MARNE', '52', 7, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(77, 'MAYENNE', '53', 18, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(78, 'MEURTHE-ET-MOSELLE', '54', 13, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(79, 'MEUSE', '55', 13, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(80, 'MORBIHAN', '56', 5, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(81, 'MOSELLE', '57', 13, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(82, 'NIEVRE', '58', 4, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(83, 'NORD', '59', 15, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(84, 'OISE', '60', 19, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(85, 'ORNE', '61', 16, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(86, 'PAS-DE-CALAIS', '62', 15, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(87, 'PUY-DE-DOME', '63', 3, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(88, 'PYRENEES-ATLANTIQUES', '64', 2, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(89, 'HAUTES-PYRENEES', '65', 14, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(90, 'PYRENEES-ORIENTALES', '66', 11, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(91, 'BAS-RHIN', '67', 1, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(92, 'HAUT-RHIN', '68', 1, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(93, 'RHONE', '69', 22, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(94, 'HAUTE-SAONE', '70', 9, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(95, 'SAONE-ET-LOIRE', '71', 4, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(96, 'SARTHE', '72', 18, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(97, 'SAVOIE', '73', 22, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(98, 'HAUTE-SAVOIE', '74', 22, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(99, 'PARIS', '75', 10, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(100, 'SEINE-MARITIME', '76', 17, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(101, 'SEINE-ET-MARNE', '77', 10, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(102, 'YVELINES', '78', 10, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(103, 'DEUX-SEVRES', '79', 20, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(104, 'SOMME', '80', 19, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(105, 'TARN', '81', 14, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(106, 'TARN-ET-GARONNE', '82', 14, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(107, 'VAR', '83', 21, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(108, 'VAUCLUSE', '84', 21, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(109, 'VENDEE', '85', 18, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(110, 'VIENNE', '86', 20, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(111, 'HAUTE-VIENNE', '87', 12, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(112, 'VOSGES', '88', 13, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(113, 'YONNE', '89', 4, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(114, 'TERRITOIRE-DE-BELFORT', '90', 9, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(115, 'ESSONNE', '91', 10, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(116, 'HAUTS-DE-SEINE', '92', 10, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(117, 'SEINE-SAINT-DENIS', '93', 10, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(118, 'VAL-DE-MARNE', '94', 10, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(119, '".$dbConn->analyseSql("VAL-D'OISE")."', '95', 10, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(120, 'GUADELOUPE', '1', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(121, 'MARTINIQUE', '2', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(122, 'GUYANE', '3', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(123, 'LA REUNION', '4', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(124, 'GUADELOUPE', '971', 120, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(125, 'MARTINIQUE', '972', 121, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(126, 'GUYANE', '973', 122, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(127, 'LA REUNION', '974', 123, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(128, 'SAINT-PIERRE-ET-MIQUELON', '975', 0, 0)";
$tabIns[] = "insert into SIT_DEPT (DEPT_ID, DEPT_INTITULE, DEPT_NUM, DEPT_PERE, DEPT_VISIBLE) VALUES(139, 'MAYOTTE', '976', 0, 0)";

?>