<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Alkanet
Ce fichier permet d'enregistrer le statut d'un message envoyé en différé.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


/** Chargement des fichiers de config */
include_once("../../../libconf/app_conf.php");

// initialisation des langues, nécessaire si $tabLg n'est pas défini dans le fichier app_conf.php
require_once(ALK_ALKANET_ROOT_PATH."lib/lib_locales.php");
$bFrontOffice = false;
initAlkLocale();

require_once(ALK_ALKANET_ROOT_PATH."lib/app_conf_alkanet.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."app_conf_sig.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkrequest.class.php");

/** Chargement des classes de bases */
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkfactory.class.php");

if( isset($_SERVER["HTTP_HOST"]) ) {
  // on interdit l'accès à partir du serveur web
  exit(1);
}

$msg_id = ( $argc == 2 && is_numeric($argv[1]) ? $argv[1] : -1 ); 
if( $msg_id <= 0 ) {
  // on interdit l'accès à partir du serveur web
  echo "Paramètre incorrecte.";
  exit(2);
} 

$dbConn = AlkFactory::getDbConn();
if( !is_null($dbConn) ) {
  if( !defined("ALK_B_ATYPE_LSDIF") ) {
    define("ALK_B_ATYPE_LSDIF", true);
  }
  
  $oQueryActionLsDif = AlkFactory::getQueryAction(ALK_ATYPE_ID_LSDIF);
  if( !is_null($oQueryActionLsDif) ) {
    $oQueryActionLsDif->saveMsgSent($msg_id, true);
  } else {
    echo "Impossible de mettre à jour le statut.";
    exit(4);
  }
} else {
  // on interdit l'accès à partir du serveur web
  echo "Connexion impossible à la base.";
  exit(3);
}

// sortie avec succès
exit(0);
?>
