{*licence 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::CEdit
Module consultation éditoriale..
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

licence
*}
{strip}
{php}

//$this->assign('dateMajSite', date('d/m/Y', strtotime($dateMajSite)));

$oQuerySpace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);

{/php}

{include file='../../../libconf/templates/alkhtmlpageheader.tpl' bAccueil=2}

{php}


// présentation des champs de base
require_once("../../lib/lib_session.php");


if( defined("ALK_B_SAMEDOMAIN") && ALK_B_SAMEDOMAIN==false && ALK_ROOT_URL != ALK_ROOT_URL_BACKOFFICE ) {
  header("location:".ALK_ROOT_URL_BACKOFFICE.( defined("ALK_VIRTUAL_DIR_BACKOFFICE") ? ALK_VIRTUAL_DIR_BACKOFFICE : ( defined("ALK_VIRTUAL_DIR") ? ALK_VIRTUAL_DIR : ALK_ROOT_DIR ) ).ALK_INDEX_AUTH);
}

AlkFactory::initLocale(false);
$err = AlkRequest::_GETint("err", "");
$fin = AlKRequest::_GETint("fin", -1);

if ($fin==1){
  // delete de la connexion
  $session_id = session_id();
  $agent_id   = $_SESSION["alk_idUser"];
  if( !defined("ALK_B_ATYPE_ESPACE") ) define("ALK_B_ATYPE_ESPACE", true);
  $oQueryActionEspace = AlkFactory::getQueryAction(ALK_ATYPE_ID_ESPACE);
  $oQueryActionEspace->deleteConnexionUser($agent_id, $session_id);
}

$oTemplate =& AlkFactory::getTemplate();

$strTokenHelp = AlkRequest::getEncodeParam("cont_id=1&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_CONTACT."&iSSheet=".ALK_SHEET_NONE);
$strTokenPwd  = AlkRequest::getEncodeParam("cont_id=1&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_CREATEUSER."&iSSheet=".ALK_SHEET_NONE."&err=0");
$strTokenInsc = AlkRequest::getEncodeParam("cont_id=1&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_CREATEUSER."&iSSheet=".ALK_SHEET_NONE."&err=1");

$strPathFileName = ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."ident/configurer_navigateur.pdf";
if (file_exists($strPathFileName) && is_file($strPathFileName)){
  $oTemplate->assign("bPdf", true);
}

$oTemplate->assign("strTokenHelp", $strTokenHelp);
$oTemplate->assign("strTokenPwd", $strTokenPwd);
$oTemplate->assign("strTokenInsc", $strTokenInsc);
// traitement des messages d'erreurs
if( $err != "" ) {
  $strHtml = "";
  
  switch( $err ) {
  case "1":
    $strHtml = "Authentification refusée.<br/>".
      "Essayez &agrave; nouveau, ou si vous continuez à ne pas y arriver,".
      " <a class='homeLink' onclick=\"javascript:help('".$strTokenHelp."')\">contactez un administrateur</a>.";
    break;
  case "2":
  case "6":
     $strHtml = "<br/>Veuillez vous réauthentifier.<br/>&nbsp;";
     break;
  }
  if( $strHtml != "" ) $strHtml = "<div class='homeFrameErr homeErr'>".$strHtml."</div>";
} else {
   // redirige vers la page de redirection SSO si authentification SSO et utilisateur authentifié
   if ( defined("ALK_AUTH") && defined("ALK_AUTH_SSO") && ALK_AUTH == ALK_AUTH_SSO
     && isset($_SESSION["alk_ssoUser"]) && $_SESSION["alk_ssoUser"] == true
     && defined("ALK_SSO_REDIRECT") && ALK_SSO_REDIRECT != "" ) {
     header("location: ".ALK_SSO_REDIRECT);
   }
   
   $strHtml= "<div class='homeFrameErr' style='text-align:center; padding-top:10px;'>".
     "<span class='homeTxt'>Veuillez saisir votre identifiant<br/>".
     " et votre mot de passe.</span></div>";
}
$oTemplate->assign("strHtmlContent", $strHtml);
 
 // chargement d'un template spécifique
 $strPathTemplate = ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."index_ident.tpl";
 if ( !(file_exists($strPathTemplate) && is_file($strPathTemplate))){
    // chargement du modèle
    $strPathTemplate = ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."alkanet/templates/index_ident.tpl";
 }
 
 // titre du formulaire
 $oTemplate->assign("strTitle", "Authentification");
 
 // champs par défaut
 $oLogin = AlkHtmlFactory::getNewHtmlText(null, 0, "strLogin", "", _t("Identifiant"), 1, 15, 80);
 $oLogin->setProperty("cssFormCtrl", "homeCtrl");
 $oTemplate->assign_by_ref("oLogin", $oLogin);
 
 $oPwd = AlkHtmlFactory::getNewHtmlText(null, 0, "strPwd2", "", _t("Mot de passe"), 1, 15, 80);
 $oPwd->setProperty("cssFormCtrl", "homeCtrl");
 $oPwd->setBPassword(true);
 $oTemplate->assign_by_ref("oPwd", $oPwd);
 
 // charge de css
 $strPathCss = "templates/home.css";
 if ( (file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."home.css") && is_file(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."home.css"))){
    // chargement du modèle
     $strPathCss = "../../".ALK_ROOT_STYLE."home.css";
 }
 
 $oTemplate->assign("strTexteOublie", _t("Mot de passe oublié?"));
 $oTemplate->assign("strTexteInscrip", _t("Vous souhaitez vous inscrire"));
 $oTemplate->assign("bOublie", true);
 $oTemplate->assign("bInscription", false);
 
 $strHtml = $oTemplate->fetch($strPathTemplate);
 //echo $strHtml;
 
 $GLOBALS["oHtmlPage"]->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_js.js");  
 $GLOBALS["oHtmlPage"]->addScriptJs(ALK_ALKANET_ROOT_URL."lib/lib_crypt.js");
 $GLOBALS["oHtmlPage"]->addScriptJs(ALK_ALKANET_ROOT_URL."scripts/alkanet/lib/index.js");
 $GLOBALS["oHtmlPage"]->addScriptJs(ALK_ALKANET_ROOT_URL."libconf/lib/index.js");
 $GLOBALS["oHtmlPage"]->addScriptCss($strPathCss);
{/php}


<form id="formLogin" name="formLogin" method="post" action="" onsubmit="return validIdentCRBN('{php}echo AlkRequest::getEncodeParam('/accueil'){/php}')">
  <input type="hidden" id="windSize" name="windSize" value=""/>
  <input type="hidden" id="strPwd" name="strPwd" value=""/>
  <div align="center">
    <div class="homeBackgound">
      <fieldset class='homeFieldSet'>
        {$strHtmlContent}
        <div class='homeFrameLogin'>
          <label class='homeLabel' for='{$oLogin->getGUID()}'>{$oLogin->getLabel()}</label>
          {$oLogin->getHtml()}
        </div>
        <div class='homeFramePwd'>
          <label class='homeLabel' for='{$oPwd->getGUID()}'>{$oPwd->getLabel()}</label>
          {$oPwd->getHtml()}
        </div>
        <div class='homeFrameBt'>
          <input id='btValider' name='btValider' type='submit' value='OK' value='Valider'/>
        </div>
        {if (isset($bOublie) && $bOublie)}
          <div class='homeFrameOubli'><a class='homeLink' onclick="javascript:getLogin('{$strTokenPwd}')">{$strTexteOublie}</a></div>
        {/if}
        {if (isset($bInscription) && $bInscription)}
          <div class='homeFrameHelp'><a class='homeLink' onclick="javascript:getLogin('{$strTokenInsc}')">{$strTexteInscrip}</a></div>
        {/if}
        {if (isset($bPdf) && $bPdf)}
          <div class='homeFramePdf'><a class='homeLink' href='configurer_navigateur.pdf' target='windPDF'>Information pour configurez son navigateur</a></div>
        {/if}
        
      </fieldset>
    </div>
  </div>
</form>
{include file='../../../libconf/templates/alkhtmlpagefooter.tpl' bAccueil=0}

{/strip}