/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

String.prototype.isTextAlpha = function() {
   return new RegExp("^[A-Za-zÀÂÇÈÉÊËÎÔÙÛàâçèéêëîôùû\\-' ]+$").test(this);
}
String.prototype.isTextNum = function() {
   return new RegExp("^\\d+$").test(this);
}
String.prototype.trim = function() {
  return this.replace(new RegExp("^\\s+|\\s+$"), '');
}
function isFieldEmpty(obj, strMsg)
{
  var strTmp = _gt("Ce champ est obligatoire.");
  
  if( typeof(strMsg) != 'undefined' ) strTmp = strMsg;          

  if( obj.value.trim() == "" ) {
    alkAlert(strTmp);
    obj.focus();
    return true;
  }
  return false;
}
function isChaineVide(obj, strMsg) 
{ 
  return isFieldEmpty(obj, strMsg); 
}
function AlertMessage(Ctrl, strMsg) 
{
  alkAlert(strMsg);
  Ctrl.focus();
  return;
}
function AlkReplaceSpecialChar(oCtrl) {
  if( typeof(oCtrl) != "undefined" && 
      typeof(oCtrl.value) != "undefined" ) {
    var strTexte = new String(oCtrl.value);
    var strNew = "";
    for (j=0; j<strTexte.length; j++) {
      if( strTexte.charCodeAt(j) == 8217 ) strNew = strNew + "'";
      else if( strTexte.charCodeAt(j) == 8364 ) strNew = strNew + "€";
      else if( strTexte.charCodeAt(j) == 339 ) strNew = strNew + "oe";
      else if( strTexte.charCodeAt(j) == 338 ) strNew = strNew + "OE";
      else if( strTexte.charCodeAt(j) > 255 ) strNew = strNew + " ";
      else strNew = strNew + strTexte.charAt(j);
    }
    oCtrl.value = strNew;
  }
}

function verifMailValid(adresse, strLabel) 
{
  var tabAdresse = adresse.split(";");
  for(var i=0; i<tabAdresse.length; i++) {
    adresse = tabAdresse[i].trim();
    if ( new RegExp("^[A-Za-z0-9\-_][!$#%&'*+-\\/=^?_`{}|~A-Za-z0-9]*@[A-Za-z0-9\\-_][A-Za-z0-9\\.\\-_]*\\.[A-Za-z0-9\\-_]{2,6}$").test(adresse) && 
         !new RegExp("\\.\\.").test(adresse) && adresse.split("@").length==2 )
      continue;
    
    return  _gtf("Le champ %s nécessite une adresse électronique valide.", strLabel)+"\n"+
      _gtf("L'adresse '%s' doit être de la forme 'x@y.z' où x, y, z sont des chaînes de caractères non vides et sans espace.", adresse);
  }
  return "";
}

function verifTextNum(strValue, oMin, oMax, strLabel)
{
  reason = "";
  var strV = new String(strValue);
  if( strV.isTextNum() == false ) {
    reason = _gtf("Le champ %s n'accepte que des chiffres.", strLabel);
    return reason;
  }
  if( oMin != "" && strV.length < oMin ) {
    reason = ( oMin==oMax
               ? _ngtf("Le champ %s nécessite %s chiffre", "Le champ %s nécessite %s chiffres", oMin, strLabel, oMin)  
               : _ngtf("Le champ %s nécessite au moins %s chiffre", "Le champ %s nécessite au moins %s chiffres", oMin, strLabel, oMin) );                             
    return reason;
  }
  if( oMax != "" && strV.length > oMax ) {
    reason = ( oMin==oMax
               ? _ngtf("Le champ %s nécessite %s chiffre", "Le champ %s nécessite %s chiffres", oMax, strLabel, oMax)  
               : _ngtf("Le champ %s nécessite au plus %s chiffre", "Le champ %s nécessite au plus %s chiffres", oMax, strLabel, oMax) );                             
    return reason;    
  }
  return reason;
}

function verifTextAlpha(strValue, oMin, oMax, strLabel)
{
  reason = "";
  var strV = new String(strValue);
  if( strV.isTextAlpha() == false ) {
    reason = _gtf("Le champ %s n'accepte que des lettres, l'apostrophe, le tiret et l'espace.", strLabel);
    return reason;
  }
  if( oMin != "" && strV.length < oMin ) {
    reason = ( oMin==oMax
               ? _ngtf("Le champ %s nécessite %s caractère", "Le champ %s nécessite %s caractères", oMin, strLabel, oMin)  
               : _ngtf("Le champ %s nécessite au moins %s caractère", "Le champ %s nécessite au moins %s caractères", oMin, strLabel, oMin) );  
    return reason;
  }
  if( oMax != "" && strV.length > oMax ) {
    reason = ( oMin==oMax
               ? _ngtf("Le champ %s nécessite %s caractère", "Le champ %s nécessite %s caractères", oMax, strLabel, oMax)  
               : _ngtf("Le champ %s nécessite au plus %s caractère", "Le champ %s nécessite au plus %s caractères", oMax, strLabel, oMax) );  
    return reason;    
  }
  return reason;
}

function verifTextUrl(strValue, iTypeUrl)
{
  reason = "";
  var strV = new String(strValue);
  
  if(iTypeUrl == 0) {
    reason = commence_par(strValue, "http://");
  }
  if(iTypeUrl == 1) {
    reason = commence_par(strValue, "https://");
  }
  if(iTypeUrl == 2) {
    reason = commence_par(strValue, "ftp://");
  }
    
  return reason;
}

function commence_par(strValue, strDebut) 
{
  var reason = "";
  strValue = strValue.toString();
  if (strValue.indexOf(strDebut) != 0) 
    reason = _gtf("la valeur doit commencer par %s", strDebut);
  return reason;
}
function validLongueurTextArea(oTextArea, lengthMax, guid)
{
  var nbCar = lengthMax - oTextArea.textLength;
  var oMsg = document.getElementById("counter_"+guid);
  if (!oMsg) return;
  if ( nbCar>=0 ){
    oMsg.className = "";
    oMsg.innerHTML = "("+_gtf("%s car. restant", nbCar)+")";
  }
  else {
    oMsg.className = "txtWarning";
    oMsg.innerHTML = "("+_gtf("%s car. excédant", Math.abs(nbCar))+")";
  }
}
