/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/** tableau mémorisant les instances XmlHttpRequest */
var tabXhr = new Array();

var reconnectExp = /\/\*ALK_RECONNECT\*\//;

AlkAjax.prototype.constructor = AlkAjax;
function AlkAjax(_name, onreadystate, methodSend, url, data)
{
  var tabMethod = new Array("GET", "POST");
  if( methodSend == 0 || methodSend == 1 ) 
    methodSend = tabMethod[methodSend];
  else if( methodSend.toUpperCase() == "GET" || methodSend.toUpperCase() == "POST" ) {
    methodSend = methodSend.toUpperCase();  
  } else {
    methodSend = "GET";
  }

  this._name        = _name;
  this.indexXHR     = -1;
  this.onreadystate = onreadystate;
  this.methodSend   = methodSend;
  this.url          = url;
  this.data         = data;
  this.async_mode   = true;
  this.returnValue  = null;

  var iArg = 5;
  var errorMethod = "";
  var startMethod = "";
  var stopMethod = "";
  var returnValue = null; 

  if( arguments.length>iArg) this.async_mode = arguments[iArg++];
  if (arguments.length>iArg) errorMethod     = arguments[iArg++];
  if (arguments.length>iArg) startMethod     = arguments[iArg++];
  if (arguments.length>iArg) stopMethod      = arguments[iArg++];
  
  var oXhr = GetXMLHttpRequest(this);
  if(this.methodSend == "POST"){
    if( data!="" && data.indexOf("=")==-1 ) {
      this.convertFromToParam(data);
    }
    oXhr.open(this.methodSend, this.url, (this.async_mode ? true : false));
    oXhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    oXhr.setRequestHeader("Content-length", this.data.length);
    oXhr.setRequestHeader("Connection", "keep-alive");
    oXhr.setRequestHeader("Cache-Control", "no-cache"); 
  } else { 
    oXhr.open(this.methodSend, this.url, (this.async_mode ? true : false));
    oXhr.setRequestHeader("Cache-Control", "no-cache"); 
  }
  if( this.async_mode == true ) { 
    oXhr.onreadystatechange = function() {
      if( oXhr.readyState==1 && startMethod!="" ) {
        eval(startMethod+"();");
      } 
      if( oXhr.readyState == 4 ){ /*ready*/
        if ( oXhr.status == 200 ){ /* ok*/ 
          if ( reconnectExp.test(oXhr.responseText) ) {
            eval(oXhr.responseText);
            return;
          } else {
            if( onreadystate != "" ) {
              eval(onreadystate+"(oXhr.responseText);");
            }
          }
          if( stopMethod!="" ) {
            eval(stopMethod+"();");
          }
        } else {
          if( errorMethod!="" ) {
            eval(errorMethod+"(\"Error :\\nCall= "+this.url+"\\nResponse= "+oXhr.responseText+"\");");
          }
        }
        if( this.indexXHR>-1 && this.indexXHR<tabXhr.length ) {
          tabXhr[this.indexXHR] = false;
        }
      }
    }
  }
  
  oXhr.send(this.data);
  
  if( this.async_mode == false ) {
    returnValue = oXhr.responseText;
  }
  
  this.returnValue = returnValue;  
}

/**
 * Retourne la valeur retournée par fonction onreadystate appelée en backcall par la requête ajax
 * @return any
 */
AlkAjax.prototype.getReturnValue = function ()
{
  return this.returnValue;
}

/** 
 * @brief Retourne un référence sur l'objet XMLHttpRequest
 */
function GetXMLHttpRequest(oAjax)
{  
  var xhr = null; 
     
  if( window.XMLHttpRequest ) {
    // Firefox 
    xhr = new XMLHttpRequest(); 
  } else if( window.ActiveXObject ) {
    // Internet Explorer 
    xhr = new ActiveXObject("Microsoft.XMLHTTP"); 
  } else { 
    // XMLHTTPRequest non supporté par le navigateur 
    alert("Votre navigateur n'accepte pas de créer des requêtes de type AJAX."); 
    return null; 
  } 
  if( oAjax ) {
    oAjax.indexXHR = tabXhr.length;
    tabXhr[tabXhr.length] = xhr;
  }
  return xhr;
}

/**
 * Annule toutes les requêtes ajax en cours
 */
function abortAllHttpRequest()
{
  for(var i=0; i<tabXhr.length; i++) {
    if( tabXhr[i] ) {
      tabXhr[i].abort();
    }
  }
  tabXhr = new Array();
}
 
/**
 * Transforme les éléments d'un formulaire en paramètres de type '&name=value' et les concatène
 * retourne true si lecture du formulaire ok, retourne false sinon
 * 
 * Le résultat de la concaténation est stocké dans la propriété Data
 * @param formName  nom du formulaire à renvoyer
 * @return bool
 */
AlkAjax.prototype.convertFromToParam = function (formName)
{       
  eval("var oForm = document."+formName); 
  if( !oForm ) return false;
  
  var getstr = "";
  for (i=0; i<oForm.elements.length; i++) {
    if ( oForm.elements[i].disabled == false ) {
      if (oForm.elements[i].tagName == "INPUT") {
        if (oForm.elements[i].type == "text") {
          getstr += oForm.elements[i].name + "=" + encodeURIComponent(oForm.elements[i].value) + "&";
        }
        if (oForm.elements[i].type == "hidden") {
          getstr += oForm.elements[i].name + "=" + encodeURIComponent(oForm.elements[i].value) + "&";
        }
        if (oForm.elements[i].type == "password") {
      	  //Attention le mot de passe est encodé
          getstr += oForm.elements[i].name + "=" + encodeURIComponent(TextEncode(oForm.elements[i].value)) + "&";
        }
        if (oForm.elements[i].type == "checkbox") {
          if (oForm.elements[i].checked) {
            getstr += oForm.elements[i].name + "=" + encodeURIComponent(oForm.elements[i].value) + "&";
          } else {
            getstr += oForm.elements[i].name + "=&";
          }
        }
        if (oForm.elements[i].type == "radio") {
          if (oForm.elements[i].checked) {
            getstr += oForm.elements[i].name + "=" + encodeURIComponent(oForm.elements[i].value) + "&";
          }
        }
      }
      if (oForm.elements[i].type == "textarea") {
        getstr += oForm.elements[i].name + "=" + encodeURIComponent(oForm.elements[i].value) + "&";
      }   
      if (oForm.elements[i].tagName == "SELECT") {
        var sel = oForm.elements[i];
        if ( sel.multiple ) {
          for (var j=0; j<sel.options.length; j++ ) {
            if ( sel.options[j].selected ) {
              getstr += sel.name + "=" + encodeURIComponent(sel.options[j].value) + "&";
            }
          }
        } else {
          if( sel.options.length > 0 && sel.selectedIndex>=0 && sel.selectedIndex<sel.options.length ) 
            getstr += sel.name + "=" + encodeURIComponent(sel.options[sel.selectedIndex].value) + "&";
        }
      }
    }
  }
  
  this.data = getstr;
  return true;
}

/**
 * @brief Fonction à appeler lorsque le résultat d'un appel Ajax n'est pas traité 
 */
function NothingToDo(xhrResponseText){}
