<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Pattern
Module fournissant les classes de base Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkds.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkdrpgsql.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkerrorpgsql.class.php");

/**
 * @package Alkanet_Class_Pattern
 * 
 * @class AlkDsPgSql
 * @brief DataSet basé sur postgresql, hérite de la classe AlkDs
 */
final class AlkDsPgSql extends AlkDs
{

  /**
   *  Constructeur par défaut de la classe
   *
   * @param conn    handle de la connexion ouverte
   * @param strSQL  requête sql
   * @param idFirst indice de début pour la pagination (=0 par défaut)
   * @param idLast  indice de fin pour la pagination (=-1 par défaut)
   * @param bErr    true si gestion des erreurs, false pour passer sous silence l'erreur
   * @param strDbEncoding encodage du client sgbd
   */
  public function __construct($conn, $strSQL, $idFirst=0, $idLast=-1, $bErr=true, $strDbEncoding=ALK_SGBD_ENCODING)
  {
    parent::__construct($conn, $strSQL, $idFirst, $idLast, $bErr, $strDbEncoding);

    if( $bErr == true ) startErrorHandlerPgsql(); else ob_start();
    
    $this->iCountDr = 0;
    $this->bEof = true;
    $this->iCurDr = -1;
    $strSqlMax = "";
    
    // ajout spécifique du code si utilisation du jQuery DATATABLE
    $_columns    = AlkFactory::getSQLParamsName("columns", "");
    if ($_columns != ""){
      $_limit      = AlkFactory::getSQLParamsName("limit", -2);
      $_sortable   = AlkFactory::getSQLParamsName("sortable", array());
      $_searchable = AlkFactory::getSQLParamsName("searchable", array());
      $_start      = AlkFactory::getSQLParamsName("start", -2);
      $_columns    = AlkFactory::getSQLParamsName("columns", "");
      $_iColSort   = AlkFactory::getSQLParamsName("iColumSort", -2);
      $_sSortDir   = AlkFactory::getSQLParamsName("sSortDir", "");
      $_nbColumns  = AlkFactory::getSQLParamsName("nbColumns", "");
      $_sSearch    = AlkFactory::getSQLParamsName("sSearch", "");
      $tabWhere    = array();
      $tabOrderBy  = array();
      $strEndStart = "";

      $tabColumns = explode(",", $_columns);
      foreach ($tabColumns as $index => $strColumName){
        // filtre
        if ($_sSearch != "" && isset($_searchable[$index]) && $_searchable[$index]=="true")
          $tabWhere[] = "coalesce(lower(".$strColumName."::text), '')";
      }
      
      // order by 
      foreach ($_iColSort as $i => $itemICol){
        if (isset($_sortable[$itemICol]))
          $tabOrderBy[] = $tabColumns[$itemICol]." ".$_sSortDir[$i];
      }

      // analyseSql()
      $strEndStart = (!empty($tabWhere) ? " where ".implode("||", $tabWhere)." like '%".AlkFactory::getDbConn()->analyseSql(strtolower($_sSearch))."%'" : "").
                     (!empty($tabOrderBy) ? "order by ".implode(",", $tabOrderBy) : "");
      
      $strSqlOnly = $strSQL;
      $strSearchPath = "";
      if( substr($strSQL, 0, 18) == "set search_path to" ) {
        $strSqlOnly = substr($strSQL, strpos($strSQL, ";")+1);
        $strSearchPath = substr($strSQL, 0, strpos($strSQL, ";")+1);
      }
      $strSQL = $strSearchPath." select foo.* from (".$strSqlOnly.") foo ".$strEndStart;
      $idFirst = $_start;
      $idLast  = $idFirst+$_limit-1;
    }

    if( $idLast>=$idFirst && $idFirst>=0 ) {
      // pagination
      if( substr($strSQL, 0, 18) == "set search_path to" ) {
        $strSqlOnly = substr($strSQL, strpos($strSQL, ";")+1);
        $strSqlMax = "select count(*) as nb from (".$strSqlOnly.") subQuery";
      } else {
        $strSqlMax = "select count(*) as nb from (".$strSQL.") subQuery";
      }
      
      $nbEltParPage = ($idLast-$idFirst)+1;
      $strSQL .= " limit ".$nbEltParPage." offset ".$idFirst;
    }
    
    $this->oRes = @pg_query($conn, $strSQL);

    if( !is_resource($this->oRes) ) {
      if( $bErr == true ) {
        trigger_error("dsPgsql - Erreur requête (".$strSQL.", PgSql : ".pg_last_error($conn).")", E_USER_ERROR);
      } else {
        $this->_SetError("dsPgsql - Erreur requête (".$strSQL.", PgSql : ".pg_last_error($conn).")");
      }
    } else {
      // détermine le nombre d'éléments retournés
      $this->iCountDr = @pg_num_rows($this->oRes);
      if( is_bool($this->iCountDr) ) $this->iCountDr = 0;
      $this->iCountTotDr = ( $idLast>=$idFirst && $idFirst>=0 && $this->iCountDr>0 ? -1 : $this->iCountDr );
    }

    if( $strSqlMax != "" ) {
      // calcul le nombre total
      $this->iCountTotDr = -1;
      $oResCount = @pg_query($conn, $strSqlMax);
      if( is_resource($oResCount) ) {
        if( $oDrCount = @pg_fetch_object($oResCount) ) {
          $this->iCountTotDr = $oDrCount->nb;
          if( !is_numeric($this->iCountTotDr) ) {
            $this->iCountTotDr = $this->iCountDr;
          }
        }
      }
    
      if( $this->iCountTotDr == -1 ) {
        $this->iCountTotDr = $this->iCountDr;
        if( $bErr == true ) {
          trigger_error("dsPgsql -  fonction ".__FUNCTION__." : Erreur pg_fetch_all : ".pg_last_error($conn).")", E_USER_ERROR);
        } else {
          $this->_SetError("dsPgsql - fonction ".__FUNCTION__." : Erreur pg_fetch_all : ".pg_last_error($conn).")");
        }
      }
    }    
    
    if( $this->iCountDr > 0 ) {
      $this->iCurDr = 0;
      $this->bEof = false;
    } else {
      $this->iCountDr = 0;
      $this->iCountTotDr = 0;
    }

    if( $bErr == true ) endErrorHandlerPgsql(); else ob_end_clean();
  }

  /**
   * Méthode qui lit et mémorise tout le flux résultat de la requête
   * Cette méthode doit suivre l'appel à initDataSet() ou est appelée automatiquement par la méthode setTree()
   */
  public function fetchAll()
  {
    if( $this->bFetchAll ) return;
  
    if( $this->bErr == true ) startErrorHandlerPgsql(); else ob_start();

    $this->bUseInternalCache = true;
    
    // mémorise les types de champs
    if( empty($this->tabType) ) {
      $nbFields = @pg_num_fields($this->oRes);
      for($i=0; $i<$nbFields; $i++) {
        $this->tabType[$i] = @pg_field_type($this->oRes, $i);
        $this->tabFields[$i] = @pg_field_name($this->oRes, $i);
      }
    }
      
    if( $this->iCountDr > 0 ) {
      $this->iCurDr = 0;
      $this->bEof = false;
      $this->tabDr = @pg_fetch_all($this->oRes); // PGSQL_ASSOC par défaut
      if( is_bool($this->tabDr) ) {
        $this->tabDr = array();
        $this->iCurDr = -1;
        $this->bEof = true;
        if( $this->bErr == true ) {
          trigger_error("dsPgsql -  fonction ".__FUNCTION__." : Erreur pg_fetch_all : ".pg_last_error($conn).")", E_USER_ERROR);
        } else {
          $this->_SetError("dsPgsql - fonction ".__FUNCTION__." : Erreur pg_fetch_all : ".pg_last_error($conn).")");
        }
      }  
      
      if( $this->strCacheFieldIndex!="" ) {
        foreach($this->tabDr as $i => $tabDr) {
          if( isset($tabDr[$this->strCacheFieldIndex]) ) {
            $strKey = $tabDr[$this->strCacheFieldIndex];
          } else {
            trigger_error("AlkdsMysql - fonction ".__FUNCTION__." : cacheFieldIndex non trouvé.", E_USER_ERROR);
          }
          $this->tabDrIndex[$strKey] = $i;
        }
      }      
    }
  
    if( !$this->bEof ) {
      $this->bFetchAll = true;
      if( $this->bUseCache ) {
        AlkFactory::memCacheSetData($this->strCacheName, $this->strSql, $this, $this->iCacheExpire);
      }
    }
      
    if( $this->bErr == true ) endErrorHandlerPgsql(); else ob_end_clean();
  }
  
  /**
   * mémorise le contenu du dataSet en mémoire pour permettre la mise en cache par la suite
   * @param tabDr  contenu du dataRow représenté par un tableau associatif
   */
  protected function saveDataRow($tabDr)
  {
    if( !is_array($tabDr) ) {
      if( $this->bErr == true ) {
        trigger_error("DsPgSql[".__LINE__."] - pg_fetch_array error (Indice :".
                      count($this->tabDr)." , PgSql : ".pg_last_error($this->conn).")", E_USER_ERROR);
      } else {
        $this->_SetError(pg_last_error($this->conn));
        $this->tabDr[] = false;
        return;
      }
    }
    
    if( empty($this->tabType) ) {
      // mémorise les types
      $nbFields = @pg_num_fields($this->oRes);
      for($i=0; $i<$nbFields; $i++) {
        $this->tabType[$i] = @pg_field_type($this->oRes, $i);
        $this->tabFields[$i] = @pg_field_name($this->oRes, $i);
      }
    }
    
    // mémorise
    $this->tabDr[] = $tabDr;
    $iNewCount = count($this->tabDr);
    
    if( $this->strCacheFieldIndex!="" ) {
      if( isset($tabDr[$this->strCacheFieldIndex]) ) {
        $strKey = $tabDr[$this->strCacheFieldIndex];
      } else {
        trigger_error("AlkdsPgsql - fonction ".__FUNCTION__." : cacheFieldIndex non trouvé.", E_USER_ERROR);
      }
      $this->tabDrIndex[$strKey] = $iNewCount-1;
    }
    
    if( $iNewCount == $this->iCountDr && !$this->bFetchAll ) {
      $this->bFetchAll = true;
      if( $this->bUseCache ) {
        AlkFactory::memCacheSetData($this->strCacheName, $this->strSql, $this, $this->iCacheExpire);
      }
    }
  }
  
  /**
   *  Retourne le datarow (dr) correspondant à l'indice courant ($iCurDr)
   *
   * @return Retourne un dataRow si ok, false sinon
   */
  public function getRow()
  {
    trigger_error("AlkdsPgsql - fonction ".__FUNCTION__." obsolète.", E_USER_ERROR);
    
    /*$drRes = false;
    if( $this->iCurDr>=0 && $this->iCurDr<$this->iCountDr ) {
      $drRes = new AlkDrPgSql($this->tabDr[$this->iCurDr], $this);
    } else {
      $this->iCurDr = -1;
      $this->bEof = true;
    }
    return $drRes;*/
  }

  /**
   *  Retourne le datarow (dr) correspondant à l'indice courant ($iCurDr) puis passe au suivant
   *        Retourne false si EOF est atteint
   *
   * @return Retourne un dataRow si ok, false sinon
   */
  public function getRowIter()
  {
    $drRes = false;
    if( $this->iCurDr>=0 && $this->iCurDr<$this->iCountDr ) {
      if( $this->bErr == true ) startErrorHandlerPgsql(); else ob_start();
      if( !$this->bFetchAll ) {
        if( $this->bUseInternalCache ) {
          $this->saveDataRow(@pg_fetch_array($this->oRes, null, PGSQL_ASSOC));
          $drRes = new AlkDrPgSql($this->tabDr[$this->iCurDr], $this);
        } else {
          /// nécessaire pour utiliser getValueNum()
          if( empty($this->tabType) ) {
            // mémorise les types
            $nbFields = @pg_num_fields($this->oRes);
            for($i=0; $i<$nbFields; $i++) {
              $this->tabType[$i] = @pg_field_type($this->oRes, $i);
              $this->tabFields[$i] = @pg_field_name($this->oRes, $i);
            }
          }
          
          $tabDr = pg_fetch_array($this->oRes, null, PGSQL_ASSOC);
          if( is_array($tabDr) ) {
            $drRes = new AlkDrPgSql($tabDr, $this);
          }
        }
      } else {
        $drRes = new AlkDrPgSql($this->tabDr[$this->iCurDr], $this);
      }
      $this->moveNext();

      if( $this->bErr == true ) endErrorHandlerPgsql(); else ob_end_clean();
    }
    
    return $drRes;
  }

  /**
   *  Retourne un tableau associatif du datarow correspondant à l'indice courant ($iCurDr) puis passe au suivant
   *  Les clés correspondantes au nom des champs avec la casse Majuscule
   *  Retourne false si EOF est atteint
   *
   * @return array : Retourne un tableau associatif si ok, false sinon
   */
  public function getAssocIter()
  {
    $drRes = false;
    if( $this->iCurDr>=0 && $this->iCurDr<$this->iCountDr ) {
      if( $this->bErr == true ) startErrorHandlerPgsql(); else ob_start();
      
      if( !$this->bFetchAll ) {
        if( $this->bUseInternalCache ) {
          $this->saveDataRow(@pg_fetch_array($this->oRes, null, PGSQL_ASSOC));
          $tabDr = $this->tabDr[$this->iCurDr];
        } else {
          // nécessaire pour utiliser getValueNum()
          if( empty($this->tabType) ) {
            // mémorise les types
            $nbFields = @pg_num_fields($this->oRes);
            for($i=0; $i<$nbFields; $i++) {
              $this->tabType[$i] = @pg_field_type($this->oRes, $i);
              $this->tabFields[$i] = @pg_field_name($this->oRes, $i);
            }
          }
          
          $tabDr = @pg_fetch_array($this->oRes, null, PGSQL_ASSOC);
        }
      } else {
        $tabDr = $this->tabDr[$this->iCurDr];
      }
      
      if( is_array($tabDr) ) {
        $drRes = array_change_key_case($tabDr, CASE_UPPER);
      }
      $this->moveNext();
  
      if( $this->bErr == true ) endErrorHandlerPgsql(); else ob_end_clean();
    }
  
    return $drRes;
  }
  
  /**
   *  Retourne le datarow (dr) positionné à l'indice id
   *        Retourne false si l'indice n'est pas satisfaisant
   *         n'agit ni sur bEOF, ni sur le pointeur 
   *
   * @param id Indice du dataRow
   * @return Retourne un dataRow si ok, false sinon
   */
  public function getRowAt( $id )
  {
    trigger_error("AlkdsPgsql - fonction ".__FUNCTION__." obsolète.", E_USER_ERROR);
    
    /*$drRes = false;      
    if( $this->iCountDr>0 && $id>=0 && $id<$this->iCountDr ){
      $drRes = new AlkDrPgSql($this->tabDr[$id], $this);
    }
    return $drRes;*/
  }

  /**
   *  Place le pointeur du dataset sur le premier datarow
   *        Met à jour l'indice courant du dataset
   */
  public function moveFirst()
  {
    if( $this->iCountDr > 0 ) {
      $this->iCurDr = 0;
      $this->bEof = false;
      if( !$this->bFetchAll && $this->oRes ) {
        @pg_result_seek($this->oRes, 0); 
      }
    } else {
      $this->iCurDr = -1;
      $this->bEof = true;
    }
  }

  /**
   *  Place le pointeur du dataset sur le datarow précédent
   *        Met à jour l'indice courant du dataset
   */
  public function movePrev()
  {
    if( !$this->bFetchAll ) {
      trigger_error("AlkdsPgsql - fonction ".__FUNCTION__." non autorisée en mode FetchItem.", E_USER_ERROR);
    }
    
    if( $this->iCountDr>0 && $this->iCurDr>0 ) {
      $this->iCurDr--;
    } else {
      $this->iCurDr = -1;
      $this->bEof = true;
    }
  }

  /**
   *  Place le pointeur du dataset sur le datarow suivant
   *        Met à jour l'indice courant du dataset
   */
  public function moveNext()
  {
    if( $this->iCountDr>0 && $this->iCurDr<$this->iCountDr ) {
      $this->iCurDr++;
      
      if( $this->iCurDr >= $this->iCountDr ) {
        $this->bEof = true;
      }
    } else {
      $this->iCurDr = -1;
      $this->bEof = true;
    }
  }

  /**
   *  Place le pointeur du dataset sur le dernier datarow
   *        Met à jour l'indice courant du dataset
   */
  public function moveLast( )
  {
    if( !$this->bFetchAll ) {
      trigger_error("AlkdsPgsql - fonction ".__FUNCTION__." non autorisée en mode FetchItem.", E_USER_ERROR);
    }
    
    if ( $this->iCountDr > 0 ) {
      $this->iCurDr = $this->iCountDr-1;
    } else {
      $this->iCurDr = -1;
      $this->bEof = true;
    }
  }

  /**
   *  Place le pointeur du dataset sur le (iCurDr+iNb) ième datarow
   *        Met à jour l'indice courant du dataset
   *
   * @param iNb Décalage positive ou négatif par rapport au dataRow courant
   */
  public function move($iNb)
  {
    if( !$this->bFetchAll ) {
      trigger_error("AlkDsPgsql - fonction ".__FUNCTION__." non autorisée en mode FetchItem.", E_USER_ERROR);
    }
        
    if( $this->iCountDr > 0 && $this->iCurDr+$iNb>=0 && $this->iCurDr+$iNb<$this->iCountDr ) {
      $this->iCurDr += $iNb;
    } else {
      $this->iCurDr = -1;
      $this->bEof = true;
    }
  }
    
  /**
   *  Tri le dataSet après lecture dans la source donnée
   *        Effectue un tri à plusieurs niveaux
   *        Nécessite de connaite les noms de champ : ID et ID_PERE
   *        le dataset doit être déjà trié par niv puis par rang
   *
   * @param strFieldId  Nom du champ ID dans la requeête
   * @param strFieldIdp Nom du champ ID_PERE dans la requête
   */
  public function setTree($strFieldId, $strFieldIdp)
  {
    $tabNoeud = array();   // contient l'ensemble des noeuds
    $tabIndex = array();   // contient l'index inverse id -> cpt
    $stack = array();
    
    if( !$this->bFetchAll ) {
      $this->fetchAll();
    }
    
    for ($i=0; $i< $this->iCountTotDr; $i++) {
      //$drPgsqltmp = pgsql_fetch_array($this->oRes);
      $drPgsqltmp = $this->tabDr[$i];
      
      $idFils = $drPgsqltmp[strtolower($strFieldId)];
      $idPere = $drPgsqltmp[strtolower($strFieldIdp)];
      $tabNoeud[$i]["FILS"] = array();
      $tabNoeud[$i]["ID"] = $idFils;
      $tabNoeud[$i]["OK"] = false;

      // memorize the first level id in a stack
      array_push($stack, $i);

      // met a jour la table index secondaire
      $tabIndex[$idFils] = $i;

      // ajoute l'id fils a l'id pere
      if( $idPere > 0 )
        if( array_key_exists($idPere, $tabIndex) == true ) {
          $iPere = $tabIndex[$idPere];
          array_push($tabNoeud[$iPere]["FILS"], $i);
        }
    }

    // parse the sons
    $tabDr2 = array();
    $j = 0;
    while( count($stack) > 0 ) {
      $i = array_shift($stack);
      if( $tabNoeud[$i]["OK"] == false ) {
        $id = $tabNoeud[$i]["ID"];
        $tabNoeud[$i]["OK"] = true;
        $tabDr2[$j] = $this->tabDr[$i];
        $j++;
        
        $nbFils = count($tabNoeud[$i]["FILS"]);
        for ($k=$nbFils-1; $k>=0; $k--) {
          $if = $tabNoeud[$i]["FILS"][$k];
          array_unshift($stack, $if);
        }
      }
      $i++;
    }

    $tabNoeud = null;
    $tabIndex = null;
    $this->tabDr = $tabDr2;
  }
  
}
?>