<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlpanel.class.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlPanelFilterLink
 * 
 * Classe affichant un panel contenant un titre suivi d'une liste 
 *        de liens permettant de filtrer une liste
 */
class AlkHtmlPanelFilterLink extends AlkHtmlPanel
{
  /** titre de la liste au singulier */
  protected $strTitle;

  /** titre de la liste au pluriel */
  protected $strTitlePlural;

  /** identifiant de l'élément sélectionné */
  protected $idSelect;

  /** tableau contenant les éléments à afficher */
  protected $tabItems;

  /** dataSet contenant les l'id et le texte à afficher */
  protected $oDsItem;

  /** Nom du champ permettant de récupérer l'id de l'élément dans le dataset */
  protected $strFieldId;
  
  /** Nom du champ permettant de récupérer le texte de l'élément dans le dataset */
  protected $strFieldTxt;

  /** url sur le lien de l'item auquel il faudra ajouter l'id au moment de l'affichage */
  protected $strUrlBaseItem;

  /** css sur le titre */
  protected $cssTitle;

  /** css sur le lien d'un élément  et d'un élément sélectionné */
  protected $cssItem;
  protected $cssItemSelect;

  /** css sur un les separateurs */
  protected $cssText;

  /** alignement du panel dans la page : left (par défaut), center, right */
  protected $strAlign;

  /** marge en pixel placé après le panel (=8 par défaut) */
  protected $marginBottom;

  /** texte sur le lien permettant de ne pas appliquer de filtre : vide (filtre obligatoire), tous(par défaut) ou toutes */
  protected $strAll;

	/** indice passée dans l'url correspondant au lien strAll */
  protected $iValueAll;

  /** text affiché lorsque aucun élément n'est présent = Aucun par défaut */
  protected $strNothing;

  /** =true si affichage de strAll avec 1 seul élément dans la liste, =false sinon (par défaut) */
  protected $bViewAll;

  /** caractère séparateur entre éléments de la liste */
  protected $strSeparator;

 

  /**
   *  Constructeur par défaut
   *
   * @param strTitle  Titre de la liste
   * @param idSelect  Identiifant de l'élément sélectionné
   */
  public function __construct($strTitle, $idSelect, $name="")
  {
    parent::__construct($name);
    
    $this->strTitle = $strTitle;
    $this->strTitlePlural = $strTitle;
    $this->idSelect = $idSelect;

    $this->strAll   = _t("Tous");
    $this->iValueAll = "-1";
    $this->bViewAll = false;
    $this->strNothing = _t("Aucun");
    $this->strAlign = "left";
    $this->strSeparator = " | ";
    $this->marginBottom = "8";
    
    $this->tabItems = array();

    $this->oDsItem = null;
    $this->strFieldId = "";
    $this->strFieldTxt = "";
    $this->strUrlBaseItem = "";

    $this->cssTitle       = "formLabel";
    $this->cssItem        = "txtNormal";
    $this->cssItemSelect  = "txtNormal bold";
    $this->cssTxt         = "txtNormal";
  }
  
  /** 
   * Modifieur de l'attribut strTitlePlural
   * @param strTitlePlural   pluriel du titre
   */
  public function setPlural($strTitlePlural)
  {
    $this->strTitlePlural = $strTitlePlural;
  }
  
  /**
   *  Ajoute un élément à la liste
   *
   * @param idItem      Identifiant de l'élément
   * @param strItem     Intitulé de l'élément
   * @param strItemUrl  Url sur l'élément (l'url ne doit contenir l'id, placé &paramId= en fin ou fonction javascript dont parenthèse ")" est remplacée par "idItem)"" )
   */
  public function addItem($idItem, $strItem, $strItemUrl)
  {
    $this->strUrlBaseItem = $strItemUrl;    
    $this->tabItems[count($this->tabItems)] = array("id" => $idItem, "txt" => $strItem, "url"=>$strItemUrl);
  }

  /**
   *  Associe au panel un dataset, le nom des champs permettant de récupérer chaque information
   *        et l'url de base permettant de créer l'url du lien uniquement en y ajoutant l'identifiant
   *        strUrlBase doit se terminer par &param=
   *
   * @param oDs            dataSet contenant les l'id et le texte à afficher
   * @param strFieldId     Nom du champ permettant de récupérer l'id de l'élément dans le dataset
   * @param strFieldTxt    Nom du champ permettant de récupérer le texte de l'élément dans le dataset
   * @param strUrlBaseItem url sur le lien de l'item auquel il faudra ajouter l'id au moment de l'affichage
   */
  public function setDataset(&$oDs, $strFieldId, $strFieldTxt, $strUrlBaseItem)
  {
    $this->oDsItem =& $oDs;
    $this->strFieldId = $strFieldId;
    $this->strFieldTxt = $strFieldTxt;
    $this->strUrlBaseItem = $strUrlBaseItem;    
  }
  
  /**
   *  Retourne l'indice du premier élément de la liste si on est sur la valeur par défaut (ALL)
   *        et que cette valeur n'est pas affichée ; retourne la valeur courante sinon
   * @return int : indice sélectionné
   */
  public function getSelectedId()
  {
    if ( $this->idSelect==$this->iValueAll && $this->strAll=="" ){
      if( $this->oDsItem != null ) {
        $this->oDsItem->moveFirst();
        if( $drItem = $this->oDsItem->getRowIter() ) {
          $this->idSelect  = $drItem->getValueName($this->strFieldId);
        }
      }
      else if ( !empty($this->tabItems) ){
        $this->idSelect  = $this->tabItems[0]["id"];
      }
    }
    return $this->idSelect;
  }
  /**
   *  Retourne le code html du panel
   *
   * @return Retourne un string
   */
  public function getHtml()
  {
    $strHtml = "";

    $nbItem = 0;
    $strItemUrl = $this->strUrlBaseItem;
    $bJsUrl = mb_ereg_match("javascript:", $strItemUrl);
    
    if( $this->oDsItem != null ) {
      // cas du dataset
      $this->oDsItem->moveFirst();
      $nbItem = $this->oDsItem->getCountTotDr();
      while( $drItem = $this->oDsItem->getRowIter() ) {
        $idItem  = $drItem->getValueName($this->strFieldId);
        $strItem = $drItem->getValueName($this->strFieldTxt);
        
        $strUrl = ( $bJsUrl 
                    ? mb_ereg_replace("\)", $idItem.")", $strItemUrl) 
                    : $strItemUrl.$idItem );
        
        $strHtml .= ( $strHtml != "" ? $this->strSeparator : '' ).
          '<a class="'.( $this->idSelect == $idItem ? $this->cssItemSelect : $this->cssItem ).'"'.
          ' href="'.$strUrl.'">'.$strItem.'</a>';
      }
    } else {
      // cas du tableau
      $nbItem = count($this->tabItems);
      foreach($this->tabItems as $tabItem) {
        $idItem  = $tabItem["id"];
        $strItem = $tabItem["txt"];
        $strAnItemUrl = $tabItem["url"];
        
        $bJsUrl = mb_ereg_match("javascript:", $strItemUrl);

        $strUrl = ( $bJsUrl 
                    ? mb_ereg_replace("\)", $idItem.")", $strAnItemUrl) 
                    : $strAnItemUrl.$idItem );
          
        $strHtml .= ( $strHtml != "" ? $this->strSeparator : '' ).
          '<a class="'.( $this->idSelect == $idItem ? $this->cssItemSelect : $this->cssItem ).'"'.
          ' href="'.$strUrl.'">'.$strItem.'</a>';
      }
    }
    
    $bJsUrl = mb_ereg_match("javascript:", $strItemUrl);
    $strUrl = ($bJsUrl ? mb_ereg_replace("\)", $this->iValueAll.")", $strItemUrl) : $strItemUrl.$this->iValueAll);
        
    $strHtml = '<div align="'.$this->strAlign.'"'.
      ' style="margin-bottom:'.$this->marginBottom.'px;"'.
      ( $this->strAlign == "left" ? ' margin-left:10px;' : '' ).
      ( $this->strAlign == "right" ? ' margin-right:10px;' : '' ).
      '">'.
      '<span class="'.$this->cssTitle.'">'.
      ( $nbItem > 1 
        ? $this->strTitlePlural 
        : $this->strTitle).
      ( $this->strTitle!="" 
        ? ' : ' 
        : '' ).
      '</span>'.
      ( $this->strAll != ""
        ? ( ($nbItem == 1 && $this->bViewAll) || $nbItem > 1
            ? '<a class="'.( $this->idSelect == $this->iValueAll ? $this->cssItemSelect : $this->cssItem ).'"'.
              ' href="'.$strUrl.'">'.$this->strAll.'</a>'.$this->strSeparator
            : '' )
        : '' ).
      '<span class="'.$this->cssText.'">'.( $strHtml != "" ? $strHtml : $this->strNothing ).'</span>'.
      '</div>';
    
    return $strHtml;
  }

}
?>