<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmllist.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlblock.class.php");

class AlkHtmlListJQuery extends AlkHtmlList {
  
  /** permet de proposer un filtre sur la liste si le mode est ALK_MODE_JQUERY */
  protected $bFilter;
  
   /** permet de proposer un chargement ajax des données via le serveur*/
  protected $modeAjax;
  
  protected $bHeader = false;
  
  /**
   *  Constructeur par défaut
   * 
   * @param oForm          Formulaire propriétaire de la liste (null accepté)
   * @param iNbElt         Nombre d'élément au total (hors pagination)
   * @param iNumPage       Numéro de page actuel (=1 par défaut)
   * @param iNbEltParPage  Nombre éléments par page (=20 par défaut)
   * @param bPagine        Vrai si résultat paginé, faux sinon (true par défaut)
   * @param strUrlPagine   url de pagination
   * @param strMsgNoResult message affiché lorsqu'une info n'est affichée
   * @param bAllData       vrai= tabData contient toutes les données, faux = tabData ne contient que les données de la page (faux par défaut)
   * @param strName        nom du controle : tabPagine par défaut
   * @param bSelectNbElts  true pour afficher le composant de selection de pagination
   * @param tabValSelect   Tableau contenant les paginations possibles
   */
  public function __construct($oForm, $iNbElt, $bPagine=true, $strUrlPagine="", $strName="tabPagine")
  {
    parent::__construct($oForm, $iNbElt, 1, 20, $bPagine, $strUrlPagine, "", false, $strName, true, array());
    $this->modeAjax = false;
    $this->bFilter  = false;
    
  }
  
  /*$oForm, $iNbElt=0, $iNumPage=1, $iNbEltParPage=ALK_ITEMS_PER_PAGE, $bPagine=true, $strUrlPagine="", 
                              $strMsgNoResult="", $bAllData=false, $strName="tabPagine", $bSelectNbElts=true, $tabValSelect=array() */
  
  /**
   * Ajout un champ de recherche à la liste
   */
  public function setFilter($bFilter) {
    $this->bFilter = $bFilter;
  }
  
  /**
   * Permet de faire fonctionner le chargement de la liste en ajax
   */
  public function setModeAjax($mode){
    $this->modeAjax = $mode;
  }
  
  /**
   *  Regarde si la donnée est un objet de type htmlctrl et l'ajoute à la liste des controles si c'est le cas
   * 
   * @param oData  Donnée à controler 
   */
  private function checkData($oData)
  {
    if ( is_object($oData) && is_subclass_of($oData, self::ALK_CLASS_HTMLCTRL) ){
      $this->addCtrl($oData, ALK_HTMLFORM_NONE);
    }
  }
  
    /**
   *  Cherche le formulaire dans lequel cette liste est inclus ou le construit sinon
   * 
   * @return AlkHtmlForm
   */
  private function checkForm()
  {
    if (!is_null($this->oForm)) return true;
    
    if ( $this->isInHtmlForm() ){
      $oForm = $this->getParent();
      while ( !is_null($oForm) && !is_subclass_of($oForm, self::ALK_CLASS_HTMLFORM) ){
        $oForm = $oForm->getParent();
      }
      $this->oForm = $oForm;
      return true;
    }
    return false;
  }
  
  
  private function getParamsForModeJQuery() {
    $bFirstSortable = false;
    $iCol           = -1;
    $strJs = "jQuery(document).ready( function () {".
              "var testlangage = ".
              "{ ".
             "     'sLengthMenu': 'Afficher _MENU_ lignes par page',".
             "     'sZeroRecords': 'Aucune donnée trouvée',".
             "     'sInfo'       : 'Affiche _START_ à _END_ ligne(s) sur _TOTAL_ ligne(s)',".
             "     'sInfoEmpty'  : 'Affiche 0 à 0 sur 0 ligne',".
             "     'sInfoFiltered': '(filtré de _MAX_ ligne(s))',".
             "     'sEmptyTable'  : '"._t("Aucune donnée trouvée")."',".
             "     'sProcessing'  : '"._t("Chargement...")."',".
             "     'sSearch'      : 'Filtrer sur:',".
             "     'oPaginate': { ".
             "       'sFirst': '<<',".
             "       'sLast' : '>>',".
             "       'sNext' : '>',".
             "       'sPrevious': '<' ".
             "     }};".
             "  jQuery('#".$this->id."').dataTable({".
             "   'bProcessing': ".($this->modeAjax ? "true" : "false").",".
             "   'bServerSide': ".($this->modeAjax ? "true" : "false").",".
             "   'sAjaxSource': ".($this->modeAjax ? "'".$this->strUrlPagine."'" : "null").",".
             "   'oLanguage': testlangage".
             "    ,".
             "  'sPaginationType': 'full_numbers',".
             "  'bPaginate' : ".($this->bPagine ? "true" : "false").",".
             "  'bFilter'   : ".($this->bFilter ? "true" : "false"). ",".
             "  'bDestroy':true ,".
             "  'aoColumns' : [";
    
    
    // colonnes
    for($i=0; $i< $this->iNbCol; $i++) {
      if( count($this->tabRight) == 0 || 
          count($this->tabRight) > 0 && $this->tabRight[$i] > 0 
      ){    
        $bSortable      = (isset($this->tabAlign[$i][3]) ? $this->tabAlign[$i][3] : true);
        $bSearchable    = (isset($this->tabAlign[$i][4]) ? $this->tabAlign[$i][4] : true);
        $strColumName   = (isset($this->tabAlign[$i][2]) ? $this->tabAlign[$i][2] : true);
        $strAlign       = (isset($this->tabAlign[$i][0]) ? $this->tabAlign[$i][0] : "center");
        $strJs.= "{'sName' : '".$strColumName."', 'sAlign' : '".$strAlign."',";
        
        if ($bSortable) {
          if (!$bFirstSortable) {
            $iCol = $i;
            $bFirstSortable = true;
          }
        }
        $strJs.= " 'bSortable' : ".($bSortable? "true" : "false") .", 'bSearchable' : ".($bSearchable? "true" : "false")."}";
         $strJs.=  ",";
      }
    }
    $strJs = trim($strJs,",");
    $strJs.= " ],".
    ($iCol > -1 ? " 'aaSorting'    : [[ ".max(0, $iCol).", 'asc' ]] " : "");
    $strJs.= "});".
            "});";
    
    $this->addJs($strJs);
  }
  
  /**
   *  Retourne les liens de pagination
   */
  protected function _getHtmlPagination($bClose=true)
  {
    return "";
  }
  
   /**
   *  Retourne l'entete du tableau de la page courante
   */
  protected function _getHtmlHeader() {
     $strHeader = "";
     if (!$this->bHeader) {
       $strHeader = parent::_getHtmlHeader();
       $this->bHeader = true;
     }
     return $strHeader;
  }
     /**
   *  Retourne le contenu html du tableau paginé 
   */
  public function getHtml()
  {
    $this->addDefaultCss();
    $this->setContents();
    $this->getParamsForModeJQuery();
    
    $strHtml = "";
    $strHeader = $this->_getHtmlHeader();
    if( $this->iNbCol == 0 ) {
      $strHtml = '<div id="none_'.$this->getGUID().'"' .
        ' class="'.$this->cssText.'"'.
        ' align="center"' .
        ' style="margin-top:30px; margin-bottom:30px">'.
        ( $this->strMsgNoColumn == "" 
          ? _t("Vous n'avez pas les droits nécessaires pour consulter cette liste.") 
          : $this->strMsgNoColumn ).
        '</div>';
    } else {
      if( $this->iNbElt <= 0 ) {
        $strHtml = 
          $strHeader.
          $this->_getHtmlFooter().
          ( !$this->bBlock 
            ? AlkHtmlBlock::getHtml() 
            : '' );
      } else {
        $strHtml = 
          $strHeader.
          ( !$this->modeAjax 
            ? $this->_getHtmlBody()
            : ""
          ).
          $this->_getHtmlFooter().
          ( !$this->bBlock 
            ? AlkHtmlBlock::getHtml() 
            : '');
      }
    }
    return $strHtml;
  } 
}
?>