<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::LsDif
Module liste de diffusion.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkquery.class.php");

/**
 * @package Alkanet_Module_LsDif
 * @class AlkQueryLsDif
 * Ensemble des requetes liées à l'application liste de diffusion
 */
final class AlkQueryLsDif extends AlkQuery
{

  /**
   * @brief Constructeur par défaut
   * @param oDb référence sur la connexion au sgbd
   */ 
  public function __construct(&$oDb) 
  {
    parent::__construct($oDb);   
  }
   
  /**
   * Destructeur par défaut
   */
  public function __destruct() { }
  
  /**
   * Retourne un identifiant unique pour nommer une pièce jointe
   * @return Retourne un string retournant l'id du fichier joint
   */
  public function getStr_pjId()
  {
    $strRes = $this->dbConn->GetNextId("LSDIF_01_PJ", "PJ_ID", "SEQ_LSDIF_01_PJ");
    return $strRes;
  }

  /**
   * liste des messages de la boite des éléments envoyés
   * @param appli_id  Identifiant de l'application
   * @param agent_id  Identifiant de l'agent
   * @param tboite    Type de boite =0 : message reçu, =1 : message envoyé à l'agent ou public
   * @param msg_type  type de message =-1 tous, =0 courriel, =1 newsletter, =2 modèle
   * @param idFirst   indice du premier élément à retourner (pagination)
   * @param idLast    indice du dernier élément à retourner (pagination)
   * @return Retourne un dataSet
   */
  public function getDsListeBoiteMsg($appli_id, $agent_id, $tboite, $msg_type, $idFirst, $idLast)
  {
    if( $tboite == "0" ) {
      // message reçu par l'utilisateur
      $strSql = "select distinct be.*, d.ABONNE_ID, d.DEST_ETAT, af.AGENT_MAIL as msg_mailfrom,".
        $this->dbConn->getConcat("af.AGENT_PRENOM", "' '", "af.AGENT_NOM")." as msg_nomfrom,".
        $this->dbConn->GetDateFormat("DD/MM/YY HH:MI", "be.MSG_DATE", false)." as DATE_ENR, ".
        $this->dbConn->GetDateFormat("DD/MM/YY HH:MI", "be.MSG_DATENV", false)." as DATE_ENV ".
        " from LSDIF_MSG be" .
        "   inner join SIT_AGENT af on af.AGENT_ID=be.MSG_IDFROM".
        "   inner join LSDIF_DEST d on be.MSG_ID=d.MSG_ID".
        "   inner join SIT_ABONNE ab on d.ABONNE_ID=ab.AGENT_ID".
        " where be.APPLI_ID=".$appli_id." and ab.AGENT_ID=".$agent_id.
        "   and d.DEST_VISIBLE=1 and be.MSG_DATENV is not null and d.DEST_ETAT>0".
        ( $msg_type != ""
          ? " and be.MSG_TYPE in (".$msg_type.")"
          : "" ).
        " order by be.MSG_DATE desc";
    } else {
      // messages envoyés publics plus ceux de l'utilisateur
      $strWhere = " and (be.MSG_PUBLIC=1 or (be.MSG_PUBLIC=0 and (be.MSG_IDFROM=".$agent_id." or be.AGENT_ID=".$agent_id.")))";
            
      $strSql = "select be.*, af.AGENT_MAIL as msg_mailfrom,".
        $this->dbConn->getConcat("af.AGENT_PRENOM", "' '", "af.AGENT_NOM")." as msg_nomfrom, ml.LISTE_ID,".
        $this->dbConn->GetDateFormat("DD/MM/YY HH:MI", "be.MSG_DATE", false)." as DATE_ENR, ".
        $this->dbConn->GetDateFormat("DD/MM/YY HH:MI", "be.MSG_DATENV", false)." as DATE_ENV ".
        " from LSDIF_MSG be".
        "   inner join SIT_AGENT af on af.AGENT_ID=be.MSG_IDFROM".
        "   left join LSDIF_MSG_LISTE ml on be.MSG_ID=ml.MSG_ID".
        " where be.APPLI_ID=".$appli_id.$strWhere.
        ( $msg_type != ""
          ? " and be.MSG_TYPE in (".$msg_type.")"
          : "" ).
        " order by be.MSG_DATE desc";
    }

    return $this->dbConn->InitDataSet($strSql, $idFirst, $idLast);
  }

  /**
   * Retourne la liste des modèles publics et ceux de l'agent pour l'appli donnée
   * @param appli_id  Identifiant de l'application
   * @param agent_id  Identifiant de l'agent
   * @param idFirst   indice du premier élément à retourner (pagination)
   * @param idLast    indice du dernier élément à retourner (pagination)
   * @return AlkDs
   */
  public function getDsListeModeleMsg($appli_id, $agent_id, $idFirst=0, $idLast=-1)
  {
    // message reçu par l'utilisateur
    $strSql = "select be.*,".
    $this->dbConn->GetDateFormat("DD/MM/YY HH:MI", "be.MSG_DATE", false)." as DATE_ENR, ".
      $this->dbConn->getConcat("af.AGENT_PRENOM", "' '", "af.AGENT_NOM")." as auteur".
      " from LSDIF_MSG be" .
      "   inner join SIT_AGENT af on af.AGENT_ID=be.AGENT_ID".
      " where be.APPLI_ID=".$appli_id." and be.MSG_TYPE=4" .
      "   and (be.MSG_PUBLIC=1 or be.MSG_PUBLIC=0 and be.AGENT_ID=".$agent_id.")".
      " order by be.MSG_SUJET";

    return $this->dbConn->InitDataSet($strSql, $idFirst, $idLast);
  }

  /**
   * Retourne le source du message msg_id
   * @param msg_id identifiant du message
   * @return string
   */
  public function getStrMsg($msg_id)
  {
    $strMsg = "";
    $strSql = "select MSG_MESSAGE from LSDIF_MSG where MSG_ID=".$msg_id;
    $dsMsg = $this->dbConn->InitDataSet($strSql);
    if( $drMsg = $dsMsg->getRowIter() ) {
      $strMsg = $drMsg->getValueName("MSG_MESSAGE");
      $strMsg = html_entity_decode($strMsg);
    }
    return $strMsg;
  }

  /**
   * Retourne la fiche d'un message de la boite
   * @param msg_id Identifiant de la boite d'envoi
   * @return Retourne un dataSet
   */
  public function getDsFicheMessage($msg_id)
  {
    $strSql = "select be.*, af.AGENT_MAIL as msg_mailfrom, ar.AGENT_MAIL as msg_mailreply, ml.LISTE_ID, mp.PAGE_ID,".
      $this->dbConn->getConcat("ar.AGENT_PRENOM", "' '", "ar.AGENT_NOM")." as msg_nomreply," .
      $this->dbConn->getConcat("af.AGENT_PRENOM", "' '", "af.AGENT_NOM")." as msg_nomfrom,".
      $this->dbConn->GetDateFormat("DD/MM/YY HH:MI", "be.MSG_DATE", false)." as DATE_ENR, ".
      $this->dbConn->GetDateFormat("DD/MM/YY HH:MI", "be.MSG_DATENV", false)." as DATE_ENV ".
      " from LSDIF_MSG be" .
      "   inner join SIT_AGENT af on af.AGENT_ID=be.MSG_IDFROM".
      "   left join SIT_AGENT ar on ar.AGENT_ID=be.MSG_IDREPLY".
      "   left join LSDIF_MSG_LISTE ml on be.MSG_ID=ml.MSG_ID".
      "   left join LSDIF_MSG_PAGE mp on be.MSG_ID=mp.MSG_ID".
      " where be.MSG_ID=".$msg_id;
    return $this->dbConn->InitDataSet($strSql);
  }

  /**
   * Retourne la liste des destinataires après envoi
   * @param msg_id  identifiant du message envoyé
   * @param bOrder   =false par défaut, = true pour ordonner le résultat par ordre alphanuméric nom, prénom
   * @param iReSend  =-1 par défaut pour retourner tous les destinataites
   *                 =0 pour retourner les destinataires qui n'ont pas reçu le message
   *                 =1 pour retourner la liste des destinataires à qui on leur a envoyé le message
   *                 =2 pour retourner la liste des destinataires ayant reçu le message
   *                 =3 =2+1
   * @param agent_id identifiant de l'agent
   * @return AlkDs
   */
  public function getDsListDest($msg_id, $bOrder=false, $iReSend="-1", $agent_id="-1")
  {
    $strSql = "select ab.*, d.DEST_ETAT, " .
      $this->dbConn->getConcat("'AA_'", "ab.ABONNE_ID", "'_'", "ab.AGENT_ID")." as A_ABONNE_ID,".
      $this->dbConn->getConcat("ABONNE_PRENOM", "' '", "ab.ABONNE_NOM")." as ABONNE_PRENOM_NOM".
      " from LSDIF_DEST d" .
      "  inner join SIT_ABONNE ab on ab.ABONNE_ID=d.ABONNE_ID".
      " where MSG_ID=".$msg_id.
      ( $agent_id != "-1" && $agent_id != ALK_USER_ID_INTERNET
        ? " and ab.AGENT_ID=".$agent_id
        : "" ).
      ( $iReSend=="-1"
        ? ""
        : ( $iReSend<3
            ? " and d.DEST_ETAT=".$iReSend 
            : " and d.DEST_ETAT>0")).
      ( $bOrder
        ? " order by ab.ABONNE_NOM, ab.ABONNE_PRENOM"
        : "" );
    return $this->dbConn->InitDataSet($strSql);
  }

  /**
   * Retourne la liste des destinataires avant envoi
   * @param liste_id  identifiant de la liste associée au message
   * @return AlkDs
   */
  public function getDsListDestForCombo($liste_id)
  {
    if( $liste_id == "" ) $liste_id = "-1";
    $strSql = "select ".
      $this->dbConn->getConcat("'L_'", "ll.SLISTE_ID")." as A_ID, ".AlkFactory::getDBCurrentLanguageField("l.LISTE_INTITULE")." as NOM".
      " from SIT_LISTE_SLISTE ll" .
      "   inner join SIT_LISTE l on l.LISTE_ID=ll.SLISTE_ID".
      " where ll.LISTE_ID=".$liste_id.
      " union select ".
      $this->dbConn->getConcat("'AA_'", "ab.ABONNE_ID", "'_'", "ab.AGENT_ID")." as A_ID,".
      $this->dbConn->getConcat("ABONNE_NOM", "' '", "ab.ABONNE_PRENOM")." as NOM".
      " from SIT_ABONNE_LISTE al" .
      "   inner join SIT_ABONNE ab on al.ABONNE_ID=ab.ABONNE_ID".
      " where al.LISTE_ID=".$liste_id.
      " order by NOM";
    return $this->dbConn->InitDataSet($strSql);
  }

  /**
   * Retourne la liste des documents d'un bloc gedit
   * En mode admin, retourne juste le nom de l'appli ou de la catégorie
   * @param bloc_id           identifiant du bloc
   * @param bloc_typeassoc type d'association : 0=aucune, 1=appli, 2=cat, 3=data
   *                       si bit 2 on =4 : filtre publication : news uniquement
   *                       si bit 3 on =8 : filtre publication : infos publiés passés (archivés)
   *                       si bit 4 on =16: filtre publication : infos publiés présents
   *                       si bit 5 on =32: filtre publication : infos non publiés
   *                       bit 6 au bit 12 : anciennes versions de tris prédéfinis 
   *                       si bit 13 on : ordre : champ nouveauté
   *                       si bit 14 on : ordre : champ catégorie
   *                       si bit 15 on : ordre : champ data
   *                       si bit 16 on : ordre : champ date pub décroissant
   *                       si bit 17 on : ordre : champ date pub croissant
   *                       si bit 18 on : ordre : champ date info décroissant
   *                       si bit 19 on : ordre : champ date info croissant
   *                       si bit 20 on : ordre : champ date maj décroissant
   *                       si bit 21 on : ordre : champ date maj croissant
   *                       si bit 22 on : filtre calendaire : date début-fin pub 
   *                       si bit 23 on : filtre calendaire : date début-fin info 
   *                       si bit 24 on : filtre calendaire : date début-fin màj
   *                       si bit 25 on : filtre publication : infos synf 
   *                       si bit 26 on : filtre publication : en cours de validation
   *                       si bit 27 on : filtre publication : 30 derniers jours date pub
   *                       si bit 28 on : filtre publication : 30 derniers jours date info
   *                       si bit 29 on : filtre publication : 30 derniers jours date màj
   *                       si bit 30 on : ordre : champ rang des données décroissant
   *                       si bit 31 on : ordre : champ rang des données croissant
   * @param user_id           identifiant de l'utilisateur connecté
   * @param strAppliTypeAbrev abreviation de l'application contenant l'information
   * @param bAdmin            true si admin, false pour consultation
   * @param strLg          langue sélectionnée, =_FR par défaut
   * @param bloc_ordre     liste de nombres séparés par une virgule. 1 nombre correspond à une puissance de deux. 
   *                       cette liste correspond à l'ordre des champs d'après les champs de bit de bloc_typeassoc
   * @param bloc_datedeb   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc
   * @param bloc_datefin   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc 
   * @return AlkDs
   */
  public function getDsListDataByBlocId($bloc_id, $bloc_typeassoc, $user_id, $strAppliTypeAbrev, 
                                        $bAdmin=false, $strLg=ALK_LG_BDD, $bloc_ordre="", $bloc_datedeb="", $bloc_datefin="", $bloc_limit="-1")
  {
    $strSql = "select df.FORM_DESC".$strLg.", df.FORM_TITRE".$strLg.", d.DATA_ID, d.DATA_TITRE".$strLg.", ".
      " d.DATA_DESCL".$strLg.", d.CONT_ID, d.APPLI_ID,".
      "   LISTE_RANG as DATA_RANG , '' as DATA_URL, '' as DATA_NBPJ".
      " from V_GEDIT_LSDIF_DATA d".
      "   inner join LSDIF_LISTE_BLOC db on d.DATA_ID=db.LISTE_ID".
      "   inner join LSDIF_FORM_BLOC df ON df.BLOC_ID = db.BLOC_ID".
      " where db.BLOC_ID=".$bloc_id." and d.USER_ID=".$user_id." and d.RIGHT_ID>0" .
      " order by DATA_RANG, DATA_TITRE".$strLg;

    return $this->dbConn->initDataset($strSql);
  }
  
  /**
   * Retourne dans un tableau, les msg_id actuellement en file d'attente ou en cours de traitement
   * { msg_id => ["lock" => x, "wait" => y]}
   * @return array
   */
  public function getTabMsgQueue()
  {
    $tabRes = array();
    $strPathQueue = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD."queue/";
    $tabFiles = getTabFilesByDir($strPathQueue, array("queue"), true);
    foreach($tabFiles as $strFileName=>$strPathFileName) {
      $tabMatch = array();
      $nbMatch = preg_match("/(\d*)_mail_(\d*).queue/", $strFileName, $tabMatch);
      $msg_id = ( $nbMatch == 1 
                  ? $tabMatch[2]
                  : "-1" );
      if( $msg_id != "-1" ) {
        if( !isset($tabRes["".$msg_id]) ) {
          $tabRes["".$msg_id] = 1; 
        }
        if( !file_exists($strPathFileName.".lock") ) {
          $tabRes["".$msg_id]++;
        }
      }
    }
    return $tabRes;
  }
  
  /**
   * Retourne les informations liées à l'abonnement à une information
   * @param table_name  nom de la table de l'information
   * @param field_name  nom du champ clé primaire de l'information
   * @param data_id     clé primaire de l'information ou liste d'identifiants séparés par une virgule
   */
  public function getInfoAbonnement($table_name="", $field_name="", $data_id="-1")
  {
    $strSql = "select t.*" .
      ", ".AlkFactory::getDBCurrentLanguageField("l.LISTE_INTITULE")." as LISTE_INTITULE" .
      " from ".strtoupper($table_name)." t" .
      " inner join SIT_LISTE l on l.LISTE_ID=t.LISTE_ID" .
      " where ".strtoupper($field_name)." in (".$data_id.")";
    return $this->dbConn->InitDataSet($strSql);
  }
  
}
?>