<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::LsDif
Module liste de diffusion.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_LsDif
 * @class AlkHtmlPopupLsDifVerifMessage
 * Classe permettant d'afficher une popup demandant la vérification d'un message d'envoi'
 */
class AlkHtmlPopupLsDifVerifMessage extends AlkHtmlForm
{
  protected $maxSend;
  protected $msg_id;
  
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "popupLsDifVerifEnvoiMessage"); 
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
    
    $this->maxSend = ( defined("ALK_MAIL_MAX_SEND")  && ALK_MAIL_MAX_SEND>=10 && ALK_MAIL_MAX_SEND<=200
                       ? ALK_MAIL_MAX_SEND
                       : 200 ); 
  } 
   
   /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { }
  
  /**
   * Traitement du formulaire
   */
  public function doSql()
  {
    $this->setData(ALK_INIT_MODE_REQUEST);
    $this->iMode = AlkRequest::getToken("iMode", "");
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_AVALIDER, ALK_SHEET_NONE); 
    switch( $this->iMode ) {
    case "SendTest": $this->send(true); break;
    case "SendMail": $this->send(); break;
    case "ExportDest": return $this->exportDest(); break;
    case "AddTemplate": 
    case "UpdateTemplate": 
      $msg_id = $this->saveTemplate($this->iMode); 
      if( $this->iMode == "AddTemplate" ) {
        // mise à jour de la liste des templates 
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FORM, ALK_SHEET_NONE, "&iMode=8&msg_id=".$msg_id);
        
        $strHtmlJs = "top.onLoadTemplateList('".$strToken."');" .
          " alkAlert('"._t("Le message courant a été enregistré en tant que nouveau modèle.")."');";
      } else {
        $strHtmlJs = "alkAlert('"._t("Le modèle sélectionné a été enregistré.")."');";
      }
      echo getBodyOnLoadExec($strHtmlJs);
      break; 
    }
    return "";
  } 
   
  /**
   * Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  {
    return _t("Vérification du message à envoyer");
  }
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    list($bCanSend, $msg_group) = $this->save();
    $this->setLabelDesc(_t("Votre message est prêt à être envoyé.")."<br/>".
                        ( !$bCanSend
                          ? ( $msg_group=="0"
                              ? _f("Le nombre de destinataires étant trop important%nll'envoi sera exécuté en différé par une tâche planifiée.", "<br/>") 
                              : _t("Ayant opté pour un envoi personnalisé,l'envoi sera exécuté en différé par une tâche planifiée.") )."<br/>".
                            _t("Vous recevrez un courriel lorsque l'envoi sera effectué.")
                          : "" ));      
    
    $oBlock = $this->addBlock("block1", "", "", 0, 650);
    $strHtml = $this->getHmlMsg();
    $oResult = AlkHtmlFactory::getHtml($strHtml);
    $oBlock->addCtrl($oResult, ALK_HTMLFORM_1L1C);

    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_AVALIDER, ALK_SHEET_NONE, "&iMode=SendTest");
    $oSubmit = $this->addButton("oBtTester","javascript:callAction('".$strToken."', false);", _t("Tester"), _t("Envoyer ce message à l'utilisateur connecté") );
    $this->addSubmitButton($oSubmit);
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_AVALIDER, ALK_SHEET_NONE, "&iMode=SendMail");
    $oSubmit = $this->addButton("oBtEnvoyer","javascript:callAction('".$strToken."', true);", _t("Envoyer"), _t("Envoyer ce message") );
    $this->addSubmitButton($oSubmit);
    $this->addButton("oBtFermer","javascript:closeWindow();", _t("Fermer"), _t("Fermer cette fenêtre") );

    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_LIB."alkhtmlpopuplsdifverifenvoi.js");
  }
  
  /**
   * Enregistre le message avant envoi
   */
  private function save()
  {
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $appli_id = AlkRequest::getToken("appli_id", "0");
    $print = AlkRequest::_GETint("print", "0");
    $queryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
    
    /** Récupération des parametres du formulaire */
    $msg_id     = ( isset($_SESSION["ALK_LSDIF_MSG_ID"]) ? $_SESSION["ALK_LSDIF_MSG_ID"] : "-1" );
    $liste_id   = ( isset($_SESSION["ALK_LSDIF_LISTE_ID"]) ? $_SESSION["ALK_LSDIF_LISTE_ID"] : "-1" );
    $msg_id     = AlkRequest::_POSTint("msg_id", $msg_id);
    $liste_id   = AlkRequest::_POSTint("liste_id", $liste_id);
    $msg_idfrom = AlkRequest::_POSTint("msg_idfrom", "-1");
    $msg_idreply= AlkRequest::_POSTint("msg_idreply", "-1");
    $msg_sujet  = AlkRequest::_POST("msg_sujet", "");
    $msg_message= trim(AlkRequest::_POST("msg_message", ""));
    $msg_public = AlkRequest::_POSTcheck("msg_public");
    $msg_group  = AlkRequest::_POSTint("msg_group", "0");
    $msg_type   = AlkRequest::_POSTint("msg_type", "0");
    $page_id    = AlkRequest::_POSTint("page_id", "-1");
    $langue_id  = AlkRequest::_POSTint("langue_id", "1");
    
    $eventTitle = AlkRequest::_POST("eventTitle", "");
    $eventDesc  = AlkRequest::_POST("eventDesc", "");
    $datedeb    = AlkRequest::_POST("datedeb", "");
    $heuredeb   = AlkRequest::_POST("heuredeb", "");
    $datefin    = AlkRequest::_POST("datefin", "");
    $heurefin   = AlkRequest::_POST("heurefin", "");
    $timerappel = AlkRequest::_POST("timerappel", "");

    $mailListes = AlkRequest::_POST("mailListes", array());
    $nbDest     = count($mailListes);
    $tabDest    = array();
    $iMailSave  = AlkRequest::_POSTcheck("mailEnr");
    $bCanSend   = ( $nbDest < $this->maxSend && $msg_group == "0" ? true : false );
    $iMailSave  = ( !$bCanSend ? 1 : $iMailSave ); 

    // decode du mail Msg : retire les balises <p></p> auparavant
    if( $msg_message != "" ) { 
      $msg_message = mb_ereg_replace("<p>", "", $msg_message);
      $msg_message = mb_ereg_replace("</p>", "", $msg_message);
      if ( defined("ALK_B_LSDIF_EDITOR_LONGDESC") && ALK_B_LSDIF_EDITOR_LONGDESC==true ) {  // décode le message qu'en mode éditeur
        $msg_message = AlkRequest::decodeValue($msg_message);
      }
    }
    
    $strPathUploadLsDif = AlkFactory::getUploadPath(ALK_ATYPE_ID_LSDIF);
    $strDoUploadLsDif   = ALK_ROOT_UPLOAD.AlkFactory::getModuleName(ALK_ATYPE_ID_LSDIF)."/";

    /** Traitement des pieces jointes */
    $tabFileName = array();
    $filesize = 0;
    for($i=0; $i < 3; $i++) {
      $pj_id = $this->oAppli->oQuery->getStr_pjId();
      $strFileName = doUpload("mailFj".chr(65+$i), $pj_id."_", $strDoUploadLsDif); 
      if( $strFileName=="" ) {
        // aucun fichier n'a été uploadé, on reprend l'ancien, on en fait une copie
        $strFileName = AlkRequest::_POST("old_mailFj".chr(65+$i));
      }       
              
      if( is_string($strFileName) && $strFileName!="" ) {
        // ajout des fichiers joints
        $filesize += @filesize($strPathUploadLsDif.$strFileName);
        $tabFileName[$i] = $strFileName;
      } else {
         $tabFileName[$i] = "";
      }
    }
    
    $strAbonneIdInclude = AlkRequest::_POST("strAbonneIdInclude", "");
    $tabAbonneIdInculde = array();
    if ( $strAbonneIdInclude != "" ) {
      $tabAbonneIdInculde = explode("|", $strAbonneIdInclude);
    }
    
    if( $iMailSave == "1" ) {
      $msg_id = $this->oAppli->oQueryAction->saveMsg($msg_id, $appli_id, $msg_idfrom, $msg_idreply, 
                                                     $msg_sujet, $msg_message, $msg_public, $msg_group, 
                                                     $msg_type, $page_id, $langue_id, $tabFileName);
      $dsDest = $this->oAppli->oQueryAction->saveMsgDest($msg_id, $liste_id, $cont_id, $mailListes, 1, -1, $tabAbonneIdInculde);
    } else {
      $dsDest = $this->oAppli->oQueryAction->saveMsgDest($msg_id, $liste_id, $cont_id, $mailListes, 0, -1, $tabAbonneIdInculde);
    }
    while( $drDest = $dsDest->getRowIter() ) {
      $strMailTo = $drDest->getValueName("MAIL");
      $strNomTo  = trim($drDest->getValueName("PRENOM")." ".$drDest->getValueName("NOM"));
      if( $strMailTo != "" ) {
        $tabDest[] = array($strNomTo, $strMailTo, $drDest->getValueName("PRENOM"), $drDest->getValueName("NOM"));
      }
    }
    
    // met à jour le msg_id sur le formulaire principal
    $_SESSION["ALK_LSDIF_MSG_ID"] = $msg_id;
    $_SESSION["ALK_LSDIF_LISTE_ID"] = $liste_id;
    $this->addOnLoad("if ( typeof top.setBEnvId == 'function' ) {top.setBEnvId(".$msg_id.", ".$liste_id.")};");
    
    /** Preparation du mail, enregistré en session */
    
    /** Expediteur : utilisateur courant sinon SIT */
    $strMailFrom = AlkFactory::getSProperty("user_mail", ALK_MAIL_ADMIN_MAIL);
    $strNomFrom = AlkFactory::getSProperty("user_name", ALK_APP_TITLE);
    $dsCoord = $queryAnnu->GetStrDs_ficheAgentMail($msg_idfrom);
    if( $drCoord = $dsCoord->getRowIter() ) {
      $strMailFrom = $drCoord->getValueName("MAIL");
      $strNomFrom = $drCoord->getValueName("PRENOM")." ".$drCoord->getValueName("NOM");
    }
  
    /** Répondre à */
    $strMailReplyTo = "";
    $strNomReplyTo = "";
    $dsCoord = $queryAnnu->GetStrDs_ficheAgentMail($msg_idreply);
    if( $drCoord = $dsCoord->getRowIter() )  {
      $strMailReplyTo = $drCoord->getValueName("MAIL");
      $strNomReplyTo = $drCoord->getValueName("NOM")." ".$drCoord->getValueName("PRENOM");
    }
    
    if( $msg_type == "3" ) {
      $msg_message = $this->oAppli->oQuery->getStrMsg($msg_id);
    }
    
    $_SESSION["ALK_MAIL_DATA"] = array($appli_id, $iMailSave, $msg_public, 
                                       $msg_idfrom, $strNomFrom, $strMailFrom, $strNomReplyTo, $strMailReplyTo,
                                       count($tabDest), $tabDest, $msg_sujet, $msg_message, $tabFileName, 
                                       $msg_group, $bCanSend, $msg_id, $msg_type, $page_id, $langue_id, 
                                       $eventTitle, $eventDesc, $datedeb, $heuredeb, $datefin, $heurefin, $timerappel);
    return array($bCanSend, $msg_group);
  }

  /**
   * Enregistre un modèle de message en ajout ou modif en fonction du mode fourni en paramètre
   * @param iMode    = AddTemplate ou UpdateTemplate correspondant au type d'action à effectuer
   */
  private function saveTemplate($iMode)
  {
    $appli_id = AlkRequest::getToken("appli_id", "0");
    
    /** Récupération des parametres du formulaire */
    $msg_id_src = AlkRequest::_POSTint("msg_id", "-1");
    
    $msg_id = "-1";
    if( $iMode == "UpdateTemplate" ) {
      $msg_id = AlkRequest::_POSTint("msg_template", $msg_id);
      if( $msg_id == "-1" ) {
        // update demandé non possible
        return "-1"; 
      }
    }
    $msg_sujet  = AlkRequest::_POST("msg_sujet", "");
    $msg_message= AlkRequest::_POST("msg_message", "");
    $msg_public = AlkRequest::_POSTcheck("msg_public");
    $msg_group  = AlkRequest::_POSTint("msg_group", "0");
    $msg_type   = AlkRequest::_POSTint("msg_type", "0");

    // decode du mail Msg : retire les balises <p></p> auparavant
    $msg_message = mb_ereg_replace("<p>", "", $msg_message);
    $msg_message = mb_ereg_replace("</p>", "", $msg_message);
    $msg_message = AlkRequest::decodeValue($msg_message);
    
    $strPathUploadLsDif = AlkFactory::getUploadPath(ALK_ATYPE_ID_LSDIF);
    $strDoUploadLsDif   = ALK_ROOT_UPLOAD.AlkFactory::getModuleName(ALK_ATYPE_ID_LSDIF)."/";

    /** Traitement des pieces jointes */
    $tabFileName = array();
    $filesize = 0;
    for($i=0; $i < 3; $i++) {
      $pj_id = $this->oAppli->oQuery->getStr_pjId();
      $strFileName = doUpload("mailFj".chr(65+$i), $pj_id."_", $strDoUploadLsDif); 
      if( $strFileName=="" ) {
        // aucun fichier n'a été uploadé, on reprend l'ancien, on en fait une copie
        $strFileName = AlkRequest::_POST("old_mailFj".chr(65+$i));
      }       
              
      if( is_string($strFileName) && $strFileName!="" ) {
        // ajout des fichiers joints
        $filesize += @filesize($strPathUploadLsDif.$strFileName);
        $tabFileName[$i] = $strFileName;
      } else {
         $tabFileName[$i] = "";
      }
    }
    
    if( $msg_type == "3" ) {
      $msg_message = $this->oAppli->oQuery->getStrMsg($msg_id_src);
    }
        
    return $this->oAppli->oQueryAction->saveTemplate($msg_id, $appli_id, $msg_sujet, 
                                                     $msg_message, $msg_public, $msg_group, $tabFileName);
  }

  /**
   * Retourne le code html d'une ligne du tableau affichant le message envoyé
   * @return string
   */
  private function getTabResHtml($strLabel, $strData)
  {
    return "<tr>" .
      ( $strLabel=="" && $strData!=""
        ? "<td align='left' valign='top' colspan='2'>".$strData."</td>"
        : ( $strLabel!="" && $strData==""
            ? "<td align='left' valign='top' colspan='2'><span class='formLabel'>".$strLabel."&nbsp;</span></td>"
            : "<td width='80' align='right' valign='top'><span class='formLabel'>".$strLabel."&nbsp;</span></td>".
              "<td align='left' valign='top'>".$strData."</td>" )).
      "</tr>";
  }
   
  /**
   * Retourne le code html du message à envoyer
   * @return string
   */
  private function getHmlMsg()
  {
    $strHtml = "";
    if( isset($_SESSION["ALK_MAIL_DATA"]) && 
        is_array($_SESSION["ALK_MAIL_DATA"]) && count($_SESSION["ALK_MAIL_DATA"])==26 ) {
        list($appli_id, $iMailSave, $msg_public, $msg_idfrom, $msg_nomfrom, $msg_mailfrom, 
             $msg_nomreply, $msg_mailreply, $nbDest, $tabDest, $msg_sujet, $msg_message, 
             $tabFileName, $msg_group, $bCanSend, $msg_id, $msg_type, $page_id, $langue_id, 
             $eventTitle, $eventDesc, $datedeb, $heuredeb, $datefin, $heurefin, $timerappel) = $_SESSION["ALK_MAIL_DATA"];
   
      $strHtml = "<table border='0' cellpadding='1' cellspacing='0' width='100%'>";
      
      // expediteur
      $strData = "<a class='aContenuLien' href='mailto:".$msg_mailfrom."'>".$msg_nomfrom."</a>";
      $strHtml .= $this->getTabResHtml(_t("Expéditeur : "), $strData);       
      if( $msg_mailreply != "" ) {
        $strData = "<a class='aContenuLien' href='mailto:".$msg_mailreply."'>".$msg_nomreply."</a>";
        $strHtml .= $this->getTabResHtml(_t("Répondre à : "), $strData);
      }       
      
      // destinataire
      $strEnsDest = "";
      $strGlu = "";
      $iNbDest=0;
      foreach($tabDest as $tabInfo) {
        $strEnsDest .= $strGlu."<a class='aContenuLien' href='mailto:".$tabInfo[1]."'>".$tabInfo[0]."</a>";
        $strGlu = ", ";
        $iNbDest++;
        if( $iNbDest>200 ) break;
      }
      $strTokenExportMail = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_AVALIDER, ALK_SHEET_NONE, "&iMode=ExportDest");
      $strEnsDest = ( $strEnsDest != "" 
                      ? "<div style='border: 1px solid #d8d8d8; overflow:auto; width:100%; height:80px;'>".
                        $strEnsDest.
                        ( $bCanSend
                          ? ""
                          : ( $nbDest > $this->maxSend 
                              ? "...<br/>plus de ".$this->maxSend." destinataires." 
                              : "")).
                        "<br/><br/>>> <a target='_blank' href=\"".ALK_ALKANET_SQL."?token=".$strTokenExportMail."\">"._t("Télécharger la liste des destinataires")."</a>".
                        "</div>" 
                      : "<span class='txtWarning'>"._t("Aucun destinataire.")."</span>" );
      $strHtml .= $this->getTabResHtml(_t("Destinataires : "), $strEnsDest);
      
      // sujet
      $strHtml .= $this->getTabResHtml(_t("Sujet : "), $msg_sujet);
    
      // piece jointe
      $strUrlUploadLsDif  = AlkFactory::getUploadUrl(ALK_ATYPE_ID_LSDIF, false);
      $strData = "";
      if( is_array($tabFileName) ) {
        $strGlu = "";
        for($i=0; $i<count($tabFileName); $i++) {
          if( $tabFileName[$i] != "" ) {
            $strData .= $strGlu."<a target='_blank' href=\"".$strUrlUploadLsDif.$tabFileName[$i]."\">".$tabFileName[$i]."</a>";
            $strGlu = ", ";
          }
        }
      }       
      if( $strData != "" ) {
        $strHtml .= $this->getTabResHtml("Pi&egrave;ce jointe : ", $strData);
      }
  
      // message
      if( $msg_type == "3" ) {
        $strHtml .= $this->getTabResHtml("", "<iframe style='border: 1px solid #d8d8d8; overflow:auto; width:100%; height:230px;' src='".$strUrlUploadLsDif."lettre_".$msg_id.".htm'></iframe>");
      } else {
        $strHtml .= $this->getTabResHtml("", "<div style='border: 1px solid #d8d8d8; overflow:auto; width:100%; height:230px;'>".$msg_message."</div>");
      }
      
      $strHtml .= "</table></div><br>";
    }    
    return $strHtml;    
  }

  /**
   * Exportation sur la sortie standard des destinataires :
   * par ligne : NOM;PRENOM;COURRIEL
   * Retourne l'url du fichier généré pour s'y rediriger 
   * @return string
   */
  private function exportDest()
  {
    if( isset($_SESSION["ALK_MAIL_DATA"]) && 
        is_array($_SESSION["ALK_MAIL_DATA"]) && count($_SESSION["ALK_MAIL_DATA"])==26 ) {
      
      $msg_id = $_SESSION["ALK_MAIL_DATA"][15];
      $tabDest = $_SESSION["ALK_MAIL_DATA"][9];

      $fileName = "destinataires_".$msg_id.".csv";

      $strPathFileName = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD."cache/".$fileName;
      $hf = fopen($strPathFileName, "w");
      if( $hf ) {  
        $strRC = "\r\n";
        $strSep = ";";
        fwrite($hf, "NOM".$strSep."PRENOM".$strSep."COURRIEL".$strRC);
        $strTmp = "";
        $iSize = pow(2, 16);
        foreach( $tabDest as $tabInfo ) {
          $strTmp .= $tabInfo[3].$strSep.
            $tabInfo[2].$strSep.
            $tabInfo[1].$strRC;
  
          if( strlen($strTmp) > $iSize ) {
            fwrite($hf, $strTmp);
            $strTmp = "";
          }
        }
        if( $strTmp != "" ) {
          fwrite($hf, $strTmp);
        }
        fclose($hf);
        
        return ALK_ALKANET_ROOT_URL.ALK_ROOT_UPLOAD."cache/".$fileName;
      }
    }
    return "";
  }

  /**
   * Envoi le message définitivement
   *        puis affiche une alerte en js donnant le statut de l'action effectuée
   * @param bTest =false par défaut pour envoyer à tous les destinataires, 
   *              =true pour n'envoyer qu'à l'utilisateur connecté
   */
  private function send($bTest=false)
  {
    ini_set("memory_limit", "128M");
    set_time_limit(60*15); // 15mn
             
    $res = 0;
    $bInit = false;
    if( isset($_SESSION["ALK_MAIL_DATA"]) && 
        is_array($_SESSION["ALK_MAIL_DATA"]) && count($_SESSION["ALK_MAIL_DATA"])==26 ) {
      $bInit = true;
      list($appli_id, $iMailSave, $msg_public, $msg_idfrom, $msg_nomfrom, $msg_mailfrom, 
           $msg_nomreply, $msg_mailreply, $nbDest, $tabDest, $msg_sujet, $msg_message, 
           $tabFileName, $msg_group, $bCanSend, $msg_id, $msg_type, $page_id, $langue_id,
           $eventTitle, $eventDesc, $datedeb, $heuredeb, $datefin, $heurefin, $timerappel) = $_SESSION["ALK_MAIL_DATA"];
    }
    
    if( !$bInit ) {
      $msg_id = AlkRequest::getToken("msg_id", "-1");
      $dsBEnv = $this->oAppli->oQuery->getDsFicheMessage($msg_id);
      if( $drBEnv = $dsBEnv->getRowIter() ) {
        $bInit = true;
        $iMailSave = 1;
        $appli_id       = $drBEnv->getValueName("APPLI_ID");
        $msg_public    = $drBEnv->getValueName("MSG_PUBLIC");
        $msg_idfrom    = $drBEnv->getValueName("MSG_IDFROM");
        $msg_nomfrom   = $drBEnv->getValueName("MSG_NOMFROM");
        $msg_mailfrom  = $drBEnv->getValueName("MSG_MAILFROM");
        $msg_nomreply  = $drBEnv->getValueName("MSG_NOMREPLY");
        $msg_mailreply = $drBEnv->getValueName("MSG_MAILREPLY");
        $msg_sujet     = $drBEnv->getValueName("MSG_SUJET");
        $msg_message   = $drBEnv->getValueName("MSG_MESSAGE"); 
        $msg_pj        = $drBEnv->getValueName("MSG_PJ");
        $msg_group     = $drBEnv->getValueName("MSG_GROUP");
        $msg_type      = $drBEnv->getValueName("MSG_TYPE");
        $bCanSend = false;
        $nbDest = 0; 
        $tabDest = array();
        $tabFileName = explode("|", $msg_pj);
      } 
    }

    if( $bInit ) {
      $oAlkMail = AlkFactory::getMail();
      $oAlkMail->setSubject($msg_sujet);
      $oAlkMail->setHtml(true);
      $oAlkMail->setMaxSend($this->maxSend);
  
      $oAlkMail->setBody($msg_message);
      $msg_txt = str_replace("<br>", "<br/>", $msg_message);
      $msg_txt = str_replace("</p>", "<br/>", $msg_txt);
      $msg_txt = str_replace("<br/>", "\n", $msg_txt);
      $msg_txt = strip_tags($msg_txt);
      $msg_txt = html_entity_decode($msg_txt, ENT_COMPAT, ALK_MAIL_ENCODING);
      $oAlkMail->setAltBody($msg_txt);
  
      $oAlkMail->setProperty("bDebugMode", ALK_DEBUG_MAIL); //ALK_MODE_DEBUG;
  
      $oAlkMail->setFrom($msg_nomfrom, $msg_mailfrom, false);
        
      if( $msg_mailreply != "" ) {
        $oAlkMail->addReplyTo($msg_nomreply, $msg_mailreply);
      } else {
        $oAlkMail->addReplyTo(ALK_MAIL_NOREPLY_NAME, ALK_MAIL_NOREPLY_MAIL);
      }
      
      // place l'expéditeur en copie cachée
      $oAlkMail->addCCi($msg_nomfrom, $msg_mailfrom);

      if( !$bTest ) {
        if( $bCanSend ) {
          foreach($tabDest as $tabD) {
            $oAlkMail->addCCi($tabD[0], $tabD[1]);
          }
        } else {
          $dsAb = $this->oAppli->oQuery->getDsListDest($msg_id, false, 0);
          while( $drAb = $dsAb->getRowIter() ) {
            $user_name = trim($drAb->getValueName("ABONNE_PRENOM")." ".$drAb->getValueName("ABONNE_PRENOM"));
            $user_mail = $drAb->getValueName("ABONNE_MAIL");
            $oAlkMail->addTo($user_name, $user_mail, ($msg_group =="1" ? array("[#PRENOM_NOM#]" => $user_name) : array())); 
          }
        }
      } else {
        $user_name = AlkFactory::getSProperty("user_name", "");
        $user_mail = AlkFactory::getSProperty("user_mail", "");
        $oAlkMail->addTo($user_name, $user_mail, ($msg_group =="1" ? array("[#PRENOM_NOM#]" => $user_name) : array()));
      }   
      
      $strPathUploadLsDif = AlkFactory::getUploadPath(ALK_ATYPE_ID_LSDIF); 
      foreach($tabFileName as $strFileName) {
        if( $strFileName != "" && file_exists($strPathUploadLsDif.$strFileName) ) {
          $oAlkMail->addFile($strPathUploadLsDif.$strFileName, $strFileName);
        }
      }
      
      // ajout événement ICS
      if ( $datedeb != "" && $heuredeb != "" && $datefin != "" &&  $heurefin != "" ) {
        $tabParamsEvent = array("objet" => $eventTitle, "event_desc" => $eventDesc, "datedeb" => $datedeb, "heuredeb" => $heuredeb, "datefin" => $datefin, "heurefin" => $heurefin);
        if ( $timerappel != "" ) {
          $tabParamsEvent["alarm_desc"] = $eventTitle."\n".$eventDesc;
          $tabParamsEvent["alarm_time"] = $timerappel;
        }
        $oAlkMail->addEventToIcs($tabParamsEvent);
      }
      
      if( $msg_group=="0" || $bTest ) {
        $res = $oAlkMail->send($msg_id, true);
      } else {
        $res = $oAlkMail->sendMailToQueue($msg_id, true);
        if( $res > 0 ) $res = -$res-10; 
      }
    }

    $strMsg = "";
    switch( $res ) {
    case 0  : 
      $strMsg = _t("Votre message n'a pas été envoyé."); 
      break;
      
    case -1 : 
      $strMsg = _f("Votre message n'a pas été envoyé :%nlaucun destinataire n'a été trouvé.", "\n");
      break;

    case -2 : 
      $strMsg = _f("Votre message n'a pas été envoyé :%nlproblème lié à la construction du message.", "\n");
      break;

    case -3 : 
      $strMsg = _f("Votre message contient trop de destinataires pour être envoyé directement.%nlIl n'a pas été possible de le placer dans la file d'attente.", "\n"); 
      break;

    default : 
      if( $res < -10 ) {
        $strMsg = 
          ( $msg_group=="0" 
            ? _f("Votre message contient trop de destinataires pour être envoyé directement.%nlIl a été placé avec succès en attente de traitement.%nlVous serez informé par messagerie lorsque l'envoi sera achevé.", "\n", "\n")
            : _f("Ayant opté pour un envoi personnalisé,%nlvotre message a été placé avec succès en attente de traitement.%nlVous serez informé par messagerie lorsque l'envoi sera achevé.", "\n", "\n")
          );
      } else {
        $strMsg = _nf("Votre message a été envoyé à %d destinataire.", "Votre message a été envoyé à %d destinataires.", $res);
      } 
      break;
    }
    
    // Enregistrement dans la boite d'envoi
    if( $iMailSave == "1" && ( $res > 0 || $res < -10 )) {
      $this->oAppli->oQueryAction->saveMsgSent($msg_id, ($res>0 ? true : false));
    }
    $strMsg = addslashes($strMsg);
    $strMsg = str_replace("\n", "\\n", $strMsg);
    echo getBodyOnLoadExec("alkAlert('".$strMsg."');");    
  }

}
?>